#!/usr/local/biotools/perl/5.14.2/bin/perl

use strict;
use warnings;

#check for presence of all i/p and o/p files
 if (scalar(@ARGV) != 3)	
 {
 die ( "Usage:\nFillLocusInfo.pl <Loci.Transcripts> <KnownAnnot.tmp> <Ouput file>\n" )
 }

my %hash1=();
my %hash2=();

open (FIRST,"$ARGV[0]");
while(my $line = <FIRST>)	
{
	chomp $line;
	my @array = split(' ',$line);
	my $uniq = $array[1];
	$hash1{$uniq} = $array[0];
}
close FIRST;

open (SECOND,"$ARGV[1]");
while(my $line = <SECOND>)	
{
	chomp $line;
	my @array = split('\t',$line);
	my $uniq = $array[3];
	$hash2{$uniq} = join ("\t",@array);
}
close SECOND;

open (OUT, ">$ARGV[2]");

foreach my $find (sort keys %hash2)
{
	if(defined $hash1{$find})
	{
		print OUT "$hash2{$find}\t$hash1{$find}\n";
	}
}
close OUT;
