#!/usr/local/biotools/perl/5.14.2/bin/perl

use strict;
use warnings;

#check for presence of all i/p and o/p files
 if (scalar(@ARGV) != 3)	
 {
 die ( "Usage:\nFillGeneInfo.pl <File1 with lincRNAs> <File2 with Gene info> <Ouput file>\n" );
 }

my %hash1=();
my %hash2=();

open (FIRST,"$ARGV[0]");
while(my $line = <FIRST>)	
{
	chomp $line;
	my @array = split('\t',$line);
	my $uniq = $line;
	$hash1{$uniq} = $line;
}
close FIRST;

open (SECOND,"$ARGV[1]");
while(my $line = <SECOND>)	
{
	chomp $line;
	my @array = split(':',$line);
	my $uniq = $array[0];
	$hash2{$uniq} = join ("\t",$array[1]);
}
close SECOND;

open (OUT, ">$ARGV[2]");

foreach my $find (keys %hash1)
{
	if(defined $hash2{$find})
	{
		print OUT "$hash1{$find}\t$hash2{$find}\n";
	}
	else	
	{
		print OUT "$hash1{$find}\t-\n";
	
	}
}	

 close OUT;
