#!/usr/local/biotools/perl/5.14.2/bin/perl

=head1 NAME
   createIGVSessionXML.pl

=head1 SYNOPSIS
    USAGE: createIGVSesionXML.pl -o=output_file

=head1 OPTIONS

B<--input, -i>
	Required. Complete path of file lincRNA candidate bed file.

B<--output_file, -o>
	Required. Complete output file name to store IGV Session info

B<--help,-h>


=head1  DESCRIPTION
	Generate IGV Session file

=head1  INPUT

=head1  OUTPUT


=head1  CONTACT
  bjaysheel@gmail.com


==head1 EXAMPLE
	./createIGVSessionXML.pl -o=output_file

=cut

use lib "/data2/bsi/reference/perl_workflow_ref/lib";
use lib "/data2/bsi/reference/perl_workflow_ref/lib/perl5/x86_64-linux/auto";
use strict;
use warnings;
use Data::Dumper;
use Pod::Usage;
use Getopt::Long qw(:config no_ignore_case no_auto_abbrev pass_through);
use ParseConfig;
use Workflow::Logger;

my %options = ();
my $results = GetOptions (\%options,
						  'input|i=s',
                          'output_file|o=s',
						  'run_info|r=s',
						  'log|l=s',
			              'debug=s',
						  'help|h') || pod2usage();

## display documentation
if( $options{'help'} ){
    pod2usage( {-exitval => 0, -verbose => 2, -output => \*STDERR} );
}

#############################################################################
#### make sure everything passed was peachy
&check_parameters(\%options);

#### parse X_info files
my $config = new ParseConfig($options{run_info});

my $logger = new Workflow::Logger('LOG_FILE'=>"$config->{RunInfo}->{logs}/CreateIGVSession.log",
								  'LOG_LEVEL'=>$options{'debug'});
$logger = Workflow::Logger::get_logger();

$logger->info("Generate IGV session started");

my $cmd = "";
my $this = {};

my $xml = <<EOS;
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<Session genome="hg19" locus="All" version="4">
	<Resources>
		<Resource name="lincRNA candidates" path="\@\@ALL_LINCRNA_BED\@\@"/>
		<Resource name="MIT lincRNA transcripts" path="\@\@MIT_LINCRNA_BED\@\@"/>
		<Resource name="Genecode lincRNA" path="\@\@GENECODE_LINCRNA\@\@"/>
		<Resource name="All K4 Chromatin" path="\@\@ALL_K4_CHROMATIN\@\@"/>
		<Resource name="All K36 Chromatin" path="\@\@ALL_K36_CHROMATIN\@\@"/>
	</Resources>
</Session>
EOS


$xml =~ s/\@\@ALL_LINCRNA_BED\@\@/$options{input}/;
$xml =~ s/\@\@MIT_LINCRNA_BED\@\@/$config->{ToolInfo}->{mit_transcripts}->{value}/;
$xml =~ s/\@\@GENECODE_LINCRNA\@\@/$config->{ToolInfo}->{gencode_bed}->{value}/;
$xml =~ s/\@\@ALL_K4_CHROMATIN\@\@/$config->{ToolInfo}->{k4_chromatin}->{value}/;
$xml =~ s/\@\@ALL_K36_CHROMATIN\@\@/$config->{ToolInfo}->{k36_chromatin}->{value}/;

open(OUT, ">", $options{output_file}) or die "Could not open output file $options{output_file}\n";
print OUT $xml;
close(OUT);


$logger->info("Generate IGV session complete");
exit();

#############################################################################
sub check_parameters {
    my $options = shift;

	my @required = qw(output_file run_info input);

	foreach my $key (@required) {
		unless ($options{$key}) {
			print STDERR "ARG: $key is required\n";
			pod2usage({-exitval => 2,  -message => "error message", -verbose => 1, -output => \*STDERR});
			exit(-1);
		}
	}

	$options{'debug'} = 3 unless ($options{'debug'});
}

#############################################################################
sub execute_cmd {
	my $cmd = shift;

	$logger->info($cmd);
	system($cmd);

	while (( $? >> 8 ) != 0 ){
		$logger->logdie("ERROR: Following command failed to execute. Exiting execution of workflow\n$cmd");
		exit(100);
	}
}
