#!/usr/local/biotools/perl/5.14.2/bin/perl

## Perl script to comare two files (columns joined by '_') to find uncommon rows

use strict;
use warnings;

if (scalar(@ARGV) != 3)	
{
	die ( "Usage:\nFormatCPATOutput.pl <File1.txt to compare> <File2.txt to compare> <Ouput file with common results>\n" );
}

my %hash1=();
my %hash2=();

#Form a unique key with identifiers (column 1) from cpat
open (FIRST,"$ARGV[0]");
while(my $line = <FIRST>)	
{
	next if ($line =~ m/#/);
	chomp $line;
	my @array = split('\t',$line);
	 my $uniq = $array[0];
	$hash1{$uniq} = $line;
}
close FIRST;

#Form a unique key with identifiers (column 4) 
open (SECOND,"$ARGV[1]");
while(my $line = <SECOND>)	
{
	next if ($line =~ m/#/);
	chomp $line;
	my @array = split('\t',$line);
	my $uniq = $array[3];
	$hash2{$uniq} = join ("\t",@array);
}
close SECOND;

#Loop over unique key from %hash1 and compare with %hash2; print the result to OUT
open (OUT, ">$ARGV[2]");
# open (OUT2, ">$ARGV[3]");
foreach my $find (sort keys %hash1)
{
	if(defined $hash2{$find})
	{
		print OUT "$hash2{$find}\n";
	}
	# else
	# {
		# print OUT2 "$hash1{$find}\n";
	# }
}	
close OUT;
# close OUT2;



