package SampleInfo;

use strict;
use warnings;
use Data::Dumper;

sub new {
    my ($class, %opts) = @_;
    my $self = {};

 	bless($self,$class);
	$self->init(\%opts);

	return $self;
}

sub init {
	my ($self, $options) = @_;

	my @samples = split(/:/, $options->{samplenames});
	my @lane = split(/:/, $options->{laneindex});
	my @lab = split(/:/, $options->{labindexes});

	for (my $i=0; $i<scalar(@samples); $i++){
		my $sample_info = `grep '^$samples[$i]=' $options->{sample_info}`;
		chomp $sample_info;

		## get all sample file names for given sample
		## could be multiple if sample was run in multiple times
		my @groups = split(/\n/, $sample_info);

		foreach my $group (@groups) {
			my $obj = {};

			## get reads for each group.
			my @reads = split(/\t/, $group);

			## trim any space
			$reads[0] =	$self->trim($reads[0]);

			## change NAME=READ1 into READ1
			$reads[0] =~ s/.*=//;

			## if paired end reads.
			$reads[1] =	$self->trim($reads[1]) if (scalar(@reads) == 2);

			## check if its gz file.
			if ($reads[0] =~ /\.gz$/) {
				$obj->{'type'} = "gz";
			} else { $obj->{'type'} = ""; }

			## check if file is bam or fastq format
			if ($reads[0] =~ /\.bam/) {
				$obj->{'format'} = "bam";
			} else { $obj->{'format'} = "fastq"; }

			$obj->{'read1'} = $reads[0];
			$obj->{'read2'} = $reads[1] if (scalar(@reads) == 2);
			$obj->{'filepath'} = $options->{'input_dir'};
			$obj->{'laneindex'} = $lane[$i];
			$obj->{'labindex'} = $lab[$i];

			push @{$self->{$samples[$i]}}, $obj;
		}
	}
}

sub export {
	my ($self, $file) = @_;

	foreach my $key (keys %{$self}) {
		write_to_file($self->{$key}, $key, $file);
	}
}

sub export_sample {
	my ($self, $file, $sample) = @_;

	open (OUT, ">", $file) or die "Could not open file $file\n";
	print OUT $sample ."=". $self->{$sample}[0]->{read1} ."\t". $self->{$sample}[0]->{read2} ."\n";
	close(OUT);

}

sub write_to_file {
	my $arr = shift;
	my $sample = shift;
	my $file = shift;

	open (OUT, ">>", $file) or die "Could not open file $file\n";

	foreach my $s (@{$arr}){
		print OUT $sample ."=". $s->{read1} ."\t". $s->{read2} ."\n";
	}

	close(OUT);
}

sub trim {
	my ($self, $str) = @_;

	$str =~ s/^\s+//;
	$str =~ s/\s+$//;

	$str;
}

1;
