package ParseConfig;

use strict;
use warnings;
use Data::Dumper;
use RunInfo;
use SampleInfo;
use ToolInfo;
use MemoryInfo;

my $OPTIONS = {
		'RunInfo' => {
			"aligner" => { 'required' => 0, 'default' => "none" },
			"base_output_dir" => { 'required' => 1 },
			"email" => { 'required' => 0, 'default' => "" },
			"output_folder" => { 'required' => 1 },
			"input_dir" => { 'required' => 1 },
			"pi" => { 'required' => 1 },
			"tool" => { 'required' => 1 },
			"tool_info" => { 'required' => 1 },
			"type" => { 'required' => 1 },
			"version" => { 'required' => 1 },
			"analysis" => { 'required' => 0, 'default' => "all" },
			"chrindex" => { 'required' => 0, 'default' => "1:2:3:4:5:6:7:8:9:10:11:12:13:14:15:16:17:18:19:20:21:22:X:Y:M" },
			"center" => { 'required' => 0, 'default' => "Mayo" },
			"disease" => { 'required' => 0, 'default' => "" },
			"date" => { 'required' => 0, 'default' => date() },
			"delivery_folder" => { 'required' => 0, 'default' => "NA" },
			"fastqc" => { 'required' => 0, 'default' => "yes" },
			"folder_fastqc" => { 'required' => 0, 'default' => "NA" },
			"genomebuild" => { 'required' => 0, 'default' => "hg19" },
			"labindexes" => { 'required' => 0, 'default' => "" },
			"laneindex" => { 'required' => 0, 'default' => "" },
			"paired" => { 'required' => 0, 'default' => 1},
			"platform" => { 'required' => 0, 'default' => 'illumina' },
			"readlength" => { 'required' => 0, 'default' => 1},
			"sampleinformation" => { 'required' => 0, 'default' => "" },
			"samplenames" => { 'required' => 1 },
			"sample_info" => { 'required' => 1 },
			"unique_id" => {'required' => 0, 'default' => "0000"},
			"group_id" => {'required' => 0, 'default' => "0000"}
		},
		'SampleInfo' => {
			"samplenames" => { 'required' => 1 },
			"sample_info" => { 'required' => 1 },
			"input_dir" => { 'required' => 1},
			"laneindex" => { 'required' => 1 },
			"labindexes" => { 'required' => 1 }
  		},
		'ToolInfo' => {
			"queue" => { 'required' => 1 },
			"insert_size" => { 'required' => 0, 'default' => '50' },
			"mate_sd" => { 'required' => 0, 'default' => '20' },
			"fusion_min_dist" => { 'required' => 0, 'default' => 50000},
		},
		'MemoryInfo' => {
		}
};

sub new {
    my ($class, $file) = @_;
    my $self = {};

 	bless($self,$class);
	$self->init($file);

	return $self;
}

sub init {
	my ($self, $file) = @_;
        #print "file = $file\n";
	#### convert run_info file into hash
	my %opts = $self->file2object($file);

	my %defaults;
	my $missing = 0;
	my $obj_string = "RunInfo";

	$self->{RunInfo} = $self->createObject("RunInfo", \%opts);

	#### create standard log dir.
	$self->{RunInfo}->{'logs'} = "$self->{RunInfo}->{base_output_dir}/$self->{RunInfo}->{pi}/$self->{RunInfo}->{type}/$self->{RunInfo}->{output_folder}/logs";

	#### check for email.
	if ((! defined $self->{RunInfo}->{email}) || (! length($self->{RunInfo}->{email}))){
		$self->add_user_email();
	}

	%defaults = ();
	$defaults{'samplenames'} = $self->{RunInfo}->{'samplenames'};
	$defaults{'sample_info'} = $self->{RunInfo}->{'sample_info'};
	$defaults{'input_dir'} = $self->{RunInfo}->{'input_dir'};
	$defaults{'laneindex'} = $self->{RunInfo}->{'laneindex'};
	$defaults{'labindexes'} = $self->{RunInfo}->{'labindexes'};

	$self->{SampleInfo} = $self->createObject("SampleInfo", \%defaults);

	## convert tool_info file into hash
	%opts = ();
	%opts = $self->file2object($self->{RunInfo}->{tool_info});
	$self->{ToolInfo} = $self->createObject("ToolInfo", \%opts);


	if (defined $self->{RunInfo}->{memory_info}) {
		## convert tool_info file into hash
		%opts = ();
		%opts = $self->file2object($self->{RunInfo}->{memory_info});
		$self->{MemoryInfo} = $self->createObject("MemoryInfo", \%opts);
	}
}

sub createObject {
	my ($self, $obj_string, $opts) = @_;

	my $missing = 0;
	my %defaults;

	foreach my $opt( keys %{$OPTIONS->{$obj_string}} ) {
		if( $OPTIONS->{$obj_string}->{$opt}->{'required'}
		   && !exists( $opts->{$opt} ) ) {
			%defaults = ();
			$missing = 1;
			print STDERR "Required key: $opt is missing\n";
			last;
		}

		$defaults{$opt} = $OPTIONS->{$obj_string}->{$opt}->{'default'} unless( $OPTIONS->{$obj_string}->{$opt}->{'required'} );
	}

	die("Could not determine object type from parameters passed: $obj_string") if( $missing );
	map { $defaults{$_} = $opts->{$_} } keys %$opts;

	my @obj_opts;
	map { push(@obj_opts, "$_ => '$defaults{$_}'") } keys %defaults;

	my $eval_string = "\$obj = new $obj_string( ".join(", ", @obj_opts)." )";
	my $obj;
	eval($eval_string);
	die("Could not create object type: $obj_string [$@]\n") unless( defined( $obj ) );

	return $obj;
}

sub file2object {
	my ($self, $file) = @_;

	my %opts;
	open(FHD, "<", $file) or die "Could not open file to read $file\n";

	## file should be of format
	## key=value
	## any comments line start with #
	while (<FHD>) {
		chomp $_;
		next if ($_ =~ /^#/);
		next if (!length($_));

		my ($key, $value) = split(/\s*=\s*/);
		$key = lc(trim($key));

		### special value in info file here ~ is suppose to be = for values.
		$value =~ s/~/=/g;

		$opts{$key} = trim($value);
	}

	return %opts;
}

#### get current username running this script and add their username to runinfo.
sub add_user_email {
	my ($self) = @_;

	my $username = (getpwuid($<))[0];

	$self->{RunInfo}->{email} = $username;
}

sub date {
	my @months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
    my @weekDays = qw(Sun Mon Tue Wed Thu Fri Sat Sun);
    my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = localtime();
    my $year = 1900 + $yearOffset;

	return $month."/".$dayOfMonth."/".$year;
}

sub trim {
	my $string = shift;

	$string =~ s/^\s+//;
	$string =~ s/\s+$//;

	return $string;
}

1;
