package Tools::Verify::Rscript;

@ISA = qw(Tools::Verify); 

use Tools::Verify ; 
use strict ; 
use warnings ; 


sub init {
	my $self = shift ; 

	$self->{name} = 'Rscript'; 
	$self->{filename} = 'Rscript'; 
	$self->{executable} = TRUE ; 
	$self->{min_version} = "2.14.1"; 
} 

sub getDescription { return "Rscript "; }

sub getConfigLabel { return "R"; }

sub getConfigType { return "dir"; }

sub getSource { return "http://cran.rstudio.com"; }

sub getVersion { 
	my $self = shift ; 

	my $filename = $self->getPath(); 

	my $command = "$filename --version";
	my $output = $self->execute($command);

	my $version = undef ; 

	my @lines = split(/\n/, $output); 

	foreach my $thisLine (@lines) { 
		chomp($thisLine); 
		if($thisLine =~ /Version/){ 
			$version = $thisLine; 
			$version =~ s/version (\d+.\d+.\d+)$/$1/;
		}
	}

	return $version ; 
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
