package Tools::Verify::CPATLib;

@ISA = qw(Tools::Verify); 

use Tools::Verify ; 
use strict ; 
use warnings ; 

use File::Basename;

sub init {
	my $self = shift ; 

	$self->{name} = 'CPAT Lib'; 
	$self->{directory} = 'site-packages'; 
	$self->{executable} = FALSE ; 
	@{$self->{run_dependencies}} = qw/Python/;
} 

sub getDescription { return "CPAT Python Lib "; }

sub getConfigLabel { return "PYTHON_CPAT"; }

sub getConfigType { return "dir"; }

sub getSource { return "http://cpat.googlecode.com/files/CPAT-1.2.1.tar.gz"; }

sub functionTest { 
	my $self = shift ; 

	my $path = $self->getPath(); 
	if(-f $path){ $path = dirname($path); } 

	my $dir = $path . "/CPAT-1.2.1-py2.7-linux-x86_64.egg"; 
	my $file = $dir . "/csamtools.so"; 

	if(!-d $dir){ return "CPAT lib missing directory \"$dir\""; }

	if(!-f $file){ return "CPAT lib missing file \"file\""; }

	return TRUE ; 
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
