package Tools::Verify::CPAT;

@ISA = qw(Tools::Verify); 

use Tools::Verify ; 
use strict ; 
use warnings ; 


sub init {
	my $self = shift ; 

	$self->{name} = 'CPAT'; 
	$self->{filename} = 'cpat.py'; 
	$self->{executable} = TRUE ; 
	$self->{min_version} = "1.2"; 
} 

sub getDescription { return "CPAT "; }

sub getConfigLabel { return "CPAT"; }

sub getConfigType { return "dir"; }

sub getSource { return "http://cpat.googlecode.com/files/CPAT-1.2.1.tar.gz"; }

sub getVersion { 
	my $self = shift ; 

	my $filename = $self->getPath(); 

	my $command = "$filename --version";
	my $output = $self->execute($command);

	my $version = undef ; 

	my @lines = split(/\n/, $output); 

	foreach my $thisLine (@lines){ 
		chomp($thisLine); 
		if($thisLine =~ /Version/){ 
			$version = $thisLine ; 
			$version =~ s/^cpat.py (\d+.\d+)$/$1/ ; 
		}
	}

	return $version ; 
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
