grp_cmp_func <- function (

		resdir="/home/m123485/project/Ashu/Result/MS_relative", 
		datdir="/home/m123485/project/Ashu/Data",
		codedir="/data2/microbiome/jeff/im_tornado/junR/", 
		R.obj=NULL,
		stat.file='Stats.R',
		otu.biom="test_paired.biom", 
		map.file="mapping_MS_relative.csv", 
		tree.file="test_paired.tree", 
		ko.biom=NULL,
		cog.biom=NULL,
#		ko.biom="metagenome_predictions_ko.biom", 
#		cog.biom="metagenome_predictions_cog.biom", 
		unweight.file="unweighted_unifrac_dm.txt", 
		grp.name="Disease_state2",
		grp.level.use=NULL,
	#	grp.level.use=c('MS', 'Relative'),
		num.var=NULL,
		rm.var.ind=1:5,
#		num.var=c('Age', 'Age_onsetyears', 'BMI', 'Years_to_2nd_attack', 'Duration_of_smoking', 'Smoking_pack_day'),
		test.formula='~ Age + Disease_state2',
		strata=NULL,
		selection=NULL,
		cluster.meta.info="Disease_state2",
		prev=0.10,
		minp=0.002,
		fdr.cutoff=0.15,
		rarefy.dep=10000
		) {

			cat("Load data ... \n")
			source(file.path(codedir, stat.file))			
			setwd(datdir)
			load_package()
			
			if (is.null(R.obj)) {
				data.obj <- load_data(otu.biom, map.file, tree.file, ko.biom, cog.biom)
				dist.obj <- construct_distance(data.obj, unweight.file)
				
				samIDs <- outlier_detect(data.obj, dist.obj)
				samIDs <- intersect(samIDs, rownames(data.obj$meta.dat))
				
				data.obj <- subset_data(data.obj, samIDs)
				dist.obj <- subset_dist(dist.obj, samIDs)
				
				save(data.obj, dist.obj, file="Data.RData")
			} else {
				load(R.obj)
			}
         
			if (is.null(grp.level.use)) {
				if (is.null(selection)) {
					samIDs <- rownames(data.obj$meta.dat)
				} else {
					samIDs <- rownames(data.obj$meta.dat)[eval(parse(text=selection), envir=data.obj$meta.dat)]
				}
			} else {
				if (is.null(selection)) {
					samIDs <- rownames(data.obj$meta.dat)[data.obj$meta.dat[, grp.name] %in% grp.level.use]
				} else {
					samIDs <- rownames(data.obj$meta.dat)[data.obj$meta.dat[, grp.name] %in% grp.level.use & eval(parse(text=selection), envir=data.obj$meta.dat)]
				}				
			}
q()						
			data.obj <- subset_data(data.obj, samIDs)
			dist.obj <- subset_dist(dist.obj, samIDs)
write.csv(data.obj$otu.name, 'Out.taxonomy.csv')
quit(save = "default", status = 0, runLast = TRUE)
# Clean meta data
			# summary(data.obj$meta.dat)
			data.obj$meta.dat <- data.obj$meta.dat[, -rm.var.ind]
			
			if (grp.name %in% num.var) {
				data.obj$meta.dat[, grp.name] <- as.numeric(data.obj$meta.dat[, grp.name])
			} else {
				data.obj$meta.dat[, grp.name] <- factor(data.obj$meta.dat[, grp.name], levels=grp.level.use)
			}
			
			colnames(data.obj$meta.dat) <- gsub("^\\s+|\\s+$", "", colnames(data.obj$meta.dat))
			cat.var <- setdiff(colnames(data.obj$meta.dat), num.var)
			sapply(cat.var, function(i) {
						data.obj$meta.dat[, i] <<- factor(data.obj$meta.dat[, i])
						NULL})
			sapply(num.var, function(i) {
						data.obj$meta.dat[, i] <<- as.numeric(data.obj$meta.dat[, i])
						NULL})
#			summary(data.obj$meta.dat)
			
			phylo.obj <- phyloseq(otu_table(data.obj$otu.tab, taxa_are_rows=T), phy_tree(data.obj$tree), tax_table(data.obj$otu.name), sample_data(data.obj$meta.dat))
			
			dir.create(resdir, showWarnings = FALSE)
			setwd(resdir)
			theme_set(theme_bw(base_size=16))
			
			save(dist.obj, data.obj, phylo.obj, file='Data.RData')


			#####################################
# 0. Basic characteristics          #
			#####################################
			cat("Calculating summary statistics for demographic factors ...\n")
			perform_demograph_analysis(data.obj, grp.name)
			
			#####################################
# 1. Alpah diversity analysis       #
			#####################################
			cat("Alpha diversity analysis ...\n")
			generate_rarefy_curve(data.obj, phylo.obj, grp.name, depth=rarefy.dep)
			generate_alpha_boxplot(data.obj, phylo.obj, depth=rarefy.dep, grp.name=grp.name, strata=strata)
			perform_alpha_test(data.obj, phylo.obj, depth=rarefy.dep, iter.no=10, formula=test.formula)
#perform_alpha_test_otu(data.obj, formula = '~ Age + Disease_state', grp.name=grp.name)
			
			#####################################
# 2. Beta  diversity analysis       #
			#####################################
			cat("Beta diversity analysis ...\n")
			generate_ordination(data.obj, dist.obj, grp.name=grp.name, strata=strata)
			generate_clustering(data.obj, dist.obj, meta.info=cluster.meta.info, is.labRow=T)
			
            generate_distance_barplot(data.obj, dist.obj, grp=grp.name, within=T, strata=strata)
			generate_distance_boxplot(data.obj, dist.obj, grp=grp.name, within=T, strata=strata)
			
#perform_distance_comp_test(data.obj, dist.obj, grp.name=grp.name)
			perform_permanova_test(data.obj, dist.obj, formula=test.formula)
			perform_betadisper_test(data.obj, dist.obj, grp.name = grp.name)
			#####################################
# 3. Taxa  diversity analysis       #
			#####################################
			cat("Taxa level analysis ...\n")
			generate_taxa_heatmap(data.obj, meta.info=cluster.meta.info, prev=prev, minp=minp)
		    generate_stacked_barplot(data.obj, grp.name=grp.name, agg.cutoff=0.01)
			
			generate_taxa_boxplot(data.obj, grp.name=grp.name, strata=strata)
            generate_taxa_barplot(data.obj, grp.name=grp.name, strata=strata)
			generate_taxa_barplot_aggregate(data.obj, grp.name=grp.name, strata=strata, prev=prev, minp=minp)
					
			diff.obj <- perform_differential_analysis(data.obj, grp.name=grp.name, cutoff=fdr.cutoff, prev=prev, minp=minp)
			visualize_differential_analysis(data.obj, diff.obj, grp.name=grp.name, cutoff=fdr.cutoff)
			
			diff.obj <- perform_differential_analysis(data.obj, grp.name=grp.name,  taxa.levels=c('Phylum', 'Class', 'Order', 'Family', 'Genus'), 
					cutoff=fdr.cutoff, prev=prev, minp=minp, 'AllFiveLevels')
			create_lefse_format(data.obj, diff.obj, grp.name=grp.name, cutoff=fdr.cutoff, prev=prev, minp=minp)
			perform_lefse_analysis(data.obj, diff.obj, grp.name=grp.name)
			
#generate_coef_plot(coef.obj, res.dir)
            set.seed(123)
            predictionRF(data.obj,  resp.name=grp.name,  prev=prev, minp=minp)
			predictionRF(data.obj,  resp.name=grp.name, taxa.level='Genus', prev=prev, minp=minp)
				
			if (!is.null(ko.biom)) {		
				
				generate_taxa_boxplot(data.obj, grp.name=grp.name, strata=strata, rm.outlier=F,
						taxa.levels=c("KEGG_Pathways3"), ann='KEGG')
				generate_taxa_barplot(data.obj, grp.name=grp.name, strata=strata, 
						taxa.levels=c("KEGG_Pathways3"), ann='KEGG')
				generate_taxa_barplot_aggregate(data.obj, grp.name=grp.name, strata=strata, 
						taxa.levels=c("KEGG_Pathways3"), ann='KEGG')
				diff.obj <- perform_differential_analysis(data.obj, grp.name=grp.name, cutoff=fdr.cutoff, 
						taxa.levels=c("KEGG_Pathways3"), ann='KEGG')			
				visualize_differential_analysis(data.obj, diff.obj, grp.name=grp.name, cutoff=fdr.cutoff, ann='KEGG', scale='none')	
			}
			
			if (!is.null(cog.biom)) {
				
				generate_taxa_boxplot(data.obj, grp.name=grp.name, strata=strata, rm.outlier=F,
						taxa.levels=c("COG_Category2"), ann='COG')
				generate_taxa_barplot(data.obj, grp.name=grp.name, strata=strata, 
						taxa.levels=c("COG_Category2"), ann='COG')
				generate_taxa_barplot_aggregate(data.obj, grp.name=grp.name, strata=strata, 
						taxa.levels=c("COG_Category2"), ann='COG')
				diff.obj <- perform_differential_analysis(data.obj, grp.name=grp.name, cutoff=fdr.cutoff, 
						taxa.levels=c("COG_Category2"), ann='COG')
				visualize_differential_analysis(data.obj, diff.obj, grp.name=grp.name, cutoff=fdr.cutoff, ann='COG', scale='none')				
				
			}
	
#
#create_lefse_format(data.obj, res.dir)
#create_metagenassist_format(data.obj, res.dir)
#create_krona_format(data.obj, res.dir)
			
		}





