/*==============================================================*/
/* Database name:  NGSPortal                                    */
/* DBMS name:      Microsoft SQL Server 2005                    */
/* Created on:     11/3/2011 10:10:58 AM                        */
/*==============================================================*/

/*==============================================================*/
/*	Delete all the existing tables, in the order needed to get	*/
/*	around the various foreign key constraints on the tables	*/
/*==============================================================*/
DROP TABLE BadData;
DROP TABLE SecondaryAnalysisLinker;
DROP TABLE SecondaryAnalysis;
DROP TABLE AnalysisType;
DROP TABLE ContactSequenceLinker;
DROP TABLE ProjectSampleLinker;
DROP TABLE SequencedSample;
DROP TABLE FileLocation;
DROP TABLE FlagstatResults;
DROP TABLE AccessChange;
DROP TABLE AccessChangeLog;
DROP TABLE ApplicationTypes;
DROP TABLE ContactProjectLinker;
DROP TABLE ContactGroupLinker;
DROP TABLE Groups;
DROP TABLE ContactLinker;
DROP TABLE AdHoc;
DROP TABLE FamilyMember;
DROP TABLE Family;
DROP TABLE Notes;
DROP TABLE ProjectInformation;
DROP TABLE Contacts;
DROP TABLE RunInformation;
DROP TABLE PrimaryAnalysisStatus;
DROP TABLE QCResults;
DROP TABLE ReadTypes;
DROP TABLE Role;
DROP TABLE Sample;
DROP TABLE Status;
DROP TABLE Tables;
DROP TABLE SGESecJobHistory;


/*==============================================================*/
/* Database: NGSPortal                                          */
/*==============================================================*/
/*
 * use NGSPortal
 * go
 */


/*==============================================================*/
/* Table: AccessChange                                          */
/*==============================================================*/
CREATE TABLE AccessChange (
   id                   Int                  IDENTITY,
   changeID             Int                  NOT NULL,
   theTable             Int                  NOT NULL,
   theRow               Int                  NOT NULL,
   CONSTRAINT PK_AccessChange PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: TableAccessChanges                                    */
/*==============================================================*/
CREATE CLUSTERED INDEX TableAccessChanges ON AccessChange (
theTable ASC, 
theRow ASC, 
changeID ASC
)
go

/*==============================================================*/
/* Table: AccessChangeLog                                       */
/*==============================================================*/
CREATE TABLE AccessChangeLog (
   id                   Int                  IDENTITY,
   authorizer           Int                  NOT NULL,
   authorized           Int                  NOT NULL,
   changeDate           DateTime             NOT NULL DEFAULT GetDate (),
   granted              Bit                  NOT NULL,
   CONSTRAINT PK_AccessChangeLog PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: Changes                                               */
/*==============================================================*/
CREATE CLUSTERED INDEX Changes ON AccessChangeLog (
changeDate DESC
)
go

/*==============================================================*/
/* Index: AccessChanges                                         */
/*==============================================================*/
CREATE NONCLUSTERED INDEX AccessChanges ON AccessChangeLog (
authorizer ASC, 
granted ASC, 
authorized ASC
)
go

/*==============================================================*/
/* Table: AdHoc                                                 */
/*==============================================================*/
CREATE TABLE AdHoc (
   id                   Int                  IDENTITY,
   theTable             Int                  NOT NULL,
   theRow               Int                  NOT NULL,
   theKey               VarChar(255)         NOT NULL,
   theValue             VarChar(255)         NOT NULL,
   CONSTRAINT PK_AdHoc PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: TableKeyValuePairs                                    */
/*==============================================================*/
CREATE CLUSTERED INDEX TableKeyValuePairs ON AdHoc (
theTable ASC, 
theRow ASC, 
theKey ASC, 
theValue ASC
)
go

/*==============================================================*/
/* Index: KeyValuePairs                                         */
/*==============================================================*/
CREATE NONCLUSTERED INDEX KeyValuePairs ON AdHoc (
theKey ASC, 
theValue ASC, 
theTable ASC, 
theRow ASC
)
go

/*==============================================================*/
/* Table: AnalysisGroup                                         */
/*==============================================================*/
CREATE TABLE AnalysisGroup (
   id                   Int                  Identity,
   projectID            Int                  DEFAULT NULL,
   CONSTRAINT PK_AnalysisGroup PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Table: AnalysisGroupLinker                                   */
/*==============================================================*/
CREATE TABLE AnalysisGroupLinker (
   sequencingID         Int                  NOT NULL,
   analysisID           Int                  NOT NULL
)
go

/*==============================================================*/
/* Index: AnGroup                                               */
/*==============================================================*/
CREATE CLUSTERED INDEX AnGroup ON AnalysisGroupLinker (
analysisID ASC, 
sequencingID ASC
)
go

/*==============================================================*/
/* Index: AnGroup2                                              */
/*==============================================================*/
CREATE INDEX AnGroup2 ON AnalysisGroupLinker (
sequencingID ASC,
analysisID ASC
)
go

/*==============================================================*/
/* Table: AnalysisType                                          */
/*==============================================================*/
CREATE TABLE AnalysisType (
   id                   Int                  IDENTITY,
   name                 VarChar(255)         NOT NULL,
   versionNumber        Float                NOT NULL,
   CONSTRAINT PK_ANALYSISTYPE PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON AnalysisType (
name ASC, 
versionNumber ASC
)
go

/*==============================================================*/
/* Table: ApplicationTypes                                      */
/*==============================================================*/
CREATE TABLE ApplicationTypes (
   id                   Int                  IDENTITY,
   name                 VarChar(7)           NOT NULL,
   description          VarChar(31)          NOT NULL DEFAULT '',
   CONSTRAINT PK_APPLICATIONTYPES PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON ApplicationTypes (
name ASC
)
go

/*==============================================================*/
/* Table: BadData                                               */
/*==============================================================*/
CREATE TABLE BadData (
   id                   Int                  IDENTITY,
   name                 VarChar(63)          NOT NULL,
   isRun                Bit                  NOT NULL DEFAULT 0,
   dateAdded            DateTime             NOT NULL DEFAULT GetDate (),
   CONSTRAINT PK_BadData PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: ITEMS                                                 */
/*==============================================================*/
CREATE UNIQUE INDEX Items ON BadData (
isRun ASC, 
name ASC
)
go

/*==============================================================*/
/* Table: CaptureKit                                            */
/*==============================================================*/
CREATE TABLE CaptureKit (
   id                   Int                  Identity,
   name                 VarChar(255)         NOT NULL,
   CONSTRAINT PK_CaptureKit PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Table: ContactGroupLinker                                    */
/*==============================================================*/
CREATE TABLE ContactGroupLinker (
   contactRoleID        Int                  NOT NULL,
   groupID              Int                  NOT NULL
)
go

/*==============================================================*/
/* Index: CONTACTS                                              */
/*==============================================================*/
CREATE INDEX CONTACTS ON ContactGroupLinker (
groupID ASC,
contactRoleID ASC
)
go

/*==============================================================*/
/* Table: ContactLinker                                         */
/*==============================================================*/
CREATE TABLE ContactLinker (
   id                   Int                  IDENTITY,
   contactID            Int                  NOT NULL,
   userRole             Int                  NOT NULL,
   CONSTRAINT PK_CONTACTLINKER PRIMARY KEY (id)
)
go

/*==============================================================*/
/* Index: ROLES                                                 */
/*==============================================================*/
CREATE UNIQUE INDEX ROLES ON ContactLinker (
userRole ASC,
contactID ASC
)
go

/*==============================================================*/
/* Index: CONTACTS                                              */
/*==============================================================*/
CREATE UNIQUE INDEX CONTACTS ON ContactLinker (
contactID ASC,
userRole ASC
)
go

/*==============================================================*/
/* Index: ContactInfo                                           */
/*==============================================================*/
CREATE INDEX ContactInfo ON ContactLinker (
contactID ASC,
id ASC
)
go

/*==============================================================*/
/* Table: ContactProjectLinker                                  */
/*==============================================================*/
CREATE TABLE ContactProjectLinker (
   contactRoleID        Int                  NOT NULL,
   projectID            Int                  NOT NULL
)
go

/*==============================================================*/
/* Index: CONTACTS                                              */
/*==============================================================*/
CREATE INDEX CONTACTS ON ContactProjectLinker (
projectID ASC,
contactRoleID ASC
)
go

/*==============================================================*/
/* Index: Projects                                              */
/*==============================================================*/
CREATE INDEX Projects ON ContactProjectLinker (
contactRoleID ASC,
projectID ASC
)
go

/*==============================================================*/
/* Table: ContactSequenceLinker                                 */
/*==============================================================*/
CREATE TABLE ContactSequenceLinker (
   sequencingID         Int                  NOT NULL,
   contactRoleID        Int                  NOT NULL
)
go

/*==============================================================*/
/* Index: CONTACTS                                              */
/*==============================================================*/
CREATE INDEX CONTACTS ON ContactSequenceLinker (
sequencingID ASC,
contactRoleID ASC
)
go

/*==============================================================*/
/* Index: SEQUENCES                                             */
/*==============================================================*/
CREATE INDEX SEQUENCES ON ContactSequenceLinker (
contactRoleID ASC,
sequencingID ASC
)
go

/*==============================================================*/
/* Table: Contacts                                              */
/*==============================================================*/
CREATE TABLE Contacts (
   id                   Int                  IDENTITY,
   lastName             VarChar(31)          NOT NULL DEFAULT '',
   firstName            VarChar(31)          NOT NULL DEFAULT '',
   lanID                VarChar(31)          NOT NULL DEFAULT '',
   internal             Bit                  NOT NULL,
   email                VarChar(255)         NOT NULL DEFAULT '',
   useCount             Int                  NOT NULL DEFAULT 0,
   lastUsed             DateTime             DEFAULT GetDate (),
   CONSTRAINT PK_CONTACTS PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON Contacts (
lastName ASC,
firstName ASC, 
id ASC
)
go

/*==============================================================*/
/* Table: Family                                                */
/*==============================================================*/
CREATE TABLE Family (
   id                   Int                  IDENTITY,
   name                 VarChar(255)         NOT NULL,
   CONSTRAINT PK_Family PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON Family (
name ASC
)
go

/*==============================================================*/
/* Table: FamilyMember                                          */
/* Table for creating Many : 1 (FamilyMember : Sample) and      */
/* Many : Many (Family : Sample) connections.                   */
/* The geneologically oldest Sample will belong to generation 1,*/
/* have 1 Family, and will have a NULL parentID.  Children will */
/* be generation + 1 of that family.                            */
/* Example: Let us have samples from the paternal Grandfather,  */
/* the Father, the Mother, and the Child.                       */
/* PG is family 1, generation 1.                                */
/* Father is family 1, generation 2.                            */
/* Mother is family 2, generation 1.                            */
/* Child is family 1, generation 3, AND family 2, generation 2  */
/*==============================================================*/
CREATE TABLE FamilyMember (
   id                   Int                  IDENTITY,
   sampleID             Int                  NOT NULL,
   familyID             Int                  NOT NULL,
   parentID             Int                  NULL DEFAULT NULL,
   generation           Int                  NOT NULL DEFAULT 0,
   isMale               Bit                  NULL DEFAULT NULL,
   name                 VarChar(255)         NOT NULL,
   CONSTRAINT PK_FamilyMember PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: Families                                              */
/*==============================================================*/
CREATE CLUSTERED INDEX Families ON FamilyMember (
familyID ASC, 
sampleID ASC
)
go

/*==============================================================*/
/* Index: Samples                                               */
/*==============================================================*/
CREATE NONCLUSTERED INDEX Samples ON FamilyMember (
sampleID ASC, 
familyID ASC
)
go

/*==============================================================*/
/* Index: Offspring                                             */
/*==============================================================*/
CREATE NONCLUSTERED INDEX Offspring ON FamilyMember (
parentID ASC, 
sampleID ASC
)
go

/*==============================================================*/
/* Index: Identifier                                            */
/*==============================================================*/
CREATE NONCLUSTERED INDEX Identifier ON FamilyMember (
id ASC, 
sampleID ASC
)
go

/*==============================================================*/
/* Index: Generations                                           */
/*==============================================================*/
CREATE NONCLUSTERED INDEX Generations ON FamilyMember (
familyID ASC, 
generation ASC, 
sampleID ASC
)
go

/*==============================================================*/
/* Table: FileLocation                                          */
/*==============================================================*/
CREATE TABLE FileLocation (
   id                   Int                  IDENTITY,
   name                 VarChar(31)          NOT NULL,
   description          VarChar(255)         NOT NULL DEFAULT '',
   location             VarChar(255)         NOT NULL,
   access               VarChar(255)         NOT NULL,
   CONSTRAINT PK_FILELOCATION PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON FileLocation (
name ASC
)
go

/*==============================================================*/
/* Table: FlagstatResults                                       */
/*==============================================================*/
CREATE TABLE FlagstatResults (
   id                   Int                  IDENTITY,
   readCount            BigInt               NOT NULL,
   mappedCount          BigInt               NOT NULL,
   qcFailure            Int                  NOT NULL,
   duplicates           Int                  NOT NULL,
   CONSTRAINT PK_FLAGSTATRESULTS PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Table: Groups                                                */
/*==============================================================*/
CREATE TABLE Groups (
   id                   Int                  IDENTITY,
   creator              Int                  NOT NULL,
   name                 VarChar(31)          NOT NULL,
   description          VarChar(255)         NOT NULL,
   constraint PK_GROUPS primary key (id)
)
go

/*==============================================================*/
/* Index: Names                                                 */
/*==============================================================*/
CREATE UNIQUE INDEX Names ON Groups (
name ASC
)
go

/*==============================================================*/
/* Table: Notes                                                 */
/*==============================================================*/
CREATE TABLE Notes (
   contactID            Int                  NOT NULL,
   theTable             Int                  NOT NULL,
   theRow               Int                  NOT NULL,
   theDate              DateTime             NOT NULL,
   note                 VarChar(8000)        NOT NULL,
   deleted              Bit                  NOT NULL DEFAULT 0
)
go

/*==============================================================*/
/* Index: TABLENOTES                                            */
/*==============================================================*/
CREATE CLUSTERED INDEX TABLENOTES ON Notes (
theTable ASC,
theRow ASC
)
go

/*==============================================================*/
/* Table: PrimaryAnalysisStatus                                 */
/*==============================================================*/
CREATE TABLE PrimaryAnalysisStatus (
   id                   Int                  IDENTITY,
   status               VarChar(31)          NOT NULL,
   task                 VarChar(31)          NOT NULL,
   CONSTRAINT PK_PRIMARYANALYSISSTATUS PRIMARY KEY (id)
)
go

/*==============================================================*/
/* Index: STATUS                                                */
/*==============================================================*/
CREATE UNIQUE INDEX STATUS ON PrimaryAnalysisStatus (
task ASC, 
status ASC
)
go

/*==============================================================*/
/* Table: ProjectInformation                                    */
/*==============================================================*/
CREATE TABLE ProjectInformation (
   id                   Int                  IDENTITY,
   name                 VarChar(63)          NOT NULL DEFAULT '',
   description          VarChar(255)         NOT NULL DEFAULT '',
   progress             Int                  NOT NULL DEFAULT 0,
   IRC                  Int                  NULL,
   CONSTRAINT PK_PROJECTINFORMATION PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON ProjectInformation (
name ASC
)
go

/*==============================================================*/
/* Table: ProjectSampleLinker                                   */
/*==============================================================*/
CREATE TABLE ProjectSampleLinker (
   sequencingID         Int                  NOT NULL,
   projectID            Int                  NOT NULL
)
go

/*==============================================================*/
/* Index: PROJECTINFO                                           */
/*==============================================================*/
CREATE UNIQUE INDEX PROJECTINFO ON ProjectSampleLinker (
projectID ASC,
sequencingID ASC
)
go

/*==============================================================*/
/* Index: SEQUENCINGINFO                                        */
/*==============================================================*/
CREATE UNIQUE INDEX SEQUENCINGINFO ON ProjectSampleLinker (
sequencingID ASC,
projectID ASC
)
go

/*==============================================================*/
/* Table: QCResults                                             */
/*==============================================================*/
CREATE TABLE QCResults (
   id                   Int                  IDENTITY,
   sequenceCount        Int                  NOT NULL,
   numBases             Int                  NOT NULL,
   numBadBases          Int                  NOT NULL,
   gcContent            Double Precision     NULL, 	/* NaN == NULL */
   duplicationLevel     Double Precision     NULL, 	/* NaN == NULL */
   percentSeqLow        Double Precision     NULL, 	/* NaN == NULL */
   percentSeqHigh       Double Precision     NULL, 	/* NaN == NULL */
   qcValue              VarChar(31)          NOT NULL,
   dataURL              VarChar(8000)        NOT NULL,
   whichRead            TinyInt              NOT NULL DEFAULT 1,
   CONSTRAINT PK_QCRESULTS PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Table: ReadTypes                                             */
/*==============================================================*/
CREATE TABLE ReadTypes (
   id                   Int                  IDENTITY,
   name                 VarChar(31)          NOT NULL,
   description          VarChar(31)          NOT NULL DEFAULT '',
   CONSTRAINT PK_READTYPES PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON ReadTypes (
name ASC
)
go

/*==============================================================*/
/* Table: RLIMSProject                                         */
/*==============================================================*/
CREATE TABLE RLIMSProject (
   id                   Int                  Identity,
   name                 VarChar(31)          NOT NULL,
   CONSTRAINT PK_RLIMSProject PRIMARY KEY NONCLUSTERED (id)
)
GO

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON RLIMSProject (
name ASC
)
GO


/*==============================================================*/
/* Table: Role                                                  */
/*==============================================================*/
CREATE TABLE Role (
   id                   Int                  IDENTITY,
   name                 VarChar(31)          NOT NULL,
   CONSTRAINT PK_ROLE PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: NAME                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX NAME ON Role (
name ASC
)
go

/*==============================================================*/
/* Table: RunInformation                                        */
/*==============================================================*/
CREATE TABLE RunInformation (
   id                   Int                  IDENTITY,
   runID                VarChar(63)          NOT NULL DEFAULT '',
   flowCell             VarChar(15)          NOT NULL,
   instrumentCompleteDate DateTime           NULL,
   primaryCompleteDate  DateTime             NULL,
   primaryQCCompleteDate DateTime            NULL,
   primaryDeliveryDate  DateTime             NULL,
   rlimsBatchID         VarChar(31)          NOT NULL,
   instrument           VarChar(15)          NOT NULL,
   primaryAnalysisStatus Int                 NULL,
   startDate            DateTime             NOT NULL,
   runValidated         Bit                  NOT NULL DEFAULT 0,
   CONSTRAINT PK_RUNINFORMATION PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: RUNS                                                  */
/*==============================================================*/
CREATE UNIQUE INDEX RUNS ON RunInformation (
runID ASC
)
go

/*==============================================================*/
/* Index: LifeTime                                              */
/*==============================================================*/
CREATE NONCLUSTERED INDEX LifeTime ON RunInformation (
startDate ASC, 
instrumentCompleteDate ASC, 
id ASC
)
go

/*==============================================================*/
/* Table: Sample                                                */
/*==============================================================*/
CREATE TABLE Sample (
   id                   Int                  IDENTITY,
   name                 VarChar(63)          NOT NULL DEFAULT '',
   sampleID             VarChar(63)          NOT NULL DEFAULT '',
   species              VarChar(31)          NOT NULL DEFAULT '',
   diseaseType          VarChar(31)          NULL DEFAULT NULL,
   tissueType           VarChar(31)          NULL DEFAULT NULL,
   parentID             VarChar(63)          NOT NULL DEFAULT '',
   CONSTRAINT PK_SAMPLE PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: SAMPLEID                                              */
/*==============================================================*/
CREATE UNIQUE INDEX SAMPLEID ON Sample (
sampleID ASC, 
parentID ASC
)
go

/*==============================================================*/
/* Index: Names                                                 */
/*==============================================================*/
CREATE INDEX Names ON Sample (
name ASC, 
id ASC
)
go

/*==============================================================*/
/* Index: Disease                                               */
/*==============================================================*/
CREATE INDEX Disease ON Sample (
diseaseType ASC, 
id ASC
)
go

/*==============================================================*/
/* Index: Tissue                                                */
/*==============================================================*/
CREATE INDEX Tissue ON Sample (
tissueType ASC, 
id ASC
)
go

/*==============================================================*/
/* Table: SecondaryAnalysis                                     */
/*==============================================================*/
CREATE TABLE SecondaryAnalysis (
   id                   Int                  IDENTITY,
   analysisType         Int                  NOT NULL,
   complete             Bit                  NOT NULL,
   deleteDate           DateTime             NULL,
   keepFileRequestor    VarChar(255)         NULL DEFAULT NULL,
   notes                VarChar(255)         NULL DEFAULT NULL,
   failed               Bit                  NOT NULL DEFAULT 0,
   anGroupID            Int                  NULL DEFAULT NULL,
   statusID             Int                  NOT NULL DEFAULT 1,
   dateAdded            DateTime             NOT NULL DEFAULT GetDate (),
   CONSTRAINT PK_SECONDARYANALYSIS PRIMARY KEY NONCLUSTERED (id)
)
go

/*
declare @CurrentUser sysname
select @CurrentUser = user_name()
execute sp_addextendedproperty 'MS_Description', 
   'Date when secondary analysis files will be deleted.  User can change this if need files to stay \
   around longer.

Should we have an uneditable 'original delete date' field, so we can do queries to find people who are \
pushing back their delete dates (so we can ask them WHY they''re doing it)?',
go
*/

/*==============================================================*/
/* Index: TYPES                                                 */
/*==============================================================*/
CREATE CLUSTERED INDEX TYPES ON SecondaryAnalysis (
analysisType ASC,
id ASC
)
go

/*==============================================================*/
/* Index: Status                                                */
/*==============================================================*/
CREATE INDEX Status ON SecondaryAnalysis (
statusID ASC,
anGroupID ASC
)
go

/*==============================================================*/
/* Index: Analysis                                              */
/*==============================================================*/
CREATE INDEX Analysis ON SecondaryAnalysis (
anGroupID ASC,
statusID ASC,
analysisType ASC,
complete ASC
)
go

/*==============================================================*/
/* Table: SequencedSample                                       */
/*==============================================================*/
CREATE TABLE SequencedSample (
   id                   Int                  IDENTITY,
   sampleID             Int                  NOT NULL,
   runID                Int                  NOT NULL,
   appType              Int                  NOT NULL,
   readType             Int                  NOT NULL,
   qcResults            Int                  NULL DEFAULT NULL,
   pairQCResults        Int                  NULL DEFAULT NULL,
   lane                 Int                  NOT NULL,
   cycles               Int                  NOT NULL,
   isControl            Bit                  NOT NULL,
   indexVendor          Bit                  NOT NULL DEFAULT 0,
   indexSequence        VarChar(31)          NOT NULL DEFAULT '',
   flowCell             VarChar(15)          NOT NULL,
   rlimsID              VarChar(15)          NOT NULL,
   requestName          VarChar(63)          NOT NULL,
   resultLocation       Int                  NOT NULL DEFAULT 0,
   fileSize             BigInt               NULL DEFAULT NULL,
   keepFileRequestor    VarChar(255)         NULL DEFAULT NULL,
   keepFileDate         DateTime             NULL DEFAULT NULL,
   flagstatResults      Int                  NULL DEFAULT NULL,
   pairFlagstatResults  Int                  NULL DEFAULT NULL,
   bamFileName          VarChar(255)         NULL DEFAULT NULL,
   isCIM                Bit                  NOT NULL DEFAULT 0,
   isBIC                Bit                  NULL DEFAULT NULL,
   needUpdate           Bit                  NOT NULL DEFAULT 0,
   captureKit           Int                  NOT NULL DEFAULT 0,
   rlimsProjectID       Int                  NULL DEFAULT NULL,
   CONSTRAINT PK_SEQUENCEDSAMPLE PRIMARY KEY NONCLUSTERED (id),
   CONSTRAINT AK_KEY_2_SEQUENCE UNIQUE (flowCell, indexSequence, lane)
)
go

/*==============================================================*/
/* Index: JOINER                                                */
/*==============================================================*/
CREATE INDEX JOINER ON SequencedSample (
runID ASC,
sampleID ASC, 
id ASC
)
go

/*==============================================================*/
/* Index: REQUESTERS                                            */
/*==============================================================*/
CREATE INDEX REQUESTERS ON SequencedSample (
keepFileRequestor ASC
)
go

/*==============================================================*/
/* Index: KeepDates                                             */
/*==============================================================*/
CREATE INDEX KeepDates ON SequencedSample (
keepFileDate ASC
)
GO

/*==============================================================*/
/* Table: Status                                                */
/*==============================================================*/
CREATE TABLE Status (
   id                   Int                  IDENTITY,
   name                 VarChar(255)         NOT NULL,
   CONSTRAINT PK_STATUS PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: VALUE                                                 */
/*==============================================================*/
CREATE UNIQUE INDEX VALUE ON Status (
name ASC
)
go

/*==============================================================*/
/* Table: Tables                                                */
/*==============================================================*/
CREATE TABLE Tables (
   id                   Int                  IDENTITY,
   name                 VarChar(31)          NOT NULL,
   CONSTRAINT PK_TABLES PRIMARY KEY NONCLUSTERED (id)
)
go

/*==============================================================*/
/* Index: THENAMES                                              */
/*==============================================================*/
CREATE UNIQUE INDEX THENAMES ON Tables (
name ASC
)
go

/*==============================================================*/
/* Table: SGESecJobHistory                                      */
/*==============================================================*/
CREATE TABLE SGESecJobHistory
(
id                   Int IDENTITY PRIMARY KEY,
jobName              VarChar(255) NOT NULL,
jobID                VarChar(255) NOT NULL,
userName             VarChar(255) DEFAULT NULL,
queue                VarChar(255) DEFAULT NULL,
host                 VarChar(255) DEFAULT NULL,
maxVmem              VarChar(255) DEFAULT NULL,
startTime            DateTime DEFAULT NULL,
endTime              DateTime DEFAULT NULL,
exitStatus           Int DEFAULT NULL,
userTime             VarChar(255) DEFAULT NULL,
systemTime           VarChar(255) DEFAULT NULL,
wallClockTime        VarChar(255) DEFAULT NULL,
cpu                  VarChar(255) DEFAULT NULL,
Workflow             VarChar(255) DEFAULT NULL,
MajorVersion         Int DEFAULT NULL,
MinorVersion         Int DEFAULT NULL,
ScriptName           VarChar(255) DEFAULT NULL,
SampleID             VarChar(255) DEFAULT NULL,
CpuSeconds           Int DEFAULT NULL,
UserSeconds          Int DEFAULT NULL,
SystemSeconds        Int DEFAULT NULL,
WallSeconds          Int DEFAULT NULL,
runID                VarChar(255) DEFAULT NULL,
vmem                 Real DEFAULT NULL,
hVmem                Real DEFAULT NULL,
SubmissionTime       DateTime DEFAULT NULL,
WaitTimeMinutes      Real DEFAULT NULL,
PEEnv                VarChar(255) DEFAULT NULL,
PEID                 VarChar(255) DEFAULT NULL,
PESlots              Int DEFAULT NULL,
MemUtilizedPct       Real DEFAULT NULL,
JobNum               Int DEFAULT NULL,
ArrayNum             Int DEFAULT NULL,
cores                Int DEFAULT NULL,
);

CREATE TABLE SGEPriJobHistory (
id                  Int                Identity PRIMARY KEY,
jobName             VarChar(255)       NOT NULL,
jobID               VarChar(255)       NOT NULL,
userName            VarChar(255)       DEFAULT NULL,
queue               VarChar(255)       DEFAULT NULL,
host                VarChar(255)       DEFAULT NULL,
maxVmem             VarChar(255)       DEFAULT NULL,
startTime           DateTime           DEFAULT NULL,
endTime             DateTime           DEFAULT NULL,
exitStatus          Int                DEFAULT NULL,
userTime            VarChar(255)       DEFAULT NULL,
systemTime          VarChar(255)       DEFAULT NULL,
wallClockTime       VarChar(255)       DEFAULT NULL,
cpu                 VarChar(255)       DEFAULT NULL,
workflow            VarChar(255)       DEFAULT NULL,
majorVersion        Int                DEFAULT NULL,
minorVersion        Int                DEFAULT NULL,
scriptName          VarChar(255)       DEFAULT NULL,
sampleID            VarChar(255)       DEFAULT NULL,
cpuSeconds          Int                DEFAULT NULL,
userSeconds         Int                DEFAULT NULL,
systemSeconds       Int                DEFAULT NULL,
wallSeconds         Int                DEFAULT NULL,
runID               VarChar(255)       DEFAULT NULL,
vmem                Real               DEFAULT NULL,
hVmem               Real               DEFAULT NULL,
submissionTime      DateTime           DEFAULT NULL,
waitTimeMinutes     Real               DEFAULT NULL,
peEnv               VarChar(255)       DEFAULT NULL,
peID                VarChar(255)       DEFAULT NULL,
peSlots             Int                DEFAULT NULL,
memUtilizedPct      Real               DEFAULT NULL,
jobNum              Int                DEFAULT NULL,
arrayNum            Int                DEFAULT NULL,
cores               Int                DEFAULT NULL
);

CREATE TABLE SGEWorkflowExecution(
id                  Int                Identity PRIMARY KEY,
runID               VarChar(255)       NOT NULL,
sampleID            VarChar(255)       DEFAULT NULL,
snalysis            VarChar(255)       DEFAULT NULL,
userName            VarChar(255)       DEFAULT NULL,
tool                VarChar(255)       DEFAULT NULL,
execTime            DateTime           DEFAULT NULL
);

CREATE TABLE SecondaryProjectInformation (
   id             Int             IDENTITY, 
   Notes          VarChar(255)    DEFAULT NULL, 
   AssignedDate   DateTime        DEFAULT NULL, 
   DeliveryDate   DateTime        DEFAULT NULL, 
   ProjectType    VarChar(65)     DEFAULT NULL, 
   name           VarChar(255)    DEFAULT NULL, 
   isBatched      Bit             NOT NULL DEFAULT 0, 
   firstReportDate DateTime       NULL DEFAULT NULL,
   CONSTRAINT PK_SECPROJECTINFORMATION PRIMARY KEY NONCLUSTERED (id)
)
go

CREATE UNIQUE INDEX projectName ON SecondaryProjectInformation (name) WHERE name IS NOT NULL;

CREATE TABLE SecondaryProjectSampleLinker (
  sequencingID         Int                  NOT NULL,
  secprojectID         Int                  NOT NULL
)
go

CREATE UNIQUE INDEX SECPROJECTINFO ON SecondaryProjectSampleLinker (
secprojectID ASC,
sequencingID ASC
)
go


CREATE UNIQUE INDEX SECSEQUENCINGINFO ON SecondaryProjectSampleLinker (
sequencingID ASC,
secprojectID ASC
)
Go

CREATE TABLE ContactSecondaryProjectLinker (
contactRoleID        Int                  NOT NULL,
secprojectID         Int                  NOT NULL
)
go

CREATE INDEX SECCONTACTS ON ContactSecondaryProjectLinker(
secprojectID ASC,
contactRoleID ASC
)
go

CREATE INDEX SECPROJECTS ON ContactSecondaryProjectLinker (
contactRoleID ASC,
secprojectID ASC
)
go



ALTER TABLE AccessChange
   ADD CONSTRAINT FK_AccessChange_REFERENCE_Acce FOREIGN KEY (changeID)
      REFERENCES AccessChangeLog (id)
go

ALTER TABLE AccessChange
   ADD CONSTRAINT FK_AccessChange_REFERENCE_Table FOREIGN KEY (theTable)
      REFERENCES Tables (id)
go

ALTER TABLE AccessChangeLog
   ADD CONSTRAINT FK_AccessChangeLog_REF_Contact FOREIGN KEY (authorizer)
      REFERENCES ContactLinker (id)
go

ALTER TABLE AccessChangeLog
   ADD CONSTRAINT FK_AccessChangeLog_REF_Contact2 FOREIGN KEY (authorized)
      REFERENCES ContactLinker (id)
go

ALTER TABLE AdHoc
   ADD CONSTRAINT FK_AdHoc_REFERENCE_TABLES FOREIGN KEY (theTable)
      REFERENCES Tables (id)
go

ALTER TABLE AnalysisGroup
   ADD CONSTRAINT FK_AnGrp_REFERENCE_SecProj FOREIGN KEY (projectID)
      REFERENCES SecondaryProjectInformation (id)
go

ALTER TABLE ContactGroupLinker
   ADD CONSTRAINT FK_CONTACTG_REFERENCE_GROUPS FOREIGN KEY (groupID)
      REFERENCES Groups (id)
go

ALTER TABLE ContactGroupLinker
   ADD CONSTRAINT FK_CONTACTG_REFERENCE_CONTACTL FOREIGN KEY (contactRoleID)
      REFERENCES ContactLinker (id)
go

ALTER TABLE ContactLinker
   ADD CONSTRAINT FK_CONTACTL_REFERENCE_ROLE FOREIGN KEY (userRole)
      REFERENCES Role (id)
go

ALTER TABLE ContactLinker
   ADD CONSTRAINT FK_CONTACTL_REFERENCE_CONTACTS FOREIGN KEY (contactID)
      REFERENCES Contacts (id)
go

ALTER TABLE ContactProjectLinker
   ADD CONSTRAINT FK_CONTACTP_REFERENCE_CONTACTL FOREIGN KEY (contactRoleID)
      REFERENCES ContactLinker (id)
go

ALTER TABLE ContactProjectLinker
   ADD CONSTRAINT FK_CONTACTP_REFERENCE_PROJECTI FOREIGN KEY (projectID)
      REFERENCES ProjectInformation (id)
go

ALTER TABLE ContactSequenceLinker
   ADD CONSTRAINT FK_CONTACTS_REFERENCE_SEQUENCE FOREIGN KEY (sequencingID)
      REFERENCES SequencedSample (id) ON DELETE CASCADE
go

ALTER TABLE ContactSequenceLinker
   ADD CONSTRAINT FK_CONTACTS_REFERENCE_CONTACTL FOREIGN KEY (contactRoleID)
      REFERENCES ContactLinker (id)
go

ALTER TABLE FamilyMember
   ADD CONSTRAINT FK_FamilyMe_REFERENCE_Family FOREIGN KEY (familyID)
      REFERENCES Family (id)
go

ALTER TABLE FamilyMember
   ADD CONSTRAINT FK_FamilyMe_REFERENCE_Sample FOREIGN KEY (sampleID)
      REFERENCES Sample (id)
go

ALTER TABLE FamilyMember
   ADD CONSTRAINT FK_FamilyMe_REFERENCE_FamilyMe FOREIGN KEY (parentID)
      REFERENCES FamilyMember (id)
go

ALTER TABLE Groups
   ADD CONSTRAINT FK_Groups_REFERENCE_Contacts FOREIGN KEY (creator)
      REFERENCES Contacts (id)
go

ALTER TABLE Notes
   ADD CONSTRAINT FK_NOTES_REFERENCE_TABLES FOREIGN KEY (theTable)
      REFERENCES Tables (id)
go

ALTER TABLE Notes
   ADD CONSTRAINT FK_NOTES_REFERENCE_CONTACTS FOREIGN KEY (contactID)
      REFERENCES Contacts (id)
go

ALTER TABLE ProjectSampleLinker
   ADD CONSTRAINT FK_PROJECTS_REFERENCE_SEQUENCE FOREIGN KEY (sequencingID)
      REFERENCES SequencedSample (id) ON DELETE CASCADE
go

ALTER TABLE ProjectSampleLinker
   ADD CONSTRAINT FK_PROJECTS_REFERENCE_PROJECTI FOREIGN KEY (projectID)
      REFERENCES ProjectInformation (id)
go

ALTER TABLE RunInformation
   ADD CONSTRAINT FK_RUNINFOR_REFERENCE_PRIMARYA FOREIGN KEY (primaryAnalysisStatus)
      REFERENCES PrimaryAnalysisStatus (id)
go

ALTER TABLE SecondaryAnalysis
   ADD CONSTRAINT FK_SECONDAR_REFERENCE_ANALYSIS FOREIGN KEY (analysisType)
      REFERENCES AnalysisType (id)
go

ALTER TABLE SecondaryAnalysis
   ADD CONSTRAINT FK_SecAn_REFERENCE_AnalysisGroup FOREIGN KEY (anGroupID)
      REFERENCES AnalysisGroup (id)
go

ALTER TABLE SecondaryAnalysis
   ADD CONSTRAINT FK_SecAn_REFERENCE_Status FOREIGN KEY (statusID)
      REFERENCES Status (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SEQUENCE_REFERENCE_SAMPLE FOREIGN KEY (sampleID)
      REFERENCES Sample (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SEQUENCE_REFERENCE_RUNINFOR FOREIGN KEY (runID)
      REFERENCES RunInformation (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SEQUENCE_REFERENCE_FLAGSTAT FOREIGN KEY (flagstatResults)
      REFERENCES FlagstatResults (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SEQUENCE_REFERENCE_PAIRFLAG FOREIGN KEY (pairFlagstatResults)
      REFERENCES FlagstatResults (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SEQUENCE_REFERENCE_READTYPE FOREIGN KEY (readType)
      REFERENCES ReadTypes (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SEQUENCE_REFERENCE_APPLICAT FOREIGN KEY (appType)
      REFERENCES ApplicationTypes (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SEQUENCE_REFERENCE_QCRESULT FOREIGN KEY (qcResults)
      REFERENCES QCResults (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SEQUENCE_REFERENCE_PairQCRESULT FOREIGN KEY (pairQCResults)
      REFERENCES QCResults (id)
go

ALTER TABLE SequencedSample
   ADD CONSTRAINT FK_SSample_REFERENCE_RLIMSProj FOREIGN KEY (rlimsProjectID)
      REFERENCES RLIMSProject (id)
GO

ALTER TABLE SecondaryProjectSampleLinker
   ADD CONSTRAINT FK_SECPROJECTS_REFERENCE_SEQUENCE FOREIGN KEY (sequencingID)
      REFERENCES SequencedSample (id) ON DELETE CASCADE
go

ALTER TABLE SecondaryProjectSampleLinker
   ADD CONSTRAINT FK_SECPROJECTS_REFERENCE_PROJECTI FOREIGN KEY (secprojectID)
      REFERENCES SecondaryProjectInformation(id)
go


ALTER TABLE ContactSecondaryProjectLinker
   ADD CONSTRAINT FK_CONTACTSEC_REFERENCE_CONTACTL FOREIGN KEY (contactRoleID)
      REFERENCES ContactLinker (id)
go

ALTER TABLE ContactSecondaryProjectLinker
   ADD CONSTRAINT FK_CONTACTSEC_REFERENCE_PROJECTI FOREIGN KEY (secprojectID)
      REFERENCES SecondaryProjectInformation (id)
go

INSERT INTO Role (name) VALUES ('PI');
INSERT INTO Role (name) VALUES ('Co-PI');
INSERT INTO Role (name) VALUES ('Researcher');
INSERT INTO Role (name) VALUES ('Informatics PhD Lead');
INSERT INTO Role (name) VALUES ('Informatics Lead');
INSERT INTO Role (name) VALUES ('Informatics Specialist');
INSERT INTO Role (name) VALUES ('Statistician');
INSERT INTO Role (name) VALUES ('IT');
INSERT INTO Role (name) VALUES ('SPA');
INSERT INTO Role (name) VALUES ('Lab Manager');
INSERT INTO Role (name) VALUES ('Lab Tech');
INSERT INTO Role (name) VALUES ('Admin');
INSERT INTO Role (name) VALUES ('Project Creator');
INSERT INTO Role (name) VALUES ('Project Informatics Lead');
INSERT INTO Role (name) VALUES ('Project Informatics Specialist');
INSERT INTO Role (name) VALUES ('Project PI');

INSERT INTO ReadTypes (name, description) VALUES ('SINGLE_READ', 'Single read');
INSERT INTO ReadTypes (name, description) VALUES ('PAIRED_END', 'Paired End');
INSERT INTO ReadTypes (name, description) VALUES ('MATED_PAIRED_END', 'Mated Paired End');

INSERT INTO ApplicationTypes (name, description) VALUES ('GENOM', 'Whole genome resequencing');
INSERT INTO ApplicationTypes (name, description) VALUES ('MRNAS', 'mRNA Sequencing');
INSERT INTO ApplicationTypes (name, description) VALUES ('SRNAD', 'Small RNA Discovery');
INSERT INTO ApplicationTypes (name, description) VALUES ('METHL', 'Methylation');
INSERT INTO ApplicationTypes (name, description) VALUES ('CHIPS', 'ChIP-SEQ');
INSERT INTO ApplicationTypes (name, description) VALUES ('DGESQ', 'Digital gene expression');
INSERT INTO ApplicationTypes (name, description) VALUES ('EXOME', 'Exome');
INSERT INTO ApplicationTypes (name, description) VALUES ('AMPLN', 'Amplicon');
INSERT INTO ApplicationTypes (name, description) VALUES ('CSCAP', 'Custom SureSelect Capture');
INSERT INTO ApplicationTypes (name, description) VALUES ('MEDIP-S', 'Methylated DNA IP Sequencing');
INSERT INTO ApplicationTypes (name, description) VALUES ('MATEPAI', 'Mate Pair');
INSERT INTO ApplicationTypes (name, description) VALUES ('RIP-SEQ', 'RNA IP Sequencing');
INSERT INTO ApplicationTypes (name, description) VALUES ('LNCRNA', 'Long non coding RNA');
INSERT INTO ApplicationTypes (name, description) VALUES ('TotalRN', 'Total RNA sequencing');
INSERT INTO ApplicationTypes (name, description) VALUES ('HALO', 'Haloplex Custom');
INSERT INTO ApplicationTypes (name, description) VALUES ('ChIRP', 'ChIRP Sequencing');
INSERT INTO ApplicationTypes (name, description) VALUES ('CLIP-Se', 'CLIP-Seq');
INSERT INTO ApplicationTypes (name, description) VALUES ('GENOdM', 'Mouse Whole Genome');
INSERT INTO ApplicationTypes (name, description) VALUES ('16sAMP', '16s Amplicon');
INSERT INTO ApplicationTypes (name, description) VALUES ('METAGEN', 'MetaGenome');
INSERT INTO ApplicationTypes (name, description) VALUES ('smRNA', 'Small RNA');

INSERT INTO AnalysisType (name, versionNumber) VALUES ('Exome', '3.2');
INSERT INTO AnalysisType (name, versionNumber) VALUES ('mRNA-SEQ', '3.6');
INSERT INTO AnalysisType (name, versionNumber) VALUES ('WholeGenome', '1.0');
INSERT INTO AnalysisType (name, versionNumber) VALUES ('Methylation', '1.0');
INSERT INTO AnalysisType (name, versionNumber) VALUES ('MAPRSeq', '1.2');
INSERT INTO AnalysisType (name, versionNumber) VALUES ('ChipSeq', '2.0');
INSERT INTO AnalysisType (name, versionNumber) VALUES ('miRNA', '1.0');
INSERT INTO AnalysisType (name, versionNumber) VALUES ('Microbiome', '1.0');
INSERT INTO AnalysisType (name, versionNumber) VALUES ('MAPRSeq', '1.1');

INSERT INTO Status (name) VALUES ('Beginning');
INSERT INTO Status (name) VALUES ('Start');
INSERT INTO Status (name) VALUES ('AdapterTrimming');
INSERT INTO Status (name) VALUES ('Sampling');
INSERT INTO Status (name) VALUES ('QC');
INSERT INTO Status (name) VALUES ('unused1');
INSERT INTO Status (name) VALUES ('Trimming');
INSERT INTO Status (name) VALUES ('unused2');
INSERT INTO Status (name) VALUES ('ChimeraCheck');
INSERT INTO Status (name) VALUES ('Alignment');
INSERT INTO Status (name) VALUES ('unused3');
INSERT INTO Status (name) VALUES ('unused4');
INSERT INTO Status (name) VALUES ('unused5');
INSERT INTO Status (name) VALUES ('Realignment');
INSERT INTO Status (name) VALUES ('OTUCall');
INSERT INTO Status (name) VALUES ('unused6');
INSERT INTO Status (name) VALUES ('unused7');
INSERT INTO Status (name) VALUES ('ExpressionCount');
INSERT INTO Status (name) VALUES ('unused8');
INSERT INTO Status (name) VALUES ('unused9');
INSERT INTO Status (name) VALUES ('PeakCalling');
INSERT INTO Status (name) VALUES ('VariantCalling');
INSERT INTO Status (name) VALUES ('unused10');
INSERT INTO Status (name) VALUES ('CpgCalling');
INSERT INTO Status (name) VALUES ('unused12');
INSERT INTO Status (name) VALUES ('Annotation');
INSERT INTO Status (name) VALUES ('unused13');
INSERT INTO Status (name) VALUES ('unused14');
INSERT INTO Status (name) VALUES ('unused15');
INSERT INTO Status (name) VALUES ('Statistics');
INSERT INTO Status (name) VALUES ('unused16');
INSERT INTO Status (name) VALUES ('unused17');
INSERT INTO Status (name) VALUES ('unused18');
INSERT INTO Status (name) VALUES ('Results');
INSERT INTO Status (name) VALUES ('unused19');
INSERT INTO Status (name) VALUES ('Complete');
INSERT INTO Status (name) VALUES ('Delivered');
INSERT INTO Status (name) VALUES ('unused20');
INSERT INTO Status (name) VALUES ('unused21');
INSERT INTO Status (name) VALUES ('Not Analyzed');
INSERT INTO Status (name) VALUES ('unusedHold1');
INSERT INTO Status (name) VALUES ('unusedHold2');
INSERT INTO Status (name) VALUES ('unusedHold3');
INSERT INTO Status (name) VALUES ('unusedHold4');
INSERT INTO Status (name) VALUES ('unusedHold5');

INSERT INTO Tables (name) VALUES ('AccessChange');
INSERT INTO Tables (name) VALUES ('AccessChangeLog');
INSERT INTO Tables (name) VALUES ('AdHoc');
INSERT INTO Tables (name) VALUES ('AnalysisGroup');
INSERT INTO Tables (name) VALUES ('AnalysisGroupLinker');
INSERT INTO Tables (name) VALUES ('AnalysisType');
INSERT INTO Tables (name) VALUES ('ApplicationTypes');
INSERT INTO Tables (name) VALUES ('BadData');
INSERT INTO Tables (name) VALUES ('CaptureKit');
INSERT INTO Tables (name) VALUES ('ContactGroupLinker');
INSERT INTO Tables (name) VALUES ('ContactLinker');
INSERT INTO Tables (name) VALUES ('ContactProjectLinker');
INSERT INTO Tables (name) VALUES ('Contacts');
INSERT INTO Tables (name) VALUES ('ContactSecondaryProjectLinker');
INSERT INTO Tables (name) VALUES ('ContactSequenceLinker');
INSERT INTO Tables (name) VALUES ('Family');
INSERT INTO Tables (name) VALUES ('FamilyMember');
INSERT INTO Tables (name) VALUES ('FileLocation');
INSERT INTO Tables (name) VALUES ('FlagstatResults');
INSERT INTO Tables (name) VALUES ('Groups');
INSERT INTO Tables (name) VALUES ('Notes');
INSERT INTO Tables (name) VALUES ('PrimaryAnalysisStatus');
INSERT INTO Tables (name) VALUES ('ProjectInformation');
INSERT INTO Tables (name) VALUES ('ProjectSampleLinker');
INSERT INTO Tables (name) VALUES ('QCResults');
INSERT INTO Tables (name) VALUES ('ReadTypes');
INSERT INTO Tables (name) VALUES ('RLIMSProject');
INSERT INTO Tables (name) VALUES ('Role');
INSERT INTO Tables (name) VALUES ('RunInformation');
INSERT INTO Tables (name) VALUES ('Sample');
INSERT INTO Tables (name) VALUES ('SecondaryAnalysis');
INSERT INTO Tables (name) VALUES ('SecondaryProjectInformation');
INSERT INTO Tables (name) VALUES ('SecondaryProjectSampleLinker');
INSERT INTO Tables (name) VALUES ('SequencedSample');
INSERT INTO Tables (name) VALUES ('SGEPriJobHistory');
INSERT INTO Tables (name) VALUES ('SGESecJobHistory');
INSERT INTO Tables (name) VALUES ('SGEWorkflowExecution');
INSERT INTO Tables (name) VALUES ('Status');
INSERT INTO Tables (name) VALUES ('Tables');

INSERT INTO FileLocation (name, description, location, access) 
	VALUES ('NL', 'Delivery Storage', '/data3/delivery/<pi name>/<run name>/primary/<sample name>', 
			'ftp://rcfisinl1-212/delivery/');
INSERT INTO FileLocation (name, description, location, access) 
	VALUES ('RA', 'Research Archive', '/NGS/delivery/<pi name>/<run name>/primary/<sample name>', 
			'http://research-archive/?B=%2FNGS%2Fdelivery%2F');
INSERT INTO FileLocation (name, description, location, access) 
	VALUES ('X', 'Analysis storage', '/data2/delivery/<pi name>/<run name>/primary/<sample name>', 
			'file://///rcfcluster-cifs/data2/delivery/');

