#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Created on Thu Sep  5 15:58:57 2013

@author: patricio
"""

import argparse
from Bio import SeqIO

parser= argparse.ArgumentParser(description="Convert Stockholm-formatted alignment files to fasta files. Only for small (< 100000 reads) alignments.")

parser.add_argument('in_stk', help="Input Stockholm file.")
parser.add_argument('out_fasta', help="Output fasta file.")

args= parser.parse_args()

SeqIO.convert(args.in_stk, "stockholm", args.out_fasta, "fasta")