#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Created on Fri Aug 30 14:31:36 2013

@author: patricio
"""

import argparse
from Bio import SeqIO
from Bio.SeqRecord import SeqRecord

parser= argparse.ArgumentParser(description="Renames IDs in the OTU file.")

parser.add_argument('in_fasta', help="Input fasta file with otus.")
parser.add_argument('out_fasta', help="Output file with OTU IDs renamed.")
#add by Jeff Chen, Apr-21-1-24
parser.add_argument('start', type=int, help="start index of FASTA name.")
args= parser.parse_args()

renamed= (SeqRecord(seq=r.seq, id="{}".format(i), description="original_id={}".format(r.id)) for i,r in enumerate(SeqIO.parse(args.in_fasta, "fasta"),args.start))

SeqIO.write(renamed, args.out_fasta, "fasta")
