#!/usr/bin/env python
from Bio import SeqIO
import argparse

parser= argparse.ArgumentParser(description="Converts a FASTQ formatted file (qualities in PHRED33 format) into a FASTA formatted file, and optionally a file with corresponding qualities.")

parser.add_argument('fastq', help="Input FASTQ file.")
parser.add_argument('fasta', help="Output FASTA file.")
parser.add_argument('--qual', help="Optional QUAL file to store read qualities" )

args= parser.parse_args()

SeqIO.convert(args.fastq, "fastq", args.fasta, "fasta")

if args.qual is not None:
    SeqIO.convert(args.fastq, "fastq", args.qual, "qual") 
