#line 1 "numpy/core/src/umath/simd.inc.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */

/*
 * This file is for the definitions of simd vectorized operations.
 *
 * Currently contains sse2 functions that are built on amd64, x32 or
 * non-generic builds (CFLAGS=-march=...)
 * In future it may contain other instruction sets like AVX or NEON detected
 * at runtime in which case it needs to be included indirectly via a file
 * compiled with special options (or use gcc target attributes) so the binary
 * stays portable.
 */


#ifndef __NPY_SIMD_INC
#define __NPY_SIMD_INC

#include "lowlevel_strided_loops.h"
#include "numpy/npy_common.h"
/* for NO_FLOATING_POINT_SUPPORT */
#include "numpy/ufuncobject.h"
#ifdef NPY_HAVE_SSE2_INTRINSICS
#include <emmintrin.h>
#endif
#include <assert.h>
#include <stdlib.h>
#include <string.h> /* for memcpy */

int PyUFunc_getfperr(void);
void PyUFunc_clearfperr(void);

/*
 * stride is equal to element size and input and destination are equal or
 * don't overlap within one register
 */
#define IS_BLOCKABLE_UNARY(esize, vsize) \
    (steps[0] == (esize) && steps[0] == steps[1] && \
     (npy_is_aligned(args[0], esize) && npy_is_aligned(args[1], esize)) && \
     ((abs(args[1] - args[0]) >= (vsize)) || ((abs(args[1] - args[0]) == 0))))

#define IS_BLOCKABLE_REDUCE(esize, vsize) \
    (steps[1] == (esize) && abs(args[1] - args[0]) >= (vsize))

#define IS_BLOCKABLE_BINARY(esize, vsize) \
    (steps[0] == steps[1] && steps[1] == steps[2] && steps[2] == (esize) && \
     npy_is_aligned(args[2], (esize)) && npy_is_aligned(args[1], (esize)) && \
     npy_is_aligned(args[0], (esize)) && \
     (abs(args[2] - args[0]) >= (vsize) || abs(args[2] - args[0]) == 0) && \
     (abs(args[2] - args[1]) >= (vsize) || abs(args[2] - args[1]) >= 0))

#define IS_BLOCKABLE_BINARY_SCALAR1(esize, vsize) \
    (steps[0] == 0 && steps[1] == steps[2] && steps[2] == (esize) && \
     npy_is_aligned(args[2], (esize)) && npy_is_aligned(args[1], (esize)) && \
     ((abs(args[2] - args[1]) >= (vsize)) || (abs(args[2] - args[1]) == 0)) && \
     abs(args[2] - args[0]) >= (esize))

#define IS_BLOCKABLE_BINARY_SCALAR2(esize, vsize) \
    (steps[1] == 0 && steps[0] == steps[2] && steps[2] == (esize) && \
     npy_is_aligned(args[2], (esize)) && npy_is_aligned(args[0], (esize)) && \
     ((abs(args[2] - args[0]) >= (vsize)) || (abs(args[2] - args[0]) == 0)) && \
     abs(args[2] - args[1]) >= (esize))

#define IS_BLOCKABLE_BINARY_BOOL(esize, vsize) \
    (steps[0] == (esize) && steps[0] == steps[1] && steps[2] == (1) && \
     npy_is_aligned(args[1], (esize)) && \
     npy_is_aligned(args[0], (esize)))

#define IS_BLOCKABLE_BINARY_SCALAR1_BOOL(esize, vsize) \
    (steps[0] == 0 && steps[1] == (esize) && steps[2] == (1) && \
     npy_is_aligned(args[1], (esize)))

#define IS_BLOCKABLE_BINARY_SCALAR2_BOOL(esize, vsize) \
    (steps[0] == (esize) && steps[1] == 0 && steps[2] == (1) && \
     npy_is_aligned(args[0], (esize)))

/* align var to alignment */
#define LOOP_BLOCK_ALIGN_VAR(var, type, alignment)\
    npy_intp i, peel = npy_aligned_block_offset(var, sizeof(type),\
                                                alignment, n);\
    for(i = 0; i < peel; i++)

#define LOOP_BLOCKED(type, vsize)\
    for(; i < npy_blocked_end(peel, sizeof(type), vsize, n);\
            i += (vsize / sizeof(type)))

#define LOOP_BLOCKED_END\
    for (; i < n; i++)

/* fanout two bits to two bytes */
static const npy_int16 fanout_2[] = {
    0x0000,
    0x0001,
    0x0100,
    0x0101,
};

/* fanout four bits to four bytes */
static const npy_int32 fanout_4[] = {
    0x00000000,
    0x00000001,
    0x00000100,
    0x00000101,
    0x00010000,
    0x00010001,
    0x00010100,
    0x00010101,
    0x01000000,
    0x01000001,
    0x01000100,
    0x01000101,
    0x01010000,
    0x01010001,
    0x01010100,
    0x01010101
};


/*
 * Dispatcher functions
 * decide whether the operation can be vectorized and run it
 * if it was run returns true and false if nothing was done
 */

/*
 *****************************************************************************
 **                           FLOAT DISPATCHERS
 *****************************************************************************
 */

#line 136

#line 142

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_sqrt_FLOAT(npy_float *, npy_float *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_simd_sqrt_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_UNARY(sizeof(npy_float), 16)) {
        sse2_sqrt_FLOAT((npy_float*)args[1], (npy_float*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_absolute_FLOAT(npy_float *, npy_float *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_simd_absolute_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_UNARY(sizeof(npy_float), 16)) {
        sse2_absolute_FLOAT((npy_float*)args[1], (npy_float*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_minimum_FLOAT(npy_float *, npy_float *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_reduce_simd_minimum_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_REDUCE(sizeof(npy_float), 16)) {
        sse2_minimum_FLOAT((npy_float*)args[1], (npy_float*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_maximum_FLOAT(npy_float *, npy_float *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_reduce_simd_maximum_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_REDUCE(sizeof(npy_float), 16)) {
        sse2_maximum_FLOAT((npy_float*)args[1], (npy_float*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}



#line 169

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_add_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_add_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_add_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_add_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_float * op = (npy_float *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_add_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_add_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_float), 16)) {
        sse2_binary_add_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_subtract_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_subtract_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_subtract_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_subtract_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_float * op = (npy_float *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_subtract_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_subtract_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_float), 16)) {
        sse2_binary_subtract_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_multiply_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_multiply_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_multiply_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_multiply_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_float * op = (npy_float *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_multiply_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_multiply_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_float), 16)) {
        sse2_binary_multiply_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_divide_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_divide_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_divide_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_divide_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_float * op = (npy_float *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_divide_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_divide_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_float), 16)) {
        sse2_binary_divide_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}



#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_equal_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_not_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_not_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_not_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_not_equal_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_not_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_not_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_not_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_less_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_less_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_less_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_less_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_less_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_less_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_less_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_less_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_less_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_less_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_less_equal_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_less_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_less_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_less_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_greater_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_greater_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_greater_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_greater_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_greater_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_greater_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_greater_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_greater_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_greater_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_greater_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_greater_equal_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_greater_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_greater_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_greater_equal_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_logical_and_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_logical_and_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_logical_and_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_logical_and_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_logical_and_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_logical_and_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_logical_and_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_logical_or_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_logical_or_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_logical_or_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_logical_or_FLOAT(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_float * ip1 = (npy_float *)args[0];
    npy_float * ip2 = (npy_float *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar1_logical_or_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_scalar2_logical_or_FLOAT(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_float), 16)) {
        sse2_binary_logical_or_FLOAT(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}




#line 136

#line 142

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_sqrt_DOUBLE(npy_double *, npy_double *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_simd_sqrt_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_UNARY(sizeof(npy_double), 16)) {
        sse2_sqrt_DOUBLE((npy_double*)args[1], (npy_double*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_absolute_DOUBLE(npy_double *, npy_double *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_simd_absolute_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_UNARY(sizeof(npy_double), 16)) {
        sse2_absolute_DOUBLE((npy_double*)args[1], (npy_double*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_minimum_DOUBLE(npy_double *, npy_double *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_reduce_simd_minimum_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_REDUCE(sizeof(npy_double), 16)) {
        sse2_minimum_DOUBLE((npy_double*)args[1], (npy_double*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_maximum_DOUBLE(npy_double *, npy_double *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_reduce_simd_maximum_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_REDUCE(sizeof(npy_double), 16)) {
        sse2_maximum_DOUBLE((npy_double*)args[1], (npy_double*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}



#line 169

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_add_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_add_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_add_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_add_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_double * op = (npy_double *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_add_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_add_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_double), 16)) {
        sse2_binary_add_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_subtract_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_subtract_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_subtract_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_subtract_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_double * op = (npy_double *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_subtract_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_subtract_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_double), 16)) {
        sse2_binary_subtract_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_multiply_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_multiply_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_multiply_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_multiply_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_double * op = (npy_double *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_multiply_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_multiply_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_double), 16)) {
        sse2_binary_multiply_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_divide_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_divide_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_divide_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_divide_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_double * op = (npy_double *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_divide_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_divide_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_double), 16)) {
        sse2_binary_divide_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}



#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_equal_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_not_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_not_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_not_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_not_equal_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_not_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_not_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_not_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_less_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_less_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_less_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_less_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_less_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_less_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_less_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_less_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_less_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_less_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_less_equal_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_less_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_less_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_less_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_greater_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_greater_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_greater_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_greater_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_greater_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_greater_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_greater_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_greater_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_greater_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_greater_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_greater_equal_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_greater_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_greater_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_greater_equal_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_logical_and_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_logical_and_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_logical_and_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_logical_and_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_logical_and_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_logical_and_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_logical_and_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 1 && 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_logical_or_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_logical_or_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_logical_or_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_logical_or_DOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 1 && 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_double * ip1 = (npy_double *)args[0];
    npy_double * ip2 = (npy_double *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar1_logical_or_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_scalar2_logical_or_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_double), 16)) {
        sse2_binary_logical_or_DOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}




#line 136

#line 142

#if 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_sqrt_LONGDOUBLE(npy_longdouble *, npy_longdouble *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_simd_sqrt_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_UNARY(sizeof(npy_longdouble), 16)) {
        sse2_sqrt_LONGDOUBLE((npy_longdouble*)args[1], (npy_longdouble*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_absolute_LONGDOUBLE(npy_longdouble *, npy_longdouble *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_simd_absolute_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_UNARY(sizeof(npy_longdouble), 16)) {
        sse2_absolute_LONGDOUBLE((npy_longdouble*)args[1], (npy_longdouble*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_minimum_LONGDOUBLE(npy_longdouble *, npy_longdouble *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_reduce_simd_minimum_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_REDUCE(sizeof(npy_longdouble), 16)) {
        sse2_minimum_LONGDOUBLE((npy_longdouble*)args[1], (npy_longdouble*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 142

#if 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_maximum_LONGDOUBLE(npy_longdouble *, npy_longdouble *, const npy_intp n);

#endif

static NPY_INLINE int
run_unary_reduce_simd_maximum_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && defined NPY_HAVE_SSE2_INTRINSICS
    if (IS_BLOCKABLE_REDUCE(sizeof(npy_longdouble), 16)) {
        sse2_maximum_LONGDOUBLE((npy_longdouble*)args[1], (npy_longdouble*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}



#line 169

#if 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_add_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_add_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_add_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_add_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_longdouble * op = (npy_longdouble *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_add_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_add_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_longdouble), 16)) {
        sse2_binary_add_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_subtract_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_subtract_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_subtract_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_subtract_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_longdouble * op = (npy_longdouble *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_subtract_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_subtract_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_longdouble), 16)) {
        sse2_binary_subtract_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_multiply_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_multiply_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_multiply_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_multiply_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_longdouble * op = (npy_longdouble *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_multiply_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_multiply_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_longdouble), 16)) {
        sse2_binary_multiply_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 169

#if 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_divide_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_divide_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_divide_LONGDOUBLE(npy_longdouble * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_divide_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_longdouble * op = (npy_longdouble *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_divide_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_divide_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY(sizeof(npy_longdouble), 16)) {
        sse2_binary_divide_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}



#line 218

#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_equal_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_not_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_not_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_not_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_not_equal_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_not_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_not_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_not_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_less_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_less_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_less_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_less_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_less_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_less_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_less_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_less_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_less_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_less_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_less_equal_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_less_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_less_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_less_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_greater_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_greater_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_greater_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_greater_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_greater_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_greater_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_greater_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_greater_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_greater_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_greater_equal_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_greater_equal_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && 1 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_greater_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_greater_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_greater_equal_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 0 && 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_logical_and_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_logical_and_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_logical_and_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_logical_and_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_logical_and_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_logical_and_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_logical_and_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}


#line 218

#if 0 && 0 && defined NPY_HAVE_SSE2_INTRINSICS

/* prototypes */
static void
sse2_binary_logical_or_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                          npy_intp n);
static void
sse2_binary_scalar1_logical_or_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);
static void
sse2_binary_scalar2_logical_or_LONGDOUBLE(npy_bool * op, npy_longdouble * ip1, npy_longdouble * ip2,
                                  npy_intp n);

#endif

static NPY_INLINE int
run_binary_simd_logical_or_LONGDOUBLE(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if 0 && 0 && defined NPY_HAVE_SSE2_INTRINSICS
    npy_longdouble * ip1 = (npy_longdouble *)args[0];
    npy_longdouble * ip2 = (npy_longdouble *)args[1];
    npy_bool * op = (npy_bool *)args[2];
    npy_intp n = dimensions[0];
    /* argument one scalar */
    if (IS_BLOCKABLE_BINARY_SCALAR1_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar1_logical_or_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    /* argument two scalar */
    else if (IS_BLOCKABLE_BINARY_SCALAR2_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_scalar2_logical_or_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
    else if (IS_BLOCKABLE_BINARY_BOOL(sizeof(npy_longdouble), 16)) {
        sse2_binary_logical_or_LONGDOUBLE(op, ip1, ip2, n);
        return 1;
    }
#endif
    return 0;
}





/*
 *****************************************************************************
 **                           BOOL DISPATCHERS
 *****************************************************************************
 */

#line 273

static void
sse2_binary_logical_or_BOOL(npy_bool * op, npy_bool * ip1, npy_bool * ip2,
                        npy_intp n);

static NPY_INLINE int
run_binary_simd_logical_or_BOOL(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if defined NPY_HAVE_SSE2_INTRINSICS
    if (sizeof(npy_bool) == 1 && IS_BLOCKABLE_BINARY(sizeof(npy_bool), 16)) {
        sse2_binary_logical_or_BOOL((npy_bool*)args[2], (npy_bool*)args[0],
                               (npy_bool*)args[1], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


static void
sse2_reduce_logical_or_BOOL(npy_bool * op, npy_bool * ip, npy_intp n);

static NPY_INLINE int
run_reduce_simd_logical_or_BOOL(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if defined NPY_HAVE_SSE2_INTRINSICS
    if (sizeof(npy_bool) == 1 && IS_BLOCKABLE_REDUCE(sizeof(npy_bool), 16)) {
        sse2_reduce_logical_or_BOOL((npy_bool*)args[0], (npy_bool*)args[1],
                                dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 273

static void
sse2_binary_logical_and_BOOL(npy_bool * op, npy_bool * ip1, npy_bool * ip2,
                        npy_intp n);

static NPY_INLINE int
run_binary_simd_logical_and_BOOL(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if defined NPY_HAVE_SSE2_INTRINSICS
    if (sizeof(npy_bool) == 1 && IS_BLOCKABLE_BINARY(sizeof(npy_bool), 16)) {
        sse2_binary_logical_and_BOOL((npy_bool*)args[2], (npy_bool*)args[0],
                               (npy_bool*)args[1], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


static void
sse2_reduce_logical_and_BOOL(npy_bool * op, npy_bool * ip, npy_intp n);

static NPY_INLINE int
run_reduce_simd_logical_and_BOOL(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if defined NPY_HAVE_SSE2_INTRINSICS
    if (sizeof(npy_bool) == 1 && IS_BLOCKABLE_REDUCE(sizeof(npy_bool), 16)) {
        sse2_reduce_logical_and_BOOL((npy_bool*)args[0], (npy_bool*)args[1],
                                dimensions[0]);
        return 1;
    }
#endif
    return 0;
}



#line 313

static void
sse2_absolute_BOOL(npy_bool *, npy_bool *, const npy_intp n);

static NPY_INLINE int
run_unary_simd_absolute_BOOL(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if defined NPY_HAVE_SSE2_INTRINSICS
    if (sizeof(npy_bool) == 1 && IS_BLOCKABLE_UNARY(sizeof(npy_bool), 16)) {
        sse2_absolute_BOOL((npy_bool*)args[1], (npy_bool*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}


#line 313

static void
sse2_logical_not_BOOL(npy_bool *, npy_bool *, const npy_intp n);

static NPY_INLINE int
run_unary_simd_logical_not_BOOL(char **args, npy_intp *dimensions, npy_intp *steps)
{
#if defined NPY_HAVE_SSE2_INTRINSICS
    if (sizeof(npy_bool) == 1 && IS_BLOCKABLE_UNARY(sizeof(npy_bool), 16)) {
        sse2_logical_not_BOOL((npy_bool*)args[1], (npy_bool*)args[0], dimensions[0]);
        return 1;
    }
#endif
    return 0;
}



#ifdef NPY_HAVE_SSE2_INTRINSICS

/*
 * Vectorized operations
 */
/*
 *****************************************************************************
 **                           FLOAT LOOPS
 *****************************************************************************
 */

#line 346

static NPY_INLINE npy_float sse2_horizontal_min___m128(__m128 v)
{
    npy_float r;
    __m128 tmp = _mm_movehl_ps(v, v);                   /* c     d     ... */
    __m128 m = _mm_min_ps(v, tmp);                    /* m(ac) m(bd) ... */
    tmp = _mm_shuffle_ps(m, m, _MM_SHUFFLE(1, 1, 1, 1));/* m(bd) m(bd) ... */
    _mm_store_ss(&r, _mm_min_ps(tmp, m));             /* m(acbd) ... */
    return r;
}

static NPY_INLINE npy_double sse2_horizontal_min___m128d(__m128d v)
{
    npy_double r;
    __m128d tmp = _mm_unpackhi_pd(v, v);    /* b     b */
    _mm_store_sd(&r, _mm_min_pd(tmp, v)); /* m(ab) m(bb) */
    return r;
}


#line 346

static NPY_INLINE npy_float sse2_horizontal_max___m128(__m128 v)
{
    npy_float r;
    __m128 tmp = _mm_movehl_ps(v, v);                   /* c     d     ... */
    __m128 m = _mm_max_ps(v, tmp);                    /* m(ac) m(bd) ... */
    tmp = _mm_shuffle_ps(m, m, _MM_SHUFFLE(1, 1, 1, 1));/* m(bd) m(bd) ... */
    _mm_store_ss(&r, _mm_max_ps(tmp, m));             /* m(acbd) ... */
    return r;
}

static NPY_INLINE npy_double sse2_horizontal_max___m128d(__m128d v)
{
    npy_double r;
    __m128d tmp = _mm_unpackhi_pd(v, v);    /* b     b */
    _mm_store_sd(&r, _mm_max_pd(tmp, v)); /* m(ab) m(bb) */
    return r;
}



#line 380


#line 388

static void
sse2_binary_add_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[i] + ip2[i];
    /* lots of specializations, to squeeze out max performance */
    if (npy_is_aligned(&ip1[i], 16) && npy_is_aligned(&ip2[i], 16)) {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_load_ps(&ip1[i]);
                __m128 c = _mm_add_ps(a, a);
                _mm_store_ps(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_load_ps(&ip1[i]);
                __m128 b = _mm_load_ps(&ip2[i]);
                __m128 c = _mm_add_ps(a, b);
                _mm_store_ps(&op[i], c);
            }
        }
    }
    else if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip1[i]);
            __m128 b = _mm_loadu_ps(&ip2[i]);
            __m128 c = _mm_add_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip1[i]);
            __m128 b = _mm_load_ps(&ip2[i]);
            __m128 c = _mm_add_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_loadu_ps(&ip1[i]);
                __m128 c = _mm_add_ps(a, a);
                _mm_store_ps(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_loadu_ps(&ip1[i]);
                __m128 b = _mm_loadu_ps(&ip2[i]);
                __m128 c = _mm_add_ps(a, b);
                _mm_store_ps(&op[i], c);
            }
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] + ip2[i];
    }
}


static void
sse2_binary_scalar1_add_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    const __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[0] + ip2[i];
    if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 b = _mm_load_ps(&ip2[i]);
            __m128 c = _mm_add_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 b = _mm_loadu_ps(&ip2[i]);
            __m128 c = _mm_add_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[0] + ip2[i];
    }
}


static void
sse2_binary_scalar2_add_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    const __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[i] + ip2[0];
    if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip1[i]);
            __m128 c = _mm_add_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip1[i]);
            __m128 c = _mm_add_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] + ip2[0];
    }
}


#line 388

static void
sse2_binary_subtract_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[i] - ip2[i];
    /* lots of specializations, to squeeze out max performance */
    if (npy_is_aligned(&ip1[i], 16) && npy_is_aligned(&ip2[i], 16)) {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_load_ps(&ip1[i]);
                __m128 c = _mm_sub_ps(a, a);
                _mm_store_ps(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_load_ps(&ip1[i]);
                __m128 b = _mm_load_ps(&ip2[i]);
                __m128 c = _mm_sub_ps(a, b);
                _mm_store_ps(&op[i], c);
            }
        }
    }
    else if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip1[i]);
            __m128 b = _mm_loadu_ps(&ip2[i]);
            __m128 c = _mm_sub_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip1[i]);
            __m128 b = _mm_load_ps(&ip2[i]);
            __m128 c = _mm_sub_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_loadu_ps(&ip1[i]);
                __m128 c = _mm_sub_ps(a, a);
                _mm_store_ps(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_loadu_ps(&ip1[i]);
                __m128 b = _mm_loadu_ps(&ip2[i]);
                __m128 c = _mm_sub_ps(a, b);
                _mm_store_ps(&op[i], c);
            }
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] - ip2[i];
    }
}


static void
sse2_binary_scalar1_subtract_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    const __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[0] - ip2[i];
    if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 b = _mm_load_ps(&ip2[i]);
            __m128 c = _mm_sub_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 b = _mm_loadu_ps(&ip2[i]);
            __m128 c = _mm_sub_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[0] - ip2[i];
    }
}


static void
sse2_binary_scalar2_subtract_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    const __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[i] - ip2[0];
    if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip1[i]);
            __m128 c = _mm_sub_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip1[i]);
            __m128 c = _mm_sub_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] - ip2[0];
    }
}


#line 388

static void
sse2_binary_multiply_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[i] * ip2[i];
    /* lots of specializations, to squeeze out max performance */
    if (npy_is_aligned(&ip1[i], 16) && npy_is_aligned(&ip2[i], 16)) {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_load_ps(&ip1[i]);
                __m128 c = _mm_mul_ps(a, a);
                _mm_store_ps(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_load_ps(&ip1[i]);
                __m128 b = _mm_load_ps(&ip2[i]);
                __m128 c = _mm_mul_ps(a, b);
                _mm_store_ps(&op[i], c);
            }
        }
    }
    else if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip1[i]);
            __m128 b = _mm_loadu_ps(&ip2[i]);
            __m128 c = _mm_mul_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip1[i]);
            __m128 b = _mm_load_ps(&ip2[i]);
            __m128 c = _mm_mul_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_loadu_ps(&ip1[i]);
                __m128 c = _mm_mul_ps(a, a);
                _mm_store_ps(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_loadu_ps(&ip1[i]);
                __m128 b = _mm_loadu_ps(&ip2[i]);
                __m128 c = _mm_mul_ps(a, b);
                _mm_store_ps(&op[i], c);
            }
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] * ip2[i];
    }
}


static void
sse2_binary_scalar1_multiply_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    const __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[0] * ip2[i];
    if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 b = _mm_load_ps(&ip2[i]);
            __m128 c = _mm_mul_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 b = _mm_loadu_ps(&ip2[i]);
            __m128 c = _mm_mul_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[0] * ip2[i];
    }
}


static void
sse2_binary_scalar2_multiply_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    const __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[i] * ip2[0];
    if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip1[i]);
            __m128 c = _mm_mul_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip1[i]);
            __m128 c = _mm_mul_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] * ip2[0];
    }
}


#line 388

static void
sse2_binary_divide_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[i] / ip2[i];
    /* lots of specializations, to squeeze out max performance */
    if (npy_is_aligned(&ip1[i], 16) && npy_is_aligned(&ip2[i], 16)) {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_load_ps(&ip1[i]);
                __m128 c = _mm_div_ps(a, a);
                _mm_store_ps(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_load_ps(&ip1[i]);
                __m128 b = _mm_load_ps(&ip2[i]);
                __m128 c = _mm_div_ps(a, b);
                _mm_store_ps(&op[i], c);
            }
        }
    }
    else if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip1[i]);
            __m128 b = _mm_loadu_ps(&ip2[i]);
            __m128 c = _mm_div_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip1[i]);
            __m128 b = _mm_load_ps(&ip2[i]);
            __m128 c = _mm_div_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_loadu_ps(&ip1[i]);
                __m128 c = _mm_div_ps(a, a);
                _mm_store_ps(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_float, 16) {
                __m128 a = _mm_loadu_ps(&ip1[i]);
                __m128 b = _mm_loadu_ps(&ip2[i]);
                __m128 c = _mm_div_ps(a, b);
                _mm_store_ps(&op[i], c);
            }
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] / ip2[i];
    }
}


static void
sse2_binary_scalar1_divide_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    const __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[0] / ip2[i];
    if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 b = _mm_load_ps(&ip2[i]);
            __m128 c = _mm_div_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 b = _mm_loadu_ps(&ip2[i]);
            __m128 c = _mm_div_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[0] / ip2[i];
    }
}


static void
sse2_binary_scalar2_divide_FLOAT(npy_float * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    const __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16)
        op[i] = ip1[i] / ip2[0];
    if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip1[i]);
            __m128 c = _mm_div_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip1[i]);
            __m128 c = _mm_div_ps(a, b);
            _mm_store_ps(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] / ip2[0];
    }
}



#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_equal_FLOAT(const npy_float a, const npy_float b)
{
    npy_float tmp;
    __m128 v = _mm_cmpeq_ss(_mm_load_ss(&a),
                                     _mm_load_ss(&b));
    _mm_store_ss(&tmp, v);
    return sizeof(npy_float) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_equal_FLOAT(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 b = _mm_loadu_ps(&ip2[i]);
        __m128 c = _mm_cmpeq_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_equal_FLOAT(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_float, 16) {
        op[i] = sse2_ordered_cmp_equal_FLOAT(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 b = _mm_load_ps(&ip2[i]);
        __m128 c = _mm_cmpeq_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_equal_FLOAT(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_equal_FLOAT(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 c = _mm_cmpeq_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_equal_FLOAT(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_not_equal_FLOAT(const npy_float a, const npy_float b)
{
    npy_float tmp;
    __m128 v = _mm_cmpneq_ss(_mm_load_ss(&a),
                                     _mm_load_ss(&b));
    _mm_store_ss(&tmp, v);
    return sizeof(npy_float) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_not_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_not_equal_FLOAT(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 b = _mm_loadu_ps(&ip2[i]);
        __m128 c = _mm_cmpneq_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_not_equal_FLOAT(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_not_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_float, 16) {
        op[i] = sse2_ordered_cmp_not_equal_FLOAT(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 b = _mm_load_ps(&ip2[i]);
        __m128 c = _mm_cmpneq_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_not_equal_FLOAT(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_not_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_not_equal_FLOAT(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 c = _mm_cmpneq_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_not_equal_FLOAT(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_less_FLOAT(const npy_float a, const npy_float b)
{
    npy_float tmp;
    __m128 v = _mm_cmplt_ss(_mm_load_ss(&a),
                                     _mm_load_ss(&b));
    _mm_store_ss(&tmp, v);
    return sizeof(npy_float) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_less_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_less_FLOAT(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 b = _mm_loadu_ps(&ip2[i]);
        __m128 c = _mm_cmplt_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_FLOAT(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_less_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_float, 16) {
        op[i] = sse2_ordered_cmp_less_FLOAT(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 b = _mm_load_ps(&ip2[i]);
        __m128 c = _mm_cmplt_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_FLOAT(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_less_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_less_FLOAT(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 c = _mm_cmplt_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_FLOAT(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_less_equal_FLOAT(const npy_float a, const npy_float b)
{
    npy_float tmp;
    __m128 v = _mm_cmple_ss(_mm_load_ss(&a),
                                     _mm_load_ss(&b));
    _mm_store_ss(&tmp, v);
    return sizeof(npy_float) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_less_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_less_equal_FLOAT(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 b = _mm_loadu_ps(&ip2[i]);
        __m128 c = _mm_cmple_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_equal_FLOAT(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_less_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_float, 16) {
        op[i] = sse2_ordered_cmp_less_equal_FLOAT(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 b = _mm_load_ps(&ip2[i]);
        __m128 c = _mm_cmple_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_equal_FLOAT(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_less_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_less_equal_FLOAT(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 c = _mm_cmple_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_equal_FLOAT(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_greater_FLOAT(const npy_float a, const npy_float b)
{
    npy_float tmp;
    __m128 v = _mm_cmpgt_ss(_mm_load_ss(&a),
                                     _mm_load_ss(&b));
    _mm_store_ss(&tmp, v);
    return sizeof(npy_float) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_greater_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_greater_FLOAT(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 b = _mm_loadu_ps(&ip2[i]);
        __m128 c = _mm_cmpgt_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_FLOAT(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_greater_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_float, 16) {
        op[i] = sse2_ordered_cmp_greater_FLOAT(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 b = _mm_load_ps(&ip2[i]);
        __m128 c = _mm_cmpgt_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_FLOAT(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_greater_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_greater_FLOAT(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 c = _mm_cmpgt_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_FLOAT(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_greater_equal_FLOAT(const npy_float a, const npy_float b)
{
    npy_float tmp;
    __m128 v = _mm_cmpge_ss(_mm_load_ss(&a),
                                     _mm_load_ss(&b));
    _mm_store_ss(&tmp, v);
    return sizeof(npy_float) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_greater_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_greater_equal_FLOAT(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 b = _mm_loadu_ps(&ip2[i]);
        __m128 c = _mm_cmpge_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_equal_FLOAT(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_greater_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 a = _mm_set1_ps(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_float, 16) {
        op[i] = sse2_ordered_cmp_greater_equal_FLOAT(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 b = _mm_load_ps(&ip2[i]);
        __m128 c = _mm_cmpge_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_equal_FLOAT(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_greater_equal_FLOAT(npy_bool * op, npy_float * ip1, npy_float * ip2, npy_intp n)
{
    npy_bool * r;
    __m128 b = _mm_set1_ps(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_float, 16) {
        op[i] = sse2_ordered_cmp_greater_equal_FLOAT(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_float, 16) {
        __m128 a = _mm_load_ps(&ip1[i]);
        __m128 c = _mm_cmpge_ps(a, b);
        npy_int32 ir = fanout_4[_mm_movemask_ps(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_equal_FLOAT(ip1[i], ip2[0]);
    }
}


static void
sse2_sqrt_FLOAT(npy_float * op, npy_float * ip, const npy_intp n)
{
    /* align output to 16 bytes */
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16) {
        op[i] = npy_sqrtf(ip[i]);
    }
    assert(n < (16 / sizeof(npy_float)) || npy_is_aligned(&op[i], 16));
    if (npy_is_aligned(&ip[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 d = _mm_load_ps(&ip[i]);
            _mm_store_ps(&op[i], _mm_sqrt_ps(d));
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 d = _mm_loadu_ps(&ip[i]);
            _mm_store_ps(&op[i], _mm_sqrt_ps(d));
        }
    }
    LOOP_BLOCKED_END {
        op[i] = npy_sqrtf(ip[i]);
    }
}


static void
sse2_absolute_FLOAT(npy_float * op, npy_float * ip, const npy_intp n)
{
    /*
     * get 0x7FFFFFFF mask (everything but signbit set)
     * float & ~mask will remove the sign
     * this is equivalent to how the compiler implements fabs on amd64
     */
    const __m128 mask = _mm_set1_ps(-0.f);

    /* align output to 16 bytes */
    LOOP_BLOCK_ALIGN_VAR(op, npy_float, 16) {
        const npy_float tmp = ip[i] > 0 ? ip[i]: -ip[i];
        /* add 0 to clear -0.0 */
        op[i] = tmp + 0;
    }
    assert(n < (16 / sizeof(npy_float)) || npy_is_aligned(&op[i], 16));
    if (npy_is_aligned(&ip[i], 16)) {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_load_ps(&ip[i]);
            _mm_store_ps(&op[i], _mm_andnot_ps(mask, a));
        }
    }
    else {
        LOOP_BLOCKED(npy_float, 16) {
            __m128 a = _mm_loadu_ps(&ip[i]);
            _mm_store_ps(&op[i], _mm_andnot_ps(mask, a));
        }
    }
    LOOP_BLOCKED_END {
        const npy_float tmp = ip[i] > 0 ? ip[i]: -ip[i];
        /* add 0 to clear -0.0 */
        op[i] = tmp + 0;
    }
}


#line 659
/* arguments swapped as unary reduce has the swapped compared to unary */
static void
sse2_maximum_FLOAT(npy_float * ip, npy_float * op, const npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(ip, npy_float, 16) {
        *op = (*op >= ip[i] || npy_isnan(*op)) ? *op : ip[i];
    }
    assert(n < (16 / sizeof(npy_float)) || npy_is_aligned(&ip[i], 16));
    if (i + 2 * 16 / sizeof(npy_float) <= n) {
        /* load the first elements */
        __m128 c = _mm_load_ps((npy_float*)&ip[i]);
#ifdef NO_FLOATING_POINT_SUPPORT
        __m128 cnan = _mm_cmpneq_ps(c, c);
#else
        /* minps/minpd will set invalid flag if nan is encountered */
        PyUFunc_clearfperr();
#endif
        i += 16 / sizeof(npy_float);

        LOOP_BLOCKED(npy_float, 16) {
            __m128 v = _mm_load_ps((npy_float*)&ip[i]);
            c = _mm_max_ps(c, v);
#ifdef NO_FLOATING_POINT_SUPPORT
            /* check for nan, breaking the loop makes non nan case slow */
            cnan = _mm_or_ps(_mm_cmpneq_ps(v, v), cnan);
        }

        if (_mm_movemask_ps(cnan)) {
            *op = NPY_NANF;
            return;
        }
#else
        }
#endif
        {
            npy_float tmp = sse2_horizontal_max___m128(c);
            if (PyUFunc_getfperr() & UFUNC_FPE_INVALID)
                *op = NPY_NANF;
            else
                *op  = (*op >= tmp || npy_isnan(*op)) ? *op : tmp;
        }
    }
    LOOP_BLOCKED_END {
        *op  = (*op >= ip[i] || npy_isnan(*op)) ? *op : ip[i];
    }
}

#line 659
/* arguments swapped as unary reduce has the swapped compared to unary */
static void
sse2_minimum_FLOAT(npy_float * ip, npy_float * op, const npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(ip, npy_float, 16) {
        *op = (*op <= ip[i] || npy_isnan(*op)) ? *op : ip[i];
    }
    assert(n < (16 / sizeof(npy_float)) || npy_is_aligned(&ip[i], 16));
    if (i + 2 * 16 / sizeof(npy_float) <= n) {
        /* load the first elements */
        __m128 c = _mm_load_ps((npy_float*)&ip[i]);
#ifdef NO_FLOATING_POINT_SUPPORT
        __m128 cnan = _mm_cmpneq_ps(c, c);
#else
        /* minps/minpd will set invalid flag if nan is encountered */
        PyUFunc_clearfperr();
#endif
        i += 16 / sizeof(npy_float);

        LOOP_BLOCKED(npy_float, 16) {
            __m128 v = _mm_load_ps((npy_float*)&ip[i]);
            c = _mm_min_ps(c, v);
#ifdef NO_FLOATING_POINT_SUPPORT
            /* check for nan, breaking the loop makes non nan case slow */
            cnan = _mm_or_ps(_mm_cmpneq_ps(v, v), cnan);
        }

        if (_mm_movemask_ps(cnan)) {
            *op = NPY_NANF;
            return;
        }
#else
        }
#endif
        {
            npy_float tmp = sse2_horizontal_min___m128(c);
            if (PyUFunc_getfperr() & UFUNC_FPE_INVALID)
                *op = NPY_NANF;
            else
                *op  = (*op <= tmp || npy_isnan(*op)) ? *op : tmp;
        }
    }
    LOOP_BLOCKED_END {
        *op  = (*op <= ip[i] || npy_isnan(*op)) ? *op : ip[i];
    }
}



#line 380


#line 388

static void
sse2_binary_add_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[i] + ip2[i];
    /* lots of specializations, to squeeze out max performance */
    if (npy_is_aligned(&ip1[i], 16) && npy_is_aligned(&ip2[i], 16)) {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_load_pd(&ip1[i]);
                __m128d c = _mm_add_pd(a, a);
                _mm_store_pd(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_load_pd(&ip1[i]);
                __m128d b = _mm_load_pd(&ip2[i]);
                __m128d c = _mm_add_pd(a, b);
                _mm_store_pd(&op[i], c);
            }
        }
    }
    else if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip1[i]);
            __m128d b = _mm_loadu_pd(&ip2[i]);
            __m128d c = _mm_add_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip1[i]);
            __m128d b = _mm_load_pd(&ip2[i]);
            __m128d c = _mm_add_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_loadu_pd(&ip1[i]);
                __m128d c = _mm_add_pd(a, a);
                _mm_store_pd(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_loadu_pd(&ip1[i]);
                __m128d b = _mm_loadu_pd(&ip2[i]);
                __m128d c = _mm_add_pd(a, b);
                _mm_store_pd(&op[i], c);
            }
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] + ip2[i];
    }
}


static void
sse2_binary_scalar1_add_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    const __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[0] + ip2[i];
    if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d b = _mm_load_pd(&ip2[i]);
            __m128d c = _mm_add_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d b = _mm_loadu_pd(&ip2[i]);
            __m128d c = _mm_add_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[0] + ip2[i];
    }
}


static void
sse2_binary_scalar2_add_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    const __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[i] + ip2[0];
    if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip1[i]);
            __m128d c = _mm_add_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip1[i]);
            __m128d c = _mm_add_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] + ip2[0];
    }
}


#line 388

static void
sse2_binary_subtract_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[i] - ip2[i];
    /* lots of specializations, to squeeze out max performance */
    if (npy_is_aligned(&ip1[i], 16) && npy_is_aligned(&ip2[i], 16)) {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_load_pd(&ip1[i]);
                __m128d c = _mm_sub_pd(a, a);
                _mm_store_pd(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_load_pd(&ip1[i]);
                __m128d b = _mm_load_pd(&ip2[i]);
                __m128d c = _mm_sub_pd(a, b);
                _mm_store_pd(&op[i], c);
            }
        }
    }
    else if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip1[i]);
            __m128d b = _mm_loadu_pd(&ip2[i]);
            __m128d c = _mm_sub_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip1[i]);
            __m128d b = _mm_load_pd(&ip2[i]);
            __m128d c = _mm_sub_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_loadu_pd(&ip1[i]);
                __m128d c = _mm_sub_pd(a, a);
                _mm_store_pd(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_loadu_pd(&ip1[i]);
                __m128d b = _mm_loadu_pd(&ip2[i]);
                __m128d c = _mm_sub_pd(a, b);
                _mm_store_pd(&op[i], c);
            }
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] - ip2[i];
    }
}


static void
sse2_binary_scalar1_subtract_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    const __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[0] - ip2[i];
    if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d b = _mm_load_pd(&ip2[i]);
            __m128d c = _mm_sub_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d b = _mm_loadu_pd(&ip2[i]);
            __m128d c = _mm_sub_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[0] - ip2[i];
    }
}


static void
sse2_binary_scalar2_subtract_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    const __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[i] - ip2[0];
    if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip1[i]);
            __m128d c = _mm_sub_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip1[i]);
            __m128d c = _mm_sub_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] - ip2[0];
    }
}


#line 388

static void
sse2_binary_multiply_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[i] * ip2[i];
    /* lots of specializations, to squeeze out max performance */
    if (npy_is_aligned(&ip1[i], 16) && npy_is_aligned(&ip2[i], 16)) {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_load_pd(&ip1[i]);
                __m128d c = _mm_mul_pd(a, a);
                _mm_store_pd(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_load_pd(&ip1[i]);
                __m128d b = _mm_load_pd(&ip2[i]);
                __m128d c = _mm_mul_pd(a, b);
                _mm_store_pd(&op[i], c);
            }
        }
    }
    else if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip1[i]);
            __m128d b = _mm_loadu_pd(&ip2[i]);
            __m128d c = _mm_mul_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip1[i]);
            __m128d b = _mm_load_pd(&ip2[i]);
            __m128d c = _mm_mul_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_loadu_pd(&ip1[i]);
                __m128d c = _mm_mul_pd(a, a);
                _mm_store_pd(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_loadu_pd(&ip1[i]);
                __m128d b = _mm_loadu_pd(&ip2[i]);
                __m128d c = _mm_mul_pd(a, b);
                _mm_store_pd(&op[i], c);
            }
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] * ip2[i];
    }
}


static void
sse2_binary_scalar1_multiply_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    const __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[0] * ip2[i];
    if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d b = _mm_load_pd(&ip2[i]);
            __m128d c = _mm_mul_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d b = _mm_loadu_pd(&ip2[i]);
            __m128d c = _mm_mul_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[0] * ip2[i];
    }
}


static void
sse2_binary_scalar2_multiply_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    const __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[i] * ip2[0];
    if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip1[i]);
            __m128d c = _mm_mul_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip1[i]);
            __m128d c = _mm_mul_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] * ip2[0];
    }
}


#line 388

static void
sse2_binary_divide_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[i] / ip2[i];
    /* lots of specializations, to squeeze out max performance */
    if (npy_is_aligned(&ip1[i], 16) && npy_is_aligned(&ip2[i], 16)) {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_load_pd(&ip1[i]);
                __m128d c = _mm_div_pd(a, a);
                _mm_store_pd(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_load_pd(&ip1[i]);
                __m128d b = _mm_load_pd(&ip2[i]);
                __m128d c = _mm_div_pd(a, b);
                _mm_store_pd(&op[i], c);
            }
        }
    }
    else if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip1[i]);
            __m128d b = _mm_loadu_pd(&ip2[i]);
            __m128d c = _mm_div_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip1[i]);
            __m128d b = _mm_load_pd(&ip2[i]);
            __m128d c = _mm_div_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        if (ip1 == ip2) {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_loadu_pd(&ip1[i]);
                __m128d c = _mm_div_pd(a, a);
                _mm_store_pd(&op[i], c);
            }
        }
        else {
            LOOP_BLOCKED(npy_double, 16) {
                __m128d a = _mm_loadu_pd(&ip1[i]);
                __m128d b = _mm_loadu_pd(&ip2[i]);
                __m128d c = _mm_div_pd(a, b);
                _mm_store_pd(&op[i], c);
            }
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] / ip2[i];
    }
}


static void
sse2_binary_scalar1_divide_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    const __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[0] / ip2[i];
    if (npy_is_aligned(&ip2[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d b = _mm_load_pd(&ip2[i]);
            __m128d c = _mm_div_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d b = _mm_loadu_pd(&ip2[i]);
            __m128d c = _mm_div_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[0] / ip2[i];
    }
}


static void
sse2_binary_scalar2_divide_DOUBLE(npy_double * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    const __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16)
        op[i] = ip1[i] / ip2[0];
    if (npy_is_aligned(&ip1[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip1[i]);
            __m128d c = _mm_div_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip1[i]);
            __m128d c = _mm_div_pd(a, b);
            _mm_store_pd(&op[i], c);
        }
    }
    LOOP_BLOCKED_END {
        op[i] = ip1[i] / ip2[0];
    }
}



#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_equal_DOUBLE(const npy_double a, const npy_double b)
{
    npy_double tmp;
    __m128d v = _mm_cmpeq_sd(_mm_load_sd(&a),
                                     _mm_load_sd(&b));
    _mm_store_sd(&tmp, v);
    return sizeof(npy_double) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_equal_DOUBLE(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d b = _mm_loadu_pd(&ip2[i]);
        __m128d c = _mm_cmpeq_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_equal_DOUBLE(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_double, 16) {
        op[i] = sse2_ordered_cmp_equal_DOUBLE(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d b = _mm_load_pd(&ip2[i]);
        __m128d c = _mm_cmpeq_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_equal_DOUBLE(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_equal_DOUBLE(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d c = _mm_cmpeq_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_equal_DOUBLE(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_not_equal_DOUBLE(const npy_double a, const npy_double b)
{
    npy_double tmp;
    __m128d v = _mm_cmpneq_sd(_mm_load_sd(&a),
                                     _mm_load_sd(&b));
    _mm_store_sd(&tmp, v);
    return sizeof(npy_double) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_not_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_not_equal_DOUBLE(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d b = _mm_loadu_pd(&ip2[i]);
        __m128d c = _mm_cmpneq_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_not_equal_DOUBLE(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_not_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_double, 16) {
        op[i] = sse2_ordered_cmp_not_equal_DOUBLE(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d b = _mm_load_pd(&ip2[i]);
        __m128d c = _mm_cmpneq_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_not_equal_DOUBLE(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_not_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_not_equal_DOUBLE(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d c = _mm_cmpneq_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_not_equal_DOUBLE(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_less_DOUBLE(const npy_double a, const npy_double b)
{
    npy_double tmp;
    __m128d v = _mm_cmplt_sd(_mm_load_sd(&a),
                                     _mm_load_sd(&b));
    _mm_store_sd(&tmp, v);
    return sizeof(npy_double) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_less_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_less_DOUBLE(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d b = _mm_loadu_pd(&ip2[i]);
        __m128d c = _mm_cmplt_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_DOUBLE(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_less_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_double, 16) {
        op[i] = sse2_ordered_cmp_less_DOUBLE(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d b = _mm_load_pd(&ip2[i]);
        __m128d c = _mm_cmplt_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_DOUBLE(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_less_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_less_DOUBLE(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d c = _mm_cmplt_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_DOUBLE(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_less_equal_DOUBLE(const npy_double a, const npy_double b)
{
    npy_double tmp;
    __m128d v = _mm_cmple_sd(_mm_load_sd(&a),
                                     _mm_load_sd(&b));
    _mm_store_sd(&tmp, v);
    return sizeof(npy_double) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_less_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_less_equal_DOUBLE(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d b = _mm_loadu_pd(&ip2[i]);
        __m128d c = _mm_cmple_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_equal_DOUBLE(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_less_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_double, 16) {
        op[i] = sse2_ordered_cmp_less_equal_DOUBLE(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d b = _mm_load_pd(&ip2[i]);
        __m128d c = _mm_cmple_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_equal_DOUBLE(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_less_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_less_equal_DOUBLE(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d c = _mm_cmple_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_less_equal_DOUBLE(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_greater_DOUBLE(const npy_double a, const npy_double b)
{
    npy_double tmp;
    __m128d v = _mm_cmpgt_sd(_mm_load_sd(&a),
                                     _mm_load_sd(&b));
    _mm_store_sd(&tmp, v);
    return sizeof(npy_double) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_greater_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_greater_DOUBLE(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d b = _mm_loadu_pd(&ip2[i]);
        __m128d c = _mm_cmpgt_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_DOUBLE(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_greater_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_double, 16) {
        op[i] = sse2_ordered_cmp_greater_DOUBLE(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d b = _mm_load_pd(&ip2[i]);
        __m128d c = _mm_cmpgt_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_DOUBLE(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_greater_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_greater_DOUBLE(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d c = _mm_cmpgt_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_DOUBLE(ip1[i], ip2[0]);
    }
}

#line 509

/* sets invalid fpu flag on QNaN for consistency with packed compare */
static NPY_INLINE int
sse2_ordered_cmp_greater_equal_DOUBLE(const npy_double a, const npy_double b)
{
    npy_double tmp;
    __m128d v = _mm_cmpge_sd(_mm_load_sd(&a),
                                     _mm_load_sd(&b));
    _mm_store_sd(&tmp, v);
    return sizeof(npy_double) == 4 ?
        (*(npy_uint32 *)&tmp) & 1 : (*(npy_uint64 *)&tmp) & 1;
}

static void
sse2_binary_greater_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_greater_equal_DOUBLE(ip1[i], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d b = _mm_loadu_pd(&ip2[i]);
        __m128d c = _mm_cmpge_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_equal_DOUBLE(ip1[i], ip2[i]);
    }
}


static void
sse2_binary_scalar1_greater_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d a = _mm_set1_pd(ip1[0]);
    LOOP_BLOCK_ALIGN_VAR(ip2, npy_double, 16) {
        op[i] = sse2_ordered_cmp_greater_equal_DOUBLE(ip1[0], ip2[i]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d b = _mm_load_pd(&ip2[i]);
        __m128d c = _mm_cmpge_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_equal_DOUBLE(ip1[0], ip2[i]);
    }
}


static void
sse2_binary_scalar2_greater_equal_DOUBLE(npy_bool * op, npy_double * ip1, npy_double * ip2, npy_intp n)
{
    npy_bool * r;
    __m128d b = _mm_set1_pd(ip2[0]);
    LOOP_BLOCK_ALIGN_VAR(ip1, npy_double, 16) {
        op[i] = sse2_ordered_cmp_greater_equal_DOUBLE(ip1[i], ip2[0]);
    }
    r = &op[i];
    LOOP_BLOCKED(npy_double, 16) {
        __m128d a = _mm_load_pd(&ip1[i]);
        __m128d c = _mm_cmpge_pd(a, b);
        npy_int16 ir = fanout_2[_mm_movemask_pd(c)];
        /* may be unaligned */
        memcpy(r, &ir, sizeof(ir));
        r += sizeof(ir);
    }
    LOOP_BLOCKED_END {
        op[i] = sse2_ordered_cmp_greater_equal_DOUBLE(ip1[i], ip2[0]);
    }
}


static void
sse2_sqrt_DOUBLE(npy_double * op, npy_double * ip, const npy_intp n)
{
    /* align output to 16 bytes */
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16) {
        op[i] = npy_sqrt(ip[i]);
    }
    assert(n < (16 / sizeof(npy_double)) || npy_is_aligned(&op[i], 16));
    if (npy_is_aligned(&ip[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d d = _mm_load_pd(&ip[i]);
            _mm_store_pd(&op[i], _mm_sqrt_pd(d));
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d d = _mm_loadu_pd(&ip[i]);
            _mm_store_pd(&op[i], _mm_sqrt_pd(d));
        }
    }
    LOOP_BLOCKED_END {
        op[i] = npy_sqrt(ip[i]);
    }
}


static void
sse2_absolute_DOUBLE(npy_double * op, npy_double * ip, const npy_intp n)
{
    /*
     * get 0x7FFFFFFF mask (everything but signbit set)
     * float & ~mask will remove the sign
     * this is equivalent to how the compiler implements fabs on amd64
     */
    const __m128d mask = _mm_set1_pd(-0.);

    /* align output to 16 bytes */
    LOOP_BLOCK_ALIGN_VAR(op, npy_double, 16) {
        const npy_double tmp = ip[i] > 0 ? ip[i]: -ip[i];
        /* add 0 to clear -0.0 */
        op[i] = tmp + 0;
    }
    assert(n < (16 / sizeof(npy_double)) || npy_is_aligned(&op[i], 16));
    if (npy_is_aligned(&ip[i], 16)) {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_load_pd(&ip[i]);
            _mm_store_pd(&op[i], _mm_andnot_pd(mask, a));
        }
    }
    else {
        LOOP_BLOCKED(npy_double, 16) {
            __m128d a = _mm_loadu_pd(&ip[i]);
            _mm_store_pd(&op[i], _mm_andnot_pd(mask, a));
        }
    }
    LOOP_BLOCKED_END {
        const npy_double tmp = ip[i] > 0 ? ip[i]: -ip[i];
        /* add 0 to clear -0.0 */
        op[i] = tmp + 0;
    }
}


#line 659
/* arguments swapped as unary reduce has the swapped compared to unary */
static void
sse2_maximum_DOUBLE(npy_double * ip, npy_double * op, const npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(ip, npy_double, 16) {
        *op = (*op >= ip[i] || npy_isnan(*op)) ? *op : ip[i];
    }
    assert(n < (16 / sizeof(npy_double)) || npy_is_aligned(&ip[i], 16));
    if (i + 2 * 16 / sizeof(npy_double) <= n) {
        /* load the first elements */
        __m128d c = _mm_load_pd((npy_double*)&ip[i]);
#ifdef NO_FLOATING_POINT_SUPPORT
        __m128d cnan = _mm_cmpneq_pd(c, c);
#else
        /* minps/minpd will set invalid flag if nan is encountered */
        PyUFunc_clearfperr();
#endif
        i += 16 / sizeof(npy_double);

        LOOP_BLOCKED(npy_double, 16) {
            __m128d v = _mm_load_pd((npy_double*)&ip[i]);
            c = _mm_max_pd(c, v);
#ifdef NO_FLOATING_POINT_SUPPORT
            /* check for nan, breaking the loop makes non nan case slow */
            cnan = _mm_or_pd(_mm_cmpneq_pd(v, v), cnan);
        }

        if (_mm_movemask_pd(cnan)) {
            *op = NPY_NAN;
            return;
        }
#else
        }
#endif
        {
            npy_double tmp = sse2_horizontal_max___m128d(c);
            if (PyUFunc_getfperr() & UFUNC_FPE_INVALID)
                *op = NPY_NAN;
            else
                *op  = (*op >= tmp || npy_isnan(*op)) ? *op : tmp;
        }
    }
    LOOP_BLOCKED_END {
        *op  = (*op >= ip[i] || npy_isnan(*op)) ? *op : ip[i];
    }
}

#line 659
/* arguments swapped as unary reduce has the swapped compared to unary */
static void
sse2_minimum_DOUBLE(npy_double * ip, npy_double * op, const npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(ip, npy_double, 16) {
        *op = (*op <= ip[i] || npy_isnan(*op)) ? *op : ip[i];
    }
    assert(n < (16 / sizeof(npy_double)) || npy_is_aligned(&ip[i], 16));
    if (i + 2 * 16 / sizeof(npy_double) <= n) {
        /* load the first elements */
        __m128d c = _mm_load_pd((npy_double*)&ip[i]);
#ifdef NO_FLOATING_POINT_SUPPORT
        __m128d cnan = _mm_cmpneq_pd(c, c);
#else
        /* minps/minpd will set invalid flag if nan is encountered */
        PyUFunc_clearfperr();
#endif
        i += 16 / sizeof(npy_double);

        LOOP_BLOCKED(npy_double, 16) {
            __m128d v = _mm_load_pd((npy_double*)&ip[i]);
            c = _mm_min_pd(c, v);
#ifdef NO_FLOATING_POINT_SUPPORT
            /* check for nan, breaking the loop makes non nan case slow */
            cnan = _mm_or_pd(_mm_cmpneq_pd(v, v), cnan);
        }

        if (_mm_movemask_pd(cnan)) {
            *op = NPY_NAN;
            return;
        }
#else
        }
#endif
        {
            npy_double tmp = sse2_horizontal_min___m128d(c);
            if (PyUFunc_getfperr() & UFUNC_FPE_INVALID)
                *op = NPY_NAN;
            else
                *op  = (*op <= tmp || npy_isnan(*op)) ? *op : tmp;
        }
    }
    LOOP_BLOCKED_END {
        *op  = (*op <= ip[i] || npy_isnan(*op)) ? *op : ip[i];
    }
}




/*
 *****************************************************************************
 **                           BOOL LOOPS
 *****************************************************************************
 */

#line 728

/*
 * convert any bit set to boolean true so vectorized and normal operations are
 * consistent, should not be required if bool is used correctly everywhere but
 * you never know
 */
#if !0
static NPY_INLINE __m128i byte_to_true(__m128i v)
{
    const __m128i zero = _mm_setzero_si128();
    const __m128i truemask = _mm_set1_epi8(1 == 1);
    /* get 0xFF for zeros */
    __m128i tmp = _mm_cmpeq_epi8(v, zero);
    /* filled with 0xFF/0x00, negate and mask to boolean true */
    return _mm_andnot_si128(tmp, truemask);
}
#endif

static void
sse2_binary_logical_or_BOOL(npy_bool * op, npy_bool * ip1, npy_bool * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_bool, 16)
        op[i] = ip1[i] || ip2[i];
    LOOP_BLOCKED(npy_bool, 16) {
        __m128i a = _mm_loadu_si128((__m128i*)&ip1[i]);
        __m128i b = _mm_loadu_si128((__m128i*)&ip2[i]);
#if 0
        const __m128i zero = _mm_setzero_si128();
        /* get 0xFF for non zeros*/
        __m128i tmp = _mm_cmpeq_epi8(a, zero);
        /* andnot -> 0x00 for zeros xFF for non zeros, & with ip2 */
        tmp = _mm_andnot_si128(tmp, b);
#else
        __m128i tmp = _mm_or_si128(a, b);
#endif

        _mm_store_si128((__m128i*)&op[i], byte_to_true(tmp));
    }
    LOOP_BLOCKED_END {
        op[i] = (ip1[i] || ip2[i]);
    }
}


static void
sse2_reduce_logical_or_BOOL(npy_bool * op, npy_bool * ip, const npy_intp n)
{
    const __m128i zero = _mm_setzero_si128();
    LOOP_BLOCK_ALIGN_VAR(ip, npy_bool, 16) {
        *op = *op || ip[i];
        if (*op != 0) {
            return;
        }
    }
    /* unrolled once to replace a slow movmsk with a fast pmaxb */
    LOOP_BLOCKED(npy_bool, 32) {
        __m128i v = _mm_load_si128((__m128i*)&ip[i]);
        __m128i v2 = _mm_load_si128((__m128i*)&ip[i + 16]);
        v = _mm_cmpeq_epi8(v, zero);
        v2 = _mm_cmpeq_epi8(v2, zero);
#if 0
        if ((_mm_movemask_epi8(_mm_max_epu8(v, v2)) != 0)) {
            *op = 0;
#else
        if ((_mm_movemask_epi8(_mm_min_epu8(v, v2)) != 0xFFFF)) {
            *op = 1;
#endif
            return;
        }
    }
    LOOP_BLOCKED_END {
        *op = *op || ip[i];
        if (*op != 0) {
            return;
        }
    }
}


#line 728

/*
 * convert any bit set to boolean true so vectorized and normal operations are
 * consistent, should not be required if bool is used correctly everywhere but
 * you never know
 */
#if !1
static NPY_INLINE __m128i byte_to_true(__m128i v)
{
    const __m128i zero = _mm_setzero_si128();
    const __m128i truemask = _mm_set1_epi8(1 == 1);
    /* get 0xFF for zeros */
    __m128i tmp = _mm_cmpeq_epi8(v, zero);
    /* filled with 0xFF/0x00, negate and mask to boolean true */
    return _mm_andnot_si128(tmp, truemask);
}
#endif

static void
sse2_binary_logical_and_BOOL(npy_bool * op, npy_bool * ip1, npy_bool * ip2, npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_bool, 16)
        op[i] = ip1[i] && ip2[i];
    LOOP_BLOCKED(npy_bool, 16) {
        __m128i a = _mm_loadu_si128((__m128i*)&ip1[i]);
        __m128i b = _mm_loadu_si128((__m128i*)&ip2[i]);
#if 1
        const __m128i zero = _mm_setzero_si128();
        /* get 0xFF for non zeros*/
        __m128i tmp = _mm_cmpeq_epi8(a, zero);
        /* andnot -> 0x00 for zeros xFF for non zeros, & with ip2 */
        tmp = _mm_andnot_si128(tmp, b);
#else
        __m128i tmp = _mm_or_si128(a, b);
#endif

        _mm_store_si128((__m128i*)&op[i], byte_to_true(tmp));
    }
    LOOP_BLOCKED_END {
        op[i] = (ip1[i] && ip2[i]);
    }
}


static void
sse2_reduce_logical_and_BOOL(npy_bool * op, npy_bool * ip, const npy_intp n)
{
    const __m128i zero = _mm_setzero_si128();
    LOOP_BLOCK_ALIGN_VAR(ip, npy_bool, 16) {
        *op = *op && ip[i];
        if (*op == 0) {
            return;
        }
    }
    /* unrolled once to replace a slow movmsk with a fast pmaxb */
    LOOP_BLOCKED(npy_bool, 32) {
        __m128i v = _mm_load_si128((__m128i*)&ip[i]);
        __m128i v2 = _mm_load_si128((__m128i*)&ip[i + 16]);
        v = _mm_cmpeq_epi8(v, zero);
        v2 = _mm_cmpeq_epi8(v2, zero);
#if 1
        if ((_mm_movemask_epi8(_mm_max_epu8(v, v2)) != 0)) {
            *op = 0;
#else
        if ((_mm_movemask_epi8(_mm_min_epu8(v, v2)) != 0xFFFF)) {
            *op = 1;
#endif
            return;
        }
    }
    LOOP_BLOCKED_END {
        *op = *op && ip[i];
        if (*op == 0) {
            return;
        }
    }
}



#line 819

static void
sse2_absolute_BOOL(npy_bool * op, npy_bool * ip, const npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_bool, 16)
        op[i] = (ip[i] != 0);
    LOOP_BLOCKED(npy_bool, 16) {
        __m128i a = _mm_loadu_si128((__m128i*)&ip[i]);
#if 0
        const __m128i zero = _mm_setzero_si128();
        const __m128i truemask = _mm_set1_epi8(1 == 1);
        /* equivalent to byte_to_true but can skip the negation */
        a = _mm_cmpeq_epi8(a, zero);
        a = _mm_and_si128(a, truemask);
#else
        /* abs is kind of pointless but maybe its used for byte_to_true */
        a = byte_to_true(a);
#endif
        _mm_store_si128((__m128i*)&op[i], a);
    }
    LOOP_BLOCKED_END {
        op[i] = (ip[i] != 0);
    }
}


#line 819

static void
sse2_logical_not_BOOL(npy_bool * op, npy_bool * ip, const npy_intp n)
{
    LOOP_BLOCK_ALIGN_VAR(op, npy_bool, 16)
        op[i] = (ip[i] == 0);
    LOOP_BLOCKED(npy_bool, 16) {
        __m128i a = _mm_loadu_si128((__m128i*)&ip[i]);
#if 1
        const __m128i zero = _mm_setzero_si128();
        const __m128i truemask = _mm_set1_epi8(1 == 1);
        /* equivalent to byte_to_true but can skip the negation */
        a = _mm_cmpeq_epi8(a, zero);
        a = _mm_and_si128(a, truemask);
#else
        /* abs is kind of pointless but maybe its used for byte_to_true */
        a = byte_to_true(a);
#endif
        _mm_store_si128((__m128i*)&op[i], a);
    }
    LOOP_BLOCKED_END {
        op[i] = (ip[i] == 0);
    }
}



#endif /* NPY_HAVE_SSE2_INTRINSICS */

#endif

