#line 1 "numpy/core/src/npysort/quicksort.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */

/*
 * The purpose of this module is to add faster sort functions
 * that are type-specific.  This is done by altering the
 * function table for the builtin descriptors.
 *
 * These sorting functions are copied almost directly from numarray
 * with a few modifications (complex comparisons compare the imaginary
 * part if the real parts are equal, for example), and the names
 * are changed.
 *
 * The original sorting code is due to Charles R. Harris who wrote
 * it for numarray.
 */

/*
 * Quick sort is usually the fastest, but the worst case scenario can
 * be slower than the merge and heap sorts.  The merge sort requires
 * extra memory and so for large arrays may not be useful.
 *
 * The merge sort is *stable*, meaning that equal components
 * are unmoved from their entry versions, so it can be used to
 * implement lexigraphic sorting on multiple keys.
 *
 * The heap sort is included for completeness.
 */

#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include <stdlib.h>
#include "npy_sort.h"
#include "npysort_common.h"

#define NOT_USED NPY_UNUSED(unused)
#define PYA_QS_STACK 100
#define SMALL_QUICKSORT 15
#define SMALL_MERGESORT 20
#define SMALL_STRING 16


/*
 *****************************************************************************
 **                            NUMERIC SORTS                                **
 *****************************************************************************
 */


#line 62

int
quicksort_bool(npy_bool *start, npy_intp num, void *NOT_USED)
{
    npy_bool vp;
    npy_bool *pl = start;
    npy_bool *pr = start + num - 1;
    npy_bool *stack[PYA_QS_STACK];
    npy_bool **sptr = stack;
    npy_bool *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (BOOL_LT(*pm, *pl)) BOOL_SWAP(*pm, *pl);
            if (BOOL_LT(*pr, *pm)) BOOL_SWAP(*pr, *pm);
            if (BOOL_LT(*pm, *pl)) BOOL_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            BOOL_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (BOOL_LT(*pi, vp));
                do --pj; while (BOOL_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                BOOL_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            BOOL_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && BOOL_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_bool(npy_bool *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_bool vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (BOOL_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (BOOL_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (BOOL_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (BOOL_LT(v[*pi], vp));
                do --pj; while (BOOL_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && BOOL_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_byte(npy_byte *start, npy_intp num, void *NOT_USED)
{
    npy_byte vp;
    npy_byte *pl = start;
    npy_byte *pr = start + num - 1;
    npy_byte *stack[PYA_QS_STACK];
    npy_byte **sptr = stack;
    npy_byte *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (BYTE_LT(*pm, *pl)) BYTE_SWAP(*pm, *pl);
            if (BYTE_LT(*pr, *pm)) BYTE_SWAP(*pr, *pm);
            if (BYTE_LT(*pm, *pl)) BYTE_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            BYTE_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (BYTE_LT(*pi, vp));
                do --pj; while (BYTE_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                BYTE_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            BYTE_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && BYTE_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_byte(npy_byte *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_byte vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (BYTE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (BYTE_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (BYTE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (BYTE_LT(v[*pi], vp));
                do --pj; while (BYTE_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && BYTE_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_ubyte(npy_ubyte *start, npy_intp num, void *NOT_USED)
{
    npy_ubyte vp;
    npy_ubyte *pl = start;
    npy_ubyte *pr = start + num - 1;
    npy_ubyte *stack[PYA_QS_STACK];
    npy_ubyte **sptr = stack;
    npy_ubyte *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (UBYTE_LT(*pm, *pl)) UBYTE_SWAP(*pm, *pl);
            if (UBYTE_LT(*pr, *pm)) UBYTE_SWAP(*pr, *pm);
            if (UBYTE_LT(*pm, *pl)) UBYTE_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            UBYTE_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (UBYTE_LT(*pi, vp));
                do --pj; while (UBYTE_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                UBYTE_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            UBYTE_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && UBYTE_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_ubyte(npy_ubyte *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_ubyte vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (UBYTE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (UBYTE_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (UBYTE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (UBYTE_LT(v[*pi], vp));
                do --pj; while (UBYTE_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && UBYTE_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_short(npy_short *start, npy_intp num, void *NOT_USED)
{
    npy_short vp;
    npy_short *pl = start;
    npy_short *pr = start + num - 1;
    npy_short *stack[PYA_QS_STACK];
    npy_short **sptr = stack;
    npy_short *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (SHORT_LT(*pm, *pl)) SHORT_SWAP(*pm, *pl);
            if (SHORT_LT(*pr, *pm)) SHORT_SWAP(*pr, *pm);
            if (SHORT_LT(*pm, *pl)) SHORT_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            SHORT_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (SHORT_LT(*pi, vp));
                do --pj; while (SHORT_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                SHORT_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            SHORT_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && SHORT_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_short(npy_short *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_short vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (SHORT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (SHORT_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (SHORT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (SHORT_LT(v[*pi], vp));
                do --pj; while (SHORT_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && SHORT_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_ushort(npy_ushort *start, npy_intp num, void *NOT_USED)
{
    npy_ushort vp;
    npy_ushort *pl = start;
    npy_ushort *pr = start + num - 1;
    npy_ushort *stack[PYA_QS_STACK];
    npy_ushort **sptr = stack;
    npy_ushort *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (USHORT_LT(*pm, *pl)) USHORT_SWAP(*pm, *pl);
            if (USHORT_LT(*pr, *pm)) USHORT_SWAP(*pr, *pm);
            if (USHORT_LT(*pm, *pl)) USHORT_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            USHORT_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (USHORT_LT(*pi, vp));
                do --pj; while (USHORT_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                USHORT_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            USHORT_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && USHORT_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_ushort(npy_ushort *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_ushort vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (USHORT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (USHORT_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (USHORT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (USHORT_LT(v[*pi], vp));
                do --pj; while (USHORT_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && USHORT_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_int(npy_int *start, npy_intp num, void *NOT_USED)
{
    npy_int vp;
    npy_int *pl = start;
    npy_int *pr = start + num - 1;
    npy_int *stack[PYA_QS_STACK];
    npy_int **sptr = stack;
    npy_int *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (INT_LT(*pm, *pl)) INT_SWAP(*pm, *pl);
            if (INT_LT(*pr, *pm)) INT_SWAP(*pr, *pm);
            if (INT_LT(*pm, *pl)) INT_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            INT_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (INT_LT(*pi, vp));
                do --pj; while (INT_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                INT_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            INT_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && INT_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_int(npy_int *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_int vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (INT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (INT_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (INT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (INT_LT(v[*pi], vp));
                do --pj; while (INT_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && INT_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_uint(npy_uint *start, npy_intp num, void *NOT_USED)
{
    npy_uint vp;
    npy_uint *pl = start;
    npy_uint *pr = start + num - 1;
    npy_uint *stack[PYA_QS_STACK];
    npy_uint **sptr = stack;
    npy_uint *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (UINT_LT(*pm, *pl)) UINT_SWAP(*pm, *pl);
            if (UINT_LT(*pr, *pm)) UINT_SWAP(*pr, *pm);
            if (UINT_LT(*pm, *pl)) UINT_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            UINT_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (UINT_LT(*pi, vp));
                do --pj; while (UINT_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                UINT_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            UINT_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && UINT_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_uint(npy_uint *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_uint vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (UINT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (UINT_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (UINT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (UINT_LT(v[*pi], vp));
                do --pj; while (UINT_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && UINT_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_long(npy_long *start, npy_intp num, void *NOT_USED)
{
    npy_long vp;
    npy_long *pl = start;
    npy_long *pr = start + num - 1;
    npy_long *stack[PYA_QS_STACK];
    npy_long **sptr = stack;
    npy_long *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (LONG_LT(*pm, *pl)) LONG_SWAP(*pm, *pl);
            if (LONG_LT(*pr, *pm)) LONG_SWAP(*pr, *pm);
            if (LONG_LT(*pm, *pl)) LONG_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            LONG_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (LONG_LT(*pi, vp));
                do --pj; while (LONG_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                LONG_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            LONG_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && LONG_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_long(npy_long *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_long vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (LONG_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (LONG_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (LONG_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (LONG_LT(v[*pi], vp));
                do --pj; while (LONG_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && LONG_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_ulong(npy_ulong *start, npy_intp num, void *NOT_USED)
{
    npy_ulong vp;
    npy_ulong *pl = start;
    npy_ulong *pr = start + num - 1;
    npy_ulong *stack[PYA_QS_STACK];
    npy_ulong **sptr = stack;
    npy_ulong *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (ULONG_LT(*pm, *pl)) ULONG_SWAP(*pm, *pl);
            if (ULONG_LT(*pr, *pm)) ULONG_SWAP(*pr, *pm);
            if (ULONG_LT(*pm, *pl)) ULONG_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            ULONG_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (ULONG_LT(*pi, vp));
                do --pj; while (ULONG_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                ULONG_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            ULONG_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && ULONG_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_ulong(npy_ulong *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_ulong vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (ULONG_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (ULONG_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (ULONG_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (ULONG_LT(v[*pi], vp));
                do --pj; while (ULONG_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && ULONG_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_longlong(npy_longlong *start, npy_intp num, void *NOT_USED)
{
    npy_longlong vp;
    npy_longlong *pl = start;
    npy_longlong *pr = start + num - 1;
    npy_longlong *stack[PYA_QS_STACK];
    npy_longlong **sptr = stack;
    npy_longlong *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (LONGLONG_LT(*pm, *pl)) LONGLONG_SWAP(*pm, *pl);
            if (LONGLONG_LT(*pr, *pm)) LONGLONG_SWAP(*pr, *pm);
            if (LONGLONG_LT(*pm, *pl)) LONGLONG_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            LONGLONG_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (LONGLONG_LT(*pi, vp));
                do --pj; while (LONGLONG_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                LONGLONG_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            LONGLONG_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && LONGLONG_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_longlong(npy_longlong *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_longlong vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (LONGLONG_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (LONGLONG_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (LONGLONG_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (LONGLONG_LT(v[*pi], vp));
                do --pj; while (LONGLONG_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && LONGLONG_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_ulonglong(npy_ulonglong *start, npy_intp num, void *NOT_USED)
{
    npy_ulonglong vp;
    npy_ulonglong *pl = start;
    npy_ulonglong *pr = start + num - 1;
    npy_ulonglong *stack[PYA_QS_STACK];
    npy_ulonglong **sptr = stack;
    npy_ulonglong *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (ULONGLONG_LT(*pm, *pl)) ULONGLONG_SWAP(*pm, *pl);
            if (ULONGLONG_LT(*pr, *pm)) ULONGLONG_SWAP(*pr, *pm);
            if (ULONGLONG_LT(*pm, *pl)) ULONGLONG_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            ULONGLONG_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (ULONGLONG_LT(*pi, vp));
                do --pj; while (ULONGLONG_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                ULONGLONG_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            ULONGLONG_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && ULONGLONG_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_ulonglong(npy_ulonglong *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_ulonglong vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (ULONGLONG_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (ULONGLONG_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (ULONGLONG_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (ULONGLONG_LT(v[*pi], vp));
                do --pj; while (ULONGLONG_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && ULONGLONG_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_half(npy_ushort *start, npy_intp num, void *NOT_USED)
{
    npy_ushort vp;
    npy_ushort *pl = start;
    npy_ushort *pr = start + num - 1;
    npy_ushort *stack[PYA_QS_STACK];
    npy_ushort **sptr = stack;
    npy_ushort *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (HALF_LT(*pm, *pl)) HALF_SWAP(*pm, *pl);
            if (HALF_LT(*pr, *pm)) HALF_SWAP(*pr, *pm);
            if (HALF_LT(*pm, *pl)) HALF_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            HALF_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (HALF_LT(*pi, vp));
                do --pj; while (HALF_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                HALF_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            HALF_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && HALF_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_half(npy_ushort *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_ushort vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (HALF_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (HALF_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (HALF_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (HALF_LT(v[*pi], vp));
                do --pj; while (HALF_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && HALF_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_float(npy_float *start, npy_intp num, void *NOT_USED)
{
    npy_float vp;
    npy_float *pl = start;
    npy_float *pr = start + num - 1;
    npy_float *stack[PYA_QS_STACK];
    npy_float **sptr = stack;
    npy_float *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (FLOAT_LT(*pm, *pl)) FLOAT_SWAP(*pm, *pl);
            if (FLOAT_LT(*pr, *pm)) FLOAT_SWAP(*pr, *pm);
            if (FLOAT_LT(*pm, *pl)) FLOAT_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            FLOAT_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (FLOAT_LT(*pi, vp));
                do --pj; while (FLOAT_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                FLOAT_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            FLOAT_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && FLOAT_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_float(npy_float *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_float vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (FLOAT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (FLOAT_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (FLOAT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (FLOAT_LT(v[*pi], vp));
                do --pj; while (FLOAT_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && FLOAT_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_double(npy_double *start, npy_intp num, void *NOT_USED)
{
    npy_double vp;
    npy_double *pl = start;
    npy_double *pr = start + num - 1;
    npy_double *stack[PYA_QS_STACK];
    npy_double **sptr = stack;
    npy_double *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (DOUBLE_LT(*pm, *pl)) DOUBLE_SWAP(*pm, *pl);
            if (DOUBLE_LT(*pr, *pm)) DOUBLE_SWAP(*pr, *pm);
            if (DOUBLE_LT(*pm, *pl)) DOUBLE_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            DOUBLE_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (DOUBLE_LT(*pi, vp));
                do --pj; while (DOUBLE_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                DOUBLE_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            DOUBLE_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && DOUBLE_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_double(npy_double *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_double vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (DOUBLE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (DOUBLE_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (DOUBLE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (DOUBLE_LT(v[*pi], vp));
                do --pj; while (DOUBLE_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && DOUBLE_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_longdouble(npy_longdouble *start, npy_intp num, void *NOT_USED)
{
    npy_longdouble vp;
    npy_longdouble *pl = start;
    npy_longdouble *pr = start + num - 1;
    npy_longdouble *stack[PYA_QS_STACK];
    npy_longdouble **sptr = stack;
    npy_longdouble *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (LONGDOUBLE_LT(*pm, *pl)) LONGDOUBLE_SWAP(*pm, *pl);
            if (LONGDOUBLE_LT(*pr, *pm)) LONGDOUBLE_SWAP(*pr, *pm);
            if (LONGDOUBLE_LT(*pm, *pl)) LONGDOUBLE_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            LONGDOUBLE_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (LONGDOUBLE_LT(*pi, vp));
                do --pj; while (LONGDOUBLE_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                LONGDOUBLE_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            LONGDOUBLE_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && LONGDOUBLE_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_longdouble(npy_longdouble *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_longdouble vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (LONGDOUBLE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (LONGDOUBLE_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (LONGDOUBLE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (LONGDOUBLE_LT(v[*pi], vp));
                do --pj; while (LONGDOUBLE_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && LONGDOUBLE_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_cfloat(npy_cfloat *start, npy_intp num, void *NOT_USED)
{
    npy_cfloat vp;
    npy_cfloat *pl = start;
    npy_cfloat *pr = start + num - 1;
    npy_cfloat *stack[PYA_QS_STACK];
    npy_cfloat **sptr = stack;
    npy_cfloat *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (CFLOAT_LT(*pm, *pl)) CFLOAT_SWAP(*pm, *pl);
            if (CFLOAT_LT(*pr, *pm)) CFLOAT_SWAP(*pr, *pm);
            if (CFLOAT_LT(*pm, *pl)) CFLOAT_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            CFLOAT_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (CFLOAT_LT(*pi, vp));
                do --pj; while (CFLOAT_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                CFLOAT_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            CFLOAT_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && CFLOAT_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_cfloat(npy_cfloat *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_cfloat vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (CFLOAT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (CFLOAT_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (CFLOAT_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (CFLOAT_LT(v[*pi], vp));
                do --pj; while (CFLOAT_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && CFLOAT_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_cdouble(npy_cdouble *start, npy_intp num, void *NOT_USED)
{
    npy_cdouble vp;
    npy_cdouble *pl = start;
    npy_cdouble *pr = start + num - 1;
    npy_cdouble *stack[PYA_QS_STACK];
    npy_cdouble **sptr = stack;
    npy_cdouble *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (CDOUBLE_LT(*pm, *pl)) CDOUBLE_SWAP(*pm, *pl);
            if (CDOUBLE_LT(*pr, *pm)) CDOUBLE_SWAP(*pr, *pm);
            if (CDOUBLE_LT(*pm, *pl)) CDOUBLE_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            CDOUBLE_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (CDOUBLE_LT(*pi, vp));
                do --pj; while (CDOUBLE_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                CDOUBLE_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            CDOUBLE_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && CDOUBLE_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_cdouble(npy_cdouble *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_cdouble vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (CDOUBLE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (CDOUBLE_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (CDOUBLE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (CDOUBLE_LT(v[*pi], vp));
                do --pj; while (CDOUBLE_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && CDOUBLE_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 62

int
quicksort_clongdouble(npy_clongdouble *start, npy_intp num, void *NOT_USED)
{
    npy_clongdouble vp;
    npy_clongdouble *pl = start;
    npy_clongdouble *pr = start + num - 1;
    npy_clongdouble *stack[PYA_QS_STACK];
    npy_clongdouble **sptr = stack;
    npy_clongdouble *pm, *pi, *pj, *pk;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (CLONGDOUBLE_LT(*pm, *pl)) CLONGDOUBLE_SWAP(*pm, *pl);
            if (CLONGDOUBLE_LT(*pr, *pm)) CLONGDOUBLE_SWAP(*pr, *pm);
            if (CLONGDOUBLE_LT(*pm, *pl)) CLONGDOUBLE_SWAP(*pm, *pl);
            vp = *pm;
            pi = pl;
            pj = pr - 1;
            CLONGDOUBLE_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (CLONGDOUBLE_LT(*pi, vp));
                do --pj; while (CLONGDOUBLE_LT(vp, *pj));
                if (pi >= pj) {
                    break;
                }
                CLONGDOUBLE_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            CLONGDOUBLE_SWAP(*pi, *pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vp = *pi;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && CLONGDOUBLE_LT(vp, *pk)) {
                *pj-- = *pk--;
            }
            *pj = vp;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


int
aquicksort_clongdouble(npy_clongdouble *v, npy_intp* tosort, npy_intp num, void *NOT_USED)
{
    npy_clongdouble vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr = stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (CLONGDOUBLE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            if (CLONGDOUBLE_LT(v[*pr],v[*pm])) INTP_SWAP(*pr, *pm);
            if (CLONGDOUBLE_LT(v[*pm],v[*pl])) INTP_SWAP(*pm, *pl);
            vp = v[*pm];
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm, *pj);
            for (;;) {
                do ++pi; while (CLONGDOUBLE_LT(v[*pi], vp));
                do --pj; while (CLONGDOUBLE_LT(vp, v[*pj]));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi, *pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v[vi];
            pj = pi;
            pk = pi - 1;
            while (pj > pl && CLONGDOUBLE_LT(vp, v[*pk])) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}




/*
 *****************************************************************************
 **                             STRING SORTS                                **
 *****************************************************************************
 */


#line 209

int
quicksort_string(npy_char *start, npy_intp num, PyArrayObject *arr)
{
    const size_t len = PyArray_ITEMSIZE(arr)/sizeof(npy_char);
    npy_char *vp = malloc(PyArray_ITEMSIZE(arr));
    npy_char *pl = start;
    npy_char *pr = start + (num - 1)*len;
    npy_char *stack[PYA_QS_STACK], **sptr = stack, *pm, *pi, *pj, *pk;

    for (;;) {
        while ((size_t)(pr - pl) > SMALL_QUICKSORT*len) {
            /* quicksort partition */
            pm = pl + (((pr - pl)/len) >> 1)*len;
            if (STRING_LT(pm, pl, len)) STRING_SWAP(pm, pl, len);
            if (STRING_LT(pr, pm, len)) STRING_SWAP(pr, pm, len);
            if (STRING_LT(pm, pl, len)) STRING_SWAP(pm, pl, len);
            STRING_COPY(vp, pm, len);
            pi = pl;
            pj = pr - len;
            STRING_SWAP(pm, pj, len);
            for (;;) {
                do pi += len; while (STRING_LT(pi, vp, len));
                do pj -= len; while (STRING_LT(vp, pj, len));
                if (pi >= pj) {
                    break;
                }
                STRING_SWAP(pi, pj, len);
            }
            pk = pr - len;
            STRING_SWAP(pi, pk, len);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + len;
                *sptr++ = pr;
                pr = pi - len;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - len;
                pl = pi + len;
            }
        }

        /* insertion sort */
        for (pi = pl + len; pi <= pr; pi += len) {
            STRING_COPY(vp, pi, len);
            pj = pi;
            pk = pi - len;
            while (pj > pl && STRING_LT(vp, pk, len)) {
                STRING_COPY(pj, pk, len);
                pj -= len;
                pk -= len;
            }
            STRING_COPY(pj, vp, len);
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    free(vp);
    return 0;
}


int
aquicksort_string(npy_char *v, npy_intp* tosort, npy_intp num, PyArrayObject *arr)
{
    size_t len = PyArray_ITEMSIZE(arr)/sizeof(npy_char);
    npy_char *vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr=stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (STRING_LT(v + (*pm)*len, v + (*pl)*len, len)) INTP_SWAP(*pm, *pl);
            if (STRING_LT(v + (*pr)*len, v + (*pm)*len, len)) INTP_SWAP(*pr, *pm);
            if (STRING_LT(v + (*pm)*len, v + (*pl)*len, len)) INTP_SWAP(*pm, *pl);
            vp = v + (*pm)*len;
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm,*pj);
            for (;;) {
                do ++pi; while (STRING_LT(v + (*pi)*len, vp, len));
                do --pj; while (STRING_LT(vp, v + (*pj)*len, len));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v + vi*len;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && STRING_LT(vp, v + (*pk)*len, len)) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}


#line 209

int
quicksort_unicode(npy_ucs4 *start, npy_intp num, PyArrayObject *arr)
{
    const size_t len = PyArray_ITEMSIZE(arr)/sizeof(npy_ucs4);
    npy_ucs4 *vp = malloc(PyArray_ITEMSIZE(arr));
    npy_ucs4 *pl = start;
    npy_ucs4 *pr = start + (num - 1)*len;
    npy_ucs4 *stack[PYA_QS_STACK], **sptr = stack, *pm, *pi, *pj, *pk;

    for (;;) {
        while ((size_t)(pr - pl) > SMALL_QUICKSORT*len) {
            /* quicksort partition */
            pm = pl + (((pr - pl)/len) >> 1)*len;
            if (UNICODE_LT(pm, pl, len)) UNICODE_SWAP(pm, pl, len);
            if (UNICODE_LT(pr, pm, len)) UNICODE_SWAP(pr, pm, len);
            if (UNICODE_LT(pm, pl, len)) UNICODE_SWAP(pm, pl, len);
            UNICODE_COPY(vp, pm, len);
            pi = pl;
            pj = pr - len;
            UNICODE_SWAP(pm, pj, len);
            for (;;) {
                do pi += len; while (UNICODE_LT(pi, vp, len));
                do pj -= len; while (UNICODE_LT(vp, pj, len));
                if (pi >= pj) {
                    break;
                }
                UNICODE_SWAP(pi, pj, len);
            }
            pk = pr - len;
            UNICODE_SWAP(pi, pk, len);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + len;
                *sptr++ = pr;
                pr = pi - len;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - len;
                pl = pi + len;
            }
        }

        /* insertion sort */
        for (pi = pl + len; pi <= pr; pi += len) {
            UNICODE_COPY(vp, pi, len);
            pj = pi;
            pk = pi - len;
            while (pj > pl && UNICODE_LT(vp, pk, len)) {
                UNICODE_COPY(pj, pk, len);
                pj -= len;
                pk -= len;
            }
            UNICODE_COPY(pj, vp, len);
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    free(vp);
    return 0;
}


int
aquicksort_unicode(npy_ucs4 *v, npy_intp* tosort, npy_intp num, PyArrayObject *arr)
{
    size_t len = PyArray_ITEMSIZE(arr)/sizeof(npy_ucs4);
    npy_ucs4 *vp;
    npy_intp *pl = tosort;
    npy_intp *pr = tosort + num - 1;
    npy_intp *stack[PYA_QS_STACK];
    npy_intp **sptr=stack;
    npy_intp *pm, *pi, *pj, *pk, vi;

    for (;;) {
        while ((pr - pl) > SMALL_QUICKSORT) {
            /* quicksort partition */
            pm = pl + ((pr - pl) >> 1);
            if (UNICODE_LT(v + (*pm)*len, v + (*pl)*len, len)) INTP_SWAP(*pm, *pl);
            if (UNICODE_LT(v + (*pr)*len, v + (*pm)*len, len)) INTP_SWAP(*pr, *pm);
            if (UNICODE_LT(v + (*pm)*len, v + (*pl)*len, len)) INTP_SWAP(*pm, *pl);
            vp = v + (*pm)*len;
            pi = pl;
            pj = pr - 1;
            INTP_SWAP(*pm,*pj);
            for (;;) {
                do ++pi; while (UNICODE_LT(v + (*pi)*len, vp, len));
                do --pj; while (UNICODE_LT(vp, v + (*pj)*len, len));
                if (pi >= pj) {
                    break;
                }
                INTP_SWAP(*pi,*pj);
            }
            pk = pr - 1;
            INTP_SWAP(*pi,*pk);
            /* push largest partition on stack */
            if (pi - pl < pr - pi) {
                *sptr++ = pi + 1;
                *sptr++ = pr;
                pr = pi - 1;
            }
            else {
                *sptr++ = pl;
                *sptr++ = pi - 1;
                pl = pi + 1;
            }
        }

        /* insertion sort */
        for (pi = pl + 1; pi <= pr; ++pi) {
            vi = *pi;
            vp = v + vi*len;
            pj = pi;
            pk = pi - 1;
            while (pj > pl && UNICODE_LT(vp, v + (*pk)*len, len)) {
                *pj-- = *pk--;
            }
            *pj = vi;
        }
        if (sptr == stack) {
            break;
        }
        pr = *(--sptr);
        pl = *(--sptr);
    }

    return 0;
}




/*
 *****************************************************************************
 **                             GENERIC SORT                                **
 *****************************************************************************
 */


/*
 * This sort has almost the same signature as libc qsort and is intended to
 * supply an error return for compatibility with the other generic sort
 * kinds.
 */
int
npy_quicksort(void *base, size_t num, size_t size, npy_comparator cmp)
{
    qsort(base, num, size, cmp);
    return 0;
}

