#line 1 "numpy/core/src/scalarmathmodule.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */

/* The purpose of this module is to add faster math for array scalars
   that does not go through the ufunc machinery

   but still supports error-modes.
*/

#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include "Python.h"
#include "numpy/arrayobject.h"
#include "numpy/ufuncobject.h"
#include "numpy/arrayscalars.h"

#include "npy_pycompat.h"

#include "numpy/halffloat.h"
#include "scalarmathmodule.h"

/* Basic operations:
 *
 *  BINARY:
 *
 * add, subtract, multiply, divide, remainder, divmod, power,
 * floor_divide, true_divide
 *
 * lshift, rshift, and, or, xor (integers only)
 *
 * UNARY:
 *
 * negative, positive, absolute, nonzero, invert, int, long, float, oct, hex
 *
 */

#line 40
static void
byte_ctype_add(npy_byte a, npy_byte b, npy_byte *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
byte_ctype_subtract(npy_byte a, npy_byte b, npy_byte *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 40
static void
short_ctype_add(npy_short a, npy_short b, npy_short *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
short_ctype_subtract(npy_short a, npy_short b, npy_short *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 40
static void
int_ctype_add(npy_int a, npy_int b, npy_int *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
int_ctype_subtract(npy_int a, npy_int b, npy_int *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 40
static void
long_ctype_add(npy_long a, npy_long b, npy_long *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
long_ctype_subtract(npy_long a, npy_long b, npy_long *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 40
static void
longlong_ctype_add(npy_longlong a, npy_longlong b, npy_longlong *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
longlong_ctype_subtract(npy_longlong a, npy_longlong b, npy_longlong *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}


#line 64
static void
ubyte_ctype_add(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
ubyte_ctype_subtract(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 64
static void
ushort_ctype_add(npy_ushort a, npy_ushort b, npy_ushort *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
ushort_ctype_subtract(npy_ushort a, npy_ushort b, npy_ushort *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 64
static void
uint_ctype_add(npy_uint a, npy_uint b, npy_uint *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
uint_ctype_subtract(npy_uint a, npy_uint b, npy_uint *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 64
static void
ulong_ctype_add(npy_ulong a, npy_ulong b, npy_ulong *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
ulong_ctype_subtract(npy_ulong a, npy_ulong b, npy_ulong *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 64
static void
ulonglong_ctype_add(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
ulonglong_ctype_subtract(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}


#ifndef NPY_SIZEOF_BYTE
#define NPY_SIZEOF_BYTE 1
#endif

#line 102
#if NPY_SIZEOF_INT > NPY_SIZEOF_BYTE
static void
byte_ctype_multiply(npy_byte a, npy_byte b, npy_byte *out) {
    npy_int temp;
    temp = ((npy_int) a) * ((npy_int) b);
    *out = (npy_byte) temp;
#if 1
    if (temp > NPY_MAX_BYTE || temp < NPY_MIN_BYTE)
#else
        if (temp > NPY_MAX_BYTE)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 102
#if NPY_SIZEOF_INT > NPY_SIZEOF_BYTE
static void
ubyte_ctype_multiply(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    npy_uint temp;
    temp = ((npy_uint) a) * ((npy_uint) b);
    *out = (npy_ubyte) temp;
#if 0
    if (temp > NPY_MAX_UBYTE || temp < NPY_MIN_UBYTE)
#else
        if (temp > NPY_MAX_UBYTE)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 102
#if NPY_SIZEOF_INT > NPY_SIZEOF_SHORT
static void
short_ctype_multiply(npy_short a, npy_short b, npy_short *out) {
    npy_int temp;
    temp = ((npy_int) a) * ((npy_int) b);
    *out = (npy_short) temp;
#if 1
    if (temp > NPY_MAX_SHORT || temp < NPY_MIN_SHORT)
#else
        if (temp > NPY_MAX_SHORT)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 102
#if NPY_SIZEOF_INT > NPY_SIZEOF_SHORT
static void
ushort_ctype_multiply(npy_ushort a, npy_ushort b, npy_ushort *out) {
    npy_uint temp;
    temp = ((npy_uint) a) * ((npy_uint) b);
    *out = (npy_ushort) temp;
#if 0
    if (temp > NPY_MAX_USHORT || temp < NPY_MIN_USHORT)
#else
        if (temp > NPY_MAX_USHORT)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 102
#if NPY_SIZEOF_LONGLONG > NPY_SIZEOF_INT
static void
int_ctype_multiply(npy_int a, npy_int b, npy_int *out) {
    npy_longlong temp;
    temp = ((npy_longlong) a) * ((npy_longlong) b);
    *out = (npy_int) temp;
#if 1
    if (temp > NPY_MAX_INT || temp < NPY_MIN_INT)
#else
        if (temp > NPY_MAX_INT)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 102
#if NPY_SIZEOF_LONGLONG > NPY_SIZEOF_INT
static void
uint_ctype_multiply(npy_uint a, npy_uint b, npy_uint *out) {
    npy_ulonglong temp;
    temp = ((npy_ulonglong) a) * ((npy_ulonglong) b);
    *out = (npy_uint) temp;
#if 0
    if (temp > NPY_MAX_UINT || temp < NPY_MIN_UINT)
#else
        if (temp > NPY_MAX_UINT)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 102
#if NPY_SIZEOF_LONGLONG > NPY_SIZEOF_LONG
static void
long_ctype_multiply(npy_long a, npy_long b, npy_long *out) {
    npy_longlong temp;
    temp = ((npy_longlong) a) * ((npy_longlong) b);
    *out = (npy_long) temp;
#if 1
    if (temp > NPY_MAX_LONG || temp < NPY_MIN_LONG)
#else
        if (temp > NPY_MAX_LONG)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 102
#if NPY_SIZEOF_LONGLONG > NPY_SIZEOF_LONG
static void
ulong_ctype_multiply(npy_ulong a, npy_ulong b, npy_ulong *out) {
    npy_ulonglong temp;
    temp = ((npy_ulonglong) a) * ((npy_ulonglong) b);
    *out = (npy_ulong) temp;
#if 0
    if (temp > NPY_MAX_ULONG || temp < NPY_MIN_ULONG)
#else
        if (temp > NPY_MAX_ULONG)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif


#line 127
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_INT
static void
int_ctype_multiply(npy_int a, npy_int b, npy_int *out) {
    if (npy_mul_with_overflow_int(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 127
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_INT
static void
uint_ctype_multiply(npy_uint a, npy_uint b, npy_uint *out) {
    if (npy_mul_with_overflow_uint(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 127
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_LONG
static void
long_ctype_multiply(npy_long a, npy_long b, npy_long *out) {
    if (npy_mul_with_overflow_long(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 127
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_LONG
static void
ulong_ctype_multiply(npy_ulong a, npy_ulong b, npy_ulong *out) {
    if (npy_mul_with_overflow_ulong(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 127
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_LONGLONG
static void
longlong_ctype_multiply(npy_longlong a, npy_longlong b, npy_longlong *out) {
    if (npy_mul_with_overflow_longlong(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 127
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_LONGLONG
static void
ulonglong_ctype_multiply(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    if (npy_mul_with_overflow_ulonglong(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif


#line 146
static void
byte_ctype_divide(npy_byte a, npy_byte b, npy_byte *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_byte tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define byte_ctype_floor_divide byte_ctype_divide
static void
byte_ctype_remainder(npy_byte a, npy_byte b, npy_byte *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
ubyte_ctype_divide(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_ubyte tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define ubyte_ctype_floor_divide ubyte_ctype_divide
static void
ubyte_ctype_remainder(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
short_ctype_divide(npy_short a, npy_short b, npy_short *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_short tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define short_ctype_floor_divide short_ctype_divide
static void
short_ctype_remainder(npy_short a, npy_short b, npy_short *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
ushort_ctype_divide(npy_ushort a, npy_ushort b, npy_ushort *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_ushort tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define ushort_ctype_floor_divide ushort_ctype_divide
static void
ushort_ctype_remainder(npy_ushort a, npy_ushort b, npy_ushort *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
int_ctype_divide(npy_int a, npy_int b, npy_int *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_int tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define int_ctype_floor_divide int_ctype_divide
static void
int_ctype_remainder(npy_int a, npy_int b, npy_int *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
uint_ctype_divide(npy_uint a, npy_uint b, npy_uint *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_uint tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define uint_ctype_floor_divide uint_ctype_divide
static void
uint_ctype_remainder(npy_uint a, npy_uint b, npy_uint *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
long_ctype_divide(npy_long a, npy_long b, npy_long *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_long tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define long_ctype_floor_divide long_ctype_divide
static void
long_ctype_remainder(npy_long a, npy_long b, npy_long *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
ulong_ctype_divide(npy_ulong a, npy_ulong b, npy_ulong *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_ulong tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define ulong_ctype_floor_divide ulong_ctype_divide
static void
ulong_ctype_remainder(npy_ulong a, npy_ulong b, npy_ulong *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
longlong_ctype_divide(npy_longlong a, npy_longlong b, npy_longlong *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_longlong tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define longlong_ctype_floor_divide longlong_ctype_divide
static void
longlong_ctype_remainder(npy_longlong a, npy_longlong b, npy_longlong *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 146
static void
ulonglong_ctype_divide(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_ulonglong tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define ulonglong_ctype_floor_divide ulonglong_ctype_divide
static void
ulonglong_ctype_remainder(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}


#line 201
#define byte_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_float) (a)) / ((npy_float) (b));

#line 201
#define ubyte_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_float) (a)) / ((npy_float) (b));

#line 201
#define short_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_float) (a)) / ((npy_float) (b));

#line 201
#define ushort_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_float) (a)) / ((npy_float) (b));

#line 201
#define int_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 201
#define uint_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 201
#define long_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 201
#define ulong_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 201
#define longlong_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 201
#define ulonglong_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));


/* b will always be positive in this call */
#line 215
static void
byte_ctype_power(npy_byte a, npy_byte b, npy_byte *out) {
    npy_byte temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            byte_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        byte_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
ubyte_ctype_power(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    npy_ubyte temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            ubyte_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        ubyte_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
short_ctype_power(npy_short a, npy_short b, npy_short *out) {
    npy_short temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            short_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        short_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
ushort_ctype_power(npy_ushort a, npy_ushort b, npy_ushort *out) {
    npy_ushort temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            ushort_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        ushort_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
int_ctype_power(npy_int a, npy_int b, npy_int *out) {
    npy_int temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            int_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        int_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
uint_ctype_power(npy_uint a, npy_uint b, npy_uint *out) {
    npy_uint temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            uint_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        uint_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
long_ctype_power(npy_long a, npy_long b, npy_long *out) {
    npy_long temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            long_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        long_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
ulong_ctype_power(npy_ulong a, npy_ulong b, npy_ulong *out) {
    npy_ulong temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            ulong_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        ulong_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
longlong_ctype_power(npy_longlong a, npy_longlong b, npy_longlong *out) {
    npy_longlong temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            longlong_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        longlong_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}

#line 215
static void
ulonglong_ctype_power(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    npy_ulonglong temp, ix, mult;
    /* code from Python's intobject.c, with overflow checking removed. */
    temp = a;
    ix = 1;
    while (b > 0) {
        if (b & 1) {
            ulonglong_ctype_multiply(ix, temp, &mult);
            ix = mult;
            if (temp == 0) {
                break;
            }
        }
        b >>= 1;        /* Shift exponent down by 1 bit */
        if (b==0) {
            break;
        }
        /* Square the value of temp */
        ulonglong_ctype_multiply(temp, temp, &mult);
        temp = mult;
    }
    *out = ix;
}




/* QUESTION:  Should we check for overflow / underflow in (l,r)shift? */

#line 251

#line 256

#define byte_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define byte_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define byte_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define byte_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define byte_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define ubyte_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define ubyte_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define ubyte_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define ubyte_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define ubyte_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define short_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define short_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define short_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define short_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define short_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define ushort_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define ushort_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define ushort_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define ushort_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define ushort_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define int_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define int_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define int_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define int_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define int_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define uint_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define uint_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define uint_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define uint_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define uint_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define long_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define long_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define long_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define long_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define long_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define ulong_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define ulong_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define ulong_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define ulong_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define ulong_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define longlong_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define longlong_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define longlong_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define longlong_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define longlong_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 251

#line 256

#define ulonglong_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 256

#define ulonglong_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 256

#define ulonglong_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 256

#define ulonglong_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 256

#define ulonglong_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)





#line 267
static npy_float (*_basic_float_floor)(npy_float);
static npy_float (*_basic_float_sqrt)(npy_float);
static npy_float (*_basic_float_fmod)(npy_float, npy_float);
#define float_ctype_add(a, b, outp) *(outp) = a + b
#define float_ctype_subtract(a, b, outp) *(outp) = a - b
#define float_ctype_multiply(a, b, outp) *(outp) = a * b
#define float_ctype_divide(a, b, outp) *(outp) = a / b
#define float_ctype_true_divide float_ctype_divide
#define float_ctype_floor_divide(a, b, outp)   \
    *(outp) = _basic_float_floor((a) / (b))

#line 267
static npy_double (*_basic_double_floor)(npy_double);
static npy_double (*_basic_double_sqrt)(npy_double);
static npy_double (*_basic_double_fmod)(npy_double, npy_double);
#define double_ctype_add(a, b, outp) *(outp) = a + b
#define double_ctype_subtract(a, b, outp) *(outp) = a - b
#define double_ctype_multiply(a, b, outp) *(outp) = a * b
#define double_ctype_divide(a, b, outp) *(outp) = a / b
#define double_ctype_true_divide double_ctype_divide
#define double_ctype_floor_divide(a, b, outp)   \
    *(outp) = _basic_double_floor((a) / (b))

#line 267
static npy_longdouble (*_basic_longdouble_floor)(npy_longdouble);
static npy_longdouble (*_basic_longdouble_sqrt)(npy_longdouble);
static npy_longdouble (*_basic_longdouble_fmod)(npy_longdouble, npy_longdouble);
#define longdouble_ctype_add(a, b, outp) *(outp) = a + b
#define longdouble_ctype_subtract(a, b, outp) *(outp) = a - b
#define longdouble_ctype_multiply(a, b, outp) *(outp) = a * b
#define longdouble_ctype_divide(a, b, outp) *(outp) = a / b
#define longdouble_ctype_true_divide longdouble_ctype_divide
#define longdouble_ctype_floor_divide(a, b, outp)   \
    *(outp) = _basic_longdouble_floor((a) / (b))


static npy_half (*_basic_half_floor)(npy_half);
static npy_half (*_basic_half_sqrt)(npy_half);
static npy_half (*_basic_half_fmod)(npy_half, npy_half);

#define half_ctype_add(a, b, outp) *(outp) = \
        npy_float_to_half(npy_half_to_float(a) + npy_half_to_float(b))
#define half_ctype_subtract(a, b, outp) *(outp) = \
        npy_float_to_half(npy_half_to_float(a) - npy_half_to_float(b))
#define half_ctype_multiply(a, b, outp) *(outp) = \
        npy_float_to_half(npy_half_to_float(a) * npy_half_to_float(b))
#define half_ctype_divide(a, b, outp) *(outp) = \
        npy_float_to_half(npy_half_to_float(a) / npy_half_to_float(b))
#define half_ctype_true_divide half_ctype_divide
#define half_ctype_floor_divide(a, b, outp)   \
        *(outp) = npy_float_to_half(_basic_float_floor(npy_half_to_float(a) / \
        npy_half_to_float(b)))

#line 302
#define cfloat_ctype_add(a, b, outp) do{        \
    (outp)->real = (a).real + (b).real;         \
    (outp)->imag = (a).imag + (b).imag;         \
    } while(0)
#define cfloat_ctype_subtract(a, b, outp) do{   \
    (outp)->real = (a).real - (b).real;         \
    (outp)->imag = (a).imag - (b).imag;         \
    } while(0)
#define cfloat_ctype_multiply(a, b, outp) do{                   \
    (outp)->real = (a).real * (b).real - (a).imag * (b).imag;   \
    (outp)->imag = (a).real * (b).imag + (a).imag * (b).real;   \
    } while(0)
/* Note: complex division by zero must yield some complex inf */
#define cfloat_ctype_divide(a, b, outp) do{                         \
    npy_float d = (b).real*(b).real + (b).imag*(b).imag;              \
    if (d != 0) {                                                   \
        (outp)->real = ((a).real*(b).real + (a).imag*(b).imag)/d;   \
        (outp)->imag = ((a).imag*(b).real - (a).real*(b).imag)/d;   \
    }                                                               \
    else {                                                          \
        (outp)->real = (a).real/d;                                  \
        (outp)->imag = (a).imag/d;                                  \
    }                                                               \
    } while(0)
#define cfloat_ctype_true_divide cfloat_ctype_divide
#define cfloat_ctype_floor_divide(a, b, outp) do {      \
    (outp)->real = _basic_float_floor                 \
    (((a).real*(b).real + (a).imag*(b).imag) /          \
     ((b).real*(b).real + (b).imag*(b).imag));          \
    (outp)->imag = 0;                                   \
    } while(0)

#line 302
#define cdouble_ctype_add(a, b, outp) do{        \
    (outp)->real = (a).real + (b).real;         \
    (outp)->imag = (a).imag + (b).imag;         \
    } while(0)
#define cdouble_ctype_subtract(a, b, outp) do{   \
    (outp)->real = (a).real - (b).real;         \
    (outp)->imag = (a).imag - (b).imag;         \
    } while(0)
#define cdouble_ctype_multiply(a, b, outp) do{                   \
    (outp)->real = (a).real * (b).real - (a).imag * (b).imag;   \
    (outp)->imag = (a).real * (b).imag + (a).imag * (b).real;   \
    } while(0)
/* Note: complex division by zero must yield some complex inf */
#define cdouble_ctype_divide(a, b, outp) do{                         \
    npy_double d = (b).real*(b).real + (b).imag*(b).imag;              \
    if (d != 0) {                                                   \
        (outp)->real = ((a).real*(b).real + (a).imag*(b).imag)/d;   \
        (outp)->imag = ((a).imag*(b).real - (a).real*(b).imag)/d;   \
    }                                                               \
    else {                                                          \
        (outp)->real = (a).real/d;                                  \
        (outp)->imag = (a).imag/d;                                  \
    }                                                               \
    } while(0)
#define cdouble_ctype_true_divide cdouble_ctype_divide
#define cdouble_ctype_floor_divide(a, b, outp) do {      \
    (outp)->real = _basic_double_floor                 \
    (((a).real*(b).real + (a).imag*(b).imag) /          \
     ((b).real*(b).real + (b).imag*(b).imag));          \
    (outp)->imag = 0;                                   \
    } while(0)

#line 302
#define clongdouble_ctype_add(a, b, outp) do{        \
    (outp)->real = (a).real + (b).real;         \
    (outp)->imag = (a).imag + (b).imag;         \
    } while(0)
#define clongdouble_ctype_subtract(a, b, outp) do{   \
    (outp)->real = (a).real - (b).real;         \
    (outp)->imag = (a).imag - (b).imag;         \
    } while(0)
#define clongdouble_ctype_multiply(a, b, outp) do{                   \
    (outp)->real = (a).real * (b).real - (a).imag * (b).imag;   \
    (outp)->imag = (a).real * (b).imag + (a).imag * (b).real;   \
    } while(0)
/* Note: complex division by zero must yield some complex inf */
#define clongdouble_ctype_divide(a, b, outp) do{                         \
    npy_longdouble d = (b).real*(b).real + (b).imag*(b).imag;              \
    if (d != 0) {                                                   \
        (outp)->real = ((a).real*(b).real + (a).imag*(b).imag)/d;   \
        (outp)->imag = ((a).imag*(b).real - (a).real*(b).imag)/d;   \
    }                                                               \
    else {                                                          \
        (outp)->real = (a).real/d;                                  \
        (outp)->imag = (a).imag/d;                                  \
    }                                                               \
    } while(0)
#define clongdouble_ctype_true_divide clongdouble_ctype_divide
#define clongdouble_ctype_floor_divide(a, b, outp) do {      \
    (outp)->real = _basic_longdouble_floor                 \
    (((a).real*(b).real + (a).imag*(b).imag) /          \
     ((b).real*(b).real + (b).imag*(b).imag));          \
    (outp)->imag = 0;                                   \
    } while(0)


#line 339
static void
float_ctype_remainder(npy_float a, npy_float b, npy_float *out) {
    npy_float mod;
    mod = _basic_float_fmod(a, b);
    if (mod && (((b < 0) != (mod < 0)))) {
        mod += b;
    }
    *out = mod;
}

#line 339
static void
double_ctype_remainder(npy_double a, npy_double b, npy_double *out) {
    npy_double mod;
    mod = _basic_double_fmod(a, b);
    if (mod && (((b < 0) != (mod < 0)))) {
        mod += b;
    }
    *out = mod;
}

#line 339
static void
longdouble_ctype_remainder(npy_longdouble a, npy_longdouble b, npy_longdouble *out) {
    npy_longdouble mod;
    mod = _basic_longdouble_fmod(a, b);
    if (mod && (((b < 0) != (mod < 0)))) {
        mod += b;
    }
    *out = mod;
}


static void
half_ctype_remainder(npy_half a, npy_half b, npy_half *out) {
    float mod, fa = npy_half_to_float(a), fb = npy_half_to_float(b);
    mod = _basic_float_fmod(fa, fb);
    if (mod && (((fb < 0) != (mod < 0)))) {
        mod += fb;
    }
    *out = npy_float_to_half(mod);
}


#line 366
#define byte_ctype_divmod(a, b, out, out2) {  \
    byte_ctype_floor_divide(a, b, out);       \
    byte_ctype_remainder(a, b, out2);         \
    }

#line 366
#define ubyte_ctype_divmod(a, b, out, out2) {  \
    ubyte_ctype_floor_divide(a, b, out);       \
    ubyte_ctype_remainder(a, b, out2);         \
    }

#line 366
#define short_ctype_divmod(a, b, out, out2) {  \
    short_ctype_floor_divide(a, b, out);       \
    short_ctype_remainder(a, b, out2);         \
    }

#line 366
#define ushort_ctype_divmod(a, b, out, out2) {  \
    ushort_ctype_floor_divide(a, b, out);       \
    ushort_ctype_remainder(a, b, out2);         \
    }

#line 366
#define int_ctype_divmod(a, b, out, out2) {  \
    int_ctype_floor_divide(a, b, out);       \
    int_ctype_remainder(a, b, out2);         \
    }

#line 366
#define uint_ctype_divmod(a, b, out, out2) {  \
    uint_ctype_floor_divide(a, b, out);       \
    uint_ctype_remainder(a, b, out2);         \
    }

#line 366
#define long_ctype_divmod(a, b, out, out2) {  \
    long_ctype_floor_divide(a, b, out);       \
    long_ctype_remainder(a, b, out2);         \
    }

#line 366
#define ulong_ctype_divmod(a, b, out, out2) {  \
    ulong_ctype_floor_divide(a, b, out);       \
    ulong_ctype_remainder(a, b, out2);         \
    }

#line 366
#define longlong_ctype_divmod(a, b, out, out2) {  \
    longlong_ctype_floor_divide(a, b, out);       \
    longlong_ctype_remainder(a, b, out2);         \
    }

#line 366
#define ulonglong_ctype_divmod(a, b, out, out2) {  \
    ulonglong_ctype_floor_divide(a, b, out);       \
    ulonglong_ctype_remainder(a, b, out2);         \
    }

#line 366
#define half_ctype_divmod(a, b, out, out2) {  \
    half_ctype_floor_divide(a, b, out);       \
    half_ctype_remainder(a, b, out2);         \
    }

#line 366
#define float_ctype_divmod(a, b, out, out2) {  \
    float_ctype_floor_divide(a, b, out);       \
    float_ctype_remainder(a, b, out2);         \
    }

#line 366
#define double_ctype_divmod(a, b, out, out2) {  \
    double_ctype_floor_divide(a, b, out);       \
    double_ctype_remainder(a, b, out2);         \
    }

#line 366
#define longdouble_ctype_divmod(a, b, out, out2) {  \
    longdouble_ctype_floor_divide(a, b, out);       \
    longdouble_ctype_remainder(a, b, out2);         \
    }

#line 366
#define cfloat_ctype_divmod(a, b, out, out2) {  \
    cfloat_ctype_floor_divide(a, b, out);       \
    cfloat_ctype_remainder(a, b, out2);         \
    }

#line 366
#define cdouble_ctype_divmod(a, b, out, out2) {  \
    cdouble_ctype_floor_divide(a, b, out);       \
    cdouble_ctype_remainder(a, b, out2);         \
    }

#line 366
#define clongdouble_ctype_divmod(a, b, out, out2) {  \
    clongdouble_ctype_floor_divide(a, b, out);       \
    clongdouble_ctype_remainder(a, b, out2);         \
    }


#line 376
static npy_float (*_basic_float_pow)(npy_float a, npy_float b);

static void
float_ctype_power(npy_float a, npy_float b, npy_float *out)
{
    *out = _basic_float_pow(a, b);
}

#line 376
static npy_double (*_basic_double_pow)(npy_double a, npy_double b);

static void
double_ctype_power(npy_double a, npy_double b, npy_double *out)
{
    *out = _basic_double_pow(a, b);
}

#line 376
static npy_longdouble (*_basic_longdouble_pow)(npy_longdouble a, npy_longdouble b);

static void
longdouble_ctype_power(npy_longdouble a, npy_longdouble b, npy_longdouble *out)
{
    *out = _basic_longdouble_pow(a, b);
}

static void
half_ctype_power(npy_half a, npy_half b, npy_half *out)
{
    const npy_float af = npy_half_to_float(a);
    const npy_float bf = npy_half_to_float(b);
    const npy_float outf = _basic_float_pow(af,bf);
    *out = npy_float_to_half(outf);
}

#line 402
static void
byte_ctype_negative(npy_byte a, npy_byte *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
ubyte_ctype_negative(npy_ubyte a, npy_ubyte *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
short_ctype_negative(npy_short a, npy_short *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
ushort_ctype_negative(npy_ushort a, npy_ushort *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
int_ctype_negative(npy_int a, npy_int *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
uint_ctype_negative(npy_uint a, npy_uint *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
long_ctype_negative(npy_long a, npy_long *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
ulong_ctype_negative(npy_ulong a, npy_ulong *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
longlong_ctype_negative(npy_longlong a, npy_longlong *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
ulonglong_ctype_negative(npy_ulonglong a, npy_ulonglong *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
float_ctype_negative(npy_float a, npy_float *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
double_ctype_negative(npy_double a, npy_double *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 402
static void
longdouble_ctype_negative(npy_longdouble a, npy_longdouble *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}


static void
half_ctype_negative(npy_half a, npy_half *out)
{
    *out = a^0x8000u;
}


#line 423
static void
cfloat_ctype_negative(npy_cfloat a, npy_cfloat *out)
{
    out->real = -a.real;
    out->imag = -a.imag;
}

#line 423
static void
cdouble_ctype_negative(npy_cdouble a, npy_cdouble *out)
{
    out->real = -a.real;
    out->imag = -a.imag;
}

#line 423
static void
clongdouble_ctype_negative(npy_clongdouble a, npy_clongdouble *out)
{
    out->real = -a.real;
    out->imag = -a.imag;
}


#line 439
static void
byte_ctype_positive(npy_byte a, npy_byte *out)
{
    *out = a;
}

#line 439
static void
ubyte_ctype_positive(npy_ubyte a, npy_ubyte *out)
{
    *out = a;
}

#line 439
static void
short_ctype_positive(npy_short a, npy_short *out)
{
    *out = a;
}

#line 439
static void
ushort_ctype_positive(npy_ushort a, npy_ushort *out)
{
    *out = a;
}

#line 439
static void
int_ctype_positive(npy_int a, npy_int *out)
{
    *out = a;
}

#line 439
static void
uint_ctype_positive(npy_uint a, npy_uint *out)
{
    *out = a;
}

#line 439
static void
long_ctype_positive(npy_long a, npy_long *out)
{
    *out = a;
}

#line 439
static void
ulong_ctype_positive(npy_ulong a, npy_ulong *out)
{
    *out = a;
}

#line 439
static void
longlong_ctype_positive(npy_longlong a, npy_longlong *out)
{
    *out = a;
}

#line 439
static void
ulonglong_ctype_positive(npy_ulonglong a, npy_ulonglong *out)
{
    *out = a;
}

#line 439
static void
half_ctype_positive(npy_half a, npy_half *out)
{
    *out = a;
}

#line 439
static void
float_ctype_positive(npy_float a, npy_float *out)
{
    *out = a;
}

#line 439
static void
double_ctype_positive(npy_double a, npy_double *out)
{
    *out = a;
}

#line 439
static void
longdouble_ctype_positive(npy_longdouble a, npy_longdouble *out)
{
    *out = a;
}


/*
 * Get the nc_powf, nc_pow, and nc_powl functions from
 * the data area of the power ufunc in umathmodule.
 */

#line 455
static void
cfloat_ctype_positive(npy_cfloat a, npy_cfloat *out)
{
    out->real = a.real;
    out->imag = a.imag;
}

static void (*_basic_cfloat_pow)(npy_cfloat *, npy_cfloat *, npy_cfloat *);

static void
cfloat_ctype_power(npy_cfloat a, npy_cfloat b, npy_cfloat *out)
{
    _basic_cfloat_pow(&a, &b, out);
}

#line 455
static void
cdouble_ctype_positive(npy_cdouble a, npy_cdouble *out)
{
    out->real = a.real;
    out->imag = a.imag;
}

static void (*_basic_cdouble_pow)(npy_cdouble *, npy_cdouble *, npy_cdouble *);

static void
cdouble_ctype_power(npy_cdouble a, npy_cdouble b, npy_cdouble *out)
{
    _basic_cdouble_pow(&a, &b, out);
}

#line 455
static void
clongdouble_ctype_positive(npy_clongdouble a, npy_clongdouble *out)
{
    out->real = a.real;
    out->imag = a.imag;
}

static void (*_basic_clongdouble_pow)(npy_clongdouble *, npy_clongdouble *, npy_clongdouble *);

static void
clongdouble_ctype_power(npy_clongdouble a, npy_clongdouble b, npy_clongdouble *out)
{
    _basic_clongdouble_pow(&a, &b, out);
}



#line 475

#define ubyte_ctype_absolute ubyte_ctype_positive


#line 475

#define ushort_ctype_absolute ushort_ctype_positive


#line 475

#define uint_ctype_absolute uint_ctype_positive


#line 475

#define ulong_ctype_absolute ulong_ctype_positive


#line 475

#define ulonglong_ctype_absolute ulonglong_ctype_positive




#line 487
static void
byte_ctype_absolute(npy_byte a, npy_byte *out)
{
    *out = (a < 0 ? -a : a);
}

#line 487
static void
short_ctype_absolute(npy_short a, npy_short *out)
{
    *out = (a < 0 ? -a : a);
}

#line 487
static void
int_ctype_absolute(npy_int a, npy_int *out)
{
    *out = (a < 0 ? -a : a);
}

#line 487
static void
long_ctype_absolute(npy_long a, npy_long *out)
{
    *out = (a < 0 ? -a : a);
}

#line 487
static void
longlong_ctype_absolute(npy_longlong a, npy_longlong *out)
{
    *out = (a < 0 ? -a : a);
}

#line 487
static void
float_ctype_absolute(npy_float a, npy_float *out)
{
    *out = (a < 0 ? -a : a);
}

#line 487
static void
double_ctype_absolute(npy_double a, npy_double *out)
{
    *out = (a < 0 ? -a : a);
}

#line 487
static void
longdouble_ctype_absolute(npy_longdouble a, npy_longdouble *out)
{
    *out = (a < 0 ? -a : a);
}


static void
half_ctype_absolute(npy_half a, npy_half *out)
{
    *out = a&0x7fffu;
}

#line 506
static void
cfloat_ctype_absolute(npy_cfloat a, npy_float *out)
{
    *out = _basic_float_sqrt(a.real*a.real + a.imag*a.imag);
}

#line 506
static void
cdouble_ctype_absolute(npy_cdouble a, npy_double *out)
{
    *out = _basic_double_sqrt(a.real*a.real + a.imag*a.imag);
}

#line 506
static void
clongdouble_ctype_absolute(npy_clongdouble a, npy_longdouble *out)
{
    *out = _basic_longdouble_sqrt(a.real*a.real + a.imag*a.imag);
}


#line 517

#define byte_ctype_invert(a, out) *(out) = ~a;


#line 517

#define ubyte_ctype_invert(a, out) *(out) = ~a;


#line 517

#define short_ctype_invert(a, out) *(out) = ~a;


#line 517

#define ushort_ctype_invert(a, out) *(out) = ~a;


#line 517

#define int_ctype_invert(a, out) *(out) = ~a;


#line 517

#define uint_ctype_invert(a, out) *(out) = ~a;


#line 517

#define long_ctype_invert(a, out) *(out) = ~a;


#line 517

#define ulong_ctype_invert(a, out) *(out) = ~a;


#line 517

#define longlong_ctype_invert(a, out) *(out) = ~a;


#line 517

#define ulonglong_ctype_invert(a, out) *(out) = ~a;



/*** END OF BASIC CODE **/


/* The general strategy for commutative binary operators is to
 *
 * 1) Convert the types to the common type if both are scalars (0 return)
 * 2) If both are not scalars use ufunc machinery (-2 return)
 * 3) If both are scalars but cannot be cast to the right type
 * return NotImplmented (-1 return)
 *
 * 4) Perform the function on the C-type.
 * 5) If an error condition occurred, check to see
 * what the current error-handling is and handle the error.
 *
 * 6) Construct and return the output scalar.
 */

#line 557

static int
_byte_convert_to_ctype(PyObject *a, npy_byte *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Byte)) {
        *arg1 = PyArrayScalar_VAL(a, Byte);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_BYTE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_BYTE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _byte_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_ubyte_convert_to_ctype(PyObject *a, npy_ubyte *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, UByte)) {
        *arg1 = PyArrayScalar_VAL(a, UByte);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_UBYTE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_UBYTE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _ubyte_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_short_convert_to_ctype(PyObject *a, npy_short *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Short)) {
        *arg1 = PyArrayScalar_VAL(a, Short);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_SHORT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_SHORT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _short_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_ushort_convert_to_ctype(PyObject *a, npy_ushort *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, UShort)) {
        *arg1 = PyArrayScalar_VAL(a, UShort);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_USHORT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_USHORT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _ushort_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_int_convert_to_ctype(PyObject *a, npy_int *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Int)) {
        *arg1 = PyArrayScalar_VAL(a, Int);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_INT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_INT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _int_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_uint_convert_to_ctype(PyObject *a, npy_uint *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, UInt)) {
        *arg1 = PyArrayScalar_VAL(a, UInt);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_UINT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_UINT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _uint_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_long_convert_to_ctype(PyObject *a, npy_long *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Long)) {
        *arg1 = PyArrayScalar_VAL(a, Long);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_LONG)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_LONG);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _long_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_ulong_convert_to_ctype(PyObject *a, npy_ulong *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, ULong)) {
        *arg1 = PyArrayScalar_VAL(a, ULong);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_ULONG)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_ULONG);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _ulong_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_longlong_convert_to_ctype(PyObject *a, npy_longlong *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, LongLong)) {
        *arg1 = PyArrayScalar_VAL(a, LongLong);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_LONGLONG)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_LONGLONG);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _longlong_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_ulonglong_convert_to_ctype(PyObject *a, npy_ulonglong *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, ULongLong)) {
        *arg1 = PyArrayScalar_VAL(a, ULongLong);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_ULONGLONG)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_ULONGLONG);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _ulonglong_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_half_convert_to_ctype(PyObject *a, npy_half *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Half)) {
        *arg1 = PyArrayScalar_VAL(a, Half);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_HALF)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_HALF);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _half_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_float_convert_to_ctype(PyObject *a, npy_float *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Float)) {
        *arg1 = PyArrayScalar_VAL(a, Float);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_FLOAT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_FLOAT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _float_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_longdouble_convert_to_ctype(PyObject *a, npy_longdouble *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, LongDouble)) {
        *arg1 = PyArrayScalar_VAL(a, LongDouble);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_LONGDOUBLE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_LONGDOUBLE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _longdouble_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_cfloat_convert_to_ctype(PyObject *a, npy_cfloat *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, CFloat)) {
        *arg1 = PyArrayScalar_VAL(a, CFloat);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_CFLOAT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_CFLOAT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _cfloat_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_cdouble_convert_to_ctype(PyObject *a, npy_cdouble *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, CDouble)) {
        *arg1 = PyArrayScalar_VAL(a, CDouble);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_CDOUBLE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_CDOUBLE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _cdouble_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 557

static int
_clongdouble_convert_to_ctype(PyObject *a, npy_clongdouble *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, CLongDouble)) {
        *arg1 = PyArrayScalar_VAL(a, CLongDouble);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_CLONGDOUBLE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_CLONGDOUBLE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _clongdouble_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}




/* Same as above but added exact checks against known python types for speed */

#line 609

static int
_double_convert_to_ctype(PyObject *a, npy_double *arg1)
{
    PyObject *temp;

    if (PyFloat_CheckExact(a)){
        *arg1 = PyFloat_AS_DOUBLE(a);
        return 0;
    }

    if (PyArray_IsScalar(a, Double)) {
        *arg1 = PyArrayScalar_VAL(a, Double);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_DOUBLE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_DOUBLE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _double_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}




#line 664
static int
_byte_convert2_to_ctypes(PyObject *a, npy_byte *arg1,
                           PyObject *b, npy_byte *arg2)
{
    int ret;
    ret = _byte_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _byte_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_ubyte_convert2_to_ctypes(PyObject *a, npy_ubyte *arg1,
                           PyObject *b, npy_ubyte *arg2)
{
    int ret;
    ret = _ubyte_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _ubyte_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_short_convert2_to_ctypes(PyObject *a, npy_short *arg1,
                           PyObject *b, npy_short *arg2)
{
    int ret;
    ret = _short_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _short_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_ushort_convert2_to_ctypes(PyObject *a, npy_ushort *arg1,
                           PyObject *b, npy_ushort *arg2)
{
    int ret;
    ret = _ushort_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _ushort_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_int_convert2_to_ctypes(PyObject *a, npy_int *arg1,
                           PyObject *b, npy_int *arg2)
{
    int ret;
    ret = _int_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _int_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_uint_convert2_to_ctypes(PyObject *a, npy_uint *arg1,
                           PyObject *b, npy_uint *arg2)
{
    int ret;
    ret = _uint_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _uint_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_long_convert2_to_ctypes(PyObject *a, npy_long *arg1,
                           PyObject *b, npy_long *arg2)
{
    int ret;
    ret = _long_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _long_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_ulong_convert2_to_ctypes(PyObject *a, npy_ulong *arg1,
                           PyObject *b, npy_ulong *arg2)
{
    int ret;
    ret = _ulong_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _ulong_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_longlong_convert2_to_ctypes(PyObject *a, npy_longlong *arg1,
                           PyObject *b, npy_longlong *arg2)
{
    int ret;
    ret = _longlong_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _longlong_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_ulonglong_convert2_to_ctypes(PyObject *a, npy_ulonglong *arg1,
                           PyObject *b, npy_ulonglong *arg2)
{
    int ret;
    ret = _ulonglong_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _ulonglong_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_half_convert2_to_ctypes(PyObject *a, npy_half *arg1,
                           PyObject *b, npy_half *arg2)
{
    int ret;
    ret = _half_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _half_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_float_convert2_to_ctypes(PyObject *a, npy_float *arg1,
                           PyObject *b, npy_float *arg2)
{
    int ret;
    ret = _float_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _float_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_double_convert2_to_ctypes(PyObject *a, npy_double *arg1,
                           PyObject *b, npy_double *arg2)
{
    int ret;
    ret = _double_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _double_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_cfloat_convert2_to_ctypes(PyObject *a, npy_cfloat *arg1,
                           PyObject *b, npy_cfloat *arg2)
{
    int ret;
    ret = _cfloat_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _cfloat_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 664
static int
_cdouble_convert2_to_ctypes(PyObject *a, npy_cdouble *arg1,
                           PyObject *b, npy_cdouble *arg2)
{
    int ret;
    ret = _cdouble_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _cdouble_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}


#line 685

static int
_longdouble_convert2_to_ctypes(PyObject *a, npy_longdouble *arg1,
                           PyObject *b, npy_longdouble *arg2)
{
    int ret;
    ret = _longdouble_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _longdouble_convert_to_ctype(b, arg2);
    if (ret == -2) {
        ret = -3;
    }
    if (ret < 0) {
        return ret;
    }
    return 0;
}


#line 685

static int
_clongdouble_convert2_to_ctypes(PyObject *a, npy_clongdouble *arg1,
                           PyObject *b, npy_clongdouble *arg2)
{
    int ret;
    ret = _clongdouble_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _clongdouble_convert_to_ctype(b, arg2);
    if (ret == -2) {
        ret = -3;
    }
    if (ret < 0) {
        return ret;
    }
    return 0;
}




#if defined(NPY_PY3K)
#define CODEGEN_SKIP_divide_FLAG
#endif

#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
byte_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_add(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_add(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
ubyte_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_add(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_add(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
short_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_add(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_add(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
ushort_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_add(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_add(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
int_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_add(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_add(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
uint_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_add(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_add(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
long_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_add(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_add(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
ulong_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_add(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_add(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
longlong_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_add(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_add(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
ulonglong_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_add(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_add(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
byte_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_subtract(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_subtract(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
ubyte_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_subtract(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_subtract(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
short_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_subtract(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_subtract(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
ushort_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_subtract(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_subtract(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
int_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_subtract(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_subtract(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
uint_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_subtract(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_subtract(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
long_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_subtract(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_subtract(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
ulong_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_subtract(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_subtract(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
longlong_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_subtract(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_subtract(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
ulonglong_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_subtract(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_subtract(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
byte_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_multiply(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_multiply(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
ubyte_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_multiply(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_multiply(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
short_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_multiply(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_multiply(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
ushort_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_multiply(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_multiply(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
int_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_multiply(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_multiply(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
uint_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_multiply(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_multiply(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
long_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_multiply(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_multiply(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
ulong_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_multiply(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_multiply(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
longlong_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_multiply(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_multiply(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
ulonglong_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_multiply(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_multiply(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
byte_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_divide(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_divide(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
ubyte_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_divide(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_divide(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
short_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_divide(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_divide(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
ushort_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_divide(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_divide(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
int_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_divide(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_divide(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
uint_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_divide(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_divide(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
long_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_divide(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_divide(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
ulong_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_divide(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_divide(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
longlong_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_divide(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_divide(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
ulonglong_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_divide(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_divide(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
byte_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_remainder(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_remainder(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
ubyte_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_remainder(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_remainder(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
short_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_remainder(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_remainder(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
ushort_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_remainder(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_remainder(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
int_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_remainder(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_remainder(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
uint_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_remainder(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_remainder(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
long_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_remainder(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_remainder(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
ulong_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_remainder(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_remainder(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
longlong_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_remainder(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_remainder(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
ulonglong_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_remainder(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_remainder(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
byte_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 1
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    byte_ctype_divmod(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_divmod(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
ubyte_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 1
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    ubyte_ctype_divmod(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_divmod(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
short_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 1
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    short_ctype_divmod(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_divmod(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
ushort_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 1
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    ushort_ctype_divmod(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_divmod(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
int_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 1
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    int_ctype_divmod(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_divmod(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
uint_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 1
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    uint_ctype_divmod(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_divmod(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
long_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 1
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    long_ctype_divmod(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_divmod(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
ulong_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 1
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    ulong_ctype_divmod(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_divmod(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
longlong_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 1
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    longlong_ctype_divmod(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_divmod(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
ulonglong_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 1
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    ulonglong_ctype_divmod(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_divmod(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
byte_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_floor_divide(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_floor_divide(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
ubyte_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_floor_divide(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_floor_divide(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
short_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_floor_divide(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_floor_divide(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
ushort_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_floor_divide(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_floor_divide(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
int_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_floor_divide(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_floor_divide(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
uint_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_floor_divide(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_floor_divide(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
long_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_floor_divide(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_floor_divide(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
ulong_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_floor_divide(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_floor_divide(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
longlong_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_floor_divide(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_floor_divide(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
ulonglong_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_floor_divide(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_floor_divide(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
byte_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_lshift(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_lshift(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
ubyte_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_lshift(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_lshift(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
short_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_lshift(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_lshift(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
ushort_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_lshift(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_lshift(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
int_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_lshift(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_lshift(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
uint_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_lshift(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_lshift(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
long_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_lshift(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_lshift(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
ulong_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_lshift(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_lshift(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
longlong_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_lshift(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_lshift(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
ulonglong_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_lshift(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_lshift(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
byte_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_rshift(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_rshift(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
ubyte_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_rshift(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_rshift(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
short_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_rshift(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_rshift(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
ushort_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_rshift(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_rshift(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
int_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_rshift(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_rshift(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
uint_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_rshift(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_rshift(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
long_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_rshift(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_rshift(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
ulong_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_rshift(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_rshift(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
longlong_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_rshift(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_rshift(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
ulonglong_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_rshift(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_rshift(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
byte_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_and(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_and(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
ubyte_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_and(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_and(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
short_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_and(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_and(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
ushort_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_and(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_and(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
int_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_and(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_and(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
uint_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_and(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_and(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
long_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_and(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_and(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
ulong_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_and(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_and(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
longlong_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_and(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_and(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
ulonglong_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_and(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_and(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
byte_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_or(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_or(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
ubyte_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_or(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_or(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
short_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_or(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_or(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
ushort_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_or(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_or(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
int_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_or(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_or(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
uint_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_or(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_or(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
long_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_or(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_or(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
ulong_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_or(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_or(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
longlong_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_or(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_or(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
ulonglong_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_or(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_or(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
byte_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_xor(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_xor(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
ubyte_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_xor(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_xor(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
short_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_xor(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_xor(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
ushort_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_xor(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_xor(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
int_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_xor(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_xor(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
uint_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_xor(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_xor(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
long_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_xor(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_xor(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
ulong_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_xor(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_xor(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
longlong_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_xor(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_xor(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
ulonglong_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_xor(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_xor(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
byte_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    byte_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
ubyte_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    ubyte_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
short_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    short_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
ushort_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    ushort_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
int_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    int_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
uint_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    uint_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
long_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    long_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
ulong_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    ulong_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
longlong_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    longlong_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
ulonglong_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    ulonglong_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
half_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_add(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_add(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
float_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_add(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_add(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
double_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_add(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_add(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
longdouble_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_add(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_add(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
cfloat_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_add(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_add(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
cdouble_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_add(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_add(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
clongdouble_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_add(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_add(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
half_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_subtract(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_subtract(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
float_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_subtract(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_subtract(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
double_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_subtract(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_subtract(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
longdouble_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_subtract(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_subtract(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
cfloat_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_subtract(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_subtract(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
cdouble_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_subtract(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_subtract(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
clongdouble_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_subtract(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_subtract(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
half_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_multiply(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_multiply(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
float_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_multiply(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_multiply(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
double_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_multiply(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_multiply(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
longdouble_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_multiply(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_multiply(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
cfloat_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_multiply(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_multiply(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
cdouble_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_multiply(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_multiply(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
clongdouble_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_multiply(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_multiply(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
half_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_divide(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_divide(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
float_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
double_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
longdouble_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_divide(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_divide(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
cfloat_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_divide(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_divide(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
cdouble_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_divide(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_divide(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
clongdouble_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_divide(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_divide(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
half_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_floor_divide(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_floor_divide(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
float_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_floor_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_floor_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
double_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_floor_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_floor_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
longdouble_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_floor_divide(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_floor_divide(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
cfloat_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_floor_divide(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_floor_divide(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
cdouble_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_floor_divide(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_floor_divide(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
clongdouble_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_floor_divide(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_floor_divide(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
half_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_true_divide(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_true_divide(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
float_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
double_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
longdouble_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_true_divide(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_true_divide(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
cfloat_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_true_divide(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_true_divide(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
cdouble_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_true_divide(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_true_divide(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
clongdouble_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_true_divide(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_true_divide(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
half_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 1
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    half_ctype_divmod(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_divmod(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
float_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 1
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    float_ctype_divmod(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_divmod(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
double_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 1
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    double_ctype_divmod(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_divmod(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
longdouble_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 1
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    longdouble_ctype_divmod(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_divmod(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
half_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_remainder(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_remainder(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
float_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_remainder(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_remainder(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
double_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_remainder(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_remainder(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 755

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
longdouble_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    PyUFunc_clearfperr();
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_remainder(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_remainder(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif



#undef CODEGEN_SKIP_divide_FLAG

#define _IS_ZERO(x) (x == 0)

#line 905

#if 0
static PyObject *
byte_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_byte arg1, arg2;
    int retstatus;
    int first;
    npy_byte out = {0, 0};

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        byte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#elif 1

static PyObject *
byte_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_byte arg1, arg2;
    int retstatus;
    int first;
    npy_byte out = 0;
    npy_float out1 = 0;

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        byte_ctype_power(arg1, -arg2, &out);
        out1 = (npy_float) (1.0 / out);
    }
    else {
        byte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Float);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Float, out1);
    }
    else {
        ret = PyArrayScalar_New(Byte);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Byte, out);
    }

    return ret;
}

#else

static PyObject *
byte_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_byte arg1, arg2;
    int retstatus;
    int first;

    npy_byte out = 0;
    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        byte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
ubyte_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    int retstatus;
    int first;
    npy_ubyte out = {0, 0};

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        ubyte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#elif 0

static PyObject *
ubyte_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    int retstatus;
    int first;
    npy_ubyte out = 0;
    npy_float out1 = 0;

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        ubyte_ctype_power(arg1, -arg2, &out);
        out1 = (npy_float) (1.0 / out);
    }
    else {
        ubyte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Float);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Float, out1);
    }
    else {
        ret = PyArrayScalar_New(UByte);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, UByte, out);
    }

    return ret;
}

#else

static PyObject *
ubyte_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    int retstatus;
    int first;

    npy_ubyte out = 0;
    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        ubyte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
short_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_short arg1, arg2;
    int retstatus;
    int first;
    npy_short out = {0, 0};

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        short_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#elif 1

static PyObject *
short_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_short arg1, arg2;
    int retstatus;
    int first;
    npy_short out = 0;
    npy_float out1 = 0;

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        short_ctype_power(arg1, -arg2, &out);
        out1 = (npy_float) (1.0 / out);
    }
    else {
        short_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Float);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Float, out1);
    }
    else {
        ret = PyArrayScalar_New(Short);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Short, out);
    }

    return ret;
}

#else

static PyObject *
short_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_short arg1, arg2;
    int retstatus;
    int first;

    npy_short out = 0;
    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        short_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
ushort_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    int retstatus;
    int first;
    npy_ushort out = {0, 0};

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        ushort_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#elif 0

static PyObject *
ushort_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    int retstatus;
    int first;
    npy_ushort out = 0;
    npy_float out1 = 0;

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        ushort_ctype_power(arg1, -arg2, &out);
        out1 = (npy_float) (1.0 / out);
    }
    else {
        ushort_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Float);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Float, out1);
    }
    else {
        ret = PyArrayScalar_New(UShort);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, UShort, out);
    }

    return ret;
}

#else

static PyObject *
ushort_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    int retstatus;
    int first;

    npy_ushort out = 0;
    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        ushort_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
int_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_int arg1, arg2;
    int retstatus;
    int first;
    npy_int out = {0, 0};

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        int_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#elif 1

static PyObject *
int_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_int arg1, arg2;
    int retstatus;
    int first;
    npy_int out = 0;
    npy_double out1 = 0;

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        int_ctype_power(arg1, -arg2, &out);
        out1 = (npy_double) (1.0 / out);
    }
    else {
        int_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Double);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Double, out1);
    }
    else {
        ret = PyArrayScalar_New(Int);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Int, out);
    }

    return ret;
}

#else

static PyObject *
int_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_int arg1, arg2;
    int retstatus;
    int first;

    npy_int out = 0;
    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        int_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
uint_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_uint arg1, arg2;
    int retstatus;
    int first;
    npy_uint out = {0, 0};

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        uint_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#elif 0

static PyObject *
uint_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_uint arg1, arg2;
    int retstatus;
    int first;
    npy_uint out = 0;
    npy_double out1 = 0;

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        uint_ctype_power(arg1, -arg2, &out);
        out1 = (npy_double) (1.0 / out);
    }
    else {
        uint_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Double);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Double, out1);
    }
    else {
        ret = PyArrayScalar_New(UInt);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, UInt, out);
    }

    return ret;
}

#else

static PyObject *
uint_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_uint arg1, arg2;
    int retstatus;
    int first;

    npy_uint out = 0;
    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        uint_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
long_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_long arg1, arg2;
    int retstatus;
    int first;
    npy_long out = {0, 0};

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        long_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#elif 1

static PyObject *
long_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_long arg1, arg2;
    int retstatus;
    int first;
    npy_long out = 0;
    npy_double out1 = 0;

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        long_ctype_power(arg1, -arg2, &out);
        out1 = (npy_double) (1.0 / out);
    }
    else {
        long_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Double);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Double, out1);
    }
    else {
        ret = PyArrayScalar_New(Long);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Long, out);
    }

    return ret;
}

#else

static PyObject *
long_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_long arg1, arg2;
    int retstatus;
    int first;

    npy_long out = 0;
    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        long_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
ulong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    int retstatus;
    int first;
    npy_ulong out = {0, 0};

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        ulong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#elif 0

static PyObject *
ulong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    int retstatus;
    int first;
    npy_ulong out = 0;
    npy_double out1 = 0;

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        ulong_ctype_power(arg1, -arg2, &out);
        out1 = (npy_double) (1.0 / out);
    }
    else {
        ulong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Double);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Double, out1);
    }
    else {
        ret = PyArrayScalar_New(ULong);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, ULong, out);
    }

    return ret;
}

#else

static PyObject *
ulong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    int retstatus;
    int first;

    npy_ulong out = 0;
    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        ulong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
longlong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    int retstatus;
    int first;
    npy_longlong out = {0, 0};

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        longlong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#elif 1

static PyObject *
longlong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    int retstatus;
    int first;
    npy_longlong out = 0;
    npy_double out1 = 0;

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        longlong_ctype_power(arg1, -arg2, &out);
        out1 = (npy_double) (1.0 / out);
    }
    else {
        longlong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Double);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Double, out1);
    }
    else {
        ret = PyArrayScalar_New(LongLong);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, LongLong, out);
    }

    return ret;
}

#else

static PyObject *
longlong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    int retstatus;
    int first;

    npy_longlong out = 0;
    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        longlong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
ulonglong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    int retstatus;
    int first;
    npy_ulonglong out = {0, 0};

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        ulonglong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#elif 0

static PyObject *
ulonglong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    int retstatus;
    int first;
    npy_ulonglong out = 0;
    npy_double out1 = 0;

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        ulonglong_ctype_power(arg1, -arg2, &out);
        out1 = (npy_double) (1.0 / out);
    }
    else {
        ulonglong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Double);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Double, out1);
    }
    else {
        ret = PyArrayScalar_New(ULongLong);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, ULongLong, out);
    }

    return ret;
}

#else

static PyObject *
ulonglong_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    int retstatus;
    int first;

    npy_ulonglong out = 0;
    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        ulonglong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
half_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_half arg1, arg2;
    int retstatus;
    int first;
    npy_half out = {NPY_HALF_ZERO, NPY_HALF_ZERO};

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (npy_half_iszero(arg2.real) && npy_half_iszero(arg2.imag)) {
        out.real = NPY_HALF_ONE;
        out.imag = NPY_HALF_ZERO;
    }
    else {
        half_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#elif 0

static PyObject *
half_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_half arg1, arg2;
    int retstatus;
    int first;
    npy_half out = NPY_HALF_ZERO;
    npy_half out1 = NPY_HALF_ZERO;

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (npy_half_iszero(arg2)) {
        out1 = out = NPY_HALF_ONE;
    }
    else if (arg2 < 0) {
        half_ctype_power(arg1, -arg2, &out);
        out1 = (npy_half) (1.0 / out);
    }
    else {
        half_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Half);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Half, out1);
    }
    else {
        ret = PyArrayScalar_New(Half);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Half, out);
    }

    return ret;
}

#else

static PyObject *
half_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_half arg1, arg2;
    int retstatus;
    int first;

    npy_half out = NPY_HALF_ZERO;
    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (npy_half_iszero(arg2)) {
        out = NPY_HALF_ONE;
    }
    else {
        half_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
float_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_float arg1, arg2;
    int retstatus;
    int first;
    npy_float out = {0, 0};

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        float_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#elif 0

static PyObject *
float_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_float arg1, arg2;
    int retstatus;
    int first;
    npy_float out = 0;
    npy_float out1 = 0;

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        float_ctype_power(arg1, -arg2, &out);
        out1 = (npy_float) (1.0 / out);
    }
    else {
        float_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Float);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Float, out1);
    }
    else {
        ret = PyArrayScalar_New(Float);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Float, out);
    }

    return ret;
}

#else

static PyObject *
float_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_float arg1, arg2;
    int retstatus;
    int first;

    npy_float out = 0;
    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        float_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
double_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_double arg1, arg2;
    int retstatus;
    int first;
    npy_double out = {0, 0};

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        double_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#elif 0

static PyObject *
double_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_double arg1, arg2;
    int retstatus;
    int first;
    npy_double out = 0;
    npy_double out1 = 0;

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        double_ctype_power(arg1, -arg2, &out);
        out1 = (npy_double) (1.0 / out);
    }
    else {
        double_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(Double);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Double, out1);
    }
    else {
        ret = PyArrayScalar_New(Double);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, Double, out);
    }

    return ret;
}

#else

static PyObject *
double_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_double arg1, arg2;
    int retstatus;
    int first;

    npy_double out = 0;
    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        double_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#endif


#line 905

#if 0
static PyObject *
longdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    int retstatus;
    int first;
    npy_longdouble out = {0, 0};

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        longdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#elif 0

static PyObject *
longdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    int retstatus;
    int first;
    npy_longdouble out = 0;
    npy_longdouble out1 = 0;

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        longdouble_ctype_power(arg1, -arg2, &out);
        out1 = (npy_longdouble) (1.0 / out);
    }
    else {
        longdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(LongDouble);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, LongDouble, out1);
    }
    else {
        ret = PyArrayScalar_New(LongDouble);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, LongDouble, out);
    }

    return ret;
}

#else

static PyObject *
longdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    int retstatus;
    int first;

    npy_longdouble out = 0;
    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        longdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#endif


#line 905

#if 1
static PyObject *
cfloat_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    int retstatus;
    int first;
    npy_cfloat out = {0, 0};

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        cfloat_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#elif 0

static PyObject *
cfloat_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    int retstatus;
    int first;
    npy_cfloat out = 0;
    npy_cfloat out1 = 0;

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        cfloat_ctype_power(arg1, -arg2, &out);
        out1 = (npy_cfloat) (1.0 / out);
    }
    else {
        cfloat_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(CFloat);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, CFloat, out1);
    }
    else {
        ret = PyArrayScalar_New(CFloat);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, CFloat, out);
    }

    return ret;
}

#else

static PyObject *
cfloat_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    int retstatus;
    int first;

    npy_cfloat out = 0;
    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        cfloat_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#endif


#line 905

#if 1
static PyObject *
cdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    int retstatus;
    int first;
    npy_cdouble out = {0, 0};

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        cdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#elif 0

static PyObject *
cdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    int retstatus;
    int first;
    npy_cdouble out = 0;
    npy_cdouble out1 = 0;

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        cdouble_ctype_power(arg1, -arg2, &out);
        out1 = (npy_cdouble) (1.0 / out);
    }
    else {
        cdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(CDouble);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, CDouble, out1);
    }
    else {
        ret = PyArrayScalar_New(CDouble);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, CDouble, out);
    }

    return ret;
}

#else

static PyObject *
cdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    int retstatus;
    int first;

    npy_cdouble out = 0;
    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        cdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#endif


#line 905

#if 1
static PyObject *
clongdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    int retstatus;
    int first;
    npy_clongdouble out = {0, 0};

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        clongdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#elif 0

static PyObject *
clongdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    int retstatus;
    int first;
    npy_clongdouble out = 0;
    npy_clongdouble out1 = 0;

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out1 = out = 1;
    }
    else if (arg2 < 0) {
        clongdouble_ctype_power(arg1, -arg2, &out);
        out1 = (npy_clongdouble) (1.0 / out);
    }
    else {
        clongdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    if (arg2 < 0) {
        ret = PyArrayScalar_New(CLongDouble);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, CLongDouble, out1);
    }
    else {
        ret = PyArrayScalar_New(CLongDouble);
        if (ret == NULL) {
            return NULL;
        }
        PyArrayScalar_ASSIGN(ret, CLongDouble, out);
    }

    return ret;
}

#else

static PyObject *
clongdouble_power(PyObject *a, PyObject *b, PyObject *NPY_UNUSED(c))
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    int retstatus;
    int first;

    npy_clongdouble out = 0;
    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,NULL);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,NULL);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    PyUFunc_clearfperr();

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        clongdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = PyUFunc_getfperr();
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#endif


#undef _IS_ZERO


#line 1147

#line 1153

#define cfloat_divmod NULL


#line 1153

#define cfloat_remainder NULL




#line 1147

#line 1153

#define cdouble_divmod NULL


#line 1153

#define cdouble_remainder NULL




#line 1147

#line 1153

#define clongdouble_divmod NULL


#line 1153

#define clongdouble_remainder NULL





#line 1165

#line 1171

#define half_lshift NULL


#line 1171

#define half_rshift NULL


#line 1171

#define half_and NULL


#line 1171

#define half_or NULL


#line 1171

#define half_xor NULL




#line 1165

#line 1171

#define float_lshift NULL


#line 1171

#define float_rshift NULL


#line 1171

#define float_and NULL


#line 1171

#define float_or NULL


#line 1171

#define float_xor NULL




#line 1165

#line 1171

#define double_lshift NULL


#line 1171

#define double_rshift NULL


#line 1171

#define double_and NULL


#line 1171

#define double_or NULL


#line 1171

#define double_xor NULL




#line 1165

#line 1171

#define longdouble_lshift NULL


#line 1171

#define longdouble_rshift NULL


#line 1171

#define longdouble_and NULL


#line 1171

#define longdouble_or NULL


#line 1171

#define longdouble_xor NULL




#line 1165

#line 1171

#define cfloat_lshift NULL


#line 1171

#define cfloat_rshift NULL


#line 1171

#define cfloat_and NULL


#line 1171

#define cfloat_or NULL


#line 1171

#define cfloat_xor NULL




#line 1165

#line 1171

#define cdouble_lshift NULL


#line 1171

#define cdouble_rshift NULL


#line 1171

#define cdouble_and NULL


#line 1171

#define cdouble_or NULL


#line 1171

#define cdouble_xor NULL




#line 1165

#line 1171

#define clongdouble_lshift NULL


#line 1171

#define clongdouble_rshift NULL


#line 1171

#define clongdouble_and NULL


#line 1171

#define clongdouble_or NULL


#line 1171

#define clongdouble_xor NULL





#line 1221
static PyObject *
byte_negative(PyObject *a)
{
    npy_byte arg1;
    npy_byte out;
    PyObject *ret;

    switch(_byte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    byte_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Byte);
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#line 1221
static PyObject *
ubyte_negative(PyObject *a)
{
    npy_ubyte arg1;
    npy_ubyte out;
    PyObject *ret;

    switch(_ubyte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ubyte_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(UByte);
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#line 1221
static PyObject *
short_negative(PyObject *a)
{
    npy_short arg1;
    npy_short out;
    PyObject *ret;

    switch(_short_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    short_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Short);
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#line 1221
static PyObject *
ushort_negative(PyObject *a)
{
    npy_ushort arg1;
    npy_ushort out;
    PyObject *ret;

    switch(_ushort_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ushort_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(UShort);
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#line 1221
static PyObject *
int_negative(PyObject *a)
{
    npy_int arg1;
    npy_int out;
    PyObject *ret;

    switch(_int_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    int_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Int);
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#line 1221
static PyObject *
uint_negative(PyObject *a)
{
    npy_uint arg1;
    npy_uint out;
    PyObject *ret;

    switch(_uint_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    uint_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(UInt);
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#line 1221
static PyObject *
long_negative(PyObject *a)
{
    npy_long arg1;
    npy_long out;
    PyObject *ret;

    switch(_long_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    long_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Long);
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#line 1221
static PyObject *
ulong_negative(PyObject *a)
{
    npy_ulong arg1;
    npy_ulong out;
    PyObject *ret;

    switch(_ulong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulong_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(ULong);
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#line 1221
static PyObject *
longlong_negative(PyObject *a)
{
    npy_longlong arg1;
    npy_longlong out;
    PyObject *ret;

    switch(_longlong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longlong_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(LongLong);
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#line 1221
static PyObject *
ulonglong_negative(PyObject *a)
{
    npy_ulonglong arg1;
    npy_ulonglong out;
    PyObject *ret;

    switch(_ulonglong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulonglong_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(ULongLong);
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#line 1221
static PyObject *
half_negative(PyObject *a)
{
    npy_half arg1;
    npy_half out;
    PyObject *ret;

    switch(_half_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    half_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Half);
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#line 1221
static PyObject *
float_negative(PyObject *a)
{
    npy_float arg1;
    npy_float out;
    PyObject *ret;

    switch(_float_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    float_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Float);
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#line 1221
static PyObject *
double_negative(PyObject *a)
{
    npy_double arg1;
    npy_double out;
    PyObject *ret;

    switch(_double_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    double_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Double);
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#line 1221
static PyObject *
longdouble_negative(PyObject *a)
{
    npy_longdouble arg1;
    npy_longdouble out;
    PyObject *ret;

    switch(_longdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longdouble_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(LongDouble);
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#line 1221
static PyObject *
cfloat_negative(PyObject *a)
{
    npy_cfloat arg1;
    npy_cfloat out;
    PyObject *ret;

    switch(_cfloat_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cfloat_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(CFloat);
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#line 1221
static PyObject *
cdouble_negative(PyObject *a)
{
    npy_cdouble arg1;
    npy_cdouble out;
    PyObject *ret;

    switch(_cdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cdouble_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(CDouble);
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#line 1221
static PyObject *
clongdouble_negative(PyObject *a)
{
    npy_clongdouble arg1;
    npy_clongdouble out;
    PyObject *ret;

    switch(_clongdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    clongdouble_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(CLongDouble);
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#line 1221
static PyObject *
byte_positive(PyObject *a)
{
    npy_byte arg1;
    npy_byte out;
    PyObject *ret;

    switch(_byte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    byte_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Byte);
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#line 1221
static PyObject *
ubyte_positive(PyObject *a)
{
    npy_ubyte arg1;
    npy_ubyte out;
    PyObject *ret;

    switch(_ubyte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ubyte_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(UByte);
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#line 1221
static PyObject *
short_positive(PyObject *a)
{
    npy_short arg1;
    npy_short out;
    PyObject *ret;

    switch(_short_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    short_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Short);
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#line 1221
static PyObject *
ushort_positive(PyObject *a)
{
    npy_ushort arg1;
    npy_ushort out;
    PyObject *ret;

    switch(_ushort_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ushort_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(UShort);
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#line 1221
static PyObject *
int_positive(PyObject *a)
{
    npy_int arg1;
    npy_int out;
    PyObject *ret;

    switch(_int_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    int_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Int);
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#line 1221
static PyObject *
uint_positive(PyObject *a)
{
    npy_uint arg1;
    npy_uint out;
    PyObject *ret;

    switch(_uint_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    uint_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(UInt);
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#line 1221
static PyObject *
long_positive(PyObject *a)
{
    npy_long arg1;
    npy_long out;
    PyObject *ret;

    switch(_long_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    long_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Long);
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#line 1221
static PyObject *
ulong_positive(PyObject *a)
{
    npy_ulong arg1;
    npy_ulong out;
    PyObject *ret;

    switch(_ulong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulong_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(ULong);
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#line 1221
static PyObject *
longlong_positive(PyObject *a)
{
    npy_longlong arg1;
    npy_longlong out;
    PyObject *ret;

    switch(_longlong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longlong_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(LongLong);
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#line 1221
static PyObject *
ulonglong_positive(PyObject *a)
{
    npy_ulonglong arg1;
    npy_ulonglong out;
    PyObject *ret;

    switch(_ulonglong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulonglong_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(ULongLong);
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#line 1221
static PyObject *
half_positive(PyObject *a)
{
    npy_half arg1;
    npy_half out;
    PyObject *ret;

    switch(_half_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    half_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Half);
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#line 1221
static PyObject *
float_positive(PyObject *a)
{
    npy_float arg1;
    npy_float out;
    PyObject *ret;

    switch(_float_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    float_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Float);
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#line 1221
static PyObject *
double_positive(PyObject *a)
{
    npy_double arg1;
    npy_double out;
    PyObject *ret;

    switch(_double_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    double_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Double);
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#line 1221
static PyObject *
longdouble_positive(PyObject *a)
{
    npy_longdouble arg1;
    npy_longdouble out;
    PyObject *ret;

    switch(_longdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longdouble_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(LongDouble);
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#line 1221
static PyObject *
cfloat_positive(PyObject *a)
{
    npy_cfloat arg1;
    npy_cfloat out;
    PyObject *ret;

    switch(_cfloat_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cfloat_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(CFloat);
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#line 1221
static PyObject *
cdouble_positive(PyObject *a)
{
    npy_cdouble arg1;
    npy_cdouble out;
    PyObject *ret;

    switch(_cdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cdouble_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(CDouble);
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#line 1221
static PyObject *
clongdouble_positive(PyObject *a)
{
    npy_clongdouble arg1;
    npy_clongdouble out;
    PyObject *ret;

    switch(_clongdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    clongdouble_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(CLongDouble);
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#line 1221
static PyObject *
byte_absolute(PyObject *a)
{
    npy_byte arg1;
    npy_byte out;
    PyObject *ret;

    switch(_byte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    byte_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Byte);
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#line 1221
static PyObject *
ubyte_absolute(PyObject *a)
{
    npy_ubyte arg1;
    npy_ubyte out;
    PyObject *ret;

    switch(_ubyte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ubyte_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(UByte);
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#line 1221
static PyObject *
short_absolute(PyObject *a)
{
    npy_short arg1;
    npy_short out;
    PyObject *ret;

    switch(_short_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    short_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Short);
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#line 1221
static PyObject *
ushort_absolute(PyObject *a)
{
    npy_ushort arg1;
    npy_ushort out;
    PyObject *ret;

    switch(_ushort_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ushort_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(UShort);
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#line 1221
static PyObject *
int_absolute(PyObject *a)
{
    npy_int arg1;
    npy_int out;
    PyObject *ret;

    switch(_int_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    int_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Int);
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#line 1221
static PyObject *
uint_absolute(PyObject *a)
{
    npy_uint arg1;
    npy_uint out;
    PyObject *ret;

    switch(_uint_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    uint_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(UInt);
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#line 1221
static PyObject *
long_absolute(PyObject *a)
{
    npy_long arg1;
    npy_long out;
    PyObject *ret;

    switch(_long_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    long_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Long);
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#line 1221
static PyObject *
ulong_absolute(PyObject *a)
{
    npy_ulong arg1;
    npy_ulong out;
    PyObject *ret;

    switch(_ulong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulong_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(ULong);
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#line 1221
static PyObject *
longlong_absolute(PyObject *a)
{
    npy_longlong arg1;
    npy_longlong out;
    PyObject *ret;

    switch(_longlong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longlong_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(LongLong);
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#line 1221
static PyObject *
ulonglong_absolute(PyObject *a)
{
    npy_ulonglong arg1;
    npy_ulonglong out;
    PyObject *ret;

    switch(_ulonglong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulonglong_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(ULongLong);
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#line 1221
static PyObject *
half_absolute(PyObject *a)
{
    npy_half arg1;
    npy_half out;
    PyObject *ret;

    switch(_half_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    half_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Half);
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#line 1221
static PyObject *
float_absolute(PyObject *a)
{
    npy_float arg1;
    npy_float out;
    PyObject *ret;

    switch(_float_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    float_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Float);
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#line 1221
static PyObject *
double_absolute(PyObject *a)
{
    npy_double arg1;
    npy_double out;
    PyObject *ret;

    switch(_double_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    double_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Double);
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#line 1221
static PyObject *
longdouble_absolute(PyObject *a)
{
    npy_longdouble arg1;
    npy_longdouble out;
    PyObject *ret;

    switch(_longdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longdouble_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(LongDouble);
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#line 1221
static PyObject *
cfloat_absolute(PyObject *a)
{
    npy_cfloat arg1;
    npy_float out;
    PyObject *ret;

    switch(_cfloat_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cfloat_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Float);
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#line 1221
static PyObject *
cdouble_absolute(PyObject *a)
{
    npy_cdouble arg1;
    npy_double out;
    PyObject *ret;

    switch(_cdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cdouble_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Double);
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#line 1221
static PyObject *
clongdouble_absolute(PyObject *a)
{
    npy_clongdouble arg1;
    npy_longdouble out;
    PyObject *ret;

    switch(_clongdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    clongdouble_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(LongDouble);
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#line 1221
static PyObject *
byte_invert(PyObject *a)
{
    npy_byte arg1;
    npy_byte out;
    PyObject *ret;

    switch(_byte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    byte_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(Byte);
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#line 1221
static PyObject *
ubyte_invert(PyObject *a)
{
    npy_ubyte arg1;
    npy_ubyte out;
    PyObject *ret;

    switch(_ubyte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ubyte_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(UByte);
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#line 1221
static PyObject *
short_invert(PyObject *a)
{
    npy_short arg1;
    npy_short out;
    PyObject *ret;

    switch(_short_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    short_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(Short);
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#line 1221
static PyObject *
ushort_invert(PyObject *a)
{
    npy_ushort arg1;
    npy_ushort out;
    PyObject *ret;

    switch(_ushort_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ushort_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(UShort);
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#line 1221
static PyObject *
int_invert(PyObject *a)
{
    npy_int arg1;
    npy_int out;
    PyObject *ret;

    switch(_int_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    int_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(Int);
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#line 1221
static PyObject *
uint_invert(PyObject *a)
{
    npy_uint arg1;
    npy_uint out;
    PyObject *ret;

    switch(_uint_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    uint_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(UInt);
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#line 1221
static PyObject *
long_invert(PyObject *a)
{
    npy_long arg1;
    npy_long out;
    PyObject *ret;

    switch(_long_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    long_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(Long);
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#line 1221
static PyObject *
ulong_invert(PyObject *a)
{
    npy_ulong arg1;
    npy_ulong out;
    PyObject *ret;

    switch(_ulong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulong_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(ULong);
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#line 1221
static PyObject *
longlong_invert(PyObject *a)
{
    npy_longlong arg1;
    npy_longlong out;
    PyObject *ret;

    switch(_longlong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longlong_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(LongLong);
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#line 1221
static PyObject *
ulonglong_invert(PyObject *a)
{
    npy_ulonglong arg1;
    npy_ulonglong out;
    PyObject *ret;

    switch(_ulonglong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulonglong_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(ULongLong);
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}


#line 1261

#define half_invert NULL


#line 1261

#define float_invert NULL


#line 1261

#define double_invert NULL


#line 1261

#define longdouble_invert NULL


#line 1261

#define cfloat_invert NULL


#line 1261

#define cdouble_invert NULL


#line 1261

#define clongdouble_invert NULL



#if defined(NPY_PY3K)
#define NONZERO_NAME(prefix) prefix##bool
#else
#define NONZERO_NAME(prefix) prefix##nonzero
#endif

#define _IS_NONZERO(x) (x != 0)
#line 1286
static int
NONZERO_NAME(byte_)(PyObject *a)
{
    int ret;
    npy_byte arg1;

    if (_byte_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(ubyte_)(PyObject *a)
{
    int ret;
    npy_ubyte arg1;

    if (_ubyte_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(short_)(PyObject *a)
{
    int ret;
    npy_short arg1;

    if (_short_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(ushort_)(PyObject *a)
{
    int ret;
    npy_ushort arg1;

    if (_ushort_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(int_)(PyObject *a)
{
    int ret;
    npy_int arg1;

    if (_int_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(uint_)(PyObject *a)
{
    int ret;
    npy_uint arg1;

    if (_uint_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(long_)(PyObject *a)
{
    int ret;
    npy_long arg1;

    if (_long_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(ulong_)(PyObject *a)
{
    int ret;
    npy_ulong arg1;

    if (_ulong_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(longlong_)(PyObject *a)
{
    int ret;
    npy_longlong arg1;

    if (_longlong_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(ulonglong_)(PyObject *a)
{
    int ret;
    npy_ulonglong arg1;

    if (_ulonglong_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(half_)(PyObject *a)
{
    int ret;
    npy_half arg1;

    if (_half_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = !npy_half_iszero(arg1);
#else
    ret = (!npy_half_iszero(arg1.real) || !npy_half_iszero(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(float_)(PyObject *a)
{
    int ret;
    npy_float arg1;

    if (_float_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(double_)(PyObject *a)
{
    int ret;
    npy_double arg1;

    if (_double_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(longdouble_)(PyObject *a)
{
    int ret;
    npy_longdouble arg1;

    if (_longdouble_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(cfloat_)(PyObject *a)
{
    int ret;
    npy_cfloat arg1;

    if (_cfloat_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 0
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(cdouble_)(PyObject *a)
{
    int ret;
    npy_cdouble arg1;

    if (_cdouble_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 0
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1286
static int
NONZERO_NAME(clongdouble_)(PyObject *a)
{
    int ret;
    npy_clongdouble arg1;

    if (_clongdouble_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 0
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#undef _IS_NONZERO


static int
emit_complexwarning(void)
{
    static PyObject *cls = NULL;
    if (cls == NULL) {
        PyObject *mod;
        mod = PyImport_ImportModule("numpy.core");
        assert(mod != NULL);
        cls = PyObject_GetAttrString(mod, "ComplexWarning");
        assert(cls != NULL);
        Py_DECREF(mod);
    }
    return PyErr_WarnEx(cls,
            "Casting complex values to real discards the imaginary part", 1);
}

#line 1354
static PyObject *
byte_int(PyObject *obj)
{
#if 0
    signed long x= (PyArrayScalar_VAL(obj, Byte).real);
    int ret;
#else
    signed long x= (PyArrayScalar_VAL(obj, Byte));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromLong(x);
}

#line 1354
static PyObject *
ubyte_int(PyObject *obj)
{
#if 0
    unsigned long x= (PyArrayScalar_VAL(obj, UByte).real);
    int ret;
#else
    unsigned long x= (PyArrayScalar_VAL(obj, UByte));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 1
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromUnsignedLong(x);
}

#line 1354
static PyObject *
short_int(PyObject *obj)
{
#if 0
    signed long x= (PyArrayScalar_VAL(obj, Short).real);
    int ret;
#else
    signed long x= (PyArrayScalar_VAL(obj, Short));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromLong(x);
}

#line 1354
static PyObject *
ushort_int(PyObject *obj)
{
#if 0
    unsigned long x= (PyArrayScalar_VAL(obj, UShort).real);
    int ret;
#else
    unsigned long x= (PyArrayScalar_VAL(obj, UShort));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 1
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromUnsignedLong(x);
}

#line 1354
static PyObject *
int_int(PyObject *obj)
{
#if 0
    signed long x= (PyArrayScalar_VAL(obj, Int).real);
    int ret;
#else
    signed long x= (PyArrayScalar_VAL(obj, Int));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromLong(x);
}

#line 1354
static PyObject *
uint_int(PyObject *obj)
{
#if 0
    unsigned long x= (PyArrayScalar_VAL(obj, UInt).real);
    int ret;
#else
    unsigned long x= (PyArrayScalar_VAL(obj, UInt));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 1
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromUnsignedLong(x);
}

#line 1354
static PyObject *
long_int(PyObject *obj)
{
#if 0
    signed long x= (PyArrayScalar_VAL(obj, Long).real);
    int ret;
#else
    signed long x= (PyArrayScalar_VAL(obj, Long));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromLong(x);
}

#line 1354
static PyObject *
ulong_int(PyObject *obj)
{
#if 0
    unsigned long x= (PyArrayScalar_VAL(obj, ULong).real);
    int ret;
#else
    unsigned long x= (PyArrayScalar_VAL(obj, ULong));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 1
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromUnsignedLong(x);
}

#line 1354
static PyObject *
longlong_int(PyObject *obj)
{
#if 0
    signed PY_LONG_LONG x= (PyArrayScalar_VAL(obj, LongLong).real);
    int ret;
#else
    signed PY_LONG_LONG x= (PyArrayScalar_VAL(obj, LongLong));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromLongLong(x);
}

#line 1354
static PyObject *
ulonglong_int(PyObject *obj)
{
#if 0
    unsigned PY_LONG_LONG x= (PyArrayScalar_VAL(obj, ULongLong).real);
    int ret;
#else
    unsigned PY_LONG_LONG x= (PyArrayScalar_VAL(obj, ULongLong));
#endif

#if 0
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 1
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromUnsignedLongLong(x);
}

#line 1354
static PyObject *
half_int(PyObject *obj)
{
#if 0
     double x= npy_half_to_double(PyArrayScalar_VAL(obj, Half).real);
    int ret;
#else
     double x= npy_half_to_double(PyArrayScalar_VAL(obj, Half));
#endif

#if 1
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromDouble(x);
}

#line 1354
static PyObject *
float_int(PyObject *obj)
{
#if 0
     double x= (PyArrayScalar_VAL(obj, Float).real);
    int ret;
#else
     double x= (PyArrayScalar_VAL(obj, Float));
#endif

#if 1
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromDouble(x);
}

#line 1354
static PyObject *
double_int(PyObject *obj)
{
#if 0
     double x= (PyArrayScalar_VAL(obj, Double).real);
    int ret;
#else
     double x= (PyArrayScalar_VAL(obj, Double));
#endif

#if 1
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromDouble(x);
}

#line 1354
static PyObject *
longdouble_int(PyObject *obj)
{
#if 0
     double x= (PyArrayScalar_VAL(obj, LongDouble).real);
    int ret;
#else
     double x= (PyArrayScalar_VAL(obj, LongDouble));
#endif

#if 1
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 0
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromDouble(x);
}

#line 1354
static PyObject *
cfloat_int(PyObject *obj)
{
#if 1
     double x= (PyArrayScalar_VAL(obj, CFloat).real);
    int ret;
#else
     double x= (PyArrayScalar_VAL(obj, CFloat));
#endif

#if 1
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 1
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromDouble(x);
}

#line 1354
static PyObject *
cdouble_int(PyObject *obj)
{
#if 1
     double x= (PyArrayScalar_VAL(obj, CDouble).real);
    int ret;
#else
     double x= (PyArrayScalar_VAL(obj, CDouble));
#endif

#if 1
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 1
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromDouble(x);
}

#line 1354
static PyObject *
clongdouble_int(PyObject *obj)
{
#if 1
     double x= (PyArrayScalar_VAL(obj, CLongDouble).real);
    int ret;
#else
     double x= (PyArrayScalar_VAL(obj, CLongDouble));
#endif

#if 1
    double ix;
    modf(x, &ix);
    x = ix;
#endif

#if 1
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
#endif

#if 0
    if(x < LONG_MAX)
        return PyInt_FromLong(x);
#else
    if(LONG_MIN < x && x < LONG_MAX)
        return PyInt_FromLong(x);
#endif
    return PyLong_FromDouble(x);
}


#line 1404
static PyObject *
byte_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromLongLong(((PyArrayScalar_VAL(obj, Byte)).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Byte)));
#endif
}

#line 1404
static PyObject *
ubyte_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong(((PyArrayScalar_VAL(obj, UByte)).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UByte)));
#endif
}

#line 1404
static PyObject *
short_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromLongLong(((PyArrayScalar_VAL(obj, Short)).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Short)));
#endif
}

#line 1404
static PyObject *
ushort_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong(((PyArrayScalar_VAL(obj, UShort)).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UShort)));
#endif
}

#line 1404
static PyObject *
int_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromLongLong(((PyArrayScalar_VAL(obj, Int)).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Int)));
#endif
}

#line 1404
static PyObject *
uint_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong(((PyArrayScalar_VAL(obj, UInt)).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UInt)));
#endif
}

#line 1404
static PyObject *
long_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromLongLong(((PyArrayScalar_VAL(obj, Long)).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Long)));
#endif
}

#line 1404
static PyObject *
ulong_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong(((PyArrayScalar_VAL(obj, ULong)).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, ULong)));
#endif
}

#line 1404
static PyObject *
longlong_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromLongLong(((PyArrayScalar_VAL(obj, LongLong)).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, LongLong)));
#endif
}

#line 1404
static PyObject *
ulonglong_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong(((PyArrayScalar_VAL(obj, ULongLong)).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, ULongLong)));
#endif
}

#line 1404
static PyObject *
half_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromDouble(npy_half_to_double((PyArrayScalar_VAL(obj, Half)).real));
#else
    return PyLong_FromDouble(npy_half_to_double(PyArrayScalar_VAL(obj, Half)));
#endif
}

#line 1404
static PyObject *
float_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromDouble(((PyArrayScalar_VAL(obj, Float)).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, Float)));
#endif
}

#line 1404
static PyObject *
double_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromDouble(((PyArrayScalar_VAL(obj, Double)).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, Double)));
#endif
}

#line 1404
static PyObject *
longdouble_long(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromDouble(((PyArrayScalar_VAL(obj, LongDouble)).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, LongDouble)));
#endif
}

#line 1404
static PyObject *
cfloat_long(PyObject *obj)
{
#if 1
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromDouble(((PyArrayScalar_VAL(obj, CFloat)).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, CFloat)));
#endif
}

#line 1404
static PyObject *
cdouble_long(PyObject *obj)
{
#if 1
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromDouble(((PyArrayScalar_VAL(obj, CDouble)).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, CDouble)));
#endif
}

#line 1404
static PyObject *
clongdouble_long(PyObject *obj)
{
#if 1
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyLong_FromDouble(((PyArrayScalar_VAL(obj, CLongDouble)).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, CLongDouble)));
#endif
}

#line 1404
static PyObject *
byte_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, Byte)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Byte)));
#endif
}

#line 1404
static PyObject *
ubyte_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, UByte)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UByte)));
#endif
}

#line 1404
static PyObject *
short_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, Short)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Short)));
#endif
}

#line 1404
static PyObject *
ushort_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, UShort)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UShort)));
#endif
}

#line 1404
static PyObject *
int_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, Int)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Int)));
#endif
}

#line 1404
static PyObject *
uint_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, UInt)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UInt)));
#endif
}

#line 1404
static PyObject *
long_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, Long)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Long)));
#endif
}

#line 1404
static PyObject *
ulong_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, ULong)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, ULong)));
#endif
}

#line 1404
static PyObject *
longlong_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, LongLong)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, LongLong)));
#endif
}

#line 1404
static PyObject *
ulonglong_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, ULongLong)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, ULongLong)));
#endif
}

#line 1404
static PyObject *
half_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(npy_half_to_double((PyArrayScalar_VAL(obj, Half)).real));
#else
    return PyFloat_FromDouble(npy_half_to_double(PyArrayScalar_VAL(obj, Half)));
#endif
}

#line 1404
static PyObject *
float_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, Float)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Float)));
#endif
}

#line 1404
static PyObject *
double_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, Double)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Double)));
#endif
}

#line 1404
static PyObject *
longdouble_float(PyObject *obj)
{
#if 0
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, LongDouble)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, LongDouble)));
#endif
}

#line 1404
static PyObject *
cfloat_float(PyObject *obj)
{
#if 1
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, CFloat)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CFloat)));
#endif
}

#line 1404
static PyObject *
cdouble_float(PyObject *obj)
{
#if 1
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, CDouble)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CDouble)));
#endif
}

#line 1404
static PyObject *
clongdouble_float(PyObject *obj)
{
#if 1
    int ret;
    ret = emit_complexwarning();
    if (ret < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(((PyArrayScalar_VAL(obj, CLongDouble)).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CLongDouble)));
#endif
}


#if !defined(NPY_PY3K)

#line 1432
static PyObject *
byte_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = byte_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
ubyte_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = ubyte_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
short_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = short_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
ushort_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = ushort_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
int_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = int_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
uint_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = uint_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
long_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = long_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
ulong_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = ulong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
longlong_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = longlong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
ulonglong_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = ulonglong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
half_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = half_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
float_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = float_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
double_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = double_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
longdouble_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = longdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
cfloat_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = cfloat_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
cdouble_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = cdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
clongdouble_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = clongdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1432
static PyObject *
byte_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = byte_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
ubyte_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = ubyte_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
short_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = short_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
ushort_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = ushort_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
int_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = int_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
uint_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = uint_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
long_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = long_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
ulong_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = ulong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
longlong_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = longlong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
ulonglong_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = ulonglong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
half_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = half_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
float_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = float_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
double_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = double_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
longdouble_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = longdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
cfloat_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = cfloat_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
cdouble_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = cdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1432
static PyObject *
clongdouble_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = clongdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}


#endif

#line 1452
#define def_cmp_le(arg1, arg2) (arg1 <= arg2)
#define cmplx_cmp_le(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag <= arg2.imag :        \
                                      arg1.real <= arg2.real)
#define def_half_cmp_le(arg1, arg2) npy_half_le(arg1, arg2)

#line 1452
#define def_cmp_ge(arg1, arg2) (arg1 >= arg2)
#define cmplx_cmp_ge(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag >= arg2.imag :        \
                                      arg1.real >= arg2.real)
#define def_half_cmp_ge(arg1, arg2) npy_half_ge(arg1, arg2)

#line 1452
#define def_cmp_lt(arg1, arg2) (arg1 < arg2)
#define cmplx_cmp_lt(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag < arg2.imag :        \
                                      arg1.real < arg2.real)
#define def_half_cmp_lt(arg1, arg2) npy_half_lt(arg1, arg2)

#line 1452
#define def_cmp_gt(arg1, arg2) (arg1 > arg2)
#define cmplx_cmp_gt(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag > arg2.imag :        \
                                      arg1.real > arg2.real)
#define def_half_cmp_gt(arg1, arg2) npy_half_gt(arg1, arg2)

#line 1452
#define def_cmp_eq(arg1, arg2) (arg1 == arg2)
#define cmplx_cmp_eq(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag == arg2.imag :        \
                                      arg1.real == arg2.real)
#define def_half_cmp_eq(arg1, arg2) npy_half_eq(arg1, arg2)

#line 1452
#define def_cmp_ne(arg1, arg2) (arg1 != arg2)
#define cmplx_cmp_ne(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag != arg2.imag :        \
                                      arg1.real != arg2.real)
#define def_half_cmp_ne(arg1, arg2) npy_half_ne(arg1, arg2)


#line 1466
static PyObject*
byte_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_byte arg1, arg2;
    int out=0;

    switch(_byte_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
ubyte_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_ubyte arg1, arg2;
    int out=0;

    switch(_ubyte_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
short_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_short arg1, arg2;
    int out=0;

    switch(_short_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
ushort_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_ushort arg1, arg2;
    int out=0;

    switch(_ushort_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
int_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_int arg1, arg2;
    int out=0;

    switch(_int_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
uint_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_uint arg1, arg2;
    int out=0;

    switch(_uint_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
long_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_long arg1, arg2;
    int out=0;

    switch(_long_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
ulong_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_ulong arg1, arg2;
    int out=0;

    switch(_ulong_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
longlong_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_longlong arg1, arg2;
    int out=0;

    switch(_longlong_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
ulonglong_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_ulonglong arg1, arg2;
    int out=0;

    switch(_ulonglong_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
half_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_half arg1, arg2;
    int out=0;

    switch(_half_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_half_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_half_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_half_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_half_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_half_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_half_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
float_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_float arg1, arg2;
    int out=0;

    switch(_float_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
double_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_double arg1, arg2;
    int out=0;

    switch(_double_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
longdouble_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_longdouble arg1, arg2;
    int out=0;

    switch(_longdouble_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
cfloat_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_cfloat arg1, arg2;
    int out=0;

    switch(_cfloat_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = cmplx_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = cmplx_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = cmplx_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = cmplx_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = cmplx_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = cmplx_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
cdouble_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_cdouble arg1, arg2;
    int out=0;

    switch(_cdouble_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = cmplx_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = cmplx_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = cmplx_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = cmplx_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = cmplx_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = cmplx_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1466
static PyObject*
clongdouble_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_clongdouble arg1, arg2;
    int out=0;

    switch(_clongdouble_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = cmplx_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = cmplx_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = cmplx_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = cmplx_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = cmplx_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = cmplx_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}



#line 1530
static PyNumberMethods byte_as_number = {
    (binaryfunc)byte_add,                     /*nb_add*/
    (binaryfunc)byte_subtract,                /*nb_subtract*/
    (binaryfunc)byte_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)byte_divide,                  /*nb_divide*/
#endif
    (binaryfunc)byte_remainder,               /*nb_remainder*/
    (binaryfunc)byte_divmod,                  /*nb_divmod*/
    (ternaryfunc)byte_power,                  /*nb_power*/
    (unaryfunc)byte_negative,
    (unaryfunc)byte_positive,                 /*nb_pos*/
    (unaryfunc)byte_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)byte_bool,                       /*nb_bool*/
#else
    (inquiry)byte_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)byte_invert,                   /*nb_invert*/
    (binaryfunc)byte_lshift,                  /*nb_lshift*/
    (binaryfunc)byte_rshift,                  /*nb_rshift*/
    (binaryfunc)byte_and,                     /*nb_and*/
    (binaryfunc)byte_xor,                     /*nb_xor*/
    (binaryfunc)byte_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)byte_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)byte_long,                     /*nb_long*/
#endif
    (unaryfunc)byte_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)byte_oct,                      /*nb_oct*/
    (unaryfunc)byte_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)byte_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)byte_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods ubyte_as_number = {
    (binaryfunc)ubyte_add,                     /*nb_add*/
    (binaryfunc)ubyte_subtract,                /*nb_subtract*/
    (binaryfunc)ubyte_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)ubyte_divide,                  /*nb_divide*/
#endif
    (binaryfunc)ubyte_remainder,               /*nb_remainder*/
    (binaryfunc)ubyte_divmod,                  /*nb_divmod*/
    (ternaryfunc)ubyte_power,                  /*nb_power*/
    (unaryfunc)ubyte_negative,
    (unaryfunc)ubyte_positive,                 /*nb_pos*/
    (unaryfunc)ubyte_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)ubyte_bool,                       /*nb_bool*/
#else
    (inquiry)ubyte_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)ubyte_invert,                   /*nb_invert*/
    (binaryfunc)ubyte_lshift,                  /*nb_lshift*/
    (binaryfunc)ubyte_rshift,                  /*nb_rshift*/
    (binaryfunc)ubyte_and,                     /*nb_and*/
    (binaryfunc)ubyte_xor,                     /*nb_xor*/
    (binaryfunc)ubyte_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)ubyte_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)ubyte_long,                     /*nb_long*/
#endif
    (unaryfunc)ubyte_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)ubyte_oct,                      /*nb_oct*/
    (unaryfunc)ubyte_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)ubyte_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)ubyte_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods short_as_number = {
    (binaryfunc)short_add,                     /*nb_add*/
    (binaryfunc)short_subtract,                /*nb_subtract*/
    (binaryfunc)short_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)short_divide,                  /*nb_divide*/
#endif
    (binaryfunc)short_remainder,               /*nb_remainder*/
    (binaryfunc)short_divmod,                  /*nb_divmod*/
    (ternaryfunc)short_power,                  /*nb_power*/
    (unaryfunc)short_negative,
    (unaryfunc)short_positive,                 /*nb_pos*/
    (unaryfunc)short_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)short_bool,                       /*nb_bool*/
#else
    (inquiry)short_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)short_invert,                   /*nb_invert*/
    (binaryfunc)short_lshift,                  /*nb_lshift*/
    (binaryfunc)short_rshift,                  /*nb_rshift*/
    (binaryfunc)short_and,                     /*nb_and*/
    (binaryfunc)short_xor,                     /*nb_xor*/
    (binaryfunc)short_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)short_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)short_long,                     /*nb_long*/
#endif
    (unaryfunc)short_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)short_oct,                      /*nb_oct*/
    (unaryfunc)short_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)short_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)short_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods ushort_as_number = {
    (binaryfunc)ushort_add,                     /*nb_add*/
    (binaryfunc)ushort_subtract,                /*nb_subtract*/
    (binaryfunc)ushort_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)ushort_divide,                  /*nb_divide*/
#endif
    (binaryfunc)ushort_remainder,               /*nb_remainder*/
    (binaryfunc)ushort_divmod,                  /*nb_divmod*/
    (ternaryfunc)ushort_power,                  /*nb_power*/
    (unaryfunc)ushort_negative,
    (unaryfunc)ushort_positive,                 /*nb_pos*/
    (unaryfunc)ushort_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)ushort_bool,                       /*nb_bool*/
#else
    (inquiry)ushort_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)ushort_invert,                   /*nb_invert*/
    (binaryfunc)ushort_lshift,                  /*nb_lshift*/
    (binaryfunc)ushort_rshift,                  /*nb_rshift*/
    (binaryfunc)ushort_and,                     /*nb_and*/
    (binaryfunc)ushort_xor,                     /*nb_xor*/
    (binaryfunc)ushort_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)ushort_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)ushort_long,                     /*nb_long*/
#endif
    (unaryfunc)ushort_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)ushort_oct,                      /*nb_oct*/
    (unaryfunc)ushort_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)ushort_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)ushort_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods int_as_number = {
    (binaryfunc)int_add,                     /*nb_add*/
    (binaryfunc)int_subtract,                /*nb_subtract*/
    (binaryfunc)int_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)int_divide,                  /*nb_divide*/
#endif
    (binaryfunc)int_remainder,               /*nb_remainder*/
    (binaryfunc)int_divmod,                  /*nb_divmod*/
    (ternaryfunc)int_power,                  /*nb_power*/
    (unaryfunc)int_negative,
    (unaryfunc)int_positive,                 /*nb_pos*/
    (unaryfunc)int_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)int_bool,                       /*nb_bool*/
#else
    (inquiry)int_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)int_invert,                   /*nb_invert*/
    (binaryfunc)int_lshift,                  /*nb_lshift*/
    (binaryfunc)int_rshift,                  /*nb_rshift*/
    (binaryfunc)int_and,                     /*nb_and*/
    (binaryfunc)int_xor,                     /*nb_xor*/
    (binaryfunc)int_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)int_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)int_long,                     /*nb_long*/
#endif
    (unaryfunc)int_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)int_oct,                      /*nb_oct*/
    (unaryfunc)int_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)int_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)int_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods uint_as_number = {
    (binaryfunc)uint_add,                     /*nb_add*/
    (binaryfunc)uint_subtract,                /*nb_subtract*/
    (binaryfunc)uint_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)uint_divide,                  /*nb_divide*/
#endif
    (binaryfunc)uint_remainder,               /*nb_remainder*/
    (binaryfunc)uint_divmod,                  /*nb_divmod*/
    (ternaryfunc)uint_power,                  /*nb_power*/
    (unaryfunc)uint_negative,
    (unaryfunc)uint_positive,                 /*nb_pos*/
    (unaryfunc)uint_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)uint_bool,                       /*nb_bool*/
#else
    (inquiry)uint_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)uint_invert,                   /*nb_invert*/
    (binaryfunc)uint_lshift,                  /*nb_lshift*/
    (binaryfunc)uint_rshift,                  /*nb_rshift*/
    (binaryfunc)uint_and,                     /*nb_and*/
    (binaryfunc)uint_xor,                     /*nb_xor*/
    (binaryfunc)uint_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)uint_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)uint_long,                     /*nb_long*/
#endif
    (unaryfunc)uint_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)uint_oct,                      /*nb_oct*/
    (unaryfunc)uint_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)uint_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)uint_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods long_as_number = {
    (binaryfunc)long_add,                     /*nb_add*/
    (binaryfunc)long_subtract,                /*nb_subtract*/
    (binaryfunc)long_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)long_divide,                  /*nb_divide*/
#endif
    (binaryfunc)long_remainder,               /*nb_remainder*/
    (binaryfunc)long_divmod,                  /*nb_divmod*/
    (ternaryfunc)long_power,                  /*nb_power*/
    (unaryfunc)long_negative,
    (unaryfunc)long_positive,                 /*nb_pos*/
    (unaryfunc)long_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)long_bool,                       /*nb_bool*/
#else
    (inquiry)long_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)long_invert,                   /*nb_invert*/
    (binaryfunc)long_lshift,                  /*nb_lshift*/
    (binaryfunc)long_rshift,                  /*nb_rshift*/
    (binaryfunc)long_and,                     /*nb_and*/
    (binaryfunc)long_xor,                     /*nb_xor*/
    (binaryfunc)long_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)long_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)long_long,                     /*nb_long*/
#endif
    (unaryfunc)long_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)long_oct,                      /*nb_oct*/
    (unaryfunc)long_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)long_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)long_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods ulong_as_number = {
    (binaryfunc)ulong_add,                     /*nb_add*/
    (binaryfunc)ulong_subtract,                /*nb_subtract*/
    (binaryfunc)ulong_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)ulong_divide,                  /*nb_divide*/
#endif
    (binaryfunc)ulong_remainder,               /*nb_remainder*/
    (binaryfunc)ulong_divmod,                  /*nb_divmod*/
    (ternaryfunc)ulong_power,                  /*nb_power*/
    (unaryfunc)ulong_negative,
    (unaryfunc)ulong_positive,                 /*nb_pos*/
    (unaryfunc)ulong_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)ulong_bool,                       /*nb_bool*/
#else
    (inquiry)ulong_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)ulong_invert,                   /*nb_invert*/
    (binaryfunc)ulong_lshift,                  /*nb_lshift*/
    (binaryfunc)ulong_rshift,                  /*nb_rshift*/
    (binaryfunc)ulong_and,                     /*nb_and*/
    (binaryfunc)ulong_xor,                     /*nb_xor*/
    (binaryfunc)ulong_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)ulong_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)ulong_long,                     /*nb_long*/
#endif
    (unaryfunc)ulong_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)ulong_oct,                      /*nb_oct*/
    (unaryfunc)ulong_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)ulong_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)ulong_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods longlong_as_number = {
    (binaryfunc)longlong_add,                     /*nb_add*/
    (binaryfunc)longlong_subtract,                /*nb_subtract*/
    (binaryfunc)longlong_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)longlong_divide,                  /*nb_divide*/
#endif
    (binaryfunc)longlong_remainder,               /*nb_remainder*/
    (binaryfunc)longlong_divmod,                  /*nb_divmod*/
    (ternaryfunc)longlong_power,                  /*nb_power*/
    (unaryfunc)longlong_negative,
    (unaryfunc)longlong_positive,                 /*nb_pos*/
    (unaryfunc)longlong_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)longlong_bool,                       /*nb_bool*/
#else
    (inquiry)longlong_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)longlong_invert,                   /*nb_invert*/
    (binaryfunc)longlong_lshift,                  /*nb_lshift*/
    (binaryfunc)longlong_rshift,                  /*nb_rshift*/
    (binaryfunc)longlong_and,                     /*nb_and*/
    (binaryfunc)longlong_xor,                     /*nb_xor*/
    (binaryfunc)longlong_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)longlong_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)longlong_long,                     /*nb_long*/
#endif
    (unaryfunc)longlong_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)longlong_oct,                      /*nb_oct*/
    (unaryfunc)longlong_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)longlong_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)longlong_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods ulonglong_as_number = {
    (binaryfunc)ulonglong_add,                     /*nb_add*/
    (binaryfunc)ulonglong_subtract,                /*nb_subtract*/
    (binaryfunc)ulonglong_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)ulonglong_divide,                  /*nb_divide*/
#endif
    (binaryfunc)ulonglong_remainder,               /*nb_remainder*/
    (binaryfunc)ulonglong_divmod,                  /*nb_divmod*/
    (ternaryfunc)ulonglong_power,                  /*nb_power*/
    (unaryfunc)ulonglong_negative,
    (unaryfunc)ulonglong_positive,                 /*nb_pos*/
    (unaryfunc)ulonglong_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)ulonglong_bool,                       /*nb_bool*/
#else
    (inquiry)ulonglong_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)ulonglong_invert,                   /*nb_invert*/
    (binaryfunc)ulonglong_lshift,                  /*nb_lshift*/
    (binaryfunc)ulonglong_rshift,                  /*nb_rshift*/
    (binaryfunc)ulonglong_and,                     /*nb_and*/
    (binaryfunc)ulonglong_xor,                     /*nb_xor*/
    (binaryfunc)ulonglong_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)ulonglong_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)ulonglong_long,                     /*nb_long*/
#endif
    (unaryfunc)ulonglong_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)ulonglong_oct,                      /*nb_oct*/
    (unaryfunc)ulonglong_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)ulonglong_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)ulonglong_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods half_as_number = {
    (binaryfunc)half_add,                     /*nb_add*/
    (binaryfunc)half_subtract,                /*nb_subtract*/
    (binaryfunc)half_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)half_divide,                  /*nb_divide*/
#endif
    (binaryfunc)half_remainder,               /*nb_remainder*/
    (binaryfunc)half_divmod,                  /*nb_divmod*/
    (ternaryfunc)half_power,                  /*nb_power*/
    (unaryfunc)half_negative,
    (unaryfunc)half_positive,                 /*nb_pos*/
    (unaryfunc)half_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)half_bool,                       /*nb_bool*/
#else
    (inquiry)half_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)half_invert,                   /*nb_invert*/
    (binaryfunc)half_lshift,                  /*nb_lshift*/
    (binaryfunc)half_rshift,                  /*nb_rshift*/
    (binaryfunc)half_and,                     /*nb_and*/
    (binaryfunc)half_xor,                     /*nb_xor*/
    (binaryfunc)half_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)half_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)half_long,                     /*nb_long*/
#endif
    (unaryfunc)half_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)half_oct,                      /*nb_oct*/
    (unaryfunc)half_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)half_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)half_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods float_as_number = {
    (binaryfunc)float_add,                     /*nb_add*/
    (binaryfunc)float_subtract,                /*nb_subtract*/
    (binaryfunc)float_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)float_divide,                  /*nb_divide*/
#endif
    (binaryfunc)float_remainder,               /*nb_remainder*/
    (binaryfunc)float_divmod,                  /*nb_divmod*/
    (ternaryfunc)float_power,                  /*nb_power*/
    (unaryfunc)float_negative,
    (unaryfunc)float_positive,                 /*nb_pos*/
    (unaryfunc)float_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)float_bool,                       /*nb_bool*/
#else
    (inquiry)float_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)float_invert,                   /*nb_invert*/
    (binaryfunc)float_lshift,                  /*nb_lshift*/
    (binaryfunc)float_rshift,                  /*nb_rshift*/
    (binaryfunc)float_and,                     /*nb_and*/
    (binaryfunc)float_xor,                     /*nb_xor*/
    (binaryfunc)float_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)float_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)float_long,                     /*nb_long*/
#endif
    (unaryfunc)float_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)float_oct,                      /*nb_oct*/
    (unaryfunc)float_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)float_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)float_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods double_as_number = {
    (binaryfunc)double_add,                     /*nb_add*/
    (binaryfunc)double_subtract,                /*nb_subtract*/
    (binaryfunc)double_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)double_divide,                  /*nb_divide*/
#endif
    (binaryfunc)double_remainder,               /*nb_remainder*/
    (binaryfunc)double_divmod,                  /*nb_divmod*/
    (ternaryfunc)double_power,                  /*nb_power*/
    (unaryfunc)double_negative,
    (unaryfunc)double_positive,                 /*nb_pos*/
    (unaryfunc)double_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)double_bool,                       /*nb_bool*/
#else
    (inquiry)double_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)double_invert,                   /*nb_invert*/
    (binaryfunc)double_lshift,                  /*nb_lshift*/
    (binaryfunc)double_rshift,                  /*nb_rshift*/
    (binaryfunc)double_and,                     /*nb_and*/
    (binaryfunc)double_xor,                     /*nb_xor*/
    (binaryfunc)double_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)double_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)double_long,                     /*nb_long*/
#endif
    (unaryfunc)double_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)double_oct,                      /*nb_oct*/
    (unaryfunc)double_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)double_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)double_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods longdouble_as_number = {
    (binaryfunc)longdouble_add,                     /*nb_add*/
    (binaryfunc)longdouble_subtract,                /*nb_subtract*/
    (binaryfunc)longdouble_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)longdouble_divide,                  /*nb_divide*/
#endif
    (binaryfunc)longdouble_remainder,               /*nb_remainder*/
    (binaryfunc)longdouble_divmod,                  /*nb_divmod*/
    (ternaryfunc)longdouble_power,                  /*nb_power*/
    (unaryfunc)longdouble_negative,
    (unaryfunc)longdouble_positive,                 /*nb_pos*/
    (unaryfunc)longdouble_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)longdouble_bool,                       /*nb_bool*/
#else
    (inquiry)longdouble_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)longdouble_invert,                   /*nb_invert*/
    (binaryfunc)longdouble_lshift,                  /*nb_lshift*/
    (binaryfunc)longdouble_rshift,                  /*nb_rshift*/
    (binaryfunc)longdouble_and,                     /*nb_and*/
    (binaryfunc)longdouble_xor,                     /*nb_xor*/
    (binaryfunc)longdouble_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)longdouble_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)longdouble_long,                     /*nb_long*/
#endif
    (unaryfunc)longdouble_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)longdouble_oct,                      /*nb_oct*/
    (unaryfunc)longdouble_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)longdouble_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)longdouble_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods cfloat_as_number = {
    (binaryfunc)cfloat_add,                     /*nb_add*/
    (binaryfunc)cfloat_subtract,                /*nb_subtract*/
    (binaryfunc)cfloat_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)cfloat_divide,                  /*nb_divide*/
#endif
    (binaryfunc)cfloat_remainder,               /*nb_remainder*/
    (binaryfunc)cfloat_divmod,                  /*nb_divmod*/
    (ternaryfunc)cfloat_power,                  /*nb_power*/
    (unaryfunc)cfloat_negative,
    (unaryfunc)cfloat_positive,                 /*nb_pos*/
    (unaryfunc)cfloat_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)cfloat_bool,                       /*nb_bool*/
#else
    (inquiry)cfloat_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)cfloat_invert,                   /*nb_invert*/
    (binaryfunc)cfloat_lshift,                  /*nb_lshift*/
    (binaryfunc)cfloat_rshift,                  /*nb_rshift*/
    (binaryfunc)cfloat_and,                     /*nb_and*/
    (binaryfunc)cfloat_xor,                     /*nb_xor*/
    (binaryfunc)cfloat_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)cfloat_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)cfloat_long,                     /*nb_long*/
#endif
    (unaryfunc)cfloat_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)cfloat_oct,                      /*nb_oct*/
    (unaryfunc)cfloat_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)cfloat_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)cfloat_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods cdouble_as_number = {
    (binaryfunc)cdouble_add,                     /*nb_add*/
    (binaryfunc)cdouble_subtract,                /*nb_subtract*/
    (binaryfunc)cdouble_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)cdouble_divide,                  /*nb_divide*/
#endif
    (binaryfunc)cdouble_remainder,               /*nb_remainder*/
    (binaryfunc)cdouble_divmod,                  /*nb_divmod*/
    (ternaryfunc)cdouble_power,                  /*nb_power*/
    (unaryfunc)cdouble_negative,
    (unaryfunc)cdouble_positive,                 /*nb_pos*/
    (unaryfunc)cdouble_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)cdouble_bool,                       /*nb_bool*/
#else
    (inquiry)cdouble_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)cdouble_invert,                   /*nb_invert*/
    (binaryfunc)cdouble_lshift,                  /*nb_lshift*/
    (binaryfunc)cdouble_rshift,                  /*nb_rshift*/
    (binaryfunc)cdouble_and,                     /*nb_and*/
    (binaryfunc)cdouble_xor,                     /*nb_xor*/
    (binaryfunc)cdouble_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)cdouble_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)cdouble_long,                     /*nb_long*/
#endif
    (unaryfunc)cdouble_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)cdouble_oct,                      /*nb_oct*/
    (unaryfunc)cdouble_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)cdouble_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)cdouble_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};

#line 1530
static PyNumberMethods clongdouble_as_number = {
    (binaryfunc)clongdouble_add,                     /*nb_add*/
    (binaryfunc)clongdouble_subtract,                /*nb_subtract*/
    (binaryfunc)clongdouble_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)clongdouble_divide,                  /*nb_divide*/
#endif
    (binaryfunc)clongdouble_remainder,               /*nb_remainder*/
    (binaryfunc)clongdouble_divmod,                  /*nb_divmod*/
    (ternaryfunc)clongdouble_power,                  /*nb_power*/
    (unaryfunc)clongdouble_negative,
    (unaryfunc)clongdouble_positive,                 /*nb_pos*/
    (unaryfunc)clongdouble_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)clongdouble_bool,                       /*nb_bool*/
#else
    (inquiry)clongdouble_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)clongdouble_invert,                   /*nb_invert*/
    (binaryfunc)clongdouble_lshift,                  /*nb_lshift*/
    (binaryfunc)clongdouble_rshift,                  /*nb_rshift*/
    (binaryfunc)clongdouble_and,                     /*nb_and*/
    (binaryfunc)clongdouble_xor,                     /*nb_xor*/
    (binaryfunc)clongdouble_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)clongdouble_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)clongdouble_long,                     /*nb_long*/
#endif
    (unaryfunc)clongdouble_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)clongdouble_oct,                      /*nb_oct*/
    (unaryfunc)clongdouble_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)clongdouble_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)clongdouble_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
};


static void *saved_tables_arrtype[9];

static void
add_scalarmath(void)
{
    #line 1608
    byte_as_number.nb_index = PyByteArrType_Type.tp_as_number->nb_index;
    PyByteArrType_Type.tp_as_number = &(byte_as_number);
    PyByteArrType_Type.tp_richcompare = byte_richcompare;
    
#line 1608
    ubyte_as_number.nb_index = PyUByteArrType_Type.tp_as_number->nb_index;
    PyUByteArrType_Type.tp_as_number = &(ubyte_as_number);
    PyUByteArrType_Type.tp_richcompare = ubyte_richcompare;
    
#line 1608
    short_as_number.nb_index = PyShortArrType_Type.tp_as_number->nb_index;
    PyShortArrType_Type.tp_as_number = &(short_as_number);
    PyShortArrType_Type.tp_richcompare = short_richcompare;
    
#line 1608
    ushort_as_number.nb_index = PyUShortArrType_Type.tp_as_number->nb_index;
    PyUShortArrType_Type.tp_as_number = &(ushort_as_number);
    PyUShortArrType_Type.tp_richcompare = ushort_richcompare;
    
#line 1608
    int_as_number.nb_index = PyIntArrType_Type.tp_as_number->nb_index;
    PyIntArrType_Type.tp_as_number = &(int_as_number);
    PyIntArrType_Type.tp_richcompare = int_richcompare;
    
#line 1608
    uint_as_number.nb_index = PyUIntArrType_Type.tp_as_number->nb_index;
    PyUIntArrType_Type.tp_as_number = &(uint_as_number);
    PyUIntArrType_Type.tp_richcompare = uint_richcompare;
    
#line 1608
    long_as_number.nb_index = PyLongArrType_Type.tp_as_number->nb_index;
    PyLongArrType_Type.tp_as_number = &(long_as_number);
    PyLongArrType_Type.tp_richcompare = long_richcompare;
    
#line 1608
    ulong_as_number.nb_index = PyULongArrType_Type.tp_as_number->nb_index;
    PyULongArrType_Type.tp_as_number = &(ulong_as_number);
    PyULongArrType_Type.tp_richcompare = ulong_richcompare;
    
#line 1608
    longlong_as_number.nb_index = PyLongLongArrType_Type.tp_as_number->nb_index;
    PyLongLongArrType_Type.tp_as_number = &(longlong_as_number);
    PyLongLongArrType_Type.tp_richcompare = longlong_richcompare;
    
#line 1608
    ulonglong_as_number.nb_index = PyULongLongArrType_Type.tp_as_number->nb_index;
    PyULongLongArrType_Type.tp_as_number = &(ulonglong_as_number);
    PyULongLongArrType_Type.tp_richcompare = ulonglong_richcompare;
    
#line 1608
    half_as_number.nb_index = PyHalfArrType_Type.tp_as_number->nb_index;
    PyHalfArrType_Type.tp_as_number = &(half_as_number);
    PyHalfArrType_Type.tp_richcompare = half_richcompare;
    
#line 1608
    float_as_number.nb_index = PyFloatArrType_Type.tp_as_number->nb_index;
    PyFloatArrType_Type.tp_as_number = &(float_as_number);
    PyFloatArrType_Type.tp_richcompare = float_richcompare;
    
#line 1608
    double_as_number.nb_index = PyDoubleArrType_Type.tp_as_number->nb_index;
    PyDoubleArrType_Type.tp_as_number = &(double_as_number);
    PyDoubleArrType_Type.tp_richcompare = double_richcompare;
    
#line 1608
    longdouble_as_number.nb_index = PyLongDoubleArrType_Type.tp_as_number->nb_index;
    PyLongDoubleArrType_Type.tp_as_number = &(longdouble_as_number);
    PyLongDoubleArrType_Type.tp_richcompare = longdouble_richcompare;
    
#line 1608
    cfloat_as_number.nb_index = PyCFloatArrType_Type.tp_as_number->nb_index;
    PyCFloatArrType_Type.tp_as_number = &(cfloat_as_number);
    PyCFloatArrType_Type.tp_richcompare = cfloat_richcompare;
    
#line 1608
    cdouble_as_number.nb_index = PyCDoubleArrType_Type.tp_as_number->nb_index;
    PyCDoubleArrType_Type.tp_as_number = &(cdouble_as_number);
    PyCDoubleArrType_Type.tp_richcompare = cdouble_richcompare;
    
#line 1608
    clongdouble_as_number.nb_index = PyCLongDoubleArrType_Type.tp_as_number->nb_index;
    PyCLongDoubleArrType_Type.tp_as_number = &(clongdouble_as_number);
    PyCLongDoubleArrType_Type.tp_richcompare = clongdouble_richcompare;
    

    saved_tables_arrtype[0] = PyLongArrType_Type.tp_as_number;
#if !defined(NPY_PY3K)
    saved_tables_arrtype[1] = PyLongArrType_Type.tp_compare;
#endif
    saved_tables_arrtype[2] = PyLongArrType_Type.tp_richcompare;
    saved_tables_arrtype[3] = PyDoubleArrType_Type.tp_as_number;
#if !defined(NPY_PY3K)
    saved_tables_arrtype[4] = PyDoubleArrType_Type.tp_compare;
#endif
    saved_tables_arrtype[5] = PyDoubleArrType_Type.tp_richcompare;
    saved_tables_arrtype[6] = PyCDoubleArrType_Type.tp_as_number;
#if !defined(NPY_PY3K)
    saved_tables_arrtype[7] = PyCDoubleArrType_Type.tp_compare;
#endif
    saved_tables_arrtype[8] = PyCDoubleArrType_Type.tp_richcompare;
}

static int
get_functions(void)
{
    PyObject *mm, *obj;
    void **funcdata;
    char *signatures;
    int i, j;
    int ret = -1;

    /* Get the nc_pow functions */
    /* Get the pow functions */
    mm = PyImport_ImportModule("numpy.core.umath");
    if (mm == NULL) {
        return -1;
    }

    obj = PyObject_GetAttrString(mm, "power");
    if (obj == NULL) {
        goto fail;
    }
    funcdata = ((PyUFuncObject *)obj)->data;
    signatures = ((PyUFuncObject *)obj)->types;

    i = 0;
    j = 0;
    while (signatures[i] != NPY_FLOAT) {
        i += 3;
        j++;
    }
    _basic_float_pow = funcdata[j];
    _basic_double_pow = funcdata[j + 1];
    _basic_longdouble_pow = funcdata[j + 2];
    _basic_cfloat_pow = funcdata[j + 3];
    _basic_cdouble_pow = funcdata[j + 4];
    _basic_clongdouble_pow = funcdata[j + 5];
    Py_DECREF(obj);

    /* Get the floor functions */
    obj = PyObject_GetAttrString(mm, "floor");
    if (obj == NULL) {
        goto fail;
    }
    funcdata = ((PyUFuncObject *)obj)->data;
    signatures = ((PyUFuncObject *)obj)->types;
    i = 0;
    j = 0;
    while(signatures[i] != NPY_FLOAT) {
        i += 2;
        j++;
    }
    _basic_half_floor = funcdata[j - 1];
    _basic_float_floor = funcdata[j];
    _basic_double_floor = funcdata[j + 1];
    _basic_longdouble_floor = funcdata[j + 2];
    Py_DECREF(obj);

    /* Get the sqrt functions */
    obj = PyObject_GetAttrString(mm, "sqrt");
    if (obj == NULL) {
        goto fail;
    }
    funcdata = ((PyUFuncObject *)obj)->data;
    signatures = ((PyUFuncObject *)obj)->types;
    /*
     * sqrt ufunc is specialized for double and float loops in
     * generate_umath.py, the first to go into FLOAT/DOUBLE_sqrt
     * they have the same signature as the scalar variants so we need to skip
     * over them
     */
    i = 4;
    j = 2;
    while (signatures[i] != NPY_FLOAT) {
        i += 2; j++;
    }
    _basic_half_sqrt = funcdata[j - 1];
    _basic_float_sqrt = funcdata[j];
    _basic_double_sqrt = funcdata[j + 1];
    _basic_longdouble_sqrt = funcdata[j + 2];
    Py_DECREF(obj);

    /* Get the fmod functions */
    obj = PyObject_GetAttrString(mm, "fmod");
    if (obj == NULL) {
        goto fail;
    }
    funcdata = ((PyUFuncObject *)obj)->data;
    signatures = ((PyUFuncObject *)obj)->types;
    i = 0;
    j = 0;
    while (signatures[i] != NPY_FLOAT) {
        i += 3;
        j++;
    }
    _basic_half_fmod = funcdata[j - 1];
    _basic_float_fmod = funcdata[j];
    _basic_double_fmod = funcdata[j + 1];
    _basic_longdouble_fmod = funcdata[j + 2];
    Py_DECREF(obj);
    return ret = 0;

 fail:
    Py_DECREF(mm);
    return ret;
}

static void *saved_tables[9];

char doc_alterpyscalars[] = "";

static PyObject *
alter_pyscalars(PyObject *NPY_UNUSED(dummy), PyObject *args)
{
    int n;
    PyObject *obj;
    n = PyTuple_GET_SIZE(args);
    while (n--) {
        obj = PyTuple_GET_ITEM(args, n);
#if !defined(NPY_PY3K)
        if (obj == (PyObject *)(&PyInt_Type)) {
            PyInt_Type.tp_as_number = PyLongArrType_Type.tp_as_number;
            PyInt_Type.tp_compare = PyLongArrType_Type.tp_compare;
            PyInt_Type.tp_richcompare = PyLongArrType_Type.tp_richcompare;
        }
        else
#endif
        if (obj == (PyObject *)(&PyFloat_Type)) {
            PyFloat_Type.tp_as_number = PyDoubleArrType_Type.tp_as_number;
#if !defined(NPY_PY3K)
            PyFloat_Type.tp_compare = PyDoubleArrType_Type.tp_compare;
#endif
            PyFloat_Type.tp_richcompare = PyDoubleArrType_Type.tp_richcompare;
        }
        else if (obj == (PyObject *)(&PyComplex_Type)) {
            PyComplex_Type.tp_as_number = PyCDoubleArrType_Type.tp_as_number;
#if !defined(NPY_PY3K)
            PyComplex_Type.tp_compare = PyCDoubleArrType_Type.tp_compare;
#endif
            PyComplex_Type.tp_richcompare =             \
                PyCDoubleArrType_Type.tp_richcompare;
        }
        else {
            PyErr_SetString(PyExc_ValueError,
                    "arguments must be int, float, or complex");
            return NULL;
        }
    }
    Py_INCREF(Py_None);
    return Py_None;
}

char doc_restorepyscalars[] = "";
static PyObject *
restore_pyscalars(PyObject *NPY_UNUSED(dummy), PyObject *args)
{
    int n;
    PyObject *obj;

    n = PyTuple_GET_SIZE(args);
    while (n--) {
        obj = PyTuple_GET_ITEM(args, n);
#if !defined(NPY_PY3K)
        if (obj == (PyObject *)(&PyInt_Type)) {
            PyInt_Type.tp_as_number = saved_tables[0];
            PyInt_Type.tp_compare = saved_tables[1];
            PyInt_Type.tp_richcompare = saved_tables[2];
        }
        else
#endif
        if (obj == (PyObject *)(&PyFloat_Type)) {
            PyFloat_Type.tp_as_number = saved_tables[3];
#if !defined(NPY_PY3K)
            PyFloat_Type.tp_compare = saved_tables[4];
#endif
            PyFloat_Type.tp_richcompare = saved_tables[5];
        }
        else if (obj == (PyObject *)(&PyComplex_Type)) {
            PyComplex_Type.tp_as_number = saved_tables[6];
#if !defined(NPY_PY3K)
            PyComplex_Type.tp_compare = saved_tables[7];
#endif
            PyComplex_Type.tp_richcompare = saved_tables[8];
        }
        else {
            PyErr_SetString(PyExc_ValueError,
                    "arguments must be int, float, or complex");
            return NULL;
        }
    }
    Py_INCREF(Py_None);
    return Py_None;
}

char doc_usepythonmath[] = "";
static PyObject *
use_pythonmath(PyObject *NPY_UNUSED(dummy), PyObject *args)
{
    int n;
    PyObject *obj;

    n = PyTuple_GET_SIZE(args);
    while (n--) {
        obj = PyTuple_GET_ITEM(args, n);
#if !defined(NPY_PY3K)
        if (obj == (PyObject *)(&PyInt_Type)) {
            PyLongArrType_Type.tp_as_number = saved_tables[0];
            PyLongArrType_Type.tp_compare = saved_tables[1];
            PyLongArrType_Type.tp_richcompare = saved_tables[2];
        }
        else
#endif
        if (obj == (PyObject *)(&PyFloat_Type)) {
            PyDoubleArrType_Type.tp_as_number = saved_tables[3];
#if !defined(NPY_PY3K)
            PyDoubleArrType_Type.tp_compare = saved_tables[4];
#endif
            PyDoubleArrType_Type.tp_richcompare = saved_tables[5];
        }
        else if (obj == (PyObject *)(&PyComplex_Type)) {
            PyCDoubleArrType_Type.tp_as_number = saved_tables[6];
#if !defined(NPY_PY3K)
            PyCDoubleArrType_Type.tp_compare = saved_tables[7];
#endif
            PyCDoubleArrType_Type.tp_richcompare = saved_tables[8];
        }
        else {
            PyErr_SetString(PyExc_ValueError,
                    "arguments must be int, float, or complex");
            return NULL;
        }
    }
    Py_INCREF(Py_None);
    return Py_None;
}

char doc_usescalarmath[] = "";
static PyObject *
use_scalarmath(PyObject *NPY_UNUSED(dummy), PyObject *args)
{
    int n;
    PyObject *obj;

    n = PyTuple_GET_SIZE(args);
    while (n--) {
        obj = PyTuple_GET_ITEM(args, n);
#if !defined(NPY_PY3K)
        if (obj == (PyObject *)(&PyInt_Type)) {
            PyLongArrType_Type.tp_as_number = saved_tables_arrtype[0];
            PyLongArrType_Type.tp_compare = saved_tables_arrtype[1];
            PyLongArrType_Type.tp_richcompare = saved_tables_arrtype[2];
        }
        else
#endif
        if (obj == (PyObject *)(&PyFloat_Type)) {
            PyDoubleArrType_Type.tp_as_number = saved_tables_arrtype[3];
#if !defined(NPY_PY3K)
            PyDoubleArrType_Type.tp_compare = saved_tables_arrtype[4];
#endif
            PyDoubleArrType_Type.tp_richcompare = saved_tables_arrtype[5];
        }
        else if (obj == (PyObject *)(&PyComplex_Type)) {
            PyCDoubleArrType_Type.tp_as_number = saved_tables_arrtype[6];
#if !defined(NPY_PY3K)
            PyCDoubleArrType_Type.tp_compare = saved_tables_arrtype[7];
#endif
            PyCDoubleArrType_Type.tp_richcompare = saved_tables_arrtype[8];
        }
        else {
            PyErr_SetString(PyExc_ValueError,
                    "arguments must be int, float, or complex");
            return NULL;
        }
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static struct PyMethodDef methods[] = {
    {"alter_pythonmath",
        (PyCFunction) alter_pyscalars,
         METH_VARARGS, doc_alterpyscalars},
    {"restore_pythonmath",
        (PyCFunction) restore_pyscalars,
         METH_VARARGS, doc_restorepyscalars},
    {"use_pythonmath",
        (PyCFunction) use_pythonmath,
        METH_VARARGS, doc_usepythonmath},
    {"use_scalarmath",
        (PyCFunction) use_scalarmath,
        METH_VARARGS, doc_usescalarmath},
    {NULL, NULL, 0, NULL}
};

#if defined(NPY_PY3K)
static struct PyModuleDef moduledef = {
        PyModuleDef_HEAD_INIT,
        "scalarmath",
        NULL,
        -1,
        methods,
        NULL,
        NULL,
        NULL,
        NULL
};
#endif

#if defined(NPY_PY3K)
#define RETVAL m
PyMODINIT_FUNC PyInit_scalarmath(void)
#else
#define RETVAL
PyMODINIT_FUNC
initscalarmath(void)
#endif
{
#if defined(NPY_PY3K)
    PyObject *m = PyModule_Create(&moduledef);
    if (!m) {
        return NULL;
    }
#else
    Py_InitModule("scalarmath", methods);
#endif

    import_array();
    import_umath();

    if (get_functions() < 0) {
        return RETVAL;
    }

    add_scalarmath();

#if !defined(NPY_PY3K)
    saved_tables[0] = PyInt_Type.tp_as_number;
    saved_tables[1] = PyInt_Type.tp_compare;
    saved_tables[2] = PyInt_Type.tp_richcompare;
#endif
    saved_tables[3] = PyFloat_Type.tp_as_number;
#if !defined(NPY_PY3K)
    saved_tables[4] = PyFloat_Type.tp_compare;
#endif
    saved_tables[5] = PyFloat_Type.tp_richcompare;
    saved_tables[6] = PyComplex_Type.tp_as_number;
#if !defined(NPY_PY3K)
    saved_tables[7] = PyComplex_Type.tp_compare;
#endif
    saved_tables[8] = PyComplex_Type.tp_richcompare;

    return RETVAL;
}

