#line 1 "numpy/core/src/private/scalarmathmodule.h.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/*
 * some overflow checking integer arithmetic
 */
#include <numpy/npy_common.h>

#ifndef __NPY_SCALARMATHMODULE_H__
#define __NPY_SCALARMATHMODULE_H__

#line 17

/*
 * writes result of a * b into r
 * returns 1 if a * b overflowed else returns 0
 */
static NPY_INLINE int
npy_mul_with_overflow_int(npy_int * r, npy_int a, npy_int b)
{
    const npy_int half_sz = (((npy_int)1 << (sizeof(a) * 8 / 2)) - 1);

    *r = a * b;
    /*
     * avoid expensive division on common no overflow case
     * could be improved via compiler intrinsics e.g. via clang
     * __builtin_mul_with_overflow, gcc __int128 or cpu overflow flags
     */
    if (NPY_UNLIKELY((a | b) >= half_sz) &&
        a != 0 && b > NPY_MAX_INT / a) {
        return 1;
    }

    return 0;
}

#line 17

/*
 * writes result of a * b into r
 * returns 1 if a * b overflowed else returns 0
 */
static NPY_INLINE int
npy_mul_with_overflow_uint(npy_uint * r, npy_uint a, npy_uint b)
{
    const npy_uint half_sz = (((npy_uint)1 << (sizeof(a) * 8 / 2)) - 1);

    *r = a * b;
    /*
     * avoid expensive division on common no overflow case
     * could be improved via compiler intrinsics e.g. via clang
     * __builtin_mul_with_overflow, gcc __int128 or cpu overflow flags
     */
    if (NPY_UNLIKELY((a | b) >= half_sz) &&
        a != 0 && b > NPY_MAX_UINT / a) {
        return 1;
    }

    return 0;
}

#line 17

/*
 * writes result of a * b into r
 * returns 1 if a * b overflowed else returns 0
 */
static NPY_INLINE int
npy_mul_with_overflow_long(npy_long * r, npy_long a, npy_long b)
{
    const npy_long half_sz = (((npy_long)1 << (sizeof(a) * 8 / 2)) - 1);

    *r = a * b;
    /*
     * avoid expensive division on common no overflow case
     * could be improved via compiler intrinsics e.g. via clang
     * __builtin_mul_with_overflow, gcc __int128 or cpu overflow flags
     */
    if (NPY_UNLIKELY((a | b) >= half_sz) &&
        a != 0 && b > NPY_MAX_LONG / a) {
        return 1;
    }

    return 0;
}

#line 17

/*
 * writes result of a * b into r
 * returns 1 if a * b overflowed else returns 0
 */
static NPY_INLINE int
npy_mul_with_overflow_ulong(npy_ulong * r, npy_ulong a, npy_ulong b)
{
    const npy_ulong half_sz = (((npy_ulong)1 << (sizeof(a) * 8 / 2)) - 1);

    *r = a * b;
    /*
     * avoid expensive division on common no overflow case
     * could be improved via compiler intrinsics e.g. via clang
     * __builtin_mul_with_overflow, gcc __int128 or cpu overflow flags
     */
    if (NPY_UNLIKELY((a | b) >= half_sz) &&
        a != 0 && b > NPY_MAX_ULONG / a) {
        return 1;
    }

    return 0;
}

#line 17

/*
 * writes result of a * b into r
 * returns 1 if a * b overflowed else returns 0
 */
static NPY_INLINE int
npy_mul_with_overflow_longlong(npy_longlong * r, npy_longlong a, npy_longlong b)
{
    const npy_longlong half_sz = (((npy_longlong)1 << (sizeof(a) * 8 / 2)) - 1);

    *r = a * b;
    /*
     * avoid expensive division on common no overflow case
     * could be improved via compiler intrinsics e.g. via clang
     * __builtin_mul_with_overflow, gcc __int128 or cpu overflow flags
     */
    if (NPY_UNLIKELY((a | b) >= half_sz) &&
        a != 0 && b > NPY_MAX_LONGLONG / a) {
        return 1;
    }

    return 0;
}

#line 17

/*
 * writes result of a * b into r
 * returns 1 if a * b overflowed else returns 0
 */
static NPY_INLINE int
npy_mul_with_overflow_ulonglong(npy_ulonglong * r, npy_ulonglong a, npy_ulonglong b)
{
    const npy_ulonglong half_sz = (((npy_ulonglong)1 << (sizeof(a) * 8 / 2)) - 1);

    *r = a * b;
    /*
     * avoid expensive division on common no overflow case
     * could be improved via compiler intrinsics e.g. via clang
     * __builtin_mul_with_overflow, gcc __int128 or cpu overflow flags
     */
    if (NPY_UNLIKELY((a | b) >= half_sz) &&
        a != 0 && b > NPY_MAX_ULONGLONG / a) {
        return 1;
    }

    return 0;
}

#line 17

/*
 * writes result of a * b into r
 * returns 1 if a * b overflowed else returns 0
 */
static NPY_INLINE int
npy_mul_with_overflow_intp(npy_intp * r, npy_intp a, npy_intp b)
{
    const npy_intp half_sz = (((npy_intp)1 << (sizeof(a) * 8 / 2)) - 1);

    *r = a * b;
    /*
     * avoid expensive division on common no overflow case
     * could be improved via compiler intrinsics e.g. via clang
     * __builtin_mul_with_overflow, gcc __int128 or cpu overflow flags
     */
    if (NPY_UNLIKELY((a | b) >= half_sz) &&
        a != 0 && b > NPY_MAX_INTP / a) {
        return 1;
    }

    return 0;
}


#endif

