#line 1 "numpy/core/src/npysort/heapsort.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */

/*
 * The purpose of this module is to add faster sort functions
 * that are type-specific.  This is done by altering the
 * function table for the builtin descriptors.
 *
 * These sorting functions are copied almost directly from numarray
 * with a few modifications (complex comparisons compare the imaginary
 * part if the real parts are equal, for example), and the names
 * are changed.
 *
 * The original sorting code is due to Charles R. Harris who wrote
 * it for numarray.
 */

/*
 * Quick sort is usually the fastest, but the worst case scenario can
 * be slower than the merge and heap sorts.  The merge sort requires
 * extra memory and so for large arrays may not be useful.
 *
 * The merge sort is *stable*, meaning that equal components
 * are unmoved from their entry versions, so it can be used to
 * implement lexigraphic sorting on multiple keys.
 *
 * The heap sort is included for completeness.
 */

#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include <stdlib.h>
#include "npy_sort.h"
#include "npysort_common.h"

#define NOT_USED NPY_UNUSED(unused)
#define PYA_QS_STACK 100
#define SMALL_QUICKSORT 15
#define SMALL_MERGESORT 20
#define SMALL_STRING 16


/*
 *****************************************************************************
 **                            NUMERIC SORTS                                **
 *****************************************************************************
 */


#line 62

int
heapsort_bool(npy_bool *start, npy_intp n, void *NOT_USED)
{
    npy_bool tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && BOOL_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (BOOL_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && BOOL_LT(a[j], a[j+1])) {
                j++;
            }
            if (BOOL_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_bool(npy_bool *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && BOOL_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (BOOL_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && BOOL_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (BOOL_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_byte(npy_byte *start, npy_intp n, void *NOT_USED)
{
    npy_byte tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && BYTE_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (BYTE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && BYTE_LT(a[j], a[j+1])) {
                j++;
            }
            if (BYTE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_byte(npy_byte *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && BYTE_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (BYTE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && BYTE_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (BYTE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_ubyte(npy_ubyte *start, npy_intp n, void *NOT_USED)
{
    npy_ubyte tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && UBYTE_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (UBYTE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && UBYTE_LT(a[j], a[j+1])) {
                j++;
            }
            if (UBYTE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_ubyte(npy_ubyte *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && UBYTE_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (UBYTE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && UBYTE_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (UBYTE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_short(npy_short *start, npy_intp n, void *NOT_USED)
{
    npy_short tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && SHORT_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (SHORT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && SHORT_LT(a[j], a[j+1])) {
                j++;
            }
            if (SHORT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_short(npy_short *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && SHORT_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (SHORT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && SHORT_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (SHORT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_ushort(npy_ushort *start, npy_intp n, void *NOT_USED)
{
    npy_ushort tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && USHORT_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (USHORT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && USHORT_LT(a[j], a[j+1])) {
                j++;
            }
            if (USHORT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_ushort(npy_ushort *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && USHORT_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (USHORT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && USHORT_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (USHORT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_int(npy_int *start, npy_intp n, void *NOT_USED)
{
    npy_int tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && INT_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (INT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && INT_LT(a[j], a[j+1])) {
                j++;
            }
            if (INT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_int(npy_int *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && INT_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (INT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && INT_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (INT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_uint(npy_uint *start, npy_intp n, void *NOT_USED)
{
    npy_uint tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && UINT_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (UINT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && UINT_LT(a[j], a[j+1])) {
                j++;
            }
            if (UINT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_uint(npy_uint *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && UINT_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (UINT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && UINT_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (UINT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_long(npy_long *start, npy_intp n, void *NOT_USED)
{
    npy_long tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && LONG_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (LONG_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && LONG_LT(a[j], a[j+1])) {
                j++;
            }
            if (LONG_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_long(npy_long *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && LONG_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (LONG_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && LONG_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (LONG_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_ulong(npy_ulong *start, npy_intp n, void *NOT_USED)
{
    npy_ulong tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && ULONG_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (ULONG_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && ULONG_LT(a[j], a[j+1])) {
                j++;
            }
            if (ULONG_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_ulong(npy_ulong *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && ULONG_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (ULONG_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && ULONG_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (ULONG_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_longlong(npy_longlong *start, npy_intp n, void *NOT_USED)
{
    npy_longlong tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && LONGLONG_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (LONGLONG_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && LONGLONG_LT(a[j], a[j+1])) {
                j++;
            }
            if (LONGLONG_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_longlong(npy_longlong *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && LONGLONG_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (LONGLONG_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && LONGLONG_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (LONGLONG_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_ulonglong(npy_ulonglong *start, npy_intp n, void *NOT_USED)
{
    npy_ulonglong tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && ULONGLONG_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (ULONGLONG_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && ULONGLONG_LT(a[j], a[j+1])) {
                j++;
            }
            if (ULONGLONG_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_ulonglong(npy_ulonglong *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && ULONGLONG_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (ULONGLONG_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && ULONGLONG_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (ULONGLONG_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_half(npy_ushort *start, npy_intp n, void *NOT_USED)
{
    npy_ushort tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && HALF_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (HALF_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && HALF_LT(a[j], a[j+1])) {
                j++;
            }
            if (HALF_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_half(npy_ushort *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && HALF_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (HALF_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && HALF_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (HALF_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_float(npy_float *start, npy_intp n, void *NOT_USED)
{
    npy_float tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && FLOAT_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (FLOAT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && FLOAT_LT(a[j], a[j+1])) {
                j++;
            }
            if (FLOAT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_float(npy_float *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && FLOAT_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (FLOAT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && FLOAT_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (FLOAT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_double(npy_double *start, npy_intp n, void *NOT_USED)
{
    npy_double tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && DOUBLE_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (DOUBLE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && DOUBLE_LT(a[j], a[j+1])) {
                j++;
            }
            if (DOUBLE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_double(npy_double *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && DOUBLE_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (DOUBLE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && DOUBLE_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (DOUBLE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_longdouble(npy_longdouble *start, npy_intp n, void *NOT_USED)
{
    npy_longdouble tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && LONGDOUBLE_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (LONGDOUBLE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && LONGDOUBLE_LT(a[j], a[j+1])) {
                j++;
            }
            if (LONGDOUBLE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_longdouble(npy_longdouble *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && LONGDOUBLE_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (LONGDOUBLE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && LONGDOUBLE_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (LONGDOUBLE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_cfloat(npy_cfloat *start, npy_intp n, void *NOT_USED)
{
    npy_cfloat tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && CFLOAT_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (CFLOAT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && CFLOAT_LT(a[j], a[j+1])) {
                j++;
            }
            if (CFLOAT_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_cfloat(npy_cfloat *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && CFLOAT_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (CFLOAT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && CFLOAT_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (CFLOAT_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_cdouble(npy_cdouble *start, npy_intp n, void *NOT_USED)
{
    npy_cdouble tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && CDOUBLE_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (CDOUBLE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && CDOUBLE_LT(a[j], a[j+1])) {
                j++;
            }
            if (CDOUBLE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_cdouble(npy_cdouble *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && CDOUBLE_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (CDOUBLE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && CDOUBLE_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (CDOUBLE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 62

int
heapsort_clongdouble(npy_clongdouble *start, npy_intp n, void *NOT_USED)
{
    npy_clongdouble tmp, *a;
    npy_intp i,j,l;

    /* The array needs to be offset by one for heapsort indexing */
    a = start - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && CLONGDOUBLE_LT(a[j], a[j+1])) {
                j += 1;
            }
            if (CLONGDOUBLE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && CLONGDOUBLE_LT(a[j], a[j+1])) {
                j++;
            }
            if (CLONGDOUBLE_LT(tmp, a[j])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


int
aheapsort_clongdouble(npy_clongdouble *v, npy_intp *tosort, npy_intp n, void *NOT_USED)
{
    npy_intp *a, i,j,l, tmp;
    /* The arrays need to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && CLONGDOUBLE_LT(v[a[j]], v[a[j+1]])) {
                j += 1;
            }
            if (CLONGDOUBLE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && CLONGDOUBLE_LT(v[a[j]], v[a[j+1]])) {
                j++;
            }
            if (CLONGDOUBLE_LT(v[tmp], v[a[j]])) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}




/*
 *****************************************************************************
 **                             STRING SORTS                                **
 *****************************************************************************
 */


#line 178

int
heapsort_string(npy_char *start, npy_intp n, PyArrayObject *arr)
{
    size_t len = PyArray_ITEMSIZE(arr)/sizeof(npy_char);
    npy_char *tmp = malloc(PyArray_ITEMSIZE(arr));
    npy_char *a = start - len;
    npy_intp i, j, l;

    for (l = n>>1; l > 0; --l) {
        STRING_COPY(tmp, a + l*len, len);
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && STRING_LT(a + j*len, a + (j+1)*len, len))
                j += 1;
            if (STRING_LT(tmp, a + j*len, len)) {
                STRING_COPY(a + i*len, a + j*len, len);
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        STRING_COPY(a + i*len, tmp, len);
    }

    for (; n > 1;) {
        STRING_COPY(tmp, a + n*len, len);
        STRING_COPY(a + n*len, a + len, len);
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && STRING_LT(a + j*len, a + (j+1)*len, len))
                j++;
            if (STRING_LT(tmp, a + j*len, len)) {
                STRING_COPY(a + i*len, a + j*len, len);
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        STRING_COPY(a + i*len, tmp, len);
    }

    free(tmp);
    return 0;
}


int
aheapsort_string(npy_char *v, npy_intp *tosort, npy_intp n, PyArrayObject *arr)
{
    size_t len = PyArray_ITEMSIZE(arr)/sizeof(npy_char);
    npy_intp *a, i,j,l, tmp;

    /* The array needs to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && STRING_LT(v + a[j]*len, v + a[j+1]*len, len))
                j += 1;
            if (STRING_LT(v + tmp*len, v + a[j]*len, len)) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && STRING_LT(v + a[j]*len, v + a[j+1]*len, len))
                j++;
            if (STRING_LT(v + tmp*len, v + a[j]*len, len)) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}


#line 178

int
heapsort_unicode(npy_ucs4 *start, npy_intp n, PyArrayObject *arr)
{
    size_t len = PyArray_ITEMSIZE(arr)/sizeof(npy_ucs4);
    npy_ucs4 *tmp = malloc(PyArray_ITEMSIZE(arr));
    npy_ucs4 *a = start - len;
    npy_intp i, j, l;

    for (l = n>>1; l > 0; --l) {
        UNICODE_COPY(tmp, a + l*len, len);
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && UNICODE_LT(a + j*len, a + (j+1)*len, len))
                j += 1;
            if (UNICODE_LT(tmp, a + j*len, len)) {
                UNICODE_COPY(a + i*len, a + j*len, len);
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        UNICODE_COPY(a + i*len, tmp, len);
    }

    for (; n > 1;) {
        UNICODE_COPY(tmp, a + n*len, len);
        UNICODE_COPY(a + n*len, a + len, len);
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && UNICODE_LT(a + j*len, a + (j+1)*len, len))
                j++;
            if (UNICODE_LT(tmp, a + j*len, len)) {
                UNICODE_COPY(a + i*len, a + j*len, len);
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        UNICODE_COPY(a + i*len, tmp, len);
    }

    free(tmp);
    return 0;
}


int
aheapsort_unicode(npy_ucs4 *v, npy_intp *tosort, npy_intp n, PyArrayObject *arr)
{
    size_t len = PyArray_ITEMSIZE(arr)/sizeof(npy_ucs4);
    npy_intp *a, i,j,l, tmp;

    /* The array needs to be offset by one for heapsort indexing */
    a = tosort - 1;

    for (l = n>>1; l > 0; --l) {
        tmp = a[l];
        for (i = l, j = l<<1; j <= n;) {
            if (j < n && UNICODE_LT(v + a[j]*len, v + a[j+1]*len, len))
                j += 1;
            if (UNICODE_LT(v + tmp*len, v + a[j]*len, len)) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    for (; n > 1;) {
        tmp = a[n];
        a[n] = a[1];
        n -= 1;
        for (i = 1, j = 2; j <= n;) {
            if (j < n && UNICODE_LT(v + a[j]*len, v + a[j+1]*len, len))
                j++;
            if (UNICODE_LT(v + tmp*len, v + a[j]*len, len)) {
                a[i] = a[j];
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        a[i] = tmp;
    }

    return 0;
}




/*
 *****************************************************************************
 **                             GENERIC SORT                                **
 *****************************************************************************
 */


/*
 * This sort has almost the same signature as libc qsort and is intended to
 * provide a heapsort for array types that don't have type specific sorts.
 * The difference in the signature is an error return, as it might be the
 * case that a memory allocation fails.
 */
int
npy_heapsort(void *base, size_t num, size_t size, npy_comparator cmp)
{
    char *tmp = (char *) malloc(size);
    char *a = (char *) base - size;
    size_t i, j, l;

    if (tmp == NULL) {
        return -NPY_ENOMEM;
    }

    for (l = num >> 1; l > 0; --l) {
        GENERIC_COPY(tmp, a + l*size, size);
        for (i = l, j = l << 1; j <= num;) {
            if (j < num && GENERIC_LT(a + j*size, a + (j+1)*size, cmp))
                j += 1;
            if (GENERIC_LT(tmp, a + j*size, cmp)) {
                GENERIC_COPY(a + i*size, a + j*size, size);
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        GENERIC_COPY(a + i*size, tmp, size);
    }

    for (; num > 1;) {
        GENERIC_COPY(tmp, a + num*size, size);
        GENERIC_COPY(a + num*size, a + size, size);
        num -= 1;
        for (i = 1, j = 2; j <= num;) {
            if (j < num && GENERIC_LT(a + j*size, a + (j+1)*size, cmp))
                j++;
            if (GENERIC_LT(tmp, a + j*size, cmp)) {
                GENERIC_COPY(a + i*size, a + j*size, size);
                i = j;
                j += j;
            }
            else {
                break;
            }
        }
        GENERIC_COPY(a + i*size, tmp, size);
    }

    free(tmp);
    return 0;
}

