#line 1 "numpy/core/src/multiarray/scalartypes.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */
#define PY_SSIZE_T_CLEAN
#include "Python.h"
#include "structmember.h"

#define NPY_NO_DEPRECATED_API NPY_API_VERSION
#ifndef _MULTIARRAYMODULE
#define _MULTIARRAYMODULE
#endif

#include "numpy/arrayobject.h"
#include "numpy/npy_math.h"
#include "numpy/halffloat.h"
#include "numpy/arrayscalars.h"

#include "npy_pycompat.h"

#include "npy_config.h"
#include "mapping.h"
#include "ctors.h"
#include "usertypes.h"
#include "numpyos.h"
#include "common.h"
#include "scalartypes.h"
#include "_datetime.h"
#include "datetime_strings.h"

NPY_NO_EXPORT PyBoolScalarObject _PyArrayScalar_BoolValues[] = {
    {PyObject_HEAD_INIT(&PyBoolArrType_Type) 0},
    {PyObject_HEAD_INIT(&PyBoolArrType_Type) 1},
};

/* TimeInteger is deleted, but still here to fill the API slot */
NPY_NO_EXPORT PyTypeObject PyTimeIntegerArrType_Type;

/*
 * Inheritance is established later when tp_bases is set (or tp_base for
 * single inheritance)
 */

#line 47
NPY_NO_EXPORT PyTypeObject PyNumberArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.number",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 47
NPY_NO_EXPORT PyTypeObject PyIntegerArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.integer",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 47
NPY_NO_EXPORT PyTypeObject PySignedIntegerArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.signedinteger",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 47
NPY_NO_EXPORT PyTypeObject PyUnsignedIntegerArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.unsignedinteger",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 47
NPY_NO_EXPORT PyTypeObject PyInexactArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.inexact",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 47
NPY_NO_EXPORT PyTypeObject PyFloatingArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.floating",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 47
NPY_NO_EXPORT PyTypeObject PyComplexFloatingArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.complexfloating",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 47
NPY_NO_EXPORT PyTypeObject PyFlexibleArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.flexible",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 47
NPY_NO_EXPORT PyTypeObject PyCharacterArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.character",                             /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};


static PyObject *
gentype_alloc(PyTypeObject *type, Py_ssize_t nitems)
{
    PyObject *obj;
    const size_t size = _PyObject_VAR_SIZE(type, nitems + 1);

    obj = (PyObject *)PyArray_malloc(size);
    memset(obj, 0, size);
    if (type->tp_itemsize == 0) {
        PyObject_INIT(obj, type);
    }
    else {
        (void) PyObject_INIT_VAR((PyVarObject *)obj, type, nitems);
    }
    return obj;
}

static void
gentype_dealloc(PyObject *v)
{
    Py_TYPE(v)->tp_free(v);
}


static PyObject *
gentype_power(PyObject *m1, PyObject *m2, PyObject *NPY_UNUSED(m3))
{
    PyObject *arr, *ret, *arg2;
    char *msg="unsupported operand type(s) for ** or pow()";

    if (!PyArray_IsScalar(m1, Generic)) {
        if (PyArray_Check(m1)) {
            ret = Py_TYPE(m1)->tp_as_number->nb_power(m1,m2, Py_None);
        }
        else {
            if (!PyArray_IsScalar(m2, Generic)) {
                PyErr_SetString(PyExc_TypeError, msg);
                return NULL;
            }
            arr = PyArray_FromScalar(m2, NULL);
            if (arr == NULL) {
                return NULL;
            }
            ret = Py_TYPE(arr)->tp_as_number->nb_power(m1, arr, Py_None);
            Py_DECREF(arr);
        }
        return ret;
    }
    if (!PyArray_IsScalar(m2, Generic)) {
        if (PyArray_Check(m2)) {
            ret = Py_TYPE(m2)->tp_as_number->nb_power(m1,m2, Py_None);
        }
        else {
            if (!PyArray_IsScalar(m1, Generic)) {
                PyErr_SetString(PyExc_TypeError, msg);
                return NULL;
            }
            arr = PyArray_FromScalar(m1, NULL);
            if (arr == NULL) {
                return NULL;
            }
            ret = Py_TYPE(arr)->tp_as_number->nb_power(arr, m2, Py_None);
            Py_DECREF(arr);
        }
        return ret;
    }
    arr = arg2 = NULL;
    arr = PyArray_FromScalar(m1, NULL);
    arg2 = PyArray_FromScalar(m2, NULL);
    if (arr == NULL || arg2 == NULL) {
        Py_XDECREF(arr);
        Py_XDECREF(arg2);
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_power(arr, arg2, Py_None);
    Py_DECREF(arr);
    Py_DECREF(arg2);
    return ret;
}

static PyObject *
gentype_generic_method(PyObject *self, PyObject *args, PyObject *kwds,
        char *str)
{
    PyObject *arr, *meth, *ret;

    arr = PyArray_FromScalar(self, NULL);
    if (arr == NULL) {
        return NULL;
    }
    meth = PyObject_GetAttrString(arr, str);
    if (meth == NULL) {
        Py_DECREF(arr);
        return NULL;
    }
    if (kwds == NULL) {
        ret = PyObject_CallObject(meth, args);
    }
    else {
        ret = PyObject_Call(meth, args, kwds);
    }
    Py_DECREF(meth);
    Py_DECREF(arr);
    if (ret && PyArray_Check(ret)) {
        return PyArray_Return((PyArrayObject *)ret);
    }
    else {
        return ret;
    }
}

#line 224
static PyObject *
gentype_add(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_add(m1, m2);
}


#line 224
static PyObject *
gentype_subtract(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_subtract(m1, m2);
}


#line 224
static PyObject *
gentype_remainder(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_remainder(m1, m2);
}


#line 224
static PyObject *
gentype_divmod(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_divmod(m1, m2);
}


#line 224
static PyObject *
gentype_lshift(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_lshift(m1, m2);
}


#line 224
static PyObject *
gentype_rshift(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_rshift(m1, m2);
}


#line 224
static PyObject *
gentype_and(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_and(m1, m2);
}


#line 224
static PyObject *
gentype_xor(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_xor(m1, m2);
}


#line 224
static PyObject *
gentype_or(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_or(m1, m2);
}


#line 224
static PyObject *
gentype_floor_divide(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_floor_divide(m1, m2);
}


#line 224
static PyObject *
gentype_true_divide(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_true_divide(m1, m2);
}



#if !defined(NPY_PY3K)
#line 237
static PyObject *
gentype_divide(PyObject *m1, PyObject *m2)
{
    return PyArray_Type.tp_as_number->nb_divide(m1, m2);
}

#endif

static PyObject *
gentype_multiply(PyObject *m1, PyObject *m2)
{
    PyObject *ret = NULL;
    long repeat;

    if (!PyArray_IsScalar(m1, Generic) &&
            ((Py_TYPE(m1)->tp_as_number == NULL) ||
             (Py_TYPE(m1)->tp_as_number->nb_multiply == NULL))) {
        /* Try to convert m2 to an int and try sequence repeat */
        repeat = PyInt_AsLong(m2);
        if (repeat == -1 && PyErr_Occurred()) {
            return NULL;
        }
        ret = PySequence_Repeat(m1, (int) repeat);
    }
    else if (!PyArray_IsScalar(m2, Generic) &&
            ((Py_TYPE(m2)->tp_as_number == NULL) ||
             (Py_TYPE(m2)->tp_as_number->nb_multiply == NULL))) {
        /* Try to convert m1 to an int and try sequence repeat */
        repeat = PyInt_AsLong(m1);
        if (repeat == -1 && PyErr_Occurred()) {
            return NULL;
        }
        ret = PySequence_Repeat(m2, (int) repeat);
    }
    if (ret == NULL) {
        PyErr_Clear(); /* no effect if not set */
        ret = PyArray_Type.tp_as_number->nb_multiply(m1, m2);
    }
    return ret;
}

#line 282
static PyObject *
gentype_positive(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_positive(arr);
    Py_DECREF(arr);
    return ret;
}

#line 282
static PyObject *
gentype_negative(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_negative(arr);
    Py_DECREF(arr);
    return ret;
}

#line 282
static PyObject *
gentype_absolute(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_absolute(arr);
    Py_DECREF(arr);
    return ret;
}

#line 282
static PyObject *
gentype_invert(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_invert(arr);
    Py_DECREF(arr);
    return ret;
}

#line 282
static PyObject *
gentype_int(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_int(arr);
    Py_DECREF(arr);
    return ret;
}

#line 282
static PyObject *
gentype_float(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_float(arr);
    Py_DECREF(arr);
    return ret;
}


#if !defined(NPY_PY3K)
#line 302
static PyObject *
gentype_long(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_long(arr);
    Py_DECREF(arr);
    return ret;
}

#line 302
static PyObject *
gentype_oct(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_oct(arr);
    Py_DECREF(arr);
    return ret;
}

#line 302
static PyObject *
gentype_hex(PyObject *m1)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_as_number->nb_hex(arr);
    Py_DECREF(arr);
    return ret;
}

#endif

static int
gentype_nonzero_number(PyObject *m1)
{
    PyObject *arr;
    int ret;

    arr = PyArray_FromScalar(m1, NULL);
    if (arr == NULL) {
        return -1;
    }
#if defined(NPY_PY3K)
    ret = Py_TYPE(arr)->tp_as_number->nb_bool(arr);
#else
    ret = Py_TYPE(arr)->tp_as_number->nb_nonzero(arr);
#endif
    Py_DECREF(arr);
    return ret;
}

static PyObject *
gentype_str(PyObject *self)
{
    PyObject *arr, *ret = NULL;

    arr = PyArray_FromScalar(self, NULL);
    if (arr != NULL) {
        ret = PyObject_Str((PyObject *)arr);
        Py_DECREF(arr);
    }
    return ret;
}


static PyObject *
gentype_repr(PyObject *self)
{
    PyObject *arr, *ret = NULL;

    arr = PyArray_FromScalar(self, NULL);
    if (arr != NULL) {
        /* XXX: Why are we using str here? */
        ret = PyObject_Str((PyObject *)arr);
        Py_DECREF(arr);
    }
    return ret;
}

/*
 * The __format__ method for PEP 3101.
 */
static PyObject *
gentype_format(PyObject *self, PyObject *args)
{
    PyObject *format_spec;
    PyObject *obj, *ret;

#if defined(NPY_PY3K)
    if (!PyArg_ParseTuple(args, "U:__format__", &format_spec)) {
        return NULL;
    }
#else
    if (!PyArg_ParseTuple(args, "O:__format__", &format_spec)) {
        return NULL;
    }

    if (!PyUnicode_Check(format_spec) && !PyString_Check(format_spec)) {
        PyErr_SetString(PyExc_TypeError,
                "format must be a string");
        return NULL;
    }
#endif

    /*
     * Convert to an appropriate Python type and call its format.
     * TODO: For some types, like long double, this isn't right,
     *       because it throws away precision.
     */
    if (Py_TYPE(self) == &PyBoolArrType_Type) {
        obj = PyBool_FromLong(((PyBoolScalarObject *)self)->obval);
    }
    else if (PyArray_IsScalar(self, Integer)) {
#if defined(NPY_PY3K)
        obj = Py_TYPE(self)->tp_as_number->nb_int(self);
#else
        obj = Py_TYPE(self)->tp_as_number->nb_long(self);
#endif
    }
    else if (PyArray_IsScalar(self, Floating)) {
        obj = Py_TYPE(self)->tp_as_number->nb_float(self);
    }
    else if (PyArray_IsScalar(self, ComplexFloating)) {
        double val[2];
        PyArray_Descr *dtype = PyArray_DescrFromScalar(self);

        if (dtype == NULL) {
            return NULL;
        }
        if (PyArray_CastScalarDirect(self, dtype, &val[0], NPY_CDOUBLE) < 0) {
            Py_DECREF(dtype);
            return NULL;
        }
        obj = PyComplex_FromDoubles(val[0], val[1]);
        Py_DECREF(dtype);
    }
    else {
        obj = PyObject_Str(self);
    }

    if (obj == NULL) {
        return NULL;
    }

    ret = PyObject_Format(obj, format_spec);
    Py_DECREF(obj);
    return ret;
}

#ifdef FORCE_NO_LONG_DOUBLE_FORMATTING
#undef NPY_LONGDOUBLE_FMT
#define NPY_LONGDOUBLE_FMT NPY_DOUBLE_FMT
#endif

#line 446

#define _FMT1 "%%.%i" NPY_FLOAT_FMT
#define _FMT2 "%%+.%i" NPY_FLOAT_FMT

NPY_NO_EXPORT void
format_float(char *buf, size_t buflen, npy_float val, unsigned int prec)
{
    /* XXX: Find a correct size here for format string */
    char format[64], *res;
    size_t i, cnt;

    PyOS_snprintf(format, sizeof(format), _FMT1, prec);
    res = NumPyOS_ascii_formatf(buf, buflen, format, val, 0);
    if (res == NULL) {
        fprintf(stderr, "Error while formatting\n");
        return;
    }

    /* If nothing but digits after sign, append ".0" */
    cnt = strlen(buf);
    for (i = (buf[0] == '-') ? 1 : 0; i < cnt; ++i) {
        if (!isdigit(Py_CHARMASK(buf[i]))) {
            break;
        }
    }
    if (i == cnt && buflen >= cnt + 3) {
        strcpy(&buf[cnt],".0");
    }
}

#undef _FMT1
#undef _FMT2


#line 446

#define _FMT1 "%%.%i" NPY_DOUBLE_FMT
#define _FMT2 "%%+.%i" NPY_DOUBLE_FMT

NPY_NO_EXPORT void
format_double(char *buf, size_t buflen, npy_double val, unsigned int prec)
{
    /* XXX: Find a correct size here for format string */
    char format[64], *res;
    size_t i, cnt;

    PyOS_snprintf(format, sizeof(format), _FMT1, prec);
    res = NumPyOS_ascii_formatd(buf, buflen, format, val, 0);
    if (res == NULL) {
        fprintf(stderr, "Error while formatting\n");
        return;
    }

    /* If nothing but digits after sign, append ".0" */
    cnt = strlen(buf);
    for (i = (buf[0] == '-') ? 1 : 0; i < cnt; ++i) {
        if (!isdigit(Py_CHARMASK(buf[i]))) {
            break;
        }
    }
    if (i == cnt && buflen >= cnt + 3) {
        strcpy(&buf[cnt],".0");
    }
}

#undef _FMT1
#undef _FMT2


#line 446

#define _FMT1 "%%.%i" NPY_LONGDOUBLE_FMT
#define _FMT2 "%%+.%i" NPY_LONGDOUBLE_FMT

NPY_NO_EXPORT void
format_longdouble(char *buf, size_t buflen, npy_longdouble val, unsigned int prec)
{
    /* XXX: Find a correct size here for format string */
    char format[64], *res;
    size_t i, cnt;

    PyOS_snprintf(format, sizeof(format), _FMT1, prec);
    res = NumPyOS_ascii_formatl(buf, buflen, format, val, 0);
    if (res == NULL) {
        fprintf(stderr, "Error while formatting\n");
        return;
    }

    /* If nothing but digits after sign, append ".0" */
    cnt = strlen(buf);
    for (i = (buf[0] == '-') ? 1 : 0; i < cnt; ++i) {
        if (!isdigit(Py_CHARMASK(buf[i]))) {
            break;
        }
    }
    if (i == cnt && buflen >= cnt + 3) {
        strcpy(&buf[cnt],".0");
    }
}

#undef _FMT1
#undef _FMT2



#line 487

#define _FMT1 "%%.%i" NPY_FLOAT_FMT
#define _FMT2 "%%+.%i" NPY_FLOAT_FMT

static void
format_cfloat(char *buf, size_t buflen, npy_cfloat val, unsigned int prec)
{
    /* XXX: Find a correct size here for format string */
    char format[64];
    char *res;

    /*
     * Ideally, we should handle this nan/inf stuff in NumpyOS_ascii_format*
     */
#if PY_VERSION_HEX >= 0x02070000
    if (val.real == 0.0 && npy_signbit(val.real) == 0) {
#else
    if (val.real == 0.0) {
#endif
        PyOS_snprintf(format, sizeof(format), _FMT1, prec);
        res = NumPyOS_ascii_formatf(buf, buflen - 1, format, val.imag, 0);
        if (res == NULL) {
            /* FIXME
             * We need a better way to handle the error message
             */
            fprintf(stderr, "Error while formatting\n");
            return;
        }
        if (!npy_isfinite(val.imag)) {
            strncat(buf, "*", 1);
        }
        strncat(buf, "j", 1);
    }
    else {
        char re[64], im[64];
        if (npy_isfinite(val.real)) {
                PyOS_snprintf(format, sizeof(format), _FMT1, prec);
                res = NumPyOS_ascii_formatf(re, sizeof(re), format,
                        val.real, 0);
                if (res == NULL) {
                    /* FIXME
                     * We need a better way to handle the error message
                     */
                    fprintf(stderr, "Error while formatting\n");
                    return;
                }
        }
        else {
                if (npy_isnan(val.real)) {
                        strcpy(re, "nan");
                }
                else if (val.real > 0){
                        strcpy(re, "inf");
                }
                else {
                        strcpy(re, "-inf");
                }
        }


        if (npy_isfinite(val.imag)) {
                PyOS_snprintf(format, sizeof(format), _FMT2, prec);
                res = NumPyOS_ascii_formatf(im, sizeof(im), format,
                        val.imag, 0);
                if (res == NULL) {
                    fprintf(stderr, "Error while formatting\n");
                    return;
                }
        }
        else {
                if (npy_isnan(val.imag)) {
                        strcpy(im, "+nan");
                }
                else if (val.imag > 0){
                        strcpy(im, "+inf");
                }
                else {
                        strcpy(im, "-inf");
                }
                if (!npy_isfinite(val.imag)) {
                        strncat(im, "*", 1);
                }
        }
        PyOS_snprintf(buf, buflen, "(%s%sj)", re, im);
    }
}

#undef _FMT1
#undef _FMT2


#line 487

#define _FMT1 "%%.%i" NPY_DOUBLE_FMT
#define _FMT2 "%%+.%i" NPY_DOUBLE_FMT

static void
format_cdouble(char *buf, size_t buflen, npy_cdouble val, unsigned int prec)
{
    /* XXX: Find a correct size here for format string */
    char format[64];
    char *res;

    /*
     * Ideally, we should handle this nan/inf stuff in NumpyOS_ascii_format*
     */
#if PY_VERSION_HEX >= 0x02070000
    if (val.real == 0.0 && npy_signbit(val.real) == 0) {
#else
    if (val.real == 0.0) {
#endif
        PyOS_snprintf(format, sizeof(format), _FMT1, prec);
        res = NumPyOS_ascii_formatd(buf, buflen - 1, format, val.imag, 0);
        if (res == NULL) {
            /* FIXME
             * We need a better way to handle the error message
             */
            fprintf(stderr, "Error while formatting\n");
            return;
        }
        if (!npy_isfinite(val.imag)) {
            strncat(buf, "*", 1);
        }
        strncat(buf, "j", 1);
    }
    else {
        char re[64], im[64];
        if (npy_isfinite(val.real)) {
                PyOS_snprintf(format, sizeof(format), _FMT1, prec);
                res = NumPyOS_ascii_formatd(re, sizeof(re), format,
                        val.real, 0);
                if (res == NULL) {
                    /* FIXME
                     * We need a better way to handle the error message
                     */
                    fprintf(stderr, "Error while formatting\n");
                    return;
                }
        }
        else {
                if (npy_isnan(val.real)) {
                        strcpy(re, "nan");
                }
                else if (val.real > 0){
                        strcpy(re, "inf");
                }
                else {
                        strcpy(re, "-inf");
                }
        }


        if (npy_isfinite(val.imag)) {
                PyOS_snprintf(format, sizeof(format), _FMT2, prec);
                res = NumPyOS_ascii_formatd(im, sizeof(im), format,
                        val.imag, 0);
                if (res == NULL) {
                    fprintf(stderr, "Error while formatting\n");
                    return;
                }
        }
        else {
                if (npy_isnan(val.imag)) {
                        strcpy(im, "+nan");
                }
                else if (val.imag > 0){
                        strcpy(im, "+inf");
                }
                else {
                        strcpy(im, "-inf");
                }
                if (!npy_isfinite(val.imag)) {
                        strncat(im, "*", 1);
                }
        }
        PyOS_snprintf(buf, buflen, "(%s%sj)", re, im);
    }
}

#undef _FMT1
#undef _FMT2


#line 487

#define _FMT1 "%%.%i" NPY_LONGDOUBLE_FMT
#define _FMT2 "%%+.%i" NPY_LONGDOUBLE_FMT

static void
format_clongdouble(char *buf, size_t buflen, npy_clongdouble val, unsigned int prec)
{
    /* XXX: Find a correct size here for format string */
    char format[64];
    char *res;

    /*
     * Ideally, we should handle this nan/inf stuff in NumpyOS_ascii_format*
     */
#if PY_VERSION_HEX >= 0x02070000
    if (val.real == 0.0 && npy_signbit(val.real) == 0) {
#else
    if (val.real == 0.0) {
#endif
        PyOS_snprintf(format, sizeof(format), _FMT1, prec);
        res = NumPyOS_ascii_formatl(buf, buflen - 1, format, val.imag, 0);
        if (res == NULL) {
            /* FIXME
             * We need a better way to handle the error message
             */
            fprintf(stderr, "Error while formatting\n");
            return;
        }
        if (!npy_isfinite(val.imag)) {
            strncat(buf, "*", 1);
        }
        strncat(buf, "j", 1);
    }
    else {
        char re[64], im[64];
        if (npy_isfinite(val.real)) {
                PyOS_snprintf(format, sizeof(format), _FMT1, prec);
                res = NumPyOS_ascii_formatl(re, sizeof(re), format,
                        val.real, 0);
                if (res == NULL) {
                    /* FIXME
                     * We need a better way to handle the error message
                     */
                    fprintf(stderr, "Error while formatting\n");
                    return;
                }
        }
        else {
                if (npy_isnan(val.real)) {
                        strcpy(re, "nan");
                }
                else if (val.real > 0){
                        strcpy(re, "inf");
                }
                else {
                        strcpy(re, "-inf");
                }
        }


        if (npy_isfinite(val.imag)) {
                PyOS_snprintf(format, sizeof(format), _FMT2, prec);
                res = NumPyOS_ascii_formatl(im, sizeof(im), format,
                        val.imag, 0);
                if (res == NULL) {
                    fprintf(stderr, "Error while formatting\n");
                    return;
                }
        }
        else {
                if (npy_isnan(val.imag)) {
                        strcpy(im, "+nan");
                }
                else if (val.imag > 0){
                        strcpy(im, "+inf");
                }
                else {
                        strcpy(im, "-inf");
                }
                if (!npy_isfinite(val.imag)) {
                        strncat(im, "*", 1);
                }
        }
        PyOS_snprintf(buf, buflen, "(%s%sj)", re, im);
    }
}

#undef _FMT1
#undef _FMT2



NPY_NO_EXPORT void
format_half(char *buf, size_t buflen, npy_half val, unsigned int prec)
{
    format_float(buf, buflen, npy_half_to_float(val), prec);
}

/*
 * over-ride repr and str of array-scalar strings and unicode to
 * remove NULL bytes and then call the corresponding functions
 * of string and unicode.
 */

#line 599
static PyObject *
stringtype_repr(PyObject *self)
{
    const npy_char *dptr, *ip;
    int len;
    PyObject *new;
    PyObject *ret;

    ip = dptr = PyString_AS_STRING(self);
    len = PyString_GET_SIZE(self);
    dptr += len-1;
    while(len > 0 && *dptr-- == 0) {
        len--;
    }
    new = PyString_FromStringAndSize(ip, len);
    if (new == NULL) {
        return PyUString_FromString("");
    }
    ret = PyString_Type.tp_repr(new);
    Py_DECREF(new);
    return ret;
}

#line 599
static PyObject *
stringtype_str(PyObject *self)
{
    const npy_char *dptr, *ip;
    int len;
    PyObject *new;
    PyObject *ret;

    ip = dptr = PyString_AS_STRING(self);
    len = PyString_GET_SIZE(self);
    dptr += len-1;
    while(len > 0 && *dptr-- == 0) {
        len--;
    }
    new = PyString_FromStringAndSize(ip, len);
    if (new == NULL) {
        return PyUString_FromString("");
    }
    ret = PyString_Type.tp_str(new);
    Py_DECREF(new);
    return ret;
}

#line 599
static PyObject *
unicodetype_repr(PyObject *self)
{
    const Py_UNICODE *dptr, *ip;
    int len;
    PyObject *new;
    PyObject *ret;

    ip = dptr = PyUnicode_AS_UNICODE(self);
    len = PyUnicode_GET_SIZE(self);
    dptr += len-1;
    while(len > 0 && *dptr-- == 0) {
        len--;
    }
    new = PyUnicode_FromUnicode(ip, len);
    if (new == NULL) {
        return PyUString_FromString("");
    }
    ret = PyUnicode_Type.tp_repr(new);
    Py_DECREF(new);
    return ret;
}

#line 599
static PyObject *
unicodetype_str(PyObject *self)
{
    const Py_UNICODE *dptr, *ip;
    int len;
    PyObject *new;
    PyObject *ret;

    ip = dptr = PyUnicode_AS_UNICODE(self);
    len = PyUnicode_GET_SIZE(self);
    dptr += len-1;
    while(len > 0 && *dptr-- == 0) {
        len--;
    }
    new = PyUnicode_FromUnicode(ip, len);
    if (new == NULL) {
        return PyUString_FromString("");
    }
    ret = PyUnicode_Type.tp_str(new);
    Py_DECREF(new);
    return ret;
}


static PyObject *
datetimetype_repr(PyObject *self)
{
    PyDatetimeScalarObject *scal;
    npy_datetimestruct dts;
    PyObject *ret;
    char iso[NPY_DATETIME_MAX_ISO8601_STRLEN];
    int local;
    NPY_DATETIMEUNIT unit;

    if (!PyArray_IsScalar(self, Datetime)) {
        PyErr_SetString(PyExc_RuntimeError,
                "Called NumPy datetime repr on a non-datetime type");
        return NULL;
    }

    scal = (PyDatetimeScalarObject *)self;

    if (convert_datetime_to_datetimestruct(&scal->obmeta,
                scal->obval, &dts) < 0) {
        return NULL;
    }

    local = (scal->obmeta.base > NPY_FR_D);
    /*
     * Because we're defaulting to local time, display hours with
     * minutes precision, so that 30-minute timezone offsets can work.
     */
    unit = scal->obmeta.base;
    if (unit == NPY_FR_h) {
        unit = NPY_FR_m;
    }
    if (make_iso_8601_datetime(&dts, iso, sizeof(iso), local,
                            unit, -1, NPY_SAFE_CASTING) < 0) {
        return NULL;
    }

    /*
     * For straight units or generic units, the unit will be deduced
     * from the string, so it's not necessary to specify it.
     */
    if ((scal->obmeta.num == 1 && scal->obmeta.base != NPY_FR_h) ||
            scal->obmeta.base == NPY_FR_GENERIC) {
        ret = PyUString_FromString("numpy.datetime64('");
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString(iso));
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString("')"));
    }
    else {
        ret = PyUString_FromString("numpy.datetime64('");
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString(iso));
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString("','"));
        ret = append_metastr_to_string(&scal->obmeta, 1, ret);
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString("')"));
    }

    return ret;
}

static PyObject *
timedeltatype_repr(PyObject *self)
{
    PyTimedeltaScalarObject *scal;
    PyObject *ret;

    if (!PyArray_IsScalar(self, Timedelta)) {
        PyErr_SetString(PyExc_RuntimeError,
                "Called NumPy timedelta repr on a non-datetime type");
        return NULL;
    }

    scal = (PyTimedeltaScalarObject *)self;

    /* The value */
    if (scal->obval == NPY_DATETIME_NAT) {
        ret = PyUString_FromString("numpy.timedelta64('NaT'");
    }
    else {
        /*
         * Can't use "%lld" in Python < 2.7, Python3 < 3.2,
         * or if HAVE_LONG_LONG is not defined
         */
#if defined(HAVE_LONG_LONG) && \
           ((PY_VERSION_HEX >= 0x02070000 && PY_VERSION_HEX < 0x03000000) || \
            (PY_VERSION_HEX >= 0x03020000))
        ret = PyUString_FromFormat("numpy.timedelta64(%lld",
                                            (long long)scal->obval);
#else
        ret = PyUString_FromFormat("numpy.timedelta64(%ld",
                                            (long)scal->obval);
#endif
    }
    /* The metadata unit */
    if (scal->obmeta.base == NPY_FR_GENERIC) {
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString(")"));
    }
    else {
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString(",'"));
        ret = append_metastr_to_string(&scal->obmeta, 1, ret);
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString("')"));
    }

    return ret;
}

static PyObject *
datetimetype_str(PyObject *self)
{
    PyDatetimeScalarObject *scal;
    npy_datetimestruct dts;
    char iso[NPY_DATETIME_MAX_ISO8601_STRLEN];
    int local;
    NPY_DATETIMEUNIT unit;

    if (!PyArray_IsScalar(self, Datetime)) {
        PyErr_SetString(PyExc_RuntimeError,
                "Called NumPy datetime str on a non-datetime type");
        return NULL;
    }

    scal = (PyDatetimeScalarObject *)self;

    if (convert_datetime_to_datetimestruct(&scal->obmeta, scal->obval,
                                                            &dts) < 0) {
        return NULL;
    }

    local = (scal->obmeta.base > NPY_FR_D);
    /*
     * Because we're defaulting to local time, display hours with
     * minutes precision, so that 30-minute timezone offsets can work.
     */
    unit = scal->obmeta.base;
    if (unit == NPY_FR_h) {
        unit = NPY_FR_m;
    }
    if (make_iso_8601_datetime(&dts, iso, sizeof(iso), local,
                            unit, -1, NPY_SAFE_CASTING) < 0) {
        return NULL;
    }

    return PyUString_FromString(iso);
}

static char *_datetime_verbose_strings[NPY_DATETIME_NUMUNITS] = {
    "years",
    "months",
    "weeks",
    "<invalid>",
    "days",
    "hours",
    "minutes",
    "seconds",
    "milliseconds",
    "microseconds",
    "nanoseconds",
    "picoseconds",
    "femtoseconds",
    "attoseconds",
    "generic time units"
};

static PyObject *
timedeltatype_str(PyObject *self)
{
    PyTimedeltaScalarObject *scal;
    PyObject *ret;
    char *basestr = "invalid";

    if (!PyArray_IsScalar(self, Timedelta)) {
        PyErr_SetString(PyExc_RuntimeError,
                "Called NumPy timedelta str on a non-datetime type");
        return NULL;
    }

    scal = (PyTimedeltaScalarObject *)self;

    if (scal->obmeta.base >= 0 && scal->obmeta.base < NPY_DATETIME_NUMUNITS) {
        basestr = _datetime_verbose_strings[scal->obmeta.base];
    }
    else {
        PyErr_SetString(PyExc_RuntimeError,
                "NumPy datetime metadata is corrupted");
        return NULL;
    }

    if (scal->obval == NPY_DATETIME_NAT) {
        ret = PyUString_FromString("NaT");
    }
    else {
        /*
         * Can't use "%lld" in Python < 2.7, Python3 < 3.2,
         * or if HAVE_LONG_LONG is not defined
         */
#if defined(HAVE_LONG_LONG) && \
           ((PY_VERSION_HEX >= 0x02070000 && PY_VERSION_HEX < 0x03000000) || \
            (PY_VERSION_HEX >= 0x03020000))
        ret = PyUString_FromFormat("%lld ",
                                (long long)(scal->obval * scal->obmeta.num));
#else
        ret = PyUString_FromFormat("%ld ",
                                (long)(scal->obval * scal->obmeta.num));
#endif
        PyUString_ConcatAndDel(&ret,
                PyUString_FromString(basestr));
    }

    return ret;
}

/* The REPR values are finfo.precision + 2 */
#define HALFPREC_REPR 5
#define HALFPREC_STR 5
#define FLOATPREC_REPR 8
#define FLOATPREC_STR 6
#define DOUBLEPREC_REPR 17
#define DOUBLEPREC_STR 12
#if NPY_SIZEOF_LONGDOUBLE == NPY_SIZEOF_DOUBLE
#define LONGDOUBLEPREC_REPR DOUBLEPREC_REPR
#define LONGDOUBLEPREC_STR DOUBLEPREC_STR
#else /* More than probably needed on Intel FP */
#define LONGDOUBLEPREC_REPR 20
#define LONGDOUBLEPREC_STR 12
#endif

/*
 * float type str and repr
 *
 * These functions will return NULL if PyString creation fails.
 */

#line 867
#line 871

#define PREC HALFPREC_STR

static PyObject *
halftype_str(PyObject *self)
{
    char buf[100];
    npy_half val = ((PyHalfScalarObject *)self)->obval;

    format_half(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}

#if 0
static PyObject *
chalftype_str(PyObject *self)
{
    char buf[202];
    npy_chalf val = ((PyCHalfScalarObject *)self)->obval;

    format_chalf(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}
#endif

#undef PREC


#line 871

#define PREC HALFPREC_REPR

static PyObject *
halftype_repr(PyObject *self)
{
    char buf[100];
    npy_half val = ((PyHalfScalarObject *)self)->obval;

    format_half(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}

#if 0
static PyObject *
chalftype_repr(PyObject *self)
{
    char buf[202];
    npy_chalf val = ((PyCHalfScalarObject *)self)->obval;

    format_chalf(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}
#endif

#undef PREC



#line 867
#line 871

#define PREC FLOATPREC_STR

static PyObject *
floattype_str(PyObject *self)
{
    char buf[100];
    npy_float val = ((PyFloatScalarObject *)self)->obval;

    format_float(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}

#if 1
static PyObject *
cfloattype_str(PyObject *self)
{
    char buf[202];
    npy_cfloat val = ((PyCFloatScalarObject *)self)->obval;

    format_cfloat(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}
#endif

#undef PREC


#line 871

#define PREC FLOATPREC_REPR

static PyObject *
floattype_repr(PyObject *self)
{
    char buf[100];
    npy_float val = ((PyFloatScalarObject *)self)->obval;

    format_float(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}

#if 1
static PyObject *
cfloattype_repr(PyObject *self)
{
    char buf[202];
    npy_cfloat val = ((PyCFloatScalarObject *)self)->obval;

    format_cfloat(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}
#endif

#undef PREC



#line 867
#line 871

#define PREC DOUBLEPREC_STR

static PyObject *
doubletype_str(PyObject *self)
{
    char buf[100];
    npy_double val = ((PyDoubleScalarObject *)self)->obval;

    format_double(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}

#if 1
static PyObject *
cdoubletype_str(PyObject *self)
{
    char buf[202];
    npy_cdouble val = ((PyCDoubleScalarObject *)self)->obval;

    format_cdouble(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}
#endif

#undef PREC


#line 871

#define PREC DOUBLEPREC_REPR

static PyObject *
doubletype_repr(PyObject *self)
{
    char buf[100];
    npy_double val = ((PyDoubleScalarObject *)self)->obval;

    format_double(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}

#if 1
static PyObject *
cdoubletype_repr(PyObject *self)
{
    char buf[202];
    npy_cdouble val = ((PyCDoubleScalarObject *)self)->obval;

    format_cdouble(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}
#endif

#undef PREC



#line 867
#line 871

#define PREC LONGDOUBLEPREC_STR

static PyObject *
longdoubletype_str(PyObject *self)
{
    char buf[100];
    npy_longdouble val = ((PyLongDoubleScalarObject *)self)->obval;

    format_longdouble(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}

#if 1
static PyObject *
clongdoubletype_str(PyObject *self)
{
    char buf[202];
    npy_clongdouble val = ((PyCLongDoubleScalarObject *)self)->obval;

    format_clongdouble(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}
#endif

#undef PREC


#line 871

#define PREC LONGDOUBLEPREC_REPR

static PyObject *
longdoubletype_repr(PyObject *self)
{
    char buf[100];
    npy_longdouble val = ((PyLongDoubleScalarObject *)self)->obval;

    format_longdouble(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}

#if 1
static PyObject *
clongdoubletype_repr(PyObject *self)
{
    char buf[202];
    npy_clongdouble val = ((PyCLongDoubleScalarObject *)self)->obval;

    format_clongdouble(buf, sizeof(buf), val, PREC);
    return PyUString_FromString(buf);
}
#endif

#undef PREC




/*
 * float type print (control print a, where a is a float type instance)
 */
#line 910

static int
halftype_print(PyObject *v, FILE *fp, int flags)
{
        char buf[100];
        npy_half val = ((PyHalfScalarObject *)v)->obval;

        format_half(buf, sizeof(buf), val,
                      (flags & Py_PRINT_RAW) ? HALFPREC_STR : HALFPREC_REPR);
        Py_BEGIN_ALLOW_THREADS
        fputs(buf, fp);
        Py_END_ALLOW_THREADS
        return 0;
}

#if 0
static int
chalftype_print(PyObject *v, FILE *fp, int flags)
{
        /* Size of buf: twice sizeof(real) + 2 (for the parenthesis) */
        char buf[202];
        npy_chalf val = ((PyCHalfScalarObject *)v)->obval;

        format_chalf(buf, sizeof(buf), val,
                       (flags & Py_PRINT_RAW) ? HALFPREC_STR : HALFPREC_REPR);
        Py_BEGIN_ALLOW_THREADS
        fputs(buf, fp);
        Py_END_ALLOW_THREADS
        return 0;
}
#endif


#line 910

static int
floattype_print(PyObject *v, FILE *fp, int flags)
{
        char buf[100];
        npy_float val = ((PyFloatScalarObject *)v)->obval;

        format_float(buf, sizeof(buf), val,
                      (flags & Py_PRINT_RAW) ? FLOATPREC_STR : FLOATPREC_REPR);
        Py_BEGIN_ALLOW_THREADS
        fputs(buf, fp);
        Py_END_ALLOW_THREADS
        return 0;
}

#if 1
static int
cfloattype_print(PyObject *v, FILE *fp, int flags)
{
        /* Size of buf: twice sizeof(real) + 2 (for the parenthesis) */
        char buf[202];
        npy_cfloat val = ((PyCFloatScalarObject *)v)->obval;

        format_cfloat(buf, sizeof(buf), val,
                       (flags & Py_PRINT_RAW) ? FLOATPREC_STR : FLOATPREC_REPR);
        Py_BEGIN_ALLOW_THREADS
        fputs(buf, fp);
        Py_END_ALLOW_THREADS
        return 0;
}
#endif


#line 910

static int
doubletype_print(PyObject *v, FILE *fp, int flags)
{
        char buf[100];
        npy_double val = ((PyDoubleScalarObject *)v)->obval;

        format_double(buf, sizeof(buf), val,
                      (flags & Py_PRINT_RAW) ? DOUBLEPREC_STR : DOUBLEPREC_REPR);
        Py_BEGIN_ALLOW_THREADS
        fputs(buf, fp);
        Py_END_ALLOW_THREADS
        return 0;
}

#if 1
static int
cdoubletype_print(PyObject *v, FILE *fp, int flags)
{
        /* Size of buf: twice sizeof(real) + 2 (for the parenthesis) */
        char buf[202];
        npy_cdouble val = ((PyCDoubleScalarObject *)v)->obval;

        format_cdouble(buf, sizeof(buf), val,
                       (flags & Py_PRINT_RAW) ? DOUBLEPREC_STR : DOUBLEPREC_REPR);
        Py_BEGIN_ALLOW_THREADS
        fputs(buf, fp);
        Py_END_ALLOW_THREADS
        return 0;
}
#endif


#line 910

static int
longdoubletype_print(PyObject *v, FILE *fp, int flags)
{
        char buf[100];
        npy_longdouble val = ((PyLongDoubleScalarObject *)v)->obval;

        format_longdouble(buf, sizeof(buf), val,
                      (flags & Py_PRINT_RAW) ? LONGDOUBLEPREC_STR : LONGDOUBLEPREC_REPR);
        Py_BEGIN_ALLOW_THREADS
        fputs(buf, fp);
        Py_END_ALLOW_THREADS
        return 0;
}

#if 1
static int
clongdoubletype_print(PyObject *v, FILE *fp, int flags)
{
        /* Size of buf: twice sizeof(real) + 2 (for the parenthesis) */
        char buf[202];
        npy_clongdouble val = ((PyCLongDoubleScalarObject *)v)->obval;

        format_clongdouble(buf, sizeof(buf), val,
                       (flags & Py_PRINT_RAW) ? LONGDOUBLEPREC_STR : LONGDOUBLEPREC_REPR);
        Py_BEGIN_ALLOW_THREADS
        fputs(buf, fp);
        Py_END_ALLOW_THREADS
        return 0;
}
#endif




/*
 * Could improve this with a PyLong_FromLongDouble(longdouble ldval)
 * but this would need some more work...
 */

#line 958
static PyObject *
longdoubletype_int(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyLongDoubleScalarObject *)self)->obval);
    obj = PyLong_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_int(obj);
    Py_DECREF(obj);
    return ret;
}

#line 958
static PyObject *
longdoubletype_float(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyLongDoubleScalarObject *)self)->obval);
    obj = PyFloat_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_float(obj);
    Py_DECREF(obj);
    return ret;
}

#line 958
static PyObject *
clongdoubletype_int(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyCLongDoubleScalarObject *)self)->obval).real;
    obj = PyLong_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_int(obj);
    Py_DECREF(obj);
    return ret;
}

#line 958
static PyObject *
clongdoubletype_float(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyCLongDoubleScalarObject *)self)->obval).real;
    obj = PyFloat_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_float(obj);
    Py_DECREF(obj);
    return ret;
}


#if !defined(NPY_PY3K)

#line 982
static PyObject *
longdoubletype_long(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyLongDoubleScalarObject *)self)->obval);
    obj = PyLong_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_long(obj);
    Py_DECREF(obj);
    return ret;
}

#line 982
static PyObject *
longdoubletype_hex(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyLongDoubleScalarObject *)self)->obval);
    obj = PyLong_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_hex(obj);
    Py_DECREF(obj);
    return ret;
}

#line 982
static PyObject *
longdoubletype_oct(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyLongDoubleScalarObject *)self)->obval);
    obj = PyLong_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_oct(obj);
    Py_DECREF(obj);
    return ret;
}

#line 982
static PyObject *
clongdoubletype_long(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyCLongDoubleScalarObject *)self)->obval).real;
    obj = PyLong_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_long(obj);
    Py_DECREF(obj);
    return ret;
}

#line 982
static PyObject *
clongdoubletype_hex(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyCLongDoubleScalarObject *)self)->obval).real;
    obj = PyLong_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_hex(obj);
    Py_DECREF(obj);
    return ret;
}

#line 982
static PyObject *
clongdoubletype_oct(PyObject *self)
{
    double dval;
    PyObject *obj, *ret;

    dval = (double)(((PyCLongDoubleScalarObject *)self)->obval).real;
    obj = PyLong_FromDouble(dval);
    ret = Py_TYPE(obj)->tp_as_number->nb_oct(obj);
    Py_DECREF(obj);
    return ret;
}


#endif /* !defined(NPY_PY3K) */

static PyNumberMethods gentype_as_number = {
    (binaryfunc)gentype_add,                     /*nb_add*/
    (binaryfunc)gentype_subtract,                /*nb_subtract*/
    (binaryfunc)gentype_multiply,                /*nb_multiply*/
#if defined(NPY_PY3K)
#else
    (binaryfunc)gentype_divide,                  /*nb_divide*/
#endif
    (binaryfunc)gentype_remainder,               /*nb_remainder*/
    (binaryfunc)gentype_divmod,                  /*nb_divmod*/
    (ternaryfunc)gentype_power,                  /*nb_power*/
    (unaryfunc)gentype_negative,
    (unaryfunc)gentype_positive,                 /*nb_pos*/
    (unaryfunc)gentype_absolute,                 /*(unaryfunc)gentype_abs,*/
    (inquiry)gentype_nonzero_number,             /*nb_nonzero*/
    (unaryfunc)gentype_invert,                   /*nb_invert*/
    (binaryfunc)gentype_lshift,                  /*nb_lshift*/
    (binaryfunc)gentype_rshift,                  /*nb_rshift*/
    (binaryfunc)gentype_and,                     /*nb_and*/
    (binaryfunc)gentype_xor,                     /*nb_xor*/
    (binaryfunc)gentype_or,                      /*nb_or*/
#if defined(NPY_PY3K)
#else
    0,                                           /*nb_coerce*/
#endif
    (unaryfunc)gentype_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    0,                                           /*nb_reserved*/
#else
    (unaryfunc)gentype_long,                     /*nb_long*/
#endif
    (unaryfunc)gentype_float,                    /*nb_float*/
#if defined(NPY_PY3K)
#else
    (unaryfunc)gentype_oct,                      /*nb_oct*/
    (unaryfunc)gentype_hex,                      /*nb_hex*/
#endif
    0,                                           /*inplace_add*/
    0,                                           /*inplace_subtract*/
    0,                                           /*inplace_multiply*/
#if defined(NPY_PY3K)
#else
    0,                                           /*inplace_divide*/
#endif
    0,                                           /*inplace_remainder*/
    0,                                           /*inplace_power*/
    0,                                           /*inplace_lshift*/
    0,                                           /*inplace_rshift*/
    0,                                           /*inplace_and*/
    0,                                           /*inplace_xor*/
    0,                                           /*inplace_or*/
    (binaryfunc)gentype_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)gentype_true_divide,             /*nb_true_divide*/
    0,                                           /*nb_inplace_floor_divide*/
    0,                                           /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                             /*nb_index*/
};


static PyObject *
gentype_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    PyObject *arr, *ret;

    arr = PyArray_FromScalar(self, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = Py_TYPE(arr)->tp_richcompare(arr, other, cmp_op);
    Py_DECREF(arr);
    return ret;
}

static PyObject *
gentype_ndim_get(PyObject *NPY_UNUSED(self))
{
    return PyInt_FromLong(0);
}

static PyObject *
gentype_flags_get(PyObject *NPY_UNUSED(self))
{
    return PyArray_NewFlagsObject(NULL);
}

static PyObject *
voidtype_flags_get(PyVoidScalarObject *self)
{
    PyObject *flagobj;
    flagobj = PyArrayFlags_Type.tp_alloc(&PyArrayFlags_Type, 0);
    if (flagobj == NULL) {
        return NULL;
    }
    ((PyArrayFlagsObject *)flagobj)->arr = NULL;
    ((PyArrayFlagsObject *)flagobj)->flags = self->flags;
    return flagobj;
}

static PyObject *
voidtype_dtypedescr_get(PyVoidScalarObject *self)
{
    Py_INCREF(self->descr);
    return (PyObject *)self->descr;
}


static PyObject *
gentype_data_get(PyObject *self)
{
#if defined(NPY_PY3K)
    return PyMemoryView_FromObject(self);
#else
    return PyBuffer_FromObject(self, 0, Py_END_OF_BUFFER);
#endif
}


static PyObject *
gentype_itemsize_get(PyObject *self)
{
    PyArray_Descr *typecode;
    PyObject *ret;
    int elsize;

    typecode = PyArray_DescrFromScalar(self);
    elsize = typecode->elsize;
#ifndef Py_UNICODE_WIDE
    if (typecode->type_num == NPY_UNICODE) {
        elsize >>= 1;
    }
#endif
    ret = PyInt_FromLong((long) elsize);
    Py_DECREF(typecode);
    return ret;
}

static PyObject *
gentype_size_get(PyObject *NPY_UNUSED(self))
{
    return PyInt_FromLong(1);
}

#if PY_VERSION_HEX >= 0x03000000
NPY_NO_EXPORT void
gentype_struct_free(PyObject *ptr)
{
    PyArrayInterface *arrif;
    PyObject *context;

    arrif = (PyArrayInterface*)PyCapsule_GetPointer(ptr, NULL);
    context = (PyObject *)PyCapsule_GetContext(ptr);
    Py_DECREF(context);
    Py_XDECREF(arrif->descr);
    PyArray_free(arrif->shape);
    PyArray_free(arrif);
}
#else
NPY_NO_EXPORT void
gentype_struct_free(void *ptr, void *arg)
{
    PyArrayInterface *arrif = (PyArrayInterface *)ptr;
    Py_DECREF((PyObject *)arg);
    Py_XDECREF(arrif->descr);
    PyArray_free(arrif->shape);
    PyArray_free(arrif);
}
#endif

static PyObject *
gentype_struct_get(PyObject *self)
{
    PyArrayObject *arr;
    PyArrayInterface *inter;
    PyObject *ret;

    arr = (PyArrayObject *)PyArray_FromScalar(self, NULL);
    inter = (PyArrayInterface *)PyArray_malloc(sizeof(PyArrayInterface));
    inter->two = 2;
    inter->nd = 0;
    inter->flags = PyArray_FLAGS(arr);
    inter->flags &= ~(NPY_ARRAY_UPDATEIFCOPY | NPY_ARRAY_OWNDATA);
    inter->flags |= NPY_ARRAY_NOTSWAPPED;
    inter->typekind = PyArray_DESCR(arr)->kind;
    inter->itemsize = PyArray_DESCR(arr)->elsize;
    inter->strides = NULL;
    inter->shape = NULL;
    inter->data = PyArray_DATA(arr);
    inter->descr = NULL;

    ret = NpyCapsule_FromVoidPtrAndDesc(inter, arr, gentype_struct_free);
    return ret;
}

static PyObject *
gentype_priority_get(PyObject *NPY_UNUSED(self))
{
    return PyFloat_FromDouble(NPY_SCALAR_PRIORITY);
}

static PyObject *
gentype_shape_get(PyObject *NPY_UNUSED(self))
{
    return PyTuple_New(0);
}


static PyObject *
gentype_interface_get(PyObject *self)
{
    PyArrayObject *arr;
    PyObject *inter;

    arr = (PyArrayObject *)PyArray_FromScalar(self, NULL);
    if (arr == NULL) {
        return NULL;
    }
    inter = PyObject_GetAttrString((PyObject *)arr, "__array_interface__");
    if (inter != NULL) {
        PyDict_SetItemString(inter, "__ref", (PyObject *)arr);
    }
    Py_DECREF(arr);
    return inter;
}



static PyObject *
gentype_typedescr_get(PyObject *self)
{
    return (PyObject *)PyArray_DescrFromScalar(self);
}


static PyObject *
gentype_base_get(PyObject *NPY_UNUSED(self))
{
    Py_INCREF(Py_None);
    return Py_None;
}


static PyArray_Descr *
_realdescr_fromcomplexscalar(PyObject *self, int *typenum)
{
    if (PyArray_IsScalar(self, CDouble)) {
        *typenum = NPY_CDOUBLE;
        return PyArray_DescrFromType(NPY_DOUBLE);
    }
    if (PyArray_IsScalar(self, CFloat)) {
        *typenum = NPY_CFLOAT;
        return PyArray_DescrFromType(NPY_FLOAT);
    }
    if (PyArray_IsScalar(self, CLongDouble)) {
        *typenum = NPY_CLONGDOUBLE;
        return PyArray_DescrFromType(NPY_LONGDOUBLE);
    }
    return NULL;
}

static PyObject *
gentype_real_get(PyObject *self)
{
    PyArray_Descr *typecode;
    PyObject *ret;
    int typenum;

    if (PyArray_IsScalar(self, ComplexFloating)) {
        void *ptr;
        typecode = _realdescr_fromcomplexscalar(self, &typenum);
        ptr = scalar_value(self, NULL);
        ret = PyArray_Scalar(ptr, typecode, NULL);
        Py_DECREF(typecode);
        return ret;
    }
    else if (PyArray_IsScalar(self, Object)) {
        PyObject *obj = ((PyObjectScalarObject *)self)->obval;
        ret = PyObject_GetAttrString(obj, "real");
        if (ret != NULL) {
            return ret;
        }
        PyErr_Clear();
    }
    Py_INCREF(self);
    return (PyObject *)self;
}

static PyObject *
gentype_imag_get(PyObject *self)
{
    PyArray_Descr *typecode=NULL;
    PyObject *ret;
    int typenum;

    if (PyArray_IsScalar(self, ComplexFloating)) {
        char *ptr;
        typecode = _realdescr_fromcomplexscalar(self, &typenum);
        ptr = (char *)scalar_value(self, NULL);
        ret = PyArray_Scalar(ptr + typecode->elsize, typecode, NULL);
    }
    else if (PyArray_IsScalar(self, Object)) {
        PyObject *obj = ((PyObjectScalarObject *)self)->obval;
        PyArray_Descr *newtype;
        ret = PyObject_GetAttrString(obj, "imag");
        if (ret == NULL) {
            PyErr_Clear();
            obj = PyInt_FromLong(0);
            newtype = PyArray_DescrFromType(NPY_OBJECT);
            ret = PyArray_Scalar((char *)&obj, newtype, NULL);
            Py_DECREF(newtype);
            Py_DECREF(obj);
        }
    }
    else {
        char *temp;
        int elsize;
        typecode = PyArray_DescrFromScalar(self);
        elsize = typecode->elsize;
        temp = PyDataMem_NEW(elsize);
        memset(temp, '\0', elsize);
        ret = PyArray_Scalar(temp, typecode, NULL);
        PyDataMem_FREE(temp);
    }

    Py_XDECREF(typecode);
    return ret;
}

static PyObject *
gentype_flat_get(PyObject *self)
{
    PyObject *ret, *arr;

    arr = PyArray_FromScalar(self, NULL);
    if (arr == NULL) {
        return NULL;
    }
    ret = PyArray_IterNew(arr);
    Py_DECREF(arr);
    return ret;
}


static PyObject *
gentype_transpose_get(PyObject *self)
{
    Py_INCREF(self);
    return self;
}


static PyGetSetDef gentype_getsets[] = {
    {"ndim",
        (getter)gentype_ndim_get,
        (setter) 0,
        "number of array dimensions",
        NULL},
    {"flags",
        (getter)gentype_flags_get,
        (setter)0,
        "integer value of flags",
        NULL},
    {"shape",
        (getter)gentype_shape_get,
        (setter)0,
        "tuple of array dimensions",
        NULL},
    {"strides",
        (getter)gentype_shape_get,
        (setter) 0,
        "tuple of bytes steps in each dimension",
        NULL},
    {"data",
        (getter)gentype_data_get,
        (setter) 0,
        "pointer to start of data",
        NULL},
    {"itemsize",
        (getter)gentype_itemsize_get,
        (setter)0,
        "length of one element in bytes",
        NULL},
    {"size",
        (getter)gentype_size_get,
        (setter)0,
        "number of elements in the gentype",
        NULL},
    {"nbytes",
        (getter)gentype_itemsize_get,
        (setter)0,
        "length of item in bytes",
        NULL},
    {"base",
        (getter)gentype_base_get,
        (setter)0,
        "base object",
        NULL},
    {"dtype",
        (getter)gentype_typedescr_get,
        NULL,
        "get array data-descriptor",
        NULL},
    {"real",
        (getter)gentype_real_get,
        (setter)0,
        "real part of scalar",
        NULL},
    {"imag",
        (getter)gentype_imag_get,
        (setter)0,
        "imaginary part of scalar",
        NULL},
    {"flat",
        (getter)gentype_flat_get,
        (setter)0,
        "a 1-d view of scalar",
        NULL},
    {"T",
        (getter)gentype_transpose_get,
        (setter)0,
        "transpose",
        NULL},
    {"__array_interface__",
        (getter)gentype_interface_get,
        NULL,
        "Array protocol: Python side",
        NULL},
    {"__array_struct__",
        (getter)gentype_struct_get,
        NULL,
        "Array protocol: struct",
        NULL},
    {"__array_priority__",
        (getter)gentype_priority_get,
        NULL,
        "Array priority.",
        NULL},
    {NULL, NULL, NULL, NULL, NULL}  /* Sentinel */
};


/* 0-dim array from scalar object */

static char doc_getarray[] = "sc.__array__(|type) return 0-dim array";

static PyObject *
gentype_getarray(PyObject *scalar, PyObject *args)
{
    PyArray_Descr *outcode=NULL;
    PyObject *ret;

    if (!PyArg_ParseTuple(args, "|O&", &PyArray_DescrConverter,
                &outcode)) {
        Py_XDECREF(outcode);
        return NULL;
    }
    ret = PyArray_FromScalar(scalar, outcode);
    return ret;
}

static char doc_sc_wraparray[] = "sc.__array_wrap__(obj) return scalar from array";

static PyObject *
gentype_wraparray(PyObject *NPY_UNUSED(scalar), PyObject *args)
{
    PyObject *obj;
    PyArrayObject *arr;

    if (PyTuple_Size(args) < 1) {
        PyErr_SetString(PyExc_TypeError,
                "only accepts 1 argument.");
        return NULL;
    }
    obj = PyTuple_GET_ITEM(args, 0);
    if (!PyArray_Check(obj)) {
        PyErr_SetString(PyExc_TypeError,
                "can only be called with ndarray object");
        return NULL;
    }
    arr = (PyArrayObject *)obj;

    return PyArray_Scalar(PyArray_DATA(arr),
                    PyArray_DESCR(arr), (PyObject *)arr);
}

/*
 * These gentype_* functions do not take keyword arguments.
 * The proper flag is METH_VARARGS.
 */
#line 1492
static PyObject *
gentype_tolist(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "tolist");
}

#line 1492
static PyObject *
gentype_item(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "item");
}

#line 1492
static PyObject *
gentype_tostring(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "tostring");
}

#line 1492
static PyObject *
gentype_astype(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "astype");
}

#line 1492
static PyObject *
gentype_copy(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "copy");
}

#line 1492
static PyObject *
gentype___deepcopy__(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "__deepcopy__");
}

#line 1492
static PyObject *
gentype_searchsorted(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "searchsorted");
}

#line 1492
static PyObject *
gentype_view(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "view");
}

#line 1492
static PyObject *
gentype_swapaxes(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "swapaxes");
}

#line 1492
static PyObject *
gentype_conj(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "conj");
}

#line 1492
static PyObject *
gentype_conjugate(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "conjugate");
}

#line 1492
static PyObject *
gentype_nonzero(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "nonzero");
}

#line 1492
static PyObject *
gentype_flatten(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "flatten");
}

#line 1492
static PyObject *
gentype_ravel(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "ravel");
}

#line 1492
static PyObject *
gentype_fill(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "fill");
}

#line 1492
static PyObject *
gentype_transpose(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "transpose");
}

#line 1492
static PyObject *
gentype_newbyteorder(PyObject *self, PyObject *args)
{
    return gentype_generic_method(self, args, NULL, "newbyteorder");
}


static PyObject *
gentype_itemset(PyObject *NPY_UNUSED(self), PyObject *NPY_UNUSED(args))
{
    PyErr_SetString(PyExc_ValueError, "array-scalars are immutable");
    return NULL;
}

static PyObject *
gentype_squeeze(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, "")) {
        return NULL;
    }
    Py_INCREF(self);
    return self;
}

static Py_ssize_t
gentype_getreadbuf(PyObject *, Py_ssize_t, void **);

static PyObject *
gentype_byteswap(PyObject *self, PyObject *args)
{
    npy_bool inplace = NPY_FALSE;

    if (!PyArg_ParseTuple(args, "|O&", PyArray_BoolConverter, &inplace)) {
        return NULL;
    }
    if (inplace) {
        PyErr_SetString(PyExc_ValueError,
                "cannot byteswap a scalar in-place");
        return NULL;
    }
    else {
        /* get the data, copyswap it and pass it to a new Array scalar */
        char *data;
        PyArray_Descr *descr;
        PyObject *new;
        char *newmem;

        gentype_getreadbuf(self, 0, (void **)&data);
        descr = PyArray_DescrFromScalar(self);
        newmem = PyArray_malloc(descr->elsize);
        if (newmem == NULL) {
            Py_DECREF(descr);
            return PyErr_NoMemory();
        }
        else {
            descr->f->copyswap(newmem, data, 1, NULL);
        }
        new = PyArray_Scalar(newmem, descr, NULL);
        PyArray_free(newmem);
        Py_DECREF(descr);
        return new;
    }
}


/*
 * These gentype_* functions take keyword arguments.
 * The proper flag is METH_VARARGS | METH_KEYWORDS.
 */
#line 1568
static PyObject *
gentype_take(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "take");
}

#line 1568
static PyObject *
gentype_getfield(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "getfield");
}

#line 1568
static PyObject *
gentype_put(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "put");
}

#line 1568
static PyObject *
gentype_repeat(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "repeat");
}

#line 1568
static PyObject *
gentype_tofile(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "tofile");
}

#line 1568
static PyObject *
gentype_mean(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "mean");
}

#line 1568
static PyObject *
gentype_trace(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "trace");
}

#line 1568
static PyObject *
gentype_diagonal(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "diagonal");
}

#line 1568
static PyObject *
gentype_clip(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "clip");
}

#line 1568
static PyObject *
gentype_std(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "std");
}

#line 1568
static PyObject *
gentype_var(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "var");
}

#line 1568
static PyObject *
gentype_sum(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "sum");
}

#line 1568
static PyObject *
gentype_cumsum(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "cumsum");
}

#line 1568
static PyObject *
gentype_prod(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "prod");
}

#line 1568
static PyObject *
gentype_cumprod(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "cumprod");
}

#line 1568
static PyObject *
gentype_compress(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "compress");
}

#line 1568
static PyObject *
gentype_sort(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "sort");
}

#line 1568
static PyObject *
gentype_argsort(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "argsort");
}

#line 1568
static PyObject *
gentype_round(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "round");
}

#line 1568
static PyObject *
gentype_argmax(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "argmax");
}

#line 1568
static PyObject *
gentype_argmin(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "argmin");
}

#line 1568
static PyObject *
gentype_max(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "max");
}

#line 1568
static PyObject *
gentype_min(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "min");
}

#line 1568
static PyObject *
gentype_ptp(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "ptp");
}

#line 1568
static PyObject *
gentype_any(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "any");
}

#line 1568
static PyObject *
gentype_all(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "all");
}

#line 1568
static PyObject *
gentype_resize(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "resize");
}

#line 1568
static PyObject *
gentype_reshape(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "reshape");
}

#line 1568
static PyObject *
gentype_choose(PyObject *self, PyObject *args, PyObject *kwds)
{
    return gentype_generic_method(self, args, kwds, "choose");
}


static PyObject *
voidtype_getfield(PyVoidScalarObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *ret, *newargs;

    newargs = PyTuple_GetSlice(args, 0, 2);
    if (newargs == NULL) {
        return NULL;
    }
    ret = gentype_generic_method((PyObject *)self, newargs, kwds, "getfield");
    Py_DECREF(newargs);
    if (!ret) {
        return ret;
    }
    if (PyArray_IsScalar(ret, Generic) &&   \
            (!PyArray_IsScalar(ret, Void))) {
        PyArray_Descr *new;
        void *ptr;
        if (!PyArray_ISNBO(self->descr->byteorder)) {
            new = PyArray_DescrFromScalar(ret);
            ptr = scalar_value(ret, new);
            byte_swap_vector(ptr, 1, new->elsize);
            Py_DECREF(new);
        }
    }
    return ret;
}

static PyObject *
gentype_setfield(PyObject *NPY_UNUSED(self), PyObject *NPY_UNUSED(args), PyObject *NPY_UNUSED(kwds))
{
    PyErr_SetString(PyExc_TypeError,
            "Can't set fields in a non-void array scalar.");
    return NULL;
}

static PyObject *
voidtype_setfield(PyVoidScalarObject *self, PyObject *args, PyObject *kwds)
{
    PyArray_Descr *typecode = NULL;
    int offset = 0;
    PyObject *value;
    PyArrayObject *src;
    int mysize;
    char *dptr;
    static char *kwlist[] = {"value", "dtype", "offset", 0};

    if ((self->flags & NPY_ARRAY_WRITEABLE) != NPY_ARRAY_WRITEABLE) {
        PyErr_SetString(PyExc_RuntimeError, "Can't write to memory");
        return NULL;
    }
    if (!PyArg_ParseTupleAndKeywords(args, kwds, "OO&|i", kwlist,
                &value,
                PyArray_DescrConverter,
                &typecode, &offset)) {
        Py_XDECREF(typecode);
        return NULL;
    }

    mysize = Py_SIZE(self);

    if (offset < 0 || (offset + typecode->elsize) > mysize) {
        PyErr_Format(PyExc_ValueError,
                "Need 0 <= offset <= %d for requested type "  \
                "but received offset = %d",
                mysize-typecode->elsize, offset);
        Py_DECREF(typecode);
        return NULL;
    }

    dptr = self->obval + offset;

    if (typecode->type_num == NPY_OBJECT) {
        PyObject *temp;
        Py_INCREF(value);
        NPY_COPY_PYOBJECT_PTR(&temp, dptr);
        Py_XDECREF(temp);
        NPY_COPY_PYOBJECT_PTR(dptr, &value);
        Py_DECREF(typecode);
    }
    else {
        /* Copy data from value to correct place in dptr */
        src = (PyArrayObject *)PyArray_FromAny(value, typecode,
                                    0, 0, NPY_ARRAY_CARRAY, NULL);
        if (src == NULL) {
            return NULL;
        }
        typecode->f->copyswap(dptr, PyArray_DATA(src),
                !PyArray_ISNBO(self->descr->byteorder),
                src);
        Py_DECREF(src);
    }
    Py_INCREF(Py_None);
    return Py_None;
}


static PyObject *
gentype_reduce(PyObject *self, PyObject *NPY_UNUSED(args))
{
    PyObject *ret = NULL, *obj = NULL, *mod = NULL;
    const char *buffer;
    Py_ssize_t buflen;

    /* Return a tuple of (callable object, arguments) */
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
#if defined(NPY_PY3K)
    if (PyArray_IsScalar(self, Unicode)) {
        /* Unicode on Python 3 does not expose the buffer interface */
        buffer = PyUnicode_AS_DATA(self);
        buflen = PyUnicode_GET_DATA_SIZE(self);
    }
    else
#endif
    if (PyObject_AsReadBuffer(self, (const void **)&buffer, &buflen)<0) {
        Py_DECREF(ret);
        return NULL;
    }
    mod = PyImport_ImportModule("numpy.core.multiarray");
    if (mod == NULL) {
        return NULL;
    }
    obj = PyObject_GetAttrString(mod, "scalar");
    Py_DECREF(mod);
    if (obj == NULL) {
        return NULL;
    }
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyObject_GetAttrString((PyObject *)self, "dtype");
    if (PyArray_IsScalar(self, Object)) {
        mod = ((PyObjectScalarObject *)self)->obval;
        PyTuple_SET_ITEM(ret, 1, Py_BuildValue("NO", obj, mod));
    }
    else {
#ifndef Py_UNICODE_WIDE
        /*
         * We need to expand the buffer so that we always write
         * UCS4 to disk for pickle of unicode scalars.
         *
         * This could be in a unicode_reduce function, but
         * that would require re-factoring.
         */
        int alloc = 0;
        char *tmp;
        int newlen;

        if (PyArray_IsScalar(self, Unicode)) {
            tmp = PyArray_malloc(buflen*2);
            if (tmp == NULL) {
                Py_DECREF(ret);
                return PyErr_NoMemory();
            }
            alloc = 1;
            newlen = PyUCS2Buffer_AsUCS4((Py_UNICODE *)buffer,
                    (npy_ucs4 *)tmp,
                    buflen / 2, buflen / 2);
            buflen = newlen*4;
            buffer = tmp;
        }
#endif
        mod = PyBytes_FromStringAndSize(buffer, buflen);
        if (mod == NULL) {
            Py_DECREF(ret);
#ifndef Py_UNICODE_WIDE
            ret = NULL;
            goto fail;
#else
            return NULL;
#endif
        }
        PyTuple_SET_ITEM(ret, 1,
                Py_BuildValue("NN", obj, mod));
#ifndef Py_UNICODE_WIDE
fail:
        if (alloc) PyArray_free((char *)buffer);
#endif
    }
    return ret;
}

/* ignores everything */
static PyObject *
gentype_setstate(PyObject *NPY_UNUSED(self), PyObject *NPY_UNUSED(args))
{
    Py_INCREF(Py_None);
    return (Py_None);
}

static PyObject *
gentype_dump(PyObject *self, PyObject *args)
{
    PyObject *file = NULL;
    int ret;

    if (!PyArg_ParseTuple(args, "O", &file)) {
        return NULL;
    }
    ret = PyArray_Dump(self, file, 2);
    if (ret < 0) {
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
gentype_dumps(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, "")) {
        return NULL;
    }
    return PyArray_Dumps(self, 2);
}


/* setting flags cannot be done for scalars */
static PyObject *
gentype_setflags(PyObject *NPY_UNUSED(self), PyObject *NPY_UNUSED(args),
        PyObject *NPY_UNUSED(kwds))
{
    Py_INCREF(Py_None);
    return Py_None;
}

/*
 * casting complex numbers (that don't inherit from Python complex)
 * to Python complex
 */

#line 1811
static PyObject *
cfloat_complex(PyObject *self, PyObject *NPY_UNUSED(args),
               PyObject *NPY_UNUSED(kwds))
{
    return PyComplex_FromDoubles(PyArrayScalar_VAL(self, CFloat).real,
                                 PyArrayScalar_VAL(self, CFloat).imag);
}

#line 1811
static PyObject *
clongdouble_complex(PyObject *self, PyObject *NPY_UNUSED(args),
               PyObject *NPY_UNUSED(kwds))
{
    return PyComplex_FromDoubles(PyArrayScalar_VAL(self, CLongDouble).real,
                                 PyArrayScalar_VAL(self, CLongDouble).imag);
}


/*
 * need to fill in doc-strings for these methods on import -- copy from
 * array docstrings
 */
static PyMethodDef gentype_methods[] = {
    {"tolist",
        (PyCFunction)gentype_tolist,
        METH_VARARGS, NULL},
    {"item",
        (PyCFunction)gentype_item,
        METH_VARARGS, NULL},
    {"itemset",
        (PyCFunction)gentype_itemset,
        METH_VARARGS, NULL},
    {"tofile",
        (PyCFunction)gentype_tofile,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"tostring",
        (PyCFunction)gentype_tostring,
        METH_VARARGS, NULL},
    {"byteswap",
        (PyCFunction)gentype_byteswap,
        METH_VARARGS, NULL},
    {"astype",
        (PyCFunction)gentype_astype,
        METH_VARARGS, NULL},
    {"getfield",
        (PyCFunction)gentype_getfield,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"setfield",
        (PyCFunction)gentype_setfield,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"copy",
        (PyCFunction)gentype_copy,
        METH_VARARGS, NULL},
    {"resize",
        (PyCFunction)gentype_resize,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"__array__",
        (PyCFunction)gentype_getarray,
        METH_VARARGS, doc_getarray},
    {"__array_wrap__",
        (PyCFunction)gentype_wraparray,
        METH_VARARGS, doc_sc_wraparray},

    /* for the copy module */
    {"__copy__",
        (PyCFunction)gentype_copy,
        METH_VARARGS, NULL},
    {"__deepcopy__",
        (PyCFunction)gentype___deepcopy__,
        METH_VARARGS, NULL},

    {"__reduce__",
        (PyCFunction) gentype_reduce,
        METH_VARARGS, NULL},
    /* For consistency does nothing */
    {"__setstate__",
        (PyCFunction) gentype_setstate,
        METH_VARARGS, NULL},

    {"dumps",
        (PyCFunction) gentype_dumps,
        METH_VARARGS, NULL},
    {"dump",
        (PyCFunction) gentype_dump,
        METH_VARARGS, NULL},

    /* Methods for array */
    {"fill",
        (PyCFunction)gentype_fill,
        METH_VARARGS, NULL},
    {"transpose",
        (PyCFunction)gentype_transpose,
        METH_VARARGS, NULL},
    {"take",
        (PyCFunction)gentype_take,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"put",
        (PyCFunction)gentype_put,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"repeat",
        (PyCFunction)gentype_repeat,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"choose",
        (PyCFunction)gentype_choose,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"sort",
        (PyCFunction)gentype_sort,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"argsort",
        (PyCFunction)gentype_argsort,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"searchsorted",
        (PyCFunction)gentype_searchsorted,
        METH_VARARGS, NULL},
    {"argmax",
        (PyCFunction)gentype_argmax,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"argmin",
        (PyCFunction)gentype_argmin,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"reshape",
        (PyCFunction)gentype_reshape,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"squeeze",
        (PyCFunction)gentype_squeeze,
        METH_VARARGS, NULL},
    {"view",
        (PyCFunction)gentype_view,
        METH_VARARGS, NULL},
    {"swapaxes",
        (PyCFunction)gentype_swapaxes,
        METH_VARARGS, NULL},
    {"max",
        (PyCFunction)gentype_max,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"min",
        (PyCFunction)gentype_min,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"ptp",
        (PyCFunction)gentype_ptp,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"mean",
        (PyCFunction)gentype_mean,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"trace",
        (PyCFunction)gentype_trace,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"diagonal",
        (PyCFunction)gentype_diagonal,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"clip",
        (PyCFunction)gentype_clip,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"conj",
        (PyCFunction)gentype_conj,
        METH_VARARGS, NULL},
    {"conjugate",
        (PyCFunction)gentype_conjugate,
        METH_VARARGS, NULL},
    {"nonzero",
        (PyCFunction)gentype_nonzero,
        METH_VARARGS, NULL},
    {"std",
        (PyCFunction)gentype_std,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"var",
        (PyCFunction)gentype_var,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"sum",
        (PyCFunction)gentype_sum,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"cumsum",
        (PyCFunction)gentype_cumsum,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"prod",
        (PyCFunction)gentype_prod,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"cumprod",
        (PyCFunction)gentype_cumprod,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"all",
        (PyCFunction)gentype_all,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"any",
        (PyCFunction)gentype_any,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"compress",
        (PyCFunction)gentype_compress,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"flatten",
        (PyCFunction)gentype_flatten,
        METH_VARARGS, NULL},
    {"ravel",
        (PyCFunction)gentype_ravel,
        METH_VARARGS, NULL},
    {"round",
        (PyCFunction)gentype_round,
        METH_VARARGS | METH_KEYWORDS, NULL},
#if defined(NPY_PY3K)
    /* Hook for the round() builtin */
    {"__round__",
        (PyCFunction)gentype_round,
        METH_VARARGS | METH_KEYWORDS, NULL},
#endif
    /* For the format function */
    {"__format__",
        gentype_format,
        METH_VARARGS,
        "NumPy array scalar formatter"},
    {"setflags",
        (PyCFunction)gentype_setflags,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"newbyteorder",
        (PyCFunction)gentype_newbyteorder,
        METH_VARARGS, NULL},
    {NULL, NULL, 0, NULL} /* sentinel */
};


static PyGetSetDef voidtype_getsets[] = {
    {"flags",
        (getter)voidtype_flags_get,
        (setter)0,
        "integer value of flags",
        NULL},
    {"dtype",
        (getter)voidtype_dtypedescr_get,
        (setter)0,
        "dtype object",
        NULL},
    {NULL, NULL, NULL, NULL, NULL}
};

static PyMethodDef voidtype_methods[] = {
    {"getfield",
        (PyCFunction)voidtype_getfield,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {"setfield",
        (PyCFunction)voidtype_setfield,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {NULL, NULL, 0, NULL}
};

#line 2048
static PyMethodDef cfloattype_methods[] = {
    {"__complex__",
        (PyCFunction)cfloat_complex,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {NULL, NULL, 0, NULL}
};

#line 2048
static PyMethodDef clongdoubletype_methods[] = {
    {"__complex__",
        (PyCFunction)clongdouble_complex,
        METH_VARARGS | METH_KEYWORDS, NULL},
    {NULL, NULL, 0, NULL}
};


/************* As_mapping functions for void array scalar ************/

static Py_ssize_t
voidtype_length(PyVoidScalarObject *self)
{
    if (!PyDataType_HASFIELDS(self->descr)) {
        return 0;
    }
    else {
        /* return the number of fields */
        return (Py_ssize_t) PyTuple_GET_SIZE(self->descr->names);
    }
}

static PyObject *
voidtype_item(PyVoidScalarObject *self, Py_ssize_t n)
{
    npy_intp m;
    PyObject *flist=NULL, *fieldinfo;

    if (!(PyDataType_HASFIELDS(self->descr))) {
        PyErr_SetString(PyExc_IndexError,
                "can't index void scalar without fields");
        return NULL;
    }
    flist = self->descr->names;
    m = PyTuple_GET_SIZE(flist);
    if (n < 0) {
        n += m;
    }
    if (n < 0 || n >= m) {
        PyErr_Format(PyExc_IndexError, "invalid index (%d)", (int) n);
        return NULL;
    }
    fieldinfo = PyDict_GetItem(self->descr->fields,
            PyTuple_GET_ITEM(flist, n));
    return voidtype_getfield(self, fieldinfo, NULL);
}


/* get field by name or number */
static PyObject *
voidtype_subscript(PyVoidScalarObject *self, PyObject *ind)
{
    npy_intp n;
    PyObject *fieldinfo;

    if (!(PyDataType_HASFIELDS(self->descr))) {
        PyErr_SetString(PyExc_IndexError,
                "can't index void scalar without fields");
        return NULL;
    }

#if defined(NPY_PY3K)
    if (PyUString_Check(ind)) {
#else
    if (PyBytes_Check(ind) || PyUnicode_Check(ind)) {
#endif
        /* look up in fields */
        fieldinfo = PyDict_GetItem(self->descr->fields, ind);
        if (!fieldinfo) {
            goto fail;
        }
        return voidtype_getfield(self, fieldinfo, NULL);
    }

    /* try to convert it to a number */
    n = PyArray_PyIntAsIntp(ind);
    if (error_converting(n)) {
        goto fail;
    }
    return voidtype_item(self, (Py_ssize_t)n);

fail:
    PyErr_SetString(PyExc_IndexError, "invalid index");
    return NULL;
}

static int
voidtype_ass_item(PyVoidScalarObject *self, Py_ssize_t n, PyObject *val)
{
    npy_intp m;
    PyObject *flist=NULL, *fieldinfo, *newtup;
    PyObject *res;

    if (!(PyDataType_HASFIELDS(self->descr))) {
        PyErr_SetString(PyExc_IndexError,
                "can't index void scalar without fields");
        return -1;
    }

    flist = self->descr->names;
    m = PyTuple_GET_SIZE(flist);
    if (n < 0) {
        n += m;
    }
    if (n < 0 || n >= m) {
        goto fail;
    }
    fieldinfo = PyDict_GetItem(self->descr->fields,
            PyTuple_GET_ITEM(flist, n));
    newtup = Py_BuildValue("(OOO)", val,
            PyTuple_GET_ITEM(fieldinfo, 0),
            PyTuple_GET_ITEM(fieldinfo, 1));
    res = voidtype_setfield(self, newtup, NULL);
    Py_DECREF(newtup);
    if (!res) {
        return -1;
    }
    Py_DECREF(res);
    return 0;

fail:
    PyErr_Format(PyExc_IndexError, "invalid index (%d)", (int) n);
    return -1;
}

static int
voidtype_ass_subscript(PyVoidScalarObject *self, PyObject *ind, PyObject *val)
{
    npy_intp n;
    char *msg = "invalid index";
    PyObject *fieldinfo, *newtup;
    PyObject *res;

    if (!PyDataType_HASFIELDS(self->descr)) {
        PyErr_SetString(PyExc_IndexError,
                "can't index void scalar without fields");
        return -1;
    }

    if (!val) {
        PyErr_SetString(PyExc_ValueError,
                "cannot delete scalar field");
        return -1;
    }

#if defined(NPY_PY3K)
    if (PyUString_Check(ind)) {
#else
    if (PyBytes_Check(ind) || PyUnicode_Check(ind)) {
#endif
        /* look up in fields */
        fieldinfo = PyDict_GetItem(self->descr->fields, ind);
        if (!fieldinfo) {
            goto fail;
        }
        newtup = Py_BuildValue("(OOO)", val,
                PyTuple_GET_ITEM(fieldinfo, 0),
                PyTuple_GET_ITEM(fieldinfo, 1));
        res = voidtype_setfield(self, newtup, NULL);
        Py_DECREF(newtup);
        if (!res) {
            return -1;
        }
        Py_DECREF(res);
        return 0;
    }

    /* try to convert it to a number */
    n = PyArray_PyIntAsIntp(ind);
    if (error_converting(n)) {
        goto fail;
    }
    return voidtype_ass_item(self, (Py_ssize_t)n, val);

fail:
    PyErr_SetString(PyExc_IndexError, msg);
    return -1;
}

static PyMappingMethods voidtype_as_mapping = {
    (lenfunc)voidtype_length,                    /*mp_length*/
    (binaryfunc)voidtype_subscript,              /*mp_subscript*/
    (objobjargproc)voidtype_ass_subscript,       /*mp_ass_subscript*/
};


static PySequenceMethods voidtype_as_sequence = {
    (lenfunc)voidtype_length,                    /*sq_length*/
    0,                                           /*sq_concat*/
    0,                                           /*sq_repeat*/
    (ssizeargfunc)voidtype_item,                 /*sq_item*/
    0,                                           /*sq_slice*/
    (ssizeobjargproc)voidtype_ass_item,          /*sq_ass_item*/
    0,                                           /* ssq_ass_slice */
    0,                                           /* sq_contains */
    0,                                           /* sq_inplace_concat */
    0,                                           /* sq_inplace_repeat */
};


static Py_ssize_t
gentype_getreadbuf(PyObject *self, Py_ssize_t segment, void **ptrptr)
{
    int numbytes;
    PyArray_Descr *outcode;

    if (segment != 0) {
        PyErr_SetString(PyExc_SystemError,
                "Accessing non-existent array segment");
        return -1;
    }

    outcode = PyArray_DescrFromScalar(self);
    numbytes = outcode->elsize;
    *ptrptr = (void *)scalar_value(self, outcode);

#ifndef Py_UNICODE_WIDE
    if (outcode->type_num == NPY_UNICODE) {
        numbytes >>= 1;
    }
#endif
    Py_DECREF(outcode);
    return numbytes;
}

#if !defined(NPY_PY3K)
static Py_ssize_t
gentype_getsegcount(PyObject *self, Py_ssize_t *lenp)
{
    PyArray_Descr *outcode;

    outcode = PyArray_DescrFromScalar(self);
    if (lenp) {
        *lenp = outcode->elsize;
#ifndef Py_UNICODE_WIDE
        if (outcode->type_num == NPY_UNICODE) {
            *lenp >>= 1;
        }
#endif
    }
    Py_DECREF(outcode);
    return 1;
}

static Py_ssize_t
gentype_getcharbuf(PyObject *self, Py_ssize_t segment, constchar **ptrptr)
{
    if (PyArray_IsScalar(self, String) ||
            PyArray_IsScalar(self, Unicode)) {
        return gentype_getreadbuf(self, segment, (void **)ptrptr);
    }
    else {
        PyErr_SetString(PyExc_TypeError,
                "Non-character array cannot be interpreted "\
                "as character buffer.");
        return -1;
    }
}
#endif /* !defined(NPY_PY3K) */


static int
gentype_getbuffer(PyObject *self, Py_buffer *view, int flags)
{
    Py_ssize_t len;
    void *buf;

    /* FIXME: XXX: the format is not implemented! -- this needs more work */

    len = gentype_getreadbuf(self, 0, &buf);
    return PyBuffer_FillInfo(view, self, buf, len, 1, flags);
}

/* releasebuffer is not needed */


static PyBufferProcs gentype_as_buffer = {
#if !defined(NPY_PY3K)
    gentype_getreadbuf,                          /* bf_getreadbuffer*/
    NULL,                                        /* bf_getwritebuffer*/
    gentype_getsegcount,                         /* bf_getsegcount*/
    gentype_getcharbuf,                          /* bf_getcharbuffer*/
#endif
    gentype_getbuffer,                           /* bf_getbuffer */
    NULL,                                        /* bf_releasebuffer */
};


#if defined(NPY_PY3K)
#define BASEFLAGS Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE
#define LEAFFLAGS  Py_TPFLAGS_DEFAULT
#else
#define BASEFLAGS Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_CHECKTYPES
#define LEAFFLAGS  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES
#endif

NPY_NO_EXPORT PyTypeObject PyGenericArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.generic",                            /* tp_name*/
    sizeof(PyObject),                           /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    /* methods */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

static void
void_dealloc(PyVoidScalarObject *v)
{
    if (v->flags & NPY_ARRAY_OWNDATA) {
        PyDataMem_FREE(v->obval);
    }
    Py_XDECREF(v->descr);
    Py_XDECREF(v->base);
    Py_TYPE(v)->tp_free(v);
}

static void
object_arrtype_dealloc(PyObject *v)
{
    Py_XDECREF(((PyObjectScalarObject *)v)->obval);
    Py_TYPE(v)->tp_free(v);
}

/*
 * string and unicode inherit from Python Type first and so GET_ITEM
 * is different to get to the Python Type.
 *
 * ok is a work-around for a bug in complex_new that doesn't allocate
 *  memory from the sub-types memory allocator.
 */

#define _WORK(num)  \
    if (type->tp_bases && (PyTuple_GET_SIZE(type->tp_bases)==2)) { \
        PyTypeObject *sup; \
        /* We are inheriting from a Python type as well so \
           give it first dibs on conversion */ \
        sup = (PyTypeObject *)PyTuple_GET_ITEM(type->tp_bases, num); \
        robj = sup->tp_new(type, args, kwds); \
        if (robj != NULL) goto finish;              \
        if (PyTuple_GET_SIZE(args)!=1) return NULL; \
        PyErr_Clear(); \
        /* now do default conversion */ \
    }

#define _WORK1 _WORK(1)
#define _WORKz _WORK(0)
#define _WORK0

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
byte_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_BYTE);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyByteScalarObject *)robj)->obval, 0, sizeof(npy_byte));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_BYTE);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_byte *)dest) = *((npy_byte *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
short_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_SHORT);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyShortScalarObject *)robj)->obval, 0, sizeof(npy_short));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_SHORT);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_short *)dest) = *((npy_short *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
int_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_1(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK1

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_INT);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyIntScalarObject *)robj)->obval, 0, sizeof(npy_int));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_INT);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_int *)dest) = *((npy_int *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
long_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_1(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK1

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_LONG);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyLongScalarObject *)robj)->obval, 0, sizeof(npy_long));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_LONG);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_long *)dest) = *((npy_long *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
longlong_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_1(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK1

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_LONGLONG);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyLongLongScalarObject *)robj)->obval, 0, sizeof(npy_longlong));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_LONGLONG);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_longlong *)dest) = *((npy_longlong *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
ubyte_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_UBYTE);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyUByteScalarObject *)robj)->obval, 0, sizeof(npy_ubyte));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_UBYTE);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_ubyte *)dest) = *((npy_ubyte *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
ushort_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_USHORT);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyUShortScalarObject *)robj)->obval, 0, sizeof(npy_ushort));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_USHORT);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_ushort *)dest) = *((npy_ushort *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
uint_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_UINT);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyUIntScalarObject *)robj)->obval, 0, sizeof(npy_uint));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_UINT);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_uint *)dest) = *((npy_uint *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
ulong_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_ULONG);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyULongScalarObject *)robj)->obval, 0, sizeof(npy_ulong));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_ULONG);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_ulong *)dest) = *((npy_ulong *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
ulonglong_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_ULONGLONG);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyULongLongScalarObject *)robj)->obval, 0, sizeof(npy_ulonglong));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_ULONGLONG);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_ulonglong *)dest) = *((npy_ulonglong *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
half_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_HALF);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyHalfScalarObject *)robj)->obval, 0, sizeof(npy_half));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_HALF);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_half *)dest) = *((npy_half *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
float_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_FLOAT);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyFloatScalarObject *)robj)->obval, 0, sizeof(npy_float));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_FLOAT);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_float *)dest) = *((npy_float *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
double_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_1(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK1

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_DOUBLE);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyDoubleScalarObject *)robj)->obval, 0, sizeof(npy_double));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_DOUBLE);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_double *)dest) = *((npy_double *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
longdouble_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_LONGDOUBLE);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyLongDoubleScalarObject *)robj)->obval, 0, sizeof(npy_longdouble));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_LONGDOUBLE);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_longdouble *)dest) = *((npy_longdouble *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
cfloat_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_CFLOAT);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyCFloatScalarObject *)robj)->obval, 0, sizeof(npy_cfloat));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_CFLOAT);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_cfloat *)dest) = *((npy_cfloat *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
cdouble_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_CDOUBLE);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyCDoubleScalarObject *)robj)->obval, 0, sizeof(npy_cdouble));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_CDOUBLE);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_cdouble *)dest) = *((npy_cdouble *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
clongdouble_arrtype_new(PyTypeObject *_NPY_UNUSED1_0(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(0 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_CLONGDOUBLE);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 0 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyCLongDoubleScalarObject *)robj)->obval, 0, sizeof(npy_clongdouble));
#elif 0 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 0 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 0 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_CLONGDOUBLE);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 0 == 0
    *((npy_clongdouble *)dest) = *((npy_clongdouble *)src);
#elif 0 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 0 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
string_arrtype_new(PyTypeObject *_NPY_UNUSED1_1(type), PyObject *args, PyObject *_NPY_UNUSED2_z(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(1 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORKz

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_STRING);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 1 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyStringScalarObject *)robj)->obval, 0, sizeof(npy_string));
#elif 1 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 1 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 1 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_STRING);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 1 == 0
    *((npy_string *)dest) = *((npy_string *)src);
#elif 1 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 1 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
unicode_arrtype_new(PyTypeObject *_NPY_UNUSED1_1(type), PyObject *args, PyObject *_NPY_UNUSED2_z(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(1 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORKz

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_UNICODE);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 1 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyUnicodeScalarObject *)robj)->obval, 0, sizeof(npy_unicode));
#elif 1 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 1 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 1 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_UNICODE);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 1 == 0
    *((npy_unicode *)dest) = *((npy_unicode *)src);
#elif 1 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 1 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}

#line 2460

#define _NPY_UNUSED2_1
#define _NPY_UNUSED2_z
#define _NPY_UNUSED2_0 NPY_UNUSED
#define _NPY_UNUSED1_0
#define _NPY_UNUSED1_1
#define _NPY_UNUSED1_2 NPY_UNUSED

static PyObject *
object_arrtype_new(PyTypeObject *_NPY_UNUSED1_2(type), PyObject *args, PyObject *_NPY_UNUSED2_0(kwds))
{
    PyObject *obj = NULL;
    PyObject *robj;
    PyArrayObject *arr;
    PyArray_Descr *typecode = NULL;
#if !(2 == 2)
    int itemsize;
    void *dest, *src;
#endif

    /*
     * allow base-class (if any) to do conversion
     * If successful, this will jump to finish:
     */
    _WORK0

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    typecode = PyArray_DescrFromType(NPY_OBJECT);
    if (typecode == NULL) {
        return NULL;
    }
    /*
     * typecode is new reference and stolen by
     * PyArray_FromAny but not PyArray_Scalar
     */
    if (obj == NULL) {
#if 2 == 0
        robj = PyArray_Scalar(NULL, typecode, NULL);
        if (robj == NULL) {
            Py_DECREF(typecode);
            return NULL;
        }
        memset(&((PyObjectScalarObject *)robj)->obval, 0, sizeof(npy_object));
#elif 2 == 1
        robj = PyArray_Scalar(NULL, typecode, NULL);
#elif 2 == 2
        Py_INCREF(Py_None);
        robj = Py_None;
#endif
        Py_DECREF(typecode);
        goto finish;
    }

    /*
     * It is expected at this point that robj is a PyArrayScalar
     * (even for Object Data Type)
     */
    arr = (PyArrayObject *)PyArray_FromAny(obj, typecode,
                                    0, 0, NPY_ARRAY_FORCECAST, NULL);
    if ((arr == NULL) || (PyArray_NDIM(arr) > 0)) {
        return (PyObject *)arr;
    }
    /* 0-d array */
    robj = PyArray_ToScalar(PyArray_DATA(arr), arr);
    Py_DECREF(arr);

finish:
    /*
     * In OBJECT case, robj is no longer a
     * PyArrayScalar at this point but the
     * remaining code assumes it is
     */
#if 2 == 2
    return robj;
#else
    /* Normal return */
    if ((robj == NULL) || (Py_TYPE(robj) == type)) {
        return robj;
    }

    /*
     * This return path occurs when the requested type is not created
     * but another scalar object is created instead (i.e. when
     * the base-class does the conversion in _WORK macro)
     */

    /* Need to allocate new type and copy data-area over */
    if (type->tp_itemsize) {
        itemsize = PyBytes_GET_SIZE(robj);
    }
    else {
        itemsize = 0;
    }
    obj = type->tp_alloc(type, itemsize);
    if (obj == NULL) {
        Py_DECREF(robj);
        return NULL;
    }
    /* typecode will be NULL */
    typecode = PyArray_DescrFromType(NPY_OBJECT);
    dest = scalar_value(obj, typecode);
    src = scalar_value(robj, typecode);
    Py_DECREF(typecode);
#if 2 == 0
    *((npy_object *)dest) = *((npy_object *)src);
#elif 2 == 1 /* unicode and strings */
    if (itemsize == 0) { /* unicode */
#if PY_VERSION_HEX >= 0x03030000
        itemsize = PyUnicode_GetLength(robj) * PyUnicode_KIND(robj);
#else
        itemsize = ((PyUnicodeObject *)robj)->length * sizeof(Py_UNICODE);
#endif
    }
    memcpy(dest, src, itemsize);
    /* 2 == 2 won't get here */
#endif
    Py_DECREF(robj);
    return obj;
#endif
}


#undef _WORK1
#undef _WORKz
#undef _WORK0
#undef _WORK

#line 2595

static PyObject *
datetime_arrtype_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    PyObject *obj = NULL, *meta_obj = NULL;
    PyDatetimeScalarObject *ret;

    if (!PyArg_ParseTuple(args, "|OO", &obj, &meta_obj)) {
        return NULL;
    }

    /* Allocate the return scalar */
    ret = (PyDatetimeScalarObject *)PyDatetimeArrType_Type.tp_alloc(
                                            &PyDatetimeArrType_Type, 0);
    if (ret == NULL) {
        return NULL;
    }

    /* Incorporate the metadata if its provided */
    if (meta_obj != NULL) {
        /* Parse the provided metadata input */
        if (convert_pyobject_to_datetime_metadata(meta_obj, &ret->obmeta)
                                                                    < 0) {
            Py_DECREF(ret);
            return NULL;
        }
    }
    else {
        /*
         * A unit of -1 signals that convert_pyobject_to_datetime
         * should populate.
         */
        ret->obmeta.base = -1;
    }

    if (obj == NULL) {
        if (ret->obmeta.base == -1) {
            ret->obmeta.base = NPY_DATETIME_DEFAULTUNIT;
            ret->obmeta.num = 1;
        }

        /* Make datetime default to NaT, timedelta default to zero */
#if 1
        ret->obval = NPY_DATETIME_NAT;
#else
        ret->obval = 0;
#endif
    }
    else if (convert_pyobject_to_datetime(&ret->obmeta, obj,
                            NPY_SAME_KIND_CASTING, &ret->obval) < 0) {
        Py_DECREF(ret);
        return NULL;
    }

    return (PyObject *)ret;
}

#line 2595

static PyObject *
timedelta_arrtype_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    PyObject *obj = NULL, *meta_obj = NULL;
    PyTimedeltaScalarObject *ret;

    if (!PyArg_ParseTuple(args, "|OO", &obj, &meta_obj)) {
        return NULL;
    }

    /* Allocate the return scalar */
    ret = (PyTimedeltaScalarObject *)PyTimedeltaArrType_Type.tp_alloc(
                                            &PyTimedeltaArrType_Type, 0);
    if (ret == NULL) {
        return NULL;
    }

    /* Incorporate the metadata if its provided */
    if (meta_obj != NULL) {
        /* Parse the provided metadata input */
        if (convert_pyobject_to_datetime_metadata(meta_obj, &ret->obmeta)
                                                                    < 0) {
            Py_DECREF(ret);
            return NULL;
        }
    }
    else {
        /*
         * A unit of -1 signals that convert_pyobject_to_datetime
         * should populate.
         */
        ret->obmeta.base = -1;
    }

    if (obj == NULL) {
        if (ret->obmeta.base == -1) {
            ret->obmeta.base = NPY_DATETIME_DEFAULTUNIT;
            ret->obmeta.num = 1;
        }

        /* Make datetime default to NaT, timedelta default to zero */
#if 0
        ret->obval = NPY_DATETIME_NAT;
#else
        ret->obval = 0;
#endif
    }
    else if (convert_pyobject_to_timedelta(&ret->obmeta, obj,
                            NPY_SAME_KIND_CASTING, &ret->obval) < 0) {
        Py_DECREF(ret);
        return NULL;
    }

    return (PyObject *)ret;
}


/* bool->tp_new only returns Py_True or Py_False */
static PyObject *
bool_arrtype_new(PyTypeObject *NPY_UNUSED(type), PyObject *args, PyObject *NPY_UNUSED(kwds))
{
    PyObject *obj = NULL;
    PyArrayObject *arr;

    if (!PyArg_ParseTuple(args, "|O", &obj)) {
        return NULL;
    }
    if (obj == NULL) {
        PyArrayScalar_RETURN_FALSE;
    }
    if (obj == Py_False) {
        PyArrayScalar_RETURN_FALSE;
    }
    if (obj == Py_True) {
        PyArrayScalar_RETURN_TRUE;
    }
    arr = (PyArrayObject *)PyArray_FROM_OTF(obj,
                                NPY_BOOL, NPY_ARRAY_FORCECAST);
    if (arr && 0 == PyArray_NDIM(arr)) {
        npy_bool val = *((npy_bool *)PyArray_DATA(arr));
        Py_DECREF(arr);
        PyArrayScalar_RETURN_BOOL_FROM_LONG(val);
    }
    return PyArray_Return((PyArrayObject *)arr);
}

static PyObject *
bool_arrtype_and(PyObject *a, PyObject *b)
{
    if (PyArray_IsScalar(a, Bool) && PyArray_IsScalar(b, Bool)) {
        PyArrayScalar_RETURN_BOOL_FROM_LONG
            ((a == PyArrayScalar_True) & (b == PyArrayScalar_True));
    }
    return PyGenericArrType_Type.tp_as_number->nb_and(a, b);
}

static PyObject *
bool_arrtype_or(PyObject *a, PyObject *b)
{
    if (PyArray_IsScalar(a, Bool) && PyArray_IsScalar(b, Bool)) {
        PyArrayScalar_RETURN_BOOL_FROM_LONG
            ((a == PyArrayScalar_True)|(b == PyArrayScalar_True));
    }
    return PyGenericArrType_Type.tp_as_number->nb_or(a, b);
}

static PyObject *
bool_arrtype_xor(PyObject *a, PyObject *b)
{
    if (PyArray_IsScalar(a, Bool) && PyArray_IsScalar(b, Bool)) {
        PyArrayScalar_RETURN_BOOL_FROM_LONG
            ((a == PyArrayScalar_True)^(b == PyArrayScalar_True));
    }
    return PyGenericArrType_Type.tp_as_number->nb_xor(a, b);
}

static int
bool_arrtype_nonzero(PyObject *a)
{
    return a == PyArrayScalar_True;
}

#line 2726
static PyNumberMethods byte_arrtype_as_number;
static PyObject *
byte_index(PyObject *self)
{
    return PyInt_FromLong(PyArrayScalar_VAL(self, Byte));
}

#line 2726
static PyNumberMethods short_arrtype_as_number;
static PyObject *
short_index(PyObject *self)
{
    return PyInt_FromLong(PyArrayScalar_VAL(self, Short));
}

#line 2726
static PyNumberMethods int_arrtype_as_number;
static PyObject *
int_index(PyObject *self)
{
    return PyInt_FromLong(PyArrayScalar_VAL(self, Int));
}

#line 2726
static PyNumberMethods long_arrtype_as_number;
static PyObject *
long_index(PyObject *self)
{
    return PyInt_FromLong(PyArrayScalar_VAL(self, Long));
}

#line 2726
static PyNumberMethods ubyte_arrtype_as_number;
static PyObject *
ubyte_index(PyObject *self)
{
    return PyInt_FromLong(PyArrayScalar_VAL(self, UByte));
}

#line 2726
static PyNumberMethods ushort_arrtype_as_number;
static PyObject *
ushort_index(PyObject *self)
{
    return PyInt_FromLong(PyArrayScalar_VAL(self, UShort));
}

#line 2726
static PyNumberMethods longlong_arrtype_as_number;
static PyObject *
longlong_index(PyObject *self)
{
    return PyLong_FromLongLong(PyArrayScalar_VAL(self, LongLong));
}

#line 2726
static PyNumberMethods uint_arrtype_as_number;
static PyObject *
uint_index(PyObject *self)
{
    return PyLong_FromUnsignedLong(PyArrayScalar_VAL(self, UInt));
}

#line 2726
static PyNumberMethods ulong_arrtype_as_number;
static PyObject *
ulong_index(PyObject *self)
{
    return PyLong_FromUnsignedLong(PyArrayScalar_VAL(self, ULong));
}

#line 2726
static PyNumberMethods ulonglong_arrtype_as_number;
static PyObject *
ulonglong_index(PyObject *self)
{
    return PyLong_FromUnsignedLongLong(PyArrayScalar_VAL(self, ULongLong));
}


static PyObject *
bool_index(PyObject *a)
{
    return PyInt_FromLong(PyArrayScalar_VAL(a, Bool));
}

/* Arithmetic methods -- only so we can override &, |, ^. */
NPY_NO_EXPORT PyNumberMethods bool_arrtype_as_number = {
    0,                                           /* nb_add */
    0,                                           /* nb_subtract */
    0,                                           /* nb_multiply */
#if defined(NPY_PY3K)
#else
    0,                                           /* nb_divide */
#endif
    0,                                           /* nb_remainder */
    0,                                           /* nb_divmod */
    0,                                           /* nb_power */
    0,                                           /* nb_negative */
    0,                                           /* nb_positive */
    0,                                           /* nb_absolute */
    (inquiry)bool_arrtype_nonzero,               /* nb_nonzero / nb_bool */
    0,                                           /* nb_invert */
    0,                                           /* nb_lshift */
    0,                                           /* nb_rshift */
    (binaryfunc)bool_arrtype_and,                /* nb_and */
    (binaryfunc)bool_arrtype_xor,                /* nb_xor */
    (binaryfunc)bool_arrtype_or,                 /* nb_or */
#if defined(NPY_PY3K)
#else
    0,                                           /* nb_coerce */
#endif
    0,                                           /* nb_int */
#if defined(NPY_PY3K)
    0,                                           /* nb_reserved */
#else
    0,                                           /* nb_long */
#endif
    0,                                           /* nb_float */
#if defined(NPY_PY3K)
#else
    0,                                           /* nb_oct */
    0,                                           /* nb_hex */
#endif
    /* Added in release 2.0 */
    0,                                           /* nb_inplace_add */
    0,                                           /* nb_inplace_subtract */
    0,                                           /* nb_inplace_multiply */
#if defined(NPY_PY3K)
#else
    0,                                           /* nb_inplace_divide */
#endif
    0,                                           /* nb_inplace_remainder */
    0,                                           /* nb_inplace_power */
    0,                                           /* nb_inplace_lshift */
    0,                                           /* nb_inplace_rshift */
    0,                                           /* nb_inplace_and */
    0,                                           /* nb_inplace_xor */
    0,                                           /* nb_inplace_or */
    /* Added in release 2.2 */
    /* The following require the Py_TPFLAGS_HAVE_CLASS flag */
    0,                                           /* nb_floor_divide */
    0,                                           /* nb_true_divide */
    0,                                           /* nb_inplace_floor_divide */
    0,                                           /* nb_inplace_true_divide */
    /* Added in release 2.5 */
    0,                                           /* nb_index */
};

static PyObject *
void_arrtype_new(PyTypeObject *type, PyObject *args, PyObject *NPY_UNUSED(kwds))
{
    PyObject *obj, *arr;
    npy_ulonglong memu = 1;
    PyObject *new = NULL;
    char *destptr;

    if (!PyArg_ParseTuple(args, "O", &obj)) {
        return NULL;
    }
    /*
     * For a VOID scalar first see if obj is an integer or long
     * and create new memory of that size (filled with 0) for the scalar
     */
    if (PyLong_Check(obj) || PyInt_Check(obj) ||
            PyArray_IsScalar(obj, Integer) ||
            (PyArray_Check(obj) &&
                     PyArray_NDIM((PyArrayObject *)obj)==0 &&
                     PyArray_ISINTEGER((PyArrayObject *)obj))) {
#if defined(NPY_PY3K)
        new = Py_TYPE(obj)->tp_as_number->nb_int(obj);
#else
        new = Py_TYPE(obj)->tp_as_number->nb_long(obj);
#endif
    }
    if (new && PyLong_Check(new)) {
        PyObject *ret;
        memu = PyLong_AsUnsignedLongLong(new);
        Py_DECREF(new);
        if (PyErr_Occurred() || (memu > NPY_MAX_INT)) {
            PyErr_Clear();
            PyErr_Format(PyExc_OverflowError,
                    "size must be smaller than %d",
                    (int) NPY_MAX_INT);
            return NULL;
        }
        destptr = PyDataMem_NEW((int) memu);
        if (destptr == NULL) {
            return PyErr_NoMemory();
        }
        ret = type->tp_alloc(type, 0);
        if (ret == NULL) {
            PyDataMem_FREE(destptr);
            return PyErr_NoMemory();
        }
        ((PyVoidScalarObject *)ret)->obval = destptr;
        Py_SIZE((PyVoidScalarObject *)ret) = (int) memu;
        ((PyVoidScalarObject *)ret)->descr =
            PyArray_DescrNewFromType(NPY_VOID);
        ((PyVoidScalarObject *)ret)->descr->elsize = (int) memu;
        ((PyVoidScalarObject *)ret)->flags = NPY_ARRAY_BEHAVED |
                                             NPY_ARRAY_OWNDATA;
        ((PyVoidScalarObject *)ret)->base = NULL;
        memset(destptr, '\0', (size_t) memu);
        return ret;
    }

    arr = PyArray_FROM_OTF(obj, NPY_VOID, NPY_ARRAY_FORCECAST);
    return PyArray_Return((PyArrayObject *)arr);
}


/****************  Define Hash functions ********************/

#line 2872
static npy_hash_t
bool_arrtype_hash(PyObject *obj)
{
    return (npy_hash_t)(((PyBoolScalarObject *)obj)->obval);
}

#line 2872
static npy_hash_t
ubyte_arrtype_hash(PyObject *obj)
{
    return (npy_hash_t)(((PyUByteScalarObject *)obj)->obval);
}

#line 2872
static npy_hash_t
ushort_arrtype_hash(PyObject *obj)
{
    return (npy_hash_t)(((PyUShortScalarObject *)obj)->obval);
}


#line 2883
static npy_hash_t
byte_arrtype_hash(PyObject *obj)
{
    npy_hash_t x = (npy_hash_t)(((PyByteScalarObject *)obj)->obval);
    if (x == -1) {
        x = -2;
    }
    return x;
}

#line 2883
static npy_hash_t
short_arrtype_hash(PyObject *obj)
{
    npy_hash_t x = (npy_hash_t)(((PyShortScalarObject *)obj)->obval);
    if (x == -1) {
        x = -2;
    }
    return x;
}

#line 2883
static npy_hash_t
uint_arrtype_hash(PyObject *obj)
{
    npy_hash_t x = (npy_hash_t)(((PyUIntScalarObject *)obj)->obval);
    if (x == -1) {
        x = -2;
    }
    return x;
}


static npy_hash_t
ulong_arrtype_hash(PyObject *obj)
{
    PyObject * l = PyLong_FromUnsignedLong(((PyULongScalarObject*)obj)->obval);
    npy_hash_t x = PyObject_Hash(l);
    Py_DECREF(l);
    return x;
}

#if (NPY_SIZEOF_INT != NPY_SIZEOF_LONG) || defined(NPY_PY3K)
static npy_hash_t
int_arrtype_hash(PyObject *obj)
{
    npy_hash_t x = (npy_hash_t)(((PyIntScalarObject *)obj)->obval);
    if (x == -1) {
        x = -2;
    }
    return x;
}
#endif

#if defined(NPY_PY3K)
static npy_hash_t
long_arrtype_hash(PyObject *obj)
{
    PyObject * l = PyLong_FromLong(((PyLongScalarObject*)obj)->obval);
    npy_hash_t x = PyObject_Hash(l);
    Py_DECREF(l);
    return x;
}
#endif

#line 2931
static npy_hash_t
longlong_arrtype_hash(PyObject *obj)
{
    PyObject * l = PyLong_FromLongLong(
                                 ((PyLongLongScalarObject*)obj)->obval);
    npy_hash_t x = PyObject_Hash(l);
    Py_DECREF(l);
    return x;
}

#line 2931
static npy_hash_t
ulonglong_arrtype_hash(PyObject *obj)
{
    PyObject * l = PyLong_FromUnsignedLongLong(
                                 ((PyULongLongScalarObject*)obj)->obval);
    npy_hash_t x = PyObject_Hash(l);
    Py_DECREF(l);
    return x;
}



#line 2947
#if NPY_SIZEOF_HASH_T==NPY_SIZEOF_DATETIME
static npy_hash_t
datetime_arrtype_hash(PyObject *obj)
{
    npy_hash_t x = (npy_hash_t)(((PyDatetimeScalarObject *)obj)->obval);
    if (x == -1) {
        x = -2;
    }
    return x;
}
#elif NPY_SIZEOF_LONGLONG==NPY_SIZEOF_DATETIME
static npy_hash_t
datetime_arrtype_hash(PyObject *obj)
{
    npy_hash_t y;
    npy_longlong x = (((PyDatetimeScalarObject *)obj)->obval);

    if ((x <= LONG_MAX)) {
        y = (npy_hash_t) x;
    }
    else {
        union Mask {
            long hashvals[2];
            npy_longlong v;
        } both;

        both.v = x;
        y = both.hashvals[0] + (1000003)*both.hashvals[1];
    }
    if (y == -1) {
        y = -2;
    }
    return y;
}
#endif

#line 2947
#if NPY_SIZEOF_HASH_T==NPY_SIZEOF_DATETIME
static npy_hash_t
timedelta_arrtype_hash(PyObject *obj)
{
    npy_hash_t x = (npy_hash_t)(((PyTimedeltaScalarObject *)obj)->obval);
    if (x == -1) {
        x = -2;
    }
    return x;
}
#elif NPY_SIZEOF_LONGLONG==NPY_SIZEOF_DATETIME
static npy_hash_t
timedelta_arrtype_hash(PyObject *obj)
{
    npy_hash_t y;
    npy_longlong x = (((PyTimedeltaScalarObject *)obj)->obval);

    if ((x <= LONG_MAX)) {
        y = (npy_hash_t) x;
    }
    else {
        union Mask {
            long hashvals[2];
            npy_longlong v;
        } both;

        both.v = x;
        y = both.hashvals[0] + (1000003)*both.hashvals[1];
    }
    if (y == -1) {
        y = -2;
    }
    return y;
}
#endif




/* Wrong thing to do for longdouble, but....*/

#line 2992
static npy_hash_t
float_arrtype_hash(PyObject *obj)
{
    return _Py_HashDouble((double) ((PyFloatScalarObject *)obj)->obval);
}

/* borrowed from complex_hash */
static npy_hash_t
cfloat_arrtype_hash(PyObject *obj)
{
    npy_hash_t hashreal, hashimag, combined;
    hashreal = _Py_HashDouble((double)
            (((PyCFloatScalarObject *)obj)->obval).real);

    if (hashreal == -1) {
        return -1;
    }
    hashimag = _Py_HashDouble((double)
            (((PyCFloatScalarObject *)obj)->obval).imag);
    if (hashimag == -1) {
        return -1;
    }
    combined = hashreal + 1000003 * hashimag;
    if (combined == -1) {
        combined = -2;
    }
    return combined;
}

#line 2992
static npy_hash_t
longdouble_arrtype_hash(PyObject *obj)
{
    return _Py_HashDouble((double) ((PyLongDoubleScalarObject *)obj)->obval);
}

/* borrowed from complex_hash */
static npy_hash_t
clongdouble_arrtype_hash(PyObject *obj)
{
    npy_hash_t hashreal, hashimag, combined;
    hashreal = _Py_HashDouble((double)
            (((PyCLongDoubleScalarObject *)obj)->obval).real);

    if (hashreal == -1) {
        return -1;
    }
    hashimag = _Py_HashDouble((double)
            (((PyCLongDoubleScalarObject *)obj)->obval).imag);
    if (hashimag == -1) {
        return -1;
    }
    combined = hashreal + 1000003 * hashimag;
    if (combined == -1) {
        combined = -2;
    }
    return combined;
}


static npy_hash_t
half_arrtype_hash(PyObject *obj)
{
    return _Py_HashDouble(npy_half_to_double(((PyHalfScalarObject *)obj)->obval));
}

static npy_hash_t
object_arrtype_hash(PyObject *obj)
{
    return PyObject_Hash(((PyObjectScalarObject *)obj)->obval);
}

/* we used to just hash the pointer */
/* now use tuplehash algorithm using voidtype_item to get the object
*/
static npy_hash_t
void_arrtype_hash(PyObject *obj)
{
    npy_hash_t x, y;
    Py_ssize_t len, n;
    PyVoidScalarObject *p;
    PyObject *element;
    npy_hash_t mult = 1000003L;
    x = 0x345678L;
    p = (PyVoidScalarObject *)obj;
    /* Cannot hash mutable void scalars */
    if (p->flags & NPY_ARRAY_WRITEABLE) {
       PyErr_SetString(PyExc_TypeError, "unhashable type: 'writeable void-scalar'");
       return -1;
    }
    len = voidtype_length(p);
    for (n=0; n < len; n++) {
        element = voidtype_item(p, n);
        y = PyObject_Hash(element);
        Py_DECREF(element);
        if (y == -1)
           return -1;
        x = (x ^ y) * mult;
        mult += (npy_hash_t)(82520L + len + len);
    }
    x += 97531L;
    if (x == -1)
        x = -2;
    return x;
}

/*object arrtype getattro and setattro */
static PyObject *
object_arrtype_getattro(PyObjectScalarObject *obj, PyObject *attr) {
    PyObject *res;

    /* first look in object and then hand off to generic type */

    res = PyObject_GenericGetAttr(obj->obval, attr);
    if (res) {
        return res;
    }
    PyErr_Clear();
    return  PyObject_GenericGetAttr((PyObject *)obj, attr);
}

static int
object_arrtype_setattro(PyObjectScalarObject *obj, PyObject *attr, PyObject *val) {
    int res;
    /* first look in object and then hand off to generic type */

    res = PyObject_GenericSetAttr(obj->obval, attr, val);
    if (res >= 0) {
        return res;
    }
    PyErr_Clear();
    return PyObject_GenericSetAttr((PyObject *)obj, attr, val);
}

static PyObject *
object_arrtype_concat(PyObjectScalarObject *self, PyObject *other)
{
    return PySequence_Concat(self->obval, other);
}

static Py_ssize_t
object_arrtype_length(PyObjectScalarObject *self)
{
    return PyObject_Length(self->obval);
}

static PyObject *
object_arrtype_repeat(PyObjectScalarObject *self, Py_ssize_t count)
{
    return PySequence_Repeat(self->obval, count);
}

static PyObject *
object_arrtype_subscript(PyObjectScalarObject *self, PyObject *key)
{
    return PyObject_GetItem(self->obval, key);
}

static int
object_arrtype_ass_subscript(PyObjectScalarObject *self, PyObject *key,
                             PyObject *value)
{
    return PyObject_SetItem(self->obval, key, value);
}

static int
object_arrtype_contains(PyObjectScalarObject *self, PyObject *ob)
{
    return PySequence_Contains(self->obval, ob);
}

static PyObject *
object_arrtype_inplace_concat(PyObjectScalarObject *self, PyObject *o)
{
    return PySequence_InPlaceConcat(self->obval, o);
}

static PyObject *
object_arrtype_inplace_repeat(PyObjectScalarObject *self, Py_ssize_t count)
{
    return PySequence_InPlaceRepeat(self->obval, count);
}

static PySequenceMethods object_arrtype_as_sequence = {
    (lenfunc)object_arrtype_length,              /*sq_length*/
    (binaryfunc)object_arrtype_concat,           /*sq_concat*/
    (ssizeargfunc)object_arrtype_repeat,         /*sq_repeat*/
    0,                                           /*sq_item*/
    0,                                           /*sq_slice*/
    0,                                           /* sq_ass_item */
    0,                                           /* sq_ass_slice */
    (objobjproc)object_arrtype_contains,         /* sq_contains */
    (binaryfunc)object_arrtype_inplace_concat,   /* sq_inplace_concat */
    (ssizeargfunc)object_arrtype_inplace_repeat, /* sq_inplace_repeat */
};

static PyMappingMethods object_arrtype_as_mapping = {
    (lenfunc)object_arrtype_length,
    (binaryfunc)object_arrtype_subscript,
    (objobjargproc)object_arrtype_ass_subscript,
};

#if !defined(NPY_PY3K)
static Py_ssize_t
object_arrtype_getsegcount(PyObjectScalarObject *self, Py_ssize_t *lenp)
{
    Py_ssize_t newlen;
    int cnt;
    PyBufferProcs *pb = Py_TYPE(self->obval)->tp_as_buffer;

    if (pb == NULL ||
            pb->bf_getsegcount == NULL ||
            (cnt = (*pb->bf_getsegcount)(self->obval, &newlen)) != 1) {
        return 0;
    }
    if (lenp) {
        *lenp = newlen;
    }
    return cnt;
}

static Py_ssize_t
object_arrtype_getreadbuf(PyObjectScalarObject *self, Py_ssize_t segment, void **ptrptr)
{
    PyBufferProcs *pb = Py_TYPE(self->obval)->tp_as_buffer;

    if (pb == NULL ||
            pb->bf_getreadbuffer == NULL ||
            pb->bf_getsegcount == NULL) {
        PyErr_SetString(PyExc_TypeError,
                "expected a readable buffer object");
        return -1;
    }
    return (*pb->bf_getreadbuffer)(self->obval, segment, ptrptr);
}

static Py_ssize_t
object_arrtype_getwritebuf(PyObjectScalarObject *self, Py_ssize_t segment, void **ptrptr)
{
    PyBufferProcs *pb = Py_TYPE(self->obval)->tp_as_buffer;

    if (pb == NULL ||
            pb->bf_getwritebuffer == NULL ||
            pb->bf_getsegcount == NULL) {
        PyErr_SetString(PyExc_TypeError,
                "expected a writeable buffer object");
        return -1;
    }
    return (*pb->bf_getwritebuffer)(self->obval, segment, ptrptr);
}

static Py_ssize_t
object_arrtype_getcharbuf(PyObjectScalarObject *self, Py_ssize_t segment,
                          constchar **ptrptr)
{
    PyBufferProcs *pb = Py_TYPE(self->obval)->tp_as_buffer;

    if (pb == NULL ||
            pb->bf_getcharbuffer == NULL ||
            pb->bf_getsegcount == NULL) {
        PyErr_SetString(PyExc_TypeError,
                "expected a character buffer object");
        return -1;
    }
    return (*pb->bf_getcharbuffer)(self->obval, segment, ptrptr);
}
#endif

static int
object_arrtype_getbuffer(PyObjectScalarObject *self, Py_buffer *view, int flags)
{
    PyBufferProcs *pb = Py_TYPE(self->obval)->tp_as_buffer;
    if (pb == NULL || pb->bf_getbuffer == NULL) {
        PyErr_SetString(PyExc_TypeError,
                        "expected a readable buffer object");
        return -1;
    }
    return (*pb->bf_getbuffer)(self->obval, view, flags);
}

static void
object_arrtype_releasebuffer(PyObjectScalarObject *self, Py_buffer *view)
{
    PyBufferProcs *pb = Py_TYPE(self->obval)->tp_as_buffer;
    if (pb == NULL) {
        PyErr_SetString(PyExc_TypeError,
                        "expected a readable buffer object");
        return;
    }
    if (pb->bf_releasebuffer != NULL) {
        (*pb->bf_releasebuffer)(self->obval, view);
    }
}

static PyBufferProcs object_arrtype_as_buffer = {
#if !defined(NPY_PY3K)
    (readbufferproc)object_arrtype_getreadbuf,
    (writebufferproc)object_arrtype_getwritebuf,
    (segcountproc)object_arrtype_getsegcount,
    (charbufferproc)object_arrtype_getcharbuf,
#endif
    (getbufferproc)object_arrtype_getbuffer,
    (releasebufferproc)object_arrtype_releasebuffer,
};

static PyObject *
object_arrtype_call(PyObjectScalarObject *obj, PyObject *args, PyObject *kwds)
{
    return PyObject_Call(obj->obval, args, kwds);
}

NPY_NO_EXPORT PyTypeObject PyObjectArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.object_",                            /* tp_name*/
    sizeof(PyObjectScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    (destructor)object_arrtype_dealloc,         /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    &object_arrtype_as_sequence,                /* tp_as_sequence */
    &object_arrtype_as_mapping,                 /* tp_as_mapping */
    0,                                          /* tp_hash */
    (ternaryfunc)object_arrtype_call,           /* tp_call */
    0,                                          /* tp_str */
    (getattrofunc)object_arrtype_getattro,      /* tp_getattro */
    (setattrofunc)object_arrtype_setattro,      /* tp_setattro */
    &object_arrtype_as_buffer,                  /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

static PyObject *
gen_arrtype_subscript(PyObject *self, PyObject *key)
{
    /*
     * Only [...], [...,<???>], [<???>, ...],
     * is allowed for indexing a scalar
     *
     * These return a new N-d array with a copy of
     * the data where N is the number of None's in <???>.
     */
    PyObject *res, *ret;
    int N;

    if (key == Py_Ellipsis || key == Py_None ||
            PyTuple_Check(key)) {
        res = PyArray_FromScalar(self, NULL);
    }
    else {
        PyErr_SetString(PyExc_IndexError,
                "invalid index to scalar variable.");
        return NULL;
    }
    if (key == Py_Ellipsis) {
        return res;
    }
    if (key == Py_None) {
        ret = add_new_axes_0d((PyArrayObject *)res, 1);
        Py_DECREF(res);
        return ret;
    }
    /* Must be a Tuple */
    N = count_new_axes_0d(key);
    if (N < 0) {
        Py_DECREF(res);
        return NULL;
    }
    ret = add_new_axes_0d((PyArrayObject *)res, N);
    Py_DECREF(res);
    return ret;
}


#define NAME_bool "bool"
#define NAME_void "void"
#if defined(NPY_PY3K)
#define NAME_string "bytes"
#define NAME_unicode "str"
#else
#define NAME_string "string"
#define NAME_unicode "unicode"
#endif

#line 3389
NPY_NO_EXPORT PyTypeObject PyBoolArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy." NAME_bool "_",                /* tp_name*/
    sizeof(PyBoolScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 3389
NPY_NO_EXPORT PyTypeObject PyStringArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy." NAME_string "_",                /* tp_name*/
    sizeof(PyStringScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 3389
NPY_NO_EXPORT PyTypeObject PyUnicodeArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy." NAME_unicode "_",                /* tp_name*/
    sizeof(PyUnicodeScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#line 3389
NPY_NO_EXPORT PyTypeObject PyVoidArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy." NAME_void "",                /* tp_name*/
    sizeof(PyVoidScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};


#undef NAME_bool
#undef NAME_void
#undef NAME_string
#undef NAME_unicode

#line 3461
#if NPY_BITSOF_CHAR == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_CHAR == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_CHAR == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_CHAR == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_CHAR == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_CHAR == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_CHAR == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_CHAR == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyByteArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.int" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyByteScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_SHORT == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_SHORT == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_SHORT == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_SHORT == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_SHORT == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_SHORT == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_SHORT == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_SHORT == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyShortArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.int" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyShortScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_INT == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_INT == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_INT == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_INT == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_INT == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_INT == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_INT == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_INT == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyIntArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.int" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyIntScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_LONG == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_LONG == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_LONG == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_LONG == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_LONG == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_LONG == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_LONG == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_LONG == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyLongArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.int" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyLongScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_LONGLONG == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_LONGLONG == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_LONGLONG == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_LONGLONG == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_LONGLONG == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_LONGLONG == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_LONGLONG == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_LONGLONG == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyLongLongArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.int" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyLongLongScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_CHAR == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_CHAR == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_CHAR == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_CHAR == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_CHAR == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_CHAR == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_CHAR == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_CHAR == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyUByteArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.uint" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyUByteScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_SHORT == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_SHORT == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_SHORT == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_SHORT == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_SHORT == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_SHORT == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_SHORT == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_SHORT == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyUShortArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.uint" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyUShortScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_INT == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_INT == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_INT == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_INT == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_INT == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_INT == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_INT == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_INT == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyUIntArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.uint" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyUIntScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_LONG == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_LONG == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_LONG == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_LONG == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_LONG == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_LONG == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_LONG == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_LONG == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyULongArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.uint" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyULongScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_LONGLONG == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_LONGLONG == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_LONGLONG == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_LONGLONG == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_LONGLONG == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_LONGLONG == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_LONGLONG == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_LONGLONG == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyULongLongArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.uint" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyULongLongScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_HALF == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_HALF == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_HALF == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_HALF == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_HALF == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_HALF == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_HALF == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_HALF == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyHalfArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.float" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyHalfScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_FLOAT == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_FLOAT == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_FLOAT == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_FLOAT == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_FLOAT == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_FLOAT == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_FLOAT == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_FLOAT == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyFloatArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.float" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyFloatScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_DOUBLE == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_DOUBLE == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_DOUBLE == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_DOUBLE == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_DOUBLE == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_DOUBLE == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_DOUBLE == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_DOUBLE == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyDoubleArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.float" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyDoubleScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_LONGDOUBLE == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_LONGDOUBLE == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_LONGDOUBLE == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_LONGDOUBLE == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_LONGDOUBLE == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_LONGDOUBLE == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_LONGDOUBLE == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_LONGDOUBLE == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyLongDoubleArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.float" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyLongDoubleScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_DATETIME == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_DATETIME == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_DATETIME == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_DATETIME == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_DATETIME == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_DATETIME == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_DATETIME == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_DATETIME == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyDatetimeArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.datetime" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyDatetimeScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE

#line 3461
#if NPY_BITSOF_TIMEDELTA == 8
#define _THIS_SIZE "8"
#elif NPY_BITSOF_TIMEDELTA == 16
#define _THIS_SIZE "16"
#elif NPY_BITSOF_TIMEDELTA == 32
#define _THIS_SIZE "32"
#elif NPY_BITSOF_TIMEDELTA == 64
#define _THIS_SIZE "64"
#elif NPY_BITSOF_TIMEDELTA == 80
#define _THIS_SIZE "80"
#elif NPY_BITSOF_TIMEDELTA == 96
#define _THIS_SIZE "96"
#elif NPY_BITSOF_TIMEDELTA == 128
#define _THIS_SIZE "128"
#elif NPY_BITSOF_TIMEDELTA == 256
#define _THIS_SIZE "256"
#endif
NPY_NO_EXPORT PyTypeObject PyTimedeltaArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(NULL, 0)
#else
    PyObject_HEAD_INIT(NULL)
    0,                                          /* ob_size */
#endif
    "numpy.timedelta" _THIS_SIZE,                  /* tp_name*/
    sizeof(PyTimedeltaScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize */
    0,                                          /* tp_dealloc */
    0,                                          /* tp_print */
    0,                                          /* tp_getattr */
    0,                                          /* tp_setattr */
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr */
    0,                                          /* tp_as_number */
    0,                                          /* tp_as_sequence */
    0,                                          /* tp_as_mapping */
    0,                                          /* tp_hash */
    0,                                          /* tp_call */
    0,                                          /* tp_str */
    0,                                          /* tp_getattro */
    0,                                          /* tp_setattro */
    0,                                          /* tp_as_buffer */
    0,                                          /* tp_flags */
    0,                                          /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};

#undef _THIS_SIZE



static PyMappingMethods gentype_as_mapping = {
    NULL,
    (binaryfunc)gen_arrtype_subscript,
    NULL
};


#line 3553
#if NPY_BITSOF_FLOAT == 16
#define _THIS_SIZE2 "16"
#define _THIS_SIZE1 "32"
#elif NPY_BITSOF_FLOAT == 32
#define _THIS_SIZE2 "32"
#define _THIS_SIZE1 "64"
#elif NPY_BITSOF_FLOAT == 64
#define _THIS_SIZE2 "64"
#define _THIS_SIZE1 "128"
#elif NPY_BITSOF_FLOAT == 80
#define _THIS_SIZE2 "80"
#define _THIS_SIZE1 "160"
#elif NPY_BITSOF_FLOAT == 96
#define _THIS_SIZE2 "96"
#define _THIS_SIZE1 "192"
#elif NPY_BITSOF_FLOAT == 128
#define _THIS_SIZE2 "128"
#define _THIS_SIZE1 "256"
#elif NPY_BITSOF_FLOAT == 256
#define _THIS_SIZE2 "256"
#define _THIS_SIZE1 "512"
#endif

#define _THIS_DOC "Composed of two " _THIS_SIZE2 " bit floats"

NPY_NO_EXPORT PyTypeObject PyCFloatArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(0, 0)
#else
    PyObject_HEAD_INIT(0)
    0,                                          /* ob_size */
#endif
    "numpy.complex" _THIS_SIZE1,                 /* tp_name*/
    sizeof(PyCFloatScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize*/
    0,                                          /* tp_dealloc*/
    0,                                          /* tp_print*/
    0,                                          /* tp_getattr*/
    0,                                          /* tp_setattr*/
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr*/
    0,                                          /* tp_as_number*/
    0,                                          /* tp_as_sequence*/
    0,                                          /* tp_as_mapping*/
    0,                                          /* tp_hash */
    0,                                          /* tp_call*/
    0,                                          /* tp_str*/
    0,                                          /* tp_getattro*/
    0,                                          /* tp_setattro*/
    0,                                          /* tp_as_buffer*/
    Py_TPFLAGS_DEFAULT,                         /* tp_flags*/
    _THIS_DOC,                                  /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};
#undef _THIS_SIZE1
#undef _THIS_SIZE2
#undef _THIS_DOC


#line 3553
#if NPY_BITSOF_DOUBLE == 16
#define _THIS_SIZE2 "16"
#define _THIS_SIZE1 "32"
#elif NPY_BITSOF_DOUBLE == 32
#define _THIS_SIZE2 "32"
#define _THIS_SIZE1 "64"
#elif NPY_BITSOF_DOUBLE == 64
#define _THIS_SIZE2 "64"
#define _THIS_SIZE1 "128"
#elif NPY_BITSOF_DOUBLE == 80
#define _THIS_SIZE2 "80"
#define _THIS_SIZE1 "160"
#elif NPY_BITSOF_DOUBLE == 96
#define _THIS_SIZE2 "96"
#define _THIS_SIZE1 "192"
#elif NPY_BITSOF_DOUBLE == 128
#define _THIS_SIZE2 "128"
#define _THIS_SIZE1 "256"
#elif NPY_BITSOF_DOUBLE == 256
#define _THIS_SIZE2 "256"
#define _THIS_SIZE1 "512"
#endif

#define _THIS_DOC "Composed of two " _THIS_SIZE2 " bit floats"

NPY_NO_EXPORT PyTypeObject PyCDoubleArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(0, 0)
#else
    PyObject_HEAD_INIT(0)
    0,                                          /* ob_size */
#endif
    "numpy.complex" _THIS_SIZE1,                 /* tp_name*/
    sizeof(PyCDoubleScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize*/
    0,                                          /* tp_dealloc*/
    0,                                          /* tp_print*/
    0,                                          /* tp_getattr*/
    0,                                          /* tp_setattr*/
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr*/
    0,                                          /* tp_as_number*/
    0,                                          /* tp_as_sequence*/
    0,                                          /* tp_as_mapping*/
    0,                                          /* tp_hash */
    0,                                          /* tp_call*/
    0,                                          /* tp_str*/
    0,                                          /* tp_getattro*/
    0,                                          /* tp_setattro*/
    0,                                          /* tp_as_buffer*/
    Py_TPFLAGS_DEFAULT,                         /* tp_flags*/
    _THIS_DOC,                                  /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};
#undef _THIS_SIZE1
#undef _THIS_SIZE2
#undef _THIS_DOC


#line 3553
#if NPY_BITSOF_LONGDOUBLE == 16
#define _THIS_SIZE2 "16"
#define _THIS_SIZE1 "32"
#elif NPY_BITSOF_LONGDOUBLE == 32
#define _THIS_SIZE2 "32"
#define _THIS_SIZE1 "64"
#elif NPY_BITSOF_LONGDOUBLE == 64
#define _THIS_SIZE2 "64"
#define _THIS_SIZE1 "128"
#elif NPY_BITSOF_LONGDOUBLE == 80
#define _THIS_SIZE2 "80"
#define _THIS_SIZE1 "160"
#elif NPY_BITSOF_LONGDOUBLE == 96
#define _THIS_SIZE2 "96"
#define _THIS_SIZE1 "192"
#elif NPY_BITSOF_LONGDOUBLE == 128
#define _THIS_SIZE2 "128"
#define _THIS_SIZE1 "256"
#elif NPY_BITSOF_LONGDOUBLE == 256
#define _THIS_SIZE2 "256"
#define _THIS_SIZE1 "512"
#endif

#define _THIS_DOC "Composed of two " _THIS_SIZE2 " bit floats"

NPY_NO_EXPORT PyTypeObject PyCLongDoubleArrType_Type = {
#if defined(NPY_PY3K)
    PyVarObject_HEAD_INIT(0, 0)
#else
    PyObject_HEAD_INIT(0)
    0,                                          /* ob_size */
#endif
    "numpy.complex" _THIS_SIZE1,                 /* tp_name*/
    sizeof(PyCLongDoubleScalarObject),               /* tp_basicsize*/
    0,                                          /* tp_itemsize*/
    0,                                          /* tp_dealloc*/
    0,                                          /* tp_print*/
    0,                                          /* tp_getattr*/
    0,                                          /* tp_setattr*/
#if defined(NPY_PY3K)
    0,                                          /* tp_reserved */
#else
    0,                                          /* tp_compare */
#endif
    0,                                          /* tp_repr*/
    0,                                          /* tp_as_number*/
    0,                                          /* tp_as_sequence*/
    0,                                          /* tp_as_mapping*/
    0,                                          /* tp_hash */
    0,                                          /* tp_call*/
    0,                                          /* tp_str*/
    0,                                          /* tp_getattro*/
    0,                                          /* tp_setattro*/
    0,                                          /* tp_as_buffer*/
    Py_TPFLAGS_DEFAULT,                         /* tp_flags*/
    _THIS_DOC,                                  /* tp_doc */
    0,                                          /* tp_traverse */
    0,                                          /* tp_clear */
    0,                                          /* tp_richcompare */
    0,                                          /* tp_weaklistoffset */
    0,                                          /* tp_iter */
    0,                                          /* tp_iternext */
    0,                                          /* tp_methods */
    0,                                          /* tp_members */
    0,                                          /* tp_getset */
    0,                                          /* tp_base */
    0,                                          /* tp_dict */
    0,                                          /* tp_descr_get */
    0,                                          /* tp_descr_set */
    0,                                          /* tp_dictoffset */
    0,                                          /* tp_init */
    0,                                          /* tp_alloc */
    0,                                          /* tp_new */
    0,                                          /* tp_free */
    0,                                          /* tp_is_gc */
    0,                                          /* tp_bases */
    0,                                          /* tp_mro */
    0,                                          /* tp_cache */
    0,                                          /* tp_subclasses */
    0,                                          /* tp_weaklist */
    0,                                          /* tp_del */
    0,                                          /* tp_version_tag */
};
#undef _THIS_SIZE1
#undef _THIS_SIZE2
#undef _THIS_DOC



#ifdef NPY_ENABLE_SEPARATE_COMPILATION
/*
 * This table maps the built-in type numbers to their scalar
 * type numbers.  Note that signed integers are mapped to INTNEG_SCALAR,
 * which is different than what PyArray_ScalarKind returns.
 */
NPY_NO_EXPORT signed char
_npy_scalar_kinds_table[NPY_NTYPES];

/*
 * This table maps a scalar kind (excluding NPY_NOSCALAR)
 * to the smallest type number of that kind.
 */
NPY_NO_EXPORT signed char
_npy_smallest_type_of_kind_table[NPY_NSCALARKINDS];

/*
 * This table gives the type of the same kind, but next in the sequence
 * of sizes.
 */
NPY_NO_EXPORT signed char
_npy_next_larger_type_table[NPY_NTYPES];

/*
 * This table describes safe casting for small type numbers,
 * and is used by PyArray_CanCastSafely.
 */
NPY_NO_EXPORT unsigned char
_npy_can_cast_safely_table[NPY_NTYPES][NPY_NTYPES];

/*
 * This table gives the smallest-size and smallest-kind type to which
 * the input types may be safely cast, according to _npy_can_cast_safely.
 */
NPY_NO_EXPORT signed char
_npy_type_promotion_table[NPY_NTYPES][NPY_NTYPES];
#endif

NPY_NO_EXPORT void
initialize_casting_tables(void)
{
    int i, j;

    _npy_smallest_type_of_kind_table[NPY_BOOL_SCALAR] = NPY_BOOL;
    _npy_smallest_type_of_kind_table[NPY_INTPOS_SCALAR] = NPY_UBYTE;
    _npy_smallest_type_of_kind_table[NPY_INTNEG_SCALAR] = NPY_BYTE;
    _npy_smallest_type_of_kind_table[NPY_FLOAT_SCALAR] = NPY_HALF;
    _npy_smallest_type_of_kind_table[NPY_COMPLEX_SCALAR] = NPY_CFLOAT;
    _npy_smallest_type_of_kind_table[NPY_OBJECT_SCALAR] = NPY_OBJECT;

    /* Default for built-in types is object scalar */
    memset(_npy_scalar_kinds_table, NPY_OBJECT_SCALAR,
                                        sizeof(_npy_scalar_kinds_table));
    /* Default for next largest type is -1, signalling no bigger */
    memset(_npy_next_larger_type_table, -1,
                                        sizeof(_npy_next_larger_type_table));

    /* Compile-time loop of scalar kinds */

    #line 3717

    _npy_scalar_kinds_table[NPY_BOOL] = NPY_BOOL_SCALAR;
    _npy_next_larger_type_table[NPY_BOOL] = -1;

    
#line 3717

    _npy_scalar_kinds_table[NPY_BYTE] = NPY_INTNEG_SCALAR;
    _npy_next_larger_type_table[NPY_BYTE] = NPY_SHORT;

    
#line 3717

    _npy_scalar_kinds_table[NPY_UBYTE] = NPY_INTPOS_SCALAR;
    _npy_next_larger_type_table[NPY_UBYTE] = NPY_USHORT;

    
#line 3717

    _npy_scalar_kinds_table[NPY_SHORT] = NPY_INTNEG_SCALAR;
    _npy_next_larger_type_table[NPY_SHORT] = NPY_INT;

    
#line 3717

    _npy_scalar_kinds_table[NPY_USHORT] = NPY_INTPOS_SCALAR;
    _npy_next_larger_type_table[NPY_USHORT] = NPY_UINT;

    
#line 3717

    _npy_scalar_kinds_table[NPY_INT] = NPY_INTNEG_SCALAR;
    _npy_next_larger_type_table[NPY_INT] = NPY_LONG;

    
#line 3717

    _npy_scalar_kinds_table[NPY_UINT] = NPY_INTPOS_SCALAR;
    _npy_next_larger_type_table[NPY_UINT] = NPY_ULONG;

    
#line 3717

    _npy_scalar_kinds_table[NPY_LONG] = NPY_INTNEG_SCALAR;
    _npy_next_larger_type_table[NPY_LONG] = NPY_LONGLONG;

    
#line 3717

    _npy_scalar_kinds_table[NPY_ULONG] = NPY_INTPOS_SCALAR;
    _npy_next_larger_type_table[NPY_ULONG] = NPY_ULONGLONG;

    
#line 3717

    _npy_scalar_kinds_table[NPY_LONGLONG] = NPY_INTNEG_SCALAR;
    _npy_next_larger_type_table[NPY_LONGLONG] = -1;

    
#line 3717

    _npy_scalar_kinds_table[NPY_ULONGLONG] = NPY_INTPOS_SCALAR;
    _npy_next_larger_type_table[NPY_ULONGLONG] = -1;

    
#line 3717

    _npy_scalar_kinds_table[NPY_HALF] = NPY_FLOAT_SCALAR;
    _npy_next_larger_type_table[NPY_HALF] = NPY_FLOAT;

    
#line 3717

    _npy_scalar_kinds_table[NPY_FLOAT] = NPY_FLOAT_SCALAR;
    _npy_next_larger_type_table[NPY_FLOAT] = NPY_DOUBLE;

    
#line 3717

    _npy_scalar_kinds_table[NPY_DOUBLE] = NPY_FLOAT_SCALAR;
    _npy_next_larger_type_table[NPY_DOUBLE] = NPY_LONGDOUBLE;

    
#line 3717

    _npy_scalar_kinds_table[NPY_LONGDOUBLE] = NPY_FLOAT_SCALAR;
    _npy_next_larger_type_table[NPY_LONGDOUBLE] = -1;

    
#line 3717

    _npy_scalar_kinds_table[NPY_CFLOAT] = NPY_COMPLEX_SCALAR;
    _npy_next_larger_type_table[NPY_CFLOAT] = NPY_CDOUBLE;

    
#line 3717

    _npy_scalar_kinds_table[NPY_CDOUBLE] = NPY_COMPLEX_SCALAR;
    _npy_next_larger_type_table[NPY_CDOUBLE] = NPY_CLONGDOUBLE;

    
#line 3717

    _npy_scalar_kinds_table[NPY_CLONGDOUBLE] = NPY_COMPLEX_SCALAR;
    _npy_next_larger_type_table[NPY_CLONGDOUBLE] = -1;

    

    memset(_npy_can_cast_safely_table, 0, sizeof(_npy_can_cast_safely_table));

    for (i = 0; i < NPY_NTYPES; ++i) {
        /* Identity */
        _npy_can_cast_safely_table[i][i] = 1;
        if (i != NPY_DATETIME) {
            /*
             * Bool -> <Anything> except datetime (since
             *                    it conceptually has no zero)
             */
            _npy_can_cast_safely_table[NPY_BOOL][i] = 1;
        }
        /* <Anything> -> Object */
        _npy_can_cast_safely_table[i][NPY_OBJECT] = 1;
        /* <Anything> -> Void */
        _npy_can_cast_safely_table[i][NPY_VOID] = 1;
    }

    _npy_can_cast_safely_table[NPY_STRING][NPY_UNICODE] = 1;
    _npy_can_cast_safely_table[NPY_BOOL][NPY_TIMEDELTA] = 1;

#ifndef NPY_SIZEOF_BYTE
#define NPY_SIZEOF_BYTE 1
#endif

    /* Compile-time loop of casting rules */

    #line 3772

#define _FROM_BSIZE NPY_SIZEOF_BYTE
#define _FROM_NUM   (NPY_BYTE)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 1 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_BYTE
#define _FROM_NUM   (NPY_UBYTE)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 1
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_SHORT
#define _FROM_NUM   (NPY_SHORT)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 1 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_SHORT
#define _FROM_NUM   (NPY_USHORT)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 1
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_INT
#define _FROM_NUM   (NPY_INT)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 1 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_INT
#define _FROM_NUM   (NPY_UINT)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 1
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_LONG
#define _FROM_NUM   (NPY_LONG)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 1 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_LONG
#define _FROM_NUM   (NPY_ULONG)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 1
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_LONGLONG
#define _FROM_NUM   (NPY_LONGLONG)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 1 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_LONGLONG
#define _FROM_NUM   (NPY_ULONGLONG)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 1
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_HALF
#define _FROM_NUM   (NPY_HALF)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_FLOAT
#define _FROM_NUM   (NPY_FLOAT)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_DOUBLE
#define _FROM_NUM   (NPY_DOUBLE)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _FROM_NUM   (NPY_LONGDOUBLE)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_FLOAT
#define _FROM_NUM   (NPY_CFLOAT)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_DOUBLE
#define _FROM_NUM   (NPY_CDOUBLE)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE


#line 3772

#define _FROM_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _FROM_NUM   (NPY_CLONGDOUBLE)

    _npy_can_cast_safely_table[_FROM_NUM][NPY_STRING] = 1;
    _npy_can_cast_safely_table[_FROM_NUM][NPY_UNICODE] = 1;

    /* Allow casts from any integer to the TIMEDELTA type */
#if 0 || 0
    _npy_can_cast_safely_table[_FROM_NUM][NPY_TIMEDELTA] = 1;
#endif

    #line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_BYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_BYTE
#define _TO_NUM   (NPY_UBYTE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_SHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_SHORT
#define _TO_NUM   (NPY_USHORT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_INT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_INT
#define _TO_NUM   (NPY_UINT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_LONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONG
#define _TO_NUM   (NPY_ULONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_LONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 1 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGLONG
#define _TO_NUM   (NPY_ULONGLONG)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_HALF
#define _TO_NUM   (NPY_HALF)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_FLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_DOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_LONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_FLOAT
#define _TO_NUM   (NPY_CFLOAT)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_DOUBLE
#define _TO_NUM   (NPY_CDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE


#line 3806
#define _TO_BSIZE NPY_SIZEOF_LONGDOUBLE
#define _TO_NUM   (NPY_CLONGDOUBLE)

    /*
     * NOTE: _FROM_BSIZE and _TO_BSIZE are the sizes of the "base type"
     *       which is the same as the size of the type except for
     *       complex, where it is the size of the real type.
     */

#if 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* int -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 0

#  if 0 && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> int */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> uint */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 0 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE < 8) && (_TO_BSIZE > _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_FROM_BSIZE >= 8) && (_TO_BSIZE >= _FROM_BSIZE)
    /* uint -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif


#elif 0

#  if 0 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> float */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  elif 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* float -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#elif 1

#  if 1 && (_TO_BSIZE >= _FROM_BSIZE)
    /* complex -> complex */
    _npy_can_cast_safely_table[_FROM_NUM][_TO_NUM] = 1;
#  endif

#endif

#undef _TO_NUM
#undef _TO_BSIZE



#undef _FROM_NUM
#undef _FROM_BSIZE



    /*
     * Now that the _can_cast_safely table is finished, we can
     * use it to build the _type_promotion table
     */
    for (i = 0; i < NPY_NTYPES; ++i) {
        _npy_type_promotion_table[i][i] = i;
        /* Don't let number promote to string/unicode/void/datetime/timedelta */
        if (i == NPY_STRING || i == NPY_UNICODE || i == NPY_VOID ||
                i == NPY_DATETIME || i == NPY_TIMEDELTA) {
            /* Promoting these types requires examining their contents */
            _npy_type_promotion_table[i][i] = -1;
            for (j = i + 1; j < NPY_NTYPES; ++j) {
                _npy_type_promotion_table[i][j] = -1;
                _npy_type_promotion_table[j][i] = -1;
            }
            /* Except they can convert to OBJECT */
            _npy_type_promotion_table[i][NPY_OBJECT] = NPY_OBJECT;
            _npy_type_promotion_table[NPY_OBJECT][i] = NPY_OBJECT;
        }
        else {
            for (j = i + 1; j < NPY_NTYPES; ++j) {
                /* Don't let number promote to string/unicode/void */
                if (j == NPY_STRING || j == NPY_UNICODE || j == NPY_VOID) {
                    _npy_type_promotion_table[i][j] = -1;
                    _npy_type_promotion_table[j][i] = -1;
                }
                else if (_npy_can_cast_safely_table[i][j]) {
                    _npy_type_promotion_table[i][j] = j;
                    _npy_type_promotion_table[j][i] = j;
                }
                else if (_npy_can_cast_safely_table[j][i]) {
                    _npy_type_promotion_table[i][j] = i;
                    _npy_type_promotion_table[j][i] = i;
                }
                else {
                    int k, iskind, jskind, skind;
                    iskind = _npy_scalar_kinds_table[i];
                    jskind = _npy_scalar_kinds_table[j];
                    /* If there's no kind (void/string/etc) */
                    if (iskind == NPY_NOSCALAR || jskind == NPY_NOSCALAR) {
                        k = -1;
                    }
                    else {
                        /* Start with the type of larger kind */
                        if (iskind > jskind) {
                            skind = iskind;
                            k = i;
                        }
                        else {
                            skind = jskind;
                            k = j;
                        }
                        for (;;) {
                            /* Try the next larger type of this kind */
                            k = _npy_next_larger_type_table[k];

                            /* If there is no larger, try a larger kind */
                            if (k < 0) {
                                ++skind;
                                /* Use -1 to signal no promoted type found */
                                if (skind < NPY_NSCALARKINDS) {
                                    k = _npy_smallest_type_of_kind_table[skind];
                                }
                                else {
                                    k = -1;
                                    break;
                                }
                            }

                            if (_npy_can_cast_safely_table[i][k] &&
                                            _npy_can_cast_safely_table[j][k]) {
                                break;
                            }
                        }
                    }
                    _npy_type_promotion_table[i][j] = k;
                    _npy_type_promotion_table[j][i] = k;
                }
            }
        }
    }
}


static PyNumberMethods longdoubletype_as_number;
static PyNumberMethods clongdoubletype_as_number;


NPY_NO_EXPORT void
initialize_numeric_types(void)
{
    PyGenericArrType_Type.tp_dealloc = (destructor)gentype_dealloc;
    PyGenericArrType_Type.tp_as_number = &gentype_as_number;
    PyGenericArrType_Type.tp_as_buffer = &gentype_as_buffer;
    PyGenericArrType_Type.tp_as_mapping = &gentype_as_mapping;
    PyGenericArrType_Type.tp_flags = BASEFLAGS;
    PyGenericArrType_Type.tp_methods = gentype_methods;
    PyGenericArrType_Type.tp_getset = gentype_getsets;
    PyGenericArrType_Type.tp_new = NULL;
    PyGenericArrType_Type.tp_alloc = gentype_alloc;
    PyGenericArrType_Type.tp_free = PyArray_free;
    PyGenericArrType_Type.tp_repr = gentype_repr;
    PyGenericArrType_Type.tp_str = gentype_str;
    PyGenericArrType_Type.tp_richcompare = gentype_richcompare;

    PyBoolArrType_Type.tp_as_number = &bool_arrtype_as_number;
    /*
     * need to add dummy versions with filled-in nb_index
     * in-order for PyType_Ready to fill in .__index__() method
     */

    #line 4003
    PyByteArrType_Type.tp_as_number = &byte_arrtype_as_number;
    PyByteArrType_Type.tp_as_number->nb_index = (unaryfunc)byte_index;

    
#line 4003
    PyShortArrType_Type.tp_as_number = &short_arrtype_as_number;
    PyShortArrType_Type.tp_as_number->nb_index = (unaryfunc)short_index;

    
#line 4003
    PyIntArrType_Type.tp_as_number = &int_arrtype_as_number;
    PyIntArrType_Type.tp_as_number->nb_index = (unaryfunc)int_index;

    
#line 4003
    PyLongArrType_Type.tp_as_number = &long_arrtype_as_number;
    PyLongArrType_Type.tp_as_number->nb_index = (unaryfunc)long_index;

    
#line 4003
    PyLongLongArrType_Type.tp_as_number = &longlong_arrtype_as_number;
    PyLongLongArrType_Type.tp_as_number->nb_index = (unaryfunc)longlong_index;

    
#line 4003
    PyUByteArrType_Type.tp_as_number = &ubyte_arrtype_as_number;
    PyUByteArrType_Type.tp_as_number->nb_index = (unaryfunc)ubyte_index;

    
#line 4003
    PyUShortArrType_Type.tp_as_number = &ushort_arrtype_as_number;
    PyUShortArrType_Type.tp_as_number->nb_index = (unaryfunc)ushort_index;

    
#line 4003
    PyUIntArrType_Type.tp_as_number = &uint_arrtype_as_number;
    PyUIntArrType_Type.tp_as_number->nb_index = (unaryfunc)uint_index;

    
#line 4003
    PyULongArrType_Type.tp_as_number = &ulong_arrtype_as_number;
    PyULongArrType_Type.tp_as_number->nb_index = (unaryfunc)ulong_index;

    
#line 4003
    PyULongLongArrType_Type.tp_as_number = &ulonglong_arrtype_as_number;
    PyULongLongArrType_Type.tp_as_number->nb_index = (unaryfunc)ulonglong_index;

    
    PyBoolArrType_Type.tp_as_number->nb_index = (unaryfunc)bool_index;

    PyStringArrType_Type.tp_alloc = NULL;
    PyStringArrType_Type.tp_free = NULL;

    PyStringArrType_Type.tp_repr = stringtype_repr;
    PyStringArrType_Type.tp_str = stringtype_str;

    PyUnicodeArrType_Type.tp_repr = unicodetype_repr;
    PyUnicodeArrType_Type.tp_str = unicodetype_str;

    PyVoidArrType_Type.tp_methods = voidtype_methods;
    PyVoidArrType_Type.tp_getset = voidtype_getsets;
    PyVoidArrType_Type.tp_as_mapping = &voidtype_as_mapping;
    PyVoidArrType_Type.tp_as_sequence = &voidtype_as_sequence;

    #line 4027

    PyNumberArrType_Type.tp_flags = BASEFLAGS;

    
#line 4027

    PyIntegerArrType_Type.tp_flags = BASEFLAGS;

    
#line 4027

    PySignedIntegerArrType_Type.tp_flags = BASEFLAGS;

    
#line 4027

    PyUnsignedIntegerArrType_Type.tp_flags = BASEFLAGS;

    
#line 4027

    PyInexactArrType_Type.tp_flags = BASEFLAGS;

    
#line 4027

    PyFloatingArrType_Type.tp_flags = BASEFLAGS;

    
#line 4027

    PyComplexFloatingArrType_Type.tp_flags = BASEFLAGS;

    
#line 4027

    PyFlexibleArrType_Type.tp_flags = BASEFLAGS;

    
#line 4027

    PyCharacterArrType_Type.tp_flags = BASEFLAGS;

    

    #line 4042

    PyBoolArrType_Type.tp_flags = BASEFLAGS;
    PyBoolArrType_Type.tp_new = bool_arrtype_new;
    PyBoolArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyByteArrType_Type.tp_flags = BASEFLAGS;
    PyByteArrType_Type.tp_new = byte_arrtype_new;
    PyByteArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyShortArrType_Type.tp_flags = BASEFLAGS;
    PyShortArrType_Type.tp_new = short_arrtype_new;
    PyShortArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyIntArrType_Type.tp_flags = BASEFLAGS;
    PyIntArrType_Type.tp_new = int_arrtype_new;
    PyIntArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyLongArrType_Type.tp_flags = BASEFLAGS;
    PyLongArrType_Type.tp_new = long_arrtype_new;
    PyLongArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyLongLongArrType_Type.tp_flags = BASEFLAGS;
    PyLongLongArrType_Type.tp_new = longlong_arrtype_new;
    PyLongLongArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyUByteArrType_Type.tp_flags = BASEFLAGS;
    PyUByteArrType_Type.tp_new = ubyte_arrtype_new;
    PyUByteArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyUShortArrType_Type.tp_flags = BASEFLAGS;
    PyUShortArrType_Type.tp_new = ushort_arrtype_new;
    PyUShortArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyUIntArrType_Type.tp_flags = BASEFLAGS;
    PyUIntArrType_Type.tp_new = uint_arrtype_new;
    PyUIntArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyULongArrType_Type.tp_flags = BASEFLAGS;
    PyULongArrType_Type.tp_new = ulong_arrtype_new;
    PyULongArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyULongLongArrType_Type.tp_flags = BASEFLAGS;
    PyULongLongArrType_Type.tp_new = ulonglong_arrtype_new;
    PyULongLongArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyHalfArrType_Type.tp_flags = BASEFLAGS;
    PyHalfArrType_Type.tp_new = half_arrtype_new;
    PyHalfArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyFloatArrType_Type.tp_flags = BASEFLAGS;
    PyFloatArrType_Type.tp_new = float_arrtype_new;
    PyFloatArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyDoubleArrType_Type.tp_flags = BASEFLAGS;
    PyDoubleArrType_Type.tp_new = double_arrtype_new;
    PyDoubleArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyLongDoubleArrType_Type.tp_flags = BASEFLAGS;
    PyLongDoubleArrType_Type.tp_new = longdouble_arrtype_new;
    PyLongDoubleArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyCFloatArrType_Type.tp_flags = BASEFLAGS;
    PyCFloatArrType_Type.tp_new = cfloat_arrtype_new;
    PyCFloatArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyCDoubleArrType_Type.tp_flags = BASEFLAGS;
    PyCDoubleArrType_Type.tp_new = cdouble_arrtype_new;
    PyCDoubleArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyCLongDoubleArrType_Type.tp_flags = BASEFLAGS;
    PyCLongDoubleArrType_Type.tp_new = clongdouble_arrtype_new;
    PyCLongDoubleArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyStringArrType_Type.tp_flags = BASEFLAGS;
    PyStringArrType_Type.tp_new = string_arrtype_new;
    PyStringArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyUnicodeArrType_Type.tp_flags = BASEFLAGS;
    PyUnicodeArrType_Type.tp_new = unicode_arrtype_new;
    PyUnicodeArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyVoidArrType_Type.tp_flags = BASEFLAGS;
    PyVoidArrType_Type.tp_new = void_arrtype_new;
    PyVoidArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyObjectArrType_Type.tp_flags = BASEFLAGS;
    PyObjectArrType_Type.tp_new = object_arrtype_new;
    PyObjectArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyDatetimeArrType_Type.tp_flags = BASEFLAGS;
    PyDatetimeArrType_Type.tp_new = datetime_arrtype_new;
    PyDatetimeArrType_Type.tp_richcompare = gentype_richcompare;

    
#line 4042

    PyTimedeltaArrType_Type.tp_flags = BASEFLAGS;
    PyTimedeltaArrType_Type.tp_new = timedelta_arrtype_new;
    PyTimedeltaArrType_Type.tp_richcompare = gentype_richcompare;

    

    #line 4057

    PyBoolArrType_Type.tp_hash = bool_arrtype_hash;

    
#line 4057

    PyByteArrType_Type.tp_hash = byte_arrtype_hash;

    
#line 4057

    PyShortArrType_Type.tp_hash = short_arrtype_hash;

    
#line 4057

    PyUByteArrType_Type.tp_hash = ubyte_arrtype_hash;

    
#line 4057

    PyUShortArrType_Type.tp_hash = ushort_arrtype_hash;

    
#line 4057

    PyUIntArrType_Type.tp_hash = uint_arrtype_hash;

    
#line 4057

    PyULongArrType_Type.tp_hash = ulong_arrtype_hash;

    
#line 4057

    PyULongLongArrType_Type.tp_hash = ulonglong_arrtype_hash;

    
#line 4057

    PyHalfArrType_Type.tp_hash = half_arrtype_hash;

    
#line 4057

    PyFloatArrType_Type.tp_hash = float_arrtype_hash;

    
#line 4057

    PyLongDoubleArrType_Type.tp_hash = longdouble_arrtype_hash;

    
#line 4057

    PyCFloatArrType_Type.tp_hash = cfloat_arrtype_hash;

    
#line 4057

    PyCLongDoubleArrType_Type.tp_hash = clongdouble_arrtype_hash;

    
#line 4057

    PyVoidArrType_Type.tp_hash = void_arrtype_hash;

    
#line 4057

    PyObjectArrType_Type.tp_hash = object_arrtype_hash;

    
#line 4057

    PyDatetimeArrType_Type.tp_hash = datetime_arrtype_hash;

    
#line 4057

    PyTimedeltaArrType_Type.tp_hash = timedelta_arrtype_hash;

    

    #line 4066

    PyCFloatArrType_Type.tp_methods = cfloattype_methods;

    
#line 4066

    PyCLongDoubleArrType_Type.tp_methods = clongdoubletype_methods;

    

#if (NPY_SIZEOF_INT != NPY_SIZEOF_LONG) || defined(NPY_PY3K)
    /* We won't be inheriting from Python Int type. */
    PyIntArrType_Type.tp_hash = int_arrtype_hash;
#endif

#if defined(NPY_PY3K)
    /* We won't be inheriting from Python Int type. */
    PyLongArrType_Type.tp_hash = long_arrtype_hash;
#endif

#if (NPY_SIZEOF_LONG != NPY_SIZEOF_LONGLONG) || defined(NPY_PY3K)
    /* We won't be inheriting from Python Int type. */
    PyLongLongArrType_Type.tp_hash = longlong_arrtype_hash;
#endif

    #line 4089

    PyHalfArrType_Type.tp_repr = halftype_repr;

    PyFloatArrType_Type.tp_repr = floattype_repr;
    PyCFloatArrType_Type.tp_repr = cfloattype_repr;

    PyDoubleArrType_Type.tp_repr = doubletype_repr;
    PyCDoubleArrType_Type.tp_repr  = cdoubletype_repr;

    PyDatetimeArrType_Type.tp_repr = datetimetype_repr;
    PyTimedeltaArrType_Type.tp_repr = timedeltatype_repr;

    
#line 4089

    PyHalfArrType_Type.tp_str = halftype_str;

    PyFloatArrType_Type.tp_str = floattype_str;
    PyCFloatArrType_Type.tp_str = cfloattype_str;

    PyDoubleArrType_Type.tp_str = doubletype_str;
    PyCDoubleArrType_Type.tp_str  = cdoubletype_str;

    PyDatetimeArrType_Type.tp_str = datetimetype_str;
    PyTimedeltaArrType_Type.tp_str = timedeltatype_str;

    

    PyHalfArrType_Type.tp_print = halftype_print;
    PyFloatArrType_Type.tp_print = floattype_print;
    PyDoubleArrType_Type.tp_print = doubletype_print;
    PyLongDoubleArrType_Type.tp_print = longdoubletype_print;

    PyCFloatArrType_Type.tp_print = cfloattype_print;
    PyCDoubleArrType_Type.tp_print = cdoubletype_print;
    PyCLongDoubleArrType_Type.tp_print = clongdoubletype_print;

    /*
     * These need to be coded specially because getitem does not
     * return a normal Python type
     */
    PyLongDoubleArrType_Type.tp_as_number = &longdoubletype_as_number;
    PyCLongDoubleArrType_Type.tp_as_number = &clongdoubletype_as_number;

    #line 4123

    PyLongDoubleArrType_Type.tp_as_number->nb_int = longdoubletype_int;
    PyCLongDoubleArrType_Type.tp_as_number->nb_int = clongdoubletype_int;

    
#line 4123

    PyLongDoubleArrType_Type.tp_as_number->nb_float = longdoubletype_float;
    PyCLongDoubleArrType_Type.tp_as_number->nb_float = clongdoubletype_float;

    
#line 4123

    PyLongDoubleArrType_Type.tp_repr = longdoubletype_repr;
    PyCLongDoubleArrType_Type.tp_repr = clongdoubletype_repr;

    
#line 4123

    PyLongDoubleArrType_Type.tp_str = longdoubletype_str;
    PyCLongDoubleArrType_Type.tp_str = clongdoubletype_str;

    


#if !defined(NPY_PY3K)
    #line 4135

    PyLongDoubleArrType_Type.tp_as_number->nb_long = longdoubletype_long;
    PyCLongDoubleArrType_Type.tp_as_number->nb_long = clongdoubletype_long;

    
#line 4135

    PyLongDoubleArrType_Type.tp_as_number->nb_hex = longdoubletype_hex;
    PyCLongDoubleArrType_Type.tp_as_number->nb_hex = clongdoubletype_hex;

    
#line 4135

    PyLongDoubleArrType_Type.tp_as_number->nb_oct = longdoubletype_oct;
    PyCLongDoubleArrType_Type.tp_as_number->nb_oct = clongdoubletype_oct;

    

#endif

    PyStringArrType_Type.tp_itemsize = sizeof(char);
    PyVoidArrType_Type.tp_dealloc = (destructor) void_dealloc;

    PyArrayIter_Type.tp_iter = PyObject_SelfIter;
    PyArrayMapIter_Type.tp_iter = PyObject_SelfIter;
}


/* the order of this table is important */
static PyTypeObject *typeobjects[] = {
    &PyBoolArrType_Type,
    &PyByteArrType_Type,
    &PyUByteArrType_Type,
    &PyShortArrType_Type,
    &PyUShortArrType_Type,
    &PyIntArrType_Type,
    &PyUIntArrType_Type,
    &PyLongArrType_Type,
    &PyULongArrType_Type,
    &PyLongLongArrType_Type,
    &PyULongLongArrType_Type,
    &PyFloatArrType_Type,
    &PyDoubleArrType_Type,
    &PyLongDoubleArrType_Type,
    &PyCFloatArrType_Type,
    &PyCDoubleArrType_Type,
    &PyCLongDoubleArrType_Type,
    &PyObjectArrType_Type,
    &PyStringArrType_Type,
    &PyUnicodeArrType_Type,
    &PyVoidArrType_Type,
    &PyDatetimeArrType_Type,
    &PyTimedeltaArrType_Type,
    &PyHalfArrType_Type
};

NPY_NO_EXPORT int
_typenum_fromtypeobj(PyObject *type, int user)
{
    int typenum, i;

    typenum = NPY_NOTYPE;
    i = 0;
    while(i < NPY_NTYPES) {
        if (type == (PyObject *)typeobjects[i]) {
            typenum = i;
            break;
        }
        i++;
    }

    if (!user) {
        return typenum;
    }
    /* Search any registered types */
    i = 0;
    while (i < NPY_NUMUSERTYPES) {
        if (type == (PyObject *)(userdescrs[i]->typeobj)) {
            typenum = i + NPY_USERDEF;
            break;
        }
        i++;
    }
    return typenum;
}

