#line 1 "numpy/core/src/multiarray/arraytypes.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */
#define PY_SSIZE_T_CLEAN
#include "Python.h"
#include "structmember.h"

#define NPY_NO_DEPRECATED_API NPY_API_VERSION
#define _MULTIARRAYMODULE
#include "numpy/arrayobject.h"
#include "numpy/arrayscalars.h"
#include "npy_pycompat.h"
#include "numpy/npy_math.h"
#include "numpy/halffloat.h"

#include "npy_config.h"
#include "npy_sort.h"
#include "common.h"
#include "ctors.h"
#include "usertypes.h"
#include "_datetime.h"
#include "arrayobject.h"

#include "numpyos.h"


/*
 *****************************************************************************
 **                        PYTHON TYPES TO C TYPES                          **
 *****************************************************************************
 */

static double
MyPyFloat_AsDouble(PyObject *obj)
{
    double ret = 0;
    PyObject *num;

    if (obj == Py_None) {
        return NPY_NAN;
    }
    num = PyNumber_Float(obj);
    if (num == NULL) {
        return NPY_NAN;
    }
    ret = PyFloat_AsDouble(num);
    Py_DECREF(num);
    return ret;
}

static npy_half
MyPyFloat_AsHalf(PyObject *obj)
{
    return npy_double_to_half(MyPyFloat_AsDouble(obj));
}

static PyObject *
MyPyFloat_FromHalf(npy_half h)
{
    return PyFloat_FromDouble(npy_half_to_double(h));
}


#line 67
static npy_long
MyPyLong_AsLong (PyObject *obj)
{
    npy_long ret;
    PyObject *num = PyNumber_Long(obj);

    if (num == NULL) {
        return -1;
    }
    ret = PyLong_AsLong(num);
    Py_DECREF(num);
    return ret;
}


#line 67
static npy_longlong
MyPyLong_AsLongLong (PyObject *obj)
{
    npy_longlong ret;
    PyObject *num = PyNumber_Long(obj);

    if (num == NULL) {
        return -1;
    }
    ret = PyLong_AsLongLong(num);
    Py_DECREF(num);
    return ret;
}



#line 88
static npy_ulong
MyPyLong_AsUnsignedLong (PyObject *obj)
{
    npy_ulong ret;
    PyObject *num = PyNumber_Long(obj);

    if (num == NULL) {
        return -1;
    }
    ret = PyLong_AsUnsignedLong(num);
    if (PyErr_Occurred()) {
        PyErr_Clear();
        ret = PyLong_AsLong(num);
    }
    Py_DECREF(num);
    return ret;
}


#line 88
static npy_ulonglong
MyPyLong_AsUnsignedLongLong (PyObject *obj)
{
    npy_ulonglong ret;
    PyObject *num = PyNumber_Long(obj);

    if (num == NULL) {
        return -1;
    }
    ret = PyLong_AsUnsignedLongLong(num);
    if (PyErr_Occurred()) {
        PyErr_Clear();
        ret = PyLong_AsLongLong(num);
    }
    Py_DECREF(num);
    return ret;
}




/*
 *****************************************************************************
 **                         GETITEM AND SETITEM                             **
 *****************************************************************************
 */


#line 135
static PyObject *
BOOL_getitem(char *ip, PyArrayObject *ap) {
    npy_bool t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_bool *)ip);
        return PyBool_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyBool_FromLong((long)t1);
    }
}

static int
BOOL_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_bool temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, Bool)) {
        temp = ((PyBoolScalarObject *)op)->obval;
    }
    else {
        temp = (npy_bool)PyObject_IsTrue(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_bool *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
BYTE_getitem(char *ip, PyArrayObject *ap) {
    npy_byte t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_byte *)ip);
        return PyInt_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyInt_FromLong((long)t1);
    }
}

static int
BYTE_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_byte temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, Byte)) {
        temp = ((PyByteScalarObject *)op)->obval;
    }
    else {
        temp = (npy_byte)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_byte *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
UBYTE_getitem(char *ip, PyArrayObject *ap) {
    npy_ubyte t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_ubyte *)ip);
        return PyInt_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyInt_FromLong((long)t1);
    }
}

static int
UBYTE_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_ubyte temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, UByte)) {
        temp = ((PyUByteScalarObject *)op)->obval;
    }
    else {
        temp = (npy_ubyte)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_ubyte *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
SHORT_getitem(char *ip, PyArrayObject *ap) {
    npy_short t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_short *)ip);
        return PyInt_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyInt_FromLong((long)t1);
    }
}

static int
SHORT_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_short temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, Short)) {
        temp = ((PyShortScalarObject *)op)->obval;
    }
    else {
        temp = (npy_short)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_short *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
USHORT_getitem(char *ip, PyArrayObject *ap) {
    npy_ushort t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_ushort *)ip);
        return PyInt_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyInt_FromLong((long)t1);
    }
}

static int
USHORT_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_ushort temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, UShort)) {
        temp = ((PyUShortScalarObject *)op)->obval;
    }
    else {
        temp = (npy_ushort)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_ushort *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
INT_getitem(char *ip, PyArrayObject *ap) {
    npy_int t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_int *)ip);
        return PyInt_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyInt_FromLong((long)t1);
    }
}

static int
INT_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_int temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, Int)) {
        temp = ((PyIntScalarObject *)op)->obval;
    }
    else {
        temp = (npy_int)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_int *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
LONG_getitem(char *ip, PyArrayObject *ap) {
    npy_long t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_long *)ip);
        return PyInt_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyInt_FromLong((long)t1);
    }
}

static int
LONG_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_long temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, Long)) {
        temp = ((PyLongScalarObject *)op)->obval;
    }
    else {
        temp = (npy_long)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_long *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
UINT_getitem(char *ip, PyArrayObject *ap) {
    npy_uint t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_uint *)ip);
        return PyLong_FromUnsignedLong((npy_ulong)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyLong_FromUnsignedLong((npy_ulong)t1);
    }
}

static int
UINT_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_uint temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, UInt)) {
        temp = ((PyUIntScalarObject *)op)->obval;
    }
    else {
        temp = (npy_uint)MyPyLong_AsUnsignedLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_uint *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
ULONG_getitem(char *ip, PyArrayObject *ap) {
    npy_ulong t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_ulong *)ip);
        return PyLong_FromUnsignedLong((npy_ulong)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyLong_FromUnsignedLong((npy_ulong)t1);
    }
}

static int
ULONG_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_ulong temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, ULong)) {
        temp = ((PyULongScalarObject *)op)->obval;
    }
    else {
        temp = (npy_ulong)MyPyLong_AsUnsignedLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_ulong *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
LONGLONG_getitem(char *ip, PyArrayObject *ap) {
    npy_longlong t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_longlong *)ip);
        return PyLong_FromLongLong((npy_longlong)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyLong_FromLongLong((npy_longlong)t1);
    }
}

static int
LONGLONG_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_longlong temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, LongLong)) {
        temp = ((PyLongLongScalarObject *)op)->obval;
    }
    else {
        temp = (npy_longlong)MyPyLong_AsLongLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_longlong *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
ULONGLONG_getitem(char *ip, PyArrayObject *ap) {
    npy_ulonglong t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_ulonglong *)ip);
        return PyLong_FromUnsignedLongLong((npy_ulonglong)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyLong_FromUnsignedLongLong((npy_ulonglong)t1);
    }
}

static int
ULONGLONG_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_ulonglong temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, ULongLong)) {
        temp = ((PyULongLongScalarObject *)op)->obval;
    }
    else {
        temp = (npy_ulonglong)MyPyLong_AsUnsignedLongLong(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_ulonglong *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
HALF_getitem(char *ip, PyArrayObject *ap) {
    npy_half t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_half *)ip);
        return MyPyFloat_FromHalf((npy_half)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return MyPyFloat_FromHalf((npy_half)t1);
    }
}

static int
HALF_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_half temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, Half)) {
        temp = ((PyHalfScalarObject *)op)->obval;
    }
    else {
        temp = (npy_half)MyPyFloat_AsHalf(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_half *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
FLOAT_getitem(char *ip, PyArrayObject *ap) {
    npy_float t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_float *)ip);
        return PyFloat_FromDouble((npy_float)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyFloat_FromDouble((npy_float)t1);
    }
}

static int
FLOAT_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_float temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, Float)) {
        temp = ((PyFloatScalarObject *)op)->obval;
    }
    else {
        temp = (npy_float)MyPyFloat_AsDouble(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_float *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}


#line 135
static PyObject *
DOUBLE_getitem(char *ip, PyArrayObject *ap) {
    npy_double t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_double *)ip);
        return PyFloat_FromDouble((npy_double)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return PyFloat_FromDouble((npy_double)t1);
    }
}

static int
DOUBLE_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    npy_double temp;  /* ensures alignment */

    if (PyArray_IsScalar(op, Double)) {
        temp = ((PyDoubleScalarObject *)op)->obval;
    }
    else {
        temp = (npy_double)MyPyFloat_AsDouble(op);
    }
    if (PyErr_Occurred()) {
        if (PySequence_Check(op) && !PyString_Check(op) &&
                                            !PyUnicode_Check(op)) {
            PyErr_Clear();
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap))
        *((npy_double *)ov)=temp;
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }
    return 0;
}



#line 183
static PyObject *
CFLOAT_getitem(char *ip, PyArrayObject *ap) {
    npy_float t1, t2;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        return PyComplex_FromDoubles((double)((npy_float *)ip)[0],
                (double)((npy_float *)ip)[1]);
    }
    else {
        int size = sizeof(npy_float);

        npy_bool swap = !PyArray_ISNOTSWAPPED(ap);
        copy_and_swap(&t1, ip, size, 1, 0, swap);
        copy_and_swap(&t2, ip + size, size, 1, 0, swap);
        return PyComplex_FromDoubles((double)t1, (double)t2);
    }
}


#line 183
static PyObject *
CDOUBLE_getitem(char *ip, PyArrayObject *ap) {
    npy_double t1, t2;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        return PyComplex_FromDoubles((double)((npy_double *)ip)[0],
                (double)((npy_double *)ip)[1]);
    }
    else {
        int size = sizeof(npy_double);

        npy_bool swap = !PyArray_ISNOTSWAPPED(ap);
        copy_and_swap(&t1, ip, size, 1, 0, swap);
        copy_and_swap(&t2, ip + size, size, 1, 0, swap);
        return PyComplex_FromDoubles((double)t1, (double)t2);
    }
}





#line 212
static int
CFLOAT_setitem(PyObject *op, char *ov, PyArrayObject *ap)
{
    Py_complex oop;
    PyObject *op2;
    npy_cfloat temp;
    int rsize;

    if (PyArray_IsScalar(op, CFloat)){
        temp = ((PyCFloatScalarObject *)op)->obval;
    }
    else {
        if (PyArray_Check(op) && (PyArray_NDIM((PyArrayObject *)op) == 0)) {
            op2 = PyArray_DESCR((PyArrayObject *)op)->f->getitem(
                                    PyArray_BYTES((PyArrayObject *)op),
                                    (PyArrayObject *)op);
        }
        else {
            op2 = op;
            Py_INCREF(op);
        }
        if (op2 == Py_None) {
            oop.real = NPY_NAN;
            oop.imag = NPY_NAN;
        }
        else {
            oop = PyComplex_AsCComplex (op2);
        }
        Py_DECREF(op2);
        if (PyErr_Occurred()) {
            return -1;
        }
        temp.real = (npy_float) oop.real;
        temp.imag = (npy_float) oop.imag;
    }

    memcpy(ov, &temp, PyArray_DESCR(ap)->elsize);
    if (!PyArray_ISNOTSWAPPED(ap)) {
        byte_swap_vector(ov, 2, sizeof(npy_float));
    }
    rsize = sizeof(npy_float);
    copy_and_swap(ov, &temp, rsize, 2, rsize, !PyArray_ISNOTSWAPPED(ap));
    return 0;
}


#line 212
static int
CDOUBLE_setitem(PyObject *op, char *ov, PyArrayObject *ap)
{
    Py_complex oop;
    PyObject *op2;
    npy_cdouble temp;
    int rsize;

    if (PyArray_IsScalar(op, CDouble)){
        temp = ((PyCDoubleScalarObject *)op)->obval;
    }
    else {
        if (PyArray_Check(op) && (PyArray_NDIM((PyArrayObject *)op) == 0)) {
            op2 = PyArray_DESCR((PyArrayObject *)op)->f->getitem(
                                    PyArray_BYTES((PyArrayObject *)op),
                                    (PyArrayObject *)op);
        }
        else {
            op2 = op;
            Py_INCREF(op);
        }
        if (op2 == Py_None) {
            oop.real = NPY_NAN;
            oop.imag = NPY_NAN;
        }
        else {
            oop = PyComplex_AsCComplex (op2);
        }
        Py_DECREF(op2);
        if (PyErr_Occurred()) {
            return -1;
        }
        temp.real = (npy_double) oop.real;
        temp.imag = (npy_double) oop.imag;
    }

    memcpy(ov, &temp, PyArray_DESCR(ap)->elsize);
    if (!PyArray_ISNOTSWAPPED(ap)) {
        byte_swap_vector(ov, 2, sizeof(npy_double));
    }
    rsize = sizeof(npy_double);
    copy_and_swap(ov, &temp, rsize, 2, rsize, !PyArray_ISNOTSWAPPED(ap));
    return 0;
}


#line 212
static int
CLONGDOUBLE_setitem(PyObject *op, char *ov, PyArrayObject *ap)
{
    Py_complex oop;
    PyObject *op2;
    npy_clongdouble temp;
    int rsize;

    if (PyArray_IsScalar(op, CLongDouble)){
        temp = ((PyCLongDoubleScalarObject *)op)->obval;
    }
    else {
        if (PyArray_Check(op) && (PyArray_NDIM((PyArrayObject *)op) == 0)) {
            op2 = PyArray_DESCR((PyArrayObject *)op)->f->getitem(
                                    PyArray_BYTES((PyArrayObject *)op),
                                    (PyArrayObject *)op);
        }
        else {
            op2 = op;
            Py_INCREF(op);
        }
        if (op2 == Py_None) {
            oop.real = NPY_NAN;
            oop.imag = NPY_NAN;
        }
        else {
            oop = PyComplex_AsCComplex (op2);
        }
        Py_DECREF(op2);
        if (PyErr_Occurred()) {
            return -1;
        }
        temp.real = (npy_longdouble) oop.real;
        temp.imag = (npy_longdouble) oop.imag;
    }

    memcpy(ov, &temp, PyArray_DESCR(ap)->elsize);
    if (!PyArray_ISNOTSWAPPED(ap)) {
        byte_swap_vector(ov, 2, sizeof(npy_longdouble));
    }
    rsize = sizeof(npy_longdouble);
    copy_and_swap(ov, &temp, rsize, 2, rsize, !PyArray_ISNOTSWAPPED(ap));
    return 0;
}



/*
 * These return array scalars which are different than other date-types.
 */

static PyObject *
LONGDOUBLE_getitem(char *ip, PyArrayObject *ap)
{
    return PyArray_Scalar(ip, PyArray_DESCR(ap), NULL);
}

static int
LONGDOUBLE_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    /* ensure alignment */
    npy_longdouble temp;

    if (PyArray_IsScalar(op, LongDouble)) {
        temp = ((PyLongDoubleScalarObject *)op)->obval;
    }
    else {
        temp = (npy_longdouble) MyPyFloat_AsDouble(op);
    }
    if (PyErr_Occurred()) {
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        *((npy_longdouble *)ov) = temp;
    }
    else {
        copy_and_swap(ov, &temp, PyArray_DESCR(ap)->elsize, 1, 0,
                !PyArray_ISNOTSWAPPED(ap));
    }
    return 0;
}

static PyObject *
CLONGDOUBLE_getitem(char *ip, PyArrayObject *ap)
{
    return PyArray_Scalar(ip, PyArray_DESCR(ap), NULL);
}

/* UNICODE */
static PyObject *
UNICODE_getitem(char *ip, PyArrayObject *ap)
{
    Py_ssize_t size = PyArray_ITEMSIZE(ap);
    int swap = !PyArray_ISNOTSWAPPED(ap);
    int align = !PyArray_ISALIGNED(ap);

    return (PyObject *)PyUnicode_FromUCS4(ip, size, swap, align);
}

static int
UNICODE_setitem(PyObject *op, char *ov, PyArrayObject *ap)
{
    PyObject *temp;
    Py_UNICODE *ptr;
    int datalen;
#ifndef Py_UNICODE_WIDE
    char *buffer;
#endif

    if (!PyBytes_Check(op) && !PyUnicode_Check(op) &&
            PySequence_Check(op) && PySequence_Size(op) > 0) {
        PyErr_SetString(PyExc_ValueError,
                "setting an array element with a sequence");
        return -1;
    }
    /* Sequence_Size might have returned an error */
    if (PyErr_Occurred()) {
        PyErr_Clear();
    }
#if defined(NPY_PY3K)
    if (PyBytes_Check(op)) {
        /* Try to decode from ASCII */
        temp = PyUnicode_FromEncodedObject(op, "ASCII", "strict");
        if (temp == NULL) {
            return -1;
        }
    }
    else if ((temp=PyObject_Str(op)) == NULL) {
#else
    if ((temp=PyObject_Unicode(op)) == NULL) {
#endif
        return -1;
    }
    ptr = PyUnicode_AS_UNICODE(temp);
    if ((ptr == NULL) || (PyErr_Occurred())) {
        Py_DECREF(temp);
        return -1;
    }
    datalen = PyUnicode_GET_DATA_SIZE(temp);

#ifdef Py_UNICODE_WIDE
    memcpy(ov, ptr, PyArray_MIN(PyArray_DESCR(ap)->elsize, datalen));
#else
    if (!PyArray_ISALIGNED(ap)) {
        buffer = PyArray_malloc(PyArray_DESCR(ap)->elsize);
        if (buffer == NULL) {
            Py_DECREF(temp);
            PyErr_NoMemory();
            return -1;
        }
    }
    else {
        buffer = ov;
    }
    datalen = PyUCS2Buffer_AsUCS4(ptr, (npy_ucs4 *)buffer,
            datalen >> 1, PyArray_DESCR(ap)->elsize >> 2);
    datalen <<= 2;
    if (!PyArray_ISALIGNED(ap)) {
        memcpy(ov, buffer, datalen);
        PyArray_free(buffer);
    }
#endif
    /* Fill in the rest of the space with 0 */
    if (PyArray_DESCR(ap)->elsize > datalen) {
        memset(ov + datalen, 0, (PyArray_DESCR(ap)->elsize - datalen));
    }
    if (!PyArray_ISNOTSWAPPED(ap)) {
        byte_swap_vector(ov, PyArray_DESCR(ap)->elsize >> 2, 4);
    }
    Py_DECREF(temp);
    return 0;
}

/* STRING
 *
 * can handle both NULL-terminated and not NULL-terminated cases
 * will truncate all ending NULLs in returned string.
 */
static PyObject *
STRING_getitem(char *ip, PyArrayObject *ap)
{
    /* Will eliminate NULLs at the end */
    char *ptr;
    int size = PyArray_DESCR(ap)->elsize;

    ptr = ip + size - 1;
    while (*ptr-- == '\0' && size > 0) {
        size--;
    }
    return PyBytes_FromStringAndSize(ip,size);
}

static int
STRING_setitem(PyObject *op, char *ov, PyArrayObject *ap)
{
    char *ptr;
    Py_ssize_t len;
    PyObject *temp = NULL;

    /* Handle case of assigning from an array scalar */
    if (PyArray_Check(op) && PyArray_NDIM((PyArrayObject *)op) == 0) {
        temp = PyArray_ToScalar(PyArray_BYTES((PyArrayObject *)op),
                                (PyArrayObject *)op);
        if (temp == NULL) {
            return -1;
        }
        else {
            int res = STRING_setitem(temp, ov, ap);
            Py_DECREF(temp);
            return res;
        }
    }

    if (!PyBytes_Check(op) && !PyUnicode_Check(op)
            && PySequence_Check(op) && PySequence_Size(op) != 0) {
        PyErr_SetString(PyExc_ValueError,
                "cannot set an array element with a sequence");
        return -1;
    }
#if defined(NPY_PY3K)
    if (PyUnicode_Check(op)) {
        /* Assume ASCII codec -- function similarly as Python 2 */
        temp = PyUnicode_AsASCIIString(op);
        if (temp == NULL) {
            return -1;
        }
    }
    else if (PyBytes_Check(op) || PyMemoryView_Check(op)) {
        temp = PyObject_Bytes(op);
        if (temp == NULL) {
            return -1;
        }
    }
    else {
        /* Emulate similar casting behavior as on Python 2 */
        PyObject *str;
        str = PyObject_Str(op);
        if (str == NULL) {
            return -1;
        }
        temp = PyUnicode_AsASCIIString(str);
        Py_DECREF(str);
        if (temp == NULL) {
            return -1;
        }
    }
#else
    if ((temp = PyObject_Str(op)) == NULL) {
        return -1;
    }
#endif
    if (PyBytes_AsStringAndSize(temp, &ptr, &len) == -1) {
        Py_DECREF(temp);
        return -1;
    }
    memcpy(ov, ptr, PyArray_MIN(PyArray_DESCR(ap)->elsize,len));
    /*
     * If string lenth is smaller than room in array
     * Then fill the rest of the element size with NULL
     */
    if (PyArray_DESCR(ap)->elsize > len) {
        memset(ov + len, 0, (PyArray_DESCR(ap)->elsize - len));
    }
    Py_DECREF(temp);
    return 0;
}

/* OBJECT */

#define __ALIGNED(obj, sz) ((((size_t) obj) % (sz))==0)

static PyObject *
OBJECT_getitem(char *ip, PyArrayObject *ap)
{
    PyObject *obj;
    NPY_COPY_PYOBJECT_PTR(&obj, ip);
    if (obj == NULL) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    else {
        Py_INCREF(obj);
        return obj;
    }
}


static int
OBJECT_setitem(PyObject *op, char *ov, PyArrayObject *ap)
{
    PyObject *obj;

    NPY_COPY_PYOBJECT_PTR(&obj, ov);

    Py_INCREF(op);
    Py_XDECREF(obj);

    NPY_COPY_PYOBJECT_PTR(ov, &op);

    return PyErr_Occurred() ? -1 : 0;
}

/* VOID */

static PyObject *
VOID_getitem(char *ip, PyArrayObject *ap)
{
    PyArrayObject *u = NULL;
    PyArray_Descr* descr;
    int itemsize;

    descr = PyArray_DESCR(ap);
    if (PyDataType_HASFIELDS(descr)) {
        PyObject *key;
        PyObject *names;
        int i, n;
        PyObject *ret;
        PyObject *tup, *title;
        PyArray_Descr *new;
        int offset;
        int savedflags;

        /* get the names from the fields dictionary*/
        names = descr->names;
        n = PyTuple_GET_SIZE(names);
        ret = PyTuple_New(n);
        savedflags = PyArray_FLAGS(ap);
        for (i = 0; i < n; i++) {
            key = PyTuple_GET_ITEM(names, i);
            tup = PyDict_GetItem(descr->fields, key);
            if (!PyArg_ParseTuple(tup, "Oi|O", &new, &offset, &title)) {
                Py_DECREF(ret);
                ((PyArrayObject_fields *)ap)->descr = descr;
                return NULL;
            }
            /*
             * TODO: temporarily modifying the array like this
             *       is bad coding style, should be changed.
             */
            ((PyArrayObject_fields *)ap)->descr = new;
            /* update alignment based on offset */
            if ((new->alignment > 1)
                    && ((((npy_intp)(ip+offset)) % new->alignment) != 0)) {
                PyArray_CLEARFLAGS(ap, NPY_ARRAY_ALIGNED);
            }
            else {
                PyArray_ENABLEFLAGS(ap, NPY_ARRAY_ALIGNED);
            }
            PyTuple_SET_ITEM(ret, i, new->f->getitem(ip+offset, ap));
            ((PyArrayObject_fields *)ap)->flags = savedflags;
        }
        ((PyArrayObject_fields *)ap)->descr = descr;
        return ret;
    }

    if (descr->subarray) {
        /* return an array of the basic type */
        PyArray_Dims shape = {NULL, -1};
        PyArrayObject *ret;

        if (!(PyArray_IntpConverter(descr->subarray->shape, &shape))) {
            PyDimMem_FREE(shape.ptr);
            PyErr_SetString(PyExc_ValueError,
                    "invalid shape in fixed-type tuple.");
            return NULL;
        }
        Py_INCREF(descr->subarray->base);
        ret = (PyArrayObject *)PyArray_NewFromDescr(&PyArray_Type,
                descr->subarray->base, shape.len, shape.ptr,
                NULL, ip, PyArray_FLAGS(ap)&(~NPY_ARRAY_F_CONTIGUOUS), NULL);
        PyDimMem_FREE(shape.ptr);
        if (!ret) {
            return NULL;
        }
        Py_INCREF(ap);
        if (PyArray_SetBaseObject(ret, (PyObject *)ap) < 0) {
            Py_DECREF(ret);
            return NULL;
        }
        PyArray_UpdateFlags((PyArrayObject *)ret, NPY_ARRAY_UPDATE_ALL);
        return (PyObject *)ret;
    }

    if (PyDataType_FLAGCHK(descr, NPY_ITEM_HASOBJECT)
            || PyDataType_FLAGCHK(descr, NPY_ITEM_IS_POINTER)) {
        PyErr_SetString(PyExc_ValueError,
                "tried to get void-array with object members as buffer.");
        return NULL;
    }
    itemsize = PyArray_DESCR(ap)->elsize;

#if defined(NPY_PY3K)
    /*
     * Return a byte array; there are no plain buffer objects on Py3
     */
    {
        npy_intp dims[1], strides[1];
        dims[0] = itemsize;
        strides[0] = 1;
        descr = PyArray_DescrNewFromType(NPY_BYTE);
        u = (PyArrayObject *)PyArray_NewFromDescr(&PyArray_Type,
                             descr, 1, dims, strides, ip,
                             PyArray_ISWRITEABLE(ap) ? NPY_ARRAY_WRITEABLE : 0,
                             NULL);
        Py_INCREF(ap);
        if (PyArray_SetBaseObject(u, (PyObject *)ap) < 0) {
            Py_DECREF(u);
            return NULL;
        }
    }
#else
    /*
     * default is to return buffer object pointing to
     * current item a view of it
     */
    if (PyArray_ISWRITEABLE(ap)) {
        if (array_might_be_written(ap) < 0) {
            return NULL;
        }
        u = (PyArrayObject *)PyBuffer_FromReadWriteMemory(ip, itemsize);
    }
    else {
        u = (PyArrayObject *)PyBuffer_FromMemory(ip, itemsize);
    }
#endif

    if (u == NULL) {
        return NULL;
    }
    return (PyObject *)u;
}


NPY_NO_EXPORT int PyArray_CopyObject(PyArrayObject *, PyObject *);

static int
VOID_setitem(PyObject *op, char *ip, PyArrayObject *ap)
{
    PyArray_Descr* descr;
    int itemsize=PyArray_DESCR(ap)->elsize;
    int res;

    descr = PyArray_DESCR(ap);
    if (descr->names && PyTuple_Check(op)) {
        PyObject *key;
        PyObject *names;
        int i, n;
        PyObject *tup, *title;
        PyArray_Descr *new;
        int offset;
        int savedflags;

        res = -1;
        /* get the names from the fields dictionary*/
        names = descr->names;
        n = PyTuple_GET_SIZE(names);
        if (PyTuple_GET_SIZE(op) != n) {
            PyErr_SetString(PyExc_ValueError,
                    "size of tuple must match number of fields.");
            return -1;
        }
        savedflags = PyArray_FLAGS(ap);
        for (i = 0; i < n; i++) {
            key = PyTuple_GET_ITEM(names, i);
            tup = PyDict_GetItem(descr->fields, key);
            if (!PyArg_ParseTuple(tup, "Oi|O", &new, &offset, &title)) {
                ((PyArrayObject_fields *)ap)->descr = descr;
                return -1;
            }
            /*
             * TODO: temporarily modifying the array like this
             *       is bad coding style, should be changed.
             */
            ((PyArrayObject_fields *)ap)->descr = new;
            /* remember to update alignment flags */
            if ((new->alignment > 1)
                    && ((((npy_intp)(ip+offset)) % new->alignment) != 0)) {
                PyArray_CLEARFLAGS(ap, NPY_ARRAY_ALIGNED);
            }
            else {
                PyArray_ENABLEFLAGS(ap, NPY_ARRAY_ALIGNED);
            }
            res = new->f->setitem(PyTuple_GET_ITEM(op, i), ip+offset, ap);
            ((PyArrayObject_fields *)ap)->flags = savedflags;
            if (res < 0) {
                break;
            }
        }
        ((PyArrayObject_fields *)ap)->descr = descr;
        return res;
    }

    if (descr->subarray) {
        /* copy into an array of the same basic type */
        PyArray_Dims shape = {NULL, -1};
        PyArrayObject *ret;
        if (!(PyArray_IntpConverter(descr->subarray->shape, &shape))) {
            PyDimMem_FREE(shape.ptr);
            PyErr_SetString(PyExc_ValueError,
                    "invalid shape in fixed-type tuple.");
            return -1;
        }
        Py_INCREF(descr->subarray->base);
        ret = (PyArrayObject *)PyArray_NewFromDescr(&PyArray_Type,
                        descr->subarray->base, shape.len, shape.ptr,
                        NULL, ip, PyArray_FLAGS(ap), NULL);
        PyDimMem_FREE(shape.ptr);
        if (!ret) {
            return -1;
        }
        Py_INCREF(ap);
        if (PyArray_SetBaseObject(ret, (PyObject *)ap) < 0) {
            Py_DECREF(ret);
            return -1;
        }
        PyArray_UpdateFlags(ret, NPY_ARRAY_UPDATE_ALL);
        res = PyArray_CopyObject(ret, op);
        Py_DECREF(ret);
        return res;
    }

    /* Default is to use buffer interface to set item */
    {
        const void *buffer;
        Py_ssize_t buflen;
        if (PyDataType_FLAGCHK(descr, NPY_ITEM_HASOBJECT)
                || PyDataType_FLAGCHK(descr, NPY_ITEM_IS_POINTER)) {
            PyErr_SetString(PyExc_ValueError,
                    "Setting void-array with object members using buffer.");
            return -1;
        }
        res = PyObject_AsReadBuffer(op, &buffer, &buflen);
        if (res == -1) {
            goto fail;
        }
        memcpy(ip, buffer, PyArray_MIN(buflen, itemsize));
        if (itemsize > buflen) {
            memset(ip + buflen, 0, itemsize - buflen);
        }
    }
    return 0;

fail:
    return -1;
}

static PyObject *
DATETIME_getitem(char *ip, PyArrayObject *ap) {
    npy_datetime dt;
    PyArray_DatetimeMetaData *meta = NULL;

    /* Get the datetime units metadata */
    meta = get_datetime_metadata_from_dtype(PyArray_DESCR(ap));
    if (meta == NULL) {
        return NULL;
    }

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        dt = *((npy_datetime *)ip);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&dt, ip, !PyArray_ISNOTSWAPPED(ap), ap);
    }

    return convert_datetime_to_pyobject(dt, meta);
}


static PyObject *
TIMEDELTA_getitem(char *ip, PyArrayObject *ap) {
    npy_timedelta td;
    PyArray_DatetimeMetaData *meta = NULL;

    /* Get the datetime units metadata */
    meta = get_datetime_metadata_from_dtype(PyArray_DESCR(ap));
    if (meta == NULL) {
        return NULL;
    }

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        td = *((npy_timedelta *)ip);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&td, ip, !PyArray_ISNOTSWAPPED(ap), ap);
    }

    return convert_timedelta_to_pyobject(td, meta);
}

static int
DATETIME_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    /* ensure alignment */
    npy_datetime temp = 0;
    PyArray_DatetimeMetaData *meta = NULL;

    /* Get the datetime units metadata */
    meta = get_datetime_metadata_from_dtype(PyArray_DESCR(ap));
    if (meta == NULL) {
        return -1;
    }

    /* Convert the object into a NumPy datetime */
    if (convert_pyobject_to_datetime(meta, op,
                            NPY_SAME_KIND_CASTING, &temp) < 0) {
        return -1;
    }

    /* Copy the value into the output */
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        *((npy_datetime *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp,
                !PyArray_ISNOTSWAPPED(ap), ap);
    }

    return 0;
}

static int
TIMEDELTA_setitem(PyObject *op, char *ov, PyArrayObject *ap) {
    /* ensure alignment */
    npy_timedelta temp = 0;
    PyArray_DatetimeMetaData *meta = NULL;

    /* Get the datetime units metadata */
    meta = get_datetime_metadata_from_dtype(PyArray_DESCR(ap));
    if (meta == NULL) {
        return -1;
    }

    /* Convert the object into a NumPy datetime */
    if (convert_pyobject_to_timedelta(meta, op,
                            NPY_SAME_KIND_CASTING, &temp) < 0) {
        return -1;
    }

    /* Copy the value into the output */
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        *((npy_timedelta *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, !PyArray_ISNOTSWAPPED(ap), ap);
    }

    return 0;
}


/*
 *****************************************************************************
 **                       TYPE TO TYPE CONVERSIONS                          **
 *****************************************************************************
 */


/* Assumes contiguous, and aligned, from and to */


#line 880

#line 891
static void
BYTE_to_BYTE(npy_byte *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
UBYTE_to_BYTE(npy_ubyte *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
SHORT_to_BYTE(npy_short *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
USHORT_to_BYTE(npy_ushort *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
INT_to_BYTE(npy_int *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
UINT_to_BYTE(npy_uint *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
LONG_to_BYTE(npy_long *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
ULONG_to_BYTE(npy_ulong *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
LONGLONG_to_BYTE(npy_longlong *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_BYTE(npy_ulonglong *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
FLOAT_to_BYTE(npy_float *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
DOUBLE_to_BYTE(npy_double *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_BYTE(npy_longdouble *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
DATETIME_to_BYTE(npy_datetime *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_BYTE(npy_timedelta *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip++;
    }
}


#line 906
static void
CFLOAT_to_BYTE(npy_float *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_BYTE(npy_double *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_BYTE(npy_longdouble *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_UBYTE(npy_byte *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
UBYTE_to_UBYTE(npy_ubyte *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
SHORT_to_UBYTE(npy_short *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
USHORT_to_UBYTE(npy_ushort *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
INT_to_UBYTE(npy_int *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
UINT_to_UBYTE(npy_uint *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
LONG_to_UBYTE(npy_long *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
ULONG_to_UBYTE(npy_ulong *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
LONGLONG_to_UBYTE(npy_longlong *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_UBYTE(npy_ulonglong *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
FLOAT_to_UBYTE(npy_float *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
DOUBLE_to_UBYTE(npy_double *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_UBYTE(npy_longdouble *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
DATETIME_to_UBYTE(npy_datetime *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_UBYTE(npy_timedelta *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip++;
    }
}


#line 906
static void
CFLOAT_to_UBYTE(npy_float *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_UBYTE(npy_double *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_UBYTE(npy_longdouble *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_SHORT(npy_byte *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
UBYTE_to_SHORT(npy_ubyte *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
SHORT_to_SHORT(npy_short *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
USHORT_to_SHORT(npy_ushort *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
INT_to_SHORT(npy_int *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
UINT_to_SHORT(npy_uint *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
LONG_to_SHORT(npy_long *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
ULONG_to_SHORT(npy_ulong *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
LONGLONG_to_SHORT(npy_longlong *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_SHORT(npy_ulonglong *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
FLOAT_to_SHORT(npy_float *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
DOUBLE_to_SHORT(npy_double *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_SHORT(npy_longdouble *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
DATETIME_to_SHORT(npy_datetime *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_SHORT(npy_timedelta *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip++;
    }
}


#line 906
static void
CFLOAT_to_SHORT(npy_float *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_SHORT(npy_double *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_SHORT(npy_longdouble *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_USHORT(npy_byte *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
UBYTE_to_USHORT(npy_ubyte *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
SHORT_to_USHORT(npy_short *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
USHORT_to_USHORT(npy_ushort *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
INT_to_USHORT(npy_int *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
UINT_to_USHORT(npy_uint *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
LONG_to_USHORT(npy_long *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
ULONG_to_USHORT(npy_ulong *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
LONGLONG_to_USHORT(npy_longlong *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_USHORT(npy_ulonglong *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
FLOAT_to_USHORT(npy_float *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
DOUBLE_to_USHORT(npy_double *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_USHORT(npy_longdouble *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
DATETIME_to_USHORT(npy_datetime *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_USHORT(npy_timedelta *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip++;
    }
}


#line 906
static void
CFLOAT_to_USHORT(npy_float *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_USHORT(npy_double *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_USHORT(npy_longdouble *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_INT(npy_byte *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
UBYTE_to_INT(npy_ubyte *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
SHORT_to_INT(npy_short *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
USHORT_to_INT(npy_ushort *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
INT_to_INT(npy_int *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
UINT_to_INT(npy_uint *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
LONG_to_INT(npy_long *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
ULONG_to_INT(npy_ulong *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
LONGLONG_to_INT(npy_longlong *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_INT(npy_ulonglong *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
FLOAT_to_INT(npy_float *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
DOUBLE_to_INT(npy_double *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_INT(npy_longdouble *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
DATETIME_to_INT(npy_datetime *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_INT(npy_timedelta *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip++;
    }
}


#line 906
static void
CFLOAT_to_INT(npy_float *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_INT(npy_double *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_INT(npy_longdouble *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_UINT(npy_byte *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
UBYTE_to_UINT(npy_ubyte *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
SHORT_to_UINT(npy_short *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
USHORT_to_UINT(npy_ushort *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
INT_to_UINT(npy_int *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
UINT_to_UINT(npy_uint *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
LONG_to_UINT(npy_long *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
ULONG_to_UINT(npy_ulong *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
LONGLONG_to_UINT(npy_longlong *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_UINT(npy_ulonglong *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
FLOAT_to_UINT(npy_float *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
DOUBLE_to_UINT(npy_double *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_UINT(npy_longdouble *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
DATETIME_to_UINT(npy_datetime *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_UINT(npy_timedelta *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip++;
    }
}


#line 906
static void
CFLOAT_to_UINT(npy_float *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_UINT(npy_double *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_UINT(npy_longdouble *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_LONG(npy_byte *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
UBYTE_to_LONG(npy_ubyte *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
SHORT_to_LONG(npy_short *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
USHORT_to_LONG(npy_ushort *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
INT_to_LONG(npy_int *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
UINT_to_LONG(npy_uint *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
LONG_to_LONG(npy_long *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
ULONG_to_LONG(npy_ulong *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
LONGLONG_to_LONG(npy_longlong *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_LONG(npy_ulonglong *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
FLOAT_to_LONG(npy_float *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
DOUBLE_to_LONG(npy_double *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_LONG(npy_longdouble *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
DATETIME_to_LONG(npy_datetime *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_LONG(npy_timedelta *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip++;
    }
}


#line 906
static void
CFLOAT_to_LONG(npy_float *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_LONG(npy_double *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_LONG(npy_longdouble *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_ULONG(npy_byte *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
UBYTE_to_ULONG(npy_ubyte *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
SHORT_to_ULONG(npy_short *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
USHORT_to_ULONG(npy_ushort *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
INT_to_ULONG(npy_int *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
UINT_to_ULONG(npy_uint *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
LONG_to_ULONG(npy_long *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
ULONG_to_ULONG(npy_ulong *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
LONGLONG_to_ULONG(npy_longlong *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_ULONG(npy_ulonglong *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
FLOAT_to_ULONG(npy_float *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
DOUBLE_to_ULONG(npy_double *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_ULONG(npy_longdouble *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
DATETIME_to_ULONG(npy_datetime *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_ULONG(npy_timedelta *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip++;
    }
}


#line 906
static void
CFLOAT_to_ULONG(npy_float *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_ULONG(npy_double *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_ULONG(npy_longdouble *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_LONGLONG(npy_byte *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
UBYTE_to_LONGLONG(npy_ubyte *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
SHORT_to_LONGLONG(npy_short *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
USHORT_to_LONGLONG(npy_ushort *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
INT_to_LONGLONG(npy_int *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
UINT_to_LONGLONG(npy_uint *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
LONG_to_LONGLONG(npy_long *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
ULONG_to_LONGLONG(npy_ulong *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
LONGLONG_to_LONGLONG(npy_longlong *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_LONGLONG(npy_ulonglong *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
FLOAT_to_LONGLONG(npy_float *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
DOUBLE_to_LONGLONG(npy_double *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_LONGLONG(npy_longdouble *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
DATETIME_to_LONGLONG(npy_datetime *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_LONGLONG(npy_timedelta *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip++;
    }
}


#line 906
static void
CFLOAT_to_LONGLONG(npy_float *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_LONGLONG(npy_double *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_LONGLONG(npy_longdouble *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_ULONGLONG(npy_byte *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
UBYTE_to_ULONGLONG(npy_ubyte *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
SHORT_to_ULONGLONG(npy_short *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
USHORT_to_ULONGLONG(npy_ushort *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
INT_to_ULONGLONG(npy_int *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
UINT_to_ULONGLONG(npy_uint *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
LONG_to_ULONGLONG(npy_long *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
ULONG_to_ULONGLONG(npy_ulong *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
LONGLONG_to_ULONGLONG(npy_longlong *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_ULONGLONG(npy_ulonglong *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
FLOAT_to_ULONGLONG(npy_float *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
DOUBLE_to_ULONGLONG(npy_double *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_ULONGLONG(npy_longdouble *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
DATETIME_to_ULONGLONG(npy_datetime *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_ULONGLONG(npy_timedelta *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip++;
    }
}


#line 906
static void
CFLOAT_to_ULONGLONG(npy_float *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_ULONGLONG(npy_double *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_ULONGLONG(npy_longdouble *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_FLOAT(npy_byte *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
UBYTE_to_FLOAT(npy_ubyte *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
SHORT_to_FLOAT(npy_short *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
USHORT_to_FLOAT(npy_ushort *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
INT_to_FLOAT(npy_int *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
UINT_to_FLOAT(npy_uint *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
LONG_to_FLOAT(npy_long *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
ULONG_to_FLOAT(npy_ulong *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
LONGLONG_to_FLOAT(npy_longlong *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_FLOAT(npy_ulonglong *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
FLOAT_to_FLOAT(npy_float *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
DOUBLE_to_FLOAT(npy_double *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_FLOAT(npy_longdouble *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
DATETIME_to_FLOAT(npy_datetime *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_FLOAT(npy_timedelta *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}


#line 906
static void
CFLOAT_to_FLOAT(npy_float *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_FLOAT(npy_double *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_FLOAT(npy_longdouble *ip, npy_float *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_DOUBLE(npy_byte *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
UBYTE_to_DOUBLE(npy_ubyte *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
SHORT_to_DOUBLE(npy_short *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
USHORT_to_DOUBLE(npy_ushort *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
INT_to_DOUBLE(npy_int *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
UINT_to_DOUBLE(npy_uint *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
LONG_to_DOUBLE(npy_long *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
ULONG_to_DOUBLE(npy_ulong *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
LONGLONG_to_DOUBLE(npy_longlong *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_DOUBLE(npy_ulonglong *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
FLOAT_to_DOUBLE(npy_float *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
DOUBLE_to_DOUBLE(npy_double *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_DOUBLE(npy_longdouble *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
DATETIME_to_DOUBLE(npy_datetime *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_DOUBLE(npy_timedelta *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}


#line 906
static void
CFLOAT_to_DOUBLE(npy_float *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_DOUBLE(npy_double *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_DOUBLE(npy_longdouble *ip, npy_double *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_LONGDOUBLE(npy_byte *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
UBYTE_to_LONGDOUBLE(npy_ubyte *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
SHORT_to_LONGDOUBLE(npy_short *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
USHORT_to_LONGDOUBLE(npy_ushort *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
INT_to_LONGDOUBLE(npy_int *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
UINT_to_LONGDOUBLE(npy_uint *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
LONG_to_LONGDOUBLE(npy_long *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
ULONG_to_LONGDOUBLE(npy_ulong *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
LONGLONG_to_LONGDOUBLE(npy_longlong *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_LONGDOUBLE(npy_ulonglong *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
FLOAT_to_LONGDOUBLE(npy_float *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
DOUBLE_to_LONGDOUBLE(npy_double *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_LONGDOUBLE(npy_longdouble *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
DATETIME_to_LONGDOUBLE(npy_datetime *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_LONGDOUBLE(npy_timedelta *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}


#line 906
static void
CFLOAT_to_LONGDOUBLE(npy_float *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_LONGDOUBLE(npy_double *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_LONGDOUBLE(npy_longdouble *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_DATETIME(npy_byte *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
UBYTE_to_DATETIME(npy_ubyte *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
SHORT_to_DATETIME(npy_short *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
USHORT_to_DATETIME(npy_ushort *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
INT_to_DATETIME(npy_int *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
UINT_to_DATETIME(npy_uint *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
LONG_to_DATETIME(npy_long *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
ULONG_to_DATETIME(npy_ulong *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
LONGLONG_to_DATETIME(npy_longlong *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_DATETIME(npy_ulonglong *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
FLOAT_to_DATETIME(npy_float *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
DOUBLE_to_DATETIME(npy_double *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_DATETIME(npy_longdouble *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
DATETIME_to_DATETIME(npy_datetime *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_DATETIME(npy_timedelta *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip++;
    }
}


#line 906
static void
CFLOAT_to_DATETIME(npy_float *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_DATETIME(npy_double *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_DATETIME(npy_longdouble *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)*ip;
        ip += 2;
    }
}



#line 880

#line 891
static void
BYTE_to_TIMEDELTA(npy_byte *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
UBYTE_to_TIMEDELTA(npy_ubyte *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
SHORT_to_TIMEDELTA(npy_short *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
USHORT_to_TIMEDELTA(npy_ushort *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
INT_to_TIMEDELTA(npy_int *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
UINT_to_TIMEDELTA(npy_uint *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
LONG_to_TIMEDELTA(npy_long *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
ULONG_to_TIMEDELTA(npy_ulong *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
LONGLONG_to_TIMEDELTA(npy_longlong *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
ULONGLONG_to_TIMEDELTA(npy_ulonglong *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
FLOAT_to_TIMEDELTA(npy_float *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
DOUBLE_to_TIMEDELTA(npy_double *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
LONGDOUBLE_to_TIMEDELTA(npy_longdouble *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
DATETIME_to_TIMEDELTA(npy_datetime *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}

#line 891
static void
TIMEDELTA_to_TIMEDELTA(npy_timedelta *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip++;
    }
}


#line 906
static void
CFLOAT_to_TIMEDELTA(npy_float *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip;
        ip += 2;
    }
}

#line 906
static void
CDOUBLE_to_TIMEDELTA(npy_double *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip;
        ip += 2;
    }
}

#line 906
static void
CLONGDOUBLE_to_TIMEDELTA(npy_longdouble *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)*ip;
        ip += 2;
    }
}





#line 930

static void
BYTE_to_HALF(npy_byte *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_BYTE(npy_half *ip, npy_byte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)npy_half_to_float(*ip++);
    }
}


#line 930

static void
UBYTE_to_HALF(npy_ubyte *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_UBYTE(npy_half *ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)npy_half_to_float(*ip++);
    }
}


#line 930

static void
SHORT_to_HALF(npy_short *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_SHORT(npy_half *ip, npy_short *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)npy_half_to_float(*ip++);
    }
}


#line 930

static void
USHORT_to_HALF(npy_ushort *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_USHORT(npy_half *ip, npy_ushort *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)npy_half_to_float(*ip++);
    }
}


#line 930

static void
INT_to_HALF(npy_int *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_INT(npy_half *ip, npy_int *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)npy_half_to_float(*ip++);
    }
}


#line 930

static void
UINT_to_HALF(npy_uint *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_UINT(npy_half *ip, npy_uint *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)npy_half_to_float(*ip++);
    }
}


#line 930

static void
LONG_to_HALF(npy_long *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_LONG(npy_half *ip, npy_long *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)npy_half_to_float(*ip++);
    }
}


#line 930

static void
ULONG_to_HALF(npy_ulong *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_ULONG(npy_half *ip, npy_ulong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)npy_half_to_float(*ip++);
    }
}


#line 930

static void
LONGLONG_to_HALF(npy_longlong *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_LONGLONG(npy_half *ip, npy_longlong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)npy_half_to_float(*ip++);
    }
}


#line 930

static void
ULONGLONG_to_HALF(npy_ulonglong *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_ULONGLONG(npy_half *ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)npy_half_to_float(*ip++);
    }
}


#line 930

static void
LONGDOUBLE_to_HALF(npy_longdouble *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_LONGDOUBLE(npy_half *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)npy_half_to_float(*ip++);
    }
}


#line 930

static void
DATETIME_to_HALF(npy_datetime *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_DATETIME(npy_half *ip, npy_datetime *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)npy_half_to_float(*ip++);
    }
}


#line 930

static void
TIMEDELTA_to_HALF(npy_timedelta *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_TIMEDELTA(npy_half *ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)npy_half_to_float(*ip++);
    }
}


#if NPY_SIZEOF_SHORT == 2
#define HALF_to_HALF SHORT_to_SHORT
#elif NPY_SIZEOF_INT == 2
#define HALF_to_HALF INT_to_INT
#endif

#line 963

static void
FLOAT_to_HALF(npy_uint32 *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_floatbits_to_halfbits(*ip);
#if 0
        ip += 2;
#else
        ip++;
#endif
    }
}

static void
HALF_to_FLOAT(npy_half *ip, npy_uint32 *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_halfbits_to_floatbits(*ip++);
#if 0
        *op++ = 0;
#endif
    }
}


#line 963

static void
DOUBLE_to_HALF(npy_uint64 *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_doublebits_to_halfbits(*ip);
#if 0
        ip += 2;
#else
        ip++;
#endif
    }
}

static void
HALF_to_DOUBLE(npy_half *ip, npy_uint64 *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_halfbits_to_doublebits(*ip++);
#if 0
        *op++ = 0;
#endif
    }
}


#line 963

static void
CFLOAT_to_HALF(npy_uint32 *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_floatbits_to_halfbits(*ip);
#if 1
        ip += 2;
#else
        ip++;
#endif
    }
}

static void
HALF_to_CFLOAT(npy_half *ip, npy_uint32 *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_halfbits_to_floatbits(*ip++);
#if 1
        *op++ = 0;
#endif
    }
}


#line 963

static void
CDOUBLE_to_HALF(npy_uint64 *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_doublebits_to_halfbits(*ip);
#if 1
        ip += 2;
#else
        ip++;
#endif
    }
}

static void
HALF_to_CDOUBLE(npy_half *ip, npy_uint64 *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_halfbits_to_doublebits(*ip++);
#if 1
        *op++ = 0;
#endif
    }
}



static void
CLONGDOUBLE_to_HALF(npy_longdouble *ip, npy_half *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_double_to_half((double) (*ip++));
        ip += 2;
    }
}

static void
HALF_to_CLONGDOUBLE(npy_half *ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = npy_half_to_double(*ip++);
        *op++ = 0;
    }
}

#line 1025
static void
BOOL_to_BOOL(npy_bool *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
BYTE_to_BOOL(npy_byte *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
UBYTE_to_BOOL(npy_ubyte *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
SHORT_to_BOOL(npy_short *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
USHORT_to_BOOL(npy_ushort *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
INT_to_BOOL(npy_int *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
UINT_to_BOOL(npy_uint *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
LONG_to_BOOL(npy_long *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
ULONG_to_BOOL(npy_ulong *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
LONGLONG_to_BOOL(npy_longlong *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
ULONGLONG_to_BOOL(npy_ulonglong *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
FLOAT_to_BOOL(npy_float *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
DOUBLE_to_BOOL(npy_double *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
LONGDOUBLE_to_BOOL(npy_longdouble *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
DATETIME_to_BOOL(npy_datetime *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1025
static void
TIMEDELTA_to_BOOL(npy_timedelta *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}


static void
HALF_to_BOOL(npy_half *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_bool)(!npy_half_iszero(*ip++));
    }
}

#line 1049
static void
CFLOAT_to_BOOL(npy_cfloat *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op = (npy_bool)(((*ip).real != NPY_FALSE) ||
                ((*ip).imag != NPY_FALSE));
        op++;
        ip++;
    }
}

#line 1049
static void
CDOUBLE_to_BOOL(npy_cdouble *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op = (npy_bool)(((*ip).real != NPY_FALSE) ||
                ((*ip).imag != NPY_FALSE));
        op++;
        ip++;
    }
}

#line 1049
static void
CLONGDOUBLE_to_BOOL(npy_clongdouble *ip, npy_bool *op, npy_intp n,
        PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op = (npy_bool)(((*ip).real != NPY_FALSE) ||
                ((*ip).imag != NPY_FALSE));
        op++;
        ip++;
    }
}


#line 1074
static void
BOOL_to_BYTE(npy_bool *ip, npy_byte *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_byte)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_UBYTE(npy_bool *ip, npy_ubyte *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ubyte)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_SHORT(npy_bool *ip, npy_short *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_short)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_USHORT(npy_bool *ip, npy_ushort *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ushort)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_INT(npy_bool *ip, npy_int *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_int)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_UINT(npy_bool *ip, npy_uint *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_uint)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_LONG(npy_bool *ip, npy_long *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_long)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_ULONG(npy_bool *ip, npy_ulong *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulong)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_LONGLONG(npy_bool *ip, npy_longlong *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longlong)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_ULONGLONG(npy_bool *ip, npy_ulonglong *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_ulonglong)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_HALF(npy_bool *ip, npy_half *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_half)((*ip++ != NPY_FALSE) ? NPY_HALF_ONE : NPY_HALF_ZERO);
    }
}

#line 1074
static void
BOOL_to_FLOAT(npy_bool *ip, npy_float *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_DOUBLE(npy_bool *ip, npy_double *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_LONGDOUBLE(npy_bool *ip, npy_longdouble *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_DATETIME(npy_bool *ip, npy_datetime *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_datetime)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1074
static void
BOOL_to_TIMEDELTA(npy_bool *ip, npy_timedelta *op, npy_intp n,
             PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_timedelta)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}


#line 1089

#line 1102
static void
BOOL_to_CFLOAT(npy_bool *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
BYTE_to_CFLOAT(npy_byte *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
UBYTE_to_CFLOAT(npy_ubyte *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
SHORT_to_CFLOAT(npy_short *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
USHORT_to_CFLOAT(npy_ushort *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
INT_to_CFLOAT(npy_int *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
UINT_to_CFLOAT(npy_uint *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONG_to_CFLOAT(npy_long *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
ULONG_to_CFLOAT(npy_ulong *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONGLONG_to_CFLOAT(npy_longlong *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
ULONGLONG_to_CFLOAT(npy_ulonglong *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
FLOAT_to_CFLOAT(npy_float *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
DOUBLE_to_CFLOAT(npy_double *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONGDOUBLE_to_CFLOAT(npy_longdouble *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
DATETIME_to_CFLOAT(npy_datetime *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
TIMEDELTA_to_CFLOAT(npy_timedelta *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}


#line 1089

#line 1102
static void
BOOL_to_CDOUBLE(npy_bool *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
BYTE_to_CDOUBLE(npy_byte *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
UBYTE_to_CDOUBLE(npy_ubyte *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
SHORT_to_CDOUBLE(npy_short *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
USHORT_to_CDOUBLE(npy_ushort *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
INT_to_CDOUBLE(npy_int *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
UINT_to_CDOUBLE(npy_uint *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONG_to_CDOUBLE(npy_long *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
ULONG_to_CDOUBLE(npy_ulong *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONGLONG_to_CDOUBLE(npy_longlong *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
ULONGLONG_to_CDOUBLE(npy_ulonglong *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
FLOAT_to_CDOUBLE(npy_float *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
DOUBLE_to_CDOUBLE(npy_double *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONGDOUBLE_to_CDOUBLE(npy_longdouble *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
DATETIME_to_CDOUBLE(npy_datetime *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
TIMEDELTA_to_CDOUBLE(npy_timedelta *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}


#line 1089

#line 1102
static void
BOOL_to_CLONGDOUBLE(npy_bool *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
BYTE_to_CLONGDOUBLE(npy_byte *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
UBYTE_to_CLONGDOUBLE(npy_ubyte *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
SHORT_to_CLONGDOUBLE(npy_short *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
USHORT_to_CLONGDOUBLE(npy_ushort *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
INT_to_CLONGDOUBLE(npy_int *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
UINT_to_CLONGDOUBLE(npy_uint *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONG_to_CLONGDOUBLE(npy_long *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
ULONG_to_CLONGDOUBLE(npy_ulong *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONGLONG_to_CLONGDOUBLE(npy_longlong *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
ULONGLONG_to_CLONGDOUBLE(npy_ulonglong *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
FLOAT_to_CLONGDOUBLE(npy_float *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
DOUBLE_to_CLONGDOUBLE(npy_double *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
LONGDOUBLE_to_CLONGDOUBLE(npy_longdouble *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
DATETIME_to_CLONGDOUBLE(npy_datetime *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1102
static void
TIMEDELTA_to_CLONGDOUBLE(npy_timedelta *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}



#line 1120

#line 1125
static void
CFLOAT_to_CFLOAT(npy_float *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}


#line 1125
static void
CDOUBLE_to_CFLOAT(npy_double *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}


#line 1125
static void
CLONGDOUBLE_to_CFLOAT(npy_longdouble *ip, npy_float *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}



#line 1120

#line 1125
static void
CFLOAT_to_CDOUBLE(npy_float *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}


#line 1125
static void
CDOUBLE_to_CDOUBLE(npy_double *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}


#line 1125
static void
CLONGDOUBLE_to_CDOUBLE(npy_longdouble *ip, npy_double *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}



#line 1120

#line 1125
static void
CFLOAT_to_CLONGDOUBLE(npy_float *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}


#line 1125
static void
CDOUBLE_to_CLONGDOUBLE(npy_double *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}


#line 1125
static void
CLONGDOUBLE_to_CLONGDOUBLE(npy_longdouble *ip, npy_longdouble *op, npy_intp n,
               PyArrayObject *NPY_UNUSED(aip), PyArrayObject *NPY_UNUSED(aop))
{
    n <<= 1;
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}




#line 1156
static void
BOOL_to_OBJECT(npy_bool *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = BOOL_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
BYTE_to_OBJECT(npy_byte *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = BYTE_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
UBYTE_to_OBJECT(npy_ubyte *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = UBYTE_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
SHORT_to_OBJECT(npy_short *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = SHORT_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
USHORT_to_OBJECT(npy_ushort *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = USHORT_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
INT_to_OBJECT(npy_int *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = INT_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
UINT_to_OBJECT(npy_uint *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = UINT_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
LONG_to_OBJECT(npy_long *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = LONG_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
ULONG_to_OBJECT(npy_ulong *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = ULONG_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
LONGLONG_to_OBJECT(npy_longlong *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = LONGLONG_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
ULONGLONG_to_OBJECT(npy_ulonglong *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = ULONGLONG_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
HALF_to_OBJECT(npy_half *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = HALF_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
FLOAT_to_OBJECT(npy_float *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = FLOAT_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
DOUBLE_to_OBJECT(npy_double *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = DOUBLE_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
LONGDOUBLE_to_OBJECT(npy_longdouble *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = LONGDOUBLE_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
CFLOAT_to_OBJECT(npy_cfloat *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = CFLOAT_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
CDOUBLE_to_OBJECT(npy_cdouble *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = CDOUBLE_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
CLONGDOUBLE_to_OBJECT(npy_clongdouble *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = CLONGDOUBLE_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
STRING_to_OBJECT(npy_char *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = STRING_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
UNICODE_to_OBJECT(npy_char *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = UNICODE_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
VOID_to_OBJECT(npy_char *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = VOID_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
OBJECT_to_OBJECT(PyObject * *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = OBJECT_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
DATETIME_to_OBJECT(npy_datetime *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = DATETIME_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1156
static void
TIMEDELTA_to_OBJECT(npy_timedelta *ip, PyObject **op, npy_intp n,
        PyArrayObject *aip, PyArrayObject *NPY_UNUSED(aop))
{
    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = TIMEDELTA_getitem((char *)ip, aip);
        Py_XDECREF(tmp);
    }
}


#define _NPY_UNUSEDBOOL  NPY_UNUSED
#define _NPY_UNUSEDBYTE  NPY_UNUSED
#define _NPY_UNUSEDUBYTE  NPY_UNUSED
#define _NPY_UNUSEDSHORT  NPY_UNUSED
#define _NPY_UNUSEDUSHORT  NPY_UNUSED
#define _NPY_UNUSEDINT  NPY_UNUSED
#define _NPY_UNUSEDUINT  NPY_UNUSED
#define _NPY_UNUSEDLONG  NPY_UNUSED
#define _NPY_UNUSEDULONG  NPY_UNUSED
#define _NPY_UNUSEDLONGLONG  NPY_UNUSED
#define _NPY_UNUSEDULONGLONG  NPY_UNUSED
#define _NPY_UNUSEDHALF NPY_UNUSED
#define _NPY_UNUSEDFLOAT  NPY_UNUSED
#define _NPY_UNUSEDDOUBLE  NPY_UNUSED
#define _NPY_UNUSEDLONGDOUBLE  NPY_UNUSED
#define _NPY_UNUSEDCFLOAT  NPY_UNUSED
#define _NPY_UNUSEDCDOUBLE  NPY_UNUSED
#define _NPY_UNUSEDCLONGDOUBLE  NPY_UNUSED
#define _NPY_UNUSEDDATETIME  NPY_UNUSED
#define _NPY_UNUSEDTIMEDELTA  NPY_UNUSED
#define _NPY_UNUSEDHALF NPY_UNUSED
#define _NPY_UNUSEDSTRING
#define _NPY_UNUSEDVOID
#define _NPY_UNUSEDUNICODE

#line 1214
static void
OBJECT_to_BOOL(PyObject **ip, npy_bool *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDBOOL(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            BOOL_setitem(Py_False, (char *)op, aop);
        }
        else {
            BOOL_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_BYTE(PyObject **ip, npy_byte *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDBYTE(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            BYTE_setitem(Py_False, (char *)op, aop);
        }
        else {
            BYTE_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_UBYTE(PyObject **ip, npy_ubyte *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDUBYTE(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            UBYTE_setitem(Py_False, (char *)op, aop);
        }
        else {
            UBYTE_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_SHORT(PyObject **ip, npy_short *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDSHORT(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            SHORT_setitem(Py_False, (char *)op, aop);
        }
        else {
            SHORT_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_USHORT(PyObject **ip, npy_ushort *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDUSHORT(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            USHORT_setitem(Py_False, (char *)op, aop);
        }
        else {
            USHORT_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_INT(PyObject **ip, npy_int *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDINT(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            INT_setitem(Py_False, (char *)op, aop);
        }
        else {
            INT_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_UINT(PyObject **ip, npy_uint *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDUINT(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            UINT_setitem(Py_False, (char *)op, aop);
        }
        else {
            UINT_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_LONG(PyObject **ip, npy_long *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDLONG(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            LONG_setitem(Py_False, (char *)op, aop);
        }
        else {
            LONG_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_ULONG(PyObject **ip, npy_ulong *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDULONG(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            ULONG_setitem(Py_False, (char *)op, aop);
        }
        else {
            ULONG_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_LONGLONG(PyObject **ip, npy_longlong *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDLONGLONG(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            LONGLONG_setitem(Py_False, (char *)op, aop);
        }
        else {
            LONGLONG_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_ULONGLONG(PyObject **ip, npy_ulonglong *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDULONGLONG(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            ULONGLONG_setitem(Py_False, (char *)op, aop);
        }
        else {
            ULONGLONG_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_HALF(PyObject **ip, npy_half *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDHALF(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            HALF_setitem(Py_False, (char *)op, aop);
        }
        else {
            HALF_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_FLOAT(PyObject **ip, npy_float *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDFLOAT(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            FLOAT_setitem(Py_False, (char *)op, aop);
        }
        else {
            FLOAT_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_DOUBLE(PyObject **ip, npy_double *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDDOUBLE(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            DOUBLE_setitem(Py_False, (char *)op, aop);
        }
        else {
            DOUBLE_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_LONGDOUBLE(PyObject **ip, npy_longdouble *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDLONGDOUBLE(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            LONGDOUBLE_setitem(Py_False, (char *)op, aop);
        }
        else {
            LONGDOUBLE_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_CFLOAT(PyObject **ip, npy_cfloat *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDCFLOAT(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            CFLOAT_setitem(Py_False, (char *)op, aop);
        }
        else {
            CFLOAT_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_CDOUBLE(PyObject **ip, npy_cdouble *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDCDOUBLE(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            CDOUBLE_setitem(Py_False, (char *)op, aop);
        }
        else {
            CDOUBLE_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_CLONGDOUBLE(PyObject **ip, npy_clongdouble *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDCLONGDOUBLE(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            CLONGDOUBLE_setitem(Py_False, (char *)op, aop);
        }
        else {
            CLONGDOUBLE_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_STRING(PyObject **ip, npy_char *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDSTRING(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = PyArray_DESCR(aop)->elsize;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            STRING_setitem(Py_False, (char *)op, aop);
        }
        else {
            STRING_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_UNICODE(PyObject **ip, npy_char *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDUNICODE(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = PyArray_DESCR(aop)->elsize;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            UNICODE_setitem(Py_False, (char *)op, aop);
        }
        else {
            UNICODE_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_VOID(PyObject **ip, npy_char *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDVOID(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = PyArray_DESCR(aop)->elsize;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            VOID_setitem(Py_False, (char *)op, aop);
        }
        else {
            VOID_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_DATETIME(PyObject **ip, npy_datetime *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDDATETIME(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            DATETIME_setitem(Py_False, (char *)op, aop);
        }
        else {
            DATETIME_setitem(*ip, (char *)op, aop);
        }
    }
}

#line 1214
static void
OBJECT_to_TIMEDELTA(PyObject **ip, npy_timedelta *op, npy_intp n,
        PyArrayObject *_NPY_UNUSEDTIMEDELTA(aip), PyArrayObject *aop)
{
    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            TIMEDELTA_setitem(Py_False, (char *)op, aop);
        }
        else {
            TIMEDELTA_setitem(*ip, (char *)op, aop);
        }
    }
}



#line 1259

#if 1

#define IS_STRING

static void
STRING_to_BOOL(npy_char *ip, npy_bool *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (BOOL_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_BOOL(npy_char *ip, npy_bool *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (BOOL_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_BYTE(npy_char *ip, npy_byte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (BYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_BYTE(npy_char *ip, npy_byte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (BYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_UBYTE(npy_char *ip, npy_ubyte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UBYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_UBYTE(npy_char *ip, npy_ubyte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UBYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_SHORT(npy_char *ip, npy_short *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (SHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_SHORT(npy_char *ip, npy_short *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (SHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_USHORT(npy_char *ip, npy_ushort *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (USHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_USHORT(npy_char *ip, npy_ushort *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (USHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_INT(npy_char *ip, npy_int *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (INT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_INT(npy_char *ip, npy_int *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (INT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_UINT(npy_char *ip, npy_uint *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UINT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_UINT(npy_char *ip, npy_uint *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UINT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_LONG(npy_char *ip, npy_long *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_LONG(npy_char *ip, npy_long *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_ULONG(npy_char *ip, npy_ulong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (ULONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_ULONG(npy_char *ip, npy_ulong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (ULONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_LONGLONG(npy_char *ip, npy_longlong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_LONGLONG(npy_char *ip, npy_longlong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_ULONGLONG(npy_char *ip, npy_ulonglong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (ULONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_ULONGLONG(npy_char *ip, npy_ulonglong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (ULONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_HALF(npy_char *ip, npy_half *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (HALF_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_HALF(npy_char *ip, npy_half *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (HALF_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_FLOAT(npy_char *ip, npy_float *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (FLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_FLOAT(npy_char *ip, npy_float *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (FLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_DOUBLE(npy_char *ip, npy_double *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (DOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_DOUBLE(npy_char *ip, npy_double *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (DOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_LONGDOUBLE(npy_char *ip, npy_longdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_LONGDOUBLE(npy_char *ip, npy_longdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_CFLOAT(npy_char *ip, npy_cfloat *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CFLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_CFLOAT(npy_char *ip, npy_cfloat *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CFLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_CDOUBLE(npy_char *ip, npy_cdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_CDOUBLE(npy_char *ip, npy_cdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_CLONGDOUBLE(npy_char *ip, npy_clongdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CLONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_CLONGDOUBLE(npy_char *ip, npy_clongdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CLONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_STRING

static void
STRING_to_STRING(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_STRING(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_STRING

static void
STRING_to_UNICODE(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_UNICODE(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_STRING

static void
STRING_to_VOID(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_VOID(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_DATETIME(npy_char *ip, npy_datetime *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (DATETIME_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_DATETIME(npy_char *ip, npy_datetime *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (DATETIME_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_STRING

static void
STRING_to_TIMEDELTA(npy_char *ip, npy_timedelta *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (TIMEDELTA_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_STRING

#else

static void
STRING_to_TIMEDELTA(npy_char *ip, npy_timedelta *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = STRING_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (TIMEDELTA_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_BOOL(npy_char *ip, npy_bool *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (BOOL_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_BOOL(npy_char *ip, npy_bool *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (BOOL_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_BYTE(npy_char *ip, npy_byte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (BYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_BYTE(npy_char *ip, npy_byte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (BYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_UBYTE(npy_char *ip, npy_ubyte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UBYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_UBYTE(npy_char *ip, npy_ubyte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UBYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_SHORT(npy_char *ip, npy_short *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (SHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_SHORT(npy_char *ip, npy_short *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (SHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_USHORT(npy_char *ip, npy_ushort *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (USHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_USHORT(npy_char *ip, npy_ushort *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (USHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_INT(npy_char *ip, npy_int *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (INT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_INT(npy_char *ip, npy_int *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (INT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_UINT(npy_char *ip, npy_uint *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UINT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_UINT(npy_char *ip, npy_uint *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UINT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_LONG(npy_char *ip, npy_long *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_LONG(npy_char *ip, npy_long *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_ULONG(npy_char *ip, npy_ulong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (ULONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_ULONG(npy_char *ip, npy_ulong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (ULONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_LONGLONG(npy_char *ip, npy_longlong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_LONGLONG(npy_char *ip, npy_longlong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_ULONGLONG(npy_char *ip, npy_ulonglong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (ULONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_ULONGLONG(npy_char *ip, npy_ulonglong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (ULONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_HALF(npy_char *ip, npy_half *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (HALF_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_HALF(npy_char *ip, npy_half *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (HALF_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_FLOAT(npy_char *ip, npy_float *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (FLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_FLOAT(npy_char *ip, npy_float *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (FLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_DOUBLE(npy_char *ip, npy_double *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (DOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_DOUBLE(npy_char *ip, npy_double *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (DOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_LONGDOUBLE(npy_char *ip, npy_longdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_LONGDOUBLE(npy_char *ip, npy_longdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_CFLOAT(npy_char *ip, npy_cfloat *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CFLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_CFLOAT(npy_char *ip, npy_cfloat *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CFLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_CDOUBLE(npy_char *ip, npy_cdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_CDOUBLE(npy_char *ip, npy_cdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_CLONGDOUBLE(npy_char *ip, npy_clongdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CLONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_CLONGDOUBLE(npy_char *ip, npy_clongdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CLONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_UNICODE

static void
UNICODE_to_STRING(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_STRING(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_UNICODE

static void
UNICODE_to_UNICODE(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_UNICODE(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_UNICODE

static void
UNICODE_to_VOID(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_VOID(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_DATETIME(npy_char *ip, npy_datetime *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (DATETIME_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_DATETIME(npy_char *ip, npy_datetime *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (DATETIME_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 1

#define IS_UNICODE

static void
UNICODE_to_TIMEDELTA(npy_char *ip, npy_timedelta *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (TIMEDELTA_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_UNICODE

#else

static void
UNICODE_to_TIMEDELTA(npy_char *ip, npy_timedelta *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = UNICODE_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (TIMEDELTA_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_BOOL(npy_char *ip, npy_bool *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (BOOL_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_BOOL(npy_char *ip, npy_bool *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (BOOL_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_BYTE(npy_char *ip, npy_byte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (BYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_BYTE(npy_char *ip, npy_byte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (BYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_UBYTE(npy_char *ip, npy_ubyte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UBYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_UBYTE(npy_char *ip, npy_ubyte *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UBYTE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_SHORT(npy_char *ip, npy_short *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (SHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_SHORT(npy_char *ip, npy_short *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (SHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_USHORT(npy_char *ip, npy_ushort *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (USHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_USHORT(npy_char *ip, npy_ushort *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (USHORT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_INT(npy_char *ip, npy_int *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (INT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_INT(npy_char *ip, npy_int *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (INT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_UINT(npy_char *ip, npy_uint *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UINT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_UINT(npy_char *ip, npy_uint *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UINT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_LONG(npy_char *ip, npy_long *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_LONG(npy_char *ip, npy_long *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_ULONG(npy_char *ip, npy_ulong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyInt_Type.tp_new(&PyInt_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (ULONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_ULONG(npy_char *ip, npy_ulong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (ULONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_LONGLONG(npy_char *ip, npy_longlong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_LONGLONG(npy_char *ip, npy_longlong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_ULONGLONG(npy_char *ip, npy_ulonglong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (ULONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_ULONGLONG(npy_char *ip, npy_ulonglong *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (ULONGLONG_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_HALF(npy_char *ip, npy_half *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (HALF_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_HALF(npy_char *ip, npy_half *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (HALF_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_FLOAT(npy_char *ip, npy_float *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (FLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_FLOAT(npy_char *ip, npy_float *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (FLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_DOUBLE(npy_char *ip, npy_double *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (DOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_DOUBLE(npy_char *ip, npy_double *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (DOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_LONGDOUBLE(npy_char *ip, npy_longdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyFloat_Type.tp_new(&PyFloat_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (LONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_LONGDOUBLE(npy_char *ip, npy_longdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (LONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_CFLOAT(npy_char *ip, npy_cfloat *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CFLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_CFLOAT(npy_char *ip, npy_cfloat *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CFLOAT_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_CDOUBLE(npy_char *ip, npy_cdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_CDOUBLE(npy_char *ip, npy_cdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_CLONGDOUBLE(npy_char *ip, npy_clongdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (CLONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_CLONGDOUBLE(npy_char *ip, npy_clongdouble *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (CLONGDOUBLE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_STRING(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_STRING(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_UNICODE(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_UNICODE(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_VOID(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyTuple_Type.tp_new(&PyTuple_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_VOID(npy_char *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_DATETIME(npy_char *ip, npy_datetime *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (DATETIME_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_DATETIME(npy_char *ip, npy_datetime *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (DATETIME_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif


#line 1259

#if 0

#define IS_VOID

static void
VOID_to_TIMEDELTA(npy_char *ip, npy_timedelta *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL, *new;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }

#if defined(NPY_PY3K) && defined(IS_STRING)
        /* Work around some Python 3K */
        new = PyUnicode_FromEncodedObject(temp, "ascii", "strict");
        Py_DECREF(temp);
        temp = new;
        if (temp == NULL) {
            return;
        }
#endif
        /* convert from Python object to needed one */
        {
            PyObject *args;

            /* call out to the Python builtin given by convstr */
            args = Py_BuildValue("(N)", temp);
#if defined(NPY_PY3K)
#define PyInt_Type PyLong_Type
#endif
            new = PyLong_Type.tp_new(&PyLong_Type, args, NULL);
#if defined(NPY_PY3K)
#undef PyInt_Type
#endif
            Py_DECREF(args);
            temp = new;
            if (temp == NULL) {
                return;
            }
        }

        if (TIMEDELTA_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#undef IS_VOID

#else

static void
VOID_to_TIMEDELTA(npy_char *ip, npy_timedelta *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        temp = VOID_getitem((char *)ip, aip);
        if (temp == NULL) {
            return;
        }
        if (TIMEDELTA_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}

#endif




#line 1364
static void
BOOL_to_STRING(npy_bool *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = BOOL_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
BYTE_to_STRING(npy_byte *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = BYTE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
UBYTE_to_STRING(npy_ubyte *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = UBYTE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
SHORT_to_STRING(npy_short *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = SHORT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
USHORT_to_STRING(npy_ushort *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = USHORT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
INT_to_STRING(npy_int *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = INT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
UINT_to_STRING(npy_uint *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = UINT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONG_to_STRING(npy_long *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
ULONG_to_STRING(npy_ulong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = ULONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONGLONG_to_STRING(npy_longlong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONGLONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
ULONGLONG_to_STRING(npy_ulonglong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = ULONGLONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
HALF_to_STRING(npy_half *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = HALF_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
FLOAT_to_STRING(npy_float *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = FLOAT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
DOUBLE_to_STRING(npy_double *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = DOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONGDOUBLE_to_STRING(npy_longdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONGDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CFLOAT_to_STRING(npy_cfloat *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CFLOAT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CDOUBLE_to_STRING(npy_cdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CLONGDOUBLE_to_STRING(npy_clongdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CLONGDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
DATETIME_to_STRING(npy_datetime *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = DATETIME_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
TIMEDELTA_to_STRING(npy_timedelta *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = TIMEDELTA_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
BOOL_to_UNICODE(npy_bool *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = BOOL_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
BYTE_to_UNICODE(npy_byte *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = BYTE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
UBYTE_to_UNICODE(npy_ubyte *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = UBYTE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
SHORT_to_UNICODE(npy_short *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = SHORT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
USHORT_to_UNICODE(npy_ushort *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = USHORT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
INT_to_UNICODE(npy_int *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = INT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
UINT_to_UNICODE(npy_uint *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = UINT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONG_to_UNICODE(npy_long *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
ULONG_to_UNICODE(npy_ulong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = ULONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONGLONG_to_UNICODE(npy_longlong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONGLONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
ULONGLONG_to_UNICODE(npy_ulonglong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = ULONGLONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
HALF_to_UNICODE(npy_half *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = HALF_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
FLOAT_to_UNICODE(npy_float *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = FLOAT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
DOUBLE_to_UNICODE(npy_double *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = DOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONGDOUBLE_to_UNICODE(npy_longdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONGDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CFLOAT_to_UNICODE(npy_cfloat *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CFLOAT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CDOUBLE_to_UNICODE(npy_cdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CLONGDOUBLE_to_UNICODE(npy_clongdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CLONGDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
DATETIME_to_UNICODE(npy_datetime *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = DATETIME_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
TIMEDELTA_to_UNICODE(npy_timedelta *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = TIMEDELTA_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
BOOL_to_VOID(npy_bool *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = BOOL_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
BYTE_to_VOID(npy_byte *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = BYTE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
UBYTE_to_VOID(npy_ubyte *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = UBYTE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
SHORT_to_VOID(npy_short *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = SHORT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
USHORT_to_VOID(npy_ushort *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = USHORT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
INT_to_VOID(npy_int *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = INT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
UINT_to_VOID(npy_uint *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = UINT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONG_to_VOID(npy_long *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
ULONG_to_VOID(npy_ulong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = ULONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONGLONG_to_VOID(npy_longlong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONGLONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
ULONGLONG_to_VOID(npy_ulonglong *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = ULONGLONG_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
HALF_to_VOID(npy_half *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = HALF_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
FLOAT_to_VOID(npy_float *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = FLOAT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
DOUBLE_to_VOID(npy_double *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = DOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
LONGDOUBLE_to_VOID(npy_longdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = LONGDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CFLOAT_to_VOID(npy_cfloat *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CFLOAT_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CDOUBLE_to_VOID(npy_cdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
CLONGDOUBLE_to_VOID(npy_clongdouble *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = CLONGDOUBLE_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
DATETIME_to_VOID(npy_datetime *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = DATETIME_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1364
static void
TIMEDELTA_to_VOID(npy_timedelta *ip, npy_char *op, npy_intp n, PyArrayObject *aip,
             PyArrayObject *aop)
{
    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = TIMEDELTA_getitem((char *)ip, aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp,(char *)op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}




/*
 *****************************************************************************
 **                               SCAN                                      **
 *****************************************************************************
 */


/*
 * The first ignore argument is for backwards compatibility.
 * Should be removed when the API version is bumped up.
 */

#line 1409
static int
SHORT_scan(FILE *fp, npy_short *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""hd", ip);
}

#line 1409
static int
USHORT_scan(FILE *fp, npy_ushort *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""hu", ip);
}

#line 1409
static int
INT_scan(FILE *fp, npy_int *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""d", ip);
}

#line 1409
static int
UINT_scan(FILE *fp, npy_uint *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""u", ip);
}

#line 1409
static int
LONG_scan(FILE *fp, npy_long *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""ld", ip);
}

#line 1409
static int
ULONG_scan(FILE *fp, npy_ulong *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""lu", ip);
}

#line 1409
static int
LONGLONG_scan(FILE *fp, npy_longlong *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%"NPY_LONGLONG_FMT, ip);
}

#line 1409
static int
ULONGLONG_scan(FILE *fp, npy_ulonglong *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%"NPY_ULONGLONG_FMT, ip);
}


#line 1421
static int
FLOAT_scan(FILE *fp, npy_float *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = (npy_float) result;
    return ret;
}

#line 1421
static int
DOUBLE_scan(FILE *fp, npy_double *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = (npy_double) result;
    return ret;
}

#line 1421
static int
LONGDOUBLE_scan(FILE *fp, npy_longdouble *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = (npy_longdouble) result;
    return ret;
}


static int
HALF_scan(FILE *fp, npy_half *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = npy_double_to_half(result);
    return ret;
}

#line 1452
static int
BYTE_scan(FILE *fp, npy_byte *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignore2))
{
    npy_int temp;
    int num;

    num = fscanf(fp, "%""d", &temp);
    *ip = (npy_byte) temp;
    return num;
}

#line 1452
static int
UBYTE_scan(FILE *fp, npy_ubyte *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignore2))
{
    npy_uint temp;
    int num;

    num = fscanf(fp, "%""u", &temp);
    *ip = (npy_ubyte) temp;
    return num;
}


static int
BOOL_scan(FILE *fp, npy_bool *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignore2))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = (npy_bool) (result != 0.0);
    return ret;
}

#line 1482

#define CFLOAT_scan NULL


#line 1482

#define CDOUBLE_scan NULL


#line 1482

#define CLONGDOUBLE_scan NULL


#line 1482

#define OBJECT_scan NULL


#line 1482

#define STRING_scan NULL


#line 1482

#define UNICODE_scan NULL


#line 1482

#define VOID_scan NULL


#line 1482

#define DATETIME_scan NULL


#line 1482

#define TIMEDELTA_scan NULL




/*
 *****************************************************************************
 **                             FROMSTR                                     **
 *****************************************************************************
 */


#line 1505
static int
BYTE_fromstr(char *str, npy_byte *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *ip = (npy_byte) result;
    return 0;
}

#line 1505
static int
UBYTE_fromstr(char *str, npy_ubyte *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *ip = (npy_ubyte) result;
    return 0;
}

#line 1505
static int
SHORT_fromstr(char *str, npy_short *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *ip = (npy_short) result;
    return 0;
}

#line 1505
static int
USHORT_fromstr(char *str, npy_ushort *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *ip = (npy_ushort) result;
    return 0;
}

#line 1505
static int
INT_fromstr(char *str, npy_int *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *ip = (npy_int) result;
    return 0;
}

#line 1505
static int
UINT_fromstr(char *str, npy_uint *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *ip = (npy_uint) result;
    return 0;
}

#line 1505
static int
LONG_fromstr(char *str, npy_long *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *ip = (npy_long) result;
    return 0;
}

#line 1505
static int
ULONG_fromstr(char *str, npy_ulong *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *ip = (npy_ulong) result;
    return 0;
}

#line 1505
static int
LONGLONG_fromstr(char *str, npy_longlong *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *ip = (npy_longlong) result;
    return 0;
}

#line 1505
static int
ULONGLONG_fromstr(char *str, npy_ulonglong *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *ip = (npy_ulonglong) result;
    return 0;
}

#line 1505
static int
DATETIME_fromstr(char *str, npy_datetime *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *ip = (npy_datetime) result;
    return 0;
}

#line 1505
static int
TIMEDELTA_fromstr(char *str, npy_timedelta *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *ip = (npy_timedelta) result;
    return 0;
}


#line 1522
static int
FLOAT_fromstr(char *str, npy_float *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *ip = (npy_float) result;
    return 0;
}

#line 1522
static int
DOUBLE_fromstr(char *str, npy_double *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *ip = (npy_double) result;
    return 0;
}

#line 1522
static int
LONGDOUBLE_fromstr(char *str, npy_longdouble *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *ip = (npy_longdouble) result;
    return 0;
}


static int
HALF_fromstr(char *str, npy_half *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *ip = npy_double_to_half(result);
    return 0;
}

static int
BOOL_fromstr(char *str, npy_bool *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *ip = (npy_bool) (result != 0.0);
    return 0;
}

#line 1560

#define CFLOAT_fromstr NULL


#line 1560

#define CDOUBLE_fromstr NULL


#line 1560

#define CLONGDOUBLE_fromstr NULL


#line 1560

#define OBJECT_fromstr NULL


#line 1560

#define STRING_fromstr NULL


#line 1560

#define UNICODE_fromstr NULL


#line 1560

#define VOID_fromstr NULL




/*
 *****************************************************************************
 **                            COPYSWAPN                                    **
 *****************************************************************************
 */


#line 1588
static void
SHORT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_short) && dstride == sizeof(npy_short)) {
            memcpy(dst, src, n*sizeof(npy_short));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_short));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_short));
    }
}

static void
SHORT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_short));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_SHORT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_SHORT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_SHORT-1);
            nn = NPY_SIZEOF_SHORT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
USHORT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_ushort) && dstride == sizeof(npy_ushort)) {
            memcpy(dst, src, n*sizeof(npy_ushort));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_ushort));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_ushort));
    }
}

static void
USHORT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_ushort));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_SHORT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_SHORT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_SHORT-1);
            nn = NPY_SIZEOF_SHORT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
INT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_int) && dstride == sizeof(npy_int)) {
            memcpy(dst, src, n*sizeof(npy_int));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_int));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_int));
    }
}

static void
INT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_int));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_INT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_INT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_INT-1);
            nn = NPY_SIZEOF_INT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
UINT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_uint) && dstride == sizeof(npy_uint)) {
            memcpy(dst, src, n*sizeof(npy_uint));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_uint));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_uint));
    }
}

static void
UINT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_uint));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_INT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_INT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_INT-1);
            nn = NPY_SIZEOF_INT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
LONG_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_long) && dstride == sizeof(npy_long)) {
            memcpy(dst, src, n*sizeof(npy_long));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_long));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_long));
    }
}

static void
LONG_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_long));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONG == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONG == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONG-1);
            nn = NPY_SIZEOF_LONG / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
ULONG_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_ulong) && dstride == sizeof(npy_ulong)) {
            memcpy(dst, src, n*sizeof(npy_ulong));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_ulong));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_ulong));
    }
}

static void
ULONG_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_ulong));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONG == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONG == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONG-1);
            nn = NPY_SIZEOF_LONG / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
LONGLONG_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_longlong) && dstride == sizeof(npy_longlong)) {
            memcpy(dst, src, n*sizeof(npy_longlong));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_longlong));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_longlong));
    }
}

static void
LONGLONG_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_longlong));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONGLONG == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONGLONG == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONGLONG-1);
            nn = NPY_SIZEOF_LONGLONG / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
ULONGLONG_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_ulonglong) && dstride == sizeof(npy_ulonglong)) {
            memcpy(dst, src, n*sizeof(npy_ulonglong));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_ulonglong));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_ulonglong));
    }
}

static void
ULONGLONG_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_ulonglong));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONGLONG == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONGLONG == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONGLONG-1);
            nn = NPY_SIZEOF_LONGLONG / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
HALF_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_half) && dstride == sizeof(npy_half)) {
            memcpy(dst, src, n*sizeof(npy_half));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_half));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_half));
    }
}

static void
HALF_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_half));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_HALF == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_HALF == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_HALF == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_HALF == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_HALF == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_HALF == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_HALF-1);
            nn = NPY_SIZEOF_HALF / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
FLOAT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_float) && dstride == sizeof(npy_float)) {
            memcpy(dst, src, n*sizeof(npy_float));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_float));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_float));
    }
}

static void
FLOAT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_float));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_FLOAT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_FLOAT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_FLOAT-1);
            nn = NPY_SIZEOF_FLOAT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
DOUBLE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_double) && dstride == sizeof(npy_double)) {
            memcpy(dst, src, n*sizeof(npy_double));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_double));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_double));
    }
}

static void
DOUBLE_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_double));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_DOUBLE == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_DOUBLE == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_DOUBLE-1);
            nn = NPY_SIZEOF_DOUBLE / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
LONGDOUBLE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_longdouble) && dstride == sizeof(npy_longdouble)) {
            memcpy(dst, src, n*sizeof(npy_longdouble));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_longdouble));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_longdouble));
    }
}

static void
LONGDOUBLE_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_longdouble));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONGDOUBLE == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONGDOUBLE == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONGDOUBLE-1);
            nn = NPY_SIZEOF_LONGDOUBLE / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
DATETIME_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_datetime) && dstride == sizeof(npy_datetime)) {
            memcpy(dst, src, n*sizeof(npy_datetime));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_datetime));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_datetime));
    }
}

static void
DATETIME_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_datetime));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_DATETIME == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_DATETIME == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DATETIME == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DATETIME == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DATETIME == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DATETIME == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_DATETIME-1);
            nn = NPY_SIZEOF_DATETIME / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1588
static void
TIMEDELTA_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_timedelta) && dstride == sizeof(npy_timedelta)) {
            memcpy(dst, src, n*sizeof(npy_timedelta));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_timedelta));
        }
    }
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_timedelta));
    }
}

static void
TIMEDELTA_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_timedelta));
    }
    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_TIMEDELTA == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_TIMEDELTA == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_TIMEDELTA == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_TIMEDELTA == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_TIMEDELTA == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_TIMEDELTA == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_TIMEDELTA-1);
            nn = NPY_SIZEOF_TIMEDELTA / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}



#line 1681
static void
BOOL_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int NPY_UNUSED(swap), void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_bool) && dstride == sizeof(npy_bool)) {
            memcpy(dst, src, n*sizeof(npy_bool));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_bool));
        }
    }
    /* ignore swap */
}

static void
BOOL_copyswap (void *dst, void *src, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_bool));
    }
    /* ignore swap */
}


#line 1681
static void
BYTE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int NPY_UNUSED(swap), void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_byte) && dstride == sizeof(npy_byte)) {
            memcpy(dst, src, n*sizeof(npy_byte));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_byte));
        }
    }
    /* ignore swap */
}

static void
BYTE_copyswap (void *dst, void *src, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_byte));
    }
    /* ignore swap */
}


#line 1681
static void
UBYTE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int NPY_UNUSED(swap), void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        if (sstride == sizeof(npy_ubyte) && dstride == sizeof(npy_ubyte)) {
            memcpy(dst, src, n*sizeof(npy_ubyte));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                    n, sizeof(npy_ubyte));
        }
    }
    /* ignore swap */
}

static void
UBYTE_copyswap (void *dst, void *src, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{
    if (src != NULL) {
        /* copy first if needed */
        memcpy(dst, src, sizeof(npy_ubyte));
    }
    /* ignore swap */
}





#line 1718
static void
CFLOAT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        if (sstride == sizeof(npy_cfloat) && dstride == sizeof(npy_cfloat)) {
            memcpy(dst, src, n*sizeof(npy_cfloat));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride, n,
                    sizeof(npy_cfloat));
        }
    }

    if (swap) {
        _strided_byte_swap(dst, dstride, n, NPY_SIZEOF_FLOAT);
        _strided_byte_swap(((char *)dst + NPY_SIZEOF_FLOAT), dstride,
                n, NPY_SIZEOF_FLOAT);
    }
}

static void
CFLOAT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) /* copy first if needed */
        memcpy(dst, src, sizeof(npy_cfloat));

    if (swap) {
        char *a, *b, c;
        a = (char *)dst;
#if NPY_SIZEOF_FLOAT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 2;
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 4;
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 5;
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 6;
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 8;
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_FLOAT - 1);
            nn = NPY_SIZEOF_FLOAT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
            a += nn;
            b = a + (NPY_SIZEOF_FLOAT - 1);
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1718
static void
CDOUBLE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        if (sstride == sizeof(npy_cdouble) && dstride == sizeof(npy_cdouble)) {
            memcpy(dst, src, n*sizeof(npy_cdouble));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride, n,
                    sizeof(npy_cdouble));
        }
    }

    if (swap) {
        _strided_byte_swap(dst, dstride, n, NPY_SIZEOF_DOUBLE);
        _strided_byte_swap(((char *)dst + NPY_SIZEOF_DOUBLE), dstride,
                n, NPY_SIZEOF_DOUBLE);
    }
}

static void
CDOUBLE_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) /* copy first if needed */
        memcpy(dst, src, sizeof(npy_cdouble));

    if (swap) {
        char *a, *b, c;
        a = (char *)dst;
#if NPY_SIZEOF_DOUBLE == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 2;
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 4;
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 5;
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 6;
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 8;
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_DOUBLE - 1);
            nn = NPY_SIZEOF_DOUBLE / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
            a += nn;
            b = a + (NPY_SIZEOF_DOUBLE - 1);
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 1718
static void
CLONGDOUBLE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int swap, void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        /* copy first if needed */
        if (sstride == sizeof(npy_clongdouble) && dstride == sizeof(npy_clongdouble)) {
            memcpy(dst, src, n*sizeof(npy_clongdouble));
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride, n,
                    sizeof(npy_clongdouble));
        }
    }

    if (swap) {
        _strided_byte_swap(dst, dstride, n, NPY_SIZEOF_LONGDOUBLE);
        _strided_byte_swap(((char *)dst + NPY_SIZEOF_LONGDOUBLE), dstride,
                n, NPY_SIZEOF_LONGDOUBLE);
    }
}

static void
CLONGDOUBLE_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    if (src != NULL) /* copy first if needed */
        memcpy(dst, src, sizeof(npy_clongdouble));

    if (swap) {
        char *a, *b, c;
        a = (char *)dst;
#if NPY_SIZEOF_LONGDOUBLE == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 2;
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 4;
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 5;
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 6;
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 8;
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONGDOUBLE - 1);
            nn = NPY_SIZEOF_LONGDOUBLE / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
            a += nn;
            b = a + (NPY_SIZEOF_LONGDOUBLE - 1);
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}



static void
OBJECT_copyswapn(PyObject **dst, npy_intp dstride, PyObject **src,
        npy_intp sstride, npy_intp n, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{
    npy_intp i;
    if (src != NULL) {
        if (__ALIGNED(dst, sizeof(PyObject **))
                && __ALIGNED(src, sizeof(PyObject **))
                && __ALIGNED(dstride, sizeof(PyObject **))
                && __ALIGNED(sstride, sizeof(PyObject **))) {
            dstride /= sizeof(PyObject **);
            sstride /= sizeof(PyObject **);
            for (i = 0; i < n; i++) {
                Py_XINCREF(*src);
                Py_XDECREF(*dst);
                *dst = *src;
                dst += dstride;
                src += sstride;
            }
        }
        else {
            unsigned char *dstp, *srcp;
            PyObject *tmp;
            dstp = (unsigned char*)dst;
            srcp = (unsigned char*)src;
            for (i = 0; i < n; i++) {
                NPY_COPY_PYOBJECT_PTR(&tmp, srcp);
                Py_XINCREF(tmp);
                NPY_COPY_PYOBJECT_PTR(&tmp, dstp);
                Py_XDECREF(tmp);
                NPY_COPY_PYOBJECT_PTR(dstp, srcp);
                dstp += dstride;
                srcp += sstride;
            }
        }
    }
    /* ignore swap */
    return;
}

static void
OBJECT_copyswap(PyObject **dst, PyObject **src, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        if (__ALIGNED(dst,sizeof(PyObject **)) &&
                __ALIGNED(src,sizeof(PyObject **))) {
            Py_XINCREF(*src);
            Py_XDECREF(*dst);
            *dst = *src;
        }
        else {
            PyObject *tmp;
            NPY_COPY_PYOBJECT_PTR(&tmp, src);
            Py_XINCREF(tmp);
            NPY_COPY_PYOBJECT_PTR(&tmp, dst);
            Py_XDECREF(tmp);
            NPY_COPY_PYOBJECT_PTR(dst, src);
        }
    }
}

/* ignore swap */
static void
STRING_copyswapn (char *dst, npy_intp dstride, char *src, npy_intp sstride,
                  npy_intp n, int NPY_UNUSED(swap), PyArrayObject *arr)
{
    if (src != NULL && arr != NULL) {
        int itemsize = PyArray_DESCR(arr)->elsize;

        if (dstride == itemsize && sstride == itemsize) {
            memcpy(dst, src, itemsize * n);
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src, sstride, n,
                    itemsize);
        }
    }
    return;
}

/* */
static void
VOID_copyswapn (char *dst, npy_intp dstride, char *src, npy_intp sstride,
                npy_intp n, int swap, PyArrayObject *arr)
{
    if (arr == NULL) {
        return;
    }
    if (PyArray_HASFIELDS(arr)) {
        PyObject *key, *value, *title = NULL;
        PyArray_Descr *new, *descr;
        int offset;
        Py_ssize_t pos = 0;

        descr = PyArray_DESCR(arr);
        while (PyDict_Next(descr->fields, &pos, &key, &value)) {
            if NPY_TITLE_KEY(key, value) {
                continue;
            }
            if (!PyArg_ParseTuple(value, "Oi|O", &new, &offset, &title)) {
                ((PyArrayObject_fields *)arr)->descr = descr;
                return;
            }
            /*
             * TODO: temporarily modifying the array like this
             *       is bad coding style, should be changed.
             */
            ((PyArrayObject_fields *)arr)->descr = new;
            new->f->copyswapn(dst+offset, dstride,
                    (src != NULL ? src+offset : NULL),
                    sstride, n, swap, arr);
        }
        ((PyArrayObject_fields *)arr)->descr = descr;
        return;
    }
    if (swap && PyArray_DESCR(arr)->subarray != NULL) {
        PyArray_Descr *descr, *new;
        npy_intp num;
        npy_intp i;
        int subitemsize;
        char *dstptr, *srcptr;

        descr = PyArray_DESCR(arr);
        new = descr->subarray->base;
        /*
         * TODO: temporarily modifying the array like this
         *       is bad coding style, should be changed.
         */
        ((PyArrayObject_fields *)arr)->descr = new;
        dstptr = dst;
        srcptr = src;
        subitemsize = new->elsize;
        num = descr->elsize / subitemsize;
        for (i = 0; i < n; i++) {
            new->f->copyswapn(dstptr, subitemsize, srcptr,
                    subitemsize, num, swap, arr);
            dstptr += dstride;
            if (srcptr) {
                srcptr += sstride;
            }
        }
        ((PyArrayObject_fields *)arr)->descr = descr;
        return;
    }
    if (src != NULL) {
        memcpy(dst, src, PyArray_DESCR(arr)->elsize * n);
    }
    return;
}

static void
VOID_copyswap (char *dst, char *src, int swap, PyArrayObject *arr)
{
    if (arr == NULL) {
        return;
    }
    if (PyArray_HASFIELDS(arr)) {
        PyObject *key, *value, *title = NULL;
        PyArray_Descr *new, *descr;
        int offset;
        Py_ssize_t pos = 0;

        descr = PyArray_DESCR(arr);
        while (PyDict_Next(descr->fields, &pos, &key, &value)) {
            if NPY_TITLE_KEY(key, value) {
                continue;
            }
            if (!PyArg_ParseTuple(value, "Oi|O", &new, &offset, &title)) {
                ((PyArrayObject_fields *)arr)->descr = descr;
                return;
            }
            /*
             * TODO: temporarily modifying the array like this
             *       is bad coding style, should be changed.
             */
            ((PyArrayObject_fields *)arr)->descr = new;
            new->f->copyswap(dst+offset,
                    (src != NULL ? src+offset : NULL),
                    swap, arr);
        }
        ((PyArrayObject_fields *)arr)->descr = descr;
        return;
    }
    if (swap && PyArray_DESCR(arr)->subarray != NULL) {
        PyArray_Descr *descr, *new;
        npy_intp num;
        int itemsize;

        descr = PyArray_DESCR(arr);
        new = descr->subarray->base;
        /*
         * TODO: temporarily modifying the array like this
         *       is bad coding style, should be changed.
         */
        ((PyArrayObject_fields *)arr)->descr = new;
        itemsize = new->elsize;
        num = descr->elsize / itemsize;
        new->f->copyswapn(dst, itemsize, src,
                itemsize, num, swap, arr);
        ((PyArrayObject_fields *)arr)->descr = descr;
        return;
    }
    if (src != NULL) {
        memcpy(dst, src, PyArray_DESCR(arr)->elsize);
    }
    return;
}


static void
UNICODE_copyswapn (char *dst, npy_intp dstride, char *src, npy_intp sstride,
                   npy_intp n, int swap, PyArrayObject *arr)
{
    int itemsize;

    if (arr == NULL) {
        return;
    }
    itemsize = PyArray_DESCR(arr)->elsize;
    if (src != NULL) {
        if (dstride == itemsize && sstride == itemsize) {
            memcpy(dst, src, n * itemsize);
        }
        else {
            _unaligned_strided_byte_copy(dst, dstride, src,
                    sstride, n, itemsize);
        }
    }

    n *= itemsize;
    if (swap) {
        char *a, *b, c;

        /* n is the number of unicode characters to swap */
        n >>= 2;
        for (a = (char *)dst; n > 0; n--) {
            b = a + 3;
            c = *a;
            *a++ = *b;
            *b-- = c;
            c = *a;
            *a++ = *b;
            *b-- = c;
            a += 2;
        }
    }
}


static void
STRING_copyswap(char *dst, char *src, int NPY_UNUSED(swap), PyArrayObject *arr)
{
    if (src != NULL && arr != NULL) {
        memcpy(dst, src, PyArray_DESCR(arr)->elsize);
    }
}

static void
UNICODE_copyswap (char *dst, char *src, int swap, PyArrayObject *arr)
{
    int itemsize;

    if (arr == NULL) {
        return;
    }
    itemsize = PyArray_DESCR(arr)->elsize;
    if (src != NULL) {
        memcpy(dst, src, itemsize);
    }

    if (swap) {
        char *a, *b, c;
        itemsize >>= 2;
        for (a = (char *)dst; itemsize>0; itemsize--) {
            b = a + 3;
            c = *a;
            *a++ = *b;
            *b-- = c;
            c = *a;
            *a++ = *b;
            *b-- = c;
            a += 2;
        }
    }
}


/*
 *****************************************************************************
 **                                 NONZERO                                 **
 *****************************************************************************
 */

#define _NONZERO(a) ((a) != 0)

#line 2158
static npy_bool
BOOL_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_bool *ptmp = (npy_bool *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_bool tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_bool));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
BYTE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_byte *ptmp = (npy_byte *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_byte tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_byte));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
UBYTE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_ubyte *ptmp = (npy_ubyte *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_ubyte tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_ubyte));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
SHORT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_short *ptmp = (npy_short *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_short tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_short));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
USHORT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_ushort *ptmp = (npy_ushort *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_ushort tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_ushort));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
INT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_int *ptmp = (npy_int *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_int tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_int));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
UINT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_uint *ptmp = (npy_uint *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_uint tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_uint));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
LONG_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_long *ptmp = (npy_long *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_long tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_long));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
ULONG_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_ulong *ptmp = (npy_ulong *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_ulong tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_ulong));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
LONGLONG_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_longlong *ptmp = (npy_longlong *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_longlong tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_longlong));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
ULONGLONG_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_ulonglong *ptmp = (npy_ulonglong *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_ulonglong tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_ulonglong));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
HALF_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_half *ptmp = (npy_half *)ip;
        return (npy_bool) !npy_half_iszero(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_half tmp;
#if 1
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_half));
#endif
        return (npy_bool) !npy_half_iszero(tmp);
    }
}

#line 2158
static npy_bool
FLOAT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_float *ptmp = (npy_float *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_float tmp;
#if 1
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_float));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
DOUBLE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_double *ptmp = (npy_double *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_double tmp;
#if 1
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_double));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
LONGDOUBLE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_longdouble *ptmp = (npy_longdouble *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_longdouble tmp;
#if 1
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_longdouble));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
DATETIME_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_datetime *ptmp = (npy_datetime *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_datetime tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_datetime));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2158
static npy_bool
TIMEDELTA_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_timedelta *ptmp = (npy_timedelta *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_timedelta tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
#else
        memcpy(&tmp, ip, sizeof(npy_timedelta));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}


#line 2187
static npy_bool
CFLOAT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_cfloat *ptmp = (npy_cfloat *)ip;
        return (npy_bool) ((ptmp->real != 0) || (ptmp->imag != 0));
    }
    else {
        npy_cfloat tmp;
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return (npy_bool) ((tmp.real != 0) || (tmp.imag != 0));
    }
}

#line 2187
static npy_bool
CDOUBLE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_cdouble *ptmp = (npy_cdouble *)ip;
        return (npy_bool) ((ptmp->real != 0) || (ptmp->imag != 0));
    }
    else {
        npy_cdouble tmp;
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return (npy_bool) ((tmp.real != 0) || (tmp.imag != 0));
    }
}

#line 2187
static npy_bool
CLONGDOUBLE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_clongdouble *ptmp = (npy_clongdouble *)ip;
        return (npy_bool) ((ptmp->real != 0) || (ptmp->imag != 0));
    }
    else {
        npy_clongdouble tmp;
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, !PyArray_ISNOTSWAPPED(ap), ap);
        return (npy_bool) ((tmp.real != 0) || (tmp.imag != 0));
    }
}



#define WHITESPACE " \t\n\r\v\f"
#define WHITELEN 6

static npy_bool
Py_STRING_ISSPACE(char ch)
{
    char white[] = WHITESPACE;
    int j;
    npy_bool space = NPY_FALSE;

    for (j = 0; j < WHITELEN; j++) {
        if (ch == white[j]) {
            space = NPY_TRUE;
            break;
        }
    }
    return space;
}

static npy_bool
STRING_nonzero (char *ip, PyArrayObject *ap)
{
    int len = PyArray_DESCR(ap)->elsize;
    int i;
    npy_bool nonz = NPY_FALSE;

    for (i = 0; i < len; i++) {
        if (!Py_STRING_ISSPACE(*ip)) {
            nonz = NPY_TRUE;
            break;
        }
        ip++;
    }
    return nonz;
}

#ifdef Py_UNICODE_WIDE
#define PyArray_UCS4_ISSPACE Py_UNICODE_ISSPACE
#else
#define PyArray_UCS4_ISSPACE(ch) Py_STRING_ISSPACE((char)ch)
#endif

static npy_bool
UNICODE_nonzero (npy_ucs4 *ip, PyArrayObject *ap)
{
    int len = PyArray_DESCR(ap)->elsize >> 2;
    int i;
    npy_bool nonz = NPY_FALSE;
    char *buffer = NULL;

    if ((!PyArray_ISNOTSWAPPED(ap)) || (!PyArray_ISALIGNED(ap))) {
        buffer = PyArray_malloc(PyArray_DESCR(ap)->elsize);
        if (buffer == NULL) {
            return nonz;
        }
        memcpy(buffer, ip, PyArray_DESCR(ap)->elsize);
        if (!PyArray_ISNOTSWAPPED(ap)) {
            byte_swap_vector(buffer, len, 4);
        }
        ip = (npy_ucs4 *)buffer;
    }

    for (i = 0; i < len; i++) {
        if (!PyArray_UCS4_ISSPACE(*ip)) {
            nonz = NPY_TRUE;
            break;
        }
        ip++;
    }
    PyArray_free(buffer);
    return nonz;
}

static npy_bool
OBJECT_nonzero (PyObject **ip, PyArrayObject *ap)
{

    if (PyArray_ISALIGNED(ap)) {
        if (*ip == NULL) {
            return NPY_FALSE;
        }
        return (npy_bool) PyObject_IsTrue(*ip);
    }
    else {
        PyObject *obj;
        NPY_COPY_PYOBJECT_PTR(&obj, ip);
        if (obj == NULL) {
            return NPY_FALSE;
        }
        return (npy_bool) PyObject_IsTrue(obj);
    }
}

/*
 * if we have fields, then nonzero only if all sub-fields are nonzero.
 */
static npy_bool
VOID_nonzero (char *ip, PyArrayObject *ap)
{
    int i;
    int len;
    npy_bool nonz = NPY_FALSE;

    if (PyArray_HASFIELDS(ap)) {
        PyArray_Descr *descr, *new;
        PyObject *key, *value, *title;
        int savedflags, offset;
        Py_ssize_t pos = 0;

        descr = PyArray_DESCR(ap);
        savedflags = PyArray_FLAGS(ap);
        while (PyDict_Next(descr->fields, &pos, &key, &value)) {
            if NPY_TITLE_KEY(key, value) {
                continue;
            }
            if (!PyArg_ParseTuple(value, "Oi|O", &new, &offset,
                        &title)) {
                PyErr_Clear();
                continue;
            }
            /*
             * TODO: temporarily modifying the array like this
             *       is bad coding style, should be changed.
             */
            ((PyArrayObject_fields *)ap)->descr = new;
            ((PyArrayObject_fields *)ap)->flags = savedflags;
            if ((new->alignment > 1) && !__ALIGNED(ip + offset,
                        new->alignment)) {
                PyArray_CLEARFLAGS(ap, NPY_ARRAY_ALIGNED);
            }
            else {
                PyArray_ENABLEFLAGS(ap, NPY_ARRAY_ALIGNED);
            }
            if (new->f->nonzero(ip+offset, ap)) {
                nonz = NPY_TRUE;
                break;
            }
        }
        ((PyArrayObject_fields *)ap)->descr = descr;
        ((PyArrayObject_fields *)ap)->flags = savedflags;
        return nonz;
    }
    len = PyArray_DESCR(ap)->elsize;
    for (i = 0; i < len; i++) {
        if (*ip != '\0') {
            nonz = NPY_TRUE;
            break;
        }
        ip++;
    }
    return nonz;
}

#undef __ALIGNED


/*
 *****************************************************************************
 **                                 COMPARE                                 **
 *****************************************************************************
 */


/* boolean type */

static int
BOOL_compare(npy_bool *ip1, npy_bool *ip2, PyArrayObject *NPY_UNUSED(ap))
{
    return (*ip1 ? (*ip2 ? 0 : 1) : (*ip2 ? -1 : 0));
}


/* integer types */

#line 2385

static int
BYTE_compare (npy_byte *pa, npy_byte *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_byte a = *pa;
    const npy_byte b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
UBYTE_compare (npy_ubyte *pa, npy_ubyte *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_ubyte a = *pa;
    const npy_ubyte b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
SHORT_compare (npy_short *pa, npy_short *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_short a = *pa;
    const npy_short b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
USHORT_compare (npy_ushort *pa, npy_ushort *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_ushort a = *pa;
    const npy_ushort b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
INT_compare (npy_int *pa, npy_int *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_int a = *pa;
    const npy_int b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
UINT_compare (npy_uint *pa, npy_uint *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_uint a = *pa;
    const npy_uint b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
LONG_compare (npy_long *pa, npy_long *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_long a = *pa;
    const npy_long b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
ULONG_compare (npy_ulong *pa, npy_ulong *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_ulong a = *pa;
    const npy_ulong b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
LONGLONG_compare (npy_longlong *pa, npy_longlong *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_longlong a = *pa;
    const npy_longlong b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
ULONGLONG_compare (npy_ulonglong *pa, npy_ulonglong *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_ulonglong a = *pa;
    const npy_ulonglong b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
DATETIME_compare (npy_datetime *pa, npy_datetime *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_datetime a = *pa;
    const npy_datetime b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2385

static int
TIMEDELTA_compare (npy_timedelta *pa, npy_timedelta *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_timedelta a = *pa;
    const npy_timedelta b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}




/* float types */

/*
 * The real/complex comparison functions are compatible with the new sort
 * order for nans introduced in numpy 1.4.0. All nan values now compare
 * larger than non-nan values and are sorted to the end. The comparison
 * order is:
 *
 *      Real: [R, nan]
 *      Complex: [R + Rj, R + nanj, nan + Rj, nan + nanj]
 *
 *  where complex values with the same nan placements are sorted according
 *  to the non-nan part if it exists. If both the real and imaginary parts
 *  of complex types are non-nan the order is the same as the real parts
 *  unless they happen to be equal, in which case the order is that of the
 *  imaginary parts.
 */

#line 2421

#define LT(a,b) ((a) < (b) || ((b) != (b) && (a) ==(a)))

static int
FLOAT_compare(npy_float *pa, npy_float *pb)
{
    const npy_float a = *pa;
    const npy_float b = *pb;
    int ret;

    if (LT(a,b)) {
        ret = -1;
    }
    else if (LT(b,a)) {
        ret = 1;
    }
    else {
        ret = 0;
    }
    return ret;
}


static int
CFLOAT_compare(npy_float *pa, npy_float *pb)
{
    const npy_float ar = pa[0];
    const npy_float ai = pa[1];
    const npy_float br = pb[0];
    const npy_float bi = pb[1];
    int ret;

    if (ar < br) {
        if (ai == ai || bi != bi) {
            ret = -1;
        }
        else {
            ret = 1;
        }
    }
    else if (br < ar) {
        if (bi == bi || ai != ai) {
            ret = 1;
        }
        else {
            ret = -1;
        }
    }
    else if (ar == br || (ar != ar && br != br)) {
        if (LT(ai,bi)) {
            ret = -1;
        }
        else if (LT(bi,ai)) {
            ret = 1;
        }
        else {
            ret = 0;
        }
    }
    else if (ar == ar) {
        ret = -1;
    }
    else {
        ret = 1;
    }

    return ret;
}

#undef LT


#line 2421

#define LT(a,b) ((a) < (b) || ((b) != (b) && (a) ==(a)))

static int
DOUBLE_compare(npy_double *pa, npy_double *pb)
{
    const npy_double a = *pa;
    const npy_double b = *pb;
    int ret;

    if (LT(a,b)) {
        ret = -1;
    }
    else if (LT(b,a)) {
        ret = 1;
    }
    else {
        ret = 0;
    }
    return ret;
}


static int
CDOUBLE_compare(npy_double *pa, npy_double *pb)
{
    const npy_double ar = pa[0];
    const npy_double ai = pa[1];
    const npy_double br = pb[0];
    const npy_double bi = pb[1];
    int ret;

    if (ar < br) {
        if (ai == ai || bi != bi) {
            ret = -1;
        }
        else {
            ret = 1;
        }
    }
    else if (br < ar) {
        if (bi == bi || ai != ai) {
            ret = 1;
        }
        else {
            ret = -1;
        }
    }
    else if (ar == br || (ar != ar && br != br)) {
        if (LT(ai,bi)) {
            ret = -1;
        }
        else if (LT(bi,ai)) {
            ret = 1;
        }
        else {
            ret = 0;
        }
    }
    else if (ar == ar) {
        ret = -1;
    }
    else {
        ret = 1;
    }

    return ret;
}

#undef LT


#line 2421

#define LT(a,b) ((a) < (b) || ((b) != (b) && (a) ==(a)))

static int
LONGDOUBLE_compare(npy_longdouble *pa, npy_longdouble *pb)
{
    const npy_longdouble a = *pa;
    const npy_longdouble b = *pb;
    int ret;

    if (LT(a,b)) {
        ret = -1;
    }
    else if (LT(b,a)) {
        ret = 1;
    }
    else {
        ret = 0;
    }
    return ret;
}


static int
CLONGDOUBLE_compare(npy_longdouble *pa, npy_longdouble *pb)
{
    const npy_longdouble ar = pa[0];
    const npy_longdouble ai = pa[1];
    const npy_longdouble br = pb[0];
    const npy_longdouble bi = pb[1];
    int ret;

    if (ar < br) {
        if (ai == ai || bi != bi) {
            ret = -1;
        }
        else {
            ret = 1;
        }
    }
    else if (br < ar) {
        if (bi == bi || ai != ai) {
            ret = 1;
        }
        else {
            ret = -1;
        }
    }
    else if (ar == br || (ar != ar && br != br)) {
        if (LT(ai,bi)) {
            ret = -1;
        }
        else if (LT(bi,ai)) {
            ret = 1;
        }
        else {
            ret = 0;
        }
    }
    else if (ar == ar) {
        ret = -1;
    }
    else {
        ret = 1;
    }

    return ret;
}

#undef LT



static int
HALF_compare (npy_half *pa, npy_half *pb, PyArrayObject *NPY_UNUSED(ap))
{
    npy_half a = *pa, b = *pb;
    npy_bool a_isnan, b_isnan;
    int ret;

    a_isnan = npy_half_isnan(a);
    b_isnan = npy_half_isnan(b);

    if (a_isnan) {
        ret = b_isnan ? 0 : -1;
    }
    else if (b_isnan) {
        ret = 1;
    }
    else if(npy_half_lt_nonan(a, b)) {
        ret = -1;
    }
    else if(npy_half_lt_nonan(b, a)) {
        ret = 1;
    }
    else {
        ret = 0;
    }

    return ret;
}


/* object type */

static int
OBJECT_compare(PyObject **ip1, PyObject **ip2, PyArrayObject *NPY_UNUSED(ap))
{
    /*
     * ALIGNMENT NOTE: It seems that PyArray_Sort is already handling
     * the alignment of pointers, so it doesn't need to be handled
     * here.
     */
    if ((*ip1 == NULL) || (*ip2 == NULL)) {
        if (ip1 == ip2) {
            return 1;
        }
        if (ip1 == NULL) {
            return -1;
        }
        return 1;
    }
#if defined(NPY_PY3K)
    if (PyObject_RichCompareBool(*ip1, *ip2, Py_LT) == 1) {
        return -1;
    }
    else if (PyObject_RichCompareBool(*ip1, *ip2, Py_GT) == 1) {
        return 1;
    }
    else {
        return 0;
    }
#else
    return PyObject_Compare(*ip1, *ip2);
#endif
}


/* string type */

static int
STRING_compare(char *ip1, char *ip2, PyArrayObject *ap)
{
    const unsigned char *c1 = (unsigned char *)ip1;
    const unsigned char *c2 = (unsigned char *)ip2;
    const size_t len = PyArray_DESCR(ap)->elsize;
    size_t i;

    for(i = 0; i < len; ++i) {
        if (c1[i] != c2[i]) {
            return (c1[i] > c2[i]) ? 1 : -1;
        }
    }
    return 0;
}


/* unicode type */

static int
UNICODE_compare(npy_ucs4 *ip1, npy_ucs4 *ip2,
                PyArrayObject *ap)
{
    int itemsize = PyArray_DESCR(ap)->elsize;

    if (itemsize < 0) {
        return 0;
    }
    itemsize /= sizeof(npy_ucs4);
    while (itemsize-- > 0) {
        npy_ucs4 c1 = *ip1++;
        npy_ucs4 c2 = *ip2++;
        if (c1 != c2) {
            return (c1 < c2) ? -1 : 1;
        }
    }
    return 0;
}


/* void type */

/*
 * If fields are defined, then compare on first field and if equal
 * compare on second field.  Continue until done or comparison results
 * in not_equal.
 *
 * Must align data passed on to sub-comparisons.
 * Also must swap data based on to sub-comparisons.
 */
static int
VOID_compare(char *ip1, char *ip2, PyArrayObject *ap)
{
    PyArray_Descr *descr, *new;
    PyObject *names, *key;
    PyObject *tup, *title;
    char *nip1, *nip2;
    int i, offset, res = 0, swap=0;

    if (!PyArray_HASFIELDS(ap)) {
        return STRING_compare(ip1, ip2, ap);
    }
    descr = PyArray_DESCR(ap);
    /*
     * Compare on the first-field.  If equal, then
     * compare on the second-field, etc.
     */
    names = descr->names;
    for (i = 0; i < PyTuple_GET_SIZE(names); i++) {
        key = PyTuple_GET_ITEM(names, i);
        tup = PyDict_GetItem(descr->fields, key);
        if (!PyArg_ParseTuple(tup, "Oi|O", &new, &offset, &title)) {
            goto finish;
        }
        /*
         * TODO: temporarily modifying the array like this
         *       is bad coding style, should be changed.
         */
        ((PyArrayObject_fields *)ap)->descr = new;
        swap = PyArray_ISBYTESWAPPED(ap);
        nip1 = ip1 + offset;
        nip2 = ip2 + offset;
        if ((swap) || (new->alignment > 1)) {
            if ((swap) || (((npy_intp)(nip1) % new->alignment) != 0)) {
                /* create buffer and copy */
                nip1 = PyArray_malloc(new->elsize);
                if (nip1 == NULL) {
                    goto finish;
                }
                memcpy(nip1, ip1+offset, new->elsize);
                if (swap)
                    new->f->copyswap(nip1, NULL, swap, ap);
            }
            if ((swap) || (((npy_intp)(nip2) % new->alignment) != 0)) {
                /* copy data to a buffer */
                nip2 = PyArray_malloc(new->elsize);
                if (nip2 == NULL) {
                    if (nip1 != ip1 + offset) {
                        PyArray_free(nip1);
                    }
                    goto finish;
                }
                memcpy(nip2, ip2 + offset, new->elsize);
                if (swap)
                    new->f->copyswap(nip2, NULL, swap, ap);
            }
        }
        res = new->f->compare(nip1, nip2, ap);
        if ((swap) || (new->alignment > 1)) {
            if (nip1 != ip1 + offset) {
                PyArray_free(nip1);
            }
            if (nip2 != ip2 + offset) {
                PyArray_free(nip2);
            }
        }
        if (res != 0) {
            break;
        }
    }

finish:
    ((PyArrayObject_fields *)ap)->descr = descr;
    return res;
}


/*
 *****************************************************************************
 **                                 ARGFUNC                                 **
 *****************************************************************************
 */

#define _LESS_THAN_OR_EQUAL(a,b) ((a) <= (b))

#line 2716
static int
BOOL_argmax(npy_bool *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_bool mp = *ip;
#if 0
    npy_bool mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
BYTE_argmax(npy_byte *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_byte mp = *ip;
#if 0
    npy_byte mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
UBYTE_argmax(npy_ubyte *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_ubyte mp = *ip;
#if 0
    npy_ubyte mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
SHORT_argmax(npy_short *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_short mp = *ip;
#if 0
    npy_short mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
USHORT_argmax(npy_ushort *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_ushort mp = *ip;
#if 0
    npy_ushort mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
INT_argmax(npy_int *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_int mp = *ip;
#if 0
    npy_int mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
UINT_argmax(npy_uint *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_uint mp = *ip;
#if 0
    npy_uint mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
LONG_argmax(npy_long *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_long mp = *ip;
#if 0
    npy_long mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
ULONG_argmax(npy_ulong *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_ulong mp = *ip;
#if 0
    npy_ulong mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
LONGLONG_argmax(npy_longlong *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_longlong mp = *ip;
#if 0
    npy_longlong mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
ULONGLONG_argmax(npy_ulonglong *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_ulonglong mp = *ip;
#if 0
    npy_ulonglong mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
HALF_argmax(npy_half *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_half mp = *ip;
#if 0
    npy_half mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_half_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (npy_half_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_half_isnan(ip[0]) || npy_half_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_half_isnan(mp) || npy_half_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!npy_half_le(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_half_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
FLOAT_argmax(npy_float *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_float mp = *ip;
#if 0
    npy_float mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
DOUBLE_argmax(npy_double *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_double mp = *ip;
#if 0
    npy_double mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
LONGDOUBLE_argmax(npy_longdouble *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_longdouble mp = *ip;
#if 0
    npy_longdouble mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
CFLOAT_argmax(npy_float *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_float mp = *ip;
#if 1
    npy_float mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
CDOUBLE_argmax(npy_double *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_double mp = *ip;
#if 1
    npy_double mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
CLONGDOUBLE_argmax(npy_longdouble *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_longdouble mp = *ip;
#if 1
    npy_longdouble mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
DATETIME_argmax(npy_datetime *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_datetime mp = *ip;
#if 0
    npy_datetime mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2716
static int
TIMEDELTA_argmax(npy_timedelta *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_timedelta mp = *ip;
#if 0
    npy_timedelta mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}



#line 2796
static int
BOOL_argmin(npy_bool *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_bool mp = *ip;
#if 0
    npy_bool mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
BYTE_argmin(npy_byte *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_byte mp = *ip;
#if 0
    npy_byte mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
UBYTE_argmin(npy_ubyte *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_ubyte mp = *ip;
#if 0
    npy_ubyte mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
SHORT_argmin(npy_short *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_short mp = *ip;
#if 0
    npy_short mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
USHORT_argmin(npy_ushort *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_ushort mp = *ip;
#if 0
    npy_ushort mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
INT_argmin(npy_int *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_int mp = *ip;
#if 0
    npy_int mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
UINT_argmin(npy_uint *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_uint mp = *ip;
#if 0
    npy_uint mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
LONG_argmin(npy_long *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_long mp = *ip;
#if 0
    npy_long mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
ULONG_argmin(npy_ulong *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_ulong mp = *ip;
#if 0
    npy_ulong mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
LONGLONG_argmin(npy_longlong *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_longlong mp = *ip;
#if 0
    npy_longlong mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
ULONGLONG_argmin(npy_ulonglong *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_ulonglong mp = *ip;
#if 0
    npy_ulonglong mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
HALF_argmin(npy_half *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_half mp = *ip;
#if 0
    npy_half mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_half_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (npy_half_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_half_isnan(ip[0]) || npy_half_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_half_isnan(mp) || npy_half_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!npy_half_le(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_half_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
FLOAT_argmin(npy_float *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_float mp = *ip;
#if 0
    npy_float mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
DOUBLE_argmin(npy_double *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_double mp = *ip;
#if 0
    npy_double mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
LONGDOUBLE_argmin(npy_longdouble *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_longdouble mp = *ip;
#if 0
    npy_longdouble mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
CFLOAT_argmin(npy_float *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_float mp = *ip;
#if 1
    npy_float mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
CDOUBLE_argmin(npy_double *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_double mp = *ip;
#if 1
    npy_double mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
CLONGDOUBLE_argmin(npy_longdouble *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_longdouble mp = *ip;
#if 1
    npy_longdouble mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
DATETIME_argmin(npy_datetime *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_datetime mp = *ip;
#if 0
    npy_datetime mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 2796
static int
TIMEDELTA_argmin(npy_timedelta *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_timedelta mp = *ip;
#if 0
    npy_timedelta mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}



#undef _LESS_THAN_OR_EQUAL

static int
OBJECT_argmax(PyObject **ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    PyObject *mp = ip[0];

    *max_ind = 0;
    i = 1;
    while (i < n && mp == NULL) {
        mp = ip[i];
        i++;
    }
    for (; i < n; i++) {
        ip++;
#if defined(NPY_PY3K)
        if (*ip != NULL && PyObject_RichCompareBool(*ip, mp, Py_GT) == 1) {
#else
        if (*ip != NULL && PyObject_Compare(*ip, mp) > 0) {
#endif
            mp = *ip;
            *max_ind = i;
        }
    }
    return 0;
}

#line 2890
static int
STRING_argmax(npy_char *ip, npy_intp n, npy_intp *max_ind, PyArrayObject *aip)
{
    npy_intp i;
    int elsize = PyArray_DESCR(aip)->elsize;
    npy_char *mp = (npy_char *)PyArray_malloc(elsize);

    if (mp == NULL) {
        return 0;
    }
    memcpy(mp, ip, elsize);
    *max_ind = 0;
    for (i = 1; i < n; i++) {
        ip += elsize;
        if (STRING_compare(ip, mp, aip) > 0) {
            memcpy(mp, ip, elsize);
            *max_ind = i;
        }
    }
    PyArray_free(mp);
    return 0;
}


#line 2890
static int
UNICODE_argmax(npy_ucs4 *ip, npy_intp n, npy_intp *max_ind, PyArrayObject *aip)
{
    npy_intp i;
    int elsize = PyArray_DESCR(aip)->elsize;
    npy_ucs4 *mp = (npy_ucs4 *)PyArray_malloc(elsize);

    if (mp == NULL) {
        return 0;
    }
    memcpy(mp, ip, elsize);
    *max_ind = 0;
    for (i = 1; i < n; i++) {
        ip += elsize;
        if (UNICODE_compare(ip, mp, aip) > 0) {
            memcpy(mp, ip, elsize);
            *max_ind = i;
        }
    }
    PyArray_free(mp);
    return 0;
}



#define VOID_argmax NULL

static int
OBJECT_argmin(PyObject **ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    PyObject *mp = ip[0];

    *min_ind = 0;
    i = 1;
    while (i < n && mp == NULL) {
        mp = ip[i];
        i++;
    }
    for (; i < n; i++) {
        ip++;
#if defined(NPY_PY3K)
        if (*ip != NULL && PyObject_RichCompareBool(mp, *ip, Py_GT) == 1) {
#else
        if (*ip != NULL && PyObject_Compare(mp, *ip) > 0) {
#endif
            mp = *ip;
            *min_ind = i;
        }
    }
    return 0;
}

#line 2949
static int
STRING_argmin(npy_char *ip, npy_intp n, npy_intp *min_ind, PyArrayObject *aip)
{
    npy_intp i;
    int elsize = PyArray_DESCR(aip)->elsize;
    npy_char *mp = (npy_char *)PyArray_malloc(elsize);

    if (mp==NULL) return 0;
    memcpy(mp, ip, elsize);
    *min_ind = 0;
    for(i=1; i<n; i++) {
        ip += elsize;
        if (STRING_compare(mp,ip,aip) > 0) {
            memcpy(mp, ip, elsize);
            *min_ind=i;
        }
    }
    PyArray_free(mp);
    return 0;
}


#line 2949
static int
UNICODE_argmin(npy_ucs4 *ip, npy_intp n, npy_intp *min_ind, PyArrayObject *aip)
{
    npy_intp i;
    int elsize = PyArray_DESCR(aip)->elsize;
    npy_ucs4 *mp = (npy_ucs4 *)PyArray_malloc(elsize);

    if (mp==NULL) return 0;
    memcpy(mp, ip, elsize);
    *min_ind = 0;
    for(i=1; i<n; i++) {
        ip += elsize;
        if (UNICODE_compare(mp,ip,aip) > 0) {
            memcpy(mp, ip, elsize);
            *min_ind=i;
        }
    }
    PyArray_free(mp);
    return 0;
}




#define VOID_argmin NULL


/*
 *****************************************************************************
 **                                  DOT                                    **
 *****************************************************************************
 */

/*
 * dot means inner product
 */

static void
BOOL_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
         void *NPY_UNUSED(ignore))
{
    npy_bool tmp = NPY_FALSE;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        if ((*((npy_bool *)ip1) != 0) && (*((npy_bool *)ip2) != 0)) {
            tmp = NPY_TRUE;
            break;
        }
    }
    *((npy_bool *)op) = tmp;
}

#line 3017
static void
BYTE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_long tmp = (npy_long)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_long)(*((npy_byte *)ip1)) *
               (npy_long)(*((npy_byte *)ip2));
    }
    *((npy_byte *)op) = (npy_byte) tmp;
}

#line 3017
static void
UBYTE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulong tmp = (npy_ulong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulong)(*((npy_ubyte *)ip1)) *
               (npy_ulong)(*((npy_ubyte *)ip2));
    }
    *((npy_ubyte *)op) = (npy_ubyte) tmp;
}

#line 3017
static void
SHORT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_long tmp = (npy_long)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_long)(*((npy_short *)ip1)) *
               (npy_long)(*((npy_short *)ip2));
    }
    *((npy_short *)op) = (npy_short) tmp;
}

#line 3017
static void
USHORT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulong tmp = (npy_ulong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulong)(*((npy_ushort *)ip1)) *
               (npy_ulong)(*((npy_ushort *)ip2));
    }
    *((npy_ushort *)op) = (npy_ushort) tmp;
}

#line 3017
static void
INT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_long tmp = (npy_long)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_long)(*((npy_int *)ip1)) *
               (npy_long)(*((npy_int *)ip2));
    }
    *((npy_int *)op) = (npy_int) tmp;
}

#line 3017
static void
UINT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulong tmp = (npy_ulong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulong)(*((npy_uint *)ip1)) *
               (npy_ulong)(*((npy_uint *)ip2));
    }
    *((npy_uint *)op) = (npy_uint) tmp;
}

#line 3017
static void
LONG_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_long tmp = (npy_long)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_long)(*((npy_long *)ip1)) *
               (npy_long)(*((npy_long *)ip2));
    }
    *((npy_long *)op) = (npy_long) tmp;
}

#line 3017
static void
ULONG_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulong tmp = (npy_ulong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulong)(*((npy_ulong *)ip1)) *
               (npy_ulong)(*((npy_ulong *)ip2));
    }
    *((npy_ulong *)op) = (npy_ulong) tmp;
}

#line 3017
static void
LONGLONG_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_longlong tmp = (npy_longlong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_longlong)(*((npy_longlong *)ip1)) *
               (npy_longlong)(*((npy_longlong *)ip2));
    }
    *((npy_longlong *)op) = (npy_longlong) tmp;
}

#line 3017
static void
ULONGLONG_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulonglong tmp = (npy_ulonglong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulonglong)(*((npy_ulonglong *)ip1)) *
               (npy_ulonglong)(*((npy_ulonglong *)ip2));
    }
    *((npy_ulonglong *)op) = (npy_ulonglong) tmp;
}

#line 3017
static void
FLOAT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_float tmp = (npy_float)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_float)(*((npy_float *)ip1)) *
               (npy_float)(*((npy_float *)ip2));
    }
    *((npy_float *)op) = (npy_float) tmp;
}

#line 3017
static void
DOUBLE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_double tmp = (npy_double)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_double)(*((npy_double *)ip1)) *
               (npy_double)(*((npy_double *)ip2));
    }
    *((npy_double *)op) = (npy_double) tmp;
}

#line 3017
static void
LONGDOUBLE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_longdouble tmp = (npy_longdouble)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_longdouble)(*((npy_longdouble *)ip1)) *
               (npy_longdouble)(*((npy_longdouble *)ip2));
    }
    *((npy_longdouble *)op) = (npy_longdouble) tmp;
}

#line 3017
static void
DATETIME_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_datetime tmp = (npy_datetime)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_datetime)(*((npy_datetime *)ip1)) *
               (npy_datetime)(*((npy_datetime *)ip2));
    }
    *((npy_datetime *)op) = (npy_datetime) tmp;
}

#line 3017
static void
TIMEDELTA_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_timedelta tmp = (npy_timedelta)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_timedelta)(*((npy_timedelta *)ip1)) *
               (npy_timedelta)(*((npy_timedelta *)ip2));
    }
    *((npy_timedelta *)op) = (npy_timedelta) tmp;
}


static void
HALF_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    float tmp = 0.0f;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += npy_half_to_float(*((npy_half *)ip1)) *
               npy_half_to_float(*((npy_half *)ip2));
    }
    *((npy_half *)op) = npy_float_to_half(tmp);
}

#line 3051
static void CFLOAT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2,
                       char *op, npy_intp n, void *NPY_UNUSED(ignore))
{
    npy_float tmpr = (npy_float)0.0, tmpi=(npy_float)0.0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmpr += ((npy_float *)ip1)[0] * ((npy_float *)ip2)[0]
                - ((npy_float *)ip1)[1] * ((npy_float *)ip2)[1];
        tmpi += ((npy_float *)ip1)[1] * ((npy_float *)ip2)[0]
                + ((npy_float *)ip1)[0] * ((npy_float *)ip2)[1];
    }
    ((npy_float *)op)[0] = tmpr; ((npy_float *)op)[1] = tmpi;
}


#line 3051
static void CDOUBLE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2,
                       char *op, npy_intp n, void *NPY_UNUSED(ignore))
{
    npy_double tmpr = (npy_double)0.0, tmpi=(npy_double)0.0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmpr += ((npy_double *)ip1)[0] * ((npy_double *)ip2)[0]
                - ((npy_double *)ip1)[1] * ((npy_double *)ip2)[1];
        tmpi += ((npy_double *)ip1)[1] * ((npy_double *)ip2)[0]
                + ((npy_double *)ip1)[0] * ((npy_double *)ip2)[1];
    }
    ((npy_double *)op)[0] = tmpr; ((npy_double *)op)[1] = tmpi;
}


#line 3051
static void CLONGDOUBLE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2,
                       char *op, npy_intp n, void *NPY_UNUSED(ignore))
{
    npy_longdouble tmpr = (npy_longdouble)0.0, tmpi=(npy_longdouble)0.0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmpr += ((npy_longdouble *)ip1)[0] * ((npy_longdouble *)ip2)[0]
                - ((npy_longdouble *)ip1)[1] * ((npy_longdouble *)ip2)[1];
        tmpi += ((npy_longdouble *)ip1)[1] * ((npy_longdouble *)ip2)[0]
                + ((npy_longdouble *)ip1)[0] * ((npy_longdouble *)ip2)[1];
    }
    ((npy_longdouble *)op)[0] = tmpr; ((npy_longdouble *)op)[1] = tmpi;
}



static void
OBJECT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    /*
     * ALIGNMENT NOTE: np.dot, np.inner etc. enforce that the array is
     * BEHAVED before getting to this point, so unaligned pointers aren't
     * handled here.
     */
    npy_intp i;
    PyObject *tmp1, *tmp2, *tmp = NULL;
    PyObject **tmp3;
    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        if ((*((PyObject **)ip1) == NULL) || (*((PyObject **)ip2) == NULL)) {
            tmp1 = Py_False;
            Py_INCREF(Py_False);
        }
        else {
            tmp1 = PyNumber_Multiply(*((PyObject **)ip1), *((PyObject **)ip2));
            if (!tmp1) {
                Py_XDECREF(tmp);
                return;
            }
        }
        if (i == 0) {
            tmp = tmp1;
        }
        else {
            tmp2 = PyNumber_Add(tmp, tmp1);
            Py_XDECREF(tmp);
            Py_XDECREF(tmp1);
            if (!tmp2) {
                return;
            }
            tmp = tmp2;
        }
    }
    tmp3 = (PyObject**) op;
    tmp2 = *tmp3;
    *((PyObject **)op) = tmp;
    Py_XDECREF(tmp2);
}


/*
 *****************************************************************************
 **                                 FILL                                    **
 *****************************************************************************
 */


#define BOOL_fill NULL

/* this requires buffer to be filled with objects or NULL */
static void
OBJECT_fill(PyObject **buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    PyObject *start = buffer[0];
    PyObject *delta = buffer[1];
    PyObject *second;

    delta = PyNumber_Subtract(delta, start);
    if (!delta) {
        return;
    }
    second = start = PyNumber_Add(start, delta);
    if (!start) {
        goto finish;
    }
    buffer += 2;

    for (i = 2; i < length; i++, buffer++) {
        start = PyNumber_Add(start, delta);
        if (!start) {
            goto finish;
        }
        Py_XDECREF(*buffer);
        *buffer = start;
    }

finish:
    Py_XDECREF(second);
    Py_DECREF(delta);
    return;
}

#line 3166
static void
BYTE_fill(npy_byte *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_byte start = buffer[0];
    npy_byte delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
UBYTE_fill(npy_ubyte *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ubyte start = buffer[0];
    npy_ubyte delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
SHORT_fill(npy_short *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_short start = buffer[0];
    npy_short delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
USHORT_fill(npy_ushort *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ushort start = buffer[0];
    npy_ushort delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
INT_fill(npy_int *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_int start = buffer[0];
    npy_int delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
UINT_fill(npy_uint *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_uint start = buffer[0];
    npy_uint delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
LONG_fill(npy_long *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_long start = buffer[0];
    npy_long delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
ULONG_fill(npy_ulong *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ulong start = buffer[0];
    npy_ulong delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
LONGLONG_fill(npy_longlong *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_longlong start = buffer[0];
    npy_longlong delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
ULONGLONG_fill(npy_ulonglong *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ulonglong start = buffer[0];
    npy_ulonglong delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
FLOAT_fill(npy_float *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_float start = buffer[0];
    npy_float delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
DOUBLE_fill(npy_double *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_double start = buffer[0];
    npy_double delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
LONGDOUBLE_fill(npy_longdouble *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_longdouble start = buffer[0];
    npy_longdouble delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
DATETIME_fill(npy_datetime *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_datetime start = buffer[0];
    npy_datetime delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}

#line 3166
static void
TIMEDELTA_fill(npy_timedelta *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_timedelta start = buffer[0];
    npy_timedelta delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
}


static void
HALF_fill(npy_half *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    float start = npy_half_to_float(buffer[0]);
    float delta = npy_half_to_float(buffer[1]);

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = npy_float_to_half(start + i*delta);
    }
}

#line 3198
static void
CFLOAT_fill(npy_cfloat *buffer, npy_intp length, void *NPY_UNUSED(ignore))
{
    npy_intp i;
    npy_cfloat start;
    npy_cfloat delta;

    start.real = buffer->real;
    start.imag = buffer->imag;
    delta.real = buffer[1].real;
    delta.imag = buffer[1].imag;
    delta.real -= start.real;
    delta.imag -= start.imag;
    buffer += 2;
    for (i = 2; i < length; i++, buffer++) {
        buffer->real = start.real + i*delta.real;
        buffer->imag = start.imag + i*delta.imag;
    }
}

#line 3198
static void
CDOUBLE_fill(npy_cdouble *buffer, npy_intp length, void *NPY_UNUSED(ignore))
{
    npy_intp i;
    npy_cdouble start;
    npy_cdouble delta;

    start.real = buffer->real;
    start.imag = buffer->imag;
    delta.real = buffer[1].real;
    delta.imag = buffer[1].imag;
    delta.real -= start.real;
    delta.imag -= start.imag;
    buffer += 2;
    for (i = 2; i < length; i++, buffer++) {
        buffer->real = start.real + i*delta.real;
        buffer->imag = start.imag + i*delta.imag;
    }
}

#line 3198
static void
CLONGDOUBLE_fill(npy_clongdouble *buffer, npy_intp length, void *NPY_UNUSED(ignore))
{
    npy_intp i;
    npy_clongdouble start;
    npy_clongdouble delta;

    start.real = buffer->real;
    start.imag = buffer->imag;
    delta.real = buffer[1].real;
    delta.imag = buffer[1].imag;
    delta.real -= start.real;
    delta.imag -= start.imag;
    buffer += 2;
    for (i = 2; i < length; i++, buffer++) {
        buffer->real = start.real + i*delta.real;
        buffer->imag = start.imag + i*delta.imag;
    }
}



/* this requires buffer to be filled with objects or NULL */
static void
OBJECT_fillwithscalar(PyObject **buffer, npy_intp length, PyObject **value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    PyObject *val = *value;
    for (i = 0; i < length; i++) {
        Py_XINCREF(val);
        Py_XDECREF(buffer[i]);
        buffer[i] = val;
    }
}
#line 3238
static void
BOOL_fillwithscalar(npy_bool *buffer, npy_intp length, npy_bool *value,
        void *NPY_UNUSED(ignored))
{
    memset(buffer, *value, length);
}

#line 3238
static void
BYTE_fillwithscalar(npy_byte *buffer, npy_intp length, npy_byte *value,
        void *NPY_UNUSED(ignored))
{
    memset(buffer, *value, length);
}

#line 3238
static void
UBYTE_fillwithscalar(npy_ubyte *buffer, npy_intp length, npy_ubyte *value,
        void *NPY_UNUSED(ignored))
{
    memset(buffer, *value, length);
}


#line 3259
static void
SHORT_fillwithscalar(npy_short *buffer, npy_intp length, npy_short *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_short val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
USHORT_fillwithscalar(npy_ushort *buffer, npy_intp length, npy_ushort *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ushort val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
INT_fillwithscalar(npy_int *buffer, npy_intp length, npy_int *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_int val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
UINT_fillwithscalar(npy_uint *buffer, npy_intp length, npy_uint *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_uint val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
LONG_fillwithscalar(npy_long *buffer, npy_intp length, npy_long *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_long val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
ULONG_fillwithscalar(npy_ulong *buffer, npy_intp length, npy_ulong *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ulong val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
LONGLONG_fillwithscalar(npy_longlong *buffer, npy_intp length, npy_longlong *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_longlong val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
ULONGLONG_fillwithscalar(npy_ulonglong *buffer, npy_intp length, npy_ulonglong *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ulonglong val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
HALF_fillwithscalar(npy_half *buffer, npy_intp length, npy_half *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_half val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
FLOAT_fillwithscalar(npy_float *buffer, npy_intp length, npy_float *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_float val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
DOUBLE_fillwithscalar(npy_double *buffer, npy_intp length, npy_double *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_double val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
LONGDOUBLE_fillwithscalar(npy_longdouble *buffer, npy_intp length, npy_longdouble *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_longdouble val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
CFLOAT_fillwithscalar(npy_cfloat *buffer, npy_intp length, npy_cfloat *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_cfloat val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
CDOUBLE_fillwithscalar(npy_cdouble *buffer, npy_intp length, npy_cdouble *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_cdouble val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
CLONGDOUBLE_fillwithscalar(npy_clongdouble *buffer, npy_intp length, npy_clongdouble *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_clongdouble val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
DATETIME_fillwithscalar(npy_datetime *buffer, npy_intp length, npy_datetime *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_datetime val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 3259
static void
TIMEDELTA_fillwithscalar(npy_timedelta *buffer, npy_intp length, npy_timedelta *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_timedelta val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}



/*
 *****************************************************************************
 **                               FASTCLIP                                  **
 *****************************************************************************
 */

#define _LESS_THAN(a, b) ((a) < (b))
#define _GREATER_THAN(a, b) ((a) > (b))

/*
 * In fastclip, 'b' was already checked for NaN, so the half comparison
 * only needs to check 'a' for NaN.
 */

#define _HALF_LESS_THAN(a, b) (!npy_half_isnan(a) && npy_half_lt_nonan(a, b))
#define _HALF_GREATER_THAN(a, b) (!npy_half_isnan(a) && npy_half_lt_nonan(b, a))

#line 3307
static void
BOOL_fastclip(npy_bool *in, npy_intp ni, npy_bool *min, npy_bool *max, npy_bool *out)
{
    npy_intp i;
    npy_bool max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
BYTE_fastclip(npy_byte *in, npy_intp ni, npy_byte *min, npy_byte *max, npy_byte *out)
{
    npy_intp i;
    npy_byte max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
UBYTE_fastclip(npy_ubyte *in, npy_intp ni, npy_ubyte *min, npy_ubyte *max, npy_ubyte *out)
{
    npy_intp i;
    npy_ubyte max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
SHORT_fastclip(npy_short *in, npy_intp ni, npy_short *min, npy_short *max, npy_short *out)
{
    npy_intp i;
    npy_short max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
USHORT_fastclip(npy_ushort *in, npy_intp ni, npy_ushort *min, npy_ushort *max, npy_ushort *out)
{
    npy_intp i;
    npy_ushort max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
INT_fastclip(npy_int *in, npy_intp ni, npy_int *min, npy_int *max, npy_int *out)
{
    npy_intp i;
    npy_int max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
UINT_fastclip(npy_uint *in, npy_intp ni, npy_uint *min, npy_uint *max, npy_uint *out)
{
    npy_intp i;
    npy_uint max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
LONG_fastclip(npy_long *in, npy_intp ni, npy_long *min, npy_long *max, npy_long *out)
{
    npy_intp i;
    npy_long max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
ULONG_fastclip(npy_ulong *in, npy_intp ni, npy_ulong *min, npy_ulong *max, npy_ulong *out)
{
    npy_intp i;
    npy_ulong max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
LONGLONG_fastclip(npy_longlong *in, npy_intp ni, npy_longlong *min, npy_longlong *max, npy_longlong *out)
{
    npy_intp i;
    npy_longlong max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
ULONGLONG_fastclip(npy_ulonglong *in, npy_intp ni, npy_ulonglong *min, npy_ulonglong *max, npy_ulonglong *out)
{
    npy_intp i;
    npy_ulonglong max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
HALF_fastclip(npy_half *in, npy_intp ni, npy_half *min, npy_half *max, npy_half *out)
{
    npy_intp i;
    npy_half max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 1
        /* NaNs result in no clipping, so optimize the case away */
        if (npy_half_isnan(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 1
        if (npy_half_isnan(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_HALF_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_HALF_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_HALF_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_HALF_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
FLOAT_fastclip(npy_float *in, npy_intp ni, npy_float *min, npy_float *max, npy_float *out)
{
    npy_intp i;
    npy_float max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 1
        /* NaNs result in no clipping, so optimize the case away */
        if (npy_isnan(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 1
        if (npy_isnan(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
DOUBLE_fastclip(npy_double *in, npy_intp ni, npy_double *min, npy_double *max, npy_double *out)
{
    npy_intp i;
    npy_double max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 1
        /* NaNs result in no clipping, so optimize the case away */
        if (npy_isnan(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 1
        if (npy_isnan(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
LONGDOUBLE_fastclip(npy_longdouble *in, npy_intp ni, npy_longdouble *min, npy_longdouble *max, npy_longdouble *out)
{
    npy_intp i;
    npy_longdouble max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 1
        /* NaNs result in no clipping, so optimize the case away */
        if (npy_isnan(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 1
        if (npy_isnan(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
DATETIME_fastclip(npy_datetime *in, npy_intp ni, npy_datetime *min, npy_datetime *max, npy_datetime *out)
{
    npy_intp i;
    npy_datetime max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}

#line 3307
static void
TIMEDELTA_fastclip(npy_timedelta *in, npy_intp ni, npy_timedelta *min, npy_timedelta *max, npy_timedelta *out)
{
    npy_intp i;
    npy_timedelta max_val = 0, min_val = 0;

    if (max != NULL) {
        max_val = *max;
#if 0
        /* NaNs result in no clipping, so optimize the case away */
        if (nop(max_val)) {
            if (min == NULL) {
                return;
            }
            max = NULL;
        }
#endif
    }
    if (min != NULL) {
        min_val = *min;
#if 0
        if (nop(min_val)) {
            if (max == NULL) {
                return;
            }
            min = NULL;
        }
#endif
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (_GREATER_THAN(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (_LESS_THAN(in[i], min_val)) {
                out[i]   = min_val;
            }
            else if (_GREATER_THAN(in[i], max_val)) {
                out[i]   = max_val;
            }
        }
    }
}


#undef _LESS_THAN
#undef _GREATER_THAN
#undef _HALF_LESS_THAN
#undef _HALF_GREATER_THAN

#line 3373
static void
CFLOAT_fastclip(npy_cfloat *in, npy_intp ni, npy_cfloat *min, npy_cfloat *max, npy_cfloat *out)
{
    npy_intp i;
    npy_cfloat max_val, min_val;

    min_val = *min;
    max_val = *max;
    if (max != NULL) {
        max_val = *max;
    }
    if (min != NULL) {
        min_val = *min;
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (PyArray_CLT(in[i],min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (PyArray_CGT(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (PyArray_CLT(in[i], min_val)) {
                out[i] = min_val;
            }
            else if (PyArray_CGT(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
}


#line 3373
static void
CDOUBLE_fastclip(npy_cdouble *in, npy_intp ni, npy_cdouble *min, npy_cdouble *max, npy_cdouble *out)
{
    npy_intp i;
    npy_cdouble max_val, min_val;

    min_val = *min;
    max_val = *max;
    if (max != NULL) {
        max_val = *max;
    }
    if (min != NULL) {
        min_val = *min;
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (PyArray_CLT(in[i],min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (PyArray_CGT(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (PyArray_CLT(in[i], min_val)) {
                out[i] = min_val;
            }
            else if (PyArray_CGT(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
}


#line 3373
static void
CLONGDOUBLE_fastclip(npy_clongdouble *in, npy_intp ni, npy_clongdouble *min, npy_clongdouble *max, npy_clongdouble *out)
{
    npy_intp i;
    npy_clongdouble max_val, min_val;

    min_val = *min;
    max_val = *max;
    if (max != NULL) {
        max_val = *max;
    }
    if (min != NULL) {
        min_val = *min;
    }
    if (max == NULL) {
        for (i = 0; i < ni; i++) {
            if (PyArray_CLT(in[i],min_val)) {
                out[i] = min_val;
            }
        }
    }
    else if (min == NULL) {
        for (i = 0; i < ni; i++) {
            if (PyArray_CGT(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (PyArray_CLT(in[i], min_val)) {
                out[i] = min_val;
            }
            else if (PyArray_CGT(in[i], max_val)) {
                out[i] = max_val;
            }
        }
    }
}



#define OBJECT_fastclip NULL


/*
 *****************************************************************************
 **                              FASTPUTMASK                                **
 *****************************************************************************
 */


#line 3439
static void
BOOL_fastputmask(npy_bool *in, npy_bool *mask, npy_intp ni, npy_bool *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_bool s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
BYTE_fastputmask(npy_byte *in, npy_bool *mask, npy_intp ni, npy_byte *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_byte s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
UBYTE_fastputmask(npy_ubyte *in, npy_bool *mask, npy_intp ni, npy_ubyte *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_ubyte s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
SHORT_fastputmask(npy_short *in, npy_bool *mask, npy_intp ni, npy_short *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_short s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
USHORT_fastputmask(npy_ushort *in, npy_bool *mask, npy_intp ni, npy_ushort *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_ushort s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
INT_fastputmask(npy_int *in, npy_bool *mask, npy_intp ni, npy_int *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_int s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
UINT_fastputmask(npy_uint *in, npy_bool *mask, npy_intp ni, npy_uint *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_uint s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
LONG_fastputmask(npy_long *in, npy_bool *mask, npy_intp ni, npy_long *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_long s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
ULONG_fastputmask(npy_ulong *in, npy_bool *mask, npy_intp ni, npy_ulong *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_ulong s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
LONGLONG_fastputmask(npy_longlong *in, npy_bool *mask, npy_intp ni, npy_longlong *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_longlong s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
ULONGLONG_fastputmask(npy_ulonglong *in, npy_bool *mask, npy_intp ni, npy_ulonglong *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_ulonglong s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
HALF_fastputmask(npy_half *in, npy_bool *mask, npy_intp ni, npy_half *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_half s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
FLOAT_fastputmask(npy_float *in, npy_bool *mask, npy_intp ni, npy_float *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_float s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
DOUBLE_fastputmask(npy_double *in, npy_bool *mask, npy_intp ni, npy_double *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_double s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
LONGDOUBLE_fastputmask(npy_longdouble *in, npy_bool *mask, npy_intp ni, npy_longdouble *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_longdouble s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
CFLOAT_fastputmask(npy_cfloat *in, npy_bool *mask, npy_intp ni, npy_cfloat *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_cfloat s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
CDOUBLE_fastputmask(npy_cdouble *in, npy_bool *mask, npy_intp ni, npy_cdouble *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_cdouble s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
CLONGDOUBLE_fastputmask(npy_clongdouble *in, npy_bool *mask, npy_intp ni, npy_clongdouble *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_clongdouble s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
DATETIME_fastputmask(npy_datetime *in, npy_bool *mask, npy_intp ni, npy_datetime *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_datetime s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}

#line 3439
static void
TIMEDELTA_fastputmask(npy_timedelta *in, npy_bool *mask, npy_intp ni, npy_timedelta *vals,
        npy_intp nv)
{
    npy_intp i;
    npy_timedelta s_val;

    if (nv == 1) {
        s_val = *vals;
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = s_val;
            }
        }
    }
    else {
        for (i = 0; i < ni; i++) {
            if (mask[i]) {
                in[i] = vals[i%nv];
            }
        }
    }
    return;
}


#define OBJECT_fastputmask NULL


/*
 *****************************************************************************
 **                                FASTTAKE                                 **
 *****************************************************************************
 */


#line 3490
static int
BOOL_fasttake(npy_bool *dest, npy_bool *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
BYTE_fasttake(npy_byte *dest, npy_byte *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
UBYTE_fasttake(npy_ubyte *dest, npy_ubyte *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
SHORT_fasttake(npy_short *dest, npy_short *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
USHORT_fasttake(npy_ushort *dest, npy_ushort *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
INT_fasttake(npy_int *dest, npy_int *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
UINT_fasttake(npy_uint *dest, npy_uint *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
LONG_fasttake(npy_long *dest, npy_long *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
ULONG_fasttake(npy_ulong *dest, npy_ulong *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
LONGLONG_fasttake(npy_longlong *dest, npy_longlong *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
ULONGLONG_fasttake(npy_ulonglong *dest, npy_ulonglong *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
HALF_fasttake(npy_half *dest, npy_half *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
FLOAT_fasttake(npy_float *dest, npy_float *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
DOUBLE_fasttake(npy_double *dest, npy_double *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
LONGDOUBLE_fasttake(npy_longdouble *dest, npy_longdouble *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
CFLOAT_fasttake(npy_cfloat *dest, npy_cfloat *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
CDOUBLE_fasttake(npy_cdouble *dest, npy_cdouble *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
CLONGDOUBLE_fasttake(npy_clongdouble *dest, npy_clongdouble *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
DATETIME_fasttake(npy_datetime *dest, npy_datetime *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}

#line 3490
static int
TIMEDELTA_fasttake(npy_timedelta *dest, npy_timedelta *src, npy_intp *indarray,
                    npy_intp nindarray, npy_intp n_outer,
                    npy_intp m_middle, npy_intp nelem,
                    NPY_CLIPMODE clipmode)
{
    npy_intp i, j, k, tmp;

    switch(clipmode) {
    case NPY_RAISE:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                /* We don't know what axis we're operating on, so don't report it in case of an error. */
                if (check_and_adjust_index(&tmp, nindarray, -1) < 0)
                    return 1;
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_WRAP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    while (tmp < 0) {
                        tmp += nindarray;
                    }
                }
                else if (tmp >= nindarray) {
                    while (tmp >= nindarray) {
                        tmp -= nindarray;
                    }
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src+tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src+tmp*nelem+k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    case NPY_CLIP:
        for (i = 0; i < n_outer; i++) {
            for (j = 0; j < m_middle; j++) {
                tmp = indarray[j];
                if (tmp < 0) {
                    tmp = 0;
                }
                else if (tmp >= nindarray) {
                    tmp = nindarray - 1;
                }
                if (NPY_LIKELY(nelem == 1)) {
                    *dest++ = *(src + tmp);
                }
                else {
                    for (k = 0; k < nelem; k++) {
                        *dest++ = *(src + tmp*nelem + k);
                    }
                }
            }
            src += nelem*nindarray;
        }
        break;
    }
    return 0;
}


#define OBJECT_fasttake NULL


/*
 *****************************************************************************
 **                       SETUP FUNCTION POINTERS                           **
 *****************************************************************************
 */


#define _ALIGN(type) offsetof(struct {char c; type v;}, v)
/*
 * Disable harmless compiler warning "4116: unnamed type definition in
 * parentheses" which is caused by the _ALIGN macro.
 */
#if defined(_MSC_VER)
#pragma warning(disable:4116)
#endif


#line 3600
static PyArray_ArrFuncs _PyVoid_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)VOID_to_BOOL,
        (PyArray_VectorUnaryFunc*)VOID_to_BYTE,
        (PyArray_VectorUnaryFunc*)VOID_to_UBYTE,
        (PyArray_VectorUnaryFunc*)VOID_to_SHORT,
        (PyArray_VectorUnaryFunc*)VOID_to_USHORT,
        (PyArray_VectorUnaryFunc*)VOID_to_INT,
        (PyArray_VectorUnaryFunc*)VOID_to_UINT,
        (PyArray_VectorUnaryFunc*)VOID_to_LONG,
        (PyArray_VectorUnaryFunc*)VOID_to_ULONG,
        (PyArray_VectorUnaryFunc*)VOID_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)VOID_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)VOID_to_FLOAT,
        (PyArray_VectorUnaryFunc*)VOID_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)VOID_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)VOID_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)VOID_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)VOID_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)VOID_to_OBJECT,
        (PyArray_VectorUnaryFunc*)VOID_to_STRING,
        (PyArray_VectorUnaryFunc*)VOID_to_UNICODE,
        (PyArray_VectorUnaryFunc*)VOID_to_VOID
    },
    (PyArray_GetItemFunc*)VOID_getitem,
    (PyArray_SetItemFunc*)VOID_setitem,
    (PyArray_CopySwapNFunc*)VOID_copyswapn,
    (PyArray_CopySwapFunc*)VOID_copyswap,
    (PyArray_CompareFunc*)VOID_compare,
    (PyArray_ArgFunc*)VOID_argmax,
    (PyArray_DotFunc*)NULL,
    (PyArray_ScanFunc*)VOID_scan,
    (PyArray_FromStrFunc*)VOID_fromstr,
    (PyArray_NonzeroFunc*)VOID_nonzero,
    (PyArray_FillFunc*)NULL,
    (PyArray_FillWithScalarFunc*)NULL,
#if 0
    {
        (PyArray_SortFunc *)quicksort_void,
        (PyArray_SortFunc *)heapsort_void,
        (PyArray_SortFunc *)mergesort_void
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_void,
        (PyArray_ArgSortFunc *)aheapsort_void,
        (PyArray_ArgSortFunc *)amergesort_void
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc *)NULL,
    (PyArray_FastPutmaskFunc *)NULL,
    (PyArray_FastTakeFunc *)NULL,
    (PyArray_ArgFunc*)VOID_argmin
};

/*
 * FIXME: check for PY3K
 */
static PyArray_Descr VOID_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyVoidArrType_Type,
    /* kind */
    NPY_VOIDLTR,
    /* type */
    NPY_VOIDLTR,
    /* byteorder */
    '|',
    /* flags */
    0,
    /* type_num */
    NPY_VOID,
    /* elsize */
    0,
    /* alignment */
    _ALIGN(char),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyVoid_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3600
static PyArray_ArrFuncs _PyString_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)STRING_to_BOOL,
        (PyArray_VectorUnaryFunc*)STRING_to_BYTE,
        (PyArray_VectorUnaryFunc*)STRING_to_UBYTE,
        (PyArray_VectorUnaryFunc*)STRING_to_SHORT,
        (PyArray_VectorUnaryFunc*)STRING_to_USHORT,
        (PyArray_VectorUnaryFunc*)STRING_to_INT,
        (PyArray_VectorUnaryFunc*)STRING_to_UINT,
        (PyArray_VectorUnaryFunc*)STRING_to_LONG,
        (PyArray_VectorUnaryFunc*)STRING_to_ULONG,
        (PyArray_VectorUnaryFunc*)STRING_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)STRING_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)STRING_to_FLOAT,
        (PyArray_VectorUnaryFunc*)STRING_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)STRING_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)STRING_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)STRING_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)STRING_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)STRING_to_OBJECT,
        (PyArray_VectorUnaryFunc*)STRING_to_STRING,
        (PyArray_VectorUnaryFunc*)STRING_to_UNICODE,
        (PyArray_VectorUnaryFunc*)STRING_to_VOID
    },
    (PyArray_GetItemFunc*)STRING_getitem,
    (PyArray_SetItemFunc*)STRING_setitem,
    (PyArray_CopySwapNFunc*)STRING_copyswapn,
    (PyArray_CopySwapFunc*)STRING_copyswap,
    (PyArray_CompareFunc*)STRING_compare,
    (PyArray_ArgFunc*)STRING_argmax,
    (PyArray_DotFunc*)NULL,
    (PyArray_ScanFunc*)STRING_scan,
    (PyArray_FromStrFunc*)STRING_fromstr,
    (PyArray_NonzeroFunc*)STRING_nonzero,
    (PyArray_FillFunc*)NULL,
    (PyArray_FillWithScalarFunc*)NULL,
#if 1
    {
        (PyArray_SortFunc *)quicksort_string,
        (PyArray_SortFunc *)heapsort_string,
        (PyArray_SortFunc *)mergesort_string
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_string,
        (PyArray_ArgSortFunc *)aheapsort_string,
        (PyArray_ArgSortFunc *)amergesort_string
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc *)NULL,
    (PyArray_FastPutmaskFunc *)NULL,
    (PyArray_FastTakeFunc *)NULL,
    (PyArray_ArgFunc*)STRING_argmin
};

/*
 * FIXME: check for PY3K
 */
static PyArray_Descr STRING_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyStringArrType_Type,
    /* kind */
    NPY_STRINGLTR,
    /* type */
    NPY_STRINGLTR,
    /* byteorder */
    '|',
    /* flags */
    0,
    /* type_num */
    NPY_STRING,
    /* elsize */
    0,
    /* alignment */
    _ALIGN(char),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyString_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3600
static PyArray_ArrFuncs _PyUnicode_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)UNICODE_to_BOOL,
        (PyArray_VectorUnaryFunc*)UNICODE_to_BYTE,
        (PyArray_VectorUnaryFunc*)UNICODE_to_UBYTE,
        (PyArray_VectorUnaryFunc*)UNICODE_to_SHORT,
        (PyArray_VectorUnaryFunc*)UNICODE_to_USHORT,
        (PyArray_VectorUnaryFunc*)UNICODE_to_INT,
        (PyArray_VectorUnaryFunc*)UNICODE_to_UINT,
        (PyArray_VectorUnaryFunc*)UNICODE_to_LONG,
        (PyArray_VectorUnaryFunc*)UNICODE_to_ULONG,
        (PyArray_VectorUnaryFunc*)UNICODE_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)UNICODE_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)UNICODE_to_FLOAT,
        (PyArray_VectorUnaryFunc*)UNICODE_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)UNICODE_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)UNICODE_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)UNICODE_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)UNICODE_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)UNICODE_to_OBJECT,
        (PyArray_VectorUnaryFunc*)UNICODE_to_STRING,
        (PyArray_VectorUnaryFunc*)UNICODE_to_UNICODE,
        (PyArray_VectorUnaryFunc*)UNICODE_to_VOID
    },
    (PyArray_GetItemFunc*)UNICODE_getitem,
    (PyArray_SetItemFunc*)UNICODE_setitem,
    (PyArray_CopySwapNFunc*)UNICODE_copyswapn,
    (PyArray_CopySwapFunc*)UNICODE_copyswap,
    (PyArray_CompareFunc*)UNICODE_compare,
    (PyArray_ArgFunc*)UNICODE_argmax,
    (PyArray_DotFunc*)NULL,
    (PyArray_ScanFunc*)UNICODE_scan,
    (PyArray_FromStrFunc*)UNICODE_fromstr,
    (PyArray_NonzeroFunc*)UNICODE_nonzero,
    (PyArray_FillFunc*)NULL,
    (PyArray_FillWithScalarFunc*)NULL,
#if 1
    {
        (PyArray_SortFunc *)quicksort_unicode,
        (PyArray_SortFunc *)heapsort_unicode,
        (PyArray_SortFunc *)mergesort_unicode
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_unicode,
        (PyArray_ArgSortFunc *)aheapsort_unicode,
        (PyArray_ArgSortFunc *)amergesort_unicode
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc *)NULL,
    (PyArray_FastPutmaskFunc *)NULL,
    (PyArray_FastTakeFunc *)NULL,
    (PyArray_ArgFunc*)UNICODE_argmin
};

/*
 * FIXME: check for PY3K
 */
static PyArray_Descr UNICODE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyUnicodeArrType_Type,
    /* kind */
    NPY_UNICODELTR,
    /* type */
    NPY_UNICODELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_UNICODE,
    /* elsize */
    0,
    /* alignment */
    _ALIGN(npy_ucs4),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyUnicode_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};



#line 3739

static PyArray_ArrFuncs _PyBool_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)BOOL_to_BOOL,
        (PyArray_VectorUnaryFunc*)BOOL_to_BYTE,
        (PyArray_VectorUnaryFunc*)BOOL_to_UBYTE,
        (PyArray_VectorUnaryFunc*)BOOL_to_SHORT,
        (PyArray_VectorUnaryFunc*)BOOL_to_USHORT,
        (PyArray_VectorUnaryFunc*)BOOL_to_INT,
        (PyArray_VectorUnaryFunc*)BOOL_to_UINT,
        (PyArray_VectorUnaryFunc*)BOOL_to_LONG,
        (PyArray_VectorUnaryFunc*)BOOL_to_ULONG,
        (PyArray_VectorUnaryFunc*)BOOL_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)BOOL_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)BOOL_to_FLOAT,
        (PyArray_VectorUnaryFunc*)BOOL_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)BOOL_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)BOOL_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)BOOL_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)BOOL_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)BOOL_to_OBJECT,
        (PyArray_VectorUnaryFunc*)BOOL_to_STRING,
        (PyArray_VectorUnaryFunc*)BOOL_to_UNICODE,
        (PyArray_VectorUnaryFunc*)BOOL_to_VOID
    },
    (PyArray_GetItemFunc*)BOOL_getitem,
    (PyArray_SetItemFunc*)BOOL_setitem,
    (PyArray_CopySwapNFunc*)BOOL_copyswapn,
    (PyArray_CopySwapFunc*)BOOL_copyswap,
    (PyArray_CompareFunc*)BOOL_compare,
    (PyArray_ArgFunc*)BOOL_argmax,
    (PyArray_DotFunc*)BOOL_dot,
    (PyArray_ScanFunc*)BOOL_scan,
    (PyArray_FromStrFunc*)BOOL_fromstr,
    (PyArray_NonzeroFunc*)BOOL_nonzero,
    (PyArray_FillFunc*)BOOL_fill,
    (PyArray_FillWithScalarFunc*)BOOL_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_bool,
        (PyArray_SortFunc *)heapsort_bool,
        (PyArray_SortFunc *)mergesort_bool
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_bool,
        (PyArray_ArgSortFunc *)aheapsort_bool,
        (PyArray_ArgSortFunc *)amergesort_bool
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)BOOL_fastclip,
    (PyArray_FastPutmaskFunc*)BOOL_fastputmask,
    (PyArray_FastTakeFunc*)BOOL_fasttake,
    (PyArray_ArgFunc*)BOOL_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr BOOL_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyBoolArrType_Type,
    /* kind */
    NPY_GENBOOLLTR,
    /* type */
    NPY_BOOLLTR,
    /* byteorder */
    '|',
    /* flags */
    0,
    /* type_num */
    NPY_BOOL,
    /* elsize */
    1 * sizeof(npy_bool),
    /* alignment */
    1 * _ALIGN(npy_bool),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyBool_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyByte_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)BYTE_to_BOOL,
        (PyArray_VectorUnaryFunc*)BYTE_to_BYTE,
        (PyArray_VectorUnaryFunc*)BYTE_to_UBYTE,
        (PyArray_VectorUnaryFunc*)BYTE_to_SHORT,
        (PyArray_VectorUnaryFunc*)BYTE_to_USHORT,
        (PyArray_VectorUnaryFunc*)BYTE_to_INT,
        (PyArray_VectorUnaryFunc*)BYTE_to_UINT,
        (PyArray_VectorUnaryFunc*)BYTE_to_LONG,
        (PyArray_VectorUnaryFunc*)BYTE_to_ULONG,
        (PyArray_VectorUnaryFunc*)BYTE_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)BYTE_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)BYTE_to_FLOAT,
        (PyArray_VectorUnaryFunc*)BYTE_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)BYTE_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)BYTE_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)BYTE_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)BYTE_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)BYTE_to_OBJECT,
        (PyArray_VectorUnaryFunc*)BYTE_to_STRING,
        (PyArray_VectorUnaryFunc*)BYTE_to_UNICODE,
        (PyArray_VectorUnaryFunc*)BYTE_to_VOID
    },
    (PyArray_GetItemFunc*)BYTE_getitem,
    (PyArray_SetItemFunc*)BYTE_setitem,
    (PyArray_CopySwapNFunc*)BYTE_copyswapn,
    (PyArray_CopySwapFunc*)BYTE_copyswap,
    (PyArray_CompareFunc*)BYTE_compare,
    (PyArray_ArgFunc*)BYTE_argmax,
    (PyArray_DotFunc*)BYTE_dot,
    (PyArray_ScanFunc*)BYTE_scan,
    (PyArray_FromStrFunc*)BYTE_fromstr,
    (PyArray_NonzeroFunc*)BYTE_nonzero,
    (PyArray_FillFunc*)BYTE_fill,
    (PyArray_FillWithScalarFunc*)BYTE_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_byte,
        (PyArray_SortFunc *)heapsort_byte,
        (PyArray_SortFunc *)mergesort_byte
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_byte,
        (PyArray_ArgSortFunc *)aheapsort_byte,
        (PyArray_ArgSortFunc *)amergesort_byte
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)BYTE_fastclip,
    (PyArray_FastPutmaskFunc*)BYTE_fastputmask,
    (PyArray_FastTakeFunc*)BYTE_fasttake,
    (PyArray_ArgFunc*)BYTE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr BYTE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyByteArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_BYTELTR,
    /* byteorder */
    '|',
    /* flags */
    0,
    /* type_num */
    NPY_BYTE,
    /* elsize */
    1 * sizeof(npy_byte),
    /* alignment */
    1 * _ALIGN(npy_byte),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyByte_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyUByte_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)UBYTE_to_BOOL,
        (PyArray_VectorUnaryFunc*)UBYTE_to_BYTE,
        (PyArray_VectorUnaryFunc*)UBYTE_to_UBYTE,
        (PyArray_VectorUnaryFunc*)UBYTE_to_SHORT,
        (PyArray_VectorUnaryFunc*)UBYTE_to_USHORT,
        (PyArray_VectorUnaryFunc*)UBYTE_to_INT,
        (PyArray_VectorUnaryFunc*)UBYTE_to_UINT,
        (PyArray_VectorUnaryFunc*)UBYTE_to_LONG,
        (PyArray_VectorUnaryFunc*)UBYTE_to_ULONG,
        (PyArray_VectorUnaryFunc*)UBYTE_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)UBYTE_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)UBYTE_to_FLOAT,
        (PyArray_VectorUnaryFunc*)UBYTE_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)UBYTE_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)UBYTE_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)UBYTE_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)UBYTE_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)UBYTE_to_OBJECT,
        (PyArray_VectorUnaryFunc*)UBYTE_to_STRING,
        (PyArray_VectorUnaryFunc*)UBYTE_to_UNICODE,
        (PyArray_VectorUnaryFunc*)UBYTE_to_VOID
    },
    (PyArray_GetItemFunc*)UBYTE_getitem,
    (PyArray_SetItemFunc*)UBYTE_setitem,
    (PyArray_CopySwapNFunc*)UBYTE_copyswapn,
    (PyArray_CopySwapFunc*)UBYTE_copyswap,
    (PyArray_CompareFunc*)UBYTE_compare,
    (PyArray_ArgFunc*)UBYTE_argmax,
    (PyArray_DotFunc*)UBYTE_dot,
    (PyArray_ScanFunc*)UBYTE_scan,
    (PyArray_FromStrFunc*)UBYTE_fromstr,
    (PyArray_NonzeroFunc*)UBYTE_nonzero,
    (PyArray_FillFunc*)UBYTE_fill,
    (PyArray_FillWithScalarFunc*)UBYTE_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_ubyte,
        (PyArray_SortFunc *)heapsort_ubyte,
        (PyArray_SortFunc *)mergesort_ubyte
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_ubyte,
        (PyArray_ArgSortFunc *)aheapsort_ubyte,
        (PyArray_ArgSortFunc *)amergesort_ubyte
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)UBYTE_fastclip,
    (PyArray_FastPutmaskFunc*)UBYTE_fastputmask,
    (PyArray_FastTakeFunc*)UBYTE_fasttake,
    (PyArray_ArgFunc*)UBYTE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr UBYTE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyUByteArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_UBYTELTR,
    /* byteorder */
    '|',
    /* flags */
    0,
    /* type_num */
    NPY_UBYTE,
    /* elsize */
    1 * sizeof(npy_ubyte),
    /* alignment */
    1 * _ALIGN(npy_ubyte),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyUByte_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyShort_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)SHORT_to_BOOL,
        (PyArray_VectorUnaryFunc*)SHORT_to_BYTE,
        (PyArray_VectorUnaryFunc*)SHORT_to_UBYTE,
        (PyArray_VectorUnaryFunc*)SHORT_to_SHORT,
        (PyArray_VectorUnaryFunc*)SHORT_to_USHORT,
        (PyArray_VectorUnaryFunc*)SHORT_to_INT,
        (PyArray_VectorUnaryFunc*)SHORT_to_UINT,
        (PyArray_VectorUnaryFunc*)SHORT_to_LONG,
        (PyArray_VectorUnaryFunc*)SHORT_to_ULONG,
        (PyArray_VectorUnaryFunc*)SHORT_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)SHORT_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)SHORT_to_FLOAT,
        (PyArray_VectorUnaryFunc*)SHORT_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)SHORT_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)SHORT_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)SHORT_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)SHORT_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)SHORT_to_OBJECT,
        (PyArray_VectorUnaryFunc*)SHORT_to_STRING,
        (PyArray_VectorUnaryFunc*)SHORT_to_UNICODE,
        (PyArray_VectorUnaryFunc*)SHORT_to_VOID
    },
    (PyArray_GetItemFunc*)SHORT_getitem,
    (PyArray_SetItemFunc*)SHORT_setitem,
    (PyArray_CopySwapNFunc*)SHORT_copyswapn,
    (PyArray_CopySwapFunc*)SHORT_copyswap,
    (PyArray_CompareFunc*)SHORT_compare,
    (PyArray_ArgFunc*)SHORT_argmax,
    (PyArray_DotFunc*)SHORT_dot,
    (PyArray_ScanFunc*)SHORT_scan,
    (PyArray_FromStrFunc*)SHORT_fromstr,
    (PyArray_NonzeroFunc*)SHORT_nonzero,
    (PyArray_FillFunc*)SHORT_fill,
    (PyArray_FillWithScalarFunc*)SHORT_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_short,
        (PyArray_SortFunc *)heapsort_short,
        (PyArray_SortFunc *)mergesort_short
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_short,
        (PyArray_ArgSortFunc *)aheapsort_short,
        (PyArray_ArgSortFunc *)amergesort_short
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)SHORT_fastclip,
    (PyArray_FastPutmaskFunc*)SHORT_fastputmask,
    (PyArray_FastTakeFunc*)SHORT_fasttake,
    (PyArray_ArgFunc*)SHORT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr SHORT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyShortArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_SHORTLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_SHORT,
    /* elsize */
    1 * sizeof(npy_short),
    /* alignment */
    1 * _ALIGN(npy_short),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyShort_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyUShort_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)USHORT_to_BOOL,
        (PyArray_VectorUnaryFunc*)USHORT_to_BYTE,
        (PyArray_VectorUnaryFunc*)USHORT_to_UBYTE,
        (PyArray_VectorUnaryFunc*)USHORT_to_SHORT,
        (PyArray_VectorUnaryFunc*)USHORT_to_USHORT,
        (PyArray_VectorUnaryFunc*)USHORT_to_INT,
        (PyArray_VectorUnaryFunc*)USHORT_to_UINT,
        (PyArray_VectorUnaryFunc*)USHORT_to_LONG,
        (PyArray_VectorUnaryFunc*)USHORT_to_ULONG,
        (PyArray_VectorUnaryFunc*)USHORT_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)USHORT_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)USHORT_to_FLOAT,
        (PyArray_VectorUnaryFunc*)USHORT_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)USHORT_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)USHORT_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)USHORT_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)USHORT_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)USHORT_to_OBJECT,
        (PyArray_VectorUnaryFunc*)USHORT_to_STRING,
        (PyArray_VectorUnaryFunc*)USHORT_to_UNICODE,
        (PyArray_VectorUnaryFunc*)USHORT_to_VOID
    },
    (PyArray_GetItemFunc*)USHORT_getitem,
    (PyArray_SetItemFunc*)USHORT_setitem,
    (PyArray_CopySwapNFunc*)USHORT_copyswapn,
    (PyArray_CopySwapFunc*)USHORT_copyswap,
    (PyArray_CompareFunc*)USHORT_compare,
    (PyArray_ArgFunc*)USHORT_argmax,
    (PyArray_DotFunc*)USHORT_dot,
    (PyArray_ScanFunc*)USHORT_scan,
    (PyArray_FromStrFunc*)USHORT_fromstr,
    (PyArray_NonzeroFunc*)USHORT_nonzero,
    (PyArray_FillFunc*)USHORT_fill,
    (PyArray_FillWithScalarFunc*)USHORT_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_ushort,
        (PyArray_SortFunc *)heapsort_ushort,
        (PyArray_SortFunc *)mergesort_ushort
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_ushort,
        (PyArray_ArgSortFunc *)aheapsort_ushort,
        (PyArray_ArgSortFunc *)amergesort_ushort
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)USHORT_fastclip,
    (PyArray_FastPutmaskFunc*)USHORT_fastputmask,
    (PyArray_FastTakeFunc*)USHORT_fasttake,
    (PyArray_ArgFunc*)USHORT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr USHORT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyUShortArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_USHORTLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_USHORT,
    /* elsize */
    1 * sizeof(npy_ushort),
    /* alignment */
    1 * _ALIGN(npy_ushort),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyUShort_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyInt_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)INT_to_BOOL,
        (PyArray_VectorUnaryFunc*)INT_to_BYTE,
        (PyArray_VectorUnaryFunc*)INT_to_UBYTE,
        (PyArray_VectorUnaryFunc*)INT_to_SHORT,
        (PyArray_VectorUnaryFunc*)INT_to_USHORT,
        (PyArray_VectorUnaryFunc*)INT_to_INT,
        (PyArray_VectorUnaryFunc*)INT_to_UINT,
        (PyArray_VectorUnaryFunc*)INT_to_LONG,
        (PyArray_VectorUnaryFunc*)INT_to_ULONG,
        (PyArray_VectorUnaryFunc*)INT_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)INT_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)INT_to_FLOAT,
        (PyArray_VectorUnaryFunc*)INT_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)INT_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)INT_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)INT_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)INT_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)INT_to_OBJECT,
        (PyArray_VectorUnaryFunc*)INT_to_STRING,
        (PyArray_VectorUnaryFunc*)INT_to_UNICODE,
        (PyArray_VectorUnaryFunc*)INT_to_VOID
    },
    (PyArray_GetItemFunc*)INT_getitem,
    (PyArray_SetItemFunc*)INT_setitem,
    (PyArray_CopySwapNFunc*)INT_copyswapn,
    (PyArray_CopySwapFunc*)INT_copyswap,
    (PyArray_CompareFunc*)INT_compare,
    (PyArray_ArgFunc*)INT_argmax,
    (PyArray_DotFunc*)INT_dot,
    (PyArray_ScanFunc*)INT_scan,
    (PyArray_FromStrFunc*)INT_fromstr,
    (PyArray_NonzeroFunc*)INT_nonzero,
    (PyArray_FillFunc*)INT_fill,
    (PyArray_FillWithScalarFunc*)INT_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_int,
        (PyArray_SortFunc *)heapsort_int,
        (PyArray_SortFunc *)mergesort_int
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_int,
        (PyArray_ArgSortFunc *)aheapsort_int,
        (PyArray_ArgSortFunc *)amergesort_int
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)INT_fastclip,
    (PyArray_FastPutmaskFunc*)INT_fastputmask,
    (PyArray_FastTakeFunc*)INT_fasttake,
    (PyArray_ArgFunc*)INT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr INT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyIntArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_INTLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_INT,
    /* elsize */
    1 * sizeof(npy_int),
    /* alignment */
    1 * _ALIGN(npy_int),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyInt_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyUInt_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)UINT_to_BOOL,
        (PyArray_VectorUnaryFunc*)UINT_to_BYTE,
        (PyArray_VectorUnaryFunc*)UINT_to_UBYTE,
        (PyArray_VectorUnaryFunc*)UINT_to_SHORT,
        (PyArray_VectorUnaryFunc*)UINT_to_USHORT,
        (PyArray_VectorUnaryFunc*)UINT_to_INT,
        (PyArray_VectorUnaryFunc*)UINT_to_UINT,
        (PyArray_VectorUnaryFunc*)UINT_to_LONG,
        (PyArray_VectorUnaryFunc*)UINT_to_ULONG,
        (PyArray_VectorUnaryFunc*)UINT_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)UINT_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)UINT_to_FLOAT,
        (PyArray_VectorUnaryFunc*)UINT_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)UINT_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)UINT_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)UINT_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)UINT_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)UINT_to_OBJECT,
        (PyArray_VectorUnaryFunc*)UINT_to_STRING,
        (PyArray_VectorUnaryFunc*)UINT_to_UNICODE,
        (PyArray_VectorUnaryFunc*)UINT_to_VOID
    },
    (PyArray_GetItemFunc*)UINT_getitem,
    (PyArray_SetItemFunc*)UINT_setitem,
    (PyArray_CopySwapNFunc*)UINT_copyswapn,
    (PyArray_CopySwapFunc*)UINT_copyswap,
    (PyArray_CompareFunc*)UINT_compare,
    (PyArray_ArgFunc*)UINT_argmax,
    (PyArray_DotFunc*)UINT_dot,
    (PyArray_ScanFunc*)UINT_scan,
    (PyArray_FromStrFunc*)UINT_fromstr,
    (PyArray_NonzeroFunc*)UINT_nonzero,
    (PyArray_FillFunc*)UINT_fill,
    (PyArray_FillWithScalarFunc*)UINT_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_uint,
        (PyArray_SortFunc *)heapsort_uint,
        (PyArray_SortFunc *)mergesort_uint
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_uint,
        (PyArray_ArgSortFunc *)aheapsort_uint,
        (PyArray_ArgSortFunc *)amergesort_uint
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)UINT_fastclip,
    (PyArray_FastPutmaskFunc*)UINT_fastputmask,
    (PyArray_FastTakeFunc*)UINT_fasttake,
    (PyArray_ArgFunc*)UINT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr UINT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyUIntArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_UINTLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_UINT,
    /* elsize */
    1 * sizeof(npy_uint),
    /* alignment */
    1 * _ALIGN(npy_uint),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyUInt_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyLong_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)LONG_to_BOOL,
        (PyArray_VectorUnaryFunc*)LONG_to_BYTE,
        (PyArray_VectorUnaryFunc*)LONG_to_UBYTE,
        (PyArray_VectorUnaryFunc*)LONG_to_SHORT,
        (PyArray_VectorUnaryFunc*)LONG_to_USHORT,
        (PyArray_VectorUnaryFunc*)LONG_to_INT,
        (PyArray_VectorUnaryFunc*)LONG_to_UINT,
        (PyArray_VectorUnaryFunc*)LONG_to_LONG,
        (PyArray_VectorUnaryFunc*)LONG_to_ULONG,
        (PyArray_VectorUnaryFunc*)LONG_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)LONG_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)LONG_to_FLOAT,
        (PyArray_VectorUnaryFunc*)LONG_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)LONG_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)LONG_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)LONG_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)LONG_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)LONG_to_OBJECT,
        (PyArray_VectorUnaryFunc*)LONG_to_STRING,
        (PyArray_VectorUnaryFunc*)LONG_to_UNICODE,
        (PyArray_VectorUnaryFunc*)LONG_to_VOID
    },
    (PyArray_GetItemFunc*)LONG_getitem,
    (PyArray_SetItemFunc*)LONG_setitem,
    (PyArray_CopySwapNFunc*)LONG_copyswapn,
    (PyArray_CopySwapFunc*)LONG_copyswap,
    (PyArray_CompareFunc*)LONG_compare,
    (PyArray_ArgFunc*)LONG_argmax,
    (PyArray_DotFunc*)LONG_dot,
    (PyArray_ScanFunc*)LONG_scan,
    (PyArray_FromStrFunc*)LONG_fromstr,
    (PyArray_NonzeroFunc*)LONG_nonzero,
    (PyArray_FillFunc*)LONG_fill,
    (PyArray_FillWithScalarFunc*)LONG_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_long,
        (PyArray_SortFunc *)heapsort_long,
        (PyArray_SortFunc *)mergesort_long
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_long,
        (PyArray_ArgSortFunc *)aheapsort_long,
        (PyArray_ArgSortFunc *)amergesort_long
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)LONG_fastclip,
    (PyArray_FastPutmaskFunc*)LONG_fastputmask,
    (PyArray_FastTakeFunc*)LONG_fasttake,
    (PyArray_ArgFunc*)LONG_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr LONG_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyLongArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_LONGLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_LONG,
    /* elsize */
    1 * sizeof(npy_long),
    /* alignment */
    1 * _ALIGN(npy_long),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyLong_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyULong_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)ULONG_to_BOOL,
        (PyArray_VectorUnaryFunc*)ULONG_to_BYTE,
        (PyArray_VectorUnaryFunc*)ULONG_to_UBYTE,
        (PyArray_VectorUnaryFunc*)ULONG_to_SHORT,
        (PyArray_VectorUnaryFunc*)ULONG_to_USHORT,
        (PyArray_VectorUnaryFunc*)ULONG_to_INT,
        (PyArray_VectorUnaryFunc*)ULONG_to_UINT,
        (PyArray_VectorUnaryFunc*)ULONG_to_LONG,
        (PyArray_VectorUnaryFunc*)ULONG_to_ULONG,
        (PyArray_VectorUnaryFunc*)ULONG_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)ULONG_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)ULONG_to_FLOAT,
        (PyArray_VectorUnaryFunc*)ULONG_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)ULONG_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)ULONG_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)ULONG_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)ULONG_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)ULONG_to_OBJECT,
        (PyArray_VectorUnaryFunc*)ULONG_to_STRING,
        (PyArray_VectorUnaryFunc*)ULONG_to_UNICODE,
        (PyArray_VectorUnaryFunc*)ULONG_to_VOID
    },
    (PyArray_GetItemFunc*)ULONG_getitem,
    (PyArray_SetItemFunc*)ULONG_setitem,
    (PyArray_CopySwapNFunc*)ULONG_copyswapn,
    (PyArray_CopySwapFunc*)ULONG_copyswap,
    (PyArray_CompareFunc*)ULONG_compare,
    (PyArray_ArgFunc*)ULONG_argmax,
    (PyArray_DotFunc*)ULONG_dot,
    (PyArray_ScanFunc*)ULONG_scan,
    (PyArray_FromStrFunc*)ULONG_fromstr,
    (PyArray_NonzeroFunc*)ULONG_nonzero,
    (PyArray_FillFunc*)ULONG_fill,
    (PyArray_FillWithScalarFunc*)ULONG_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_ulong,
        (PyArray_SortFunc *)heapsort_ulong,
        (PyArray_SortFunc *)mergesort_ulong
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_ulong,
        (PyArray_ArgSortFunc *)aheapsort_ulong,
        (PyArray_ArgSortFunc *)amergesort_ulong
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)ULONG_fastclip,
    (PyArray_FastPutmaskFunc*)ULONG_fastputmask,
    (PyArray_FastTakeFunc*)ULONG_fasttake,
    (PyArray_ArgFunc*)ULONG_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr ULONG_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyULongArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_ULONGLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_ULONG,
    /* elsize */
    1 * sizeof(npy_ulong),
    /* alignment */
    1 * _ALIGN(npy_ulong),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyULong_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyLongLong_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)LONGLONG_to_BOOL,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_BYTE,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_UBYTE,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_SHORT,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_USHORT,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_INT,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_UINT,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_LONG,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_ULONG,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_FLOAT,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_OBJECT,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_STRING,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_UNICODE,
        (PyArray_VectorUnaryFunc*)LONGLONG_to_VOID
    },
    (PyArray_GetItemFunc*)LONGLONG_getitem,
    (PyArray_SetItemFunc*)LONGLONG_setitem,
    (PyArray_CopySwapNFunc*)LONGLONG_copyswapn,
    (PyArray_CopySwapFunc*)LONGLONG_copyswap,
    (PyArray_CompareFunc*)LONGLONG_compare,
    (PyArray_ArgFunc*)LONGLONG_argmax,
    (PyArray_DotFunc*)LONGLONG_dot,
    (PyArray_ScanFunc*)LONGLONG_scan,
    (PyArray_FromStrFunc*)LONGLONG_fromstr,
    (PyArray_NonzeroFunc*)LONGLONG_nonzero,
    (PyArray_FillFunc*)LONGLONG_fill,
    (PyArray_FillWithScalarFunc*)LONGLONG_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_longlong,
        (PyArray_SortFunc *)heapsort_longlong,
        (PyArray_SortFunc *)mergesort_longlong
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_longlong,
        (PyArray_ArgSortFunc *)aheapsort_longlong,
        (PyArray_ArgSortFunc *)amergesort_longlong
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)LONGLONG_fastclip,
    (PyArray_FastPutmaskFunc*)LONGLONG_fastputmask,
    (PyArray_FastTakeFunc*)LONGLONG_fasttake,
    (PyArray_ArgFunc*)LONGLONG_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr LONGLONG_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyLongLongArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_LONGLONGLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_LONGLONG,
    /* elsize */
    1 * sizeof(npy_longlong),
    /* alignment */
    1 * _ALIGN(npy_longlong),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyLongLong_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyULongLong_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_BOOL,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_BYTE,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_UBYTE,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_SHORT,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_USHORT,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_INT,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_UINT,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_LONG,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_ULONG,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_FLOAT,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_OBJECT,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_STRING,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_UNICODE,
        (PyArray_VectorUnaryFunc*)ULONGLONG_to_VOID
    },
    (PyArray_GetItemFunc*)ULONGLONG_getitem,
    (PyArray_SetItemFunc*)ULONGLONG_setitem,
    (PyArray_CopySwapNFunc*)ULONGLONG_copyswapn,
    (PyArray_CopySwapFunc*)ULONGLONG_copyswap,
    (PyArray_CompareFunc*)ULONGLONG_compare,
    (PyArray_ArgFunc*)ULONGLONG_argmax,
    (PyArray_DotFunc*)ULONGLONG_dot,
    (PyArray_ScanFunc*)ULONGLONG_scan,
    (PyArray_FromStrFunc*)ULONGLONG_fromstr,
    (PyArray_NonzeroFunc*)ULONGLONG_nonzero,
    (PyArray_FillFunc*)ULONGLONG_fill,
    (PyArray_FillWithScalarFunc*)ULONGLONG_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_ulonglong,
        (PyArray_SortFunc *)heapsort_ulonglong,
        (PyArray_SortFunc *)mergesort_ulonglong
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_ulonglong,
        (PyArray_ArgSortFunc *)aheapsort_ulonglong,
        (PyArray_ArgSortFunc *)amergesort_ulonglong
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)ULONGLONG_fastclip,
    (PyArray_FastPutmaskFunc*)ULONGLONG_fastputmask,
    (PyArray_FastTakeFunc*)ULONGLONG_fasttake,
    (PyArray_ArgFunc*)ULONGLONG_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr ULONGLONG_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyULongLongArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_ULONGLONGLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_ULONGLONG,
    /* elsize */
    1 * sizeof(npy_ulonglong),
    /* alignment */
    1 * _ALIGN(npy_ulonglong),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyULongLong_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyHalf_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)HALF_to_BOOL,
        (PyArray_VectorUnaryFunc*)HALF_to_BYTE,
        (PyArray_VectorUnaryFunc*)HALF_to_UBYTE,
        (PyArray_VectorUnaryFunc*)HALF_to_SHORT,
        (PyArray_VectorUnaryFunc*)HALF_to_USHORT,
        (PyArray_VectorUnaryFunc*)HALF_to_INT,
        (PyArray_VectorUnaryFunc*)HALF_to_UINT,
        (PyArray_VectorUnaryFunc*)HALF_to_LONG,
        (PyArray_VectorUnaryFunc*)HALF_to_ULONG,
        (PyArray_VectorUnaryFunc*)HALF_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)HALF_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)HALF_to_FLOAT,
        (PyArray_VectorUnaryFunc*)HALF_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)HALF_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)HALF_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)HALF_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)HALF_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)HALF_to_OBJECT,
        (PyArray_VectorUnaryFunc*)HALF_to_STRING,
        (PyArray_VectorUnaryFunc*)HALF_to_UNICODE,
        (PyArray_VectorUnaryFunc*)HALF_to_VOID
    },
    (PyArray_GetItemFunc*)HALF_getitem,
    (PyArray_SetItemFunc*)HALF_setitem,
    (PyArray_CopySwapNFunc*)HALF_copyswapn,
    (PyArray_CopySwapFunc*)HALF_copyswap,
    (PyArray_CompareFunc*)HALF_compare,
    (PyArray_ArgFunc*)HALF_argmax,
    (PyArray_DotFunc*)HALF_dot,
    (PyArray_ScanFunc*)HALF_scan,
    (PyArray_FromStrFunc*)HALF_fromstr,
    (PyArray_NonzeroFunc*)HALF_nonzero,
    (PyArray_FillFunc*)HALF_fill,
    (PyArray_FillWithScalarFunc*)HALF_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_half,
        (PyArray_SortFunc *)heapsort_half,
        (PyArray_SortFunc *)mergesort_half
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_half,
        (PyArray_ArgSortFunc *)aheapsort_half,
        (PyArray_ArgSortFunc *)amergesort_half
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)HALF_fastclip,
    (PyArray_FastPutmaskFunc*)HALF_fastputmask,
    (PyArray_FastTakeFunc*)HALF_fasttake,
    (PyArray_ArgFunc*)HALF_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr HALF_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyHalfArrType_Type,
    /* kind */
    NPY_FLOATINGLTR,
    /* type */
    NPY_HALFLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_HALF,
    /* elsize */
    1 * sizeof(npy_half),
    /* alignment */
    1 * _ALIGN(npy_half),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyHalf_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyFloat_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)FLOAT_to_BOOL,
        (PyArray_VectorUnaryFunc*)FLOAT_to_BYTE,
        (PyArray_VectorUnaryFunc*)FLOAT_to_UBYTE,
        (PyArray_VectorUnaryFunc*)FLOAT_to_SHORT,
        (PyArray_VectorUnaryFunc*)FLOAT_to_USHORT,
        (PyArray_VectorUnaryFunc*)FLOAT_to_INT,
        (PyArray_VectorUnaryFunc*)FLOAT_to_UINT,
        (PyArray_VectorUnaryFunc*)FLOAT_to_LONG,
        (PyArray_VectorUnaryFunc*)FLOAT_to_ULONG,
        (PyArray_VectorUnaryFunc*)FLOAT_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)FLOAT_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)FLOAT_to_FLOAT,
        (PyArray_VectorUnaryFunc*)FLOAT_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)FLOAT_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)FLOAT_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)FLOAT_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)FLOAT_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)FLOAT_to_OBJECT,
        (PyArray_VectorUnaryFunc*)FLOAT_to_STRING,
        (PyArray_VectorUnaryFunc*)FLOAT_to_UNICODE,
        (PyArray_VectorUnaryFunc*)FLOAT_to_VOID
    },
    (PyArray_GetItemFunc*)FLOAT_getitem,
    (PyArray_SetItemFunc*)FLOAT_setitem,
    (PyArray_CopySwapNFunc*)FLOAT_copyswapn,
    (PyArray_CopySwapFunc*)FLOAT_copyswap,
    (PyArray_CompareFunc*)FLOAT_compare,
    (PyArray_ArgFunc*)FLOAT_argmax,
    (PyArray_DotFunc*)FLOAT_dot,
    (PyArray_ScanFunc*)FLOAT_scan,
    (PyArray_FromStrFunc*)FLOAT_fromstr,
    (PyArray_NonzeroFunc*)FLOAT_nonzero,
    (PyArray_FillFunc*)FLOAT_fill,
    (PyArray_FillWithScalarFunc*)FLOAT_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_float,
        (PyArray_SortFunc *)heapsort_float,
        (PyArray_SortFunc *)mergesort_float
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_float,
        (PyArray_ArgSortFunc *)aheapsort_float,
        (PyArray_ArgSortFunc *)amergesort_float
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)FLOAT_fastclip,
    (PyArray_FastPutmaskFunc*)FLOAT_fastputmask,
    (PyArray_FastTakeFunc*)FLOAT_fasttake,
    (PyArray_ArgFunc*)FLOAT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr FLOAT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyFloatArrType_Type,
    /* kind */
    NPY_FLOATINGLTR,
    /* type */
    NPY_FLOATLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_FLOAT,
    /* elsize */
    1 * sizeof(npy_float),
    /* alignment */
    1 * _ALIGN(npy_float),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyFloat_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyDouble_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)DOUBLE_to_BOOL,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_BYTE,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_UBYTE,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_SHORT,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_USHORT,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_INT,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_UINT,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_LONG,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_ULONG,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_FLOAT,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_OBJECT,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_STRING,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_UNICODE,
        (PyArray_VectorUnaryFunc*)DOUBLE_to_VOID
    },
    (PyArray_GetItemFunc*)DOUBLE_getitem,
    (PyArray_SetItemFunc*)DOUBLE_setitem,
    (PyArray_CopySwapNFunc*)DOUBLE_copyswapn,
    (PyArray_CopySwapFunc*)DOUBLE_copyswap,
    (PyArray_CompareFunc*)DOUBLE_compare,
    (PyArray_ArgFunc*)DOUBLE_argmax,
    (PyArray_DotFunc*)DOUBLE_dot,
    (PyArray_ScanFunc*)DOUBLE_scan,
    (PyArray_FromStrFunc*)DOUBLE_fromstr,
    (PyArray_NonzeroFunc*)DOUBLE_nonzero,
    (PyArray_FillFunc*)DOUBLE_fill,
    (PyArray_FillWithScalarFunc*)DOUBLE_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_double,
        (PyArray_SortFunc *)heapsort_double,
        (PyArray_SortFunc *)mergesort_double
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_double,
        (PyArray_ArgSortFunc *)aheapsort_double,
        (PyArray_ArgSortFunc *)amergesort_double
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)DOUBLE_fastclip,
    (PyArray_FastPutmaskFunc*)DOUBLE_fastputmask,
    (PyArray_FastTakeFunc*)DOUBLE_fasttake,
    (PyArray_ArgFunc*)DOUBLE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr DOUBLE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyDoubleArrType_Type,
    /* kind */
    NPY_FLOATINGLTR,
    /* type */
    NPY_DOUBLELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_DOUBLE,
    /* elsize */
    1 * sizeof(npy_double),
    /* alignment */
    1 * _ALIGN(npy_double),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyDouble_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyLongDouble_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_BOOL,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_BYTE,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_UBYTE,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_SHORT,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_USHORT,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_INT,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_UINT,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_LONG,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_ULONG,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_FLOAT,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_OBJECT,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_STRING,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_UNICODE,
        (PyArray_VectorUnaryFunc*)LONGDOUBLE_to_VOID
    },
    (PyArray_GetItemFunc*)LONGDOUBLE_getitem,
    (PyArray_SetItemFunc*)LONGDOUBLE_setitem,
    (PyArray_CopySwapNFunc*)LONGDOUBLE_copyswapn,
    (PyArray_CopySwapFunc*)LONGDOUBLE_copyswap,
    (PyArray_CompareFunc*)LONGDOUBLE_compare,
    (PyArray_ArgFunc*)LONGDOUBLE_argmax,
    (PyArray_DotFunc*)LONGDOUBLE_dot,
    (PyArray_ScanFunc*)LONGDOUBLE_scan,
    (PyArray_FromStrFunc*)LONGDOUBLE_fromstr,
    (PyArray_NonzeroFunc*)LONGDOUBLE_nonzero,
    (PyArray_FillFunc*)LONGDOUBLE_fill,
    (PyArray_FillWithScalarFunc*)LONGDOUBLE_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_longdouble,
        (PyArray_SortFunc *)heapsort_longdouble,
        (PyArray_SortFunc *)mergesort_longdouble
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_longdouble,
        (PyArray_ArgSortFunc *)aheapsort_longdouble,
        (PyArray_ArgSortFunc *)amergesort_longdouble
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)LONGDOUBLE_fastclip,
    (PyArray_FastPutmaskFunc*)LONGDOUBLE_fastputmask,
    (PyArray_FastTakeFunc*)LONGDOUBLE_fasttake,
    (PyArray_ArgFunc*)LONGDOUBLE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr LONGDOUBLE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyLongDoubleArrType_Type,
    /* kind */
    NPY_FLOATINGLTR,
    /* type */
    NPY_LONGDOUBLELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_LONGDOUBLE,
    /* elsize */
    1 * sizeof(npy_longdouble),
    /* alignment */
    1 * _ALIGN(npy_longdouble),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyLongDouble_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyCFloat_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)CFLOAT_to_BOOL,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_BYTE,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_UBYTE,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_SHORT,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_USHORT,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_INT,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_UINT,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_LONG,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_ULONG,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_FLOAT,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_OBJECT,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_STRING,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_UNICODE,
        (PyArray_VectorUnaryFunc*)CFLOAT_to_VOID
    },
    (PyArray_GetItemFunc*)CFLOAT_getitem,
    (PyArray_SetItemFunc*)CFLOAT_setitem,
    (PyArray_CopySwapNFunc*)CFLOAT_copyswapn,
    (PyArray_CopySwapFunc*)CFLOAT_copyswap,
    (PyArray_CompareFunc*)CFLOAT_compare,
    (PyArray_ArgFunc*)CFLOAT_argmax,
    (PyArray_DotFunc*)CFLOAT_dot,
    (PyArray_ScanFunc*)CFLOAT_scan,
    (PyArray_FromStrFunc*)CFLOAT_fromstr,
    (PyArray_NonzeroFunc*)CFLOAT_nonzero,
    (PyArray_FillFunc*)CFLOAT_fill,
    (PyArray_FillWithScalarFunc*)CFLOAT_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_cfloat,
        (PyArray_SortFunc *)heapsort_cfloat,
        (PyArray_SortFunc *)mergesort_cfloat
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_cfloat,
        (PyArray_ArgSortFunc *)aheapsort_cfloat,
        (PyArray_ArgSortFunc *)amergesort_cfloat
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)CFLOAT_fastclip,
    (PyArray_FastPutmaskFunc*)CFLOAT_fastputmask,
    (PyArray_FastTakeFunc*)CFLOAT_fasttake,
    (PyArray_ArgFunc*)CFLOAT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr CFLOAT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyCFloatArrType_Type,
    /* kind */
    NPY_COMPLEXLTR,
    /* type */
    NPY_CFLOATLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_CFLOAT,
    /* elsize */
    2 * sizeof(npy_float),
    /* alignment */
    2 * _ALIGN(npy_float),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyCFloat_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyCDouble_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_BOOL,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_BYTE,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_UBYTE,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_SHORT,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_USHORT,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_INT,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_UINT,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_LONG,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_ULONG,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_FLOAT,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_OBJECT,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_STRING,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_UNICODE,
        (PyArray_VectorUnaryFunc*)CDOUBLE_to_VOID
    },
    (PyArray_GetItemFunc*)CDOUBLE_getitem,
    (PyArray_SetItemFunc*)CDOUBLE_setitem,
    (PyArray_CopySwapNFunc*)CDOUBLE_copyswapn,
    (PyArray_CopySwapFunc*)CDOUBLE_copyswap,
    (PyArray_CompareFunc*)CDOUBLE_compare,
    (PyArray_ArgFunc*)CDOUBLE_argmax,
    (PyArray_DotFunc*)CDOUBLE_dot,
    (PyArray_ScanFunc*)CDOUBLE_scan,
    (PyArray_FromStrFunc*)CDOUBLE_fromstr,
    (PyArray_NonzeroFunc*)CDOUBLE_nonzero,
    (PyArray_FillFunc*)CDOUBLE_fill,
    (PyArray_FillWithScalarFunc*)CDOUBLE_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_cdouble,
        (PyArray_SortFunc *)heapsort_cdouble,
        (PyArray_SortFunc *)mergesort_cdouble
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_cdouble,
        (PyArray_ArgSortFunc *)aheapsort_cdouble,
        (PyArray_ArgSortFunc *)amergesort_cdouble
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)CDOUBLE_fastclip,
    (PyArray_FastPutmaskFunc*)CDOUBLE_fastputmask,
    (PyArray_FastTakeFunc*)CDOUBLE_fasttake,
    (PyArray_ArgFunc*)CDOUBLE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr CDOUBLE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyCDoubleArrType_Type,
    /* kind */
    NPY_COMPLEXLTR,
    /* type */
    NPY_CDOUBLELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_CDOUBLE,
    /* elsize */
    2 * sizeof(npy_double),
    /* alignment */
    2 * _ALIGN(npy_double),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyCDouble_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyCLongDouble_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_BOOL,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_BYTE,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_UBYTE,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_SHORT,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_USHORT,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_INT,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_UINT,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_LONG,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_ULONG,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_FLOAT,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_OBJECT,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_STRING,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_UNICODE,
        (PyArray_VectorUnaryFunc*)CLONGDOUBLE_to_VOID
    },
    (PyArray_GetItemFunc*)CLONGDOUBLE_getitem,
    (PyArray_SetItemFunc*)CLONGDOUBLE_setitem,
    (PyArray_CopySwapNFunc*)CLONGDOUBLE_copyswapn,
    (PyArray_CopySwapFunc*)CLONGDOUBLE_copyswap,
    (PyArray_CompareFunc*)CLONGDOUBLE_compare,
    (PyArray_ArgFunc*)CLONGDOUBLE_argmax,
    (PyArray_DotFunc*)CLONGDOUBLE_dot,
    (PyArray_ScanFunc*)CLONGDOUBLE_scan,
    (PyArray_FromStrFunc*)CLONGDOUBLE_fromstr,
    (PyArray_NonzeroFunc*)CLONGDOUBLE_nonzero,
    (PyArray_FillFunc*)CLONGDOUBLE_fill,
    (PyArray_FillWithScalarFunc*)CLONGDOUBLE_fillwithscalar,
#if 1
    {
        (PyArray_SortFunc *)quicksort_clongdouble,
        (PyArray_SortFunc *)heapsort_clongdouble,
        (PyArray_SortFunc *)mergesort_clongdouble
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_clongdouble,
        (PyArray_ArgSortFunc *)aheapsort_clongdouble,
        (PyArray_ArgSortFunc *)amergesort_clongdouble
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)CLONGDOUBLE_fastclip,
    (PyArray_FastPutmaskFunc*)CLONGDOUBLE_fastputmask,
    (PyArray_FastTakeFunc*)CLONGDOUBLE_fasttake,
    (PyArray_ArgFunc*)CLONGDOUBLE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr CLONGDOUBLE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyCLongDoubleArrType_Type,
    /* kind */
    NPY_COMPLEXLTR,
    /* type */
    NPY_CLONGDOUBLELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_CLONGDOUBLE,
    /* elsize */
    2 * sizeof(npy_longdouble),
    /* alignment */
    2 * _ALIGN(npy_longdouble),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyCLongDouble_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyObject_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)OBJECT_to_BOOL,
        (PyArray_VectorUnaryFunc*)OBJECT_to_BYTE,
        (PyArray_VectorUnaryFunc*)OBJECT_to_UBYTE,
        (PyArray_VectorUnaryFunc*)OBJECT_to_SHORT,
        (PyArray_VectorUnaryFunc*)OBJECT_to_USHORT,
        (PyArray_VectorUnaryFunc*)OBJECT_to_INT,
        (PyArray_VectorUnaryFunc*)OBJECT_to_UINT,
        (PyArray_VectorUnaryFunc*)OBJECT_to_LONG,
        (PyArray_VectorUnaryFunc*)OBJECT_to_ULONG,
        (PyArray_VectorUnaryFunc*)OBJECT_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)OBJECT_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)OBJECT_to_FLOAT,
        (PyArray_VectorUnaryFunc*)OBJECT_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)OBJECT_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)OBJECT_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)OBJECT_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)OBJECT_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)OBJECT_to_OBJECT,
        (PyArray_VectorUnaryFunc*)OBJECT_to_STRING,
        (PyArray_VectorUnaryFunc*)OBJECT_to_UNICODE,
        (PyArray_VectorUnaryFunc*)OBJECT_to_VOID
    },
    (PyArray_GetItemFunc*)OBJECT_getitem,
    (PyArray_SetItemFunc*)OBJECT_setitem,
    (PyArray_CopySwapNFunc*)OBJECT_copyswapn,
    (PyArray_CopySwapFunc*)OBJECT_copyswap,
    (PyArray_CompareFunc*)OBJECT_compare,
    (PyArray_ArgFunc*)OBJECT_argmax,
    (PyArray_DotFunc*)OBJECT_dot,
    (PyArray_ScanFunc*)OBJECT_scan,
    (PyArray_FromStrFunc*)OBJECT_fromstr,
    (PyArray_NonzeroFunc*)OBJECT_nonzero,
    (PyArray_FillFunc*)OBJECT_fill,
    (PyArray_FillWithScalarFunc*)OBJECT_fillwithscalar,
#if 0
    {
        (PyArray_SortFunc *)quicksort_object,
        (PyArray_SortFunc *)heapsort_object,
        (PyArray_SortFunc *)mergesort_object
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_object,
        (PyArray_ArgSortFunc *)aheapsort_object,
        (PyArray_ArgSortFunc *)amergesort_object
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)OBJECT_fastclip,
    (PyArray_FastPutmaskFunc*)OBJECT_fastputmask,
    (PyArray_FastTakeFunc*)OBJECT_fasttake,
    (PyArray_ArgFunc*)OBJECT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr OBJECT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyObjectArrType_Type,
    /* kind */
    NPY_OBJECTLTR,
    /* type */
    NPY_OBJECTLTR,
    /* byteorder */
    '|',
    /* flags */
    NPY_OBJECT_DTYPE_FLAGS,
    /* type_num */
    NPY_OBJECT,
    /* elsize */
    1 * sizeof(PyObject *),
    /* alignment */
    1 * _ALIGN(PyObject *),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyObject_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyDatetime_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)DATETIME_to_BOOL,
        (PyArray_VectorUnaryFunc*)DATETIME_to_BYTE,
        (PyArray_VectorUnaryFunc*)DATETIME_to_UBYTE,
        (PyArray_VectorUnaryFunc*)DATETIME_to_SHORT,
        (PyArray_VectorUnaryFunc*)DATETIME_to_USHORT,
        (PyArray_VectorUnaryFunc*)DATETIME_to_INT,
        (PyArray_VectorUnaryFunc*)DATETIME_to_UINT,
        (PyArray_VectorUnaryFunc*)DATETIME_to_LONG,
        (PyArray_VectorUnaryFunc*)DATETIME_to_ULONG,
        (PyArray_VectorUnaryFunc*)DATETIME_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)DATETIME_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)DATETIME_to_FLOAT,
        (PyArray_VectorUnaryFunc*)DATETIME_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)DATETIME_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)DATETIME_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)DATETIME_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)DATETIME_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)DATETIME_to_OBJECT,
        (PyArray_VectorUnaryFunc*)DATETIME_to_STRING,
        (PyArray_VectorUnaryFunc*)DATETIME_to_UNICODE,
        (PyArray_VectorUnaryFunc*)DATETIME_to_VOID
    },
    (PyArray_GetItemFunc*)DATETIME_getitem,
    (PyArray_SetItemFunc*)DATETIME_setitem,
    (PyArray_CopySwapNFunc*)DATETIME_copyswapn,
    (PyArray_CopySwapFunc*)DATETIME_copyswap,
    (PyArray_CompareFunc*)DATETIME_compare,
    (PyArray_ArgFunc*)DATETIME_argmax,
    (PyArray_DotFunc*)DATETIME_dot,
    (PyArray_ScanFunc*)DATETIME_scan,
    (PyArray_FromStrFunc*)DATETIME_fromstr,
    (PyArray_NonzeroFunc*)DATETIME_nonzero,
    (PyArray_FillFunc*)DATETIME_fill,
    (PyArray_FillWithScalarFunc*)DATETIME_fillwithscalar,
#if 0
    {
        (PyArray_SortFunc *)quicksort_datetime,
        (PyArray_SortFunc *)heapsort_datetime,
        (PyArray_SortFunc *)mergesort_datetime
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_datetime,
        (PyArray_ArgSortFunc *)aheapsort_datetime,
        (PyArray_ArgSortFunc *)amergesort_datetime
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)DATETIME_fastclip,
    (PyArray_FastPutmaskFunc*)DATETIME_fastputmask,
    (PyArray_FastTakeFunc*)DATETIME_fasttake,
    (PyArray_ArgFunc*)DATETIME_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr DATETIME_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyDatetimeArrType_Type,
    /* kind */
    NPY_DATETIMELTR,
    /* type */
    NPY_DATETIMELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_DATETIME,
    /* elsize */
    1 * sizeof(npy_datetime),
    /* alignment */
    1 * _ALIGN(npy_datetime),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyDatetime_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};


#line 3739

static PyArray_ArrFuncs _PyTimedelta_ArrFuncs = {
    {
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_BOOL,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_BYTE,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_UBYTE,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_SHORT,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_USHORT,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_INT,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_UINT,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_LONG,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_ULONG,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_LONGLONG,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_ULONGLONG,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_FLOAT,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_DOUBLE,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_LONGDOUBLE,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_CFLOAT,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_CDOUBLE,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_CLONGDOUBLE,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_OBJECT,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_STRING,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_UNICODE,
        (PyArray_VectorUnaryFunc*)TIMEDELTA_to_VOID
    },
    (PyArray_GetItemFunc*)TIMEDELTA_getitem,
    (PyArray_SetItemFunc*)TIMEDELTA_setitem,
    (PyArray_CopySwapNFunc*)TIMEDELTA_copyswapn,
    (PyArray_CopySwapFunc*)TIMEDELTA_copyswap,
    (PyArray_CompareFunc*)TIMEDELTA_compare,
    (PyArray_ArgFunc*)TIMEDELTA_argmax,
    (PyArray_DotFunc*)TIMEDELTA_dot,
    (PyArray_ScanFunc*)TIMEDELTA_scan,
    (PyArray_FromStrFunc*)TIMEDELTA_fromstr,
    (PyArray_NonzeroFunc*)TIMEDELTA_nonzero,
    (PyArray_FillFunc*)TIMEDELTA_fill,
    (PyArray_FillWithScalarFunc*)TIMEDELTA_fillwithscalar,
#if 0
    {
        (PyArray_SortFunc *)quicksort_timedelta,
        (PyArray_SortFunc *)heapsort_timedelta,
        (PyArray_SortFunc *)mergesort_timedelta
    },
    {
        (PyArray_ArgSortFunc *)aquicksort_timedelta,
        (PyArray_ArgSortFunc *)aheapsort_timedelta,
        (PyArray_ArgSortFunc *)amergesort_timedelta
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)TIMEDELTA_fastclip,
    (PyArray_FastPutmaskFunc*)TIMEDELTA_fastputmask,
    (PyArray_FastTakeFunc*)TIMEDELTA_fasttake,
    (PyArray_ArgFunc*)TIMEDELTA_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr TIMEDELTA_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyTimedeltaArrType_Type,
    /* kind */
    NPY_TIMEDELTALTR,
    /* type */
    NPY_TIMEDELTALTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_TIMEDELTA,
    /* elsize */
    1 * sizeof(npy_timedelta),
    /* alignment */
    1 * _ALIGN(npy_timedelta),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyTimedelta_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
};



#define _MAX_LETTER 128
static char _letter_to_num[_MAX_LETTER];

static PyArray_Descr *_builtin_descrs[] = {
    &BOOL_Descr,
    &BYTE_Descr,
    &UBYTE_Descr,
    &SHORT_Descr,
    &USHORT_Descr,
    &INT_Descr,
    &UINT_Descr,
    &LONG_Descr,
    &ULONG_Descr,
    &LONGLONG_Descr,
    &ULONGLONG_Descr,
    &FLOAT_Descr,
    &DOUBLE_Descr,
    &LONGDOUBLE_Descr,
    &CFLOAT_Descr,
    &CDOUBLE_Descr,
    &CLONGDOUBLE_Descr,
    &OBJECT_Descr,
    &STRING_Descr,
    &UNICODE_Descr,
    &VOID_Descr,
    &DATETIME_Descr,
    &TIMEDELTA_Descr,
    &HALF_Descr
};

/*NUMPY_API
 * Get the PyArray_Descr structure for a type.
 */
NPY_NO_EXPORT PyArray_Descr *
PyArray_DescrFromType(int type)
{
    PyArray_Descr *ret = NULL;

    if (type < NPY_NTYPES) {
        ret = _builtin_descrs[type];
    }
    else if (type == NPY_NOTYPE) {
        /*
         * This needs to not raise an error so
         * that PyArray_DescrFromType(NPY_NOTYPE)
         * works for backwards-compatible C-API
         */
        return NULL;
    }
    else if ((type == NPY_CHAR) || (type == NPY_CHARLTR)) {
        ret = PyArray_DescrNew(_builtin_descrs[NPY_STRING]);
        if (ret == NULL) {
            return NULL;
        }
        ret->elsize = 1;
        ret->type = NPY_CHARLTR;
        return ret;
    }
    else if (PyTypeNum_ISUSERDEF(type)) {
        ret = userdescrs[type - NPY_USERDEF];
    }
    else {
        int num = NPY_NTYPES;
        if (type < _MAX_LETTER) {
            num = (int) _letter_to_num[type];
        }
        if (num >= NPY_NTYPES) {
            ret = NULL;
        }
        else {
            ret = _builtin_descrs[num];
        }
    }
    if (ret == NULL) {
        PyErr_SetString(PyExc_ValueError,
                "Invalid data-type for array");
    }
    else {
        Py_INCREF(ret);
    }

    return ret;
}

/* A clone function for the datetime dtype metadata */
static NpyAuxData *
datetime_dtype_metadata_clone(NpyAuxData *data)
{
    PyArray_DatetimeDTypeMetaData *newdata =
        (PyArray_DatetimeDTypeMetaData *)PyArray_malloc(
                        sizeof(PyArray_DatetimeDTypeMetaData));
    if (newdata == NULL) {
        return NULL;
    }

    memcpy(newdata, data, sizeof(PyArray_DatetimeDTypeMetaData));

    return (NpyAuxData *)newdata;
}

/*
 * Initializes the c_metadata field for the _builtin_descrs DATETIME
 * and TIMEDELTA.
 */
int
initialize_builtin_datetime_metadata(void)
{
    PyArray_DatetimeDTypeMetaData *data1, *data2;

    /* Allocate memory for the metadata */
    data1 = PyArray_malloc(sizeof(PyArray_DatetimeDTypeMetaData));
    if (data1 == NULL) {
        return -1;
    }
    data2 = PyArray_malloc(sizeof(PyArray_DatetimeDTypeMetaData));
    if (data2 == NULL) {
        PyArray_free(data1);
        return -1;
    }

    /* Initialize the base aux data */
    memset(data1, 0, sizeof(PyArray_DatetimeDTypeMetaData));
    memset(data2, 0, sizeof(PyArray_DatetimeDTypeMetaData));
    data1->base.free = (NpyAuxData_FreeFunc *)PyArray_free;
    data2->base.free = (NpyAuxData_FreeFunc *)PyArray_free;
    data1->base.clone = datetime_dtype_metadata_clone;
    data2->base.clone = datetime_dtype_metadata_clone;

    /* Set to the default metadata */
    data1->meta.base = NPY_DATETIME_DEFAULTUNIT;
    data1->meta.num = 1;
    data2->meta.base = NPY_DATETIME_DEFAULTUNIT;
    data2->meta.num = 1;

    _builtin_descrs[NPY_DATETIME]->c_metadata = (NpyAuxData *)data1;
    _builtin_descrs[NPY_TIMEDELTA]->c_metadata = (NpyAuxData *)data2;

    return 0;
}

/*
 *****************************************************************************
 **                             SETUP TYPE INFO                             **
 *****************************************************************************
 */


/*
 * This function is called during numpy module initialization,
 * and is used to initialize internal dtype tables.
 */
NPY_NO_EXPORT int
set_typeinfo(PyObject *dict)
{
    PyObject *infodict, *s;
    int i;

    PyArray_Descr *dtype;
    PyObject *cobj, *key;

    /*
     * Add cast functions for the new types
     */

    #line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_BOOL];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BOOL_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_BOOL];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BOOL_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_BOOL];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BOOL_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_BYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BYTE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_BYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BYTE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_BYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BYTE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_UBYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UBYTE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_UBYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UBYTE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_UBYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UBYTE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_SHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)SHORT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_SHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)SHORT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_SHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)SHORT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_USHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)USHORT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_USHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)USHORT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_USHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)USHORT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_INT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)INT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_INT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)INT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_INT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)INT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_UINT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UINT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_UINT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UINT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_UINT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UINT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_LONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONG_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_LONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONG_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_LONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONG_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_ULONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONG_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_ULONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONG_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_ULONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONG_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_LONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGLONG_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_LONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGLONG_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_LONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGLONG_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_ULONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONGLONG_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_ULONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONGLONG_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_ULONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONGLONG_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_HALF];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)HALF_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_HALF];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)HALF_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_HALF];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)HALF_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_FLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)FLOAT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_FLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)FLOAT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_FLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)FLOAT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_DOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DOUBLE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_DOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DOUBLE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_DOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DOUBLE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_LONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGDOUBLE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_LONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGDOUBLE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_LONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGDOUBLE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_CFLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CFLOAT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_CFLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CFLOAT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_CFLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CFLOAT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_CDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CDOUBLE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_CDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CDOUBLE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_CDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CDOUBLE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_CLONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CLONGDOUBLE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_CLONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CLONGDOUBLE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_CLONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CLONGDOUBLE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_OBJECT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)OBJECT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_OBJECT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)OBJECT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_OBJECT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)OBJECT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_STRING];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)STRING_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_STRING];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)STRING_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_STRING];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)STRING_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_UNICODE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UNICODE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_UNICODE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UNICODE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_UNICODE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UNICODE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_VOID];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)VOID_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_VOID];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)VOID_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_VOID];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)VOID_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_DATETIME];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DATETIME_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_DATETIME];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DATETIME_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_DATETIME];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DATETIME_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4016

    #line 4021

    dtype = _builtin_descrs[NPY_TIMEDELTA];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)TIMEDELTA_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_TIMEDELTA];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)TIMEDELTA_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4021

    dtype = _builtin_descrs[NPY_TIMEDELTA];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyInt_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)TIMEDELTA_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    

    if (initialize_builtin_datetime_metadata() < 0) {
        return -1;
    }

    for (i = 0; i < _MAX_LETTER; i++) {
        _letter_to_num[i] = NPY_NTYPES;
    }

    #line 4069

    _letter_to_num[NPY_BOOLLTR] = NPY_BOOL;

    
#line 4069

    _letter_to_num[NPY_BYTELTR] = NPY_BYTE;

    
#line 4069

    _letter_to_num[NPY_UBYTELTR] = NPY_UBYTE;

    
#line 4069

    _letter_to_num[NPY_SHORTLTR] = NPY_SHORT;

    
#line 4069

    _letter_to_num[NPY_USHORTLTR] = NPY_USHORT;

    
#line 4069

    _letter_to_num[NPY_INTLTR] = NPY_INT;

    
#line 4069

    _letter_to_num[NPY_UINTLTR] = NPY_UINT;

    
#line 4069

    _letter_to_num[NPY_INTPLTR] = NPY_INTP;

    
#line 4069

    _letter_to_num[NPY_UINTPLTR] = NPY_UINTP;

    
#line 4069

    _letter_to_num[NPY_LONGLTR] = NPY_LONG;

    
#line 4069

    _letter_to_num[NPY_ULONGLTR] = NPY_ULONG;

    
#line 4069

    _letter_to_num[NPY_LONGLONGLTR] = NPY_LONGLONG;

    
#line 4069

    _letter_to_num[NPY_ULONGLONGLTR] = NPY_ULONGLONG;

    
#line 4069

    _letter_to_num[NPY_HALFLTR] = NPY_HALF;

    
#line 4069

    _letter_to_num[NPY_FLOATLTR] = NPY_FLOAT;

    
#line 4069

    _letter_to_num[NPY_DOUBLELTR] = NPY_DOUBLE;

    
#line 4069

    _letter_to_num[NPY_LONGDOUBLELTR] = NPY_LONGDOUBLE;

    
#line 4069

    _letter_to_num[NPY_CFLOATLTR] = NPY_CFLOAT;

    
#line 4069

    _letter_to_num[NPY_CDOUBLELTR] = NPY_CDOUBLE;

    
#line 4069

    _letter_to_num[NPY_CLONGDOUBLELTR] = NPY_CLONGDOUBLE;

    
#line 4069

    _letter_to_num[NPY_OBJECTLTR] = NPY_OBJECT;

    
#line 4069

    _letter_to_num[NPY_STRINGLTR] = NPY_STRING;

    
#line 4069

    _letter_to_num[NPY_UNICODELTR] = NPY_UNICODE;

    
#line 4069

    _letter_to_num[NPY_VOIDLTR] = NPY_VOID;

    
#line 4069

    _letter_to_num[NPY_DATETIMELTR] = NPY_DATETIME;

    
#line 4069

    _letter_to_num[NPY_TIMEDELTALTR] = NPY_TIMEDELTA;

    

    _letter_to_num[NPY_STRINGLTR2] = NPY_STRING;

    #line 4085

    BOOL_Descr.fields = Py_None;

    
#line 4085

    BYTE_Descr.fields = Py_None;

    
#line 4085

    UBYTE_Descr.fields = Py_None;

    
#line 4085

    SHORT_Descr.fields = Py_None;

    
#line 4085

    USHORT_Descr.fields = Py_None;

    
#line 4085

    INT_Descr.fields = Py_None;

    
#line 4085

    UINT_Descr.fields = Py_None;

    
#line 4085

    LONG_Descr.fields = Py_None;

    
#line 4085

    ULONG_Descr.fields = Py_None;

    
#line 4085

    LONGLONG_Descr.fields = Py_None;

    
#line 4085

    ULONGLONG_Descr.fields = Py_None;

    
#line 4085

    HALF_Descr.fields = Py_None;

    
#line 4085

    FLOAT_Descr.fields = Py_None;

    
#line 4085

    DOUBLE_Descr.fields = Py_None;

    
#line 4085

    LONGDOUBLE_Descr.fields = Py_None;

    
#line 4085

    CFLOAT_Descr.fields = Py_None;

    
#line 4085

    CDOUBLE_Descr.fields = Py_None;

    
#line 4085

    CLONGDOUBLE_Descr.fields = Py_None;

    
#line 4085

    OBJECT_Descr.fields = Py_None;

    
#line 4085

    STRING_Descr.fields = Py_None;

    
#line 4085

    UNICODE_Descr.fields = Py_None;

    
#line 4085

    VOID_Descr.fields = Py_None;

    
#line 4085

    DATETIME_Descr.fields = Py_None;

    
#line 4085

    TIMEDELTA_Descr.fields = Py_None;

    

    /* Set a dictionary with type information */
    infodict = PyDict_New();
    if (infodict == NULL) return -1;


    #line 4129

    PyDict_SetItemString(infodict, "BOOL",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiiiO",
#else
            s = Py_BuildValue("ciiiiiO",
#endif
                NPY_BOOLLTR,
                NPY_BOOL,
                NPY_BITSOF_BOOL,
                _ALIGN(npy_bool),
                1,
                0,
                (PyObject *) &PyBoolArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "BYTE",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiiiO",
#else
            s = Py_BuildValue("ciiiiiO",
#endif
                NPY_BYTELTR,
                NPY_BYTE,
                NPY_BITSOF_BYTE,
                _ALIGN(npy_byte),
                NPY_MAX_BYTE,
                NPY_MIN_BYTE,
                (PyObject *) &PyByteArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "UBYTE",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiiiO",
#else
            s = Py_BuildValue("ciiiiiO",
#endif
                NPY_UBYTELTR,
                NPY_UBYTE,
                NPY_BITSOF_BYTE,
                _ALIGN(npy_ubyte),
                NPY_MAX_UBYTE,
                0,
                (PyObject *) &PyUByteArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "SHORT",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiiiO",
#else
            s = Py_BuildValue("ciiiiiO",
#endif
                NPY_SHORTLTR,
                NPY_SHORT,
                NPY_BITSOF_SHORT,
                _ALIGN(npy_short),
                NPY_MAX_SHORT,
                NPY_MIN_SHORT,
                (PyObject *) &PyShortArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "USHORT",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiiiO",
#else
            s = Py_BuildValue("ciiiiiO",
#endif
                NPY_USHORTLTR,
                NPY_USHORT,
                NPY_BITSOF_SHORT,
                _ALIGN(npy_ushort),
                NPY_MAX_USHORT,
                0,
                (PyObject *) &PyUShortArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "INT",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiiiO",
#else
            s = Py_BuildValue("ciiiiiO",
#endif
                NPY_INTLTR,
                NPY_INT,
                NPY_BITSOF_INT,
                _ALIGN(npy_int),
                NPY_MAX_INT,
                NPY_MIN_INT,
                (PyObject *) &PyIntArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "UINT",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiNiO",
#else
            s = Py_BuildValue("ciiiNiO",
#endif
                NPY_UINTLTR,
                NPY_UINT,
                NPY_BITSOF_INT,
                _ALIGN(npy_uint),
                PyLong_FromUnsignedLong(NPY_MAX_UINT),
                0,
                (PyObject *) &PyUIntArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "INTP",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiNNO",
#else
            s = Py_BuildValue("ciiiNNO",
#endif
                NPY_INTPLTR,
                NPY_INTP,
                NPY_BITSOF_INTP,
                _ALIGN(npy_intp),
                PyLong_FromLongLong((npy_longlong) NPY_MAX_INTP),
                PyLong_FromLongLong((npy_longlong) NPY_MIN_INTP),
                (PyObject *) &PyIntpArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "UINTP",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiNiO",
#else
            s = Py_BuildValue("ciiiNiO",
#endif
                NPY_UINTPLTR,
                NPY_UINTP,
                NPY_BITSOF_INTP,
                _ALIGN(npy_uintp),
                PyLong_FromUnsignedLongLong((npy_ulonglong) NPY_MAX_UINTP),
                0,
                (PyObject *) &PyUIntpArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "LONG",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiillO",
#else
            s = Py_BuildValue("ciiillO",
#endif
                NPY_LONGLTR,
                NPY_LONG,
                NPY_BITSOF_LONG,
                _ALIGN(npy_long),
                NPY_MAX_LONG,
                NPY_MIN_LONG,
                (PyObject *) &PyLongArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "ULONG",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiNiO",
#else
            s = Py_BuildValue("ciiiNiO",
#endif
                NPY_ULONGLTR,
                NPY_ULONG,
                NPY_BITSOF_LONG,
                _ALIGN(npy_ulong),
                PyLong_FromUnsignedLong((npy_ulong) NPY_MAX_ULONG),
                0,
                (PyObject *) &PyULongArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "LONGLONG",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiNNO",
#else
            s = Py_BuildValue("ciiiNNO",
#endif
                NPY_LONGLONGLTR,
                NPY_LONGLONG,
                NPY_BITSOF_LONGLONG,
                _ALIGN(npy_longlong),
                PyLong_FromLongLong((npy_longlong) NPY_MAX_LONGLONG),
                PyLong_FromLongLong((npy_longlong) NPY_MIN_LONGLONG),
                (PyObject *) &PyLongLongArrType_Type));
    Py_DECREF(s);

    
#line 4129

    PyDict_SetItemString(infodict, "ULONGLONG",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiNiO",
#else
            s = Py_BuildValue("ciiiNiO",
#endif
                NPY_ULONGLONGLTR,
                NPY_ULONGLONG,
                NPY_BITSOF_LONGLONG,
                _ALIGN(npy_ulonglong),
                PyLong_FromUnsignedLongLong((npy_ulonglong) NPY_MAX_ULONGLONG),
                0,
                (PyObject *) &PyULongLongArrType_Type));
    Py_DECREF(s);

    


    #line 4158

    PyDict_SetItemString(infodict, "HALF",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_HALFLTR,
#else
            s = Py_BuildValue("ciiiO", NPY_HALFLTR,
#endif
                NPY_HALF,
                NPY_BITSOF_HALF,
                1 * _ALIGN(npy_half),
                (PyObject *) &PyHalfArrType_Type));
    Py_DECREF(s);

    
#line 4158

    PyDict_SetItemString(infodict, "FLOAT",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_FLOATLTR,
#else
            s = Py_BuildValue("ciiiO", NPY_FLOATLTR,
#endif
                NPY_FLOAT,
                NPY_BITSOF_FLOAT,
                1 * _ALIGN(npy_float),
                (PyObject *) &PyFloatArrType_Type));
    Py_DECREF(s);

    
#line 4158

    PyDict_SetItemString(infodict, "DOUBLE",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_DOUBLELTR,
#else
            s = Py_BuildValue("ciiiO", NPY_DOUBLELTR,
#endif
                NPY_DOUBLE,
                NPY_BITSOF_DOUBLE,
                1 * _ALIGN(npy_double),
                (PyObject *) &PyDoubleArrType_Type));
    Py_DECREF(s);

    
#line 4158

    PyDict_SetItemString(infodict, "LONGDOUBLE",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_LONGDOUBLELTR,
#else
            s = Py_BuildValue("ciiiO", NPY_LONGDOUBLELTR,
#endif
                NPY_LONGDOUBLE,
                NPY_BITSOF_LONGDOUBLE,
                1 * _ALIGN(npy_longdouble),
                (PyObject *) &PyLongDoubleArrType_Type));
    Py_DECREF(s);

    
#line 4158

    PyDict_SetItemString(infodict, "CFLOAT",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_CFLOATLTR,
#else
            s = Py_BuildValue("ciiiO", NPY_CFLOATLTR,
#endif
                NPY_CFLOAT,
                NPY_BITSOF_CFLOAT,
                2 * _ALIGN(npy_cfloat),
                (PyObject *) &PyCFloatArrType_Type));
    Py_DECREF(s);

    
#line 4158

    PyDict_SetItemString(infodict, "CDOUBLE",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_CDOUBLELTR,
#else
            s = Py_BuildValue("ciiiO", NPY_CDOUBLELTR,
#endif
                NPY_CDOUBLE,
                NPY_BITSOF_CDOUBLE,
                2 * _ALIGN(npy_cdouble),
                (PyObject *) &PyCDoubleArrType_Type));
    Py_DECREF(s);

    
#line 4158

    PyDict_SetItemString(infodict, "CLONGDOUBLE",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_CLONGDOUBLELTR,
#else
            s = Py_BuildValue("ciiiO", NPY_CLONGDOUBLELTR,
#endif
                NPY_CLONGDOUBLE,
                NPY_BITSOF_CLONGDOUBLE,
                2 * _ALIGN(npy_clongdouble),
                (PyObject *) &PyCLongDoubleArrType_Type));
    Py_DECREF(s);

    

    PyDict_SetItemString(infodict, "OBJECT",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_OBJECTLTR,
#else
            s = Py_BuildValue("ciiiO", NPY_OBJECTLTR,
#endif
                NPY_OBJECT,
                sizeof(PyObject *) * CHAR_BIT,
                _ALIGN(PyObject *),
                (PyObject *) &PyObjectArrType_Type));
    Py_DECREF(s);
    PyDict_SetItemString(infodict, "STRING",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_STRINGLTR,
#else
            s = Py_BuildValue("ciiiO", NPY_STRINGLTR,
#endif
                NPY_STRING,
                0,
                _ALIGN(char),
                (PyObject *) &PyStringArrType_Type));
    Py_DECREF(s);
    PyDict_SetItemString(infodict, "UNICODE",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_UNICODELTR,
#else
            s = Py_BuildValue("ciiiO", NPY_UNICODELTR,
#endif
                NPY_UNICODE,
                0,
                _ALIGN(npy_ucs4),
                (PyObject *) &PyUnicodeArrType_Type));
    Py_DECREF(s);
    PyDict_SetItemString(infodict, "VOID",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiO", NPY_VOIDLTR,
#else
            s = Py_BuildValue("ciiiO", NPY_VOIDLTR,
#endif
                NPY_VOID,
                0,
                _ALIGN(char),
                (PyObject *) &PyVoidArrType_Type));
    Py_DECREF(s);
    PyDict_SetItemString(infodict, "DATETIME",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiNNO", NPY_DATETIMELTR,
#else
            s = Py_BuildValue("ciiiNNO", NPY_DATETIMELTR,
#endif
                NPY_DATETIME,
                NPY_BITSOF_DATETIME,
                _ALIGN(npy_datetime),
                MyPyLong_FromInt64(NPY_MAX_DATETIME),
                MyPyLong_FromInt64(NPY_MIN_DATETIME),
                (PyObject *) &PyDatetimeArrType_Type));
    Py_DECREF(s);
    PyDict_SetItemString(infodict, "TIMEDELTA",
#if defined(NPY_PY3K)
            s = Py_BuildValue("CiiiNNO", NPY_TIMEDELTALTR,
#else
            s = Py_BuildValue("ciiiNNO",NPY_TIMEDELTALTR,
#endif
                NPY_TIMEDELTA,
                NPY_BITSOF_TIMEDELTA,
                _ALIGN(npy_timedelta),
                MyPyLong_FromInt64(NPY_MAX_TIMEDELTA),
                MyPyLong_FromInt64(NPY_MIN_TIMEDELTA),
                (PyObject *)&PyTimedeltaArrType_Type));
    Py_DECREF(s);

#define SETTYPE(name)                           \
    Py_INCREF(&Py##name##ArrType_Type);         \
    PyDict_SetItemString(infodict, #name,       \
            (PyObject *)&Py##name##ArrType_Type)

    SETTYPE(Generic);
    SETTYPE(Number);
    SETTYPE(Integer);
    SETTYPE(Inexact);
    SETTYPE(SignedInteger);
    SETTYPE(UnsignedInteger);
    SETTYPE(Floating);
    SETTYPE(ComplexFloating);
    SETTYPE(Flexible);
    SETTYPE(Character);

#undef SETTYPE

    PyDict_SetItemString(dict, "typeinfo", infodict);
    Py_DECREF(infodict);
    return 0;
}

#undef _MAX_LETTER

