SELECT OBJECT_NAME(OBJECT_ID) AS NameofConstraint, SCHEMA_NAME(schema_id) AS SchemaName, 
		OBJECT_NAME(parent_object_id) AS TableName, type_desc AS ConstraintType
	FROM sys.objects
	WHERE type_desc LIKE '%CONSTRAINT' AND OBJECT_NAME(parent_object_id) = 'SequencedSample'
	ORDER BY SchemaName, TableName, NameofConstraint;

ALTER TABLE SequencedSample ADD bamFileName VarChar(255) NULL DEFAULT NULL;

ALTER TABLE ProjectSampleLinker
    DROP CONSTRAINT FK_PROJECTS_REFERENCE_SEQUENCE;
ALTER TABLE ProjectSampleLinker
   ADD CONSTRAINT FK_PROJECTS_REFERENCE_SEQUENCE FOREIGN KEY (sequencingID)
      REFERENCES SequencedSample (id) ON DELETE CASCADE;

ALTER TABLE SecondaryAnalysisLinker
    DROP CONSTRAINT FK_SECONDAR_REFERENCE_SEQUENCE;
ALTER TABLE SecondaryAnalysisLinker
   ADD CONSTRAINT FK_SECONDAR_REFERENCE_SEQUENCE FOREIGN KEY (sequencingID)
      REFERENCES SequencedSample (id) ON DELETE CASCADE;

ALTER TABLE ContactSequenceLinker
    DROP CONSTRAINT FK_CONTACTS_REFERENCE_SEQUENCE;
ALTER TABLE ContactSequenceLinker
   ADD CONSTRAINT FK_CONTACTS_REFERENCE_SEQUENCE FOREIGN KEY (sequencingID)
      REFERENCES SequencedSample (id) ON DELETE CASCADE;

INSERT INTO Contacts (firstName, lastName, lanID, internal) VALUES ('Lab', 'Tech', 'labTech', 0);
INSERT INTO ContactLinker (contactID, userRole) SELECT id, 11 FROM Contacts WHERE lanID = 'labTech';

INSERT INTO Contacts (firstName, lastName, lanID, internal) VALUES ('Test', 'PI', 'testPI', 0);
INSERT INTO ContactLinker (contactID, userRole) SELECT id, 1 FROM Contacts WHERE lanID = 'testPI';

INSERT INTO Contacts (firstName, lastName, lanID, internal) VALUES ('Test', 'User', 'testUser', 0);
INSERT INTO ContactLinker (contactID, userRole) SELECT id, 9 FROM Contacts WHERE lanID = 'testUser';

INSERT INTO ContactSequenceLinker (sequencingID, contactRoleID) SELECT sSeq.id, conLink.id 
	FROM RunInformation AS run JOIN SequencedSample AS sSeq ON sSeq.runID = run.id, 
	ContactLinker AS conLink JOIN Contacts AS contact ON contact.id = conLink.contactID
	WHERE contact.lanID = 'testPI' AND (run.id = 25 OR run.id = 26);

INSERT INTO ContactSequenceLinker (sequencingID, contactRoleID) SELECT sSeq.id, conLink.id 
	FROM RunInformation AS run JOIN SequencedSample AS sSeq ON sSeq.runID = run.id, 
	ContactLinker AS conLink JOIN Contacts AS contact ON contact.id = conLink.contactID
	WHERE contact.lanID = 'testUser' AND (run.id = 27 OR run.id = 26);

sp_help

ALTER TABLE Notes ADD deleted Bit NOT NULL DEFAULT 0;
ALTER TABLE Notes DROP COLUMN noteType;

ALTER TABLE ProjectInformation DROP CONSTRAINT DF__ProjectInfo__IRC__4B973090;
ALTER TABLE ProjectInformation DROP COLUMN IRC;
ALTER TABLE ProjectInformation ADD progress Int NOT NULL DEFAULT 0;
ALTER TABLE ProjectInformation ADD IRC Int NULL DEFAULT NULL;


TRUNCATE TABLE SecondaryAnalysisLinker;
TRUNCATE TABLE AnalysisStatusLinker;
ALTER TABLE AnalysisStatusLinker
   DROP CONSTRAINT FK_ANALYSIS_REFERENCE_SECONDAR
go
ALTER TABLE SecondaryAnalysisLinker
   DROP CONSTRAINT FK_SECONDAR_REFERENCE_SECONDAR
go
TRUNCATE TABLE SecondaryAnalysis;
ALTER TABLE AnalysisStatusLinker
   ADD CONSTRAINT FK_ANALYSIS_REFERENCE_SECONDAR FOREIGN KEY (analysisID)
      REFERENCES SecondaryAnalysis (id)
go
ALTER TABLE SecondaryAnalysisLinker
   ADD CONSTRAINT FK_SECONDAR_REFERENCE_SECONDAR FOREIGN KEY (analysisID)
      REFERENCES SecondaryAnalysis (id)
go


ALTER TABLE AccessChange
   DROP CONSTRAINT FK_AccessChange_REFERENCE_Table
go
ALTER TABLE AdHoc
   DROP CONSTRAINT FK_AdHoc_REFERENCE_TABLES
go
ALTER TABLE Notes
   DROP CONSTRAINT FK_NOTES_REFERENCE_TABLES
go

TRUNCATE TABLE Tables;

ALTER TABLE AccessChange
   ADD CONSTRAINT FK_AccessChange_REFERENCE_Table FOREIGN KEY (theTable)
      REFERENCES Tables (id)
go
ALTER TABLE AdHoc
   ADD CONSTRAINT FK_AdHoc_REFERENCE_TABLES FOREIGN KEY (theTable)
      REFERENCES Tables (id)
go
ALTER TABLE Notes
   ADD CONSTRAINT FK_NOTES_REFERENCE_TABLES FOREIGN KEY (theTable)
      REFERENCES Tables (id)
go

ALTER TABLE SequencedSample DROP COLUMN resultLocation;
ALTER TABLE SequencedSample DROP CONSTRAINT DF__Sequenced__resul__190BB0C3;
ALTER TABLE SequencedSample ADD CONSTRAINT SQLServerSucks DEFAULT 0 FOR resultLocation;
ALTER TABLE SequencedSample ALTER COLUMN resultLocation INT NOT NULL;
UPDATE SequencedSample SET resultLocation = 0 WHERE resultLocation IS NULL;
ALTER TABLE SequencedSample DROP CONSTRAINT FK_SEQUENCE_REFERENCE_FILELOCA;


UPDATE SecondaryAnalysis SET keepFileRequestor = 'Mike', deleteDate = '2011-12-23' WHERE id IN (
	SELECT secLink.analysisID FROM SecondaryAnalysisLinker AS secLink 
	JOIN SequencedSample AS sSeq ON secLink.sequencingID = sSeq.id
	JOIN RunInformation AS runs ON sSeq.runID = runs.id 
	JOIN Sample AS samples ON sSeq.sampleID = samples.id 
	JOIN ContactSequenceLinker AS conSeqLink ON conSeqLink.sequencingID = sSeq.id 
	JOIN ContactLinker AS conLink ON contactRoleID = conLink.id 
	JOIN Contacts AS contact ON conLink.contactID = contact.id 
	WHERE firstName = 'Susan' AND lastName = 'Slager' AND runs.runID = '110308_SN414_0090_B81NG1ABXX')


UPDATE SequencedSample SET keepFileRequestor = 'Mike', keepFileDate = '2011-12-23' WHERE id IN (
	SELECT sSeq.id FROM SequencedSample AS sSeq JOIN RunInformation AS runs ON sSeq.runID = runs.id 
	JOIN Sample AS samples ON sSeq.sampleID = samples.id 
	JOIN ContactSequenceLinker AS conSeqLink ON sequencingID = sSeq.id 
	JOIN ContactLinker AS conLink ON contactRoleID = conLink.id 
	JOIN Contacts AS contact ON conLink.contactID = contact.id 
	WHERE firstName = 'Susan' AND lastName = 'Slager' AND runs.runID = '110308_SN414_0090_B81NG1ABXX')

	
SELECT * FROM SecondaryAnalysis AS secAn JOIN AnalysisStatusLinker anStatLink ON anStatLink.analysisID = secAn.id 
	WHERE secAn.deleteDate IS NOT NULL AND anStatLink.theDate IS NOT NULL AND 
	secAn.deleteDate > DATEADD(DAY, 180, anStatLink.theDate)

SELECT * FROM SecondaryAnalysis AS secAn JOIN AnalysisStatusLinker anStatLink ON anStatLink.analysisID = secAn.id 
	WHERE secAn.deleteDate IS NOT NULL AND anStatLink.theDate IS NOT NULL AND 
	secAn.deleteDate > ADDDATE(anStatLink.theDate, 60);


ALTER TABLE SequencedSample 
	DROP CONSTRAINT FK_SEQUENCE_REFERENCE_FLAGSTAT
GO

ALTER TABLE SequencedSample DROP CONSTRAINT DF__Sequenced__flags__1BE81D6E

ALTER TABLE SequencedSample 
	DROP COLUMN flagstatResults
GO

ALTER TABLE RunInformation 
	DROP COLUMN cycles,
	ADD startDate            DateTime             NOT NULL,
GO

DROP INDEX REQUESTERS ON SequencedSample;

ALTER TABLE SequencedSample DROP CONSTRAINT DF__Sequenced__keepF__1AF3F935

ALTER TABLE SequencedSample 
	DROP COLUMN keepFile
GO

ALTER TABLE SequencedSample ADD 
   keepFileRequestor    varchar(255)         null default null,
   keepFileDate         DateTime             null default null,
   flagstatResults      int                  null default null;

CREATE INDEX KeepDates ON SequencedSample (
keepFileDate ASC
)
GO

CREATE INDEX REQUESTERS ON SequencedSample (
keepFileRequestor ASC
)
GO

ALTER TABLE SequencedSample
   add constraint FK_SEQUENCE_REFERENCE_FLAGSTAT foreign key (flagstatResults)
      references FlagstatResults (id)
GO

ALTER TABLE SequencedSample
   add constraint FK_SEQUENCE_REFERENCE_FILELOCA foreign key (resultLocation)
      references FileLocation (id)
go

ALTER TABLE AnalysisStatusLinker 
	DROP CONSTRAINT FK_ANALYSIS_REFERENCE_SECONDAR
GO

ALTER TABLE SecondaryAnalysisLinker 
	DROP CONSTRAINT FK_SECONDAR_REFERENCE_SECONDAR
GO

TRUNCATE TABLE SecondaryAnalysisLinker;
TRUNCATE TABLE AnalysisStatusLinker;
TRUNCATE TABLE SecondaryAnalysis;

ALTER TABLE AnalysisStatusLinker
   ADD CONSTRAINT FK_ANALYSIS_REFERENCE_SECONDAR foreign key (analysisID)
      references SecondaryAnalysis (id)
go

ALTER TABLE SecondaryAnalysisLinker
   ADD CONSTRAINT FK_SECONDAR_REFERENCE_SECONDAR foreign key (analysisID)
      references SecondaryAnalysis (id)
go

ALTER TABLE AnalysisStatusLinker 
	DROP CONSTRAINT FK_ANALYSIS_REFERENCE_STATUS
GO

TRUNCATE TABLE Status;

ALTER TABLE AnalysisStatusLinker 
   ADD CONSTRAINT FK_ANALYSIS_REFERENCE_STATUS foreign key (statusID)
      references Status (id)
GO

ALTER TABLE SecondaryAnalysis 
	DROP CONSTRAINT FK_SECONDAR_REFERENCE_ANALYSIS
GO

TRUNCATE TABLE AnalysisType;

ALTER TABLE SecondaryAnalysis 
   ADD CONSTRAINT FK_SECONDAR_REFERENCE_ANALYSIS foreign key (analysisType)
      references AnalysisType (id)
GO

SELECT * FROM SecondaryAnalysisLinker;

SELECT * FROM SecondaryAnalysis;

SELECT * FROM AnalysisType;

SELECT * FROM AnalysisStatusLinker;

SELECT * FROM Status;

SELECT samples.id FROM SequencedSample AS samples JOIN RunInformation AS runs ON samples.runID = runs.id
	JOIN Sample AS sample ON sample.id = samples.sampleID 
	WHERE sample.name = 'BCT29_GAPCR' AND runs.runID = '100709_R0174436_0081';

SELECT * FROM Sample AS sample JOIN SequencedSample AS samples ON sample.id = samples.sampleID 
	WHERE samples.id >= 83 AND samples.id <= 98;

	
SELECT DISTINCT seqSample.*, sample.name 
	FROM SequencedSample AS seqSample 
	JOIN Sample AS sample ON sample.id = seqSample.sampleID 
	JOIN RunInformation AS runs ON runs.id = seqSample.runID 
	JOIN ContactSequenceLinker AS conSeq ON conSeq.sequencingID = seqSample.id 
	JOIN ContactLinker AS conLink ON conSeq.contactRoleID = conLink.id 
	JOIN Contacts AS contacts ON conLink.contactID = contacts.id 
	WHERE userRole = 1 AND runs.runID = '20048' AND lastName = 'Olson' AND firstName = 'Timothy' AND 
		seqSample.id IN (
			SELECT sequencingID FROM ContactSequenceLinker AS seqLinker 
			JOIN ContactLinker AS contactLinker ON contactRoleID = contactLinker.id 
			WHERE contactID = 1)


SELECT * FROM dbo.Contacts WHERE lanID = '';

SELECT * FROM dbo.ContactLinker WHERE contactID IN (65, 66, 76)

SELECT sample.name, COUNT (seqSample.id) AS theCount FROM Sample AS sample 
	JOIN SequencedSample AS seqSample ON seqSample.sampleID = sample.id 
	GROUP BY sample.name;


SELECT sample.name, firstName, lastName FROM Sample AS sample 
	JOIN SequencedSample AS seqSample ON seqSample.sampleID = sample.id 
	JOIN ContactSequenceLinker AS conSeq ON sequencingID = seqSample.id 
	JOIN ContactLinker AS conLink ON contactRoleID = conLink.id 
	JOIN Contacts AS contact ON contact.id = conLink.contactID 
	WHERE sample.name IN ('20048', '20046', '12662') AND userRole = 1
	GROUP BY sample.name, lastName, firstName;


SELECT DISTINCT CONCAT (lastName, ', ', firstName) AS PIName, Runs.runID AS RunID, urlQC, 
		urlMetaData, (SELECT COUNT(*) FROM AnalysisLinker WHERE sampleID = Sample.id) AS theCount 
    FROM PIInformation AS PIs JOIN Samples AS Sample JOIN RunLinker AS Links JOIN RunInformation AS Runs 
        ON PIs.id = Sample.piID AND Links.sampleID = Sample.id AND Runs.id = Links.runID
 GROUP BY Runs.runID, Sample.piID ORDER BY Runs.runID DESC

SELECT seqSamp.id FROM SequencedSample AS seqSamp 
	JOIN Sample AS samp ON seqSamp.sampleID = samp.id 
	JOIN RunInformation AS run ON seqSamp.runID = run.id 
	WHERE run.runID = '110303_SN616_0079_B81KLHABXX' AND samp.name = '16617-N';

SELECT seqSamp.id FROM SequencedSample AS seqSamp JOIN Sample AS samp ON seqSamp.sampleID = samp.id 
    WHERE seqSamp.runID = 37 AND samp.name = '16617-N';

SELECT DISTINCT lastName, firstName AS piName, runs.runID AS runID, (
	SELECT COUNT(*) FROM SecondaryAnalysisLinker WHERE sequencingID = seqSample.id) AS theCount 
	FROM SequencedSample AS seqSample JOIN RunInformation AS runs ON runs.id = seqSample.runID 
	JOIN ContactSequenceLinker AS conSeq ON conSeq.sequencingID = seqSample.id 
	JOIN ContactLinker AS conLink ON conSeq.contactRoleID = conLink.contactID 
	JOIN Contacts AS contacts ON conLink.contactID = contacts.id WHERE userRole = 1 
	GROUP BY Runs.runID, Contacts.id ORDER BY Runs.runID DESC; 

INSERT INTO ContactSequenceLinker (sequencingID, contactRoleID) SELECT id, 80 FROM SequencedSample;

SELECT * FROM Contacts ORDER By id;

SELECT * FROM Contacts WHERE lanID = 'm082166';

SELECT * FROM Contacts WHERE lastName = 'Poland';

SELECT * FROM ContactLinker WHERE contactID = 55;

SELECT * FROM ContactSequenceLinker WHERE contactRoleID = 56;

SELECT DISTINCT run.id, run.runID FROM RunInformation AS run JOIN SequencedSample AS seq ON run.id = seq.runID
WHERE seq.id IN (SELECT sequencingID FROM ContactSequenceLinker WHERE contactRoleID = 67);

INSERT INTO Contacts (firstName, lastName, lanID, internal) VALUES ('Asif', 'Hossain', 'Hossa', 1);

SELECT DISTINCT sample.name, appType.name, primaryCompleteDate 
	FROM Sample AS sample JOIN SequencedSample AS seqSample ON sample.id = seqSample.sampleID 
	JOIN ApplicationTypes AS appType ON appType.id = seqSample.appType 
	JOIN RunInformation AS runInfo ON runInfo.id = seqSample.runID 
	WHERE seqSample.runID = 109;

SELECT * FROM RunInformation;

SELECT * FROM SequencedSample WHERE runID = 64;

SELECT DISTINCT contact.*, userRole FROM Contacts AS contact 
JOIN ContactLinker AS cLinker ON contact.id = contactID
JOIN ContactSequenceLinker ON contactRoleID = cLinker.id
WHERE sequencingID IN (SELECT id FROM SequencedSample WHERE runID = 64);


SELECT DISTINCT lastName + ', ' + firstName AS piName, runs.runID AS runID, 
	COUNT(DISTINCT secAnLink.sequencingID) AS theCount 
		FROM SequencedSample AS seqSample 
		JOIN RunInformation AS runs ON runs.id = seqSample.runID 
		JOIN ContactSequenceLinker AS conSeq ON conSeq.sequencingID = seqSample.id 
		JOIN ContactLinker AS conLink ON conSeq.contactRoleID = conLink.id 
		JOIN Contacts AS contacts ON conLink.contactID = contacts.id 
		LEFT OUTER JOIN SecondaryAnalysisLinker AS secAnLink ON secAnLink.sequencingID = seqSample.id 
		WHERE userRole = 1 AND lastName = 'Poland' AND firstName = 'Gregory' AND seqSample.id IN (
			SELECT sequencingID FROM ContactSequenceLinker AS seqLinker 
				JOIN ContactLinker AS contactLinker ON contactRoleID = contactLinker.id 
				WHERE contactID = 78) 
		GROUP BY contacts.id, lastName, firstName, runs.runID ORDER BY runs.runID DESC;


SELECT DISTINCT lastName + ', ' + firstName AS piName, runs.runID AS runID, 
	COUNT(DISTINCT secAnLink.sequencingID) AS theCount 
		FROM SequencedSample AS seqSample 
		JOIN RunInformation AS runs ON runs.id = seqSample.runID 
		JOIN ContactSequenceLinker AS conSeq ON conSeq.sequencingID = seqSample.id 
		JOIN ContactLinker AS conLink ON conSeq.contactRoleID = conLink.id 
		JOIN Contacts AS contacts ON conLink.contactID = contacts.id 
		LEFT OUTER JOIN SecondaryAnalysisLinker AS secAnLink ON secAnLink.sequencingID = seqSample.id 
		WHERE userRole = 1 AND lastName = 'Poland' AND firstName = 'Gregory' AND seqSample.id IN (
			SELECT sequencingID FROM ContactSequenceLinker AS seqLinker 
				JOIN ContactLinker AS contactLinker ON contactRoleID = contactLinker.id 
				WHERE contactID = 78) 
		GROUP BY contacts.id, lastName, firstName, runs.runID ORDER BY runs.runID DESC;


SELECT DISTINCT lastName + ', ' + firstName AS piName, runs.runID, 
	COUNT(DISTINCT secAnLink.sequencingID) AS theCount 
		FROM RunInformation AS runs 
		JOIN SequencedSample AS seq ON runs.id = seq.runID 
		JOIN ContactSequenceLinker AS conSeq ON conSeq.sequencingID = seq.id 
		JOIN ContactLinker AS cLinker ON conSeq.contactRoleID = cLinker.id
		JOIN Contacts AS contact ON cLinker.contactID = contact.id 
		LEFT OUTER JOIN SecondaryAnalysisLinker AS secAnLink ON secAnLink.sequencingID = seq.id 
		WHERE cLinker.id = 56
	GROUP BY runs.runID, contact.id, lastName, firstName ORDER BY runs.runID DESC;

SELECT DISTINCT lastName + ', ' + firstName AS piName, runs.runID, 
	COUNT(DISTINCT secAnLink.sequencingID) AS theCount 
		FROM RunInformation AS runs 
		JOIN SequencedSample AS seq ON runs.id = seq.runID
		JOIN ContactSequenceLinker AS csl ON csl.sequencingID = seq.id
		JOIN ContactLinker AS link ON csl.contactRoleID = link.id 
		JOIN Contacts AS contact ON link.contactID = contact.id 
		LEFT OUTER JOIN SecondaryAnalysisLinker AS secAnLink ON secAnLink.sequencingID = seq.id 
		WHERE contact.id = 55
	GROUP BY runs.runID, contact.id, lastName, firstName ORDER BY runs.runID DESC;

		AND seqSample.id IN (
			SELECT sequencingID FROM ContactSequenceLinker AS seqLinker 
				JOIN ContactLinker AS contactLinker ON contactRoleID = contactLinker.id 
				WHERE contactID = 78) 


SELECT * FROM ContactSequenceLinker WHERE sequencingID IN (SELECT id FROM SequencedSample WHERE runID = 64);

SELECT * FROM ContactLinker WHERE id = 80;

SELECT * FROM Contacts WHERE id = 78;
