#!/bin/sh
RUN_NAME=$1
STAGING=/data2/labdata/mbcf/ga2/staging/runs
APPROVED=/data2/labdata/mbcf/ga2/approved
mv $STAGING/$RUN_NAME $APPROVED/$RUN_NAME
if [ $? == 0 ]; then
	# refresh metadata
	cd ~/applications/illumina/ga2/v1.6.0/mayo/NGS_Primary_Analysis
	cvs update metadata

	# extract to delivery space
	cd ~/logs
	java -cp ~/applications/illumina/ga2/v1.6.0/mayo/NGS_Primary_Analysis/target/NGS_Primary_Analysis-0.0.1-SNAPSHOT-jar-with-dependencies.jar illumina.seq.proc.ExtractFilteredReads -metadata xml -run $RUN_NAME 2>extract_$RUN_NAME.stderr.txt 1>extract_$RUN_NAME.stdout.txt

	if [ $? == 0 ]; then
		# send e-mail notification
		TO="DLNGSSupport@exchange.mayo.edu"
		CC="eckloff.bruce@mayo.edu"
		SUB="Run $RUN_NAME approved"
		MESG="Run $RUN_NAME processing is complete and has passed QC checks by the NGS lab.\\n\\nYou now have read access to the following location on the RCF Cluster: $APPROVED/$RUN_NAME\\n"
		echo -e "$MESG" | mailx -s "$SUB" -c "$CC" "$TO"
	else
		echo "failed to extract run $RUN_NAME to delivery space"
		exit 1
	fi
else
	echo "failed to move run $RUN_NAME from staging to approved"
	exit 1
fi
