#!/bin/sh
# archive to the delivery space on the RCF cluster using
# the aspera connect command line interface 
#
#
# Examples:
#
#	./aspera_transfer.sh -i horton_iain_m076944 -r 12828_2828_11111,201029290_2128128_21828 -p primary

# configure shell to exit the script if any statement exits with non-zero
set -e

usage() {
   echo "usage: $0 options"
   echo ""
   echo "   This script will transfer data from the research archive to a destination"
   echo "   of your choice using Aspera Connect."
   echo ""
   echo "   OPTIONS:"
   echo "     -h|--help      	  Show this message"
   echo "     -i|--investigator	  Directory loction on the research archive - only specify PI folder (ex: bar_foo_m0111111)"
   echo "     -r|--run		      Comma seperated list of run folder(s) to transfer"
   echo "     -p|--pipeline	      The analysis folder to transfer (primary, secondary, or teritiary)"
   echo "     -e|--exclude        The type of file to exclude (bam or fastq)  - Note: FASTQs may or may  not be archived"
}

#convert possible long arugment versions to short for getopts usage
for arg
do
    delim=""
    case "$arg" in\
     	--help) args="${args}-h ";;
       	--investigator_dir) args="${args}-i ";;
       	--run) args="${args}-r ";;
       	--pipleine) args="${args}-p ";;
       	--exclude) args="${args}-e ";;
       	*) [[ "${arg:0:1}" == "-" ]] || delim="\""
           args="${args}${delim}${arg}${delim} ";;
    esac
done
# reset the translated args
eval set -- $args 

while getopts ":hd:i:p:r:e:" opt; do
  case $opt in
    h)
       usage;;
    i)
       PI_DIR=$OPTARG ;;
    p)
       PIPELINE=$OPTARG ;;
    r)
       RUN=$OPTARG ;;
    e)
       EXCLUDE=$OPTARG ;;
    \?)
       echo "Invalid option: -$OPTARG" >&2
       exit 1
       ;;
    :)
       echo "Option -$OPTARG requires an argument." >&2
       exit 1
       ;;
  esac
done

if [[ -z $PI_DIR ]] || [[ -z $RUN ]] || [[ -z $PIPELINE ]]
then
   usage
   exit 1
fi

# Prompt for Username and Password for transfer
echo Username:
read -s user
echo
echo Password:
read -s passwd
echo

ASPERA_INSTALL_DIR=/home/tu02698/.aspera/connect
ASPERA_CMD=/home/tu02698/bin/ascp
export ASPERA_SCP_PASS=$passwd
SOURCE_HOST=research-archive.mayo.edu

IFS=',' 
RUN_ARRAY=$RUN
for i in $RUN_ARRAY; do 
  DEST_DIR=/data2/delivery/archive_restore_none/${PI_DIR}/${i}
  mkdir -p ${DEST_DIR}
  nohup ${ASPERA_CMD} -dTQ -l 100m -m 0 -k 2 -E ${EXCLUDE} --ignore-host-key mfad\\${user}@${SOURCE_HOST}:NGS/delivery/${PI_DIR}/${i}/${PIPELINE} ${DEST_DIR} > $i.out 2>&1 &
done

unset IFS