/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipInputStream;
import org.itadaki.bzip2.BZip2InputStream;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.util.ConcatGZIPInputStream;
import org.usadellab.trimmomatic.util.PositionTrackingInputStream;

public class FastqParser {
    private int phredOffset;
    private PositionTrackingInputStream posTrackInputStream;
    private BufferedReader reader;
    private FastqRecord current;
    private long fileLength;
    private AtomicBoolean atEOF;

    public FastqParser(int phredOffset) {
        this.phredOffset = phredOffset;
        this.atEOF = new AtomicBoolean();
    }

    public void parseOne() throws IOException {
        this.current = null;
        String line = this.reader.readLine();
        if (line == null) {
            this.atEOF.set(true);
            return;
        }
        if (line.charAt(0) != '@') {
            throw new RuntimeException("Invalid FASTQ name line: " + line);
        }
        String name = line.substring(1);
        String sequence = this.reader.readLine();
        line = this.reader.readLine();
        if (line.charAt(0) != '+') {
            throw new RuntimeException("Invalid FASTQ comment line: " + line);
        }
        String comment = line.substring(1);
        String quality = this.reader.readLine();
        this.current = new FastqRecord(name, sequence, comment, quality, this.phredOffset);
    }

    public int getProgress() {
        if (this.atEOF.get()) {
            return 100;
        }
        long bytesRead = this.posTrackInputStream.getPosition();
        return (int)((float)bytesRead / (float)this.fileLength * 100.0f);
    }

    public void parse(File file) throws IOException {
        String name = file.getName();
        this.fileLength = file.length();
        InputStream contentInputStream = this.posTrackInputStream = new PositionTrackingInputStream(new FileInputStream(file));
        if (name.toLowerCase().endsWith(".gz")) {
            contentInputStream = new ConcatGZIPInputStream(this.posTrackInputStream);
        } else if (name.toLowerCase().endsWith(".bz2")) {
            contentInputStream = new BZip2InputStream(this.posTrackInputStream, false);
        } else if (name.toLowerCase().endsWith(".zip")) {
            contentInputStream = new ZipInputStream(this.posTrackInputStream);
        }
        this.reader = new BufferedReader(new InputStreamReader(contentInputStream), 32768);
        this.parseOne();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean hasNext() {
        return this.current != null;
    }

    public FastqRecord next() throws IOException {
        FastqRecord current = this.current;
        this.parseOne();
        return current;
    }
}

