#!/usr/local/bin/perl5 -w

die "Cannot execute ../src/ntdpal" unless -x '../src/ntdpal';
$ENV{TC_SILENT} = '1';

# Test error handling on over-long input sequence:

print STDERR 'Long sequence error handling...';
$r = system '../src/ntdpal ACGTGTTCGTCGTAAATAACATGCTATATT GACGTAGACAACCCTGTGTTTAGCCTGCGTTTTGTGCCATCCTAATGCTTTACTAGATCACTGAGCCACCTCCCAAGGACTACACCTAGCGGTATTTCGTACATTAACTAGGATCCTTTTCCACATGGACTACAATGTCTGCCGAGCATGCGATGGGGTACCGCGCCCGCGCACATACGCGCGCAGAGCTTTTGGAGGCATACCTACACCGGCGAGGGGCTGCGGTTTATTGACACTGAAACGGGATAACGAGTCGCTGAATTGAGCCAAAAATATGCAAGCGTCACAAATTGTGACAAAAATTTTAAAGGAAAAATTAGACCATTGATTCTGAAGTGGTGCGTATAGGACCAGTCGTGGCAATGAGACCGATTTGAGTAGCACTAGCTCAAACACTGTCTGGGTCGCCATCAAGGCCACAAGAACTTAAGCAGCCGTCACCCTATAGAAGGTTAAGCGACGGTTAGGGCTTCTGGCAACGAAAGTTGTCGGTTCGTCCTGTGCCAACGTGTGGCAAAGTCTACTATGATTCGATTGTTGACGTGTCGACAGGCTGTTTCGCTGGATACCCCACCTTGATAATTTTTCTCGTCGAACGCTAGCAGTTTTTTTTTCAACGGCCCGGAATCTGTAAGAGGCCGTTGCAGGAACGCGTGTGTATGTAAATGCCCACTACTTCTGTTATGTACCCAAATGGCGTGCGGCGTGGATGTATAGTGTCGACCCTCCATAATCGGGCGGACGGTCGTGGGGTATGTATGATCTTCGGCACTGATTCGCCTCGAGTCTATATGTTCTTAATCCAGACCTTCGGGGAAAGCCTACTTTCCATCCGTTGTCTAGCGTCATGCCAGTGACTACTGTTGTATTGTCTGGTTCCTAAGATAGCCATGGATTCCGGACATCGACGATGCACAAGAGCGTTAGCGCTGGTGTGCAACGCAACGTCGCGAAGGCTGGGTTACAGCGTGATCTCCTGGCTGCACCCAGATGCAGAGGGACATACCTACGATGAATAGGTGCGTCTGTTTATAAACGCCCAATCCTAGCAAAAATCACAACTAAGACAGTGTATGGAAGACCCACCAGTTGTGGGCGAATGGTCAGGTATACAAGATCGTGTCAAGACGGAACTTAAGCTTCTGTGCGCTCTCCATGCGAGCTGGTACGTCTGGACGGCGAGGTATGAGTGAATGACCATCCATGGCAACTTTCGTGTTCTACGACAGATACGAGCTCGACGGACGACCTGGTGACCAGTAGTATATGCGCGTCCGTCGGCCAGACTTTCCAAACGCCCTTTCAACGAGATACATGCGAACACGCTACAATTTCTCGTTCCGTCTAAAGTCGATACTCGCAAGCCCAGGCCCGTTACTACAACGCTGTTAATAGGATCAGAAGGGCCATAAGACTTTGGCAGCGGTAGCTAGGAAAGTGATGGTTGTGATGGCCCTAGTAAGGAGTCAGCCATCTACCCAACTATTTGAATGGGACCATAGCCAAGGGACCCAGCTGTTCCTTAGAAACCTGGTGACTCCCTTAGCCAATTGTGTAACTTCGTGCGTGCCAGTATTACACCTATAATCACAAGACCCCTTCAATACGAGTCCTGTGGCGTAGTGTTCCATCAAAACAATCAAGAACAGATTTCCGGTCCCCGTTGTGTTGGGATCTAGCGGACGTTGTCGGTAGATCAATAACGTAAATGCGAATCGAAGTTCTCTGGCCTAAAACAACTGCGCGCAGGGCCTCCGGTCATTGCATCTTTCTTGTCTCTCGTGAGGGCGTGATTCGTTTACCTGGAGCGAGCCGGGCACAAGAGCTATGGATTATTGGCTGGTGCAAAAACCATTCTAGCTACAATTATACTCGCGTGTCGACGATAAGAGTGAAATCACTGCGTAGGCAAACTGCCGGGTCACCAAGAGAGGCTGATACCGCGGTTCACCC l > dpal_tmp 2>&1';
open X, 'dpal_tmp';
@foo = <X>;
close X;
print STDERR
    ($foo[1] eq "Sequence 2 longer than DPAL_MAX_ALIGN and alignment is requested\n"
     ? "OK\n" : "FAILED\n");

runtest('Default implementations + alignment',
	"dpal_gen.pl '../src/ntdpal' <dpal_input",
	'dpal_output');
system "cat dpal_tmp > dpal_output1";

runtest('Default implementations + NO alignment 1',
	"dpal_gen.pl '../src/ntdpal -s' <dpal_input",
	'dpal_score_output');
system "cat dpal_tmp > dpal_score_output1";

runtest('Default implementations + NO alignment 2',
	"dpal_gen.pl '../src/ntdpal -s' <dpal_long_input",
	'dpal_long_score_output');
system "cat dpal_tmp > dpal_long_score_output1";

runtest('Force _dpal_generic',
	"dpal_gen.pl '../src/ntdpal -s -f1' <dpal_input",
	'dpal_score_output');
system "cat dpal_tmp > dpal_score_output4";

runtest('Force _dpal_long_nopath_generic 1',
	"dpal_gen.pl '../src/ntdpal -s -f2' <dpal_input",
	'dpal_score_output');
system "cat dpal_tmp > dpal_score_output2";

runtest('Force _dpal_long_nopath_generic 2',
	"dpal_gen.pl '../src/ntdpal -s -f2' <dpal_long_input",
	'dpal_long_score_output');
system "cat dpal_tmp > dpal_long_score_output2";

runtest('Force long maxgap1 functions 1',
	"dpal_gen.pl '../src/ntdpal -s -f3' <dpal_input",
	'dpal_score_output');
system "cat dpal_tmp > dpal_score_output3";

runtest('Force long maxgap1 functions 2',
	"dpal_gen.pl '../src/ntdpal -s -f3' <dpal_long_input",
	'dpal_long_score_output');
system "cat dpal_tmp > dpal_long_score_output3";

exit;

sub runtest {
    my ($desc, $cmd, $benchfile) = @_;
    print STDERR $desc, '...';
#    system $cmd .  ' > dpal_tmp 2>&1';
    system $cmd .  ' > dpal_tmp';
    $r = system "diff $benchfile dpal_tmp";
    print STDERR $r == 0 ? "OK\n" : "FAILED\n";
}

