/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMHeaderRecordComparator;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordUtil;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class SAMUtils {
    private static final byte COMPRESSED_EQUAL_LOW = 0;
    private static final byte COMPRESSED_A_LOW = 1;
    private static final byte COMPRESSED_C_LOW = 2;
    private static final byte COMPRESSED_M_LOW = 3;
    private static final byte COMPRESSED_G_LOW = 4;
    private static final byte COMPRESSED_R_LOW = 5;
    private static final byte COMPRESSED_S_LOW = 6;
    private static final byte COMPRESSED_V_LOW = 7;
    private static final byte COMPRESSED_T_LOW = 8;
    private static final byte COMPRESSED_W_LOW = 9;
    private static final byte COMPRESSED_Y_LOW = 10;
    private static final byte COMPRESSED_H_LOW = 11;
    private static final byte COMPRESSED_K_LOW = 12;
    private static final byte COMPRESSED_D_LOW = 13;
    private static final byte COMPRESSED_B_LOW = 14;
    private static final byte COMPRESSED_N_LOW = 15;
    private static final byte COMPRESSED_EQUAL_HIGH = 0;
    private static final byte COMPRESSED_A_HIGH = 16;
    private static final byte COMPRESSED_C_HIGH = 32;
    private static final byte COMPRESSED_G_HIGH = 64;
    private static final byte COMPRESSED_T_HIGH = -128;
    private static final byte COMPRESSED_N_HIGH = -16;
    private static final byte COMPRESSED_M_HIGH = 48;
    private static final byte COMPRESSED_R_HIGH = 80;
    private static final byte COMPRESSED_S_HIGH = 96;
    private static final byte COMPRESSED_V_HIGH = 112;
    private static final byte COMPRESSED_W_HIGH = -112;
    private static final byte COMPRESSED_Y_HIGH = -96;
    private static final byte COMPRESSED_H_HIGH = -80;
    private static final byte COMPRESSED_K_HIGH = -64;
    private static final byte COMPRESSED_D_HIGH = -48;
    private static final byte COMPRESSED_B_HIGH = -32;
    public static final int MAX_PHRED_SCORE = 93;
    private static final SAMHeaderRecordComparator<SAMReadGroupRecord> HEADER_RECORD_COMPARATOR = new SAMHeaderRecordComparator("PU", "LB", "DT", "SM", "CN", "PL", "DS", "ID");

    static byte[] bytesToCompressedBases(byte[] readBases) {
        int i;
        byte[] compressedBases = new byte[(readBases.length + 1) / 2];
        for (i = 1; i < readBases.length; i += 2) {
            compressedBases[i / 2] = (byte)(SAMUtils.charToCompressedBaseHigh(readBases[i - 1]) | SAMUtils.charToCompressedBaseLow(readBases[i]));
        }
        if (i == readBases.length) {
            compressedBases[i / 2] = SAMUtils.charToCompressedBaseHigh((char)readBases[i - 1]);
        }
        return compressedBases;
    }

    public static byte[] compressedBasesToBytes(int length, byte[] compressedBases, int compressedOffset) {
        int i;
        byte[] ret = new byte[length];
        for (i = 1; i < length; i += 2) {
            int compressedIndex = i / 2 + compressedOffset;
            ret[i - 1] = SAMUtils.compressedBaseToByteHigh(compressedBases[compressedIndex]);
            ret[i] = SAMUtils.compressedBaseToByteLow(compressedBases[compressedIndex]);
        }
        if (i == length) {
            ret[i - 1] = SAMUtils.compressedBaseToByteHigh(compressedBases[i / 2 + compressedOffset]);
        }
        return ret;
    }

    private static byte charToCompressedBaseLow(int base) {
        switch (base) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 71: 
            case 103: {
                return 4;
            }
            case 84: 
            case 116: {
                return 8;
            }
            case 46: 
            case 78: 
            case 110: {
                return 15;
            }
            case 77: 
            case 109: {
                return 3;
            }
            case 82: 
            case 114: {
                return 5;
            }
            case 83: 
            case 115: {
                return 6;
            }
            case 86: 
            case 118: {
                return 7;
            }
            case 87: 
            case 119: {
                return 9;
            }
            case 89: 
            case 121: {
                return 10;
            }
            case 72: 
            case 104: {
                return 11;
            }
            case 75: 
            case 107: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 66: 
            case 98: {
                return 14;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte charToCompressedBaseHigh(int base) {
        switch (base) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 16;
            }
            case 67: 
            case 99: {
                return 32;
            }
            case 71: 
            case 103: {
                return 64;
            }
            case 84: 
            case 116: {
                return -128;
            }
            case 46: 
            case 78: 
            case 110: {
                return -16;
            }
            case 77: 
            case 109: {
                return 48;
            }
            case 82: 
            case 114: {
                return 80;
            }
            case 83: 
            case 115: {
                return 96;
            }
            case 86: 
            case 118: {
                return 112;
            }
            case 87: 
            case 119: {
                return -112;
            }
            case 89: 
            case 121: {
                return -96;
            }
            case 72: 
            case 104: {
                return -80;
            }
            case 75: 
            case 107: {
                return -64;
            }
            case 68: 
            case 100: {
                return -48;
            }
            case 66: 
            case 98: {
                return -32;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte compressedBaseToByteLow(int base) {
        switch (base & 0xF) {
            case 0: {
                return 61;
            }
            case 1: {
                return 65;
            }
            case 2: {
                return 67;
            }
            case 4: {
                return 71;
            }
            case 8: {
                return 84;
            }
            case 15: {
                return 78;
            }
            case 3: {
                return 77;
            }
            case 5: {
                return 82;
            }
            case 6: {
                return 83;
            }
            case 7: {
                return 86;
            }
            case 9: {
                return 87;
            }
            case 10: {
                return 89;
            }
            case 11: {
                return 72;
            }
            case 12: {
                return 75;
            }
            case 13: {
                return 68;
            }
            case 14: {
                return 66;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte compressedBaseToByteHigh(int base) {
        switch ((byte)(base & 0xF0)) {
            case 0: {
                return 61;
            }
            case 16: {
                return 65;
            }
            case 32: {
                return 67;
            }
            case 64: {
                return 71;
            }
            case -128: {
                return 84;
            }
            case -16: {
                return 78;
            }
            case 48: {
                return 77;
            }
            case 80: {
                return 82;
            }
            case 96: {
                return 83;
            }
            case 112: {
                return 86;
            }
            case -112: {
                return 87;
            }
            case -96: {
                return 89;
            }
            case -80: {
                return 72;
            }
            case -64: {
                return 75;
            }
            case -48: {
                return 68;
            }
            case -32: {
                return 66;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    static void normalizeBases(byte[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = StringUtil.toUpperCase(bases[i]);
            if (bases[i] != 46) continue;
            bases[i] = 78;
        }
    }

    public static String phredToFastq(byte[] data) {
        if (data == null) {
            return null;
        }
        return SAMUtils.phredToFastq(data, 0, data.length);
    }

    public static String phredToFastq(byte[] buffer, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = SAMUtils.phredToFastq(buffer[offset + i] & 0xFF);
        }
        return new String(chars);
    }

    public static char phredToFastq(int phredScore) {
        if (phredScore < 0 || phredScore > 93) {
            throw new IllegalArgumentException("Cannot encode phred score: " + phredScore);
        }
        return (char)(33 + phredScore);
    }

    public static byte[] fastqToPhred(String fastq) {
        if (fastq == null) {
            return null;
        }
        int length = fastq.length();
        byte[] scores = new byte[length];
        for (int i = 0; i < length; ++i) {
            scores[i] = (byte)SAMUtils.fastqToPhred(fastq.charAt(i));
        }
        return scores;
    }

    public static void fastqToPhred(byte[] fastq) {
        for (int i = 0; i < fastq.length; ++i) {
            fastq[i] = (byte)SAMUtils.fastqToPhred((char)(fastq[i] & 0xFF));
        }
    }

    public static int fastqToPhred(char ch) {
        if (ch < '!' || ch > '~') {
            throw new IllegalArgumentException("Invalid fastq character: " + ch);
        }
        return ch - 33;
    }

    static int reg2bin(int beg, int end) {
        return GenomicIndexUtil.reg2bin(beg, end);
    }

    static void processValidationErrors(List<SAMValidationError> validationErrors, long samRecordIndex, ValidationStringency validationStringency) {
        if (validationErrors != null && validationErrors.size() > 0) {
            for (SAMValidationError validationError : validationErrors) {
                validationError.setRecordNumber(samRecordIndex);
            }
            if (validationStringency == ValidationStringency.STRICT) {
                throw new SAMFormatException("SAM validation error: " + validationErrors.get(0));
            }
            if (validationStringency == ValidationStringency.LENIENT) {
                for (SAMValidationError error : validationErrors) {
                    System.err.println("Ignoring SAM validation error: " + error);
                }
            }
        }
    }

    public static void processValidationError(SAMValidationError validationError, ValidationStringency validationStringency) {
        if (validationStringency == ValidationStringency.STRICT) {
            throw new SAMFormatException("SAM validation error: " + validationError);
        }
        if (validationStringency == ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error: " + validationError);
        }
    }

    public static String calculateReadGroupRecordChecksum(File input) {
        MessageDigest digest;
        String ENCODING = "UTF-8";
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new Error("No MD5 algorithm was available in a Java JDK? Unheard-of!");
        }
        SAMFileReader reader = new SAMFileReader(input);
        ArrayList<SAMReadGroupRecord> sortedRecords = new ArrayList<SAMReadGroupRecord>(reader.getFileHeader().getReadGroups());
        Collections.sort(sortedRecords, HEADER_RECORD_COMPARATOR);
        for (SAMReadGroupRecord rgRecord : sortedRecords) {
            TreeMap<String, String> sortedAttributes = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : rgRecord.getAttributes()) {
                sortedAttributes.put(entry.getKey(), entry.getValue());
            }
            try {
                for (Map.Entry<String, String> entry : sortedAttributes.entrySet()) {
                    if (entry.getKey().equals("ID")) continue;
                    digest.update(entry.getKey().getBytes("UTF-8"));
                    digest.update(entry.getValue().getBytes("UTF-8"));
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error("No UTF-8!? WTH?");
            }
        }
        StringBuilder hashText = new StringBuilder(new BigInteger(1, digest.digest()).toString(16));
        while (hashText.length() < 32) {
            hashText.insert(0, "0");
        }
        return hashText.toString();
    }

    public static void chainSAMProgramRecord(SAMFileHeader header, SAMProgramRecord program) {
        List<SAMProgramRecord> pgs = header.getProgramRecords();
        if (pgs.size() > 0) {
            ArrayList<String> referencedIds = new ArrayList<String>();
            for (SAMProgramRecord pg : pgs) {
                if (pg.getPreviousProgramGroupId() == null) continue;
                referencedIds.add(pg.getPreviousProgramGroupId());
            }
            for (SAMProgramRecord pg : pgs) {
                if (pg.getProgramGroupId().equals(program.getProgramGroupId()) || referencedIds.contains(pg.getProgramGroupId())) continue;
                program.setPreviousProgramGroupId(pg.getProgramGroupId());
                break;
            }
        }
    }

    public static void makeReadUnmapped(SAMRecord rec) {
        if (rec.getReadNegativeStrandFlag()) {
            SAMRecordUtil.reverseComplement(rec);
            rec.setReadNegativeStrandFlag(false);
        }
        rec.setDuplicateReadFlag(false);
        rec.setReferenceIndex(-1);
        rec.setAlignmentStart(0);
        rec.setCigarString("*");
        rec.setMappingQuality(0);
        rec.setInferredInsertSize(0);
        rec.setNotPrimaryAlignmentFlag(false);
        rec.setProperPairFlag(false);
        rec.setReadUnmappedFlag(true);
    }

    public static boolean cigarMapsNoBasesToRef(Cigar cigar) {
        for (CigarElement el : cigar.getCigarElements()) {
            if (!el.getOperator().consumesReadBases() || !el.getOperator().consumesReferenceBases()) continue;
            return false;
        }
        return true;
    }

    public static boolean recordMapsEntirelyBeyondEndOfReference(SAMRecord record) {
        return record.getHeader().getSequence(record.getReferenceIndex()).getSequenceLength() < record.getAlignmentStart();
    }

    public static int compareMapqs(int mapq1, int mapq2) {
        if (mapq1 == mapq2) {
            return 0;
        }
        if (mapq1 == 0) {
            return -1;
        }
        if (mapq2 == 0) {
            return 1;
        }
        if (mapq1 == 255) {
            return -1;
        }
        if (mapq2 == 255) {
            return 1;
        }
        return mapq1 - mapq2;
    }

    public static int combineMapqs(int m1, int m2) {
        m1 = m1 == 255 ? 1 : (m1 *= 100);
        m2 = m2 == 255 ? 1 : (m2 *= 100);
        return m1 + m2;
    }

    public static long findVirtualOffsetOfFirstRecordInBam(File bamFile) {
        try {
            return BAMFileReader.findVirtualOffsetOfFirstRecord(bamFile);
        }
        catch (IOException ioe) {
            throw new RuntimeEOFException(ioe);
        }
    }

    public static List<AlignmentBlock> getAlignmentBlocks(Cigar cigar, int alignmentStart, String cigarTypeName) {
        if (cigar == null) {
            return Collections.emptyList();
        }
        ArrayList<AlignmentBlock> alignmentBlocks = new ArrayList<AlignmentBlock>();
        int readBase = 1;
        int refBase = alignmentStart;
        block9: for (CigarElement e : cigar.getCigarElements()) {
            switch (e.getOperator()) {
                case H: {
                    continue block9;
                }
                case P: {
                    continue block9;
                }
                case S: {
                    readBase += e.getLength();
                    continue block9;
                }
                case N: {
                    refBase += e.getLength();
                    continue block9;
                }
                case D: {
                    refBase += e.getLength();
                    continue block9;
                }
                case I: {
                    readBase += e.getLength();
                    continue block9;
                }
                case M: 
                case EQ: 
                case X: {
                    int length = e.getLength();
                    alignmentBlocks.add(new AlignmentBlock(readBase, refBase, length));
                    readBase += length;
                    refBase += length;
                    continue block9;
                }
            }
            throw new IllegalStateException("Case statement didn't deal with " + cigarTypeName + " op: " + (Object)((Object)e.getOperator()));
        }
        return Collections.unmodifiableList(alignmentBlocks);
    }

    public static int getUnclippedStart(int alignmentStart, Cigar cigar) {
        CigarElement cig;
        CigarOperator op;
        int unClippedStart = alignmentStart;
        Iterator<CigarElement> i$ = cigar.getCigarElements().iterator();
        while (i$.hasNext() && ((op = (cig = i$.next()).getOperator()) == CigarOperator.SOFT_CLIP || op == CigarOperator.HARD_CLIP)) {
            unClippedStart -= cig.getLength();
        }
        return unClippedStart;
    }

    public static int getUnclippedEnd(int alignmentEnd, Cigar cigar) {
        CigarElement cig;
        CigarOperator op;
        int unClippedEnd = alignmentEnd;
        List<CigarElement> cigs = cigar.getCigarElements();
        for (int i = cigs.size() - 1; i >= 0 && ((op = (cig = cigs.get(i)).getOperator()) == CigarOperator.SOFT_CLIP || op == CigarOperator.HARD_CLIP); --i) {
            unClippedEnd += cig.getLength();
        }
        return unClippedEnd;
    }

    public static String getMateCigarString(SAMRecord rec) {
        return rec.getStringAttribute(SAMTag.MC.name());
    }

    public static Cigar getMateCigar(SAMRecord rec, boolean withValidation) {
        String mateCigarString = SAMUtils.getMateCigarString(rec);
        Cigar mateCigar = null;
        if (mateCigarString != null) {
            mateCigar = TextCigarCodec.getSingleton().decode(mateCigarString);
            if (withValidation && rec.getValidationStringency() != ValidationStringency.SILENT) {
                List<AlignmentBlock> alignmentBlocks = SAMUtils.getAlignmentBlocks(mateCigar, rec.getMateAlignmentStart(), "mate cigar");
                SAMUtils.processValidationErrors(SAMUtils.validateCigar(rec, mateCigar, rec.getMateReferenceIndex(), alignmentBlocks, -1L, "Mate CIGAR"), -1L, rec.getValidationStringency());
            }
        }
        return mateCigar;
    }

    public static Cigar getMateCigar(SAMRecord rec) {
        return SAMUtils.getMateCigar(rec, false);
    }

    public static int getMateCigarLength(SAMRecord rec) {
        Cigar mateCigar = SAMUtils.getMateCigar(rec);
        return mateCigar != null ? mateCigar.numCigarElements() : 0;
    }

    public static int getMateAlignmentEnd(SAMRecord rec) {
        if (rec.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateAlignmentEnd called on an unmapped mate.");
        }
        Cigar mateCigar = SAMUtils.getMateCigar(rec);
        if (mateCigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found.");
        }
        return CoordMath.getEnd(rec.getMateAlignmentStart(), mateCigar.getReferenceLength());
    }

    public static int getMateUnclippedStart(SAMRecord rec) {
        if (rec.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateUnclippedStart called on an unmapped mate.");
        }
        Cigar mateCigar = SAMUtils.getMateCigar(rec);
        if (mateCigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found.");
        }
        return SAMUtils.getUnclippedStart(rec.getMateAlignmentStart(), mateCigar);
    }

    public static int getMateUnclippedEnd(SAMRecord rec) {
        if (rec.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateUnclippedEnd called on an unmapped mate.");
        }
        Cigar mateCigar = SAMUtils.getMateCigar(rec);
        if (mateCigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found.");
        }
        return SAMUtils.getUnclippedEnd(SAMUtils.getMateAlignmentEnd(rec), mateCigar);
    }

    public static List<AlignmentBlock> getMateAlignmentBlocks(SAMRecord rec) {
        return SAMUtils.getAlignmentBlocks(SAMUtils.getMateCigar(rec), rec.getMateAlignmentStart(), "mate cigar");
    }

    public static List<SAMValidationError> validateCigar(SAMRecord rec, Cigar cigar, Integer referenceIndex, List<AlignmentBlock> alignmentBlocks, long recordNumber, String cigarTypeName) {
        List<SAMValidationError> ret = cigar.isValid(rec.getReadName(), recordNumber);
        if (referenceIndex != -1) {
            SAMSequenceRecord sequence = rec.getHeader().getSequence(referenceIndex);
            int referenceSequenceLength = sequence.getSequenceLength();
            for (AlignmentBlock alignmentBlock : alignmentBlocks) {
                if (alignmentBlock.getReferenceStart() + alignmentBlock.getLength() - 1 <= referenceSequenceLength) continue;
                if (ret == null) {
                    ret = new ArrayList<SAMValidationError>();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.CIGAR_MAPS_OFF_REFERENCE, cigarTypeName + " M operator maps off end of reference", rec.getReadName(), recordNumber));
                break;
            }
        }
        return ret;
    }

    public static List<SAMValidationError> validateMateCigar(SAMRecord rec, long recordNumber) {
        List<SAMValidationError> ret = null;
        if (rec.getValidationStringency() != ValidationStringency.SILENT) {
            if (rec.getReadPairedFlag() && !rec.getMateUnmappedFlag()) {
                if (SAMUtils.getMateCigarString(rec) != null) {
                    ret = SAMUtils.validateCigar(rec, SAMUtils.getMateCigar(rec), rec.getMateReferenceIndex(), SAMUtils.getMateAlignmentBlocks(rec), recordNumber, "Mate CIGAR");
                }
            } else if (SAMUtils.getMateCigarString(rec) != null) {
                ret = new ArrayList<SAMValidationError>();
                if (rec.getMateUnmappedFlag()) {
                    ret.add(new SAMValidationError(SAMValidationError.Type.MATE_CIGAR_STRING_INVALID_PRESENCE, "Mate CIGAR String (MC Attribute) present for a read whose mate is unmapped", rec.getReadName(), recordNumber));
                } else {
                    ret.add(new SAMValidationError(SAMValidationError.Type.MATE_CIGAR_STRING_INVALID_PRESENCE, "Mate CIGAR String (MC Attribute) present for a read that is not paired", rec.getReadName(), recordNumber));
                }
            }
        }
        return ret;
    }

    public static boolean hasMateCigar(SAMRecord rec) {
        return rec.getReadPairedFlag() && !rec.getMateUnmappedFlag() && null != SAMUtils.getMateCigarString(rec);
    }
}

