#!/bin/bash

## A script to manage the multi-thread submission of computing SNP Scores
## separately for each chromosome. At the end we can concatenate all 
## the chromosome score files into one using catScores.sh

out=`pwd`
mkdir -p $out/output
mkdir -p $out/errors

## The for loop syntax is as follows
## Plink bed file has chromosomes 1-26, where 23=X, 24=Y, 
## 25=XY-pseudoautosomal, and 26-MT. 
## Since chromosomes 10 or less are larger, you may choose to submit to 
## a different machine or queue by specifying a different range like 1..10
## and alter the snpscore.$chr.sh script submission accordingly

for chr in {1..25}
do

  ## Writing to a script that will be submitted to cluster queue
  ## one for each chromosome


  ## header lines for cluster job submission
  echo "#!/bin/bash" > snpscore.$chr.sh;
  echo "#$ -l h_vmem=12G"  >> snpscore.$chr.sh;   ## max virtual memory for job
  echo "#$ -M sinnwell@mayo.edu" >> snpscore.$chr.sh;
  echo "#$ -o $out/output" >> snpscore.$chr.sh;  ## file for logfile
  echo "#$ -e $out/errors" >> snpscore.$chr.sh;  ## file for error logs
  echo "#$ -m bea" >> snpscore.$chr.sh;

  # shell commands to run R batch job with chromosome (chrom) as an argument
  echo "cd $out" >> snpscore.$chr.sh;
  echo "/WHERE/TOFIND/R CMD BATCH --no-save '--args chrom=$chr'  $out/SNPScore.unadj.R $out/snpscore.$chr.Rout" >> snpscore.$chr.sh;

  ## submit to the queue
  qsub -q 1-day snpscore.$chr.sh

done
