## With allele dosage and binary phenotype (y), functions to create
## SNP-Scores for gene-set-scan program, with and without adjusting
## for covariates.


create.scores.adj <- function(snp.dose, y, covar.matrix, fit.null, miss.val.code)
{
  
  # Oct 18, 2010: fixed yhat

  
  # y has values 1 for case and 0 for control
  # snp.dose is the SNP of interest
  # covar.matrix is a matrix of covariates to adjust out
  # fit.null is fit of null model: glm(y ~ covar.matrix, family=binomial)
  
  if(length(y) != length(snp.dose))
    {
      stop("lengths of y and snp.dose do not match")
    }

  if(length(y) != nrow(covar.matrix))
    {
      stop("lenghth of y not equal to number of rows of covar.matrix")
    }

  
  any.miss <- apply(is.na(cbind(y, covar.matrix)), 1, any)
  yhat <- rep(NA, length(y))
  yhat[!any.miss] <- fit.null$fitted.values

  
  # regress snp.dose on covar's = covar.matrix
  any.miss <- apply(is.na(cbind(snp.dose, covar.matrix)), 1, any)

  fit1 <- glm(snp.dose ~ covar.matrix)
  snp.resid <- rep(NA, length(snp.dose))
  snp.resid[!any.miss] <- fit1$residuals

  # vector of scores per person
  
  score <- (y-yhat)*(snp.resid)
  
  score[is.na(score)] <- miss.val.code

  return(score)
}


create.scores.unadj <- function(snp.dose, y, miss.val.code)
{
  
  # y has values 1 for case and 0 for control
  # snp.dose is the SNP of interest
  # miss.val.code is code for missing scores

  n <- length(y)
  if(length(snp.dose) != n)
    {
      stop("lengths of y and snp.dose do not match")
    }

   
  any.miss <- apply(is.na(cbind(y, snp.dose)), 1, any)

  y <- y[!any.miss]
  snp.dose <- snp.dose[!any.miss]

  y.mean <- mean(y)
  snp.mean <-  mean(snp.dose)
  

  # vector of scores per person
  score <- rep(NA, n)
  
  score[!any.miss] <- (y-y.mean)*(snp.dose - snp.mean)
  
  score[is.na(score)] <- miss.val.code

  return(score)
}


