#!/bin/bash

## This script is an example showing how to call GeneSetScan 
## using example parameter files. The parameter files all give instructions
## to the program to find the actual data files except SNPScore.txt, where
## we provide the steps to create the file in GSS/SNPScores. You can find a
## README with instructions on how to use the example scripts we provided.
## We do not provide an example score file in the package.

## All program options can be called on the command line rather than 
## the parameter file, but the large quantity of required parameters are better
## handled with a parameter file for Gene_Set_Scan

## All calls to the method show the log information directed to a file 
## with ">", which we recommend because the log information is verbose
## and useful.

## See GSS/data/DATA-LIST for description of pre-processed input data
## See GSS/SNPScores/README.snpscores for description of creating SNP Scores


## LIST OF USER OPTIONS:
../bin/GeneSetScan --help


## GENE-LEVEL ANALYSIS
##  gene-level scoring: sqrt(mean)
##  gene-moments: normal 
../bin/GeneSetScan --par gene.par > results/gene.out


## RUN GO PATHWAYS SEPARATELY IN 3 NAMESPACES
##  gene-level scoring: sqrt(mean)
##  gene-moments: normal 
##  gene-set-level scoring: weighted mean

## BIOLOGICAL_PROCESS
../bin/GeneSetScan --par go.bp.par > results/go.bp.out

## MOLECULAR_FUNCTION
../bin/GeneSetScan --par go.mf.par > results/go.mf.out

## CELLULAR_COMPONENT
../bin/GeneSetScan --par gp.cc.par > results/go.cc.out

## ALL
../bin/GeneSetScan --par gp.all.par > results/go.all.out


## KEGG PATHWAYS ANALYSIS
##  gene-level scoring: sqrt(mean)
##  gene-moments: normal 
##  gene-set-level scoring: weighted mean
../bin/GeneSetScan --par kegg.par > results/kegg.out
