/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.HttpMethodReleaseInputStream;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3BucketVersioningStatus;
import org.jets3t.service.security.AWSDevPayCredentials;
import org.jets3t.service.security.ProviderCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestS3Service
extends S3Service {
    private static final Log log = LogFactory.getLog(RestS3Service.class);
    private static final String AWS_SIGNATURE_IDENTIFIER = "AWS";
    private static final String AWS_REST_HEADER_PREFIX = "x-amz-";
    private static final String AWS_REST_METADATA_PREFIX = "x-amz-meta-";
    private String awsDevPayUserToken = null;
    private String awsDevPayProductToken = null;
    private boolean isRequesterPaysEnabled = false;

    public RestS3Service(ProviderCredentials credentials) throws S3ServiceException {
        this(credentials, (String)null, (CredentialsProvider)null);
    }

    public RestS3Service(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) throws S3ServiceException {
        this(credentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public RestS3Service(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) throws S3ServiceException {
        this(credentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, new HostConfiguration());
    }

    public RestS3Service(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties, HostConfiguration hostConfig) throws S3ServiceException {
        super(credentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, hostConfig);
        if (credentials instanceof AWSDevPayCredentials) {
            AWSDevPayCredentials awsDevPayCredentials = (AWSDevPayCredentials)credentials;
            this.awsDevPayUserToken = awsDevPayCredentials.getUserToken();
            this.awsDevPayProductToken = awsDevPayCredentials.getProductToken();
        } else {
            this.awsDevPayUserToken = jets3tProperties.getStringProperty("devpay.user-token", null);
            this.awsDevPayProductToken = jets3tProperties.getStringProperty("devpay.product-token", null);
        }
        this.setRequesterPaysEnabled(this.jets3tProperties.getBoolProperty("httpclient.requester-pays-buckets-enabled", false));
    }

    @Override
    protected boolean isTargettingGoogleStorageService() {
        return Constants.GS_DEFAULT_HOSTNAME.equals(this.getJetS3tProperties().getStringProperty("s3service.s3-endpoint", null));
    }

    public void setDevPayUserToken(String userToken) {
        this.awsDevPayUserToken = userToken;
    }

    public String getDevPayUserToken() {
        return this.awsDevPayUserToken;
    }

    public void setDevPayProductToken(String productToken) {
        this.awsDevPayProductToken = productToken;
    }

    public String getDevPayProductToken() {
        return this.awsDevPayProductToken;
    }

    public void setRequesterPaysEnabled(boolean isRequesterPays) {
        this.isRequesterPaysEnabled = isRequesterPays;
    }

    public boolean isRequesterPaysEnabled() {
        return this.isRequesterPaysEnabled;
    }

    @Override
    protected HttpMethodBase setupConnection(String method, String bucketName, String objectKey, Map<String, Object> requestParameters) throws S3ServiceException {
        HttpMethodBase httpMethod;
        try {
            httpMethod = super.setupConnection(method, bucketName, objectKey, requestParameters);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        if (this.getDevPayUserToken() != null || this.getDevPayProductToken() != null) {
            if (this.getDevPayProductToken() != null) {
                String securityToken = this.getDevPayUserToken() + "," + this.getDevPayProductToken();
                httpMethod.setRequestHeader("x-amz-security-token", securityToken);
                if (log.isDebugEnabled()) {
                    log.debug("Including DevPay user and product tokens in request: x-amz-security-token=" + securityToken);
                }
            } else {
                httpMethod.setRequestHeader("x-amz-security-token", this.getDevPayUserToken());
                if (log.isDebugEnabled()) {
                    log.debug("Including DevPay user token in request: x-amz-security-token=" + this.getDevPayUserToken());
                }
            }
        }
        if (this.isRequesterPaysEnabled()) {
            String[] requesterPaysHeaderAndValue = "x-amz-request-payer=requester".split("=");
            httpMethod.setRequestHeader(requesterPaysHeaderAndValue[0], requesterPaysHeaderAndValue[1]);
            if (log.isDebugEnabled()) {
                log.debug("Including Requester Pays header in request: x-amz-request-payer=requester");
            }
        }
        return httpMethod;
    }

    @Override
    public String getEndpoint() {
        return this.jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
    }

    @Override
    protected String getVirtualPath() {
        return this.jets3tProperties.getStringProperty("s3service.s3-endpoint-virtual-path", "");
    }

    @Override
    protected String getSignatureIdentifier() {
        return AWS_SIGNATURE_IDENTIFIER;
    }

    @Override
    public String getRestHeaderPrefix() {
        return AWS_REST_HEADER_PREFIX;
    }

    @Override
    public String getRestMetadataPrefix() {
        return AWS_REST_METADATA_PREFIX;
    }

    @Override
    protected int getHttpPort() {
        return this.jets3tProperties.getIntProperty("s3service.s3-endpoint-http-port", 80);
    }

    @Override
    protected int getHttpsPort() {
        return this.jets3tProperties.getIntProperty("s3service.s3-endpoint-https-port", 443);
    }

    @Override
    protected boolean getHttpsOnly() {
        return this.jets3tProperties.getBoolProperty("s3service.https-only", true);
    }

    @Override
    protected boolean getDisableDnsBuckets() {
        return this.jets3tProperties.getBoolProperty("s3service.disable-dns-buckets", false);
    }

    @Override
    protected boolean getEnableStorageClasses() {
        return this.jets3tProperties.getBoolProperty("s3service.enable-storage-classes", false);
    }

    @Override
    protected BaseVersionOrDeleteMarker[] listVersionedObjectsImpl(String bucketName, String prefix, String delimiter, String keyMarker, String versionMarker, long maxListingLength) throws S3ServiceException {
        return this.listVersionedObjectsInternal(bucketName, prefix, delimiter, maxListingLength, true, keyMarker, versionMarker).getItems();
    }

    @Override
    protected void updateBucketVersioningStatusImpl(String bucketName, boolean enabled, boolean multiFactorAuthDeleteEnabled, String multiFactorSerialNumber, String multiFactorAuthCode) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((enabled ? "Enabling" : "Suspending") + " versioning for bucket " + bucketName + (multiFactorAuthDeleteEnabled ? " with Multi-Factor Auth enabled" : ""));
        }
        try {
            XMLBuilder builder = XMLBuilder.create("VersioningConfiguration").a("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/").e("Status").t(enabled ? "Enabled" : "Suspended").up().e("MfaDelete").t(multiFactorAuthDeleteEnabled ? "Enabled" : "Disabled");
            HashMap<String, Object> requestParams = new HashMap<String, Object>();
            requestParams.put("versioning", null);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            if (multiFactorSerialNumber != null || multiFactorAuthCode != null) {
                metadata.put("x-amz-mfa", multiFactorSerialNumber + " " + multiFactorAuthCode);
            }
            try {
                this.performRestPutWithXmlBuilder(bucketName, null, metadata, requestParams, builder);
            }
            catch (ServiceException se) {
                throw new S3ServiceException(se);
            }
        }
        catch (ParserConfigurationException e) {
            throw new S3ServiceException("Failed to build XML document for request", e);
        }
    }

    @Override
    protected S3BucketVersioningStatus getBucketVersioningStatusImpl(String bucketName) throws S3ServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Checking status of versioning for bucket " + bucketName);
            }
            HashMap<String, Object> requestParams = new HashMap<String, Object>();
            requestParams.put("versioning", null);
            HttpMethodBase method = this.performRestGet(bucketName, null, requestParams, null);
            return this.getXmlResponseSaxParser().parseVersioningConfigurationResponse(new HttpMethodReleaseInputStream(method));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    protected VersionOrDeleteMarkersChunk listVersionedObjectsInternal(String bucketName, String prefix, String delimiter, long maxListingLength, boolean automaticallyMergeChunks, String nextKeyMarker, String nextVersionIdMarker) throws S3ServiceException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("versions", null);
        if (prefix != null) {
            parameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            parameters.put("delimiter", delimiter);
        }
        if (maxListingLength > 0L) {
            parameters.put("max-keys", String.valueOf(maxListingLength));
        }
        ArrayList<BaseVersionOrDeleteMarker> items = new ArrayList<BaseVersionOrDeleteMarker>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        while (incompleteListing) {
            HttpMethodBase httpMethod;
            if (nextKeyMarker != null) {
                parameters.put("key-marker", nextKeyMarker);
            } else {
                parameters.remove("key-marker");
            }
            if (nextVersionIdMarker != null) {
                parameters.put("version-id-marker", nextVersionIdMarker);
            } else {
                parameters.remove("version-id-marker");
            }
            try {
                httpMethod = this.performRestGet(bucketName, null, parameters, null);
            }
            catch (ServiceException se) {
                throw new S3ServiceException(se);
            }
            XmlResponsesSaxParser.ListVersionsResultsHandler handler = null;
            try {
                handler = this.getXmlResponseSaxParser().parseListVersionsResponse(new HttpMethodReleaseInputStream(httpMethod));
                ioErrorRetryCount = 0;
            }
            catch (ServiceException se) {
                if (se.getCause() instanceof IOException && ioErrorRetryCount < 5) {
                    ++ioErrorRetryCount;
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Retrying bucket listing failure due to IO error", se);
                    continue;
                }
                throw new S3ServiceException(se);
            }
            BaseVersionOrDeleteMarker[] partialItems = handler.getItems();
            if (log.isDebugEnabled()) {
                log.debug("Found " + partialItems.length + " items in one batch");
            }
            items.addAll(Arrays.asList(partialItems));
            String[] partialCommonPrefixes = handler.getCommonPrefixes();
            if (log.isDebugEnabled()) {
                log.debug("Found " + partialCommonPrefixes.length + " common prefixes in one batch");
            }
            commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
            incompleteListing = handler.isListingTruncated();
            nextKeyMarker = handler.getNextKeyMarker();
            nextVersionIdMarker = handler.getNextVersionIdMarker();
            if (incompleteListing && log.isDebugEnabled()) {
                log.debug("Yet to receive complete listing of bucket versions, continuing with key-marker=" + nextKeyMarker + " and version-id-marker=" + nextVersionIdMarker);
            }
            if (automaticallyMergeChunks) continue;
            break;
        }
        if (automaticallyMergeChunks) {
            if (log.isDebugEnabled()) {
                log.debug("Found " + items.size() + " items in total");
            }
            return new VersionOrDeleteMarkersChunk(prefix, delimiter, items.toArray(new BaseVersionOrDeleteMarker[items.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), null, null);
        }
        return new VersionOrDeleteMarkersChunk(prefix, delimiter, items.toArray(new BaseVersionOrDeleteMarker[items.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), nextKeyMarker, nextVersionIdMarker);
    }

    @Override
    protected VersionOrDeleteMarkersChunk listVersionedObjectsChunkedImpl(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, String priorLastVersion, boolean completeListing) throws S3ServiceException {
        return this.listVersionedObjectsInternal(bucketName, prefix, delimiter, maxListingLength, completeListing, priorLastKey, priorLastVersion);
    }

    @Override
    protected String getBucketLocationImpl(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Retrieving location of Bucket: " + bucketName);
        }
        HashMap<String, Object> requestParameters = new HashMap<String, Object>();
        requestParameters.put("location", "");
        try {
            HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
            return this.getXmlResponseSaxParser().parseBucketLocationResponse(new HttpMethodReleaseInputStream(httpMethod));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected S3BucketLoggingStatus getBucketLoggingStatusImpl(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Retrieving Logging Status for Bucket: " + bucketName);
        }
        HashMap<String, Object> requestParameters = new HashMap<String, Object>();
        requestParameters.put("logging", "");
        try {
            HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
            return this.getXmlResponseSaxParser().parseLoggingStatusResponse(new HttpMethodReleaseInputStream(httpMethod)).getBucketLoggingStatus();
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected void setBucketLoggingStatusImpl(String bucketName, S3BucketLoggingStatus status) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Setting Logging Status for bucket: " + bucketName);
        }
        HashMap<String, Object> requestParameters = new HashMap<String, Object>();
        requestParameters.put("logging", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        String statusAsXml = null;
        try {
            statusAsXml = status.toXml();
        }
        catch (Exception e) {
            throw new S3ServiceException("Unable to generate LoggingStatus XML document", e);
        }
        try {
            metadata.put("Content-Length", String.valueOf(statusAsXml.length()));
            this.performRestPut(bucketName, null, metadata, requestParameters, new StringRequestEntity(statusAsXml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode LoggingStatus XML document", e);
        }
    }

    @Override
    protected String getBucketPolicyImpl(String bucketName) throws S3ServiceException {
        try {
            HashMap<String, Object> requestParameters = new HashMap<String, Object>();
            requestParameters.put("policy", "");
            HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
            return httpMethod.getResponseBodyAsString();
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (IOException e) {
            throw new S3ServiceException(e);
        }
    }

    @Override
    protected void setBucketPolicyImpl(String bucketName, String policyDocument) throws S3ServiceException {
        HashMap<String, Object> requestParameters = new HashMap<String, Object>();
        requestParameters.put("policy", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        try {
            metadata.put("Content-Length", String.valueOf(policyDocument.length()));
            this.performRestPut(bucketName, null, metadata, requestParameters, new StringRequestEntity(policyDocument, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode LoggingStatus XML document", e);
        }
    }

    @Override
    protected void deleteBucketPolicyImpl(String bucketName) throws S3ServiceException {
        try {
            HashMap<String, Object> requestParameters = new HashMap<String, Object>();
            requestParameters.put("policy", "");
            this.performRestDelete(bucketName, null, requestParameters, null, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected boolean isRequesterPaysBucketImpl(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Retrieving Request Payment Configuration settings for Bucket: " + bucketName);
        }
        HashMap<String, Object> requestParameters = new HashMap<String, Object>();
        requestParameters.put("requestPayment", "");
        try {
            HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
            return this.getXmlResponseSaxParser().parseRequestPaymentConfigurationResponse(new HttpMethodReleaseInputStream(httpMethod));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    protected void setRequesterPaysBucketImpl(String bucketName, boolean requesterPays) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Setting Request Payment Configuration settings for bucket: " + bucketName);
        }
        HashMap<String, Object> requestParameters = new HashMap<String, Object>();
        requestParameters.put("requestPayment", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        try {
            String xml = "<RequestPaymentConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Payer>" + (requesterPays ? "Requester" : "BucketOwner") + "</Payer>" + "</RequestPaymentConfiguration>";
            metadata.put("Content-Length", String.valueOf(xml.length()));
            this.performRestPut(bucketName, null, metadata, requestParameters, new StringRequestEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode RequestPaymentConfiguration XML document", e);
        }
    }
}

