/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.datasources.sample.Sample;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.AbstractReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ExtendedEventPileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElementTracker;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileup;

public class ReadBackedExtendedEventPileupImpl
extends AbstractReadBackedPileup<ReadBackedExtendedEventPileupImpl, ExtendedEventPileupElement>
implements ReadBackedExtendedEventPileup {
    private int nInsertions;
    private int maxDeletionLength;

    public ReadBackedExtendedEventPileupImpl(GenomeLoc loc, List<ExtendedEventPileupElement> pileupElements) {
        super(loc, pileupElements);
    }

    public ReadBackedExtendedEventPileupImpl(GenomeLoc loc, PileupElementTracker<ExtendedEventPileupElement> tracker) {
        super(loc, tracker);
    }

    public ReadBackedExtendedEventPileupImpl(GenomeLoc loc, List<ExtendedEventPileupElement> pileup, int size, int maxDeletionLength, int nInsertions, int nDeletions, int nMQ0Reads) {
        super(loc, pileup, size, nDeletions, nMQ0Reads);
        this.maxDeletionLength = maxDeletionLength;
        this.nInsertions = nInsertions;
    }

    public ReadBackedExtendedEventPileupImpl(GenomeLoc loc, Map<Sample, ? extends ReadBackedExtendedEventPileupImpl> pileupElementsBySample) {
        super(loc, pileupElementsBySample);
    }

    @Override
    protected void calculateCachedData() {
        super.calculateCachedData();
        this.nInsertions = 0;
        this.nMQ0Reads = 0;
        for (ExtendedEventPileupElement p : this.toExtendedIterable()) {
            if (p.isDeletion()) {
                this.maxDeletionLength = Math.max(this.maxDeletionLength, p.getEventLength());
                continue;
            }
            if (!p.isInsertion()) continue;
            ++this.nInsertions;
        }
    }

    @Override
    protected void addPileupToCumulativeStats(AbstractReadBackedPileup<ReadBackedExtendedEventPileupImpl, ExtendedEventPileupElement> pileup) {
        super.addPileupToCumulativeStats(pileup);
        ReadBackedExtendedEventPileup extendedEventPileup = (ReadBackedExtendedEventPileup)((Object)pileup);
        this.nInsertions += extendedEventPileup.getNumberOfInsertions();
        this.maxDeletionLength += extendedEventPileup.getMaxDeletionLength();
    }

    protected ReadBackedExtendedEventPileupImpl createNewPileup(GenomeLoc loc, PileupElementTracker<ExtendedEventPileupElement> tracker) {
        return new ReadBackedExtendedEventPileupImpl(loc, tracker);
    }

    @Override
    protected ExtendedEventPileupElement createNewPileupElement(SAMRecord read, int offset) {
        throw new UnsupportedOperationException("Not enough information provided to create a new pileup element");
    }

    @Override
    public int getNumberOfInsertions() {
        return this.nInsertions;
    }

    @Override
    public int getMaxDeletionLength() {
        return this.maxDeletionLength;
    }

    @Override
    public Iterable<ExtendedEventPileupElement> toExtendedIterable() {
        return new Iterable<ExtendedEventPileupElement>(){

            @Override
            public Iterator<ExtendedEventPileupElement> iterator() {
                return ReadBackedExtendedEventPileupImpl.this.pileupElementTracker.iterator();
            }
        };
    }

    @Override
    public byte[] getEvents() {
        byte[] v = new byte[this.size()];
        int i = 0;
        for (ExtendedEventPileupElement e : this.toExtendedIterable()) {
            switch (e.getType()) {
                case INSERTION: {
                    v[i] = 73;
                    break;
                }
                case DELETION: {
                    v[i] = 68;
                    break;
                }
                case NOEVENT: {
                    v[i] = 46;
                    break;
                }
                default: {
                    throw new ReviewedStingException("Unknown event type encountered: " + (Object)((Object)e.getType()));
                }
            }
            ++i;
        }
        return v;
    }

    @Override
    public List<Pair<String, Integer>> getEventStringsWithCounts() {
        return this.getEventStringsWithCounts(null);
    }

    @Override
    public String getShortPileupString() {
        return String.format("%s %s E %s", this.getLocation().getContig(), this.getLocation().getStart(), new String(this.getEvents()));
    }

    @Override
    public List<Pair<String, Integer>> getEventStringsWithCounts(byte[] refBases) {
        HashMap<String, Integer> events = new HashMap<String, Integer>();
        block5: for (ExtendedEventPileupElement e : this.toExtendedIterable()) {
            String indel = null;
            switch (e.getType()) {
                case INSERTION: {
                    indel = "+" + e.getEventBases();
                    break;
                }
                case DELETION: {
                    indel = this.getDeletionString(e.getEventLength(), refBases);
                    break;
                }
                case NOEVENT: {
                    continue block5;
                }
                default: {
                    throw new ReviewedStingException("Unknown event type encountered: " + (Object)((Object)e.getType()));
                }
            }
            Integer cnt = (Integer)events.get(indel);
            if (cnt == null) {
                events.put(indel, 1);
                continue;
            }
            events.put(indel, cnt + 1);
        }
        ArrayList<Pair<String, Integer>> eventList = new ArrayList<Pair<String, Integer>>(events.size());
        for (Map.Entry m : events.entrySet()) {
            eventList.add(new Pair(m.getKey(), m.getValue()));
        }
        return eventList;
    }

    private String getDeletionString(int length, byte[] refBases) {
        if (refBases == null) {
            return Integer.toString(length) + "D";
        }
        return "-" + new String(refBases, 1, length).toUpperCase();
    }
}

