/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.broadinstitute.sting.gatk.datasources.sample.Sample;
import org.broadinstitute.sting.utils.pileup.AbstractReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.MergingPileupElementIterator;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElementTracker;

class PerSamplePileupElementTracker<PE extends PileupElement>
extends PileupElementTracker<PE> {
    private final Map<Sample, PileupElementTracker<PE>> pileup;
    private final Map<String, Sample> sampleNames = new HashMap<String, Sample>();
    private int size = 0;

    public PerSamplePileupElementTracker() {
        this.pileup = new HashMap<Sample, PileupElementTracker<PE>>();
    }

    public PerSamplePileupElementTracker(Map<Sample, AbstractReadBackedPileup<?, PE>> pileupsBySample) {
        this.pileup = new HashMap<Sample, PileupElementTracker<PE>>();
        for (Map.Entry<Sample, AbstractReadBackedPileup<?, PE>> entry : pileupsBySample.entrySet()) {
            Sample sample = entry.getKey();
            AbstractReadBackedPileup<?, PE> pileupBySample = entry.getValue();
            this.pileup.put(sample, pileupBySample.pileupElementTracker);
            this.sampleNames.put(sample.getId(), sample);
        }
    }

    public Collection<Sample> getSamples() {
        return this.pileup.keySet();
    }

    public PileupElementTracker<PE> getElements(Sample sample) {
        return this.pileup.get(sample);
    }

    public PileupElementTracker<PE> getElements(String sampleName) {
        return this.pileup.get(this.sampleNames.get(sampleName));
    }

    public PileupElementTracker<PE> getElements(Collection<String> selectSampleNames) {
        PerSamplePileupElementTracker<PE> result = new PerSamplePileupElementTracker<PE>();
        for (String sample : selectSampleNames) {
            Sample sampleObject = this.sampleNames.get(sample);
            result.addElements(sampleObject, this.pileup.get(sampleObject));
        }
        return result;
    }

    public void addElements(Sample sample, PileupElementTracker<PE> elements) {
        this.pileup.put(sample, elements);
        this.sampleNames.put(sample.getId(), sample);
        this.size += elements.size();
    }

    @Override
    public Iterator<PE> iterator() {
        return new MergingPileupElementIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }
}

