/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import net.sf.picard.util.PeekableIterator;
import org.broadinstitute.sting.gatk.datasources.sample.Sample;
import org.broadinstitute.sting.utils.pileup.PerSamplePileupElementTracker;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElementTracker;

class MergingPileupElementIterator<PE extends PileupElement>
implements Iterator<PE> {
    private final PriorityQueue<PeekableIterator<PE>> perSampleIterators;

    public MergingPileupElementIterator(PerSamplePileupElementTracker<PE> tracker) {
        this.perSampleIterators = new PriorityQueue(Math.max(1, tracker.getSamples().size()), new PileupElementIteratorComparator());
        for (Sample sample : tracker.getSamples()) {
            PileupElementTracker<PE> trackerPerSample = tracker.getElements(sample);
            if (trackerPerSample.size() == 0) continue;
            this.perSampleIterators.add(new PeekableIterator(trackerPerSample.iterator()));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.perSampleIterators.isEmpty();
    }

    @Override
    public PE next() {
        PeekableIterator currentIterator = (PeekableIterator)this.perSampleIterators.remove();
        PileupElement current = (PileupElement)currentIterator.next();
        if (currentIterator.hasNext()) {
            this.perSampleIterators.add(currentIterator);
        }
        return (PE)current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a merging iterator.");
    }

    private class PileupElementIteratorComparator
    implements Comparator<PeekableIterator<PE>> {
        private PileupElementIteratorComparator() {
        }

        @Override
        public int compare(PeekableIterator<PE> lhs, PeekableIterator<PE> rhs) {
            return ((PileupElement)rhs.peek()).getOffset() - ((PileupElement)lhs.peek()).getOffset();
        }
    }
}

