/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

public class FragmentPileup {
    final Collection<PileupElement> oneReadPile;
    final Collection<TwoReadPileupElement> twoReadPile = new ArrayList<TwoReadPileupElement>();

    public FragmentPileup(ReadBackedPileup pileup) {
        HashMap<String, PileupElement> nameMap = new HashMap<String, PileupElement>();
        for (PileupElement p : pileup) {
            String readName = p.getRead().getReadName();
            PileupElement pe1 = (PileupElement)nameMap.get(readName);
            if (pe1 != null) {
                this.twoReadPile.add(new TwoReadPileupElement(pe1, p));
                nameMap.remove(readName);
                continue;
            }
            nameMap.put(readName, p);
        }
        this.oneReadPile = nameMap.values();
    }

    public Collection<TwoReadPileupElement> getTwoReadPileup() {
        return this.twoReadPile;
    }

    public Collection<PileupElement> getOneReadPileup() {
        return this.oneReadPile;
    }

    public static class TwoReadPileupElement {
        protected final PileupElement PE1;
        protected final PileupElement PE2;

        public TwoReadPileupElement(PileupElement PE1, PileupElement PE2) {
            this.PE1 = PE1;
            this.PE2 = PE2;
        }

        public PileupElement getFirst() {
            return this.PE1;
        }

        public PileupElement getSecond() {
            return this.PE2;
        }
    }
}

