/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.interval;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import org.broadinstitute.sting.gatk.iterators.PushbackIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.StringToGenomeLocIteratorAdapter;
import org.broadinstitute.sting.utils.text.XReadLines;

public class IntervalFileMergingIterator
implements Iterator<GenomeLoc> {
    private PushbackIterator<GenomeLoc> it;
    private IntervalMergingRule myRule;
    private File myFile;

    public IntervalFileMergingIterator(GenomeLocParser genomeLocParser, File f, IntervalMergingRule rule) {
        this.myFile = f;
        try {
            XReadLines reader = new XReadLines(f);
            this.it = f.getName().toUpperCase().endsWith(".BED") ? new PushbackIterator<GenomeLoc>(new StringToGenomeLocIteratorAdapter(genomeLocParser, reader.iterator(), StringToGenomeLocIteratorAdapter.FORMAT.BED)) : new PushbackIterator<GenomeLoc>(new StringToGenomeLocIteratorAdapter(genomeLocParser, reader.iterator(), StringToGenomeLocIteratorAdapter.FORMAT.GATK));
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(f, (Exception)e);
        }
        this.myRule = rule;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public GenomeLoc next() {
        GenomeLoc current = this.it.next();
        while (this.it.hasNext()) {
            GenomeLoc next = this.it.next();
            if (next.isBefore(current)) {
                throw new UserException.MalformedFile(this.myFile, "Interval " + next + " in the interval file is out of order.");
            }
            if (current.overlapsP(next)) {
                current = current.merge(next);
                continue;
            }
            if (current.contiguousP(next) && this.myRule == IntervalMergingRule.ALL) {
                current = current.merge(next);
                continue;
            }
            this.it.pushback(next);
            break;
        }
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("method 'remove' is not supported by this iterator");
    }
}

