/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.genotype;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class Haplotype {
    protected byte[] bases = null;
    protected double[] quals = null;
    private GenomeLoc genomeLocation = null;
    private boolean isReference = false;

    public Haplotype(byte[] bases, int qual) {
        this.bases = bases;
        this.quals = new double[bases.length];
        Arrays.fill(this.quals, (double)qual);
    }

    public Haplotype(byte[] bases, double[] quals) {
        this.bases = bases;
        this.quals = quals;
    }

    public Haplotype(byte[] bases) {
        this(bases, 0);
    }

    public Haplotype(byte[] bases, GenomeLoc loc) {
        this(bases);
        this.genomeLocation = loc;
    }

    public Haplotype(byte[] bases, GenomeLoc loc, boolean isRef) {
        this(bases, loc);
        this.isReference = isRef;
    }

    public double getQualitySum() {
        double s = 0.0;
        for (int k = 0; k < this.bases.length; ++k) {
            s += this.quals[k];
        }
        return s;
    }

    public String toString() {
        String returnString = "";
        for (int iii = 0; iii < this.bases.length; ++iii) {
            returnString = returnString + (char)this.bases[iii];
        }
        return returnString;
    }

    public double[] getQuals() {
        return this.quals;
    }

    public byte[] getBasesAsBytes() {
        return this.bases;
    }

    public long getStartPosition() {
        return this.genomeLocation.getStart();
    }

    public long getStopPosition() {
        return this.genomeLocation.getStop();
    }

    public boolean isReference() {
        return this.isReference;
    }

    public static LinkedHashMap<Allele, Haplotype> makeHaplotypeListFromAlleles(List<Allele> alleleList, int startPos, ReferenceContext ref, int haplotypeSize, int numPrefBases) {
        LinkedHashMap<Allele, Haplotype> haplotypeMap = new LinkedHashMap<Allele, Haplotype>();
        Allele refAllele = null;
        for (Allele a : alleleList) {
            if (!a.isReference()) continue;
            refAllele = a;
            break;
        }
        if (refAllele == null) {
            throw new ReviewedStingException("BUG: no ref alleles in input to makeHaplotypeListfrom Alleles at loc: " + startPos);
        }
        byte[] refBases = ref.getBases();
        int startIdxInReference = 1 + startPos - numPrefBases - ref.getWindow().getStart();
        byte[] basesBeforeVariant = Arrays.copyOfRange(refBases, startIdxInReference, startIdxInReference + numPrefBases);
        int startAfter = startIdxInReference + numPrefBases + refAllele.getBases().length;
        if (startAfter > refBases.length) {
            startAfter = refBases.length;
        }
        byte[] basesAfterVariant = Arrays.copyOfRange(refBases, startAfter, refBases.length);
        int startLoc = ref.getWindow().getStart() + startIdxInReference;
        int stopLoc = startLoc + haplotypeSize - 1;
        GenomeLoc locus = ref.getGenomeLocParser().createGenomeLoc(ref.getLocus().getContig(), startLoc, stopLoc);
        for (Allele a : alleleList) {
            byte[] alleleBases = a.getBases();
            String haplotypeString = new String(basesBeforeVariant) + new String(alleleBases) + new String(basesAfterVariant);
            haplotypeString = haplotypeString.substring(0, haplotypeSize);
            haplotypeMap.put(a, new Haplotype(haplotypeString.getBytes(), locus, a.isReference()));
        }
        return haplotypeMap;
    }
}

