/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.clipreads;

import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.clipreads.ClippingOp;
import org.broadinstitute.sting.utils.clipreads.ClippingRepresentation;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class ReadClipper {
    SAMRecord read;
    boolean wasClipped;
    List<ClippingOp> ops = null;

    public ReadClipper(SAMRecord read) {
        this.read = read;
        this.wasClipped = false;
    }

    public void addOp(ClippingOp op) {
        if (this.ops == null) {
            this.ops = new ArrayList<ClippingOp>();
        }
        this.ops.add(op);
    }

    public List<ClippingOp> getOps() {
        return this.ops;
    }

    public boolean wasClipped() {
        return this.wasClipped;
    }

    public SAMRecord getRead() {
        return this.read;
    }

    public SAMRecord hardClipByReferenceCoordinatesLeftTail(int refStop) {
        return this.hardClipByReferenceCoordinates(-1, refStop);
    }

    public SAMRecord hardClipByReferenceCoordinatesRightTail(int refStart) {
        return this.hardClipByReferenceCoordinates(refStart, -1);
    }

    private SAMRecord hardClipByReferenceCoordinates(int refStart, int refStop) {
        int stop;
        int start = refStart < 0 ? 0 : ReadUtils.getReadCoordinateForReferenceCoordinate(this.read, refStart);
        int n = stop = refStop < 0 ? this.read.getReadLength() - 1 : ReadUtils.getReadCoordinateForReferenceCoordinate(this.read, refStop);
        if (start < 0 || stop > this.read.getReadLength() - 1) {
            throw new ReviewedStingException("Trying to clip before the start or after the end of a read");
        }
        if (start > stop) {
            stop = ReadUtils.getReadCoordinateForReferenceCoordinate(this.read, ReadUtils.getRefCoordSoftUnclippedEnd(this.read));
        }
        this.addOp(new ClippingOp(start, stop));
        SAMRecord clippedRead = this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
        this.ops = null;
        return clippedRead;
    }

    public SAMRecord hardClipByReadCoordinates(int start, int stop) {
        this.addOp(new ClippingOp(start, stop));
        return this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
    }

    @Requires(value={"left <= right"})
    public SAMRecord hardClipBothEndsByReferenceCoordinates(int left, int right) {
        if (left == right) {
            return new SAMRecord(this.read.getHeader());
        }
        this.read = this.hardClipByReferenceCoordinates(right, -1);
        return this.hardClipByReferenceCoordinates(-1, left);
    }

    public SAMRecord hardClipLowQualEnds(byte lowQual) {
        int rightClipIndex;
        byte[] quals = this.read.getBaseQualities();
        int leftClipIndex = 0;
        for (rightClipIndex = this.read.getReadLength() - 1; rightClipIndex >= 0 && quals[rightClipIndex] <= lowQual; --rightClipIndex) {
        }
        while (leftClipIndex < this.read.getReadLength() && quals[leftClipIndex] <= lowQual) {
            ++leftClipIndex;
        }
        if (leftClipIndex > rightClipIndex) {
            return new SAMRecord(this.read.getHeader());
        }
        if (rightClipIndex < this.read.getReadLength() - 1) {
            this.addOp(new ClippingOp(rightClipIndex + 1, this.read.getReadLength() - 1));
        }
        if (leftClipIndex > 0) {
            this.addOp(new ClippingOp(0, leftClipIndex - 1));
        }
        return this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
    }

    public SAMRecord clipRead(ClippingRepresentation algorithm) {
        if (this.ops == null) {
            return this.getRead();
        }
        try {
            SAMRecord clippedRead = (SAMRecord)this.read.clone();
            for (ClippingOp op : this.getOps()) {
                clippedRead = op.apply(algorithm, clippedRead);
            }
            this.wasClipped = true;
            return clippedRead;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

