/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.clipreads;

import com.google.java.contract.Requires;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.clipreads.ClippingRepresentation;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class ClippingOp {
    public final int start;
    public final int stop;

    public ClippingOp(int start, int stop) {
        this.start = start;
        this.stop = stop;
    }

    public int getLength() {
        return this.stop - this.start + 1;
    }

    public SAMRecord apply(ClippingRepresentation algorithm, SAMRecord read) {
        byte[] quals = read.getBaseQualities();
        byte[] bases = read.getReadBases();
        switch (algorithm) {
            case WRITE_NS: {
                for (int i = this.start; i <= this.stop; ++i) {
                    bases[i] = 78;
                }
                read.setReadBases(bases);
                break;
            }
            case WRITE_Q0S: {
                for (int i = this.start; i <= this.stop; ++i) {
                    quals[i] = 0;
                }
                read.setBaseQualities(quals);
                break;
            }
            case WRITE_NS_Q0S: {
                for (int i = this.start; i <= this.stop; ++i) {
                    bases[i] = 78;
                    quals[i] = 0;
                }
                read.setReadBases(bases);
                read.setBaseQualities(quals);
                break;
            }
            case HARDCLIP_BASES: {
                read = this.hardClip(read, this.start, this.stop);
                break;
            }
            case SOFTCLIP_BASES: {
                if (read.getReadUnmappedFlag()) {
                    throw new UserException("Read Clipper cannot soft clip unmapped reads");
                }
                int myStop = this.stop;
                if (this.stop + 1 - this.start == read.getReadLength()) {
                    --myStop;
                }
                if (this.start > 0 && myStop != read.getReadLength() - 1) {
                    throw new RuntimeException(String.format("Cannot apply soft clipping operator to the middle of a read: %s to be clipped at %d-%d", read.getReadName(), this.start, myStop));
                }
                Cigar oldCigar = read.getCigar();
                int scLeft = 0;
                int scRight = read.getReadLength();
                if (this.start == 0) {
                    scLeft = myStop + 1;
                } else {
                    scRight = this.start;
                }
                Cigar newCigar = this.softClip(oldCigar, scLeft, scRight);
                read.setCigar(newCigar);
                int newClippedStart = this.getNewAlignmentStartOffset(newCigar, oldCigar);
                int newStart = read.getAlignmentStart() + newClippedStart;
                read.setAlignmentStart(newStart);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Clipping operator type " + (Object)((Object)algorithm));
            }
        }
        return read;
    }

    private int getNewAlignmentStartOffset(Cigar __cigar, Cigar __oldCigar) {
        int num = 0;
        for (CigarElement e : __cigar.getCigarElements()) {
            if (e.getOperator().consumesReferenceBases()) break;
            if (!e.getOperator().consumesReadBases()) continue;
            num += e.getLength();
        }
        int oldNum = 0;
        int curReadCounter = 0;
        for (CigarElement e : __oldCigar.getCigarElements()) {
            int curRefLength = e.getLength();
            int curReadLength = e.getLength();
            if (!e.getOperator().consumesReadBases()) {
                curReadLength = 0;
            }
            boolean truncated = false;
            if (curReadCounter + curReadLength > num) {
                curReadLength = num - curReadCounter;
                curRefLength = num - curReadCounter;
                truncated = true;
            }
            if (!e.getOperator().consumesReferenceBases()) {
                curRefLength = 0;
            }
            oldNum += curRefLength;
            if ((curReadCounter += curReadLength) <= num && !truncated) continue;
            break;
        }
        return oldNum;
    }

    private Cigar softClip(Cigar __cigar, int __startClipEnd, int __endClipBegin) {
        if (__endClipBegin <= __startClipEnd) {
            int cigarLength = 0;
            for (CigarElement e : __cigar.getCigarElements()) {
                cigarLength += e.getLength();
            }
            Cigar newCigar = new Cigar();
            newCigar.add(new CigarElement(cigarLength, CigarOperator.SOFT_CLIP));
            assert (newCigar.isValid(null, -1L) == null);
            return newCigar;
        }
        int curLength = 0;
        Vector<CigarElement> newElements = new Vector<CigarElement>();
        for (CigarElement curElem : __cigar.getCigarElements()) {
            if (!curElem.getOperator().consumesReadBases()) {
                if (curElem.getOperator() != CigarOperator.HARD_CLIP && (curLength <= __startClipEnd || curLength >= __endClipBegin)) continue;
                newElements.add(new CigarElement(curElem.getLength(), curElem.getOperator()));
                continue;
            }
            int s = curLength;
            int e = curLength + curElem.getLength();
            if (e <= __startClipEnd || s >= __endClipBegin) {
                newElements.add(new CigarElement(curElem.getLength(), CigarOperator.SOFT_CLIP));
            } else if (s >= __startClipEnd && e <= __endClipBegin) {
                newElements.add(new CigarElement(curElem.getLength(), curElem.getOperator()));
            } else {
                CigarElement newStart = null;
                CigarElement newMid = null;
                CigarElement newEnd = null;
                int midLength = curElem.getLength();
                if (s < __startClipEnd) {
                    newStart = new CigarElement(__startClipEnd - s, CigarOperator.SOFT_CLIP);
                    midLength -= newStart.getLength();
                }
                if (e > __endClipBegin) {
                    newEnd = new CigarElement(e - __endClipBegin, CigarOperator.SOFT_CLIP);
                    midLength -= newEnd.getLength();
                }
                assert (midLength >= 0);
                if (midLength > 0) {
                    newMid = new CigarElement(midLength, curElem.getOperator());
                }
                if (newStart != null) {
                    newElements.add(newStart);
                }
                if (newMid != null) {
                    newElements.add(newMid);
                }
                if (newEnd != null) {
                    newElements.add(newEnd);
                }
            }
            curLength += curElem.getLength();
        }
        Vector<CigarElement> finalNewElements = new Vector<CigarElement>();
        CigarElement lastElement = null;
        for (CigarElement elem : newElements) {
            if (lastElement == null || lastElement.getOperator() != elem.getOperator()) {
                if (lastElement != null) {
                    finalNewElements.add(lastElement);
                }
                lastElement = elem;
                continue;
            }
            lastElement = new CigarElement(lastElement.getLength() + elem.getLength(), lastElement.getOperator());
        }
        if (lastElement != null) {
            finalNewElements.add(lastElement);
        }
        Cigar newCigar = new Cigar(finalNewElements);
        assert (newCigar.isValid(null, -1L) == null);
        return newCigar;
    }

    @Requires(value={"start <= stop", "start == 0 || stop == read.getReadLength() - 1", "!read.getReadUnmappedFlag()"})
    private SAMRecord hardClip(SAMRecord read, int start, int stop) {
        SAMRecord hardClippedRead;
        if (start == 0 && stop == read.getReadLength() - 1) {
            return new SAMRecord(read.getHeader());
        }
        CigarShift cigarShift = read.getReadUnmappedFlag() ? new CigarShift(new Cigar(), 0, 0) : this.hardClipCigar(read.getCigar(), start, stop);
        int newLength = read.getReadLength() - (stop - start + 1) - cigarShift.shiftFromStart - cigarShift.shiftFromEnd;
        byte[] newBases = new byte[newLength];
        byte[] newQuals = new byte[newLength];
        int copyStart = start == 0 ? stop + 1 + cigarShift.shiftFromStart : cigarShift.shiftFromStart;
        System.arraycopy(read.getReadBases(), copyStart, newBases, 0, newLength);
        System.arraycopy(read.getBaseQualities(), copyStart, newQuals, 0, newLength);
        try {
            hardClippedRead = (SAMRecord)read.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ReviewedStingException("Where did the clone go?");
        }
        hardClippedRead.setBaseQualities(newQuals);
        hardClippedRead.setReadBases(newBases);
        hardClippedRead.setCigar(cigarShift.cigar);
        if (start == 0) {
            hardClippedRead.setAlignmentStart(read.getAlignmentStart() + this.calculateAlignmentStartShift(read.getCigar(), cigarShift.cigar));
        }
        return hardClippedRead;
    }

    @Requires(value={"!cigar.isEmpty()"})
    private CigarShift hardClipCigar(Cigar cigar, int start, int stop) {
        Cigar newCigar = new Cigar();
        int index = 0;
        int totalHardClipCount = stop - start + 1;
        int alignmentShift = 0;
        if (start == 0) {
            Iterator<CigarElement> cigarElementIterator = cigar.getCigarElements().iterator();
            CigarElement cigarElement = cigarElementIterator.next();
            while (cigarElement.getOperator() == CigarOperator.HARD_CLIP) {
                totalHardClipCount += cigarElement.getLength();
                if (cigarElementIterator.hasNext()) {
                    cigarElement = cigarElementIterator.next();
                    continue;
                }
                throw new ReviewedStingException("Read is entirely hardclipped, shouldn't be trying to clip it's cigar string");
            }
            while (index <= stop) {
                int shift = 0;
                if (cigarElement.getOperator().consumesReadBases()) {
                    shift = cigarElement.getLength();
                }
                if (index + shift == stop + 1) {
                    newCigar.add(new CigarElement(totalHardClipCount + (alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, cigarElement.getLength())), CigarOperator.HARD_CLIP));
                } else if (index + shift > stop + 1) {
                    int elementLengthAfterChopping = cigarElement.getLength() - (stop - index + 1);
                    newCigar.add(new CigarElement(totalHardClipCount + (alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, stop - index + 1)), CigarOperator.HARD_CLIP));
                    newCigar.add(new CigarElement(elementLengthAfterChopping, cigarElement.getOperator()));
                }
                alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, shift);
                if ((index += shift) > stop || !cigarElementIterator.hasNext()) continue;
                cigarElement = cigarElementIterator.next();
            }
            while (cigarElementIterator.hasNext()) {
                cigarElement = cigarElementIterator.next();
                newCigar.add(new CigarElement(cigarElement.getLength(), cigarElement.getOperator()));
            }
        } else {
            Iterator<CigarElement> cigarElementIterator = cigar.getCigarElements().iterator();
            CigarElement cigarElement = cigarElementIterator.next();
            while (index < start) {
                int shift = 0;
                if (cigarElement.getOperator().consumesReadBases()) {
                    shift = cigarElement.getLength();
                }
                if (index + shift < start) {
                    newCigar.add(new CigarElement(cigarElement.getLength(), cigarElement.getOperator()));
                } else {
                    int elementLengthAfterChopping = start - index;
                    alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, cigarElement.getLength() - (start - index));
                    if (cigarElement.getOperator() == CigarOperator.HARD_CLIP) {
                        totalHardClipCount += elementLengthAfterChopping;
                    } else {
                        newCigar.add(new CigarElement(elementLengthAfterChopping, cigarElement.getOperator()));
                    }
                }
                if ((index += shift) >= start || !cigarElementIterator.hasNext()) continue;
                cigarElement = cigarElementIterator.next();
            }
            while (cigarElementIterator.hasNext()) {
                cigarElement = cigarElementIterator.next();
                alignmentShift += this.calculateHardClippingAlignmentShift(cigarElement, cigarElement.getLength());
            }
            newCigar.add(new CigarElement(totalHardClipCount + alignmentShift, CigarOperator.HARD_CLIP));
        }
        return this.cleanHardClippedCigar(newCigar);
    }

    private CigarShift cleanHardClippedCigar(Cigar cigar) {
        Cigar cleanCigar = new Cigar();
        int shiftFromStart = 0;
        int shiftFromEnd = 0;
        Stack<CigarElement> cigarStack = new Stack<CigarElement>();
        Stack<CigarElement> inverseCigarStack = new Stack<CigarElement>();
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            cigarStack.push(cigarElement);
        }
        for (int i = 1; i <= 2; ++i) {
            int shift = 0;
            boolean readHasStarted = false;
            while (!cigarStack.empty()) {
                CigarElement cigarElement = (CigarElement)cigarStack.pop();
                if (!readHasStarted && cigarElement.getOperator() != CigarOperator.INSERTION && cigarElement.getOperator() != CigarOperator.DELETION && cigarElement.getOperator() != CigarOperator.HARD_CLIP) {
                    readHasStarted = true;
                } else if (!readHasStarted && cigarElement.getOperator() == CigarOperator.INSERTION) {
                    shift += cigarElement.getLength();
                }
                if (!readHasStarted && cigarElement.getOperator() != CigarOperator.HARD_CLIP) continue;
                if (i == 1) {
                    inverseCigarStack.push(cigarElement);
                    continue;
                }
                cleanCigar.add(cigarElement);
            }
            if (i == 1) {
                shiftFromEnd = shift;
                cigarStack = inverseCigarStack;
                continue;
            }
            shiftFromStart = shift;
        }
        return new CigarShift(cleanCigar, shiftFromStart, shiftFromEnd);
    }

    private int calculateAlignmentStartShift(Cigar oldCigar, Cigar newCigar) {
        int shift = 0;
        for (CigarElement cigarElement : oldCigar.getCigarElements()) {
            if (cigarElement.getOperator().consumesReferenceBases()) break;
            shift -= cigarElement.getLength();
        }
        for (CigarElement cigarElement : newCigar.getCigarElements()) {
            if (cigarElement.getOperator().consumesReferenceBases()) break;
            shift += cigarElement.getLength();
        }
        return shift;
    }

    private int calculateHardClippingAlignmentShift(CigarElement cigarElement, int clippedLength) {
        if (cigarElement.getOperator() == CigarOperator.INSERTION) {
            int cigarElementLength = cigarElement.getLength();
            if (clippedLength >= cigarElementLength) {
                return -cigarElement.getLength();
            }
            return -clippedLength;
        }
        if (cigarElement.getOperator() == CigarOperator.DELETION) {
            return cigarElement.getLength();
        }
        return 0;
    }

    private class CigarShift {
        private Cigar cigar;
        private int shiftFromStart;
        private int shiftFromEnd;

        private CigarShift(Cigar cigar, int shiftFromStart, int shiftFromEnd) {
            this.cigar = cigar;
            this.shiftFromStart = shiftFromStart;
            this.shiftFromEnd = shiftFromEnd;
        }
    }
}

