/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.bed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class BedParser {
    static final int TO_ONE_BASED_ADDITION = 1;
    private final BufferedReader mIn;
    private GenomeLocParser genomeLocParser;
    private List<GenomeLoc> mLocations;

    public BedParser(GenomeLocParser genomeLocParser, File fl) {
        this.genomeLocParser = genomeLocParser;
        try {
            this.mIn = new BufferedReader(new FileReader(fl));
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(fl, (Exception)e);
        }
        this.mLocations = this.parseLocations();
    }

    public BedParser(BufferedReader fl) {
        this.mIn = fl;
        this.mLocations = this.parseLocations();
    }

    private List<GenomeLoc> parseLocations() {
        String line = null;
        ArrayList<GenomeLoc> locArray = new ArrayList<GenomeLoc>();
        try {
            while ((line = this.mIn.readLine()) != null) {
                locArray.add(BedParser.parseLocation(this.genomeLocParser, line));
            }
        }
        catch (IOException e) {
            throw new UserException.MalformedFile("Unable to parse line in BED file.");
        }
        return locArray;
    }

    public static GenomeLoc parseLocation(GenomeLocParser genomeLocParser, String line) {
        int stop;
        int start;
        String contig;
        try {
            String[] parts = line.split("\\s+");
            contig = parts[0];
            start = Integer.valueOf(parts[1]) + 1;
            stop = Integer.valueOf(parts[2]);
        }
        catch (Exception e) {
            throw new UserException.MalformedFile("Unable to process bed file line = " + line, e);
        }
        return genomeLocParser.createGenomeLoc(contig, start, stop, true);
    }

    public List<GenomeLoc> getLocations() {
        return this.mLocations;
    }
}

