/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.io.PrintStream;

@Invariant(value={"elapsed >= 0", "startTime >= 0", "name != null", "! running || startTime > 0"})
public class SimpleTimer {
    private final String name;
    private long elapsed = 0L;
    private long startTime = 0L;
    boolean running = false;

    @Ensures(value={"name != null && name.equals(\"Anonymous\")"})
    public SimpleTimer() {
        this("Anonymous");
    }

    @Requires(value={"name != null"})
    @Ensures(value={"this.name != null && this.name.equals(name)"})
    public SimpleTimer(String name) {
        this.name = name;
    }

    @Ensures(value={"result != null"})
    public String getName() {
        return this.name;
    }

    @Requires(value={"running == false"})
    @Ensures(value={"result != null", "elapsed == 0l"})
    public SimpleTimer start() {
        this.elapsed = 0L;
        this.restart();
        return this;
    }

    @Requires(value={"running == false"})
    @Ensures(value={"result != null"})
    public SimpleTimer restart() {
        this.running = true;
        this.startTime = this.currentTime();
        return this;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long currentTime() {
        return System.currentTimeMillis();
    }

    @Requires(value={"running == true"})
    @Ensures(value={"result != null", "elapsed >= old(elapsed)", "running == false"})
    public SimpleTimer stop() {
        this.running = false;
        this.elapsed += this.currentTime() - this.startTime;
        return this;
    }

    @Ensures(value={"result >= (elapsed/1000.0)", "result >= 0"})
    public double getElapsedTime() {
        return (double)(this.running ? this.currentTime() - this.startTime + this.elapsed : this.elapsed) / 1000.0;
    }

    public void printElapsedTime(PrintStream out) {
        out.printf("SimpleTimer %s: %.2f%n", this.name, this.getElapsedTime());
    }
}

