/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.Utils;

public class QualityUtils {
    public static final byte MAX_QUAL_SCORE = 93;
    public static final double MIN_REASONABLE_ERROR = 1.0E-4;
    public static final byte MAX_REASONABLE_Q_SCORE = 40;
    public static final byte MIN_USABLE_Q_SCORE = 6;
    public static final int MAPPING_QUALITY_UNAVAILABLE = 255;

    private QualityUtils() {
    }

    public static double qualToProb(byte qual) {
        return 1.0 - QualityUtils.qualToErrorProb(qual);
    }

    public static double qualToProb(int qual) {
        return QualityUtils.qualToProb((double)qual);
    }

    public static double qualToProb(double qual) {
        return 1.0 - Math.pow(10.0, qual / -10.0);
    }

    public static double qualToErrorProb(byte qual) {
        return Math.pow(10.0, (double)qual / -10.0);
    }

    public static byte probToQual(double prob) {
        return QualityUtils.probToQual(prob, 1.0E-4);
    }

    public static byte probToQual(double prob, double eps) {
        double lp = Math.round(-10.0 * Math.log10(1.0 - prob + eps));
        byte b = QualityUtils.boundQual((int)lp);
        return b;
    }

    public static double phredScaleCorrectRate(double trueRate) {
        return QualityUtils.phredScaleErrorRate(1.0 - trueRate);
    }

    public static double phredScaleErrorRate(double errorRate) {
        return Math.abs(-10.0 * Math.log10(errorRate));
    }

    public static double lodToPhredScaleErrorRate(double lod) {
        return QualityUtils.phredScaleErrorRate(1.0 / (Math.pow(10.0, lod) + 1.0));
    }

    public static byte boundQual(int qual) {
        return QualityUtils.boundQual(qual, (byte)93);
    }

    public static byte boundQual(int qual, byte maxQual) {
        return (byte)Math.max(Math.min(qual, maxQual), 1);
    }

    public static byte baseAndProbToCompressedQuality(int baseIndex, double prob) {
        byte compressedQual = 0;
        compressedQual = (byte)baseIndex;
        byte cprob = (byte)(100.0 * prob);
        int qualmask = -4;
        compressedQual = (byte)(compressedQual + (cprob << 2 & qualmask));
        return compressedQual;
    }

    public static int compressedQualityToBaseIndex(byte compressedQual) {
        return compressedQual & 3;
    }

    public static double compressedQualityToProb(byte compressedQual) {
        int x2 = compressedQual & 0xFF;
        return (double)(x2 >>>= 2) / 100.0;
    }

    public static byte complementCompressedQuality(byte compressedQual) {
        int baseIndex = QualityUtils.compressedQualityToBaseIndex(compressedQual);
        double prob = QualityUtils.compressedQualityToProb(compressedQual);
        return QualityUtils.baseAndProbToCompressedQuality(BaseUtils.complementIndex(baseIndex), prob);
    }

    public static byte[] reverseComplementCompressedQualityArray(byte[] compressedQuals) {
        byte[] rcCompressedQuals = new byte[compressedQuals.length];
        for (int pos = 0; pos < compressedQuals.length; ++pos) {
            rcCompressedQuals[compressedQuals.length - pos - 1] = QualityUtils.complementCompressedQuality(compressedQuals[pos]);
        }
        return rcCompressedQuals;
    }

    public static byte[] reverseQualityArray(byte[] quals) {
        return Utils.reverse(quals);
    }
}

