/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.SnpEff;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class FunctionalClass
extends VariantStratifier {
    @Override
    public void initialize() {
        this.states.add("all");
        for (FunctionalType type : FunctionalType.values()) {
            this.states.add(type.name());
        }
    }

    @Override
    public List<String> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        ArrayList<String> relevantStates = new ArrayList<String>();
        relevantStates.add("all");
        if (eval != null && eval.isVariant()) {
            FunctionalType type = null;
            if (eval.hasAttribute("refseq.functionalClass")) {
                try {
                    type = FunctionalType.valueOf(eval.getAttributeAsString("refseq.functionalClass"));
                }
                catch (Exception e) {}
            } else if (eval.hasAttribute("refseq.functionalClass_1")) {
                String key;
                int annotationId = 1;
                do {
                    String newtypeStr;
                    if ((newtypeStr = eval.getAttributeAsString(key = String.format("refseq.functionalClass_%d", annotationId))) != null && !newtypeStr.equalsIgnoreCase("null")) {
                        try {
                            FunctionalType newType = FunctionalType.valueOf(newtypeStr);
                            if (type == null || type == FunctionalType.silent && newType != FunctionalType.silent || type == FunctionalType.missense && newType == FunctionalType.nonsense) {
                                type = newType;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++annotationId;
                } while (eval.hasAttribute(key));
            } else if (eval.hasAttribute(SnpEff.InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName())) {
                try {
                    SnpEff.EffectFunctionalClass snpEffFunctionalClass = SnpEff.EffectFunctionalClass.valueOf(eval.getAttribute(SnpEff.InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName()).toString());
                    if (snpEffFunctionalClass == SnpEff.EffectFunctionalClass.NONSENSE) {
                        type = FunctionalType.nonsense;
                    } else if (snpEffFunctionalClass == SnpEff.EffectFunctionalClass.MISSENSE) {
                        type = FunctionalType.missense;
                    } else if (snpEffFunctionalClass == SnpEff.EffectFunctionalClass.SILENT) {
                        type = FunctionalType.silent;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (type != null) {
                relevantStates.add(type.name());
            }
        }
        return relevantStates;
    }

    public static enum FunctionalType {
        silent,
        missense,
        nonsense;

    }
}

