/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Analysis(description="Ti/Tv Variant Evaluator")
public class TiTvVariantEvaluator
extends VariantEvaluator
implements StandardEval {
    @DataPoint(description="number of transition loci")
    long nTi = 0L;
    @DataPoint(description="number of transversion loci")
    long nTv = 0L;
    @DataPoint(description="the transition to transversion ratio")
    double tiTvRatio = 0.0;
    @DataPoint(description="number of comp transition sites")
    long nTiInComp = 0L;
    @DataPoint(description="number of comp transversion sites")
    long nTvInComp = 0L;
    @DataPoint(description="the transition to transversion ratio for comp sites")
    double TiTvRatioStandard = 0.0;
    @DataPoint(description="number of derived transition loci")
    long nTiDerived = 0L;
    @DataPoint(description="number of derived transversion loci")
    long nTvDerived = 0L;
    @DataPoint(description="the derived transition to transversion ratio")
    double tiTvDerivedRatio = 0.0;

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    public void updateTiTv(VariantContext vc, boolean updateStandard) {
        if (vc != null && vc.isSNP() && vc.isBiallelic() && vc.isPolymorphic()) {
            if (VariantContextUtils.isTransition(vc)) {
                if (updateStandard) {
                    ++this.nTiInComp;
                } else {
                    ++this.nTi;
                }
            } else if (updateStandard) {
                ++this.nTvInComp;
            } else {
                ++this.nTv;
            }
            String refStr = vc.getReference().getBaseString().toUpperCase();
            String aaStr = vc.getAttributeAsString("ANCESTRALALLELE").toUpperCase();
            if (aaStr != null && !aaStr.equalsIgnoreCase("null") && !aaStr.equals(".")) {
                BaseUtils.BaseSubstitutionType aaSubType = BaseUtils.SNPSubstitutionType(aaStr.getBytes()[0], vc.getAlternateAllele(0).getBases()[0]);
                if (aaSubType == BaseUtils.BaseSubstitutionType.TRANSITION) {
                    ++this.nTiDerived;
                } else if (aaSubType == BaseUtils.BaseSubstitutionType.TRANSVERSION) {
                    ++this.nTvDerived;
                }
            }
        }
    }

    @Override
    public String update2(VariantContext vc1, VariantContext vc2, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (vc1 != null) {
            this.updateTiTv(vc1, false);
        }
        if (vc2 != null) {
            this.updateTiTv(vc2, true);
        }
        return null;
    }

    @Override
    public void finalizeEvaluation() {
        this.tiTvRatio = this.rate(this.nTi, this.nTv);
        this.tiTvDerivedRatio = this.rate(this.nTiDerived, this.nTvDerived);
        this.TiTvRatioStandard = this.rate(this.nTiInComp, this.nTvInComp);
    }
}

