/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="Indel length histograms", description="Shows the distrbution of insertion/deletion event lengths (negative for deletion, positive for insertion)")
public class IndelLengthHistogram
extends VariantEvaluator {
    private static final int SIZE_LIMIT = 100;
    @DataPoint(description="Histogram of indel lengths")
    IndelHistogram indelHistogram = new IndelHistogram(100);

    @Override
    public boolean enabled() {
        return true;
    }

    public String getName() {
        return "IndelLengthHistogram";
    }

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public String update1(VariantContext vc1, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (vc1.isIndel() && vc1.isPolymorphic()) {
            if (!vc1.isBiallelic()) {
                return vc1.toString();
            }
            if (vc1.isSimpleInsertion()) {
                this.indelHistogram.update(vc1.getAlternateAllele(0).length());
            } else if (vc1.isSimpleDeletion()) {
                this.indelHistogram.update(-vc1.getReference().length());
            }
        }
        return null;
    }

    static class IndelHistogram
    implements TableType {
        private Integer[] colKeys;
        private int limit;
        private String[] rowKeys = new String[]{"EventLength"};
        private Integer[] indelHistogram;

        public IndelHistogram(int limit) {
            this.colKeys = this.initColKeys(limit);
            this.indelHistogram = this.initHistogram(limit);
            this.limit = limit;
        }

        @Override
        public Object[] getColumnKeys() {
            return this.colKeys;
        }

        @Override
        public Object[] getRowKeys() {
            return this.rowKeys;
        }

        @Override
        public Object getCell(int row, int col) {
            return this.indelHistogram[col];
        }

        private Integer[] initColKeys(int size) {
            Integer[] cK = new Integer[size * 2 + 1];
            int index = 0;
            for (int i = -size; i <= size; ++i) {
                cK[index] = i;
                ++index;
            }
            return cK;
        }

        private Integer[] initHistogram(int size) {
            Integer[] hist = new Integer[size * 2 + 1];
            for (int i = 0; i < 2 * size + 1; ++i) {
                hist[i] = 0;
            }
            return hist;
        }

        @Override
        public String getName() {
            return "indelHistTable";
        }

        public void update(int eLength) {
            Integer[] integerArray = this.indelHistogram;
            int n = this.len2index(eLength);
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        }

        private int len2index(int len) {
            if (len > this.limit || len < -this.limit) {
                throw new ReviewedStingException("Indel length exceeds limit of " + this.limit + " please increase indel limit size");
            }
            return len + this.limit;
        }
    }
}

