/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.walkers.recalibration.Covariate;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalDatum;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.NestedHashMap;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class RecalDataManager {
    public final NestedHashMap data;
    private final NestedHashMap dataCollapsedReadGroup;
    private final NestedHashMap dataCollapsedQualityScore;
    private final ArrayList<NestedHashMap> dataCollapsedByCovariate;
    public static final String ORIGINAL_QUAL_ATTRIBUTE_TAG = "OQ";
    public static final String COLOR_SPACE_QUAL_ATTRIBUTE_TAG = "CQ";
    public static final String COLOR_SPACE_ATTRIBUTE_TAG = "CS";
    public static final String COLOR_SPACE_INCONSISTENCY_TAG = "ZC";
    private static boolean warnUserNullReadGroup = false;
    private static boolean warnUserNullPlatform = false;

    RecalDataManager() {
        this.data = new NestedHashMap();
        this.dataCollapsedReadGroup = null;
        this.dataCollapsedQualityScore = null;
        this.dataCollapsedByCovariate = null;
    }

    RecalDataManager(boolean createCollapsedTables, int numCovariates) {
        if (createCollapsedTables) {
            this.data = null;
            this.dataCollapsedReadGroup = new NestedHashMap();
            this.dataCollapsedQualityScore = new NestedHashMap();
            this.dataCollapsedByCovariate = new ArrayList();
            for (int iii = 0; iii < numCovariates - 2; ++iii) {
                this.dataCollapsedByCovariate.add(new NestedHashMap());
            }
        } else {
            this.data = new NestedHashMap();
            this.dataCollapsedReadGroup = null;
            this.dataCollapsedQualityScore = null;
            this.dataCollapsedByCovariate = null;
        }
    }

    public final void addToAllTables(Object[] key, RecalDatum fullDatum, int PRESERVE_QSCORES_LESS_THAN) {
        RecalDatum collapsedDatum;
        int qualityScore = Integer.parseInt(key[1].toString());
        Object[] readGroupCollapsedKey = new Object[1];
        Object[] qualityScoreCollapsedKey = new Object[2];
        Object[] covariateCollapsedKey = new Object[3];
        if (qualityScore >= PRESERVE_QSCORES_LESS_THAN) {
            readGroupCollapsedKey[0] = key[0];
            collapsedDatum = (RecalDatum)this.dataCollapsedReadGroup.get(readGroupCollapsedKey);
            if (collapsedDatum == null) {
                this.dataCollapsedReadGroup.put((Object)new RecalDatum(fullDatum), readGroupCollapsedKey);
            } else {
                collapsedDatum.combine(fullDatum);
            }
        }
        qualityScoreCollapsedKey[0] = key[0];
        qualityScoreCollapsedKey[1] = key[1];
        collapsedDatum = (RecalDatum)this.dataCollapsedQualityScore.get(qualityScoreCollapsedKey);
        if (collapsedDatum == null) {
            this.dataCollapsedQualityScore.put((Object)new RecalDatum(fullDatum), qualityScoreCollapsedKey);
        } else {
            collapsedDatum.increment(fullDatum);
        }
        for (int iii = 0; iii < this.dataCollapsedByCovariate.size(); ++iii) {
            covariateCollapsedKey[0] = key[0];
            covariateCollapsedKey[1] = key[1];
            Object theCovariateElement = key[iii + 2];
            if (theCovariateElement == null) continue;
            covariateCollapsedKey[2] = theCovariateElement;
            collapsedDatum = (RecalDatum)this.dataCollapsedByCovariate.get(iii).get(covariateCollapsedKey);
            if (collapsedDatum == null) {
                this.dataCollapsedByCovariate.get(iii).put((Object)new RecalDatum(fullDatum), covariateCollapsedKey);
                continue;
            }
            collapsedDatum.increment(fullDatum);
        }
    }

    public final void generateEmpiricalQualities(int smoothing, int maxQual) {
        this.recursivelyGenerateEmpiricalQualities(this.dataCollapsedReadGroup.data, smoothing, maxQual);
        this.recursivelyGenerateEmpiricalQualities(this.dataCollapsedQualityScore.data, smoothing, maxQual);
        for (NestedHashMap map : this.dataCollapsedByCovariate) {
            this.recursivelyGenerateEmpiricalQualities(map.data, smoothing, maxQual);
            this.checkForSingletons(map.data);
        }
    }

    private void recursivelyGenerateEmpiricalQualities(Map data, int smoothing, int maxQual) {
        for (Object comp : data.keySet()) {
            Object val = data.get(comp);
            if (val instanceof RecalDatum) {
                ((RecalDatum)val).calcCombinedEmpiricalQuality(smoothing, maxQual);
                continue;
            }
            this.recursivelyGenerateEmpiricalQualities((Map)val, smoothing, maxQual);
        }
    }

    private void checkForSingletons(Map data) {
        for (Object comp : data.keySet()) {
            Object val = data.get(comp);
            if (val instanceof RecalDatum) {
                if (data.keySet().size() != 1) continue;
                data.clear();
                continue;
            }
            this.checkForSingletons((Map)val);
        }
    }

    public final NestedHashMap getCollapsedTable(int covariate) {
        if (covariate == 0) {
            return this.dataCollapsedReadGroup;
        }
        if (covariate == 1) {
            return this.dataCollapsedQualityScore;
        }
        return this.dataCollapsedByCovariate.get(covariate - 2);
    }

    public static void parseSAMRecord(SAMRecord read, RecalibrationArgumentCollection RAC) {
        SAMReadGroupRecord readGroup = read.getReadGroup();
        if (readGroup == null) {
            if (RAC.DEFAULT_READ_GROUP != null && RAC.DEFAULT_PLATFORM != null) {
                if (!warnUserNullReadGroup && RAC.FORCE_READ_GROUP == null) {
                    Utils.warnUser("The input .bam file contains reads with no read group. Defaulting to read group ID = " + RAC.DEFAULT_READ_GROUP + " and platform = " + RAC.DEFAULT_PLATFORM + ". " + "First observed at read with name = " + read.getReadName());
                    warnUserNullReadGroup = true;
                }
                readGroup = new SAMReadGroupRecord(RAC.DEFAULT_READ_GROUP);
                readGroup.setPlatform(RAC.DEFAULT_PLATFORM);
                ((GATKSAMRecord)read).setReadGroup(readGroup);
            } else {
                throw new UserException.MalformedBAM(read, "The input .bam file contains reads with no read group. First observed at read with name = " + read.getReadName() + " Users must set both the default read group using the --default_read_group <String> argument and the default platform using the --default_platform <String> argument.");
            }
        }
        if (RAC.FORCE_READ_GROUP != null && !readGroup.getReadGroupId().equals(RAC.FORCE_READ_GROUP)) {
            String oldPlatform = readGroup.getPlatform();
            readGroup = new SAMReadGroupRecord(RAC.FORCE_READ_GROUP);
            readGroup.setPlatform(oldPlatform);
            ((GATKSAMRecord)read).setReadGroup(readGroup);
        }
        if (!(RAC.FORCE_PLATFORM == null || readGroup.getPlatform() != null && readGroup.getPlatform().equals(RAC.FORCE_PLATFORM))) {
            readGroup.setPlatform(RAC.FORCE_PLATFORM);
        }
        if (readGroup.getPlatform() == null) {
            if (RAC.DEFAULT_PLATFORM != null) {
                if (!warnUserNullPlatform) {
                    Utils.warnUser("The input .bam file contains reads with no platform information. Defaulting to platform = " + RAC.DEFAULT_PLATFORM + ". " + "First observed at read with name = " + read.getReadName());
                    warnUserNullPlatform = true;
                }
                readGroup.setPlatform(RAC.DEFAULT_PLATFORM);
            } else {
                throw new UserException.MalformedBAM(read, "The input .bam file contains reads with no platform information. First observed at read with name = " + read.getReadName() + " Users must set the default platform using the --default_platform <String> argument.");
            }
        }
    }

    public static void parseColorSpace(SAMRecord read) {
        if (read.getReadGroup().getPlatform().toUpperCase().contains("SOLID") && read.getAttribute(COLOR_SPACE_INCONSISTENCY_TAG) == null) {
            Object attr = read.getAttribute(COLOR_SPACE_ATTRIBUTE_TAG);
            if (attr != null) {
                if (!(attr instanceof String)) {
                    throw new UserException.MalformedBAM(read, String.format("Value encoded by %s in %s isn't a string!", COLOR_SPACE_ATTRIBUTE_TAG, read.getReadName()));
                }
                byte[] colorSpace = ((String)attr).getBytes();
                byte[] readBases = read.getReadBases();
                if (read.getReadNegativeStrandFlag()) {
                    readBases = BaseUtils.simpleReverseComplement(read.getReadBases());
                }
                byte[] inconsistency = new byte[readBases.length];
                byte prevBase = colorSpace[0];
                for (int iii = 0; iii < readBases.length; ++iii) {
                    byte thisBase = RecalDataManager.getNextBaseFromColor(read, prevBase, colorSpace[iii + 1]);
                    inconsistency[iii] = (byte)(thisBase != readBases[iii] ? 1 : 0);
                    prevBase = readBases[iii];
                }
                read.setAttribute(COLOR_SPACE_INCONSISTENCY_TAG, (Object)inconsistency);
            } else {
                throw new UserException.MalformedBAM(read, "Unable to find color space information in SOLiD read. First observed at read with name = " + read.getReadName() + " Unfortunately this .bam file can not be recalibrated without color space information because of potential reference bias.");
            }
        }
    }

    public static byte[] calcColorSpace(SAMRecord read, byte[] originalQualScores, SOLID_RECAL_MODE solidRecalMode, byte[] refBases) {
        Object attr = read.getAttribute(COLOR_SPACE_ATTRIBUTE_TAG);
        if (attr != null) {
            boolean setBaseN;
            if (!(attr instanceof String)) {
                throw new ReviewedStingException(String.format("Value encoded by %s in %s isn't a string!", COLOR_SPACE_ATTRIBUTE_TAG, read.getReadName()));
            }
            byte[] colorSpace = ((String)attr).getBytes();
            byte[] readBases = read.getReadBases();
            byte[] colorImpliedBases = (byte[])readBases.clone();
            byte[] refBasesDirRead = AlignmentUtils.alignmentToByteArray(read.getCigar(), read.getReadBases(), refBases);
            if (read.getReadNegativeStrandFlag()) {
                readBases = BaseUtils.simpleReverseComplement(read.getReadBases());
                refBasesDirRead = BaseUtils.simpleReverseComplement((byte[])refBasesDirRead.clone());
            }
            int[] inconsistency = new int[readBases.length];
            byte prevBase = colorSpace[0];
            for (int iii = 0; iii < readBases.length; ++iii) {
                byte thisBase;
                colorImpliedBases[iii] = thisBase = RecalDataManager.getNextBaseFromColor(read, prevBase, colorSpace[iii + 1]);
                inconsistency[iii] = thisBase == readBases[iii] ? 0 : 1;
                prevBase = readBases[iii];
            }
            if (solidRecalMode == SOLID_RECAL_MODE.SET_Q_ZERO) {
                setBaseN = false;
                originalQualScores = RecalDataManager.solidRecalSetToQZero(read, readBases, inconsistency, originalQualScores, refBasesDirRead, false);
            } else if (solidRecalMode == SOLID_RECAL_MODE.SET_Q_ZERO_BASE_N) {
                setBaseN = true;
                originalQualScores = RecalDataManager.solidRecalSetToQZero(read, readBases, inconsistency, originalQualScores, refBasesDirRead, true);
            } else if (solidRecalMode == SOLID_RECAL_MODE.REMOVE_REF_BIAS) {
                RecalDataManager.solidRecalRemoveRefBias(read, readBases, inconsistency, colorImpliedBases, refBasesDirRead);
            }
        } else {
            throw new UserException.MalformedBAM(read, "Unable to find color space information in SOLiD read. First observed at read with name = " + read.getReadName() + " Unfortunately this .bam file can not be recalibrated without color space information because of potential reference bias.");
        }
        return originalQualScores;
    }

    public static boolean checkNoCallColorSpace(SAMRecord read) {
        if (read.getReadGroup().getPlatform().toUpperCase().contains("SOLID")) {
            Object attr = read.getAttribute(COLOR_SPACE_ATTRIBUTE_TAG);
            if (attr != null) {
                if (!(attr instanceof String)) {
                    throw new ReviewedStingException(String.format("Value encoded by %s in %s isn't a string!", COLOR_SPACE_ATTRIBUTE_TAG, read.getReadName()));
                }
                byte[] colorSpace = ((String)attr).substring(1).getBytes();
                for (byte color : colorSpace) {
                    if (color == 48 || color == 49 || color == 50 || color == 51) continue;
                    return true;
                }
            } else {
                throw new UserException.MalformedBAM(read, "Unable to find color space information in SOLiD read. First observed at read with name = " + read.getReadName() + " Unfortunately this .bam file can not be recalibrated without color space information because of potential reference bias.");
            }
        }
        return false;
    }

    private static byte[] solidRecalSetToQZero(SAMRecord read, byte[] readBases, int[] inconsistency, byte[] originalQualScores, byte[] refBases, boolean setBaseN) {
        boolean negStrand = read.getReadNegativeStrandFlag();
        for (int iii = 1; iii < originalQualScores.length; ++iii) {
            if (inconsistency[iii] != 1) continue;
            if (readBases[iii] == refBases[iii]) {
                if (negStrand) {
                    originalQualScores[originalQualScores.length - (iii + 1)] = 0;
                } else {
                    originalQualScores[iii] = 0;
                }
                if (setBaseN) {
                    readBases[iii] = 78;
                }
            }
            if (readBases[iii - 1] != refBases[iii - 1]) continue;
            if (negStrand) {
                originalQualScores[originalQualScores.length - iii] = 0;
            } else {
                originalQualScores[iii - 1] = 0;
            }
            if (!setBaseN) continue;
            readBases[iii - 1] = 78;
        }
        if (negStrand) {
            readBases = BaseUtils.simpleReverseComplement((byte[])readBases.clone());
        }
        read.setReadBases(readBases);
        return originalQualScores;
    }

    private static void solidRecalRemoveRefBias(SAMRecord read, byte[] readBases, int[] inconsistency, byte[] colorImpliedBases, byte[] refBases) {
        Object attr = read.getAttribute(COLOR_SPACE_QUAL_ATTRIBUTE_TAG);
        if (attr != null) {
            if (!(attr instanceof String)) {
                throw new ReviewedStingException(String.format("Value encoded by %s in %s isn't a string!", COLOR_SPACE_QUAL_ATTRIBUTE_TAG, read.getReadName()));
            }
            String x = (String)attr;
            byte[] colorSpaceQuals = x.getBytes();
            SAMUtils.fastqToPhred(colorSpaceQuals);
            for (int iii = 1; iii < inconsistency.length - 1; ++iii) {
                if (inconsistency[iii] != 1) continue;
                for (int jjj = iii - 1; jjj <= iii; ++jjj) {
                    if (jjj != iii && inconsistency[jjj] != 0 || readBases[jjj] != refBases[jjj]) continue;
                    if (colorSpaceQuals[jjj] == colorSpaceQuals[jjj + 1]) {
                        int rand = GenomeAnalysisEngine.getRandomGenerator().nextInt(2);
                        if (rand != 0) continue;
                        readBases[jjj] = colorImpliedBases[jjj];
                        continue;
                    }
                    int maxQuality = Math.max(colorSpaceQuals[jjj], colorSpaceQuals[jjj + 1]);
                    int minQuality = Math.min(colorSpaceQuals[jjj], colorSpaceQuals[jjj + 1]);
                    int diffInQuality = maxQuality - minQuality;
                    int numLow = minQuality;
                    if (numLow == 0) {
                        ++numLow;
                        ++diffInQuality;
                    }
                    int numHigh = Math.round((float)numLow * (float)Math.pow(10.0, (float)diffInQuality / 10.0f));
                    int rand = GenomeAnalysisEngine.getRandomGenerator().nextInt(numLow + numHigh);
                    if (rand >= numLow) {
                        if (maxQuality != colorSpaceQuals[jjj]) continue;
                        readBases[jjj] = colorImpliedBases[jjj];
                        continue;
                    }
                    if (minQuality != colorSpaceQuals[jjj]) continue;
                    readBases[jjj] = colorImpliedBases[jjj];
                }
            }
            if (read.getReadNegativeStrandFlag()) {
                readBases = BaseUtils.simpleReverseComplement((byte[])readBases.clone());
            }
        } else {
            throw new UserException.MalformedBAM(read, "REMOVE_REF_BIAS recal mode requires color space qualities but they can't be found for read: " + read.getReadName());
        }
        read.setReadBases(readBases);
    }

    private static byte getNextBaseFromColor(SAMRecord read, byte prevBase, byte color) {
        switch (color) {
            case 48: {
                return prevBase;
            }
            case 49: {
                return RecalDataManager.performColorOne(prevBase);
            }
            case 50: {
                return RecalDataManager.performColorTwo(prevBase);
            }
            case 51: {
                return RecalDataManager.performColorThree(prevBase);
            }
        }
        throw new UserException.MalformedBAM(read, "Unrecognized color space in SOLID read, color = " + (char)color + " Unfortunately this bam file can not be recalibrated without full color space information because of potential reference bias.");
    }

    public static boolean isInconsistentColorSpace(SAMRecord read, int offset) {
        Object attr = read.getAttribute(COLOR_SPACE_INCONSISTENCY_TAG);
        if (attr != null) {
            byte[] inconsistency = (byte[])attr;
            if (read.getReadNegativeStrandFlag()) {
                return inconsistency[inconsistency.length - offset - 1] != 0;
            }
            return inconsistency[offset] != 0;
        }
        return false;
    }

    public static Comparable[][] computeCovariates(GATKSAMRecord gatkRead, List<Covariate> requestedCovariates) {
        List<Covariate> requestedCovariatesRef = requestedCovariates;
        int numRequestedCovariates = requestedCovariatesRef.size();
        int readLength = gatkRead.getReadLength();
        Comparable[][] covariateValues_offset_x_covar = new Comparable[readLength][numRequestedCovariates];
        Comparable[] tempCovariateValuesHolder = new Comparable[readLength];
        for (int i = 0; i < numRequestedCovariates; ++i) {
            requestedCovariatesRef.get(i).getValues(gatkRead, tempCovariateValuesHolder);
            for (int j = 0; j < readLength; ++j) {
                covariateValues_offset_x_covar[j][i] = tempCovariateValuesHolder[j];
            }
        }
        return covariateValues_offset_x_covar;
    }

    private static byte performColorOne(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 67;
            }
            case 67: 
            case 99: {
                return 65;
            }
            case 71: 
            case 103: {
                return 84;
            }
            case 84: 
            case 116: {
                return 71;
            }
        }
        return base;
    }

    private static byte performColorTwo(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 71;
            }
            case 67: 
            case 99: {
                return 84;
            }
            case 71: 
            case 103: {
                return 65;
            }
            case 84: 
            case 116: {
                return 67;
            }
        }
        return base;
    }

    private static byte performColorThree(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 84;
            }
            case 67: 
            case 99: {
                return 71;
            }
            case 71: 
            case 103: {
                return 67;
            }
            case 84: 
            case 116: {
                return 65;
            }
        }
        return base;
    }

    public static enum SOLID_NOCALL_STRATEGY {
        THROW_EXCEPTION,
        LEAVE_READ_UNRECALIBRATED,
        PURGE_READ;

    }

    public static enum SOLID_RECAL_MODE {
        DO_NOTHING,
        SET_Q_ZERO,
        SET_Q_ZERO_BASE_N,
        REMOVE_REF_BIAS;

    }
}

