/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.recalibration.ExperimentalCovariate;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;

public class MinimumNQSCovariate
implements ExperimentalCovariate {
    private int windowReach;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.windowReach = RAC.WINDOW_SIZE / 2;
    }

    public final Comparable getValue(SAMRecord read, int offset) {
        byte[] quals = read.getBaseQualities();
        byte minQual = quals[offset];
        int minIndex = Math.max(offset - this.windowReach, 0);
        int maxIndex = Math.min(offset + this.windowReach, quals.length - 1);
        for (int iii = minIndex; iii < maxIndex; ++iii) {
            if (quals[iii] >= minQual) continue;
            minQual = quals[iii];
        }
        return Integer.valueOf(minQual);
    }

    @Override
    public final Comparable getValue(String str) {
        return Integer.valueOf(Integer.parseInt(str));
    }

    @Override
    public void getValues(SAMRecord read, Comparable[] comparable) {
        for (int iii = 0; iii < read.getReadLength(); ++iii) {
            comparable[iii] = this.getValue(read, iii);
        }
    }
}

