/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import java.util.Arrays;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.recalibration.StandardCovariate;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class CycleCovariate
implements StandardCovariate {
    private static List<String> PACBIO_NAMES = Arrays.asList("PACBIO");
    private static List<String> ILLUMINA_NAMES = Arrays.asList("ILLUMINA", "SLX", "SOLEXA");
    private static List<String> SOLID_NAMES = Arrays.asList("SOLID");
    private static List<String> LS454_NAMES = Arrays.asList("454");

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        if (!(RAC.DEFAULT_PLATFORM == null || RAC.DEFAULT_PLATFORM.equalsIgnoreCase("SLX") || RAC.DEFAULT_PLATFORM.equalsIgnoreCase("ILLUMINA") || RAC.DEFAULT_PLATFORM.contains("454") || RAC.DEFAULT_PLATFORM.equalsIgnoreCase("SOLID") || RAC.DEFAULT_PLATFORM.equalsIgnoreCase("ABI_SOLID"))) {
            throw new UserException.CommandLineException("The requested default platform (" + RAC.DEFAULT_PLATFORM + ") is not a recognized platform. Implemented options are illumina, 454, and solid");
        }
    }

    private static boolean isPlatform(SAMRecord read, List<String> names) {
        String pl = read.getReadGroup().getPlatform().toUpperCase();
        for (String name : names) {
            if (!pl.contains(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getValues(SAMRecord read, Comparable[] comparable) {
        if (CycleCovariate.isPlatform(read, ILLUMINA_NAMES) || CycleCovariate.isPlatform(read, SOLID_NAMES) || CycleCovariate.isPlatform(read, PACBIO_NAMES)) {
            int increment;
            int init;
            if (!read.getReadNegativeStrandFlag()) {
                if (read.getReadPairedFlag() && read.getSecondOfPairFlag()) {
                    init = -1;
                    increment = -1;
                } else {
                    init = 1;
                    increment = 1;
                }
            } else if (read.getReadPairedFlag() && read.getSecondOfPairFlag()) {
                init = -read.getReadLength();
                increment = 1;
            } else {
                init = read.getReadLength();
                increment = -1;
            }
            int cycle = init;
            for (int i = 0; i < read.getReadLength(); ++i) {
                comparable[i] = Integer.valueOf(cycle);
                cycle += increment;
            }
        } else if (CycleCovariate.isPlatform(read, LS454_NAMES)) {
            int cycle;
            int readLength = read.getReadLength();
            byte[] bases = read.getReadBases();
            boolean multiplyByNegative1 = read.getReadPairedFlag() && read.getSecondOfPairFlag();
            int n = cycle = multiplyByNegative1 ? -1 : 1;
            if (!read.getReadNegativeStrandFlag()) {
                int iii = 0;
                while (iii < readLength) {
                    while (iii < readLength && bases[iii] == 84) {
                        comparable[iii] = Integer.valueOf(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 65) {
                        comparable[iii] = Integer.valueOf(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 67) {
                        comparable[iii] = Integer.valueOf(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 71) {
                        comparable[iii] = Integer.valueOf(cycle);
                        ++iii;
                    }
                    if (iii < readLength) {
                        cycle = multiplyByNegative1 ? --cycle : ++cycle;
                    }
                    if (iii >= readLength || BaseUtils.isRegularBase(bases[iii])) continue;
                    comparable[iii] = Integer.valueOf(cycle);
                    ++iii;
                }
            } else {
                int iii = readLength - 1;
                while (iii >= 0) {
                    while (iii >= 0 && bases[iii] == 84) {
                        comparable[iii] = Integer.valueOf(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 65) {
                        comparable[iii] = Integer.valueOf(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 67) {
                        comparable[iii] = Integer.valueOf(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 71) {
                        comparable[iii] = Integer.valueOf(cycle);
                        --iii;
                    }
                    if (iii >= 0) {
                        cycle = multiplyByNegative1 ? --cycle : ++cycle;
                    }
                    if (iii < 0 || BaseUtils.isRegularBase(bases[iii])) continue;
                    comparable[iii] = Integer.valueOf(cycle);
                    --iii;
                }
            }
        } else {
            throw new IllegalStateException("This method hasn't been implemented yet for " + read.getReadGroup().getPlatform());
        }
    }

    @Override
    public final Comparable getValue(String str) {
        return Integer.valueOf(Integer.parseInt(str));
    }
}

