/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.walkers.ReadPairWalker;
import org.broadinstitute.sting.utils.collections.ExpandingArrayList;

public class CountPairsWalker
extends ReadPairWalker<Integer, Long> {
    @Output
    private PrintStream out;
    private long firstOfPair = 0L;
    private long secondOfPair = 0L;
    private List<Long> pairCountsByType = new ExpandingArrayList<Long>();

    @Override
    public Integer map(Collection<SAMRecord> reads) {
        if (this.pairCountsByType.get(reads.size()) != null) {
            this.pairCountsByType.set(reads.size(), this.pairCountsByType.get(reads.size()) + 1L);
        } else {
            this.pairCountsByType.set(reads.size(), 1L);
        }
        for (SAMRecord read : reads) {
            if (read.getFirstOfPairFlag()) {
                ++this.firstOfPair;
            }
            if (!read.getSecondOfPairFlag()) continue;
            ++this.secondOfPair;
        }
        return 1;
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long reduce(Integer value, Long sum) {
        return (long)value.intValue() + sum;
    }

    @Override
    public void onTraversalDone(Long sum) {
        this.out.printf("Total number of pairs               : %d%n", sum);
        this.out.printf("Total number of first reads in pair : %d%n", this.firstOfPair);
        this.out.printf("Total number of second reads in pair: %d%n", this.secondOfPair);
        for (int i = 1; i < this.pairCountsByType.size(); ++i) {
            if (this.pairCountsByType.get(i) == null) continue;
            this.out.printf("Pairs of size %d: %d%n", i, this.pairCountsByType.get(i));
        }
    }
}

