/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.phasing.MergeSegregatingAlternateAllelesVCFWriter;
import org.broadinstitute.sting.gatk.walkers.phasing.WriteVCF;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Allows(value={DataSource.REFERENCE})
@Requires(value={DataSource.REFERENCE})
@By(value=DataSource.REFERENCE_ORDERED_DATA)
public class MergeMNPsWalker
extends RodWalker<Integer, Integer> {
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter writer = null;
    private MergeSegregatingAlternateAllelesVCFWriter vcMergerWriter = null;
    @Argument(fullName="maxGenomicDistanceForMNP", shortName="maxDistMNP", doc="The maximum reference-genome distance between consecutive heterozygous sites to permit merging phased VCF records into a MNP record; [default:1]", required=false)
    protected int maxGenomicDistanceForMNP = 1;
    @Input(fullName="variant", shortName="V", doc="Select variants from this VCF file", required=true)
    public RodBinding<VariantContext> variants;

    @Override
    public void initialize() {
        this.initializeVcfWriter();
    }

    private void initializeVcfWriter() {
        this.vcMergerWriter = new MergeSegregatingAlternateAllelesVCFWriter(this.writer, this.getToolkit().getGenomeLocParser(), this.getToolkit().getArguments().referenceFile, this.maxGenomicDistanceForMNP, logger, false);
        this.writer = null;
        HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
        hInfo.addAll(VCFUtils.getHeaderFields(this.getToolkit()));
        hInfo.add(new VCFHeaderLine("reference", this.getToolkit().getArguments().referenceFile.getName()));
        Map<String, VCFHeader> rodNameToHeader = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), Arrays.asList(this.variants.getName()));
        this.vcMergerWriter.writeHeader(new VCFHeader(hInfo, new TreeSet<String>(rodNameToHeader.get(this.variants.getName()).getGenotypeSamples())));
    }

    @Override
    public boolean generateExtendedEvents() {
        return false;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return null;
        }
        for (VariantContext vc : tracker.getValues(this.variants, context.getLocation())) {
            this.writeVCF(vc);
        }
        return 0;
    }

    private void writeVCF(VariantContext vc) {
        WriteVCF.writeVCF(vc, this.vcMergerWriter, logger);
    }

    @Override
    public Integer reduce(Integer result, Integer total) {
        if (result == null) {
            return total;
        }
        return total + result;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.vcMergerWriter.close();
        System.out.println("Number of successive pairs of records: " + this.vcMergerWriter.getNumRecordsAttemptToMerge());
        System.out.println("Number of potentially merged records (" + this.vcMergerWriter.getVcMergeRule() + "): " + this.vcMergerWriter.getNumRecordsSatisfyingMergeRule());
        System.out.println("Number of records merged (" + this.vcMergerWriter.getAlleleMergeRule() + "): " + this.vcMergerWriter.getNumMergedRecords());
        System.out.println(this.vcMergerWriter.getAltAlleleStats());
    }
}

